# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GeneratedKeyKeyShapeArgs',
    'KeyKeyShapeArgs',
    'KeyReplicaDetailArgs',
    'KeyRestoreFromFileArgs',
    'KeyRestoreFromObjectStoreArgs',
    'KeyVersionReplicaDetailArgs',
    'VaultReplicaDetailArgs',
    'VaultRestoreFromFileArgs',
    'VaultRestoreFromObjectStoreArgs',
    'GetKeyVersionsFilterArgs',
    'GetKeysFilterArgs',
    'GetVaultReplicasFilterArgs',
    'GetVaultsFilterArgs',
]

@pulumi.input_type
class GeneratedKeyKeyShapeArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[str],
                 length: pulumi.Input[int],
                 curve_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] algorithm: The algorithm used by a key's key versions to encrypt or decrypt.
        :param pulumi.Input[int] length: The length of the key in bytes, expressed as an integer. Supported values include the following:
               * AES: 16, 24, or 32
               * RSA: 256, 384, or 512
               * ECDSA: 32, 48, or 66
        :param pulumi.Input[str] curve_id: Supported curve IDs for ECDSA keys.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "length", length)
        if curve_id is not None:
            pulumi.set(__self__, "curve_id", curve_id)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[str]:
        """
        The algorithm used by a key's key versions to encrypt or decrypt.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[str]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter
    def length(self) -> pulumi.Input[int]:
        """
        The length of the key in bytes, expressed as an integer. Supported values include the following:
        * AES: 16, 24, or 32
        * RSA: 256, 384, or 512
        * ECDSA: 32, 48, or 66
        """
        return pulumi.get(self, "length")

    @length.setter
    def length(self, value: pulumi.Input[int]):
        pulumi.set(self, "length", value)

    @property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> Optional[pulumi.Input[str]]:
        """
        Supported curve IDs for ECDSA keys.
        """
        return pulumi.get(self, "curve_id")

    @curve_id.setter
    def curve_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "curve_id", value)


@pulumi.input_type
class KeyKeyShapeArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[str],
                 length: pulumi.Input[int],
                 curve_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] algorithm: The algorithm used by a key's key versions to encrypt or decrypt.
        :param pulumi.Input[int] length: The length of the key in bytes, expressed as an integer. Supported values include the following:
               * AES: 16, 24, or 32
               * RSA: 256, 384, or 512
               * ECDSA: 32, 48, or 66
        :param pulumi.Input[str] curve_id: Supported curve IDs for ECDSA keys.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "length", length)
        if curve_id is not None:
            pulumi.set(__self__, "curve_id", curve_id)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[str]:
        """
        The algorithm used by a key's key versions to encrypt or decrypt.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[str]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter
    def length(self) -> pulumi.Input[int]:
        """
        The length of the key in bytes, expressed as an integer. Supported values include the following:
        * AES: 16, 24, or 32
        * RSA: 256, 384, or 512
        * ECDSA: 32, 48, or 66
        """
        return pulumi.get(self, "length")

    @length.setter
    def length(self, value: pulumi.Input[int]):
        pulumi.set(self, "length", value)

    @property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> Optional[pulumi.Input[str]]:
        """
        Supported curve IDs for ECDSA keys.
        """
        return pulumi.get(self, "curve_id")

    @curve_id.setter
    def curve_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "curve_id", value)


@pulumi.input_type
class KeyReplicaDetailArgs:
    def __init__(__self__, *,
                 replication_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] replication_id: ReplicationId associated with a key operation
        """
        if replication_id is not None:
            pulumi.set(__self__, "replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[pulumi.Input[str]]:
        """
        ReplicationId associated with a key operation
        """
        return pulumi.get(self, "replication_id")

    @replication_id.setter
    def replication_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_id", value)


@pulumi.input_type
class KeyRestoreFromFileArgs:
    def __init__(__self__, *,
                 content_length: pulumi.Input[str],
                 restore_key_from_file_details: pulumi.Input[str],
                 content_md5: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] content_length: (Updatable) content length of key's backup binary file
        :param pulumi.Input[str] restore_key_from_file_details: Key backup file content.
        :param pulumi.Input[str] content_md5: (Updatable) content md5 hashed value of key's backup file
        """
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "restore_key_from_file_details", restore_key_from_file_details)
        if content_md5 is not None:
            pulumi.set(__self__, "content_md5", content_md5)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> pulumi.Input[str]:
        """
        (Updatable) content length of key's backup binary file
        """
        return pulumi.get(self, "content_length")

    @content_length.setter
    def content_length(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_length", value)

    @property
    @pulumi.getter(name="restoreKeyFromFileDetails")
    def restore_key_from_file_details(self) -> pulumi.Input[str]:
        """
        Key backup file content.
        """
        return pulumi.get(self, "restore_key_from_file_details")

    @restore_key_from_file_details.setter
    def restore_key_from_file_details(self, value: pulumi.Input[str]):
        pulumi.set(self, "restore_key_from_file_details", value)

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) content md5 hashed value of key's backup file
        """
        return pulumi.get(self, "content_md5")

    @content_md5.setter
    def content_md5(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_md5", value)


@pulumi.input_type
class KeyRestoreFromObjectStoreArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input[str],
                 bucket: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] destination: (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param pulumi.Input[str] bucket: (Updatable) Name of the bucket where key was backed up
        :param pulumi.Input[str] namespace: (Updatable) Namespace of the bucket where key was backed up
        :param pulumi.Input[str] object: (Updatable) Object containing the backup
        :param pulumi.Input[str] uri: (Updatable) Pre-authenticated-request-uri of the backup
        """
        pulumi.set(__self__, "destination", destination)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the bucket where key was backed up
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Namespace of the bucket where key was backed up
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Object containing the backup
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Pre-authenticated-request-uri of the backup
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class KeyVersionReplicaDetailArgs:
    def __init__(__self__, *,
                 replication_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] replication_id: ReplicationId associated with a key version operation
        """
        if replication_id is not None:
            pulumi.set(__self__, "replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[pulumi.Input[str]]:
        """
        ReplicationId associated with a key version operation
        """
        return pulumi.get(self, "replication_id")

    @replication_id.setter
    def replication_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_id", value)


@pulumi.input_type
class VaultReplicaDetailArgs:
    def __init__(__self__, *,
                 replication_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] replication_id: ReplicationId associated with a vault operation
        """
        if replication_id is not None:
            pulumi.set(__self__, "replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[pulumi.Input[str]]:
        """
        ReplicationId associated with a vault operation
        """
        return pulumi.get(self, "replication_id")

    @replication_id.setter
    def replication_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_id", value)


@pulumi.input_type
class VaultRestoreFromFileArgs:
    def __init__(__self__, *,
                 content_length: pulumi.Input[str],
                 restore_vault_from_file_details: pulumi.Input[str],
                 content_md5: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] content_length: content length of vault's backup binary file
        :param pulumi.Input[str] restore_vault_from_file_details: Vault backup file content
        :param pulumi.Input[str] content_md5: (Updatable) content md5 hashed value of vault's backup file
        """
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "restore_vault_from_file_details", restore_vault_from_file_details)
        if content_md5 is not None:
            pulumi.set(__self__, "content_md5", content_md5)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> pulumi.Input[str]:
        """
        content length of vault's backup binary file
        """
        return pulumi.get(self, "content_length")

    @content_length.setter
    def content_length(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_length", value)

    @property
    @pulumi.getter(name="restoreVaultFromFileDetails")
    def restore_vault_from_file_details(self) -> pulumi.Input[str]:
        """
        Vault backup file content
        """
        return pulumi.get(self, "restore_vault_from_file_details")

    @restore_vault_from_file_details.setter
    def restore_vault_from_file_details(self, value: pulumi.Input[str]):
        pulumi.set(self, "restore_vault_from_file_details", value)

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) content md5 hashed value of vault's backup file
        """
        return pulumi.get(self, "content_md5")

    @content_md5.setter
    def content_md5(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_md5", value)


@pulumi.input_type
class VaultRestoreFromObjectStoreArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input[str],
                 bucket: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] destination: (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param pulumi.Input[str] bucket: (Updatable) Name of the bucket where vault was backed up
        :param pulumi.Input[str] namespace: (Updatable) Namespace of the bucket where vault was backed up
        :param pulumi.Input[str] object: (Updatable) Object containing the backup
        :param pulumi.Input[str] uri: (Updatable) Pre-authenticated-request-uri of the backup* `restore_trigger` - (Optional) (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        """
        pulumi.set(__self__, "destination", destination)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the bucket where vault was backed up
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Namespace of the bucket where vault was backed up
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Object containing the backup
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Pre-authenticated-request-uri of the backup* `restore_trigger` - (Optional) (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class GetKeyVersionsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetKeysFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetVaultReplicasFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetVaultsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


