# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GeneratedKeyKeyShape',
    'KeyKeyShape',
    'KeyReplicaDetail',
    'KeyRestoreFromFile',
    'KeyRestoreFromObjectStore',
    'KeyVersionReplicaDetail',
    'VaultReplicaDetail',
    'VaultRestoreFromFile',
    'VaultRestoreFromObjectStore',
    'GetKeyKeyShapeResult',
    'GetKeyReplicaDetailResult',
    'GetKeyRestoreFromFileResult',
    'GetKeyRestoreFromObjectStoreResult',
    'GetKeyVersionReplicaDetailResult',
    'GetKeyVersionsFilterResult',
    'GetKeyVersionsKeyVersionResult',
    'GetKeyVersionsKeyVersionReplicaDetailResult',
    'GetKeysFilterResult',
    'GetKeysKeyResult',
    'GetKeysKeyKeyShapeResult',
    'GetKeysKeyReplicaDetailResult',
    'GetKeysKeyRestoreFromFileResult',
    'GetKeysKeyRestoreFromObjectStoreResult',
    'GetReplicationStatusReplicaDetailResult',
    'GetVaultReplicaDetailResult',
    'GetVaultReplicasFilterResult',
    'GetVaultReplicasVaultReplicaResult',
    'GetVaultRestoreFromFileResult',
    'GetVaultRestoreFromObjectStoreResult',
    'GetVaultsFilterResult',
    'GetVaultsVaultResult',
    'GetVaultsVaultReplicaDetailResult',
    'GetVaultsVaultRestoreFromFileResult',
    'GetVaultsVaultRestoreFromObjectStoreResult',
]

@pulumi.output_type
class GeneratedKeyKeyShape(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "curveId":
            suggest = "curve_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GeneratedKeyKeyShape. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GeneratedKeyKeyShape.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GeneratedKeyKeyShape.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: str,
                 length: int,
                 curve_id: Optional[str] = None):
        """
        :param str algorithm: The algorithm used by a key's key versions to encrypt or decrypt.
        :param int length: The length of the key in bytes, expressed as an integer. Supported values include the following:
               * AES: 16, 24, or 32
               * RSA: 256, 384, or 512
               * ECDSA: 32, 48, or 66
        :param str curve_id: Supported curve IDs for ECDSA keys.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "length", length)
        if curve_id is not None:
            pulumi.set(__self__, "curve_id", curve_id)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        The algorithm used by a key's key versions to encrypt or decrypt.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def length(self) -> int:
        """
        The length of the key in bytes, expressed as an integer. Supported values include the following:
        * AES: 16, 24, or 32
        * RSA: 256, 384, or 512
        * ECDSA: 32, 48, or 66
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> Optional[str]:
        """
        Supported curve IDs for ECDSA keys.
        """
        return pulumi.get(self, "curve_id")


@pulumi.output_type
class KeyKeyShape(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "curveId":
            suggest = "curve_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyKeyShape. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyKeyShape.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyKeyShape.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: str,
                 length: int,
                 curve_id: Optional[str] = None):
        """
        :param str algorithm: The algorithm used by a key's key versions to encrypt or decrypt.
        :param int length: The length of the key in bytes, expressed as an integer. Supported values include the following:
               * AES: 16, 24, or 32
               * RSA: 256, 384, or 512
               * ECDSA: 32, 48, or 66
        :param str curve_id: Supported curve IDs for ECDSA keys.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "length", length)
        if curve_id is not None:
            pulumi.set(__self__, "curve_id", curve_id)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        The algorithm used by a key's key versions to encrypt or decrypt.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def length(self) -> int:
        """
        The length of the key in bytes, expressed as an integer. Supported values include the following:
        * AES: 16, 24, or 32
        * RSA: 256, 384, or 512
        * ECDSA: 32, 48, or 66
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> Optional[str]:
        """
        Supported curve IDs for ECDSA keys.
        """
        return pulumi.get(self, "curve_id")


@pulumi.output_type
class KeyReplicaDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationId":
            suggest = "replication_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyReplicaDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyReplicaDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyReplicaDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_id: Optional[str] = None):
        """
        :param str replication_id: ReplicationId associated with a key operation
        """
        if replication_id is not None:
            pulumi.set(__self__, "replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[str]:
        """
        ReplicationId associated with a key operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class KeyRestoreFromFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentLength":
            suggest = "content_length"
        elif key == "restoreKeyFromFileDetails":
            suggest = "restore_key_from_file_details"
        elif key == "contentMd5":
            suggest = "content_md5"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyRestoreFromFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyRestoreFromFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyRestoreFromFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_length: str,
                 restore_key_from_file_details: str,
                 content_md5: Optional[str] = None):
        """
        :param str content_length: (Updatable) content length of key's backup binary file
        :param str restore_key_from_file_details: Key backup file content.
        :param str content_md5: (Updatable) content md5 hashed value of key's backup file
        """
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "restore_key_from_file_details", restore_key_from_file_details)
        if content_md5 is not None:
            pulumi.set(__self__, "content_md5", content_md5)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> str:
        """
        (Updatable) content length of key's backup binary file
        """
        return pulumi.get(self, "content_length")

    @property
    @pulumi.getter(name="restoreKeyFromFileDetails")
    def restore_key_from_file_details(self) -> str:
        """
        Key backup file content.
        """
        return pulumi.get(self, "restore_key_from_file_details")

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[str]:
        """
        (Updatable) content md5 hashed value of key's backup file
        """
        return pulumi.get(self, "content_md5")


@pulumi.output_type
class KeyRestoreFromObjectStore(dict):
    def __init__(__self__, *,
                 destination: str,
                 bucket: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str destination: (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param str bucket: (Updatable) Name of the bucket where key was backed up
        :param str namespace: (Updatable) Namespace of the bucket where key was backed up
        :param str object: (Updatable) Object containing the backup
        :param str uri: (Updatable) Pre-authenticated-request-uri of the backup
        """
        pulumi.set(__self__, "destination", destination)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        (Updatable) Name of the bucket where key was backed up
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        (Updatable) Namespace of the bucket where key was backed up
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        (Updatable) Object containing the backup
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        (Updatable) Pre-authenticated-request-uri of the backup
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class KeyVersionReplicaDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationId":
            suggest = "replication_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVersionReplicaDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVersionReplicaDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVersionReplicaDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_id: Optional[str] = None):
        """
        :param str replication_id: ReplicationId associated with a key version operation
        """
        if replication_id is not None:
            pulumi.set(__self__, "replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[str]:
        """
        ReplicationId associated with a key version operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class VaultReplicaDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationId":
            suggest = "replication_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultReplicaDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultReplicaDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultReplicaDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_id: Optional[str] = None):
        """
        :param str replication_id: ReplicationId associated with a vault operation
        """
        if replication_id is not None:
            pulumi.set(__self__, "replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[str]:
        """
        ReplicationId associated with a vault operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class VaultRestoreFromFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentLength":
            suggest = "content_length"
        elif key == "restoreVaultFromFileDetails":
            suggest = "restore_vault_from_file_details"
        elif key == "contentMd5":
            suggest = "content_md5"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultRestoreFromFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultRestoreFromFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultRestoreFromFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_length: str,
                 restore_vault_from_file_details: str,
                 content_md5: Optional[str] = None):
        """
        :param str content_length: content length of vault's backup binary file
        :param str restore_vault_from_file_details: Vault backup file content
        :param str content_md5: (Updatable) content md5 hashed value of vault's backup file
        """
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "restore_vault_from_file_details", restore_vault_from_file_details)
        if content_md5 is not None:
            pulumi.set(__self__, "content_md5", content_md5)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> str:
        """
        content length of vault's backup binary file
        """
        return pulumi.get(self, "content_length")

    @property
    @pulumi.getter(name="restoreVaultFromFileDetails")
    def restore_vault_from_file_details(self) -> str:
        """
        Vault backup file content
        """
        return pulumi.get(self, "restore_vault_from_file_details")

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[str]:
        """
        (Updatable) content md5 hashed value of vault's backup file
        """
        return pulumi.get(self, "content_md5")


@pulumi.output_type
class VaultRestoreFromObjectStore(dict):
    def __init__(__self__, *,
                 destination: str,
                 bucket: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str destination: (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param str bucket: (Updatable) Name of the bucket where vault was backed up
        :param str namespace: (Updatable) Namespace of the bucket where vault was backed up
        :param str object: (Updatable) Object containing the backup
        :param str uri: (Updatable) Pre-authenticated-request-uri of the backup* `restore_trigger` - (Optional) (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        """
        pulumi.set(__self__, "destination", destination)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        (Updatable) Name of the bucket where vault was backed up
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        (Updatable) Namespace of the bucket where vault was backed up
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        (Updatable) Object containing the backup
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        (Updatable) Pre-authenticated-request-uri of the backup* `restore_trigger` - (Optional) (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetKeyKeyShapeResult(dict):
    def __init__(__self__, *,
                 algorithm: str,
                 curve_id: str,
                 length: int):
        """
        :param str algorithm: The algorithm used by a key's key versions to encrypt or decrypt.
        :param str curve_id: Supported curve IDs for ECDSA keys.
        :param int length: The length of the key in bytes, expressed as an integer. Supported values include the following:
               * AES: 16, 24, or 32
               * RSA: 256, 384, or 512
               * ECDSA: 32, 48, or 66
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "curve_id", curve_id)
        pulumi.set(__self__, "length", length)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        The algorithm used by a key's key versions to encrypt or decrypt.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> str:
        """
        Supported curve IDs for ECDSA keys.
        """
        return pulumi.get(self, "curve_id")

    @property
    @pulumi.getter
    def length(self) -> int:
        """
        The length of the key in bytes, expressed as an integer. Supported values include the following:
        * AES: 16, 24, or 32
        * RSA: 256, 384, or 512
        * ECDSA: 32, 48, or 66
        """
        return pulumi.get(self, "length")


@pulumi.output_type
class GetKeyReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: str):
        """
        :param str replication_id: ReplicationId associated with a key operation
        """
        pulumi.set(__self__, "replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> str:
        """
        ReplicationId associated with a key operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetKeyRestoreFromFileResult(dict):
    def __init__(__self__, *,
                 content_length: str,
                 content_md5: str,
                 restore_key_from_file_details: str):
        """
        :param str content_length: content length of key's backup binary file
        :param str content_md5: content md5 hashed value of key's backup file
        :param str restore_key_from_file_details: Key backup file content
        """
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "content_md5", content_md5)
        pulumi.set(__self__, "restore_key_from_file_details", restore_key_from_file_details)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> str:
        """
        content length of key's backup binary file
        """
        return pulumi.get(self, "content_length")

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> str:
        """
        content md5 hashed value of key's backup file
        """
        return pulumi.get(self, "content_md5")

    @property
    @pulumi.getter(name="restoreKeyFromFileDetails")
    def restore_key_from_file_details(self) -> str:
        """
        Key backup file content
        """
        return pulumi.get(self, "restore_key_from_file_details")


@pulumi.output_type
class GetKeyRestoreFromObjectStoreResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 destination: str,
                 namespace: str,
                 object: str,
                 uri: str):
        """
        :param str bucket: Name of the bucket where key was backed up
        :param str destination: Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param str namespace: Namespace of the bucket where key was backed up
        :param str object: Object containing the backup
        :param str uri: Pre-authenticated-request-uri of the backup
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the bucket where key was backed up
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace of the bucket where key was backed up
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Object containing the backup
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Pre-authenticated-request-uri of the backup
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetKeyVersionReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: str):
        """
        :param str replication_id: ReplicationId associated with a key version operation
        """
        pulumi.set(__self__, "replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> str:
        """
        ReplicationId associated with a key version operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetKeyVersionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetKeyVersionsKeyVersionResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 id: str,
                 is_primary: bool,
                 key_id: str,
                 key_version_id: str,
                 management_endpoint: str,
                 public_key: str,
                 replica_details: Sequence['outputs.GetKeyVersionsKeyVersionReplicaDetailResult'],
                 restored_from_key_id: str,
                 restored_from_key_version_id: str,
                 state: str,
                 time_created: str,
                 time_of_deletion: str,
                 vault_id: str):
        """
        :param str compartment_id: The OCID of the compartment that contains this key version.
        :param str id: The OCID of the key version.
        :param bool is_primary: A boolean that will be true when key version is primary, and will be false when key version is a replica from a primary key version.
        :param str key_id: The OCID of the key.
        :param str key_version_id: The OCID of the key version.
        :param str management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        :param str public_key: The public key in PEM format. (This value pertains only to RSA and ECDSA keys.)
        :param Sequence['GetKeyVersionsKeyVersionReplicaDetailArgs'] replica_details: KeyVersion replica details
        :param str restored_from_key_version_id: The OCID of the key version from which this key version was restored.
        :param str state: The key version's current lifecycle state.  Example: `ENABLED`
        :param str time_created: The date and time this key version was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: "2018-04-03T21:10:29.600Z"
        :param str time_of_deletion: An optional property to indicate when to delete the key version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param str vault_id: The OCID of the vault that contains this key version.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_version_id", key_version_id)
        pulumi.set(__self__, "management_endpoint", management_endpoint)
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "replica_details", replica_details)
        pulumi.set(__self__, "restored_from_key_id", restored_from_key_id)
        pulumi.set(__self__, "restored_from_key_version_id", restored_from_key_version_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains this key version.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the key version.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> bool:
        """
        A boolean that will be true when key version is primary, and will be false when key version is a replica from a primary key version.
        """
        return pulumi.get(self, "is_primary")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        The OCID of the key.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyVersionId")
    def key_version_id(self) -> str:
        """
        The OCID of the key version.
        """
        return pulumi.get(self, "key_version_id")

    @property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> str:
        """
        The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        """
        return pulumi.get(self, "management_endpoint")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        The public key in PEM format. (This value pertains only to RSA and ECDSA keys.)
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> Sequence['outputs.GetKeyVersionsKeyVersionReplicaDetailResult']:
        """
        KeyVersion replica details
        """
        return pulumi.get(self, "replica_details")

    @property
    @pulumi.getter(name="restoredFromKeyId")
    def restored_from_key_id(self) -> str:
        return pulumi.get(self, "restored_from_key_id")

    @property
    @pulumi.getter(name="restoredFromKeyVersionId")
    def restored_from_key_version_id(self) -> str:
        """
        The OCID of the key version from which this key version was restored.
        """
        return pulumi.get(self, "restored_from_key_version_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The key version's current lifecycle state.  Example: `ENABLED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time this key version was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: "2018-04-03T21:10:29.600Z"
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        An optional property to indicate when to delete the key version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The OCID of the vault that contains this key version.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetKeyVersionsKeyVersionReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: str):
        """
        :param str replication_id: ReplicationId associated with a key version operation
        """
        pulumi.set(__self__, "replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> str:
        """
        ReplicationId associated with a key version operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetKeysFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetKeysKeyResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 current_key_version: str,
                 defined_tags: Mapping[str, Any],
                 desired_state: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_primary: bool,
                 key_shapes: Sequence['outputs.GetKeysKeyKeyShapeResult'],
                 management_endpoint: str,
                 protection_mode: str,
                 replica_details: Sequence['outputs.GetKeysKeyReplicaDetailResult'],
                 restore_from_files: Sequence['outputs.GetKeysKeyRestoreFromFileResult'],
                 restore_from_object_stores: Sequence['outputs.GetKeysKeyRestoreFromObjectStoreResult'],
                 restore_trigger: bool,
                 restored_from_key_id: str,
                 state: str,
                 time_created: str,
                 time_of_deletion: str,
                 vault_id: str):
        """
        :param str compartment_id: The OCID of the compartment.
        :param str current_key_version: The OCID of the key version used in cryptographic operations. During key rotation, the service might be in a transitional state where this or a newer key version are used intermittently. The `currentKeyVersion` property is updated when the service is guaranteed to use the new key version for all subsequent encryption operations.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A user-friendly name for the key. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the key.
        :param bool is_primary: A boolean that will be true when key is primary, and will be false when key is a replica from a primary key.
        :param Sequence['GetKeysKeyKeyShapeArgs'] key_shapes: The cryptographic properties of a key.
        :param str management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        :param str protection_mode: A key's protection mode indicates how the key persists and where cryptographic operations that use the key are performed. A  protection mode of `HSM` means that the key persists on a hardware security module (HSM) and all cryptographic operations are  performed inside the HSM. A protection mode of `SOFTWARE` means that the key persists on the server, protected by the vault's  RSA wrapping key which persists on the HSM. All cryptographic operations that use a key with a protection mode of  `SOFTWARE` are performed on the server.
        :param Sequence['GetKeysKeyReplicaDetailArgs'] replica_details: Key replica details
        :param str state: The key's current lifecycle state.  Example: `ENABLED`
        :param str time_created: The date and time the key was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        :param str time_of_deletion: An optional property indicating when to delete the key, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param str vault_id: The OCID of the vault that contains this key.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "current_key_version", current_key_version)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "desired_state", desired_state)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "key_shapes", key_shapes)
        pulumi.set(__self__, "management_endpoint", management_endpoint)
        pulumi.set(__self__, "protection_mode", protection_mode)
        pulumi.set(__self__, "replica_details", replica_details)
        pulumi.set(__self__, "restore_from_files", restore_from_files)
        pulumi.set(__self__, "restore_from_object_stores", restore_from_object_stores)
        pulumi.set(__self__, "restore_trigger", restore_trigger)
        pulumi.set(__self__, "restored_from_key_id", restored_from_key_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="currentKeyVersion")
    def current_key_version(self) -> str:
        """
        The OCID of the key version used in cryptographic operations. During key rotation, the service might be in a transitional state where this or a newer key version are used intermittently. The `currentKeyVersion` property is updated when the service is guaranteed to use the new key version for all subsequent encryption operations.
        """
        return pulumi.get(self, "current_key_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> str:
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name for the key. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> bool:
        """
        A boolean that will be true when key is primary, and will be false when key is a replica from a primary key.
        """
        return pulumi.get(self, "is_primary")

    @property
    @pulumi.getter(name="keyShapes")
    def key_shapes(self) -> Sequence['outputs.GetKeysKeyKeyShapeResult']:
        """
        The cryptographic properties of a key.
        """
        return pulumi.get(self, "key_shapes")

    @property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> str:
        """
        The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        """
        return pulumi.get(self, "management_endpoint")

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> str:
        """
        A key's protection mode indicates how the key persists and where cryptographic operations that use the key are performed. A  protection mode of `HSM` means that the key persists on a hardware security module (HSM) and all cryptographic operations are  performed inside the HSM. A protection mode of `SOFTWARE` means that the key persists on the server, protected by the vault's  RSA wrapping key which persists on the HSM. All cryptographic operations that use a key with a protection mode of  `SOFTWARE` are performed on the server.
        """
        return pulumi.get(self, "protection_mode")

    @property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> Sequence['outputs.GetKeysKeyReplicaDetailResult']:
        """
        Key replica details
        """
        return pulumi.get(self, "replica_details")

    @property
    @pulumi.getter(name="restoreFromFiles")
    def restore_from_files(self) -> Sequence['outputs.GetKeysKeyRestoreFromFileResult']:
        return pulumi.get(self, "restore_from_files")

    @property
    @pulumi.getter(name="restoreFromObjectStores")
    def restore_from_object_stores(self) -> Sequence['outputs.GetKeysKeyRestoreFromObjectStoreResult']:
        return pulumi.get(self, "restore_from_object_stores")

    @property
    @pulumi.getter(name="restoreTrigger")
    def restore_trigger(self) -> bool:
        return pulumi.get(self, "restore_trigger")

    @property
    @pulumi.getter(name="restoredFromKeyId")
    def restored_from_key_id(self) -> str:
        return pulumi.get(self, "restored_from_key_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The key's current lifecycle state.  Example: `ENABLED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the key was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        An optional property indicating when to delete the key, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The OCID of the vault that contains this key.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetKeysKeyKeyShapeResult(dict):
    def __init__(__self__, *,
                 algorithm: str,
                 curve_id: str,
                 length: int):
        """
        :param str algorithm: The algorithm used by a key's key versions to encrypt or decrypt data. Currently, support includes AES, RSA, and ECDSA algorithms.
        :param str curve_id: The curve ID of the keys. (This pertains only to ECDSA keys.)
        :param int length: The length of the key in bytes, expressed as an integer. Supported values include 16, 24, or 32.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "curve_id", curve_id)
        pulumi.set(__self__, "length", length)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        The algorithm used by a key's key versions to encrypt or decrypt data. Currently, support includes AES, RSA, and ECDSA algorithms.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> str:
        """
        The curve ID of the keys. (This pertains only to ECDSA keys.)
        """
        return pulumi.get(self, "curve_id")

    @property
    @pulumi.getter
    def length(self) -> int:
        """
        The length of the key in bytes, expressed as an integer. Supported values include 16, 24, or 32.
        """
        return pulumi.get(self, "length")


@pulumi.output_type
class GetKeysKeyReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: str):
        """
        :param str replication_id: ReplicationId associated with a key operation
        """
        pulumi.set(__self__, "replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> str:
        """
        ReplicationId associated with a key operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetKeysKeyRestoreFromFileResult(dict):
    def __init__(__self__, *,
                 content_length: str,
                 content_md5: str,
                 restore_key_from_file_details: str):
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "content_md5", content_md5)
        pulumi.set(__self__, "restore_key_from_file_details", restore_key_from_file_details)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> str:
        return pulumi.get(self, "content_length")

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> str:
        return pulumi.get(self, "content_md5")

    @property
    @pulumi.getter(name="restoreKeyFromFileDetails")
    def restore_key_from_file_details(self) -> str:
        return pulumi.get(self, "restore_key_from_file_details")


@pulumi.output_type
class GetKeysKeyRestoreFromObjectStoreResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 destination: str,
                 namespace: str,
                 object: str,
                 uri: str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def destination(self) -> str:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def uri(self) -> str:
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetReplicationStatusReplicaDetailResult(dict):
    def __init__(__self__, *,
                 region: str,
                 status: str):
        """
        :param str region: The replica region
        :param str status: Replication status associated with a replicationId
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The replica region
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Replication status associated with a replicationId
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetVaultReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: str):
        """
        :param str replication_id: ReplicationId associated with a vault operation
        """
        pulumi.set(__self__, "replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> str:
        """
        ReplicationId associated with a vault operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetVaultReplicasFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVaultReplicasVaultReplicaResult(dict):
    def __init__(__self__, *,
                 crypto_endpoint: str,
                 management_endpoint: str,
                 region: str,
                 status: str):
        """
        :param str crypto_endpoint: The vault replica's crypto endpoint
        :param str management_endpoint: The vault replica's management endpoint
        :param str region: Region to which vault is replicated to
        :param str status: The vault replica's status
        """
        pulumi.set(__self__, "crypto_endpoint", crypto_endpoint)
        pulumi.set(__self__, "management_endpoint", management_endpoint)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> str:
        """
        The vault replica's crypto endpoint
        """
        return pulumi.get(self, "crypto_endpoint")

    @property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> str:
        """
        The vault replica's management endpoint
        """
        return pulumi.get(self, "management_endpoint")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region to which vault is replicated to
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The vault replica's status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetVaultRestoreFromFileResult(dict):
    def __init__(__self__, *,
                 content_length: str,
                 content_md5: str,
                 restore_vault_from_file_details: str):
        """
        :param str content_length: content length of vault's backup binary file
        :param str content_md5: content md5 hashed value of vault's backup file
        :param str restore_vault_from_file_details: Vault backup file content
        """
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "content_md5", content_md5)
        pulumi.set(__self__, "restore_vault_from_file_details", restore_vault_from_file_details)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> str:
        """
        content length of vault's backup binary file
        """
        return pulumi.get(self, "content_length")

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> str:
        """
        content md5 hashed value of vault's backup file
        """
        return pulumi.get(self, "content_md5")

    @property
    @pulumi.getter(name="restoreVaultFromFileDetails")
    def restore_vault_from_file_details(self) -> str:
        """
        Vault backup file content
        """
        return pulumi.get(self, "restore_vault_from_file_details")


@pulumi.output_type
class GetVaultRestoreFromObjectStoreResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 destination: str,
                 namespace: str,
                 object: str,
                 uri: str):
        """
        :param str bucket: Name of the bucket where vault was backed up
        :param str destination: Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param str namespace: Namespace of the bucket where vault was backed up
        :param str object: Object containing the backup
        :param str uri: Pre-authenticated-request-uri of the backup
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the bucket where vault was backed up
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace of the bucket where vault was backed up
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Object containing the backup
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Pre-authenticated-request-uri of the backup
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetVaultsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVaultsVaultResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 crypto_endpoint: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_primary: bool,
                 management_endpoint: str,
                 replica_details: Sequence['outputs.GetVaultsVaultReplicaDetailResult'],
                 restore_from_files: Sequence['outputs.GetVaultsVaultRestoreFromFileResult'],
                 restore_from_object_stores: Sequence['outputs.GetVaultsVaultRestoreFromObjectStoreResult'],
                 restore_trigger: bool,
                 restored_from_vault_id: str,
                 state: str,
                 time_created: str,
                 time_of_deletion: str,
                 vault_type: str):
        """
        :param str compartment_id: The OCID of the compartment.
        :param str crypto_endpoint: The service endpoint to perform cryptographic operations against. Cryptographic operations include [Encrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/EncryptedData/Encrypt), [Decrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/DecryptedData/Decrypt), and [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) operations.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A user-friendly name for the vault. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the vault.
        :param bool is_primary: A boolean that will be true when vault is primary, and will be false when vault is a replica from a primary vault.
        :param str management_endpoint: The service endpoint to perform management operations against. Management operations include "Create," "Update," "List," "Get," and "Delete" operations.
        :param Sequence['GetVaultsVaultReplicaDetailArgs'] replica_details: Vault replica details
        :param str restored_from_vault_id: The OCID of the vault from which this vault was restored, if it was restored from a backup file.  If you restore a vault to the same region, the vault retains the same OCID that it had when you  backed up the vault.
        :param str state: The vault's current lifecycle state.  Example: `DELETED`
        :param str time_created: The date and time this vault was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        :param str time_of_deletion: An optional property to indicate when to delete the vault, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param str vault_type: The type of vault. Each type of vault stores the key with different degrees of isolation and has different options and pricing.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "crypto_endpoint", crypto_endpoint)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "management_endpoint", management_endpoint)
        pulumi.set(__self__, "replica_details", replica_details)
        pulumi.set(__self__, "restore_from_files", restore_from_files)
        pulumi.set(__self__, "restore_from_object_stores", restore_from_object_stores)
        pulumi.set(__self__, "restore_trigger", restore_trigger)
        pulumi.set(__self__, "restored_from_vault_id", restored_from_vault_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        pulumi.set(__self__, "vault_type", vault_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> str:
        """
        The service endpoint to perform cryptographic operations against. Cryptographic operations include [Encrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/EncryptedData/Encrypt), [Decrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/DecryptedData/Decrypt), and [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) operations.
        """
        return pulumi.get(self, "crypto_endpoint")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name for the vault. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the vault.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> bool:
        """
        A boolean that will be true when vault is primary, and will be false when vault is a replica from a primary vault.
        """
        return pulumi.get(self, "is_primary")

    @property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> str:
        """
        The service endpoint to perform management operations against. Management operations include "Create," "Update," "List," "Get," and "Delete" operations.
        """
        return pulumi.get(self, "management_endpoint")

    @property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> Sequence['outputs.GetVaultsVaultReplicaDetailResult']:
        """
        Vault replica details
        """
        return pulumi.get(self, "replica_details")

    @property
    @pulumi.getter(name="restoreFromFiles")
    def restore_from_files(self) -> Sequence['outputs.GetVaultsVaultRestoreFromFileResult']:
        return pulumi.get(self, "restore_from_files")

    @property
    @pulumi.getter(name="restoreFromObjectStores")
    def restore_from_object_stores(self) -> Sequence['outputs.GetVaultsVaultRestoreFromObjectStoreResult']:
        return pulumi.get(self, "restore_from_object_stores")

    @property
    @pulumi.getter(name="restoreTrigger")
    def restore_trigger(self) -> bool:
        return pulumi.get(self, "restore_trigger")

    @property
    @pulumi.getter(name="restoredFromVaultId")
    def restored_from_vault_id(self) -> str:
        """
        The OCID of the vault from which this vault was restored, if it was restored from a backup file.  If you restore a vault to the same region, the vault retains the same OCID that it had when you  backed up the vault.
        """
        return pulumi.get(self, "restored_from_vault_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The vault's current lifecycle state.  Example: `DELETED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time this vault was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        An optional property to indicate when to delete the vault, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> str:
        """
        The type of vault. Each type of vault stores the key with different degrees of isolation and has different options and pricing.
        """
        return pulumi.get(self, "vault_type")


@pulumi.output_type
class GetVaultsVaultReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: str):
        """
        :param str replication_id: ReplicationId associated with a vault operation
        """
        pulumi.set(__self__, "replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> str:
        """
        ReplicationId associated with a vault operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetVaultsVaultRestoreFromFileResult(dict):
    def __init__(__self__, *,
                 content_length: str,
                 content_md5: str,
                 restore_vault_from_file_details: str):
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "content_md5", content_md5)
        pulumi.set(__self__, "restore_vault_from_file_details", restore_vault_from_file_details)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> str:
        return pulumi.get(self, "content_length")

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> str:
        return pulumi.get(self, "content_md5")

    @property
    @pulumi.getter(name="restoreVaultFromFileDetails")
    def restore_vault_from_file_details(self) -> str:
        return pulumi.get(self, "restore_vault_from_file_details")


@pulumi.output_type
class GetVaultsVaultRestoreFromObjectStoreResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 destination: str,
                 namespace: str,
                 object: str,
                 uri: str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def destination(self) -> str:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def uri(self) -> str:
        return pulumi.get(self, "uri")


