# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UnifiedAgentConfigurationArgs', 'UnifiedAgentConfiguration']

@pulumi.input_type
class UnifiedAgentConfigurationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 is_enabled: pulumi.Input[bool],
                 service_configuration: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 group_association: Optional[pulumi.Input['UnifiedAgentConfigurationGroupAssociationArgs']] = None):
        """
        The set of arguments for constructing a UnifiedAgentConfiguration resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that the resource belongs to.
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether or not this resource is currently enabled.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationArgs'] service_configuration: (Updatable) Top level Unified Agent service configuration object.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Description for this resource.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['UnifiedAgentConfigurationGroupAssociationArgs'] group_association: (Updatable) Groups using the configuration.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "service_configuration", service_configuration)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if group_association is not None:
            pulumi.set(__self__, "group_association", group_association)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        (Updatable) Whether or not this resource is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="serviceConfiguration")
    def service_configuration(self) -> pulumi.Input['UnifiedAgentConfigurationServiceConfigurationArgs']:
        """
        (Updatable) Top level Unified Agent service configuration object.
        """
        return pulumi.get(self, "service_configuration")

    @service_configuration.setter
    def service_configuration(self, value: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationArgs']):
        pulumi.set(self, "service_configuration", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description for this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="groupAssociation")
    def group_association(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationGroupAssociationArgs']]:
        """
        (Updatable) Groups using the configuration.
        """
        return pulumi.get(self, "group_association")

    @group_association.setter
    def group_association(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationGroupAssociationArgs']]):
        pulumi.set(self, "group_association", value)


@pulumi.input_type
class _UnifiedAgentConfigurationState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 configuration_state: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 group_association: Optional[pulumi.Input['UnifiedAgentConfigurationGroupAssociationArgs']] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 service_configuration: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_last_modified: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering UnifiedAgentConfiguration resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that the resource belongs to.
        :param pulumi.Input[str] configuration_state: State of unified agent service configuration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Description for this resource.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['UnifiedAgentConfigurationGroupAssociationArgs'] group_association: (Updatable) Groups using the configuration.
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether or not this resource is currently enabled.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationArgs'] service_configuration: (Updatable) Top level Unified Agent service configuration object.
        :param pulumi.Input[str] state: The pipeline state.
        :param pulumi.Input[str] time_created: Time the resource was created.
        :param pulumi.Input[str] time_last_modified: Time the resource was last modified.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration_state is not None:
            pulumi.set(__self__, "configuration_state", configuration_state)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if group_association is not None:
            pulumi.set(__self__, "group_association", group_association)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if service_configuration is not None:
            pulumi.set(__self__, "service_configuration", service_configuration)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_modified is not None:
            pulumi.set(__self__, "time_last_modified", time_last_modified)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="configurationState")
    def configuration_state(self) -> Optional[pulumi.Input[str]]:
        """
        State of unified agent service configuration.
        """
        return pulumi.get(self, "configuration_state")

    @configuration_state.setter
    def configuration_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_state", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description for this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="groupAssociation")
    def group_association(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationGroupAssociationArgs']]:
        """
        (Updatable) Groups using the configuration.
        """
        return pulumi.get(self, "group_association")

    @group_association.setter
    def group_association(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationGroupAssociationArgs']]):
        pulumi.set(self, "group_association", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether or not this resource is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="serviceConfiguration")
    def service_configuration(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationArgs']]:
        """
        (Updatable) Top level Unified Agent service configuration object.
        """
        return pulumi.get(self, "service_configuration")

    @service_configuration.setter
    def service_configuration(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationArgs']]):
        pulumi.set(self, "service_configuration", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The pipeline state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> Optional[pulumi.Input[str]]:
        """
        Time the resource was last modified.
        """
        return pulumi.get(self, "time_last_modified")

    @time_last_modified.setter
    def time_last_modified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_modified", value)


class UnifiedAgentConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 group_association: Optional[pulumi.Input[pulumi.InputType['UnifiedAgentConfigurationGroupAssociationArgs']]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 service_configuration: Optional[pulumi.Input[pulumi.InputType['UnifiedAgentConfigurationServiceConfigurationArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Unified Agent Configuration resource in Oracle Cloud Infrastructure Logging service.

        Create unified agent configuration registration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_unified_agent_configuration = oci.logging.UnifiedAgentConfiguration("testUnifiedAgentConfiguration",
            compartment_id=var["compartment_id"],
            is_enabled=var["unified_agent_configuration_is_enabled"],
            description=var["unified_agent_configuration_description"],
            display_name=var["unified_agent_configuration_display_name"],
            service_configuration=oci.logging.UnifiedAgentConfigurationServiceConfigurationArgs(
                configuration_type=var["unified_agent_configuration_service_configuration_configuration_type"],
                destination=oci.logging.UnifiedAgentConfigurationServiceConfigurationDestinationArgs(
                    log_object_id=oci_objectstorage_object["test_object"]["id"],
                ),
                sources=[oci.logging.UnifiedAgentConfigurationServiceConfigurationSourceArgs(
                    source_type=var["unified_agent_configuration_service_configuration_sources_source_type"],
                    channels=var["unified_agent_configuration_service_configuration_sources_channels"],
                    name=var["unified_agent_configuration_service_configuration_sources_name"],
                    parser=oci.logging.UnifiedAgentConfigurationServiceConfigurationSourceParserArgs(
                        parser_type=var["unified_agent_configuration_service_configuration_sources_parser_parser_type"],
                        delimiter=var["unified_agent_configuration_service_configuration_sources_parser_delimiter"],
                        expression=var["unified_agent_configuration_service_configuration_sources_parser_expression"],
                        field_time_key=var["unified_agent_configuration_service_configuration_sources_parser_field_time_key"],
                        formats=var["unified_agent_configuration_service_configuration_sources_parser_format"],
                        format_firstline=var["unified_agent_configuration_service_configuration_sources_parser_format_firstline"],
                        grok_failure_key=var["unified_agent_configuration_service_configuration_sources_parser_grok_failure_key"],
                        grok_name_key=var["unified_agent_configuration_service_configuration_sources_parser_grok_name_key"],
                        is_estimate_current_event=var["unified_agent_configuration_service_configuration_sources_parser_is_estimate_current_event"],
                        is_keep_time_key=var["unified_agent_configuration_service_configuration_sources_parser_is_keep_time_key"],
                        is_merge_cri_fields=var["unified_agent_configuration_service_configuration_sources_parser_is_merge_cri_fields"],
                        is_null_empty_string=var["unified_agent_configuration_service_configuration_sources_parser_is_null_empty_string"],
                        is_support_colonless_ident=var["unified_agent_configuration_service_configuration_sources_parser_is_support_colonless_ident"],
                        is_with_priority=var["unified_agent_configuration_service_configuration_sources_parser_is_with_priority"],
                        keys=var["unified_agent_configuration_service_configuration_sources_parser_keys"],
                        message_format=var["unified_agent_configuration_service_configuration_sources_parser_message_format"],
                        message_key=var["unified_agent_configuration_service_configuration_sources_parser_message_key"],
                        multi_line_start_regexp=var["unified_agent_configuration_service_configuration_sources_parser_multi_line_start_regexp"],
                        nested_parser=oci.logging.UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs(
                            time_format=var["unified_agent_configuration_service_configuration_sources_parser_nested_parser_time_format"],
                            field_time_key=var["unified_agent_configuration_service_configuration_sources_parser_nested_parser_field_time_key"],
                            is_keep_time_key=var["unified_agent_configuration_service_configuration_sources_parser_nested_parser_is_keep_time_key"],
                        ),
                        null_value_pattern=var["unified_agent_configuration_service_configuration_sources_parser_null_value_pattern"],
                        patterns=[oci.logging.UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs(
                            field_time_format=var["unified_agent_configuration_service_configuration_sources_parser_patterns_field_time_format"],
                            field_time_key=var["unified_agent_configuration_service_configuration_sources_parser_patterns_field_time_key"],
                            field_time_zone=var["unified_agent_configuration_service_configuration_sources_parser_patterns_field_time_zone"],
                            name=var["unified_agent_configuration_service_configuration_sources_parser_patterns_name"],
                            pattern=var["unified_agent_configuration_service_configuration_sources_parser_patterns_pattern"],
                        )],
                        rfc5424time_format=var["unified_agent_configuration_service_configuration_sources_parser_rfc5424time_format"],
                        syslog_parser_type=var["unified_agent_configuration_service_configuration_sources_parser_syslog_parser_type"],
                        time_format=var["unified_agent_configuration_service_configuration_sources_parser_time_format"],
                        time_type=var["unified_agent_configuration_service_configuration_sources_parser_time_type"],
                        timeout_in_milliseconds=var["unified_agent_configuration_service_configuration_sources_parser_timeout_in_milliseconds"],
                        types=var["unified_agent_configuration_service_configuration_sources_parser_types"],
                    ),
                    paths=var["unified_agent_configuration_service_configuration_sources_paths"],
                )],
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            group_association=oci.logging.UnifiedAgentConfigurationGroupAssociationArgs(
                group_lists=var["unified_agent_configuration_group_association_group_list"],
            ))
        ```

        ## Import

        UnifiedAgentConfigurations can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Logging/unifiedAgentConfiguration:UnifiedAgentConfiguration test_unified_agent_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that the resource belongs to.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Description for this resource.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[pulumi.InputType['UnifiedAgentConfigurationGroupAssociationArgs']] group_association: (Updatable) Groups using the configuration.
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether or not this resource is currently enabled.
        :param pulumi.Input[pulumi.InputType['UnifiedAgentConfigurationServiceConfigurationArgs']] service_configuration: (Updatable) Top level Unified Agent service configuration object.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UnifiedAgentConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Unified Agent Configuration resource in Oracle Cloud Infrastructure Logging service.

        Create unified agent configuration registration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_unified_agent_configuration = oci.logging.UnifiedAgentConfiguration("testUnifiedAgentConfiguration",
            compartment_id=var["compartment_id"],
            is_enabled=var["unified_agent_configuration_is_enabled"],
            description=var["unified_agent_configuration_description"],
            display_name=var["unified_agent_configuration_display_name"],
            service_configuration=oci.logging.UnifiedAgentConfigurationServiceConfigurationArgs(
                configuration_type=var["unified_agent_configuration_service_configuration_configuration_type"],
                destination=oci.logging.UnifiedAgentConfigurationServiceConfigurationDestinationArgs(
                    log_object_id=oci_objectstorage_object["test_object"]["id"],
                ),
                sources=[oci.logging.UnifiedAgentConfigurationServiceConfigurationSourceArgs(
                    source_type=var["unified_agent_configuration_service_configuration_sources_source_type"],
                    channels=var["unified_agent_configuration_service_configuration_sources_channels"],
                    name=var["unified_agent_configuration_service_configuration_sources_name"],
                    parser=oci.logging.UnifiedAgentConfigurationServiceConfigurationSourceParserArgs(
                        parser_type=var["unified_agent_configuration_service_configuration_sources_parser_parser_type"],
                        delimiter=var["unified_agent_configuration_service_configuration_sources_parser_delimiter"],
                        expression=var["unified_agent_configuration_service_configuration_sources_parser_expression"],
                        field_time_key=var["unified_agent_configuration_service_configuration_sources_parser_field_time_key"],
                        formats=var["unified_agent_configuration_service_configuration_sources_parser_format"],
                        format_firstline=var["unified_agent_configuration_service_configuration_sources_parser_format_firstline"],
                        grok_failure_key=var["unified_agent_configuration_service_configuration_sources_parser_grok_failure_key"],
                        grok_name_key=var["unified_agent_configuration_service_configuration_sources_parser_grok_name_key"],
                        is_estimate_current_event=var["unified_agent_configuration_service_configuration_sources_parser_is_estimate_current_event"],
                        is_keep_time_key=var["unified_agent_configuration_service_configuration_sources_parser_is_keep_time_key"],
                        is_merge_cri_fields=var["unified_agent_configuration_service_configuration_sources_parser_is_merge_cri_fields"],
                        is_null_empty_string=var["unified_agent_configuration_service_configuration_sources_parser_is_null_empty_string"],
                        is_support_colonless_ident=var["unified_agent_configuration_service_configuration_sources_parser_is_support_colonless_ident"],
                        is_with_priority=var["unified_agent_configuration_service_configuration_sources_parser_is_with_priority"],
                        keys=var["unified_agent_configuration_service_configuration_sources_parser_keys"],
                        message_format=var["unified_agent_configuration_service_configuration_sources_parser_message_format"],
                        message_key=var["unified_agent_configuration_service_configuration_sources_parser_message_key"],
                        multi_line_start_regexp=var["unified_agent_configuration_service_configuration_sources_parser_multi_line_start_regexp"],
                        nested_parser=oci.logging.UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs(
                            time_format=var["unified_agent_configuration_service_configuration_sources_parser_nested_parser_time_format"],
                            field_time_key=var["unified_agent_configuration_service_configuration_sources_parser_nested_parser_field_time_key"],
                            is_keep_time_key=var["unified_agent_configuration_service_configuration_sources_parser_nested_parser_is_keep_time_key"],
                        ),
                        null_value_pattern=var["unified_agent_configuration_service_configuration_sources_parser_null_value_pattern"],
                        patterns=[oci.logging.UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs(
                            field_time_format=var["unified_agent_configuration_service_configuration_sources_parser_patterns_field_time_format"],
                            field_time_key=var["unified_agent_configuration_service_configuration_sources_parser_patterns_field_time_key"],
                            field_time_zone=var["unified_agent_configuration_service_configuration_sources_parser_patterns_field_time_zone"],
                            name=var["unified_agent_configuration_service_configuration_sources_parser_patterns_name"],
                            pattern=var["unified_agent_configuration_service_configuration_sources_parser_patterns_pattern"],
                        )],
                        rfc5424time_format=var["unified_agent_configuration_service_configuration_sources_parser_rfc5424time_format"],
                        syslog_parser_type=var["unified_agent_configuration_service_configuration_sources_parser_syslog_parser_type"],
                        time_format=var["unified_agent_configuration_service_configuration_sources_parser_time_format"],
                        time_type=var["unified_agent_configuration_service_configuration_sources_parser_time_type"],
                        timeout_in_milliseconds=var["unified_agent_configuration_service_configuration_sources_parser_timeout_in_milliseconds"],
                        types=var["unified_agent_configuration_service_configuration_sources_parser_types"],
                    ),
                    paths=var["unified_agent_configuration_service_configuration_sources_paths"],
                )],
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            group_association=oci.logging.UnifiedAgentConfigurationGroupAssociationArgs(
                group_lists=var["unified_agent_configuration_group_association_group_list"],
            ))
        ```

        ## Import

        UnifiedAgentConfigurations can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Logging/unifiedAgentConfiguration:UnifiedAgentConfiguration test_unified_agent_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param UnifiedAgentConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UnifiedAgentConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 group_association: Optional[pulumi.Input[pulumi.InputType['UnifiedAgentConfigurationGroupAssociationArgs']]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 service_configuration: Optional[pulumi.Input[pulumi.InputType['UnifiedAgentConfigurationServiceConfigurationArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UnifiedAgentConfigurationArgs.__new__(UnifiedAgentConfigurationArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["group_association"] = group_association
            if is_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'is_enabled'")
            __props__.__dict__["is_enabled"] = is_enabled
            if service_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'service_configuration'")
            __props__.__dict__["service_configuration"] = service_configuration
            __props__.__dict__["configuration_state"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_modified"] = None
        super(UnifiedAgentConfiguration, __self__).__init__(
            'oci:Logging/unifiedAgentConfiguration:UnifiedAgentConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            configuration_state: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            group_association: Optional[pulumi.Input[pulumi.InputType['UnifiedAgentConfigurationGroupAssociationArgs']]] = None,
            is_enabled: Optional[pulumi.Input[bool]] = None,
            service_configuration: Optional[pulumi.Input[pulumi.InputType['UnifiedAgentConfigurationServiceConfigurationArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_last_modified: Optional[pulumi.Input[str]] = None) -> 'UnifiedAgentConfiguration':
        """
        Get an existing UnifiedAgentConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that the resource belongs to.
        :param pulumi.Input[str] configuration_state: State of unified agent service configuration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Description for this resource.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[pulumi.InputType['UnifiedAgentConfigurationGroupAssociationArgs']] group_association: (Updatable) Groups using the configuration.
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether or not this resource is currently enabled.
        :param pulumi.Input[pulumi.InputType['UnifiedAgentConfigurationServiceConfigurationArgs']] service_configuration: (Updatable) Top level Unified Agent service configuration object.
        :param pulumi.Input[str] state: The pipeline state.
        :param pulumi.Input[str] time_created: Time the resource was created.
        :param pulumi.Input[str] time_last_modified: Time the resource was last modified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UnifiedAgentConfigurationState.__new__(_UnifiedAgentConfigurationState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["configuration_state"] = configuration_state
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["group_association"] = group_association
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["service_configuration"] = service_configuration
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_modified"] = time_last_modified
        return UnifiedAgentConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configurationState")
    def configuration_state(self) -> pulumi.Output[str]:
        """
        State of unified agent service configuration.
        """
        return pulumi.get(self, "configuration_state")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Description for this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="groupAssociation")
    def group_association(self) -> pulumi.Output['outputs.UnifiedAgentConfigurationGroupAssociation']:
        """
        (Updatable) Groups using the configuration.
        """
        return pulumi.get(self, "group_association")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Whether or not this resource is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="serviceConfiguration")
    def service_configuration(self) -> pulumi.Output['outputs.UnifiedAgentConfigurationServiceConfiguration']:
        """
        (Updatable) Top level Unified Agent service configuration object.
        """
        return pulumi.get(self, "service_configuration")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The pipeline state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> pulumi.Output[str]:
        """
        Time the resource was last modified.
        """
        return pulumi.get(self, "time_last_modified")

