# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMysqlDbSystemsResult',
    'AwaitableGetMysqlDbSystemsResult',
    'get_mysql_db_systems',
    'get_mysql_db_systems_output',
]

@pulumi.output_type
class GetMysqlDbSystemsResult:
    """
    A collection of values returned by getMysqlDbSystems.
    """
    def __init__(__self__, compartment_id=None, configuration_id=None, db_system_id=None, db_systems=None, display_name=None, filters=None, id=None, is_heat_wave_cluster_attached=None, is_up_to_date=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration_id and not isinstance(configuration_id, str):
            raise TypeError("Expected argument 'configuration_id' to be a str")
        pulumi.set(__self__, "configuration_id", configuration_id)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if db_systems and not isinstance(db_systems, list):
            raise TypeError("Expected argument 'db_systems' to be a list")
        pulumi.set(__self__, "db_systems", db_systems)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_heat_wave_cluster_attached and not isinstance(is_heat_wave_cluster_attached, bool):
            raise TypeError("Expected argument 'is_heat_wave_cluster_attached' to be a bool")
        pulumi.set(__self__, "is_heat_wave_cluster_attached", is_heat_wave_cluster_attached)
        if is_up_to_date and not isinstance(is_up_to_date, bool):
            raise TypeError("Expected argument 'is_up_to_date' to be a bool")
        pulumi.set(__self__, "is_up_to_date", is_up_to_date)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment the DB System belongs in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[str]:
        """
        The OCID of the Configuration to be used for Instances in this DB System.
        """
        return pulumi.get(self, "configuration_id")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[str]:
        """
        The OCID of the DB System from which a backup shall be selected to be restored when creating the new DB System. Use this together with recovery point to perform a point in time recovery operation.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="dbSystems")
    def db_systems(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemResult']:
        """
        The list of db_systems.
        """
        return pulumi.get(self, "db_systems")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The user-friendly name for the DB System. It does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMysqlDbSystemsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isHeatWaveClusterAttached")
    def is_heat_wave_cluster_attached(self) -> Optional[bool]:
        """
        If the DB System has a HeatWave Cluster attached.
        """
        return pulumi.get(self, "is_heat_wave_cluster_attached")

    @property
    @pulumi.getter(name="isUpToDate")
    def is_up_to_date(self) -> Optional[bool]:
        return pulumi.get(self, "is_up_to_date")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the DB System.
        """
        return pulumi.get(self, "state")


class AwaitableGetMysqlDbSystemsResult(GetMysqlDbSystemsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMysqlDbSystemsResult(
            compartment_id=self.compartment_id,
            configuration_id=self.configuration_id,
            db_system_id=self.db_system_id,
            db_systems=self.db_systems,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            is_heat_wave_cluster_attached=self.is_heat_wave_cluster_attached,
            is_up_to_date=self.is_up_to_date,
            state=self.state)


def get_mysql_db_systems(compartment_id: Optional[str] = None,
                         configuration_id: Optional[str] = None,
                         db_system_id: Optional[str] = None,
                         display_name: Optional[str] = None,
                         filters: Optional[Sequence[pulumi.InputType['GetMysqlDbSystemsFilterArgs']]] = None,
                         is_heat_wave_cluster_attached: Optional[bool] = None,
                         is_up_to_date: Optional[bool] = None,
                         state: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMysqlDbSystemsResult:
    """
    This data source provides the list of Mysql Db Systems in Oracle Cloud Infrastructure MySQL Database service.

    Get a list of DB Systems in the specified compartment.
    The default sort order is by timeUpdated, descending.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_mysql_db_systems = oci.Mysql.get_mysql_db_systems(compartment_id=var["compartment_id"],
        configuration_id=var["mysql_configuration_id"],
        db_system_id=oci_mysql_mysql_db_system["test_db_system"]["id"],
        display_name=var["mysql_db_system_display_name"],
        is_heat_wave_cluster_attached=var["mysql_db_system_is_heat_wave_cluster_attached"],
        is_up_to_date=var["mysql_db_system_is_up_to_date"],
        state=var["mysql_db_system_state"])
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str configuration_id: The requested Configuration instance.
    :param str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only the resource matching the given display name exactly.
    :param bool is_heat_wave_cluster_attached: If true, return only DB Systems with a HeatWave cluster attached, if false return only DB Systems with no HeatWave cluster attached. If not present, return all DB Systems.
    :param bool is_up_to_date: Filter instances if they are using the latest revision of the Configuration they are associated with.
    :param str state: DbSystem Lifecycle State
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['configurationId'] = configuration_id
    __args__['dbSystemId'] = db_system_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isHeatWaveClusterAttached'] = is_heat_wave_cluster_attached
    __args__['isUpToDate'] = is_up_to_date
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Mysql/getMysqlDbSystems:getMysqlDbSystems', __args__, opts=opts, typ=GetMysqlDbSystemsResult).value

    return AwaitableGetMysqlDbSystemsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        configuration_id=pulumi.get(__ret__, 'configuration_id'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        db_systems=pulumi.get(__ret__, 'db_systems'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_heat_wave_cluster_attached=pulumi.get(__ret__, 'is_heat_wave_cluster_attached'),
        is_up_to_date=pulumi.get(__ret__, 'is_up_to_date'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_mysql_db_systems)
def get_mysql_db_systems_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                configuration_id: Optional[pulumi.Input[Optional[str]]] = None,
                                db_system_id: Optional[pulumi.Input[Optional[str]]] = None,
                                display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetMysqlDbSystemsFilterArgs']]]]] = None,
                                is_heat_wave_cluster_attached: Optional[pulumi.Input[Optional[bool]]] = None,
                                is_up_to_date: Optional[pulumi.Input[Optional[bool]]] = None,
                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMysqlDbSystemsResult]:
    """
    This data source provides the list of Mysql Db Systems in Oracle Cloud Infrastructure MySQL Database service.

    Get a list of DB Systems in the specified compartment.
    The default sort order is by timeUpdated, descending.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_mysql_db_systems = oci.Mysql.get_mysql_db_systems(compartment_id=var["compartment_id"],
        configuration_id=var["mysql_configuration_id"],
        db_system_id=oci_mysql_mysql_db_system["test_db_system"]["id"],
        display_name=var["mysql_db_system_display_name"],
        is_heat_wave_cluster_attached=var["mysql_db_system_is_heat_wave_cluster_attached"],
        is_up_to_date=var["mysql_db_system_is_up_to_date"],
        state=var["mysql_db_system_state"])
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str configuration_id: The requested Configuration instance.
    :param str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only the resource matching the given display name exactly.
    :param bool is_heat_wave_cluster_attached: If true, return only DB Systems with a HeatWave cluster attached, if false return only DB Systems with no HeatWave cluster attached. If not present, return all DB Systems.
    :param bool is_up_to_date: Filter instances if they are using the latest revision of the Configuration they are associated with.
    :param str state: DbSystem Lifecycle State
    """
    ...
