# The FHIR-Wrapper for Geospatial

This package contains functions useful in the geocoding of FHIR-formatted input data (i.e. FHIR resources and FHIR bundles, which are lists of FHIR-formatted resource dictionaries). The `core.py` file defines the abstract `FhirGeocodeClient` that vendor-specific implementations inherit from, which ensures that implementing vendor classes have access to both `.geocode_resource()` and `.geocode_bundle()`. All other files in this package directory are vendor-specific implementations of geocoding, with one file per vendor. For an overview of the package as well as common use cases, see the _geospatial-tutorial_ in `/tutorials` at the project root. For a more in-depth explanation of specific formatting and parameters, see the docstrings and comments for each function.