"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FullRegionS3CodeCommitBackup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_codebuild_1 = require("aws-cdk-lib/aws-codebuild");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_s3_assets_1 = require("aws-cdk-lib/aws-s3-assets");
const constructs_1 = require("constructs");
const S3_BUCKET_ENV = 'SCRIPTS_BUCKET';
const S3_KEY_ENV = 'SCRIPTS_BUCKET_KEY';
class FullRegionS3CodeCommitBackup extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { backupBucket, schedule, repositoryNames = [], computeType } = props;
        const asset = new aws_s3_assets_1.Asset(this, 'ScriptsDirectory', {
            path: path.join(__dirname, '..', 'scripts'),
        });
        const buildImage = aws_codebuild_1.LinuxBuildImage.STANDARD_5_0;
        this.backupProject = new aws_codebuild_1.Project(this, 'FullRegionBackupProject', {
            environment: {
                buildImage,
                computeType: computeType || buildImage.defaultComputeType,
            },
            environmentVariables: {
                BACKUP_BUCKET: {
                    value: backupBucket.bucketName,
                },
                REPOSITORY_NAMES: {
                    value: repositoryNames.join(' '),
                },
                [S3_BUCKET_ENV]: { value: asset.s3BucketName },
                [S3_KEY_ENV]: { value: asset.s3ObjectKey },
            },
            buildSpec: aws_codebuild_1.BuildSpec.fromObject({
                version: '0.2',
                env: {
                    'git-credential-helper': 'yes',
                },
                phases: {
                    pre_build: {
                        commands: [
                            `echo "Downloading scripts from s3://\${${S3_BUCKET_ENV}}/\${${S3_KEY_ENV}}"`,
                            `aws s3 cp s3://\${${S3_BUCKET_ENV}}/\${${S3_KEY_ENV}} ./`,
                            `unzip ./$(basename \${${S3_KEY_ENV}})`,
                        ],
                    },
                    build: {
                        commands: ['chmod +x backup_codecommit.sh', './backup_codecommit.sh'],
                    },
                },
            }),
        });
        asset.grantRead(this.backupProject);
        backupBucket.grantPut(this.backupProject);
        this.backupProject.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: ['*'],
            actions: ['codecommit:BatchGet*', 'codecommit:Get*', 'codecommit:Describe*', 'codecommit:List*', 'codecommit:GitPull'],
        }));
        new aws_events_1.Rule(this, 'ScheduleRule', {
            schedule,
            targets: [new aws_events_targets_1.CodeBuildProject(this.backupProject)],
        });
    }
    /**
     * Defines an event rule which triggers when a backup fails.
     */
    onBackupFailed(id, options) {
        return this.backupProject.onBuildFailed(id, options);
    }
    /**
     * Defines an event rule which triggers when a backup starts.
     */
    onBackupStarted(id, options) {
        return this.backupProject.onBuildStarted(id, options);
    }
    /**
     * Defines an event rule which triggers when a backup complets successfully.
     */
    onBackupSucceeded(id, options) {
        return this.backupProject.onBuildSucceeded(id, options);
    }
}
exports.FullRegionS3CodeCommitBackup = FullRegionS3CodeCommitBackup;
_a = JSII_RTTI_SYMBOL_1;
FullRegionS3CodeCommitBackup[_a] = { fqn: "@cloudcomponents/cdk-codecommit-backup.FullRegionS3CodeCommitBackup", version: "2.1.0" };
//# sourceMappingURL=data:application/json;base64,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