# coding: utf-8

"""
    Engines API

    Allow clients to fetch Analytics through APIs.  # noqa: E501

    The version of the OpenAPI document: v2:[pa,spar,vault,pub],v1:[fiab,fi,axp,afi,npo,bpm,fpo]
    Contact: analytics.api.support@factset.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from fds.analyticsapi.engines.configuration import Configuration


class FICalculationParameters(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'securities': 'list[FISecurity]',
        'calculations': 'list[str]',
        'job_settings': 'FIJobSettings'
    }

    attribute_map = {
        'securities': 'securities',
        'calculations': 'calculations',
        'job_settings': 'jobSettings'
    }

    def __init__(self, securities=None, calculations=None, job_settings=None, local_vars_configuration=None):  # noqa: E501
        """FICalculationParameters - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._securities = None
        self._calculations = None
        self._job_settings = None
        self.discriminator = None

        self.securities = securities
        self.calculations = calculations
        self.job_settings = job_settings

    @property
    def securities(self):
        """Gets the securities of this FICalculationParameters.  # noqa: E501


        :return: The securities of this FICalculationParameters.  # noqa: E501
        :rtype: list[FISecurity]
        """
        return self._securities

    @securities.setter
    def securities(self, securities):
        """Sets the securities of this FICalculationParameters.


        :param securities: The securities of this FICalculationParameters.  # noqa: E501
        :type: list[FISecurity]
        """
        if self.local_vars_configuration.client_side_validation and securities is None:  # noqa: E501
            raise ValueError("Invalid value for `securities`, must not be `None`")  # noqa: E501

        self._securities = securities

    @property
    def calculations(self):
        """Gets the calculations of this FICalculationParameters.  # noqa: E501


        :return: The calculations of this FICalculationParameters.  # noqa: E501
        :rtype: list[str]
        """
        return self._calculations

    @calculations.setter
    def calculations(self, calculations):
        """Sets the calculations of this FICalculationParameters.


        :param calculations: The calculations of this FICalculationParameters.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and calculations is None:  # noqa: E501
            raise ValueError("Invalid value for `calculations`, must not be `None`")  # noqa: E501

        self._calculations = calculations

    @property
    def job_settings(self):
        """Gets the job_settings of this FICalculationParameters.  # noqa: E501


        :return: The job_settings of this FICalculationParameters.  # noqa: E501
        :rtype: FIJobSettings
        """
        return self._job_settings

    @job_settings.setter
    def job_settings(self, job_settings):
        """Sets the job_settings of this FICalculationParameters.


        :param job_settings: The job_settings of this FICalculationParameters.  # noqa: E501
        :type: FIJobSettings
        """
        if self.local_vars_configuration.client_side_validation and job_settings is None:  # noqa: E501
            raise ValueError("Invalid value for `job_settings`, must not be `None`")  # noqa: E501

        self._job_settings = job_settings

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FICalculationParameters):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FICalculationParameters):
            return True

        return self.to_dict() != other.to_dict()
