# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'VulnerabilityAuditApplicationDependency',
    'VulnerabilityAuditConfiguration',
    'VulnerabilityAuditSource',
    'VulnerabilityAuditVulnerability',
    'GetKnowledgebasesFilterResult',
    'GetKnowledgebasesKnowledgeBaseCollectionResult',
    'GetKnowledgebasesKnowledgeBaseCollectionItemResult',
    'GetVulnerabilityAuditApplicationDependencyResult',
    'GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionResult',
    'GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemResult',
    'GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemVulnerabilityResult',
    'GetVulnerabilityAuditApplicationDependencyVulnerabilitiesFilterResult',
    'GetVulnerabilityAuditApplicationDependencyVulnerabilityItemResult',
    'GetVulnerabilityAuditApplicationDependencyVulnerabilityItemVulnerabilityResult',
    'GetVulnerabilityAuditConfigurationResult',
    'GetVulnerabilityAuditSourceResult',
    'GetVulnerabilityAuditVulnerabilityResult',
    'GetVulnerabilityAuditsFilterResult',
    'GetVulnerabilityAuditsVulnerabilityAuditCollectionResult',
    'GetVulnerabilityAuditsVulnerabilityAuditCollectionItemResult',
    'GetVulnerabilityAuditsVulnerabilityAuditCollectionItemApplicationDependencyResult',
    'GetVulnerabilityAuditsVulnerabilityAuditCollectionItemConfigurationResult',
    'GetVulnerabilityAuditsVulnerabilityAuditCollectionItemSourceResult',
    'GetVulnerabilityAuditsVulnerabilityAuditCollectionItemVulnerabilityResult',
]

@pulumi.output_type
class VulnerabilityAuditApplicationDependency(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeId":
            suggest = "node_id"
        elif key == "applicationDependencyNodeIds":
            suggest = "application_dependency_node_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityAuditApplicationDependency. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityAuditApplicationDependency.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityAuditApplicationDependency.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gav: str,
                 node_id: str,
                 application_dependency_node_ids: Optional[Sequence[str]] = None):
        """
        :param str gav: Group Artifact Version (GAV) identifier (Group:Artifact:Version), e.g. org.graalvm.nativeimage:svm:21.1.0.
        :param str node_id: Unique identifier of an Application Dependency, for example nodeId1. The nodeId can be generated by assigning a unique id to each application dependency in the tree of application dependencies. Every node, even those who share the same GAV, should have a different nodeId. The preferred way of constructing a nodeId is to assign incremental integers during a breadth first or depth first search. A nodeId can be reused only it refers to the same subtree of application dependencies. (This is not equivalent to referring to the same GAV, that is, a GAV can have multiple transitive dependencies.)
        :param Sequence[str] application_dependency_node_ids: List of Application Dependencies on which this Application Dependency depends, each identified by its nodeId.
        """
        VulnerabilityAuditApplicationDependency._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            gav=gav,
            node_id=node_id,
            application_dependency_node_ids=application_dependency_node_ids,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             gav: str,
             node_id: str,
             application_dependency_node_ids: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'nodeId' in kwargs:
            node_id = kwargs['nodeId']
        if 'applicationDependencyNodeIds' in kwargs:
            application_dependency_node_ids = kwargs['applicationDependencyNodeIds']

        _setter("gav", gav)
        _setter("node_id", node_id)
        if application_dependency_node_ids is not None:
            _setter("application_dependency_node_ids", application_dependency_node_ids)

    @property
    @pulumi.getter
    def gav(self) -> str:
        """
        Group Artifact Version (GAV) identifier (Group:Artifact:Version), e.g. org.graalvm.nativeimage:svm:21.1.0.
        """
        return pulumi.get(self, "gav")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        Unique identifier of an Application Dependency, for example nodeId1. The nodeId can be generated by assigning a unique id to each application dependency in the tree of application dependencies. Every node, even those who share the same GAV, should have a different nodeId. The preferred way of constructing a nodeId is to assign incremental integers during a breadth first or depth first search. A nodeId can be reused only it refers to the same subtree of application dependencies. (This is not equivalent to referring to the same GAV, that is, a GAV can have multiple transitive dependencies.)
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="applicationDependencyNodeIds")
    def application_dependency_node_ids(self) -> Optional[Sequence[str]]:
        """
        List of Application Dependencies on which this Application Dependency depends, each identified by its nodeId.
        """
        return pulumi.get(self, "application_dependency_node_ids")


@pulumi.output_type
class VulnerabilityAuditConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPermissibleCvssV2score":
            suggest = "max_permissible_cvss_v2score"
        elif key == "maxPermissibleCvssV3score":
            suggest = "max_permissible_cvss_v3score"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityAuditConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityAuditConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityAuditConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclusions: Optional[Sequence[str]] = None,
                 max_permissible_cvss_v2score: Optional[float] = None,
                 max_permissible_cvss_v3score: Optional[float] = None):
        """
        :param Sequence[str] exclusions: A vulnerable Application Dependency is ignored if its name matches any of the items in `exclusions`.
        :param float max_permissible_cvss_v2score: A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        :param float max_permissible_cvss_v3score: A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        VulnerabilityAuditConfiguration._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            exclusions=exclusions,
            max_permissible_cvss_v2score=max_permissible_cvss_v2score,
            max_permissible_cvss_v3score=max_permissible_cvss_v3score,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             exclusions: Optional[Sequence[str]] = None,
             max_permissible_cvss_v2score: Optional[float] = None,
             max_permissible_cvss_v3score: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'maxPermissibleCvssV2score' in kwargs:
            max_permissible_cvss_v2score = kwargs['maxPermissibleCvssV2score']
        if 'maxPermissibleCvssV3score' in kwargs:
            max_permissible_cvss_v3score = kwargs['maxPermissibleCvssV3score']

        if exclusions is not None:
            _setter("exclusions", exclusions)
        if max_permissible_cvss_v2score is not None:
            _setter("max_permissible_cvss_v2score", max_permissible_cvss_v2score)
        if max_permissible_cvss_v3score is not None:
            _setter("max_permissible_cvss_v3score", max_permissible_cvss_v3score)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence[str]]:
        """
        A vulnerable Application Dependency is ignored if its name matches any of the items in `exclusions`.
        """
        return pulumi.get(self, "exclusions")

    @property
    @pulumi.getter(name="maxPermissibleCvssV2score")
    def max_permissible_cvss_v2score(self) -> Optional[float]:
        """
        A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        return pulumi.get(self, "max_permissible_cvss_v2score")

    @property
    @pulumi.getter(name="maxPermissibleCvssV3score")
    def max_permissible_cvss_v3score(self) -> Optional[float]:
        """
        A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        return pulumi.get(self, "max_permissible_cvss_v3score")


@pulumi.output_type
class VulnerabilityAuditSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ociResourceId":
            suggest = "oci_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityAuditSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityAuditSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityAuditSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 description: Optional[str] = None,
                 oci_resource_id: Optional[str] = None):
        """
        :param str type: Source type of the Vulnerability Audit.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param str description: Description of the external resource source.
        :param str oci_resource_id: The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure resource that triggered the Vulnerability Audit.
        """
        VulnerabilityAuditSource._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            description=description,
            oci_resource_id=oci_resource_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: str,
             description: Optional[str] = None,
             oci_resource_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ociResourceId' in kwargs:
            oci_resource_id = kwargs['ociResourceId']

        _setter("type", type)
        if description is not None:
            _setter("description", description)
        if oci_resource_id is not None:
            _setter("oci_resource_id", oci_resource_id)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Source type of the Vulnerability Audit.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the external resource source.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ociResourceId")
    def oci_resource_id(self) -> Optional[str]:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure resource that triggered the Vulnerability Audit.
        """
        return pulumi.get(self, "oci_resource_id")


@pulumi.output_type
class VulnerabilityAuditVulnerability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cvssV2score":
            suggest = "cvss_v2score"
        elif key == "cvssV3score":
            suggest = "cvss_v3score"
        elif key == "isIgnored":
            suggest = "is_ignored"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityAuditVulnerability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityAuditVulnerability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityAuditVulnerability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cvss_v2score: Optional[float] = None,
                 cvss_v3score: Optional[float] = None,
                 id: Optional[str] = None,
                 is_ignored: Optional[bool] = None):
        """
        :param float cvss_v2score: Common Vulnerability Scoring System (CVSS) Version 2.
        :param float cvss_v3score: Common Vulnerability Scoring System (CVSS) Version 3.
        :param str id: Unique vulnerability identifier, e.g. CVE-1999-0067.
        :param bool is_ignored: Indicates if the vulnerability was ignored according to the audit configuration.
        """
        VulnerabilityAuditVulnerability._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cvss_v2score=cvss_v2score,
            cvss_v3score=cvss_v3score,
            id=id,
            is_ignored=is_ignored,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cvss_v2score: Optional[float] = None,
             cvss_v3score: Optional[float] = None,
             id: Optional[str] = None,
             is_ignored: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cvssV2score' in kwargs:
            cvss_v2score = kwargs['cvssV2score']
        if 'cvssV3score' in kwargs:
            cvss_v3score = kwargs['cvssV3score']
        if 'isIgnored' in kwargs:
            is_ignored = kwargs['isIgnored']

        if cvss_v2score is not None:
            _setter("cvss_v2score", cvss_v2score)
        if cvss_v3score is not None:
            _setter("cvss_v3score", cvss_v3score)
        if id is not None:
            _setter("id", id)
        if is_ignored is not None:
            _setter("is_ignored", is_ignored)

    @property
    @pulumi.getter(name="cvssV2score")
    def cvss_v2score(self) -> Optional[float]:
        """
        Common Vulnerability Scoring System (CVSS) Version 2.
        """
        return pulumi.get(self, "cvss_v2score")

    @property
    @pulumi.getter(name="cvssV3score")
    def cvss_v3score(self) -> Optional[float]:
        """
        Common Vulnerability Scoring System (CVSS) Version 3.
        """
        return pulumi.get(self, "cvss_v3score")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique vulnerability identifier, e.g. CVE-1999-0067.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isIgnored")
    def is_ignored(self) -> Optional[bool]:
        """
        Indicates if the vulnerability was ignored according to the audit configuration.
        """
        return pulumi.get(self, "is_ignored")


@pulumi.output_type
class GetKnowledgebasesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetKnowledgebasesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetKnowledgebasesKnowledgeBaseCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetKnowledgebasesKnowledgeBaseCollectionItemResult']):
        GetKnowledgebasesKnowledgeBaseCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetKnowledgebasesKnowledgeBaseCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetKnowledgebasesKnowledgeBaseCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetKnowledgebasesKnowledgeBaseCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: A filter to return only resources that belong to the specified compartment identifier.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: A filter to return only resources that match the specified identifier.
        :param str state: A filter to return only Knowledge Bases that match the specified lifecycleState.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The creation date and time of the Knowledge Base (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param str time_updated: The date and time the Knowledge Base was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        GetKnowledgebasesKnowledgeBaseCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        A filter to return only resources that belong to the specified compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A filter to return only resources that match the specified identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only Knowledge Bases that match the specified lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The creation date and time of the Knowledge Base (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the Knowledge Base was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetVulnerabilityAuditApplicationDependencyResult(dict):
    def __init__(__self__, *,
                 application_dependency_node_ids: Sequence[str],
                 gav: str,
                 node_id: str):
        GetVulnerabilityAuditApplicationDependencyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            application_dependency_node_ids=application_dependency_node_ids,
            gav=gav,
            node_id=node_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             application_dependency_node_ids: Sequence[str],
             gav: str,
             node_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'applicationDependencyNodeIds' in kwargs:
            application_dependency_node_ids = kwargs['applicationDependencyNodeIds']
        if 'nodeId' in kwargs:
            node_id = kwargs['nodeId']

        _setter("application_dependency_node_ids", application_dependency_node_ids)
        _setter("gav", gav)
        _setter("node_id", node_id)

    @property
    @pulumi.getter(name="applicationDependencyNodeIds")
    def application_dependency_node_ids(self) -> Sequence[str]:
        return pulumi.get(self, "application_dependency_node_ids")

    @property
    @pulumi.getter
    def gav(self) -> str:
        return pulumi.get(self, "gav")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        return pulumi.get(self, "node_id")


@pulumi.output_type
class GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemResult']):
        """
        :param Sequence['GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemArgs'] items: List of Vulnerability Audit summaries.
        """
        GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemResult']:
        """
        List of Vulnerability Audit summaries.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemResult(dict):
    def __init__(__self__, *,
                 application_dependency_node_ids: Sequence[str],
                 gav: str,
                 is_found_in_knowledge_base: bool,
                 node_id: str,
                 vulnerabilities: Sequence['outputs.GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemVulnerabilityResult']):
        """
        :param Sequence[str] application_dependency_node_ids: List of Application Dependencies on which this Application Dependency depends, each identified by its nodeId.
        :param str gav: A filter to return only resources that match the entire GAV (Group Artifact Version) identifier given.
        :param bool is_found_in_knowledge_base: Indicates if the artifact is found in the knowledge base.
        :param str node_id: Unique identifier of an Application Dependency, for example nodeId1.
        :param Sequence['GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemVulnerabilityArgs'] vulnerabilities: List of vulnerabilities for the Application Dependency.
        """
        GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            application_dependency_node_ids=application_dependency_node_ids,
            gav=gav,
            is_found_in_knowledge_base=is_found_in_knowledge_base,
            node_id=node_id,
            vulnerabilities=vulnerabilities,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             application_dependency_node_ids: Sequence[str],
             gav: str,
             is_found_in_knowledge_base: bool,
             node_id: str,
             vulnerabilities: Sequence['outputs.GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemVulnerabilityResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'applicationDependencyNodeIds' in kwargs:
            application_dependency_node_ids = kwargs['applicationDependencyNodeIds']
        if 'isFoundInKnowledgeBase' in kwargs:
            is_found_in_knowledge_base = kwargs['isFoundInKnowledgeBase']
        if 'nodeId' in kwargs:
            node_id = kwargs['nodeId']

        _setter("application_dependency_node_ids", application_dependency_node_ids)
        _setter("gav", gav)
        _setter("is_found_in_knowledge_base", is_found_in_knowledge_base)
        _setter("node_id", node_id)
        _setter("vulnerabilities", vulnerabilities)

    @property
    @pulumi.getter(name="applicationDependencyNodeIds")
    def application_dependency_node_ids(self) -> Sequence[str]:
        """
        List of Application Dependencies on which this Application Dependency depends, each identified by its nodeId.
        """
        return pulumi.get(self, "application_dependency_node_ids")

    @property
    @pulumi.getter
    def gav(self) -> str:
        """
        A filter to return only resources that match the entire GAV (Group Artifact Version) identifier given.
        """
        return pulumi.get(self, "gav")

    @property
    @pulumi.getter(name="isFoundInKnowledgeBase")
    def is_found_in_knowledge_base(self) -> bool:
        """
        Indicates if the artifact is found in the knowledge base.
        """
        return pulumi.get(self, "is_found_in_knowledge_base")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        Unique identifier of an Application Dependency, for example nodeId1.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def vulnerabilities(self) -> Sequence['outputs.GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemVulnerabilityResult']:
        """
        List of vulnerabilities for the Application Dependency.
        """
        return pulumi.get(self, "vulnerabilities")


@pulumi.output_type
class GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemVulnerabilityResult(dict):
    def __init__(__self__, *,
                 cvss_v2score: float,
                 cvss_v3score: float,
                 id: str,
                 is_ignored: bool):
        """
        :param float cvss_v2score: Common Vulnerability Scoring System (CVSS) Version 2.
        :param float cvss_v3score: Common Vulnerability Scoring System (CVSS) Version 3.
        :param str id: Unique vulnerability identifier, e.g. CVE-1999-0067.
        :param bool is_ignored: Indicates if the vulnerability was ignored according to the audit configuration.
        """
        GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemVulnerabilityResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cvss_v2score=cvss_v2score,
            cvss_v3score=cvss_v3score,
            id=id,
            is_ignored=is_ignored,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cvss_v2score: float,
             cvss_v3score: float,
             id: str,
             is_ignored: bool,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cvssV2score' in kwargs:
            cvss_v2score = kwargs['cvssV2score']
        if 'cvssV3score' in kwargs:
            cvss_v3score = kwargs['cvssV3score']
        if 'isIgnored' in kwargs:
            is_ignored = kwargs['isIgnored']

        _setter("cvss_v2score", cvss_v2score)
        _setter("cvss_v3score", cvss_v3score)
        _setter("id", id)
        _setter("is_ignored", is_ignored)

    @property
    @pulumi.getter(name="cvssV2score")
    def cvss_v2score(self) -> float:
        """
        Common Vulnerability Scoring System (CVSS) Version 2.
        """
        return pulumi.get(self, "cvss_v2score")

    @property
    @pulumi.getter(name="cvssV3score")
    def cvss_v3score(self) -> float:
        """
        Common Vulnerability Scoring System (CVSS) Version 3.
        """
        return pulumi.get(self, "cvss_v3score")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique vulnerability identifier, e.g. CVE-1999-0067.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isIgnored")
    def is_ignored(self) -> bool:
        """
        Indicates if the vulnerability was ignored according to the audit configuration.
        """
        return pulumi.get(self, "is_ignored")


@pulumi.output_type
class GetVulnerabilityAuditApplicationDependencyVulnerabilitiesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetVulnerabilityAuditApplicationDependencyVulnerabilitiesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVulnerabilityAuditApplicationDependencyVulnerabilityItemResult(dict):
    def __init__(__self__, *,
                 application_dependency_node_ids: Sequence[str],
                 gav: str,
                 is_found_in_knowledge_base: bool,
                 node_id: str,
                 vulnerabilities: Sequence['outputs.GetVulnerabilityAuditApplicationDependencyVulnerabilityItemVulnerabilityResult']):
        """
        :param Sequence[str] application_dependency_node_ids: List of Application Dependencies on which this Application Dependency depends, each identified by its nodeId.
        :param str gav: A filter to return only resources that match the entire GAV (Group Artifact Version) identifier given.
        :param bool is_found_in_knowledge_base: Indicates if the artifact is found in the knowledge base.
        :param str node_id: Unique identifier of an Application Dependency, for example nodeId1.
        :param Sequence['GetVulnerabilityAuditApplicationDependencyVulnerabilityItemVulnerabilityArgs'] vulnerabilities: List of vulnerabilities for the Application Dependency.
        """
        GetVulnerabilityAuditApplicationDependencyVulnerabilityItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            application_dependency_node_ids=application_dependency_node_ids,
            gav=gav,
            is_found_in_knowledge_base=is_found_in_knowledge_base,
            node_id=node_id,
            vulnerabilities=vulnerabilities,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             application_dependency_node_ids: Sequence[str],
             gav: str,
             is_found_in_knowledge_base: bool,
             node_id: str,
             vulnerabilities: Sequence['outputs.GetVulnerabilityAuditApplicationDependencyVulnerabilityItemVulnerabilityResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'applicationDependencyNodeIds' in kwargs:
            application_dependency_node_ids = kwargs['applicationDependencyNodeIds']
        if 'isFoundInKnowledgeBase' in kwargs:
            is_found_in_knowledge_base = kwargs['isFoundInKnowledgeBase']
        if 'nodeId' in kwargs:
            node_id = kwargs['nodeId']

        _setter("application_dependency_node_ids", application_dependency_node_ids)
        _setter("gav", gav)
        _setter("is_found_in_knowledge_base", is_found_in_knowledge_base)
        _setter("node_id", node_id)
        _setter("vulnerabilities", vulnerabilities)

    @property
    @pulumi.getter(name="applicationDependencyNodeIds")
    def application_dependency_node_ids(self) -> Sequence[str]:
        """
        List of Application Dependencies on which this Application Dependency depends, each identified by its nodeId.
        """
        return pulumi.get(self, "application_dependency_node_ids")

    @property
    @pulumi.getter
    def gav(self) -> str:
        """
        A filter to return only resources that match the entire GAV (Group Artifact Version) identifier given.
        """
        return pulumi.get(self, "gav")

    @property
    @pulumi.getter(name="isFoundInKnowledgeBase")
    def is_found_in_knowledge_base(self) -> bool:
        """
        Indicates if the artifact is found in the knowledge base.
        """
        return pulumi.get(self, "is_found_in_knowledge_base")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        Unique identifier of an Application Dependency, for example nodeId1.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def vulnerabilities(self) -> Sequence['outputs.GetVulnerabilityAuditApplicationDependencyVulnerabilityItemVulnerabilityResult']:
        """
        List of vulnerabilities for the Application Dependency.
        """
        return pulumi.get(self, "vulnerabilities")


@pulumi.output_type
class GetVulnerabilityAuditApplicationDependencyVulnerabilityItemVulnerabilityResult(dict):
    def __init__(__self__, *,
                 cvss_v2score: float,
                 cvss_v3score: float,
                 id: str,
                 is_ignored: bool):
        """
        :param float cvss_v2score: Common Vulnerability Scoring System (CVSS) Version 2.
        :param float cvss_v3score: Common Vulnerability Scoring System (CVSS) Version 3.
        :param str id: Unique vulnerability identifier, e.g. CVE-1999-0067.
        :param bool is_ignored: Indicates if the vulnerability was ignored according to the audit configuration.
        """
        GetVulnerabilityAuditApplicationDependencyVulnerabilityItemVulnerabilityResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cvss_v2score=cvss_v2score,
            cvss_v3score=cvss_v3score,
            id=id,
            is_ignored=is_ignored,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cvss_v2score: float,
             cvss_v3score: float,
             id: str,
             is_ignored: bool,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cvssV2score' in kwargs:
            cvss_v2score = kwargs['cvssV2score']
        if 'cvssV3score' in kwargs:
            cvss_v3score = kwargs['cvssV3score']
        if 'isIgnored' in kwargs:
            is_ignored = kwargs['isIgnored']

        _setter("cvss_v2score", cvss_v2score)
        _setter("cvss_v3score", cvss_v3score)
        _setter("id", id)
        _setter("is_ignored", is_ignored)

    @property
    @pulumi.getter(name="cvssV2score")
    def cvss_v2score(self) -> float:
        """
        Common Vulnerability Scoring System (CVSS) Version 2.
        """
        return pulumi.get(self, "cvss_v2score")

    @property
    @pulumi.getter(name="cvssV3score")
    def cvss_v3score(self) -> float:
        """
        Common Vulnerability Scoring System (CVSS) Version 3.
        """
        return pulumi.get(self, "cvss_v3score")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique vulnerability identifier, e.g. CVE-1999-0067.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isIgnored")
    def is_ignored(self) -> bool:
        """
        Indicates if the vulnerability was ignored according to the audit configuration.
        """
        return pulumi.get(self, "is_ignored")


@pulumi.output_type
class GetVulnerabilityAuditConfigurationResult(dict):
    def __init__(__self__, *,
                 exclusions: Sequence[str],
                 max_permissible_cvss_v2score: float,
                 max_permissible_cvss_v3score: float):
        """
        :param Sequence[str] exclusions: A vulnerable Application Dependency is ignored if its name matches any of the items in `exclusions`.
        :param float max_permissible_cvss_v2score: A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        :param float max_permissible_cvss_v3score: A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        GetVulnerabilityAuditConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            exclusions=exclusions,
            max_permissible_cvss_v2score=max_permissible_cvss_v2score,
            max_permissible_cvss_v3score=max_permissible_cvss_v3score,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             exclusions: Sequence[str],
             max_permissible_cvss_v2score: float,
             max_permissible_cvss_v3score: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'maxPermissibleCvssV2score' in kwargs:
            max_permissible_cvss_v2score = kwargs['maxPermissibleCvssV2score']
        if 'maxPermissibleCvssV3score' in kwargs:
            max_permissible_cvss_v3score = kwargs['maxPermissibleCvssV3score']

        _setter("exclusions", exclusions)
        _setter("max_permissible_cvss_v2score", max_permissible_cvss_v2score)
        _setter("max_permissible_cvss_v3score", max_permissible_cvss_v3score)

    @property
    @pulumi.getter
    def exclusions(self) -> Sequence[str]:
        """
        A vulnerable Application Dependency is ignored if its name matches any of the items in `exclusions`.
        """
        return pulumi.get(self, "exclusions")

    @property
    @pulumi.getter(name="maxPermissibleCvssV2score")
    def max_permissible_cvss_v2score(self) -> float:
        """
        A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        return pulumi.get(self, "max_permissible_cvss_v2score")

    @property
    @pulumi.getter(name="maxPermissibleCvssV3score")
    def max_permissible_cvss_v3score(self) -> float:
        """
        A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        return pulumi.get(self, "max_permissible_cvss_v3score")


@pulumi.output_type
class GetVulnerabilityAuditSourceResult(dict):
    def __init__(__self__, *,
                 description: str,
                 oci_resource_id: str,
                 type: str):
        """
        :param str description: Description of the external resource source.
        :param str oci_resource_id: The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure resource that triggered the Vulnerability Audit.
        :param str type: Source type of the Vulnerability Audit.
        """
        GetVulnerabilityAuditSourceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            oci_resource_id=oci_resource_id,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: str,
             oci_resource_id: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ociResourceId' in kwargs:
            oci_resource_id = kwargs['ociResourceId']

        _setter("description", description)
        _setter("oci_resource_id", oci_resource_id)
        _setter("type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the external resource source.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ociResourceId")
    def oci_resource_id(self) -> str:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure resource that triggered the Vulnerability Audit.
        """
        return pulumi.get(self, "oci_resource_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Source type of the Vulnerability Audit.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetVulnerabilityAuditVulnerabilityResult(dict):
    def __init__(__self__, *,
                 cvss_v2score: float,
                 cvss_v3score: float,
                 id: str,
                 is_ignored: bool):
        """
        :param float cvss_v2score: Common Vulnerability Scoring System (CVSS) Version 2.
        :param float cvss_v3score: Common Vulnerability Scoring System (CVSS) Version 3.
        :param str id: Unique vulnerability identifier, e.g. CVE-1999-0067.
        :param bool is_ignored: Indicates if the vulnerability was ignored according to the audit configuration.
        """
        GetVulnerabilityAuditVulnerabilityResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cvss_v2score=cvss_v2score,
            cvss_v3score=cvss_v3score,
            id=id,
            is_ignored=is_ignored,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cvss_v2score: float,
             cvss_v3score: float,
             id: str,
             is_ignored: bool,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cvssV2score' in kwargs:
            cvss_v2score = kwargs['cvssV2score']
        if 'cvssV3score' in kwargs:
            cvss_v3score = kwargs['cvssV3score']
        if 'isIgnored' in kwargs:
            is_ignored = kwargs['isIgnored']

        _setter("cvss_v2score", cvss_v2score)
        _setter("cvss_v3score", cvss_v3score)
        _setter("id", id)
        _setter("is_ignored", is_ignored)

    @property
    @pulumi.getter(name="cvssV2score")
    def cvss_v2score(self) -> float:
        """
        Common Vulnerability Scoring System (CVSS) Version 2.
        """
        return pulumi.get(self, "cvss_v2score")

    @property
    @pulumi.getter(name="cvssV3score")
    def cvss_v3score(self) -> float:
        """
        Common Vulnerability Scoring System (CVSS) Version 3.
        """
        return pulumi.get(self, "cvss_v3score")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique vulnerability identifier, e.g. CVE-1999-0067.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isIgnored")
    def is_ignored(self) -> bool:
        """
        Indicates if the vulnerability was ignored according to the audit configuration.
        """
        return pulumi.get(self, "is_ignored")


@pulumi.output_type
class GetVulnerabilityAuditsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetVulnerabilityAuditsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVulnerabilityAuditsVulnerabilityAuditCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemResult']):
        GetVulnerabilityAuditsVulnerabilityAuditCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetVulnerabilityAuditsVulnerabilityAuditCollectionItemResult(dict):
    def __init__(__self__, *,
                 application_dependencies: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemApplicationDependencyResult'],
                 build_type: str,
                 compartment_id: str,
                 configurations: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemConfigurationResult'],
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_success: bool,
                 knowledge_base_id: str,
                 max_observed_cvss_v2score: float,
                 max_observed_cvss_v2score_with_ignored: float,
                 max_observed_cvss_v3score: float,
                 max_observed_cvss_v3score_with_ignored: float,
                 sources: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemSourceResult'],
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str,
                 vulnerabilities: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemVulnerabilityResult'],
                 vulnerable_artifacts_count: int,
                 vulnerable_artifacts_count_with_ignored: int):
        """
        :param str build_type: The type of the build tool.
        :param str compartment_id: A filter to return only resources that belong to the specified compartment identifier.
        :param Sequence['GetVulnerabilityAuditsVulnerabilityAuditCollectionItemConfigurationArgs'] configurations: Configuration for a Vulnerability Audit. A vulnerable Application Dependency is ignored if its name does match any of the items in `exclusions`, or all of the associated Vulnerabilies have a CVSS v2 score below `maxPermissibleCvssV2Score` and a CVSS v3 score below `maxPermissibleCvssV3Score`. type: object
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: A filter to return only resources that match the specified identifier.
        :param bool is_success: A filter to return only successful or failed Vulnerability Audits.
        :param str knowledge_base_id: A filter to return only Vulnerability Audits that were created against the specified knowledge base.
        :param float max_observed_cvss_v2score: Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored vulnerable Application Dependencies.
        :param float max_observed_cvss_v2score_with_ignored: Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable Application Dependencies including ignored ones.
        :param float max_observed_cvss_v3score: Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored vulnerable Application Dependencies.
        :param float max_observed_cvss_v3score_with_ignored: Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable Application Dependencies including ignored ones.
        :param Sequence['GetVulnerabilityAuditsVulnerabilityAuditCollectionItemSourceArgs'] sources: Vulnerability Audit source.
        :param str state: A filter to return only Vulnerability Audits that match the specified lifecycleState.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The creation date and time of the Vulnerability Audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param str time_updated: The update date and time of the Vulnerability Audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param Sequence['GetVulnerabilityAuditsVulnerabilityAuditCollectionItemVulnerabilityArgs'] vulnerabilities: List of vulnerabilities found in the Vulnerability Audit.
        :param int vulnerable_artifacts_count: Count of non-ignored vulnerable Application Dependencies.
        :param int vulnerable_artifacts_count_with_ignored: Count of all vulnerable Application Dependencies.
        """
        GetVulnerabilityAuditsVulnerabilityAuditCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            application_dependencies=application_dependencies,
            build_type=build_type,
            compartment_id=compartment_id,
            configurations=configurations,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            is_success=is_success,
            knowledge_base_id=knowledge_base_id,
            max_observed_cvss_v2score=max_observed_cvss_v2score,
            max_observed_cvss_v2score_with_ignored=max_observed_cvss_v2score_with_ignored,
            max_observed_cvss_v3score=max_observed_cvss_v3score,
            max_observed_cvss_v3score_with_ignored=max_observed_cvss_v3score_with_ignored,
            sources=sources,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
            vulnerabilities=vulnerabilities,
            vulnerable_artifacts_count=vulnerable_artifacts_count,
            vulnerable_artifacts_count_with_ignored=vulnerable_artifacts_count_with_ignored,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             application_dependencies: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemApplicationDependencyResult'],
             build_type: str,
             compartment_id: str,
             configurations: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemConfigurationResult'],
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_success: bool,
             knowledge_base_id: str,
             max_observed_cvss_v2score: float,
             max_observed_cvss_v2score_with_ignored: float,
             max_observed_cvss_v3score: float,
             max_observed_cvss_v3score_with_ignored: float,
             sources: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemSourceResult'],
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             vulnerabilities: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemVulnerabilityResult'],
             vulnerable_artifacts_count: int,
             vulnerable_artifacts_count_with_ignored: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'applicationDependencies' in kwargs:
            application_dependencies = kwargs['applicationDependencies']
        if 'buildType' in kwargs:
            build_type = kwargs['buildType']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isSuccess' in kwargs:
            is_success = kwargs['isSuccess']
        if 'knowledgeBaseId' in kwargs:
            knowledge_base_id = kwargs['knowledgeBaseId']
        if 'maxObservedCvssV2score' in kwargs:
            max_observed_cvss_v2score = kwargs['maxObservedCvssV2score']
        if 'maxObservedCvssV2scoreWithIgnored' in kwargs:
            max_observed_cvss_v2score_with_ignored = kwargs['maxObservedCvssV2scoreWithIgnored']
        if 'maxObservedCvssV3score' in kwargs:
            max_observed_cvss_v3score = kwargs['maxObservedCvssV3score']
        if 'maxObservedCvssV3scoreWithIgnored' in kwargs:
            max_observed_cvss_v3score_with_ignored = kwargs['maxObservedCvssV3scoreWithIgnored']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'vulnerableArtifactsCount' in kwargs:
            vulnerable_artifacts_count = kwargs['vulnerableArtifactsCount']
        if 'vulnerableArtifactsCountWithIgnored' in kwargs:
            vulnerable_artifacts_count_with_ignored = kwargs['vulnerableArtifactsCountWithIgnored']

        _setter("application_dependencies", application_dependencies)
        _setter("build_type", build_type)
        _setter("compartment_id", compartment_id)
        _setter("configurations", configurations)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_success", is_success)
        _setter("knowledge_base_id", knowledge_base_id)
        _setter("max_observed_cvss_v2score", max_observed_cvss_v2score)
        _setter("max_observed_cvss_v2score_with_ignored", max_observed_cvss_v2score_with_ignored)
        _setter("max_observed_cvss_v3score", max_observed_cvss_v3score)
        _setter("max_observed_cvss_v3score_with_ignored", max_observed_cvss_v3score_with_ignored)
        _setter("sources", sources)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("vulnerabilities", vulnerabilities)
        _setter("vulnerable_artifacts_count", vulnerable_artifacts_count)
        _setter("vulnerable_artifacts_count_with_ignored", vulnerable_artifacts_count_with_ignored)

    @property
    @pulumi.getter(name="applicationDependencies")
    def application_dependencies(self) -> Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemApplicationDependencyResult']:
        return pulumi.get(self, "application_dependencies")

    @property
    @pulumi.getter(name="buildType")
    def build_type(self) -> str:
        """
        The type of the build tool.
        """
        return pulumi.get(self, "build_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        A filter to return only resources that belong to the specified compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemConfigurationResult']:
        """
        Configuration for a Vulnerability Audit. A vulnerable Application Dependency is ignored if its name does match any of the items in `exclusions`, or all of the associated Vulnerabilies have a CVSS v2 score below `maxPermissibleCvssV2Score` and a CVSS v3 score below `maxPermissibleCvssV3Score`. type: object
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A filter to return only resources that match the specified identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSuccess")
    def is_success(self) -> bool:
        """
        A filter to return only successful or failed Vulnerability Audits.
        """
        return pulumi.get(self, "is_success")

    @property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> str:
        """
        A filter to return only Vulnerability Audits that were created against the specified knowledge base.
        """
        return pulumi.get(self, "knowledge_base_id")

    @property
    @pulumi.getter(name="maxObservedCvssV2score")
    def max_observed_cvss_v2score(self) -> float:
        """
        Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored vulnerable Application Dependencies.
        """
        return pulumi.get(self, "max_observed_cvss_v2score")

    @property
    @pulumi.getter(name="maxObservedCvssV2scoreWithIgnored")
    def max_observed_cvss_v2score_with_ignored(self) -> float:
        """
        Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable Application Dependencies including ignored ones.
        """
        return pulumi.get(self, "max_observed_cvss_v2score_with_ignored")

    @property
    @pulumi.getter(name="maxObservedCvssV3score")
    def max_observed_cvss_v3score(self) -> float:
        """
        Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored vulnerable Application Dependencies.
        """
        return pulumi.get(self, "max_observed_cvss_v3score")

    @property
    @pulumi.getter(name="maxObservedCvssV3scoreWithIgnored")
    def max_observed_cvss_v3score_with_ignored(self) -> float:
        """
        Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable Application Dependencies including ignored ones.
        """
        return pulumi.get(self, "max_observed_cvss_v3score_with_ignored")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemSourceResult']:
        """
        Vulnerability Audit source.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only Vulnerability Audits that match the specified lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The creation date and time of the Vulnerability Audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The update date and time of the Vulnerability Audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def vulnerabilities(self) -> Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemVulnerabilityResult']:
        """
        List of vulnerabilities found in the Vulnerability Audit.
        """
        return pulumi.get(self, "vulnerabilities")

    @property
    @pulumi.getter(name="vulnerableArtifactsCount")
    def vulnerable_artifacts_count(self) -> int:
        """
        Count of non-ignored vulnerable Application Dependencies.
        """
        return pulumi.get(self, "vulnerable_artifacts_count")

    @property
    @pulumi.getter(name="vulnerableArtifactsCountWithIgnored")
    def vulnerable_artifacts_count_with_ignored(self) -> int:
        """
        Count of all vulnerable Application Dependencies.
        """
        return pulumi.get(self, "vulnerable_artifacts_count_with_ignored")


@pulumi.output_type
class GetVulnerabilityAuditsVulnerabilityAuditCollectionItemApplicationDependencyResult(dict):
    def __init__(__self__, *,
                 application_dependency_node_ids: Sequence[str],
                 gav: str,
                 node_id: str):
        GetVulnerabilityAuditsVulnerabilityAuditCollectionItemApplicationDependencyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            application_dependency_node_ids=application_dependency_node_ids,
            gav=gav,
            node_id=node_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             application_dependency_node_ids: Sequence[str],
             gav: str,
             node_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'applicationDependencyNodeIds' in kwargs:
            application_dependency_node_ids = kwargs['applicationDependencyNodeIds']
        if 'nodeId' in kwargs:
            node_id = kwargs['nodeId']

        _setter("application_dependency_node_ids", application_dependency_node_ids)
        _setter("gav", gav)
        _setter("node_id", node_id)

    @property
    @pulumi.getter(name="applicationDependencyNodeIds")
    def application_dependency_node_ids(self) -> Sequence[str]:
        return pulumi.get(self, "application_dependency_node_ids")

    @property
    @pulumi.getter
    def gav(self) -> str:
        return pulumi.get(self, "gav")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        return pulumi.get(self, "node_id")


@pulumi.output_type
class GetVulnerabilityAuditsVulnerabilityAuditCollectionItemConfigurationResult(dict):
    def __init__(__self__, *,
                 exclusions: Sequence[str],
                 max_permissible_cvss_v2score: float,
                 max_permissible_cvss_v3score: float):
        """
        :param Sequence[str] exclusions: A vulnerable Application Dependency is ignored if its name matches any of the items in `exclusions`.
        :param float max_permissible_cvss_v2score: A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        :param float max_permissible_cvss_v3score: A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        GetVulnerabilityAuditsVulnerabilityAuditCollectionItemConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            exclusions=exclusions,
            max_permissible_cvss_v2score=max_permissible_cvss_v2score,
            max_permissible_cvss_v3score=max_permissible_cvss_v3score,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             exclusions: Sequence[str],
             max_permissible_cvss_v2score: float,
             max_permissible_cvss_v3score: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'maxPermissibleCvssV2score' in kwargs:
            max_permissible_cvss_v2score = kwargs['maxPermissibleCvssV2score']
        if 'maxPermissibleCvssV3score' in kwargs:
            max_permissible_cvss_v3score = kwargs['maxPermissibleCvssV3score']

        _setter("exclusions", exclusions)
        _setter("max_permissible_cvss_v2score", max_permissible_cvss_v2score)
        _setter("max_permissible_cvss_v3score", max_permissible_cvss_v3score)

    @property
    @pulumi.getter
    def exclusions(self) -> Sequence[str]:
        """
        A vulnerable Application Dependency is ignored if its name matches any of the items in `exclusions`.
        """
        return pulumi.get(self, "exclusions")

    @property
    @pulumi.getter(name="maxPermissibleCvssV2score")
    def max_permissible_cvss_v2score(self) -> float:
        """
        A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        return pulumi.get(self, "max_permissible_cvss_v2score")

    @property
    @pulumi.getter(name="maxPermissibleCvssV3score")
    def max_permissible_cvss_v3score(self) -> float:
        """
        A vulnerable Application Dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        return pulumi.get(self, "max_permissible_cvss_v3score")


@pulumi.output_type
class GetVulnerabilityAuditsVulnerabilityAuditCollectionItemSourceResult(dict):
    def __init__(__self__, *,
                 description: str,
                 oci_resource_id: str,
                 type: str):
        """
        :param str description: Description of the external resource source.
        :param str oci_resource_id: The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure resource that triggered the Vulnerability Audit.
        :param str type: Source type of the Vulnerability Audit.
        """
        GetVulnerabilityAuditsVulnerabilityAuditCollectionItemSourceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            oci_resource_id=oci_resource_id,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: str,
             oci_resource_id: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ociResourceId' in kwargs:
            oci_resource_id = kwargs['ociResourceId']

        _setter("description", description)
        _setter("oci_resource_id", oci_resource_id)
        _setter("type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the external resource source.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ociResourceId")
    def oci_resource_id(self) -> str:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure resource that triggered the Vulnerability Audit.
        """
        return pulumi.get(self, "oci_resource_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Source type of the Vulnerability Audit.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetVulnerabilityAuditsVulnerabilityAuditCollectionItemVulnerabilityResult(dict):
    def __init__(__self__, *,
                 cvss_v2score: float,
                 cvss_v3score: float,
                 id: str,
                 is_ignored: bool):
        """
        :param float cvss_v2score: Common Vulnerability Scoring System (CVSS) Version 2.
        :param float cvss_v3score: Common Vulnerability Scoring System (CVSS) Version 3.
        :param str id: A filter to return only resources that match the specified identifier.
        :param bool is_ignored: Indicates if the vulnerability was ignored according to the audit configuration.
        """
        GetVulnerabilityAuditsVulnerabilityAuditCollectionItemVulnerabilityResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cvss_v2score=cvss_v2score,
            cvss_v3score=cvss_v3score,
            id=id,
            is_ignored=is_ignored,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cvss_v2score: float,
             cvss_v3score: float,
             id: str,
             is_ignored: bool,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cvssV2score' in kwargs:
            cvss_v2score = kwargs['cvssV2score']
        if 'cvssV3score' in kwargs:
            cvss_v3score = kwargs['cvssV3score']
        if 'isIgnored' in kwargs:
            is_ignored = kwargs['isIgnored']

        _setter("cvss_v2score", cvss_v2score)
        _setter("cvss_v3score", cvss_v3score)
        _setter("id", id)
        _setter("is_ignored", is_ignored)

    @property
    @pulumi.getter(name="cvssV2score")
    def cvss_v2score(self) -> float:
        """
        Common Vulnerability Scoring System (CVSS) Version 2.
        """
        return pulumi.get(self, "cvss_v2score")

    @property
    @pulumi.getter(name="cvssV3score")
    def cvss_v3score(self) -> float:
        """
        Common Vulnerability Scoring System (CVSS) Version 3.
        """
        return pulumi.get(self, "cvss_v3score")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A filter to return only resources that match the specified identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isIgnored")
    def is_ignored(self) -> bool:
        """
        Indicates if the vulnerability was ignored according to the audit configuration.
        """
        return pulumi.get(self, "is_ignored")


