# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ModelEvaluationResultArgs',
    'ModelEvaluationResultClassMetricArgs',
    'ModelEvaluationResultEntityMetricArgs',
    'ModelEvaluationResultMetricArgs',
    'ModelModelDetailsArgs',
    'ModelModelDetailsClassificationModeArgs',
    'ModelTestStrategyArgs',
    'ModelTestStrategyTestingDatasetArgs',
    'ModelTestStrategyTestingDatasetLocationDetailsArgs',
    'ModelTestStrategyValidationDatasetArgs',
    'ModelTestStrategyValidationDatasetLocationDetailsArgs',
    'ModelTrainingDatasetArgs',
    'ModelTrainingDatasetLocationDetailsArgs',
    'GetEndpointsFilterArgs',
    'GetModelEvaluationResultsFilterArgs',
    'GetModelsFilterArgs',
    'GetProjectsFilterArgs',
]

@pulumi.input_type
class ModelEvaluationResultArgs:
    def __init__(__self__, *,
                 class_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultClassMetricArgs']]]] = None,
                 confusion_matrix: Optional[pulumi.Input[str]] = None,
                 entity_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultEntityMetricArgs']]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultMetricArgs']]]] = None,
                 model_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultClassMetricArgs']]] class_metrics: List of text classification metrics
        :param pulumi.Input[str] confusion_matrix: class level confusion matrix
        :param pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultEntityMetricArgs']]] entity_metrics: List of entity metrics
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: labels
        :param pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultMetricArgs']]] metrics: Model level named entity recognition metrics
        :param pulumi.Input[str] model_type: Model type
        """
        ModelEvaluationResultArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            class_metrics=class_metrics,
            confusion_matrix=confusion_matrix,
            entity_metrics=entity_metrics,
            labels=labels,
            metrics=metrics,
            model_type=model_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             class_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultClassMetricArgs']]]] = None,
             confusion_matrix: Optional[pulumi.Input[str]] = None,
             entity_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultEntityMetricArgs']]]] = None,
             labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultMetricArgs']]]] = None,
             model_type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'classMetrics' in kwargs:
            class_metrics = kwargs['classMetrics']
        if 'confusionMatrix' in kwargs:
            confusion_matrix = kwargs['confusionMatrix']
        if 'entityMetrics' in kwargs:
            entity_metrics = kwargs['entityMetrics']
        if 'modelType' in kwargs:
            model_type = kwargs['modelType']

        if class_metrics is not None:
            _setter("class_metrics", class_metrics)
        if confusion_matrix is not None:
            _setter("confusion_matrix", confusion_matrix)
        if entity_metrics is not None:
            _setter("entity_metrics", entity_metrics)
        if labels is not None:
            _setter("labels", labels)
        if metrics is not None:
            _setter("metrics", metrics)
        if model_type is not None:
            _setter("model_type", model_type)

    @property
    @pulumi.getter(name="classMetrics")
    def class_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultClassMetricArgs']]]]:
        """
        List of text classification metrics
        """
        return pulumi.get(self, "class_metrics")

    @class_metrics.setter
    def class_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultClassMetricArgs']]]]):
        pulumi.set(self, "class_metrics", value)

    @property
    @pulumi.getter(name="confusionMatrix")
    def confusion_matrix(self) -> Optional[pulumi.Input[str]]:
        """
        class level confusion matrix
        """
        return pulumi.get(self, "confusion_matrix")

    @confusion_matrix.setter
    def confusion_matrix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "confusion_matrix", value)

    @property
    @pulumi.getter(name="entityMetrics")
    def entity_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultEntityMetricArgs']]]]:
        """
        List of entity metrics
        """
        return pulumi.get(self, "entity_metrics")

    @entity_metrics.setter
    def entity_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultEntityMetricArgs']]]]):
        pulumi.set(self, "entity_metrics", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        labels
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultMetricArgs']]]]:
        """
        Model level named entity recognition metrics
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelEvaluationResultMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[str]]:
        """
        Model type
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_type", value)


@pulumi.input_type
class ModelEvaluationResultClassMetricArgs:
    def __init__(__self__, *,
                 f1: Optional[pulumi.Input[float]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 precision: Optional[pulumi.Input[float]] = None,
                 recall: Optional[pulumi.Input[float]] = None,
                 support: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param pulumi.Input[str] label: Entity label
        :param pulumi.Input[float] precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param pulumi.Input[float] recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param pulumi.Input[float] support: number of samples in the test set
        """
        ModelEvaluationResultClassMetricArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            f1=f1,
            label=label,
            precision=precision,
            recall=recall,
            support=support,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             f1: Optional[pulumi.Input[float]] = None,
             label: Optional[pulumi.Input[str]] = None,
             precision: Optional[pulumi.Input[float]] = None,
             recall: Optional[pulumi.Input[float]] = None,
             support: Optional[pulumi.Input[float]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if f1 is not None:
            _setter("f1", f1)
        if label is not None:
            _setter("label", label)
        if precision is not None:
            _setter("precision", precision)
        if recall is not None:
            _setter("recall", recall)
        if support is not None:
            _setter("support", support)

    @property
    @pulumi.getter
    def f1(self) -> Optional[pulumi.Input[float]]:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "f1")

    @f1.setter
    def f1(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "f1", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Entity label
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def precision(self) -> Optional[pulumi.Input[float]]:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "precision")

    @precision.setter
    def precision(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "precision", value)

    @property
    @pulumi.getter
    def recall(self) -> Optional[pulumi.Input[float]]:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "recall")

    @recall.setter
    def recall(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "recall", value)

    @property
    @pulumi.getter
    def support(self) -> Optional[pulumi.Input[float]]:
        """
        number of samples in the test set
        """
        return pulumi.get(self, "support")

    @support.setter
    def support(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "support", value)


@pulumi.input_type
class ModelEvaluationResultEntityMetricArgs:
    def __init__(__self__, *,
                 f1: Optional[pulumi.Input[float]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 precision: Optional[pulumi.Input[float]] = None,
                 recall: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param pulumi.Input[str] label: Entity label
        :param pulumi.Input[float] precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param pulumi.Input[float] recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        ModelEvaluationResultEntityMetricArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            f1=f1,
            label=label,
            precision=precision,
            recall=recall,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             f1: Optional[pulumi.Input[float]] = None,
             label: Optional[pulumi.Input[str]] = None,
             precision: Optional[pulumi.Input[float]] = None,
             recall: Optional[pulumi.Input[float]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if f1 is not None:
            _setter("f1", f1)
        if label is not None:
            _setter("label", label)
        if precision is not None:
            _setter("precision", precision)
        if recall is not None:
            _setter("recall", recall)

    @property
    @pulumi.getter
    def f1(self) -> Optional[pulumi.Input[float]]:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "f1")

    @f1.setter
    def f1(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "f1", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Entity label
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def precision(self) -> Optional[pulumi.Input[float]]:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "precision")

    @precision.setter
    def precision(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "precision", value)

    @property
    @pulumi.getter
    def recall(self) -> Optional[pulumi.Input[float]]:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "recall")

    @recall.setter
    def recall(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "recall", value)


@pulumi.input_type
class ModelEvaluationResultMetricArgs:
    def __init__(__self__, *,
                 accuracy: Optional[pulumi.Input[float]] = None,
                 macro_f1: Optional[pulumi.Input[float]] = None,
                 macro_precision: Optional[pulumi.Input[float]] = None,
                 macro_recall: Optional[pulumi.Input[float]] = None,
                 micro_f1: Optional[pulumi.Input[float]] = None,
                 micro_precision: Optional[pulumi.Input[float]] = None,
                 micro_recall: Optional[pulumi.Input[float]] = None,
                 weighted_f1: Optional[pulumi.Input[float]] = None,
                 weighted_precision: Optional[pulumi.Input[float]] = None,
                 weighted_recall: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] accuracy: The fraction of the labels that were correctly recognised .
        :param pulumi.Input[float] macro_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param pulumi.Input[float] macro_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param pulumi.Input[float] macro_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param pulumi.Input[float] micro_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param pulumi.Input[float] micro_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param pulumi.Input[float] micro_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param pulumi.Input[float] weighted_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param pulumi.Input[float] weighted_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param pulumi.Input[float] weighted_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        ModelEvaluationResultMetricArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            accuracy=accuracy,
            macro_f1=macro_f1,
            macro_precision=macro_precision,
            macro_recall=macro_recall,
            micro_f1=micro_f1,
            micro_precision=micro_precision,
            micro_recall=micro_recall,
            weighted_f1=weighted_f1,
            weighted_precision=weighted_precision,
            weighted_recall=weighted_recall,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             accuracy: Optional[pulumi.Input[float]] = None,
             macro_f1: Optional[pulumi.Input[float]] = None,
             macro_precision: Optional[pulumi.Input[float]] = None,
             macro_recall: Optional[pulumi.Input[float]] = None,
             micro_f1: Optional[pulumi.Input[float]] = None,
             micro_precision: Optional[pulumi.Input[float]] = None,
             micro_recall: Optional[pulumi.Input[float]] = None,
             weighted_f1: Optional[pulumi.Input[float]] = None,
             weighted_precision: Optional[pulumi.Input[float]] = None,
             weighted_recall: Optional[pulumi.Input[float]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'macroF1' in kwargs:
            macro_f1 = kwargs['macroF1']
        if 'macroPrecision' in kwargs:
            macro_precision = kwargs['macroPrecision']
        if 'macroRecall' in kwargs:
            macro_recall = kwargs['macroRecall']
        if 'microF1' in kwargs:
            micro_f1 = kwargs['microF1']
        if 'microPrecision' in kwargs:
            micro_precision = kwargs['microPrecision']
        if 'microRecall' in kwargs:
            micro_recall = kwargs['microRecall']
        if 'weightedF1' in kwargs:
            weighted_f1 = kwargs['weightedF1']
        if 'weightedPrecision' in kwargs:
            weighted_precision = kwargs['weightedPrecision']
        if 'weightedRecall' in kwargs:
            weighted_recall = kwargs['weightedRecall']

        if accuracy is not None:
            _setter("accuracy", accuracy)
        if macro_f1 is not None:
            _setter("macro_f1", macro_f1)
        if macro_precision is not None:
            _setter("macro_precision", macro_precision)
        if macro_recall is not None:
            _setter("macro_recall", macro_recall)
        if micro_f1 is not None:
            _setter("micro_f1", micro_f1)
        if micro_precision is not None:
            _setter("micro_precision", micro_precision)
        if micro_recall is not None:
            _setter("micro_recall", micro_recall)
        if weighted_f1 is not None:
            _setter("weighted_f1", weighted_f1)
        if weighted_precision is not None:
            _setter("weighted_precision", weighted_precision)
        if weighted_recall is not None:
            _setter("weighted_recall", weighted_recall)

    @property
    @pulumi.getter
    def accuracy(self) -> Optional[pulumi.Input[float]]:
        """
        The fraction of the labels that were correctly recognised .
        """
        return pulumi.get(self, "accuracy")

    @accuracy.setter
    def accuracy(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "accuracy", value)

    @property
    @pulumi.getter(name="macroF1")
    def macro_f1(self) -> Optional[pulumi.Input[float]]:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "macro_f1")

    @macro_f1.setter
    def macro_f1(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "macro_f1", value)

    @property
    @pulumi.getter(name="macroPrecision")
    def macro_precision(self) -> Optional[pulumi.Input[float]]:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "macro_precision")

    @macro_precision.setter
    def macro_precision(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "macro_precision", value)

    @property
    @pulumi.getter(name="macroRecall")
    def macro_recall(self) -> Optional[pulumi.Input[float]]:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "macro_recall")

    @macro_recall.setter
    def macro_recall(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "macro_recall", value)

    @property
    @pulumi.getter(name="microF1")
    def micro_f1(self) -> Optional[pulumi.Input[float]]:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "micro_f1")

    @micro_f1.setter
    def micro_f1(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "micro_f1", value)

    @property
    @pulumi.getter(name="microPrecision")
    def micro_precision(self) -> Optional[pulumi.Input[float]]:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "micro_precision")

    @micro_precision.setter
    def micro_precision(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "micro_precision", value)

    @property
    @pulumi.getter(name="microRecall")
    def micro_recall(self) -> Optional[pulumi.Input[float]]:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "micro_recall")

    @micro_recall.setter
    def micro_recall(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "micro_recall", value)

    @property
    @pulumi.getter(name="weightedF1")
    def weighted_f1(self) -> Optional[pulumi.Input[float]]:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "weighted_f1")

    @weighted_f1.setter
    def weighted_f1(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "weighted_f1", value)

    @property
    @pulumi.getter(name="weightedPrecision")
    def weighted_precision(self) -> Optional[pulumi.Input[float]]:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "weighted_precision")

    @weighted_precision.setter
    def weighted_precision(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "weighted_precision", value)

    @property
    @pulumi.getter(name="weightedRecall")
    def weighted_recall(self) -> Optional[pulumi.Input[float]]:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "weighted_recall")

    @weighted_recall.setter
    def weighted_recall(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "weighted_recall", value)


@pulumi.input_type
class ModelModelDetailsArgs:
    def __init__(__self__, *,
                 model_type: pulumi.Input[str],
                 classification_mode: Optional[pulumi.Input['ModelModelDetailsClassificationModeArgs']] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] model_type: Model type
        :param pulumi.Input['ModelModelDetailsClassificationModeArgs'] classification_mode: classification Modes
        :param pulumi.Input[str] language_code: supported language default value is en
        :param pulumi.Input[str] version: Optional pre trained model version. if nothing specified latest pre trained model will be used.  Supported versions can be found at /modelTypes/{modelType}
        """
        ModelModelDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            model_type=model_type,
            classification_mode=classification_mode,
            language_code=language_code,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             model_type: pulumi.Input[str],
             classification_mode: Optional[pulumi.Input['ModelModelDetailsClassificationModeArgs']] = None,
             language_code: Optional[pulumi.Input[str]] = None,
             version: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'modelType' in kwargs:
            model_type = kwargs['modelType']
        if 'classificationMode' in kwargs:
            classification_mode = kwargs['classificationMode']
        if 'languageCode' in kwargs:
            language_code = kwargs['languageCode']

        _setter("model_type", model_type)
        if classification_mode is not None:
            _setter("classification_mode", classification_mode)
        if language_code is not None:
            _setter("language_code", language_code)
        if version is not None:
            _setter("version", version)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Input[str]:
        """
        Model type
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "model_type", value)

    @property
    @pulumi.getter(name="classificationMode")
    def classification_mode(self) -> Optional[pulumi.Input['ModelModelDetailsClassificationModeArgs']]:
        """
        classification Modes
        """
        return pulumi.get(self, "classification_mode")

    @classification_mode.setter
    def classification_mode(self, value: Optional[pulumi.Input['ModelModelDetailsClassificationModeArgs']]):
        pulumi.set(self, "classification_mode", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[str]]:
        """
        supported language default value is en
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional pre trained model version. if nothing specified latest pre trained model will be used.  Supported versions can be found at /modelTypes/{modelType}
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ModelModelDetailsClassificationModeArgs:
    def __init__(__self__, *,
                 classification_mode: pulumi.Input[str],
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] classification_mode: classification Modes
        :param pulumi.Input[str] version: Optional pre trained model version. if nothing specified latest pre trained model will be used.  Supported versions can be found at /modelTypes/{modelType}
        """
        ModelModelDetailsClassificationModeArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            classification_mode=classification_mode,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             classification_mode: pulumi.Input[str],
             version: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'classificationMode' in kwargs:
            classification_mode = kwargs['classificationMode']

        _setter("classification_mode", classification_mode)
        if version is not None:
            _setter("version", version)

    @property
    @pulumi.getter(name="classificationMode")
    def classification_mode(self) -> pulumi.Input[str]:
        """
        classification Modes
        """
        return pulumi.get(self, "classification_mode")

    @classification_mode.setter
    def classification_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "classification_mode", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional pre trained model version. if nothing specified latest pre trained model will be used.  Supported versions can be found at /modelTypes/{modelType}
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ModelTestStrategyArgs:
    def __init__(__self__, *,
                 strategy_type: pulumi.Input[str],
                 testing_dataset: pulumi.Input['ModelTestStrategyTestingDatasetArgs'],
                 validation_dataset: Optional[pulumi.Input['ModelTestStrategyValidationDatasetArgs']] = None):
        """
        :param pulumi.Input[str] strategy_type: This information will define the test strategy different datasets for test and validation(optional) dataset.
        :param pulumi.Input['ModelTestStrategyTestingDatasetArgs'] testing_dataset: Possible data set type
        :param pulumi.Input['ModelTestStrategyValidationDatasetArgs'] validation_dataset: Possible data set type
        """
        ModelTestStrategyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            strategy_type=strategy_type,
            testing_dataset=testing_dataset,
            validation_dataset=validation_dataset,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             strategy_type: pulumi.Input[str],
             testing_dataset: pulumi.Input['ModelTestStrategyTestingDatasetArgs'],
             validation_dataset: Optional[pulumi.Input['ModelTestStrategyValidationDatasetArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'strategyType' in kwargs:
            strategy_type = kwargs['strategyType']
        if 'testingDataset' in kwargs:
            testing_dataset = kwargs['testingDataset']
        if 'validationDataset' in kwargs:
            validation_dataset = kwargs['validationDataset']

        _setter("strategy_type", strategy_type)
        _setter("testing_dataset", testing_dataset)
        if validation_dataset is not None:
            _setter("validation_dataset", validation_dataset)

    @property
    @pulumi.getter(name="strategyType")
    def strategy_type(self) -> pulumi.Input[str]:
        """
        This information will define the test strategy different datasets for test and validation(optional) dataset.
        """
        return pulumi.get(self, "strategy_type")

    @strategy_type.setter
    def strategy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "strategy_type", value)

    @property
    @pulumi.getter(name="testingDataset")
    def testing_dataset(self) -> pulumi.Input['ModelTestStrategyTestingDatasetArgs']:
        """
        Possible data set type
        """
        return pulumi.get(self, "testing_dataset")

    @testing_dataset.setter
    def testing_dataset(self, value: pulumi.Input['ModelTestStrategyTestingDatasetArgs']):
        pulumi.set(self, "testing_dataset", value)

    @property
    @pulumi.getter(name="validationDataset")
    def validation_dataset(self) -> Optional[pulumi.Input['ModelTestStrategyValidationDatasetArgs']]:
        """
        Possible data set type
        """
        return pulumi.get(self, "validation_dataset")

    @validation_dataset.setter
    def validation_dataset(self, value: Optional[pulumi.Input['ModelTestStrategyValidationDatasetArgs']]):
        pulumi.set(self, "validation_dataset", value)


@pulumi.input_type
class ModelTestStrategyTestingDatasetArgs:
    def __init__(__self__, *,
                 dataset_type: pulumi.Input[str],
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 location_details: Optional[pulumi.Input['ModelTestStrategyTestingDatasetLocationDetailsArgs']] = None):
        """
        :param pulumi.Input[str] dataset_type: Possible data sets
        :param pulumi.Input[str] dataset_id: Data Science Labelling Service OCID
        :param pulumi.Input['ModelTestStrategyTestingDatasetLocationDetailsArgs'] location_details: Possible object storage location types
        """
        ModelTestStrategyTestingDatasetArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset_type=dataset_type,
            dataset_id=dataset_id,
            location_details=location_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset_type: pulumi.Input[str],
             dataset_id: Optional[pulumi.Input[str]] = None,
             location_details: Optional[pulumi.Input['ModelTestStrategyTestingDatasetLocationDetailsArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'datasetType' in kwargs:
            dataset_type = kwargs['datasetType']
        if 'datasetId' in kwargs:
            dataset_id = kwargs['datasetId']
        if 'locationDetails' in kwargs:
            location_details = kwargs['locationDetails']

        _setter("dataset_type", dataset_type)
        if dataset_id is not None:
            _setter("dataset_id", dataset_id)
        if location_details is not None:
            _setter("location_details", location_details)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> pulumi.Input[str]:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @dataset_type.setter
    def dataset_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset_type", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Optional[pulumi.Input['ModelTestStrategyTestingDatasetLocationDetailsArgs']]:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")

    @location_details.setter
    def location_details(self, value: Optional[pulumi.Input['ModelTestStrategyTestingDatasetLocationDetailsArgs']]):
        pulumi.set(self, "location_details", value)


@pulumi.input_type
class ModelTestStrategyTestingDatasetLocationDetailsArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 location_type: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 object_names: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] bucket: Object storage bucket name
        :param pulumi.Input[str] location_type: Possible object storage location types
        :param pulumi.Input[str] namespace: Object storage namespace
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_names: Array of files which need to be processed in the bucket
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ModelTestStrategyTestingDatasetLocationDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            location_type=location_type,
            namespace=namespace,
            object_names=object_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: pulumi.Input[str],
             location_type: pulumi.Input[str],
             namespace: pulumi.Input[str],
             object_names: pulumi.Input[Sequence[pulumi.Input[str]]],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'locationType' in kwargs:
            location_type = kwargs['locationType']
        if 'objectNames' in kwargs:
            object_names = kwargs['objectNames']

        _setter("bucket", bucket)
        _setter("location_type", location_type)
        _setter("namespace", namespace)
        _setter("object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> pulumi.Input[str]:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @location_type.setter
    def location_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "location_type", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Array of files which need to be processed in the bucket


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "object_names")

    @object_names.setter
    def object_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "object_names", value)


@pulumi.input_type
class ModelTestStrategyValidationDatasetArgs:
    def __init__(__self__, *,
                 dataset_type: pulumi.Input[str],
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 location_details: Optional[pulumi.Input['ModelTestStrategyValidationDatasetLocationDetailsArgs']] = None):
        """
        :param pulumi.Input[str] dataset_type: Possible data sets
        :param pulumi.Input[str] dataset_id: Data Science Labelling Service OCID
        :param pulumi.Input['ModelTestStrategyValidationDatasetLocationDetailsArgs'] location_details: Possible object storage location types
        """
        ModelTestStrategyValidationDatasetArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset_type=dataset_type,
            dataset_id=dataset_id,
            location_details=location_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset_type: pulumi.Input[str],
             dataset_id: Optional[pulumi.Input[str]] = None,
             location_details: Optional[pulumi.Input['ModelTestStrategyValidationDatasetLocationDetailsArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'datasetType' in kwargs:
            dataset_type = kwargs['datasetType']
        if 'datasetId' in kwargs:
            dataset_id = kwargs['datasetId']
        if 'locationDetails' in kwargs:
            location_details = kwargs['locationDetails']

        _setter("dataset_type", dataset_type)
        if dataset_id is not None:
            _setter("dataset_id", dataset_id)
        if location_details is not None:
            _setter("location_details", location_details)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> pulumi.Input[str]:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @dataset_type.setter
    def dataset_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset_type", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Optional[pulumi.Input['ModelTestStrategyValidationDatasetLocationDetailsArgs']]:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")

    @location_details.setter
    def location_details(self, value: Optional[pulumi.Input['ModelTestStrategyValidationDatasetLocationDetailsArgs']]):
        pulumi.set(self, "location_details", value)


@pulumi.input_type
class ModelTestStrategyValidationDatasetLocationDetailsArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 location_type: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 object_names: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] bucket: Object storage bucket name
        :param pulumi.Input[str] location_type: Possible object storage location types
        :param pulumi.Input[str] namespace: Object storage namespace
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_names: Array of files which need to be processed in the bucket
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ModelTestStrategyValidationDatasetLocationDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            location_type=location_type,
            namespace=namespace,
            object_names=object_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: pulumi.Input[str],
             location_type: pulumi.Input[str],
             namespace: pulumi.Input[str],
             object_names: pulumi.Input[Sequence[pulumi.Input[str]]],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'locationType' in kwargs:
            location_type = kwargs['locationType']
        if 'objectNames' in kwargs:
            object_names = kwargs['objectNames']

        _setter("bucket", bucket)
        _setter("location_type", location_type)
        _setter("namespace", namespace)
        _setter("object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> pulumi.Input[str]:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @location_type.setter
    def location_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "location_type", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Array of files which need to be processed in the bucket


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "object_names")

    @object_names.setter
    def object_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "object_names", value)


@pulumi.input_type
class ModelTrainingDatasetArgs:
    def __init__(__self__, *,
                 dataset_type: pulumi.Input[str],
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 location_details: Optional[pulumi.Input['ModelTrainingDatasetLocationDetailsArgs']] = None):
        """
        :param pulumi.Input[str] dataset_type: Possible data sets
        :param pulumi.Input[str] dataset_id: Data Science Labelling Service OCID
        :param pulumi.Input['ModelTrainingDatasetLocationDetailsArgs'] location_details: Possible object storage location types
        """
        ModelTrainingDatasetArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset_type=dataset_type,
            dataset_id=dataset_id,
            location_details=location_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset_type: pulumi.Input[str],
             dataset_id: Optional[pulumi.Input[str]] = None,
             location_details: Optional[pulumi.Input['ModelTrainingDatasetLocationDetailsArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'datasetType' in kwargs:
            dataset_type = kwargs['datasetType']
        if 'datasetId' in kwargs:
            dataset_id = kwargs['datasetId']
        if 'locationDetails' in kwargs:
            location_details = kwargs['locationDetails']

        _setter("dataset_type", dataset_type)
        if dataset_id is not None:
            _setter("dataset_id", dataset_id)
        if location_details is not None:
            _setter("location_details", location_details)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> pulumi.Input[str]:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @dataset_type.setter
    def dataset_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset_type", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Optional[pulumi.Input['ModelTrainingDatasetLocationDetailsArgs']]:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")

    @location_details.setter
    def location_details(self, value: Optional[pulumi.Input['ModelTrainingDatasetLocationDetailsArgs']]):
        pulumi.set(self, "location_details", value)


@pulumi.input_type
class ModelTrainingDatasetLocationDetailsArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 location_type: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 object_names: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] bucket: Object storage bucket name
        :param pulumi.Input[str] location_type: Possible object storage location types
        :param pulumi.Input[str] namespace: Object storage namespace
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_names: Array of files which need to be processed in the bucket
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ModelTrainingDatasetLocationDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            location_type=location_type,
            namespace=namespace,
            object_names=object_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: pulumi.Input[str],
             location_type: pulumi.Input[str],
             namespace: pulumi.Input[str],
             object_names: pulumi.Input[Sequence[pulumi.Input[str]]],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'locationType' in kwargs:
            location_type = kwargs['locationType']
        if 'objectNames' in kwargs:
            object_names = kwargs['objectNames']

        _setter("bucket", bucket)
        _setter("location_type", location_type)
        _setter("namespace", namespace)
        _setter("object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> pulumi.Input[str]:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @location_type.setter
    def location_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "location_type", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Array of files which need to be processed in the bucket


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "object_names")

    @object_names.setter
    def object_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "object_names", value)


@pulumi.input_type
class GetEndpointsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetEndpointsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetModelEvaluationResultsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetModelEvaluationResultsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetModelsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetModelsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetProjectsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetProjectsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


