# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetGatewaysResult',
    'AwaitableGetGatewaysResult',
    'get_gateways',
    'get_gateways_output',
]

@pulumi.output_type
class GetGatewaysResult:
    """
    A collection of values returned by getGateways.
    """
    def __init__(__self__, certificate_id=None, compartment_id=None, display_name=None, filters=None, gateway_collections=None, id=None, state=None):
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if gateway_collections and not isinstance(gateway_collections, list):
            raise TypeError("Expected argument 'gateway_collections' to be a list")
        pulumi.set(__self__, "gateway_collections", gateway_collections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the resource is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetGatewaysFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="gatewayCollections")
    def gateway_collections(self) -> Sequence['outputs.GetGatewaysGatewayCollectionResult']:
        """
        The list of gateway_collection.
        """
        return pulumi.get(self, "gateway_collections")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the gateway.
        """
        return pulumi.get(self, "state")


class AwaitableGetGatewaysResult(GetGatewaysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewaysResult(
            certificate_id=self.certificate_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            gateway_collections=self.gateway_collections,
            id=self.id,
            state=self.state)


def get_gateways(certificate_id: Optional[str] = None,
                 compartment_id: Optional[str] = None,
                 display_name: Optional[str] = None,
                 filters: Optional[Sequence[pulumi.InputType['GetGatewaysFilterArgs']]] = None,
                 state: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewaysResult:
    """
    This data source provides the list of Gateways in Oracle Cloud Infrastructure API Gateway service.

    Returns a list of gateways.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_gateways = oci.ApiGateway.get_gateways(compartment_id=var["compartment_id"],
        certificate_id=var["oci_apigateway_certificate"]["test_certificate"]["id"],
        display_name=var["gateway_display_name"],
        state=var["gateway_state"])
    ```


    :param str certificate_id: Filter gateways by the certificate ocid.
    :param str compartment_id: The ocid of the compartment in which to list resources.
    :param str display_name: A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
    :param str state: A filter to return only resources that match the given lifecycle state.  Example: `SUCCEEDED`
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApiGateway/getGateways:getGateways', __args__, opts=opts, typ=GetGatewaysResult).value

    return AwaitableGetGatewaysResult(
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        gateway_collections=pulumi.get(__ret__, 'gateway_collections'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_gateways)
def get_gateways_output(certificate_id: Optional[pulumi.Input[Optional[str]]] = None,
                        compartment_id: Optional[pulumi.Input[str]] = None,
                        display_name: Optional[pulumi.Input[Optional[str]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetGatewaysFilterArgs']]]]] = None,
                        state: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGatewaysResult]:
    """
    This data source provides the list of Gateways in Oracle Cloud Infrastructure API Gateway service.

    Returns a list of gateways.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_gateways = oci.ApiGateway.get_gateways(compartment_id=var["compartment_id"],
        certificate_id=var["oci_apigateway_certificate"]["test_certificate"]["id"],
        display_name=var["gateway_display_name"],
        state=var["gateway_state"])
    ```


    :param str certificate_id: Filter gateways by the certificate ocid.
    :param str compartment_id: The ocid of the compartment in which to list resources.
    :param str display_name: A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
    :param str state: A filter to return only resources that match the given lifecycle state.  Example: `SUCCEEDED`
    """
    ...
