# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ConfigAvailabilityConfigurationArgs',
    'ConfigConfigurationArgs',
    'ConfigConfigurationClientCertificateDetailsArgs',
    'ConfigConfigurationClientCertificateDetailsClientCertificateArgs',
    'ConfigConfigurationClientCertificateDetailsPrivateKeyArgs',
    'ConfigConfigurationDnsConfigurationArgs',
    'ConfigConfigurationNetworkConfigurationArgs',
    'ConfigConfigurationReqAuthenticationDetailsArgs',
    'ConfigConfigurationReqAuthenticationDetailsAuthHeaderArgs',
    'ConfigConfigurationRequestHeaderArgs',
    'ConfigConfigurationRequestQueryParamArgs',
    'ConfigConfigurationVerifyTextArgs',
    'ConfigMaintenanceWindowScheduleArgs',
    'ConfigScriptParameterArgs',
    'ConfigScriptParameterMonitorScriptParameterArgs',
    'ConfigVantagePointArgs',
    'DedicatedVantagePointDvpStackDetailsArgs',
    'DedicatedVantagePointMonitorStatusCountMapArgs',
    'ScriptMonitorStatusCountMapArgs',
    'ScriptParameterArgs',
    'ScriptParameterScriptParameterArgs',
    'GetDedicatedVantagePointsFilterArgs',
    'GetMonitorsFilterArgs',
    'GetScriptsFilterArgs',
    'GetVantagePointsFilterArgs',
]

@pulumi.input_type
class ConfigAvailabilityConfigurationArgs:
    def __init__(__self__, *,
                 max_allowed_failures_per_interval: Optional[pulumi.Input[int]] = None,
                 min_allowed_runs_per_interval: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] max_allowed_failures_per_interval: (Updatable) Intervals with failed runs more than this value will be classified as UNAVAILABLE.
        :param pulumi.Input[int] min_allowed_runs_per_interval: (Updatable) Intervals with runs less than this value will be classified as UNKNOWN and excluded from the availability calculations.
        """
        ConfigAvailabilityConfigurationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            max_allowed_failures_per_interval=max_allowed_failures_per_interval,
            min_allowed_runs_per_interval=min_allowed_runs_per_interval,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             max_allowed_failures_per_interval: Optional[pulumi.Input[int]] = None,
             min_allowed_runs_per_interval: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'maxAllowedFailuresPerInterval' in kwargs:
            max_allowed_failures_per_interval = kwargs['maxAllowedFailuresPerInterval']
        if 'minAllowedRunsPerInterval' in kwargs:
            min_allowed_runs_per_interval = kwargs['minAllowedRunsPerInterval']

        if max_allowed_failures_per_interval is not None:
            _setter("max_allowed_failures_per_interval", max_allowed_failures_per_interval)
        if min_allowed_runs_per_interval is not None:
            _setter("min_allowed_runs_per_interval", min_allowed_runs_per_interval)

    @property
    @pulumi.getter(name="maxAllowedFailuresPerInterval")
    def max_allowed_failures_per_interval(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Intervals with failed runs more than this value will be classified as UNAVAILABLE.
        """
        return pulumi.get(self, "max_allowed_failures_per_interval")

    @max_allowed_failures_per_interval.setter
    def max_allowed_failures_per_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_allowed_failures_per_interval", value)

    @property
    @pulumi.getter(name="minAllowedRunsPerInterval")
    def min_allowed_runs_per_interval(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Intervals with runs less than this value will be classified as UNKNOWN and excluded from the availability calculations.
        """
        return pulumi.get(self, "min_allowed_runs_per_interval")

    @min_allowed_runs_per_interval.setter
    def min_allowed_runs_per_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_allowed_runs_per_interval", value)


@pulumi.input_type
class ConfigConfigurationArgs:
    def __init__(__self__, *,
                 client_certificate_details: Optional[pulumi.Input['ConfigConfigurationClientCertificateDetailsArgs']] = None,
                 config_type: Optional[pulumi.Input[str]] = None,
                 dns_configuration: Optional[pulumi.Input['ConfigConfigurationDnsConfigurationArgs']] = None,
                 is_certificate_validation_enabled: Optional[pulumi.Input[bool]] = None,
                 is_default_snapshot_enabled: Optional[pulumi.Input[bool]] = None,
                 is_failure_retried: Optional[pulumi.Input[bool]] = None,
                 is_redirection_enabled: Optional[pulumi.Input[bool]] = None,
                 network_configuration: Optional[pulumi.Input['ConfigConfigurationNetworkConfigurationArgs']] = None,
                 req_authentication_details: Optional[pulumi.Input['ConfigConfigurationReqAuthenticationDetailsArgs']] = None,
                 req_authentication_scheme: Optional[pulumi.Input[str]] = None,
                 request_headers: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationRequestHeaderArgs']]]] = None,
                 request_method: Optional[pulumi.Input[str]] = None,
                 request_post_body: Optional[pulumi.Input[str]] = None,
                 request_query_params: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationRequestQueryParamArgs']]]] = None,
                 verify_response_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 verify_response_content: Optional[pulumi.Input[str]] = None,
                 verify_texts: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationVerifyTextArgs']]]] = None):
        """
        :param pulumi.Input['ConfigConfigurationClientCertificateDetailsArgs'] client_certificate_details: (Updatable) Details for client certificate.
        :param pulumi.Input[str] config_type: (Updatable) Type of configuration.
        :param pulumi.Input['ConfigConfigurationDnsConfigurationArgs'] dns_configuration: (Updatable) Information about the DNS settings.
        :param pulumi.Input[bool] is_certificate_validation_enabled: (Updatable) If certificate validation is enabled, then the call will fail in case of certification errors.
        :param pulumi.Input[bool] is_default_snapshot_enabled: (Updatable) If disabled, auto snapshots are not collected.
        :param pulumi.Input[bool] is_failure_retried: (Updatable) If isFailureRetried is enabled, then a failed call will be retried.
        :param pulumi.Input[bool] is_redirection_enabled: (Updatable) If redirection is enabled, then redirects will be allowed while accessing target URL.
        :param pulumi.Input['ConfigConfigurationNetworkConfigurationArgs'] network_configuration: (Updatable) Details of the network configuration.
        :param pulumi.Input['ConfigConfigurationReqAuthenticationDetailsArgs'] req_authentication_details: (Updatable) Details for request HTTP authentication.
        :param pulumi.Input[str] req_authentication_scheme: (Updatable) Request HTTP authentication scheme.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationRequestHeaderArgs']]] request_headers: (Updatable) List of request headers. Example: `[{"headerName": "content-type", "headerValue":"json"}]`
        :param pulumi.Input[str] request_method: (Updatable) Request HTTP method.
        :param pulumi.Input[str] request_post_body: (Updatable) Request post body content.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationRequestQueryParamArgs']]] request_query_params: (Updatable) List of request query params. Example: `[{"paramName": "sortOrder", "paramValue": "asc"}]`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] verify_response_codes: (Updatable) Expected HTTP response codes. For status code range, set values such as 2xx, 3xx.
        :param pulumi.Input[str] verify_response_content: (Updatable) Verify response content against regular expression based string. If response content does not match the verifyResponseContent value, then it will be considered a failure.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationVerifyTextArgs']]] verify_texts: (Updatable) Verifies all the search strings present in the response. If any search string is not present in the response, then it will be considered as a failure.
        """
        ConfigConfigurationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            client_certificate_details=client_certificate_details,
            config_type=config_type,
            dns_configuration=dns_configuration,
            is_certificate_validation_enabled=is_certificate_validation_enabled,
            is_default_snapshot_enabled=is_default_snapshot_enabled,
            is_failure_retried=is_failure_retried,
            is_redirection_enabled=is_redirection_enabled,
            network_configuration=network_configuration,
            req_authentication_details=req_authentication_details,
            req_authentication_scheme=req_authentication_scheme,
            request_headers=request_headers,
            request_method=request_method,
            request_post_body=request_post_body,
            request_query_params=request_query_params,
            verify_response_codes=verify_response_codes,
            verify_response_content=verify_response_content,
            verify_texts=verify_texts,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             client_certificate_details: Optional[pulumi.Input['ConfigConfigurationClientCertificateDetailsArgs']] = None,
             config_type: Optional[pulumi.Input[str]] = None,
             dns_configuration: Optional[pulumi.Input['ConfigConfigurationDnsConfigurationArgs']] = None,
             is_certificate_validation_enabled: Optional[pulumi.Input[bool]] = None,
             is_default_snapshot_enabled: Optional[pulumi.Input[bool]] = None,
             is_failure_retried: Optional[pulumi.Input[bool]] = None,
             is_redirection_enabled: Optional[pulumi.Input[bool]] = None,
             network_configuration: Optional[pulumi.Input['ConfigConfigurationNetworkConfigurationArgs']] = None,
             req_authentication_details: Optional[pulumi.Input['ConfigConfigurationReqAuthenticationDetailsArgs']] = None,
             req_authentication_scheme: Optional[pulumi.Input[str]] = None,
             request_headers: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationRequestHeaderArgs']]]] = None,
             request_method: Optional[pulumi.Input[str]] = None,
             request_post_body: Optional[pulumi.Input[str]] = None,
             request_query_params: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationRequestQueryParamArgs']]]] = None,
             verify_response_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             verify_response_content: Optional[pulumi.Input[str]] = None,
             verify_texts: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationVerifyTextArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'clientCertificateDetails' in kwargs:
            client_certificate_details = kwargs['clientCertificateDetails']
        if 'configType' in kwargs:
            config_type = kwargs['configType']
        if 'dnsConfiguration' in kwargs:
            dns_configuration = kwargs['dnsConfiguration']
        if 'isCertificateValidationEnabled' in kwargs:
            is_certificate_validation_enabled = kwargs['isCertificateValidationEnabled']
        if 'isDefaultSnapshotEnabled' in kwargs:
            is_default_snapshot_enabled = kwargs['isDefaultSnapshotEnabled']
        if 'isFailureRetried' in kwargs:
            is_failure_retried = kwargs['isFailureRetried']
        if 'isRedirectionEnabled' in kwargs:
            is_redirection_enabled = kwargs['isRedirectionEnabled']
        if 'networkConfiguration' in kwargs:
            network_configuration = kwargs['networkConfiguration']
        if 'reqAuthenticationDetails' in kwargs:
            req_authentication_details = kwargs['reqAuthenticationDetails']
        if 'reqAuthenticationScheme' in kwargs:
            req_authentication_scheme = kwargs['reqAuthenticationScheme']
        if 'requestHeaders' in kwargs:
            request_headers = kwargs['requestHeaders']
        if 'requestMethod' in kwargs:
            request_method = kwargs['requestMethod']
        if 'requestPostBody' in kwargs:
            request_post_body = kwargs['requestPostBody']
        if 'requestQueryParams' in kwargs:
            request_query_params = kwargs['requestQueryParams']
        if 'verifyResponseCodes' in kwargs:
            verify_response_codes = kwargs['verifyResponseCodes']
        if 'verifyResponseContent' in kwargs:
            verify_response_content = kwargs['verifyResponseContent']
        if 'verifyTexts' in kwargs:
            verify_texts = kwargs['verifyTexts']

        if client_certificate_details is not None:
            _setter("client_certificate_details", client_certificate_details)
        if config_type is not None:
            _setter("config_type", config_type)
        if dns_configuration is not None:
            _setter("dns_configuration", dns_configuration)
        if is_certificate_validation_enabled is not None:
            _setter("is_certificate_validation_enabled", is_certificate_validation_enabled)
        if is_default_snapshot_enabled is not None:
            _setter("is_default_snapshot_enabled", is_default_snapshot_enabled)
        if is_failure_retried is not None:
            _setter("is_failure_retried", is_failure_retried)
        if is_redirection_enabled is not None:
            _setter("is_redirection_enabled", is_redirection_enabled)
        if network_configuration is not None:
            _setter("network_configuration", network_configuration)
        if req_authentication_details is not None:
            _setter("req_authentication_details", req_authentication_details)
        if req_authentication_scheme is not None:
            _setter("req_authentication_scheme", req_authentication_scheme)
        if request_headers is not None:
            _setter("request_headers", request_headers)
        if request_method is not None:
            _setter("request_method", request_method)
        if request_post_body is not None:
            _setter("request_post_body", request_post_body)
        if request_query_params is not None:
            _setter("request_query_params", request_query_params)
        if verify_response_codes is not None:
            _setter("verify_response_codes", verify_response_codes)
        if verify_response_content is not None:
            _setter("verify_response_content", verify_response_content)
        if verify_texts is not None:
            _setter("verify_texts", verify_texts)

    @property
    @pulumi.getter(name="clientCertificateDetails")
    def client_certificate_details(self) -> Optional[pulumi.Input['ConfigConfigurationClientCertificateDetailsArgs']]:
        """
        (Updatable) Details for client certificate.
        """
        return pulumi.get(self, "client_certificate_details")

    @client_certificate_details.setter
    def client_certificate_details(self, value: Optional[pulumi.Input['ConfigConfigurationClientCertificateDetailsArgs']]):
        pulumi.set(self, "client_certificate_details", value)

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of configuration.
        """
        return pulumi.get(self, "config_type")

    @config_type.setter
    def config_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_type", value)

    @property
    @pulumi.getter(name="dnsConfiguration")
    def dns_configuration(self) -> Optional[pulumi.Input['ConfigConfigurationDnsConfigurationArgs']]:
        """
        (Updatable) Information about the DNS settings.
        """
        return pulumi.get(self, "dns_configuration")

    @dns_configuration.setter
    def dns_configuration(self, value: Optional[pulumi.Input['ConfigConfigurationDnsConfigurationArgs']]):
        pulumi.set(self, "dns_configuration", value)

    @property
    @pulumi.getter(name="isCertificateValidationEnabled")
    def is_certificate_validation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If certificate validation is enabled, then the call will fail in case of certification errors.
        """
        return pulumi.get(self, "is_certificate_validation_enabled")

    @is_certificate_validation_enabled.setter
    def is_certificate_validation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_certificate_validation_enabled", value)

    @property
    @pulumi.getter(name="isDefaultSnapshotEnabled")
    def is_default_snapshot_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If disabled, auto snapshots are not collected.
        """
        return pulumi.get(self, "is_default_snapshot_enabled")

    @is_default_snapshot_enabled.setter
    def is_default_snapshot_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default_snapshot_enabled", value)

    @property
    @pulumi.getter(name="isFailureRetried")
    def is_failure_retried(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If isFailureRetried is enabled, then a failed call will be retried.
        """
        return pulumi.get(self, "is_failure_retried")

    @is_failure_retried.setter
    def is_failure_retried(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_failure_retried", value)

    @property
    @pulumi.getter(name="isRedirectionEnabled")
    def is_redirection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If redirection is enabled, then redirects will be allowed while accessing target URL.
        """
        return pulumi.get(self, "is_redirection_enabled")

    @is_redirection_enabled.setter
    def is_redirection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_redirection_enabled", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['ConfigConfigurationNetworkConfigurationArgs']]:
        """
        (Updatable) Details of the network configuration.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['ConfigConfigurationNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="reqAuthenticationDetails")
    def req_authentication_details(self) -> Optional[pulumi.Input['ConfigConfigurationReqAuthenticationDetailsArgs']]:
        """
        (Updatable) Details for request HTTP authentication.
        """
        return pulumi.get(self, "req_authentication_details")

    @req_authentication_details.setter
    def req_authentication_details(self, value: Optional[pulumi.Input['ConfigConfigurationReqAuthenticationDetailsArgs']]):
        pulumi.set(self, "req_authentication_details", value)

    @property
    @pulumi.getter(name="reqAuthenticationScheme")
    def req_authentication_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Request HTTP authentication scheme.
        """
        return pulumi.get(self, "req_authentication_scheme")

    @req_authentication_scheme.setter
    def req_authentication_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "req_authentication_scheme", value)

    @property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationRequestHeaderArgs']]]]:
        """
        (Updatable) List of request headers. Example: `[{"headerName": "content-type", "headerValue":"json"}]`
        """
        return pulumi.get(self, "request_headers")

    @request_headers.setter
    def request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationRequestHeaderArgs']]]]):
        pulumi.set(self, "request_headers", value)

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Request HTTP method.
        """
        return pulumi.get(self, "request_method")

    @request_method.setter
    def request_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_method", value)

    @property
    @pulumi.getter(name="requestPostBody")
    def request_post_body(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Request post body content.
        """
        return pulumi.get(self, "request_post_body")

    @request_post_body.setter
    def request_post_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_post_body", value)

    @property
    @pulumi.getter(name="requestQueryParams")
    def request_query_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationRequestQueryParamArgs']]]]:
        """
        (Updatable) List of request query params. Example: `[{"paramName": "sortOrder", "paramValue": "asc"}]`
        """
        return pulumi.get(self, "request_query_params")

    @request_query_params.setter
    def request_query_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationRequestQueryParamArgs']]]]):
        pulumi.set(self, "request_query_params", value)

    @property
    @pulumi.getter(name="verifyResponseCodes")
    def verify_response_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Expected HTTP response codes. For status code range, set values such as 2xx, 3xx.
        """
        return pulumi.get(self, "verify_response_codes")

    @verify_response_codes.setter
    def verify_response_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "verify_response_codes", value)

    @property
    @pulumi.getter(name="verifyResponseContent")
    def verify_response_content(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Verify response content against regular expression based string. If response content does not match the verifyResponseContent value, then it will be considered a failure.
        """
        return pulumi.get(self, "verify_response_content")

    @verify_response_content.setter
    def verify_response_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verify_response_content", value)

    @property
    @pulumi.getter(name="verifyTexts")
    def verify_texts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationVerifyTextArgs']]]]:
        """
        (Updatable) Verifies all the search strings present in the response. If any search string is not present in the response, then it will be considered as a failure.
        """
        return pulumi.get(self, "verify_texts")

    @verify_texts.setter
    def verify_texts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationVerifyTextArgs']]]]):
        pulumi.set(self, "verify_texts", value)


@pulumi.input_type
class ConfigConfigurationClientCertificateDetailsArgs:
    def __init__(__self__, *,
                 client_certificate: Optional[pulumi.Input['ConfigConfigurationClientCertificateDetailsClientCertificateArgs']] = None,
                 private_key: Optional[pulumi.Input['ConfigConfigurationClientCertificateDetailsPrivateKeyArgs']] = None):
        """
        :param pulumi.Input['ConfigConfigurationClientCertificateDetailsClientCertificateArgs'] client_certificate: (Updatable) Client certificate in PEM format.
        :param pulumi.Input['ConfigConfigurationClientCertificateDetailsPrivateKeyArgs'] private_key: (Updatable) The private key associated with the client certificate in PEM format.
        """
        ConfigConfigurationClientCertificateDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            client_certificate=client_certificate,
            private_key=private_key,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             client_certificate: Optional[pulumi.Input['ConfigConfigurationClientCertificateDetailsClientCertificateArgs']] = None,
             private_key: Optional[pulumi.Input['ConfigConfigurationClientCertificateDetailsPrivateKeyArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'clientCertificate' in kwargs:
            client_certificate = kwargs['clientCertificate']
        if 'privateKey' in kwargs:
            private_key = kwargs['privateKey']

        if client_certificate is not None:
            _setter("client_certificate", client_certificate)
        if private_key is not None:
            _setter("private_key", private_key)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input['ConfigConfigurationClientCertificateDetailsClientCertificateArgs']]:
        """
        (Updatable) Client certificate in PEM format.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input['ConfigConfigurationClientCertificateDetailsClientCertificateArgs']]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input['ConfigConfigurationClientCertificateDetailsPrivateKeyArgs']]:
        """
        (Updatable) The private key associated with the client certificate in PEM format.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input['ConfigConfigurationClientCertificateDetailsPrivateKeyArgs']]):
        pulumi.set(self, "private_key", value)


@pulumi.input_type
class ConfigConfigurationClientCertificateDetailsClientCertificateArgs:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None,
                 file_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] content: (Updatable) Content of the private key file.
        :param pulumi.Input[str] file_name: (Updatable) Name of the private key file.
        """
        ConfigConfigurationClientCertificateDetailsClientCertificateArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            file_name=file_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: Optional[pulumi.Input[str]] = None,
             file_name: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'fileName' in kwargs:
            file_name = kwargs['fileName']

        if content is not None:
            _setter("content", content)
        if file_name is not None:
            _setter("file_name", file_name)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Content of the private key file.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the private key file.
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_name", value)


@pulumi.input_type
class ConfigConfigurationClientCertificateDetailsPrivateKeyArgs:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None,
                 file_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] content: (Updatable) Content of the private key file.
        :param pulumi.Input[str] file_name: (Updatable) Name of the private key file.
        """
        ConfigConfigurationClientCertificateDetailsPrivateKeyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            file_name=file_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: Optional[pulumi.Input[str]] = None,
             file_name: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'fileName' in kwargs:
            file_name = kwargs['fileName']

        if content is not None:
            _setter("content", content)
        if file_name is not None:
            _setter("file_name", file_name)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Content of the private key file.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the private key file.
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_name", value)


@pulumi.input_type
class ConfigConfigurationDnsConfigurationArgs:
    def __init__(__self__, *,
                 is_override_dns: Optional[pulumi.Input[bool]] = None,
                 override_dns_ip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] is_override_dns: (Updatable) If isOverrideDns is true, then DNS settings will be overridden.
        :param pulumi.Input[str] override_dns_ip: (Updatable) Attribute to override the DNS IP value. This value will be honored only if isOverrideDns is set to true.
        """
        ConfigConfigurationDnsConfigurationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_override_dns=is_override_dns,
            override_dns_ip=override_dns_ip,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_override_dns: Optional[pulumi.Input[bool]] = None,
             override_dns_ip: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isOverrideDns' in kwargs:
            is_override_dns = kwargs['isOverrideDns']
        if 'overrideDnsIp' in kwargs:
            override_dns_ip = kwargs['overrideDnsIp']

        if is_override_dns is not None:
            _setter("is_override_dns", is_override_dns)
        if override_dns_ip is not None:
            _setter("override_dns_ip", override_dns_ip)

    @property
    @pulumi.getter(name="isOverrideDns")
    def is_override_dns(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If isOverrideDns is true, then DNS settings will be overridden.
        """
        return pulumi.get(self, "is_override_dns")

    @is_override_dns.setter
    def is_override_dns(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_override_dns", value)

    @property
    @pulumi.getter(name="overrideDnsIp")
    def override_dns_ip(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Attribute to override the DNS IP value. This value will be honored only if isOverrideDns is set to true.
        """
        return pulumi.get(self, "override_dns_ip")

    @override_dns_ip.setter
    def override_dns_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "override_dns_ip", value)


@pulumi.input_type
class ConfigConfigurationNetworkConfigurationArgs:
    def __init__(__self__, *,
                 number_of_hops: Optional[pulumi.Input[int]] = None,
                 probe_mode: Optional[pulumi.Input[str]] = None,
                 probe_per_hop: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 transmission_rate: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] number_of_hops: (Updatable) Number of hops.
        :param pulumi.Input[str] probe_mode: (Updatable) Type of probe mode when TCP protocol is selected.
        :param pulumi.Input[int] probe_per_hop: (Updatable) Number of probes per hop.
        :param pulumi.Input[str] protocol: (Updatable) Type of protocol.
        :param pulumi.Input[int] transmission_rate: (Updatable) Number of probe packets sent out simultaneously.
        """
        ConfigConfigurationNetworkConfigurationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            number_of_hops=number_of_hops,
            probe_mode=probe_mode,
            probe_per_hop=probe_per_hop,
            protocol=protocol,
            transmission_rate=transmission_rate,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             number_of_hops: Optional[pulumi.Input[int]] = None,
             probe_mode: Optional[pulumi.Input[str]] = None,
             probe_per_hop: Optional[pulumi.Input[int]] = None,
             protocol: Optional[pulumi.Input[str]] = None,
             transmission_rate: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'numberOfHops' in kwargs:
            number_of_hops = kwargs['numberOfHops']
        if 'probeMode' in kwargs:
            probe_mode = kwargs['probeMode']
        if 'probePerHop' in kwargs:
            probe_per_hop = kwargs['probePerHop']
        if 'transmissionRate' in kwargs:
            transmission_rate = kwargs['transmissionRate']

        if number_of_hops is not None:
            _setter("number_of_hops", number_of_hops)
        if probe_mode is not None:
            _setter("probe_mode", probe_mode)
        if probe_per_hop is not None:
            _setter("probe_per_hop", probe_per_hop)
        if protocol is not None:
            _setter("protocol", protocol)
        if transmission_rate is not None:
            _setter("transmission_rate", transmission_rate)

    @property
    @pulumi.getter(name="numberOfHops")
    def number_of_hops(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Number of hops.
        """
        return pulumi.get(self, "number_of_hops")

    @number_of_hops.setter
    def number_of_hops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_hops", value)

    @property
    @pulumi.getter(name="probeMode")
    def probe_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of probe mode when TCP protocol is selected.
        """
        return pulumi.get(self, "probe_mode")

    @probe_mode.setter
    def probe_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "probe_mode", value)

    @property
    @pulumi.getter(name="probePerHop")
    def probe_per_hop(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Number of probes per hop.
        """
        return pulumi.get(self, "probe_per_hop")

    @probe_per_hop.setter
    def probe_per_hop(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "probe_per_hop", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="transmissionRate")
    def transmission_rate(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Number of probe packets sent out simultaneously.
        """
        return pulumi.get(self, "transmission_rate")

    @transmission_rate.setter
    def transmission_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "transmission_rate", value)


@pulumi.input_type
class ConfigConfigurationReqAuthenticationDetailsArgs:
    def __init__(__self__, *,
                 auth_headers: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationReqAuthenticationDetailsAuthHeaderArgs']]]] = None,
                 auth_request_method: Optional[pulumi.Input[str]] = None,
                 auth_request_post_body: Optional[pulumi.Input[str]] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 auth_url: Optional[pulumi.Input[str]] = None,
                 auth_user_name: Optional[pulumi.Input[str]] = None,
                 auth_user_password: Optional[pulumi.Input[str]] = None,
                 oauth_scheme: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationReqAuthenticationDetailsAuthHeaderArgs']]] auth_headers: (Updatable) List of authentication headers. Example: `[{"headerName": "content-type", "headerValue":"json"}]`
        :param pulumi.Input[str] auth_request_method: (Updatable) Request method.
        :param pulumi.Input[str] auth_request_post_body: (Updatable) Request post body.
        :param pulumi.Input[str] auth_token: (Updatable) Authentication token.
        :param pulumi.Input[str] auth_url: (Updatable) URL to get authentication token.
        :param pulumi.Input[str] auth_user_name: (Updatable) User name for authentication.
        :param pulumi.Input[str] auth_user_password: (Updatable) User password for authentication.
        :param pulumi.Input[str] oauth_scheme: (Updatable) Request HTTP OAuth scheme.
        """
        ConfigConfigurationReqAuthenticationDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            auth_headers=auth_headers,
            auth_request_method=auth_request_method,
            auth_request_post_body=auth_request_post_body,
            auth_token=auth_token,
            auth_url=auth_url,
            auth_user_name=auth_user_name,
            auth_user_password=auth_user_password,
            oauth_scheme=oauth_scheme,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             auth_headers: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationReqAuthenticationDetailsAuthHeaderArgs']]]] = None,
             auth_request_method: Optional[pulumi.Input[str]] = None,
             auth_request_post_body: Optional[pulumi.Input[str]] = None,
             auth_token: Optional[pulumi.Input[str]] = None,
             auth_url: Optional[pulumi.Input[str]] = None,
             auth_user_name: Optional[pulumi.Input[str]] = None,
             auth_user_password: Optional[pulumi.Input[str]] = None,
             oauth_scheme: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'authHeaders' in kwargs:
            auth_headers = kwargs['authHeaders']
        if 'authRequestMethod' in kwargs:
            auth_request_method = kwargs['authRequestMethod']
        if 'authRequestPostBody' in kwargs:
            auth_request_post_body = kwargs['authRequestPostBody']
        if 'authToken' in kwargs:
            auth_token = kwargs['authToken']
        if 'authUrl' in kwargs:
            auth_url = kwargs['authUrl']
        if 'authUserName' in kwargs:
            auth_user_name = kwargs['authUserName']
        if 'authUserPassword' in kwargs:
            auth_user_password = kwargs['authUserPassword']
        if 'oauthScheme' in kwargs:
            oauth_scheme = kwargs['oauthScheme']

        if auth_headers is not None:
            _setter("auth_headers", auth_headers)
        if auth_request_method is not None:
            _setter("auth_request_method", auth_request_method)
        if auth_request_post_body is not None:
            _setter("auth_request_post_body", auth_request_post_body)
        if auth_token is not None:
            _setter("auth_token", auth_token)
        if auth_url is not None:
            _setter("auth_url", auth_url)
        if auth_user_name is not None:
            _setter("auth_user_name", auth_user_name)
        if auth_user_password is not None:
            _setter("auth_user_password", auth_user_password)
        if oauth_scheme is not None:
            _setter("oauth_scheme", oauth_scheme)

    @property
    @pulumi.getter(name="authHeaders")
    def auth_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationReqAuthenticationDetailsAuthHeaderArgs']]]]:
        """
        (Updatable) List of authentication headers. Example: `[{"headerName": "content-type", "headerValue":"json"}]`
        """
        return pulumi.get(self, "auth_headers")

    @auth_headers.setter
    def auth_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigConfigurationReqAuthenticationDetailsAuthHeaderArgs']]]]):
        pulumi.set(self, "auth_headers", value)

    @property
    @pulumi.getter(name="authRequestMethod")
    def auth_request_method(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Request method.
        """
        return pulumi.get(self, "auth_request_method")

    @auth_request_method.setter
    def auth_request_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_request_method", value)

    @property
    @pulumi.getter(name="authRequestPostBody")
    def auth_request_post_body(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Request post body.
        """
        return pulumi.get(self, "auth_request_post_body")

    @auth_request_post_body.setter
    def auth_request_post_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_request_post_body", value)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Authentication token.
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter(name="authUrl")
    def auth_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) URL to get authentication token.
        """
        return pulumi.get(self, "auth_url")

    @auth_url.setter
    def auth_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_url", value)

    @property
    @pulumi.getter(name="authUserName")
    def auth_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User name for authentication.
        """
        return pulumi.get(self, "auth_user_name")

    @auth_user_name.setter
    def auth_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_user_name", value)

    @property
    @pulumi.getter(name="authUserPassword")
    def auth_user_password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User password for authentication.
        """
        return pulumi.get(self, "auth_user_password")

    @auth_user_password.setter
    def auth_user_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_user_password", value)

    @property
    @pulumi.getter(name="oauthScheme")
    def oauth_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Request HTTP OAuth scheme.
        """
        return pulumi.get(self, "oauth_scheme")

    @oauth_scheme.setter
    def oauth_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_scheme", value)


@pulumi.input_type
class ConfigConfigurationReqAuthenticationDetailsAuthHeaderArgs:
    def __init__(__self__, *,
                 header_name: Optional[pulumi.Input[str]] = None,
                 header_value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] header_name: (Updatable) Name of the header.
        :param pulumi.Input[str] header_value: (Updatable) Value of the header.
        """
        ConfigConfigurationReqAuthenticationDetailsAuthHeaderArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            header_name=header_name,
            header_value=header_value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             header_name: Optional[pulumi.Input[str]] = None,
             header_value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'headerName' in kwargs:
            header_name = kwargs['headerName']
        if 'headerValue' in kwargs:
            header_value = kwargs['headerValue']

        if header_name is not None:
            _setter("header_name", header_name)
        if header_value is not None:
            _setter("header_value", header_value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the header.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Value of the header.
        """
        return pulumi.get(self, "header_value")

    @header_value.setter
    def header_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_value", value)


@pulumi.input_type
class ConfigConfigurationRequestHeaderArgs:
    def __init__(__self__, *,
                 header_name: Optional[pulumi.Input[str]] = None,
                 header_value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] header_name: (Updatable) Name of the header.
        :param pulumi.Input[str] header_value: (Updatable) Value of the header.
        """
        ConfigConfigurationRequestHeaderArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            header_name=header_name,
            header_value=header_value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             header_name: Optional[pulumi.Input[str]] = None,
             header_value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'headerName' in kwargs:
            header_name = kwargs['headerName']
        if 'headerValue' in kwargs:
            header_value = kwargs['headerValue']

        if header_name is not None:
            _setter("header_name", header_name)
        if header_value is not None:
            _setter("header_value", header_value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the header.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Value of the header.
        """
        return pulumi.get(self, "header_value")

    @header_value.setter
    def header_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_value", value)


@pulumi.input_type
class ConfigConfigurationRequestQueryParamArgs:
    def __init__(__self__, *,
                 param_name: Optional[pulumi.Input[str]] = None,
                 param_value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] param_name: (Updatable) Name of the parameter.
        :param pulumi.Input[str] param_value: (Updatable) Value of the parameter.
        """
        ConfigConfigurationRequestQueryParamArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            param_name=param_name,
            param_value=param_value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             param_name: Optional[pulumi.Input[str]] = None,
             param_value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'paramName' in kwargs:
            param_name = kwargs['paramName']
        if 'paramValue' in kwargs:
            param_value = kwargs['paramValue']

        if param_name is not None:
            _setter("param_name", param_name)
        if param_value is not None:
            _setter("param_value", param_value)

    @property
    @pulumi.getter(name="paramName")
    def param_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the parameter.
        """
        return pulumi.get(self, "param_name")

    @param_name.setter
    def param_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "param_name", value)

    @property
    @pulumi.getter(name="paramValue")
    def param_value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Value of the parameter.
        """
        return pulumi.get(self, "param_value")

    @param_value.setter
    def param_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "param_value", value)


@pulumi.input_type
class ConfigConfigurationVerifyTextArgs:
    def __init__(__self__, *,
                 text: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] text: (Updatable) Verification text in the response.
        """
        ConfigConfigurationVerifyTextArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            text=text,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             text: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if text is not None:
            _setter("text", text)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Verification text in the response.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class ConfigMaintenanceWindowScheduleArgs:
    def __init__(__self__, *,
                 time_ended: Optional[pulumi.Input[str]] = None,
                 time_started: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] time_ended: (Updatable) End time of the maintenance window, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param pulumi.Input[str] time_started: (Updatable) Start time of the maintenance window, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        ConfigMaintenanceWindowScheduleArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            time_ended=time_ended,
            time_started=time_started,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             time_ended: Optional[pulumi.Input[str]] = None,
             time_started: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'timeEnded' in kwargs:
            time_ended = kwargs['timeEnded']
        if 'timeStarted' in kwargs:
            time_started = kwargs['timeStarted']

        if time_ended is not None:
            _setter("time_ended", time_ended)
        if time_started is not None:
            _setter("time_started", time_started)

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) End time of the maintenance window, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_ended")

    @time_ended.setter
    def time_ended(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_ended", value)

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Start time of the maintenance window, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_started", value)


@pulumi.input_type
class ConfigScriptParameterArgs:
    def __init__(__self__, *,
                 param_name: pulumi.Input[str],
                 param_value: pulumi.Input[str],
                 is_overwritten: Optional[pulumi.Input[bool]] = None,
                 is_secret: Optional[pulumi.Input[bool]] = None,
                 monitor_script_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigScriptParameterMonitorScriptParameterArgs']]]] = None):
        """
        :param pulumi.Input[str] param_name: (Updatable) Name of the parameter.
        :param pulumi.Input[str] param_value: (Updatable) Value of the parameter.
        :param pulumi.Input[bool] is_overwritten: If parameter value is default or overwritten.
        :param pulumi.Input[bool] is_secret: Describes if  the parameter value is secret and should be kept confidential. isSecret is specified in either CreateScript or UpdateScript API.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigScriptParameterMonitorScriptParameterArgs']]] monitor_script_parameters: Details of the script parameter that can be used to overwrite the parameter present in the script.
        """
        ConfigScriptParameterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            param_name=param_name,
            param_value=param_value,
            is_overwritten=is_overwritten,
            is_secret=is_secret,
            monitor_script_parameters=monitor_script_parameters,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             param_name: pulumi.Input[str],
             param_value: pulumi.Input[str],
             is_overwritten: Optional[pulumi.Input[bool]] = None,
             is_secret: Optional[pulumi.Input[bool]] = None,
             monitor_script_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigScriptParameterMonitorScriptParameterArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'paramName' in kwargs:
            param_name = kwargs['paramName']
        if 'paramValue' in kwargs:
            param_value = kwargs['paramValue']
        if 'isOverwritten' in kwargs:
            is_overwritten = kwargs['isOverwritten']
        if 'isSecret' in kwargs:
            is_secret = kwargs['isSecret']
        if 'monitorScriptParameters' in kwargs:
            monitor_script_parameters = kwargs['monitorScriptParameters']

        _setter("param_name", param_name)
        _setter("param_value", param_value)
        if is_overwritten is not None:
            _setter("is_overwritten", is_overwritten)
        if is_secret is not None:
            _setter("is_secret", is_secret)
        if monitor_script_parameters is not None:
            _setter("monitor_script_parameters", monitor_script_parameters)

    @property
    @pulumi.getter(name="paramName")
    def param_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of the parameter.
        """
        return pulumi.get(self, "param_name")

    @param_name.setter
    def param_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "param_name", value)

    @property
    @pulumi.getter(name="paramValue")
    def param_value(self) -> pulumi.Input[str]:
        """
        (Updatable) Value of the parameter.
        """
        return pulumi.get(self, "param_value")

    @param_value.setter
    def param_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "param_value", value)

    @property
    @pulumi.getter(name="isOverwritten")
    def is_overwritten(self) -> Optional[pulumi.Input[bool]]:
        """
        If parameter value is default or overwritten.
        """
        return pulumi.get(self, "is_overwritten")

    @is_overwritten.setter
    def is_overwritten(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_overwritten", value)

    @property
    @pulumi.getter(name="isSecret")
    def is_secret(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if  the parameter value is secret and should be kept confidential. isSecret is specified in either CreateScript or UpdateScript API.
        """
        return pulumi.get(self, "is_secret")

    @is_secret.setter
    def is_secret(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_secret", value)

    @property
    @pulumi.getter(name="monitorScriptParameters")
    def monitor_script_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigScriptParameterMonitorScriptParameterArgs']]]]:
        """
        Details of the script parameter that can be used to overwrite the parameter present in the script.
        """
        return pulumi.get(self, "monitor_script_parameters")

    @monitor_script_parameters.setter
    def monitor_script_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigScriptParameterMonitorScriptParameterArgs']]]]):
        pulumi.set(self, "monitor_script_parameters", value)


@pulumi.input_type
class ConfigScriptParameterMonitorScriptParameterArgs:
    def __init__(__self__, *,
                 param_name: Optional[pulumi.Input[str]] = None,
                 param_value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] param_name: (Updatable) Name of the parameter.
        :param pulumi.Input[str] param_value: (Updatable) Value of the parameter.
        """
        ConfigScriptParameterMonitorScriptParameterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            param_name=param_name,
            param_value=param_value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             param_name: Optional[pulumi.Input[str]] = None,
             param_value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'paramName' in kwargs:
            param_name = kwargs['paramName']
        if 'paramValue' in kwargs:
            param_value = kwargs['paramValue']

        if param_name is not None:
            _setter("param_name", param_name)
        if param_value is not None:
            _setter("param_value", param_value)

    @property
    @pulumi.getter(name="paramName")
    def param_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the parameter.
        """
        return pulumi.get(self, "param_name")

    @param_name.setter
    def param_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "param_name", value)

    @property
    @pulumi.getter(name="paramValue")
    def param_value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Value of the parameter.
        """
        return pulumi.get(self, "param_value")

    @param_value.setter
    def param_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "param_value", value)


@pulumi.input_type
class ConfigVantagePointArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Name of the vantage point.
        :param pulumi.Input[str] display_name: Unique name that can be edited. The name should not contain any confidential information.
        """
        ConfigVantagePointArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            display_name=display_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: pulumi.Input[str],
             display_name: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']

        _setter("name", name)
        if display_name is not None:
            _setter("display_name", display_name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the vantage point.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class DedicatedVantagePointDvpStackDetailsArgs:
    def __init__(__self__, *,
                 dvp_stack_id: pulumi.Input[str],
                 dvp_stack_type: pulumi.Input[str],
                 dvp_stream_id: pulumi.Input[str],
                 dvp_version: pulumi.Input[str]):
        """
        :param pulumi.Input[str] dvp_stack_id: (Updatable) Stack [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Resource Manager stack for dedicated vantage point.
        :param pulumi.Input[str] dvp_stack_type: (Updatable) Type of stack.
        :param pulumi.Input[str] dvp_stream_id: (Updatable) Stream [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Resource Manager stack for dedicated vantage point.
        :param pulumi.Input[str] dvp_version: (Updatable) Version of the dedicated vantage point.
        """
        DedicatedVantagePointDvpStackDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dvp_stack_id=dvp_stack_id,
            dvp_stack_type=dvp_stack_type,
            dvp_stream_id=dvp_stream_id,
            dvp_version=dvp_version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dvp_stack_id: pulumi.Input[str],
             dvp_stack_type: pulumi.Input[str],
             dvp_stream_id: pulumi.Input[str],
             dvp_version: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'dvpStackId' in kwargs:
            dvp_stack_id = kwargs['dvpStackId']
        if 'dvpStackType' in kwargs:
            dvp_stack_type = kwargs['dvpStackType']
        if 'dvpStreamId' in kwargs:
            dvp_stream_id = kwargs['dvpStreamId']
        if 'dvpVersion' in kwargs:
            dvp_version = kwargs['dvpVersion']

        _setter("dvp_stack_id", dvp_stack_id)
        _setter("dvp_stack_type", dvp_stack_type)
        _setter("dvp_stream_id", dvp_stream_id)
        _setter("dvp_version", dvp_version)

    @property
    @pulumi.getter(name="dvpStackId")
    def dvp_stack_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Stack [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Resource Manager stack for dedicated vantage point.
        """
        return pulumi.get(self, "dvp_stack_id")

    @dvp_stack_id.setter
    def dvp_stack_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "dvp_stack_id", value)

    @property
    @pulumi.getter(name="dvpStackType")
    def dvp_stack_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of stack.
        """
        return pulumi.get(self, "dvp_stack_type")

    @dvp_stack_type.setter
    def dvp_stack_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "dvp_stack_type", value)

    @property
    @pulumi.getter(name="dvpStreamId")
    def dvp_stream_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Stream [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Resource Manager stack for dedicated vantage point.
        """
        return pulumi.get(self, "dvp_stream_id")

    @dvp_stream_id.setter
    def dvp_stream_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "dvp_stream_id", value)

    @property
    @pulumi.getter(name="dvpVersion")
    def dvp_version(self) -> pulumi.Input[str]:
        """
        (Updatable) Version of the dedicated vantage point.
        """
        return pulumi.get(self, "dvp_version")

    @dvp_version.setter
    def dvp_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "dvp_version", value)


@pulumi.input_type
class DedicatedVantagePointMonitorStatusCountMapArgs:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[int]] = None,
                 invalid: Optional[pulumi.Input[int]] = None,
                 total: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] disabled: Number of disabled monitors using the script.
        :param pulumi.Input[int] enabled: Number of enabled monitors using the script.
        :param pulumi.Input[int] invalid: Number of invalid monitors using the script.
        :param pulumi.Input[int] total: Total number of monitors using the script.
        """
        DedicatedVantagePointMonitorStatusCountMapArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            disabled=disabled,
            enabled=enabled,
            invalid=invalid,
            total=total,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             disabled: Optional[pulumi.Input[int]] = None,
             enabled: Optional[pulumi.Input[int]] = None,
             invalid: Optional[pulumi.Input[int]] = None,
             total: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if disabled is not None:
            _setter("disabled", disabled)
        if enabled is not None:
            _setter("enabled", enabled)
        if invalid is not None:
            _setter("invalid", invalid)
        if total is not None:
            _setter("total", total)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[int]]:
        """
        Number of disabled monitors using the script.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[int]]:
        """
        Number of enabled monitors using the script.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def invalid(self) -> Optional[pulumi.Input[int]]:
        """
        Number of invalid monitors using the script.
        """
        return pulumi.get(self, "invalid")

    @invalid.setter
    def invalid(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "invalid", value)

    @property
    @pulumi.getter
    def total(self) -> Optional[pulumi.Input[int]]:
        """
        Total number of monitors using the script.
        """
        return pulumi.get(self, "total")

    @total.setter
    def total(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total", value)


@pulumi.input_type
class ScriptMonitorStatusCountMapArgs:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[int]] = None,
                 invalid: Optional[pulumi.Input[int]] = None,
                 total: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] disabled: Number of disabled monitors using the script.
        :param pulumi.Input[int] enabled: Number of enabled monitors using the script.
        :param pulumi.Input[int] invalid: Number of invalid monitors using the script.
        :param pulumi.Input[int] total: Total number of monitors using the script.
        """
        ScriptMonitorStatusCountMapArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            disabled=disabled,
            enabled=enabled,
            invalid=invalid,
            total=total,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             disabled: Optional[pulumi.Input[int]] = None,
             enabled: Optional[pulumi.Input[int]] = None,
             invalid: Optional[pulumi.Input[int]] = None,
             total: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if disabled is not None:
            _setter("disabled", disabled)
        if enabled is not None:
            _setter("enabled", enabled)
        if invalid is not None:
            _setter("invalid", invalid)
        if total is not None:
            _setter("total", total)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[int]]:
        """
        Number of disabled monitors using the script.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[int]]:
        """
        Number of enabled monitors using the script.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def invalid(self) -> Optional[pulumi.Input[int]]:
        """
        Number of invalid monitors using the script.
        """
        return pulumi.get(self, "invalid")

    @invalid.setter
    def invalid(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "invalid", value)

    @property
    @pulumi.getter
    def total(self) -> Optional[pulumi.Input[int]]:
        """
        Total number of monitors using the script.
        """
        return pulumi.get(self, "total")

    @total.setter
    def total(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total", value)


@pulumi.input_type
class ScriptParameterArgs:
    def __init__(__self__, *,
                 param_name: pulumi.Input[str],
                 is_overwritten: Optional[pulumi.Input[bool]] = None,
                 is_secret: Optional[pulumi.Input[bool]] = None,
                 param_value: Optional[pulumi.Input[str]] = None,
                 script_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ScriptParameterScriptParameterArgs']]]] = None):
        """
        :param pulumi.Input[str] param_name: (Updatable) Name of the parameter.
        :param pulumi.Input[bool] is_overwritten: If parameter value is default or overwritten.
        :param pulumi.Input[bool] is_secret: (Updatable) If the parameter value is secret and should be kept confidential, then set isSecret to true.
        :param pulumi.Input[str] param_value: (Updatable) Value of the parameter.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['ScriptParameterScriptParameterArgs']]] script_parameters: Details of the script parameters, paramName must be from the script content and these details can be used to overwrite the default parameter present in the script content.
        """
        ScriptParameterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            param_name=param_name,
            is_overwritten=is_overwritten,
            is_secret=is_secret,
            param_value=param_value,
            script_parameters=script_parameters,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             param_name: pulumi.Input[str],
             is_overwritten: Optional[pulumi.Input[bool]] = None,
             is_secret: Optional[pulumi.Input[bool]] = None,
             param_value: Optional[pulumi.Input[str]] = None,
             script_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ScriptParameterScriptParameterArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'paramName' in kwargs:
            param_name = kwargs['paramName']
        if 'isOverwritten' in kwargs:
            is_overwritten = kwargs['isOverwritten']
        if 'isSecret' in kwargs:
            is_secret = kwargs['isSecret']
        if 'paramValue' in kwargs:
            param_value = kwargs['paramValue']
        if 'scriptParameters' in kwargs:
            script_parameters = kwargs['scriptParameters']

        _setter("param_name", param_name)
        if is_overwritten is not None:
            _setter("is_overwritten", is_overwritten)
        if is_secret is not None:
            _setter("is_secret", is_secret)
        if param_value is not None:
            _setter("param_value", param_value)
        if script_parameters is not None:
            _setter("script_parameters", script_parameters)

    @property
    @pulumi.getter(name="paramName")
    def param_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of the parameter.
        """
        return pulumi.get(self, "param_name")

    @param_name.setter
    def param_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "param_name", value)

    @property
    @pulumi.getter(name="isOverwritten")
    def is_overwritten(self) -> Optional[pulumi.Input[bool]]:
        """
        If parameter value is default or overwritten.
        """
        return pulumi.get(self, "is_overwritten")

    @is_overwritten.setter
    def is_overwritten(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_overwritten", value)

    @property
    @pulumi.getter(name="isSecret")
    def is_secret(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If the parameter value is secret and should be kept confidential, then set isSecret to true.
        """
        return pulumi.get(self, "is_secret")

    @is_secret.setter
    def is_secret(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_secret", value)

    @property
    @pulumi.getter(name="paramValue")
    def param_value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Value of the parameter.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "param_value")

    @param_value.setter
    def param_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "param_value", value)

    @property
    @pulumi.getter(name="scriptParameters")
    def script_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScriptParameterScriptParameterArgs']]]]:
        """
        Details of the script parameters, paramName must be from the script content and these details can be used to overwrite the default parameter present in the script content.
        """
        return pulumi.get(self, "script_parameters")

    @script_parameters.setter
    def script_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScriptParameterScriptParameterArgs']]]]):
        pulumi.set(self, "script_parameters", value)


@pulumi.input_type
class ScriptParameterScriptParameterArgs:
    def __init__(__self__, *,
                 is_secret: Optional[pulumi.Input[bool]] = None,
                 param_name: Optional[pulumi.Input[str]] = None,
                 param_value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] is_secret: (Updatable) If the parameter value is secret and should be kept confidential, then set isSecret to true.
        :param pulumi.Input[str] param_name: (Updatable) Name of the parameter.
        :param pulumi.Input[str] param_value: (Updatable) Value of the parameter.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ScriptParameterScriptParameterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_secret=is_secret,
            param_name=param_name,
            param_value=param_value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_secret: Optional[pulumi.Input[bool]] = None,
             param_name: Optional[pulumi.Input[str]] = None,
             param_value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isSecret' in kwargs:
            is_secret = kwargs['isSecret']
        if 'paramName' in kwargs:
            param_name = kwargs['paramName']
        if 'paramValue' in kwargs:
            param_value = kwargs['paramValue']

        if is_secret is not None:
            _setter("is_secret", is_secret)
        if param_name is not None:
            _setter("param_name", param_name)
        if param_value is not None:
            _setter("param_value", param_value)

    @property
    @pulumi.getter(name="isSecret")
    def is_secret(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If the parameter value is secret and should be kept confidential, then set isSecret to true.
        """
        return pulumi.get(self, "is_secret")

    @is_secret.setter
    def is_secret(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_secret", value)

    @property
    @pulumi.getter(name="paramName")
    def param_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the parameter.
        """
        return pulumi.get(self, "param_name")

    @param_name.setter
    def param_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "param_name", value)

    @property
    @pulumi.getter(name="paramValue")
    def param_value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Value of the parameter.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "param_value")

    @param_value.setter
    def param_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "param_value", value)


@pulumi.input_type
class GetDedicatedVantagePointsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only the resources that match the entire name.
        """
        GetDedicatedVantagePointsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only the resources that match the entire name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetMonitorsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of the vantage point.
        """
        GetMonitorsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the vantage point.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetScriptsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetScriptsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetVantagePointsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only the resources that match the entire name.
        """
        GetVantagePointsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only the resources that match the entire name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


