# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BlockchainPlatformComponentDetail',
    'BlockchainPlatformComponentDetailOsn',
    'BlockchainPlatformComponentDetailOsnOcpuAllocationParam',
    'BlockchainPlatformComponentDetailPeer',
    'BlockchainPlatformComponentDetailPeerOcpuAllocationParam',
    'BlockchainPlatformHostOcpuUtilizationInfo',
    'BlockchainPlatformReplicas',
    'OsnOcpuAllocationParam',
    'PeerOcpuAllocationParam',
    'GetBlockchainPlatformComponentDetailResult',
    'GetBlockchainPlatformComponentDetailOsnResult',
    'GetBlockchainPlatformComponentDetailOsnOcpuAllocationParamResult',
    'GetBlockchainPlatformComponentDetailPeerResult',
    'GetBlockchainPlatformComponentDetailPeerOcpuAllocationParamResult',
    'GetBlockchainPlatformHostOcpuUtilizationInfoResult',
    'GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionResult',
    'GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemResult',
    'GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemItemResult',
    'GetBlockchainPlatformPatchesFilterResult',
    'GetBlockchainPlatformReplicaResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnOcpuAllocationParamResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerOcpuAllocationParamResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemHostOcpuUtilizationInfoResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemReplicaResult',
    'GetBlockchainPlatformsFilterResult',
    'GetOsnOcpuAllocationParamResult',
    'GetOsnsFilterResult',
    'GetOsnsOsnCollectionResult',
    'GetOsnsOsnCollectionItemResult',
    'GetOsnsOsnCollectionItemOcpuAllocationParamResult',
    'GetPeerOcpuAllocationParamResult',
    'GetPeersFilterResult',
    'GetPeersPeerCollectionResult',
    'GetPeersPeerCollectionItemResult',
    'GetPeersPeerCollectionItemOcpuAllocationParamResult',
]

@pulumi.output_type
class BlockchainPlatformComponentDetail(dict):
    def __init__(__self__, *,
                 osns: Optional[Sequence['outputs.BlockchainPlatformComponentDetailOsn']] = None,
                 peers: Optional[Sequence['outputs.BlockchainPlatformComponentDetailPeer']] = None):
        """
        :param Sequence['BlockchainPlatformComponentDetailOsnArgs'] osns: List of OSNs
        :param Sequence['BlockchainPlatformComponentDetailPeerArgs'] peers: List of Peers
        """
        BlockchainPlatformComponentDetail._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            osns=osns,
            peers=peers,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             osns: Optional[Sequence['outputs.BlockchainPlatformComponentDetailOsn']] = None,
             peers: Optional[Sequence['outputs.BlockchainPlatformComponentDetailPeer']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if osns is not None:
            _setter("osns", osns)
        if peers is not None:
            _setter("peers", peers)

    @property
    @pulumi.getter
    def osns(self) -> Optional[Sequence['outputs.BlockchainPlatformComponentDetailOsn']]:
        """
        List of OSNs
        """
        return pulumi.get(self, "osns")

    @property
    @pulumi.getter
    def peers(self) -> Optional[Sequence['outputs.BlockchainPlatformComponentDetailPeer']]:
        """
        List of Peers
        """
        return pulumi.get(self, "peers")


@pulumi.output_type
class BlockchainPlatformComponentDetailOsn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocpuAllocationParams":
            suggest = "ocpu_allocation_params"
        elif key == "osnKey":
            suggest = "osn_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainPlatformComponentDetailOsn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainPlatformComponentDetailOsn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainPlatformComponentDetailOsn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad: Optional[str] = None,
                 ocpu_allocation_params: Optional[Sequence['outputs.BlockchainPlatformComponentDetailOsnOcpuAllocationParam']] = None,
                 osn_key: Optional[str] = None,
                 state: Optional[str] = None):
        """
        :param str ad: Availability Domain of peer
        :param Sequence['BlockchainPlatformComponentDetailOsnOcpuAllocationParamArgs'] ocpu_allocation_params: OCPU allocation parameter
        :param str osn_key: OSN identifier
        :param str state: The current state of the Platform Instance.
        """
        BlockchainPlatformComponentDetailOsn._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ad=ad,
            ocpu_allocation_params=ocpu_allocation_params,
            osn_key=osn_key,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ad: Optional[str] = None,
             ocpu_allocation_params: Optional[Sequence['outputs.BlockchainPlatformComponentDetailOsnOcpuAllocationParam']] = None,
             osn_key: Optional[str] = None,
             state: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationParams' in kwargs:
            ocpu_allocation_params = kwargs['ocpuAllocationParams']
        if 'osnKey' in kwargs:
            osn_key = kwargs['osnKey']

        if ad is not None:
            _setter("ad", ad)
        if ocpu_allocation_params is not None:
            _setter("ocpu_allocation_params", ocpu_allocation_params)
        if osn_key is not None:
            _setter("osn_key", osn_key)
        if state is not None:
            _setter("state", state)

    @property
    @pulumi.getter
    def ad(self) -> Optional[str]:
        """
        Availability Domain of peer
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter(name="ocpuAllocationParams")
    def ocpu_allocation_params(self) -> Optional[Sequence['outputs.BlockchainPlatformComponentDetailOsnOcpuAllocationParam']]:
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_params")

    @property
    @pulumi.getter(name="osnKey")
    def osn_key(self) -> Optional[str]:
        """
        OSN identifier
        """
        return pulumi.get(self, "osn_key")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Platform Instance.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class BlockchainPlatformComponentDetailOsnOcpuAllocationParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocpuAllocationNumber":
            suggest = "ocpu_allocation_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainPlatformComponentDetailOsnOcpuAllocationParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainPlatformComponentDetailOsnOcpuAllocationParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainPlatformComponentDetailOsnOcpuAllocationParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ocpu_allocation_number: Optional[float] = None):
        """
        :param float ocpu_allocation_number: Number of OCPU allocation
        """
        BlockchainPlatformComponentDetailOsnOcpuAllocationParam._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ocpu_allocation_number=ocpu_allocation_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ocpu_allocation_number: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationNumber' in kwargs:
            ocpu_allocation_number = kwargs['ocpuAllocationNumber']

        if ocpu_allocation_number is not None:
            _setter("ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> Optional[float]:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class BlockchainPlatformComponentDetailPeer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocpuAllocationParams":
            suggest = "ocpu_allocation_params"
        elif key == "peerKey":
            suggest = "peer_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainPlatformComponentDetailPeer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainPlatformComponentDetailPeer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainPlatformComponentDetailPeer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad: Optional[str] = None,
                 alias: Optional[str] = None,
                 host: Optional[str] = None,
                 ocpu_allocation_params: Optional[Sequence['outputs.BlockchainPlatformComponentDetailPeerOcpuAllocationParam']] = None,
                 peer_key: Optional[str] = None,
                 role: Optional[str] = None,
                 state: Optional[str] = None):
        """
        :param str ad: Availability Domain of peer
        :param str alias: peer alias
        :param str host: Host name of VM
        :param Sequence['BlockchainPlatformComponentDetailPeerOcpuAllocationParamArgs'] ocpu_allocation_params: OCPU allocation parameter
        :param str peer_key: peer identifier
        :param str role: Peer role
        :param str state: The current state of the Platform Instance.
        """
        BlockchainPlatformComponentDetailPeer._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ad=ad,
            alias=alias,
            host=host,
            ocpu_allocation_params=ocpu_allocation_params,
            peer_key=peer_key,
            role=role,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ad: Optional[str] = None,
             alias: Optional[str] = None,
             host: Optional[str] = None,
             ocpu_allocation_params: Optional[Sequence['outputs.BlockchainPlatformComponentDetailPeerOcpuAllocationParam']] = None,
             peer_key: Optional[str] = None,
             role: Optional[str] = None,
             state: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationParams' in kwargs:
            ocpu_allocation_params = kwargs['ocpuAllocationParams']
        if 'peerKey' in kwargs:
            peer_key = kwargs['peerKey']

        if ad is not None:
            _setter("ad", ad)
        if alias is not None:
            _setter("alias", alias)
        if host is not None:
            _setter("host", host)
        if ocpu_allocation_params is not None:
            _setter("ocpu_allocation_params", ocpu_allocation_params)
        if peer_key is not None:
            _setter("peer_key", peer_key)
        if role is not None:
            _setter("role", role)
        if state is not None:
            _setter("state", state)

    @property
    @pulumi.getter
    def ad(self) -> Optional[str]:
        """
        Availability Domain of peer
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter
    def alias(self) -> Optional[str]:
        """
        peer alias
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        Host name of VM
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ocpuAllocationParams")
    def ocpu_allocation_params(self) -> Optional[Sequence['outputs.BlockchainPlatformComponentDetailPeerOcpuAllocationParam']]:
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_params")

    @property
    @pulumi.getter(name="peerKey")
    def peer_key(self) -> Optional[str]:
        """
        peer identifier
        """
        return pulumi.get(self, "peer_key")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        Peer role
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Platform Instance.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class BlockchainPlatformComponentDetailPeerOcpuAllocationParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocpuAllocationNumber":
            suggest = "ocpu_allocation_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainPlatformComponentDetailPeerOcpuAllocationParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainPlatformComponentDetailPeerOcpuAllocationParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainPlatformComponentDetailPeerOcpuAllocationParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ocpu_allocation_number: Optional[float] = None):
        """
        :param float ocpu_allocation_number: Number of OCPU allocation
        """
        BlockchainPlatformComponentDetailPeerOcpuAllocationParam._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ocpu_allocation_number=ocpu_allocation_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ocpu_allocation_number: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationNumber' in kwargs:
            ocpu_allocation_number = kwargs['ocpuAllocationNumber']

        if ocpu_allocation_number is not None:
            _setter("ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> Optional[float]:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class BlockchainPlatformHostOcpuUtilizationInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocpuCapacityNumber":
            suggest = "ocpu_capacity_number"
        elif key == "ocpuUtilizationNumber":
            suggest = "ocpu_utilization_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainPlatformHostOcpuUtilizationInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainPlatformHostOcpuUtilizationInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainPlatformHostOcpuUtilizationInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: Optional[str] = None,
                 ocpu_capacity_number: Optional[float] = None,
                 ocpu_utilization_number: Optional[float] = None):
        """
        :param str host: Host name of VM
        :param float ocpu_capacity_number: Number of total OCPU capacity on the host
        :param float ocpu_utilization_number: Number of OCPU utilized
        """
        BlockchainPlatformHostOcpuUtilizationInfo._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            host=host,
            ocpu_capacity_number=ocpu_capacity_number,
            ocpu_utilization_number=ocpu_utilization_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             host: Optional[str] = None,
             ocpu_capacity_number: Optional[float] = None,
             ocpu_utilization_number: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuCapacityNumber' in kwargs:
            ocpu_capacity_number = kwargs['ocpuCapacityNumber']
        if 'ocpuUtilizationNumber' in kwargs:
            ocpu_utilization_number = kwargs['ocpuUtilizationNumber']

        if host is not None:
            _setter("host", host)
        if ocpu_capacity_number is not None:
            _setter("ocpu_capacity_number", ocpu_capacity_number)
        if ocpu_utilization_number is not None:
            _setter("ocpu_utilization_number", ocpu_utilization_number)

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        Host name of VM
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ocpuCapacityNumber")
    def ocpu_capacity_number(self) -> Optional[float]:
        """
        Number of total OCPU capacity on the host
        """
        return pulumi.get(self, "ocpu_capacity_number")

    @property
    @pulumi.getter(name="ocpuUtilizationNumber")
    def ocpu_utilization_number(self) -> Optional[float]:
        """
        Number of OCPU utilized
        """
        return pulumi.get(self, "ocpu_utilization_number")


@pulumi.output_type
class BlockchainPlatformReplicas(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCount":
            suggest = "ca_count"
        elif key == "consoleCount":
            suggest = "console_count"
        elif key == "proxyCount":
            suggest = "proxy_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainPlatformReplicas. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainPlatformReplicas.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainPlatformReplicas.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_count: Optional[int] = None,
                 console_count: Optional[int] = None,
                 proxy_count: Optional[int] = None):
        """
        :param int ca_count: Number of CA replicas
        :param int console_count: Number of console replicas
        :param int proxy_count: Number of REST proxy replicas
        """
        BlockchainPlatformReplicas._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ca_count=ca_count,
            console_count=console_count,
            proxy_count=proxy_count,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ca_count: Optional[int] = None,
             console_count: Optional[int] = None,
             proxy_count: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'caCount' in kwargs:
            ca_count = kwargs['caCount']
        if 'consoleCount' in kwargs:
            console_count = kwargs['consoleCount']
        if 'proxyCount' in kwargs:
            proxy_count = kwargs['proxyCount']

        if ca_count is not None:
            _setter("ca_count", ca_count)
        if console_count is not None:
            _setter("console_count", console_count)
        if proxy_count is not None:
            _setter("proxy_count", proxy_count)

    @property
    @pulumi.getter(name="caCount")
    def ca_count(self) -> Optional[int]:
        """
        Number of CA replicas
        """
        return pulumi.get(self, "ca_count")

    @property
    @pulumi.getter(name="consoleCount")
    def console_count(self) -> Optional[int]:
        """
        Number of console replicas
        """
        return pulumi.get(self, "console_count")

    @property
    @pulumi.getter(name="proxyCount")
    def proxy_count(self) -> Optional[int]:
        """
        Number of REST proxy replicas
        """
        return pulumi.get(self, "proxy_count")


@pulumi.output_type
class OsnOcpuAllocationParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocpuAllocationNumber":
            suggest = "ocpu_allocation_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsnOcpuAllocationParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsnOcpuAllocationParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsnOcpuAllocationParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ocpu_allocation_number: float):
        """
        :param float ocpu_allocation_number: (Updatable) Number of OCPU allocation
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        OsnOcpuAllocationParam._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ocpu_allocation_number=ocpu_allocation_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ocpu_allocation_number: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationNumber' in kwargs:
            ocpu_allocation_number = kwargs['ocpuAllocationNumber']

        _setter("ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> float:
        """
        (Updatable) Number of OCPU allocation


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class PeerOcpuAllocationParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocpuAllocationNumber":
            suggest = "ocpu_allocation_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PeerOcpuAllocationParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PeerOcpuAllocationParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PeerOcpuAllocationParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ocpu_allocation_number: float):
        """
        :param float ocpu_allocation_number: (Updatable) Number of OCPU allocation
        """
        PeerOcpuAllocationParam._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ocpu_allocation_number=ocpu_allocation_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ocpu_allocation_number: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationNumber' in kwargs:
            ocpu_allocation_number = kwargs['ocpuAllocationNumber']

        _setter("ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> float:
        """
        (Updatable) Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetBlockchainPlatformComponentDetailResult(dict):
    def __init__(__self__, *,
                 osns: Sequence['outputs.GetBlockchainPlatformComponentDetailOsnResult'],
                 peers: Sequence['outputs.GetBlockchainPlatformComponentDetailPeerResult']):
        """
        :param Sequence['GetBlockchainPlatformComponentDetailOsnArgs'] osns: List of OSNs
        :param Sequence['GetBlockchainPlatformComponentDetailPeerArgs'] peers: List of Peers
        """
        GetBlockchainPlatformComponentDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            osns=osns,
            peers=peers,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             osns: Sequence['outputs.GetBlockchainPlatformComponentDetailOsnResult'],
             peers: Sequence['outputs.GetBlockchainPlatformComponentDetailPeerResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("osns", osns)
        _setter("peers", peers)

    @property
    @pulumi.getter
    def osns(self) -> Sequence['outputs.GetBlockchainPlatformComponentDetailOsnResult']:
        """
        List of OSNs
        """
        return pulumi.get(self, "osns")

    @property
    @pulumi.getter
    def peers(self) -> Sequence['outputs.GetBlockchainPlatformComponentDetailPeerResult']:
        """
        List of Peers
        """
        return pulumi.get(self, "peers")


@pulumi.output_type
class GetBlockchainPlatformComponentDetailOsnResult(dict):
    def __init__(__self__, *,
                 ad: str,
                 ocpu_allocation_params: Sequence['outputs.GetBlockchainPlatformComponentDetailOsnOcpuAllocationParamResult'],
                 osn_key: str,
                 state: str):
        """
        :param str ad: Availability Domain of peer
        :param Sequence['GetBlockchainPlatformComponentDetailOsnOcpuAllocationParamArgs'] ocpu_allocation_params: OCPU allocation parameter
        :param str osn_key: OSN identifier
        :param str state: The current state of the Platform Instance.
        """
        GetBlockchainPlatformComponentDetailOsnResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ad=ad,
            ocpu_allocation_params=ocpu_allocation_params,
            osn_key=osn_key,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ad: str,
             ocpu_allocation_params: Sequence['outputs.GetBlockchainPlatformComponentDetailOsnOcpuAllocationParamResult'],
             osn_key: str,
             state: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationParams' in kwargs:
            ocpu_allocation_params = kwargs['ocpuAllocationParams']
        if 'osnKey' in kwargs:
            osn_key = kwargs['osnKey']

        _setter("ad", ad)
        _setter("ocpu_allocation_params", ocpu_allocation_params)
        _setter("osn_key", osn_key)
        _setter("state", state)

    @property
    @pulumi.getter
    def ad(self) -> str:
        """
        Availability Domain of peer
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter(name="ocpuAllocationParams")
    def ocpu_allocation_params(self) -> Sequence['outputs.GetBlockchainPlatformComponentDetailOsnOcpuAllocationParamResult']:
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_params")

    @property
    @pulumi.getter(name="osnKey")
    def osn_key(self) -> str:
        """
        OSN identifier
        """
        return pulumi.get(self, "osn_key")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Platform Instance.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetBlockchainPlatformComponentDetailOsnOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: float):
        """
        :param float ocpu_allocation_number: Number of OCPU allocation
        """
        GetBlockchainPlatformComponentDetailOsnOcpuAllocationParamResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ocpu_allocation_number=ocpu_allocation_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ocpu_allocation_number: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationNumber' in kwargs:
            ocpu_allocation_number = kwargs['ocpuAllocationNumber']

        _setter("ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetBlockchainPlatformComponentDetailPeerResult(dict):
    def __init__(__self__, *,
                 ad: str,
                 alias: str,
                 host: str,
                 ocpu_allocation_params: Sequence['outputs.GetBlockchainPlatformComponentDetailPeerOcpuAllocationParamResult'],
                 peer_key: str,
                 role: str,
                 state: str):
        """
        :param str ad: Availability Domain of peer
        :param str alias: peer alias
        :param str host: Host name of VM
        :param Sequence['GetBlockchainPlatformComponentDetailPeerOcpuAllocationParamArgs'] ocpu_allocation_params: OCPU allocation parameter
        :param str peer_key: peer identifier
        :param str role: Peer role
        :param str state: The current state of the Platform Instance.
        """
        GetBlockchainPlatformComponentDetailPeerResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ad=ad,
            alias=alias,
            host=host,
            ocpu_allocation_params=ocpu_allocation_params,
            peer_key=peer_key,
            role=role,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ad: str,
             alias: str,
             host: str,
             ocpu_allocation_params: Sequence['outputs.GetBlockchainPlatformComponentDetailPeerOcpuAllocationParamResult'],
             peer_key: str,
             role: str,
             state: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationParams' in kwargs:
            ocpu_allocation_params = kwargs['ocpuAllocationParams']
        if 'peerKey' in kwargs:
            peer_key = kwargs['peerKey']

        _setter("ad", ad)
        _setter("alias", alias)
        _setter("host", host)
        _setter("ocpu_allocation_params", ocpu_allocation_params)
        _setter("peer_key", peer_key)
        _setter("role", role)
        _setter("state", state)

    @property
    @pulumi.getter
    def ad(self) -> str:
        """
        Availability Domain of peer
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter
    def alias(self) -> str:
        """
        peer alias
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Host name of VM
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ocpuAllocationParams")
    def ocpu_allocation_params(self) -> Sequence['outputs.GetBlockchainPlatformComponentDetailPeerOcpuAllocationParamResult']:
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_params")

    @property
    @pulumi.getter(name="peerKey")
    def peer_key(self) -> str:
        """
        peer identifier
        """
        return pulumi.get(self, "peer_key")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Peer role
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Platform Instance.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetBlockchainPlatformComponentDetailPeerOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: float):
        """
        :param float ocpu_allocation_number: Number of OCPU allocation
        """
        GetBlockchainPlatformComponentDetailPeerOcpuAllocationParamResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ocpu_allocation_number=ocpu_allocation_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ocpu_allocation_number: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationNumber' in kwargs:
            ocpu_allocation_number = kwargs['ocpuAllocationNumber']

        _setter("ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetBlockchainPlatformHostOcpuUtilizationInfoResult(dict):
    def __init__(__self__, *,
                 host: str,
                 ocpu_capacity_number: float,
                 ocpu_utilization_number: float):
        """
        :param str host: Host name of VM
        :param float ocpu_capacity_number: Number of total OCPU capacity on the host
        :param float ocpu_utilization_number: Number of OCPU utilized
        """
        GetBlockchainPlatformHostOcpuUtilizationInfoResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            host=host,
            ocpu_capacity_number=ocpu_capacity_number,
            ocpu_utilization_number=ocpu_utilization_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             host: str,
             ocpu_capacity_number: float,
             ocpu_utilization_number: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuCapacityNumber' in kwargs:
            ocpu_capacity_number = kwargs['ocpuCapacityNumber']
        if 'ocpuUtilizationNumber' in kwargs:
            ocpu_utilization_number = kwargs['ocpuUtilizationNumber']

        _setter("host", host)
        _setter("ocpu_capacity_number", ocpu_capacity_number)
        _setter("ocpu_utilization_number", ocpu_utilization_number)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Host name of VM
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ocpuCapacityNumber")
    def ocpu_capacity_number(self) -> float:
        """
        Number of total OCPU capacity on the host
        """
        return pulumi.get(self, "ocpu_capacity_number")

    @property
    @pulumi.getter(name="ocpuUtilizationNumber")
    def ocpu_utilization_number(self) -> float:
        """
        Number of OCPU utilized
        """
        return pulumi.get(self, "ocpu_utilization_number")


@pulumi.output_type
class GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemResult']):
        """
        :param Sequence['GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemArgs'] items: Collection of PatchSummary
        """
        GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemResult']:
        """
        Collection of PatchSummary
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemItemResult']):
        """
        :param Sequence['GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemItemArgs'] items: Collection of PatchSummary
        """
        GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemItemResult']:
        """
        Collection of PatchSummary
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemItemResult(dict):
    def __init__(__self__, *,
                 id: str,
                 patch_info_url: str,
                 service_version: str,
                 time_patch_due: str):
        """
        :param str id: patch id
        :param str patch_info_url: A URL for the patch specific documentation
        :param str service_version: patch service version
        :param str time_patch_due: patch due date for customer initiated patching
        """
        GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            id=id,
            patch_info_url=patch_info_url,
            service_version=service_version,
            time_patch_due=time_patch_due,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             id: str,
             patch_info_url: str,
             service_version: str,
             time_patch_due: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'patchInfoUrl' in kwargs:
            patch_info_url = kwargs['patchInfoUrl']
        if 'serviceVersion' in kwargs:
            service_version = kwargs['serviceVersion']
        if 'timePatchDue' in kwargs:
            time_patch_due = kwargs['timePatchDue']

        _setter("id", id)
        _setter("patch_info_url", patch_info_url)
        _setter("service_version", service_version)
        _setter("time_patch_due", time_patch_due)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        patch id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="patchInfoUrl")
    def patch_info_url(self) -> str:
        """
        A URL for the patch specific documentation
        """
        return pulumi.get(self, "patch_info_url")

    @property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> str:
        """
        patch service version
        """
        return pulumi.get(self, "service_version")

    @property
    @pulumi.getter(name="timePatchDue")
    def time_patch_due(self) -> str:
        """
        patch due date for customer initiated patching
        """
        return pulumi.get(self, "time_patch_due")


@pulumi.output_type
class GetBlockchainPlatformPatchesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetBlockchainPlatformPatchesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetBlockchainPlatformReplicaResult(dict):
    def __init__(__self__, *,
                 ca_count: int,
                 console_count: int,
                 proxy_count: int):
        """
        :param int ca_count: Number of CA replicas
        :param int console_count: Number of console replicas
        :param int proxy_count: Number of REST proxy replicas
        """
        GetBlockchainPlatformReplicaResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ca_count=ca_count,
            console_count=console_count,
            proxy_count=proxy_count,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ca_count: int,
             console_count: int,
             proxy_count: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'caCount' in kwargs:
            ca_count = kwargs['caCount']
        if 'consoleCount' in kwargs:
            console_count = kwargs['consoleCount']
        if 'proxyCount' in kwargs:
            proxy_count = kwargs['proxyCount']

        _setter("ca_count", ca_count)
        _setter("console_count", console_count)
        _setter("proxy_count", proxy_count)

    @property
    @pulumi.getter(name="caCount")
    def ca_count(self) -> int:
        """
        Number of CA replicas
        """
        return pulumi.get(self, "ca_count")

    @property
    @pulumi.getter(name="consoleCount")
    def console_count(self) -> int:
        """
        Number of console replicas
        """
        return pulumi.get(self, "console_count")

    @property
    @pulumi.getter(name="proxyCount")
    def proxy_count(self) -> int:
        """
        Number of REST proxy replicas
        """
        return pulumi.get(self, "proxy_count")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemResult']):
        GetBlockchainPlatformsBlockchainPlatformCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemResult(dict):
    def __init__(__self__, *,
                 ca_cert_archive_text: str,
                 compartment_id: str,
                 component_details: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailResult'],
                 compute_shape: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 federated_user_id: str,
                 freeform_tags: Mapping[str, Any],
                 host_ocpu_utilization_infos: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemHostOcpuUtilizationInfoResult'],
                 id: str,
                 idcs_access_token: str,
                 is_byol: bool,
                 is_multi_ad: bool,
                 lifecycle_details: str,
                 load_balancer_shape: str,
                 platform_role: str,
                 platform_shape_type: str,
                 platform_version: str,
                 replicas: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemReplicaResult'],
                 service_endpoint: str,
                 service_version: str,
                 state: str,
                 storage_size_in_tbs: float,
                 storage_used_in_tbs: float,
                 time_created: str,
                 time_updated: str,
                 total_ocpu_capacity: int):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence['GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailArgs'] component_details: Blockchain Platform component details.
        :param str compute_shape: Compute shape - STANDARD or ENTERPRISE_SMALL or ENTERPRISE_MEDIUM or ENTERPRISE_LARGE or ENTERPRISE_EXTRA_LARGE or ENTERPRISE_CUSTOM
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: Platform Instance Description
        :param str display_name: A user-friendly name. Does not have to be unique, and it's changeable. Example: `My new resource`
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param Sequence['GetBlockchainPlatformsBlockchainPlatformCollectionItemHostOcpuUtilizationInfoArgs'] host_ocpu_utilization_infos: List of OcpuUtilization for all hosts
        :param str id: unique identifier that is immutable on creation
        :param bool is_byol: Bring your own license
        :param bool is_multi_ad: True for multi-AD blockchain plaforms, false for single-AD
        :param str lifecycle_details: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str load_balancer_shape: Type of Load Balancer shape - LB_100_MBPS or LB_400_MBPS. Default is LB_100_MBPS.
        :param str platform_role: Role of platform - FOUNDER or PARTICIPANT
        :param str platform_shape_type: Type of Platform shape - DEFAULT or CUSTOM
        :param str platform_version: Platform Version
        :param Sequence['GetBlockchainPlatformsBlockchainPlatformCollectionItemReplicaArgs'] replicas: Number of replicas of service components like Rest Proxy, CA and Console
        :param str service_endpoint: Service endpoint URL, valid post-provisioning
        :param str service_version: The version of the Platform Instance.
        :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        :param float storage_size_in_tbs: Storage size in TBs
        :param float storage_used_in_tbs: Storage used in TBs
        :param str time_created: The time the the Platform Instance was created. An RFC3339 formatted datetime string
        :param str time_updated: The time the Platform Instance was updated. An RFC3339 formatted datetime string
        :param int total_ocpu_capacity: Number of total OCPUs allocated to the platform cluster
        """
        GetBlockchainPlatformsBlockchainPlatformCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ca_cert_archive_text=ca_cert_archive_text,
            compartment_id=compartment_id,
            component_details=component_details,
            compute_shape=compute_shape,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            federated_user_id=federated_user_id,
            freeform_tags=freeform_tags,
            host_ocpu_utilization_infos=host_ocpu_utilization_infos,
            id=id,
            idcs_access_token=idcs_access_token,
            is_byol=is_byol,
            is_multi_ad=is_multi_ad,
            lifecycle_details=lifecycle_details,
            load_balancer_shape=load_balancer_shape,
            platform_role=platform_role,
            platform_shape_type=platform_shape_type,
            platform_version=platform_version,
            replicas=replicas,
            service_endpoint=service_endpoint,
            service_version=service_version,
            state=state,
            storage_size_in_tbs=storage_size_in_tbs,
            storage_used_in_tbs=storage_used_in_tbs,
            time_created=time_created,
            time_updated=time_updated,
            total_ocpu_capacity=total_ocpu_capacity,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ca_cert_archive_text: str,
             compartment_id: str,
             component_details: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailResult'],
             compute_shape: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             federated_user_id: str,
             freeform_tags: Mapping[str, Any],
             host_ocpu_utilization_infos: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemHostOcpuUtilizationInfoResult'],
             id: str,
             idcs_access_token: str,
             is_byol: bool,
             is_multi_ad: bool,
             lifecycle_details: str,
             load_balancer_shape: str,
             platform_role: str,
             platform_shape_type: str,
             platform_version: str,
             replicas: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemReplicaResult'],
             service_endpoint: str,
             service_version: str,
             state: str,
             storage_size_in_tbs: float,
             storage_used_in_tbs: float,
             time_created: str,
             time_updated: str,
             total_ocpu_capacity: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'caCertArchiveText' in kwargs:
            ca_cert_archive_text = kwargs['caCertArchiveText']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'componentDetails' in kwargs:
            component_details = kwargs['componentDetails']
        if 'computeShape' in kwargs:
            compute_shape = kwargs['computeShape']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'federatedUserId' in kwargs:
            federated_user_id = kwargs['federatedUserId']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'hostOcpuUtilizationInfos' in kwargs:
            host_ocpu_utilization_infos = kwargs['hostOcpuUtilizationInfos']
        if 'idcsAccessToken' in kwargs:
            idcs_access_token = kwargs['idcsAccessToken']
        if 'isByol' in kwargs:
            is_byol = kwargs['isByol']
        if 'isMultiAd' in kwargs:
            is_multi_ad = kwargs['isMultiAd']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'loadBalancerShape' in kwargs:
            load_balancer_shape = kwargs['loadBalancerShape']
        if 'platformRole' in kwargs:
            platform_role = kwargs['platformRole']
        if 'platformShapeType' in kwargs:
            platform_shape_type = kwargs['platformShapeType']
        if 'platformVersion' in kwargs:
            platform_version = kwargs['platformVersion']
        if 'serviceEndpoint' in kwargs:
            service_endpoint = kwargs['serviceEndpoint']
        if 'serviceVersion' in kwargs:
            service_version = kwargs['serviceVersion']
        if 'storageSizeInTbs' in kwargs:
            storage_size_in_tbs = kwargs['storageSizeInTbs']
        if 'storageUsedInTbs' in kwargs:
            storage_used_in_tbs = kwargs['storageUsedInTbs']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'totalOcpuCapacity' in kwargs:
            total_ocpu_capacity = kwargs['totalOcpuCapacity']

        _setter("ca_cert_archive_text", ca_cert_archive_text)
        _setter("compartment_id", compartment_id)
        _setter("component_details", component_details)
        _setter("compute_shape", compute_shape)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("federated_user_id", federated_user_id)
        _setter("freeform_tags", freeform_tags)
        _setter("host_ocpu_utilization_infos", host_ocpu_utilization_infos)
        _setter("id", id)
        _setter("idcs_access_token", idcs_access_token)
        _setter("is_byol", is_byol)
        _setter("is_multi_ad", is_multi_ad)
        _setter("lifecycle_details", lifecycle_details)
        _setter("load_balancer_shape", load_balancer_shape)
        _setter("platform_role", platform_role)
        _setter("platform_shape_type", platform_shape_type)
        _setter("platform_version", platform_version)
        _setter("replicas", replicas)
        _setter("service_endpoint", service_endpoint)
        _setter("service_version", service_version)
        _setter("state", state)
        _setter("storage_size_in_tbs", storage_size_in_tbs)
        _setter("storage_used_in_tbs", storage_used_in_tbs)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("total_ocpu_capacity", total_ocpu_capacity)

    @property
    @pulumi.getter(name="caCertArchiveText")
    def ca_cert_archive_text(self) -> str:
        return pulumi.get(self, "ca_cert_archive_text")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="componentDetails")
    def component_details(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailResult']:
        """
        Blockchain Platform component details.
        """
        return pulumi.get(self, "component_details")

    @property
    @pulumi.getter(name="computeShape")
    def compute_shape(self) -> str:
        """
        Compute shape - STANDARD or ENTERPRISE_SMALL or ENTERPRISE_MEDIUM or ENTERPRISE_LARGE or ENTERPRISE_EXTRA_LARGE or ENTERPRISE_CUSTOM
        """
        return pulumi.get(self, "compute_shape")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Platform Instance Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="federatedUserId")
    def federated_user_id(self) -> str:
        return pulumi.get(self, "federated_user_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostOcpuUtilizationInfos")
    def host_ocpu_utilization_infos(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemHostOcpuUtilizationInfoResult']:
        """
        List of OcpuUtilization for all hosts
        """
        return pulumi.get(self, "host_ocpu_utilization_infos")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique identifier that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> str:
        return pulumi.get(self, "idcs_access_token")

    @property
    @pulumi.getter(name="isByol")
    def is_byol(self) -> bool:
        """
        Bring your own license
        """
        return pulumi.get(self, "is_byol")

    @property
    @pulumi.getter(name="isMultiAd")
    def is_multi_ad(self) -> bool:
        """
        True for multi-AD blockchain plaforms, false for single-AD
        """
        return pulumi.get(self, "is_multi_ad")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="loadBalancerShape")
    def load_balancer_shape(self) -> str:
        """
        Type of Load Balancer shape - LB_100_MBPS or LB_400_MBPS. Default is LB_100_MBPS.
        """
        return pulumi.get(self, "load_balancer_shape")

    @property
    @pulumi.getter(name="platformRole")
    def platform_role(self) -> str:
        """
        Role of platform - FOUNDER or PARTICIPANT
        """
        return pulumi.get(self, "platform_role")

    @property
    @pulumi.getter(name="platformShapeType")
    def platform_shape_type(self) -> str:
        """
        Type of Platform shape - DEFAULT or CUSTOM
        """
        return pulumi.get(self, "platform_shape_type")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> str:
        """
        Platform Version
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter
    def replicas(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemReplicaResult']:
        """
        Number of replicas of service components like Rest Proxy, CA and Console
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> str:
        """
        Service endpoint URL, valid post-provisioning
        """
        return pulumi.get(self, "service_endpoint")

    @property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> str:
        """
        The version of the Platform Instance.
        """
        return pulumi.get(self, "service_version")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageSizeInTbs")
    def storage_size_in_tbs(self) -> float:
        """
        Storage size in TBs
        """
        return pulumi.get(self, "storage_size_in_tbs")

    @property
    @pulumi.getter(name="storageUsedInTbs")
    def storage_used_in_tbs(self) -> float:
        """
        Storage used in TBs
        """
        return pulumi.get(self, "storage_used_in_tbs")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the Platform Instance was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the Platform Instance was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalOcpuCapacity")
    def total_ocpu_capacity(self) -> int:
        """
        Number of total OCPUs allocated to the platform cluster
        """
        return pulumi.get(self, "total_ocpu_capacity")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailResult(dict):
    def __init__(__self__, *,
                 osns: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnResult'],
                 peers: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerResult']):
        """
        :param Sequence['GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnArgs'] osns: List of OSNs
        :param Sequence['GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerArgs'] peers: List of Peers
        """
        GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            osns=osns,
            peers=peers,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             osns: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnResult'],
             peers: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("osns", osns)
        _setter("peers", peers)

    @property
    @pulumi.getter
    def osns(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnResult']:
        """
        List of OSNs
        """
        return pulumi.get(self, "osns")

    @property
    @pulumi.getter
    def peers(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerResult']:
        """
        List of Peers
        """
        return pulumi.get(self, "peers")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnResult(dict):
    def __init__(__self__, *,
                 ad: str,
                 ocpu_allocation_params: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnOcpuAllocationParamResult'],
                 osn_key: str,
                 state: str):
        """
        :param str ad: Availability Domain of peer
        :param Sequence['GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnOcpuAllocationParamArgs'] ocpu_allocation_params: OCPU allocation parameter
        :param str osn_key: OSN identifier
        :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        """
        GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ad=ad,
            ocpu_allocation_params=ocpu_allocation_params,
            osn_key=osn_key,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ad: str,
             ocpu_allocation_params: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnOcpuAllocationParamResult'],
             osn_key: str,
             state: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationParams' in kwargs:
            ocpu_allocation_params = kwargs['ocpuAllocationParams']
        if 'osnKey' in kwargs:
            osn_key = kwargs['osnKey']

        _setter("ad", ad)
        _setter("ocpu_allocation_params", ocpu_allocation_params)
        _setter("osn_key", osn_key)
        _setter("state", state)

    @property
    @pulumi.getter
    def ad(self) -> str:
        """
        Availability Domain of peer
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter(name="ocpuAllocationParams")
    def ocpu_allocation_params(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnOcpuAllocationParamResult']:
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_params")

    @property
    @pulumi.getter(name="osnKey")
    def osn_key(self) -> str:
        """
        OSN identifier
        """
        return pulumi.get(self, "osn_key")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: float):
        """
        :param float ocpu_allocation_number: Number of OCPU allocation
        """
        GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnOcpuAllocationParamResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ocpu_allocation_number=ocpu_allocation_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ocpu_allocation_number: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationNumber' in kwargs:
            ocpu_allocation_number = kwargs['ocpuAllocationNumber']

        _setter("ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerResult(dict):
    def __init__(__self__, *,
                 ad: str,
                 alias: str,
                 host: str,
                 ocpu_allocation_params: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerOcpuAllocationParamResult'],
                 peer_key: str,
                 role: str,
                 state: str):
        """
        :param str ad: Availability Domain of peer
        :param str alias: peer alias
        :param str host: Host name of VM
        :param Sequence['GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerOcpuAllocationParamArgs'] ocpu_allocation_params: OCPU allocation parameter
        :param str peer_key: peer identifier
        :param str role: Peer role
        :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        """
        GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ad=ad,
            alias=alias,
            host=host,
            ocpu_allocation_params=ocpu_allocation_params,
            peer_key=peer_key,
            role=role,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ad: str,
             alias: str,
             host: str,
             ocpu_allocation_params: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerOcpuAllocationParamResult'],
             peer_key: str,
             role: str,
             state: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationParams' in kwargs:
            ocpu_allocation_params = kwargs['ocpuAllocationParams']
        if 'peerKey' in kwargs:
            peer_key = kwargs['peerKey']

        _setter("ad", ad)
        _setter("alias", alias)
        _setter("host", host)
        _setter("ocpu_allocation_params", ocpu_allocation_params)
        _setter("peer_key", peer_key)
        _setter("role", role)
        _setter("state", state)

    @property
    @pulumi.getter
    def ad(self) -> str:
        """
        Availability Domain of peer
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter
    def alias(self) -> str:
        """
        peer alias
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Host name of VM
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ocpuAllocationParams")
    def ocpu_allocation_params(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerOcpuAllocationParamResult']:
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_params")

    @property
    @pulumi.getter(name="peerKey")
    def peer_key(self) -> str:
        """
        peer identifier
        """
        return pulumi.get(self, "peer_key")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Peer role
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: float):
        """
        :param float ocpu_allocation_number: Number of OCPU allocation
        """
        GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerOcpuAllocationParamResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ocpu_allocation_number=ocpu_allocation_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ocpu_allocation_number: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationNumber' in kwargs:
            ocpu_allocation_number = kwargs['ocpuAllocationNumber']

        _setter("ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemHostOcpuUtilizationInfoResult(dict):
    def __init__(__self__, *,
                 host: str,
                 ocpu_capacity_number: float,
                 ocpu_utilization_number: float):
        """
        :param str host: Host name of VM
        :param float ocpu_capacity_number: Number of total OCPU capacity on the host
        :param float ocpu_utilization_number: Number of OCPU utilized
        """
        GetBlockchainPlatformsBlockchainPlatformCollectionItemHostOcpuUtilizationInfoResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            host=host,
            ocpu_capacity_number=ocpu_capacity_number,
            ocpu_utilization_number=ocpu_utilization_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             host: str,
             ocpu_capacity_number: float,
             ocpu_utilization_number: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuCapacityNumber' in kwargs:
            ocpu_capacity_number = kwargs['ocpuCapacityNumber']
        if 'ocpuUtilizationNumber' in kwargs:
            ocpu_utilization_number = kwargs['ocpuUtilizationNumber']

        _setter("host", host)
        _setter("ocpu_capacity_number", ocpu_capacity_number)
        _setter("ocpu_utilization_number", ocpu_utilization_number)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Host name of VM
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ocpuCapacityNumber")
    def ocpu_capacity_number(self) -> float:
        """
        Number of total OCPU capacity on the host
        """
        return pulumi.get(self, "ocpu_capacity_number")

    @property
    @pulumi.getter(name="ocpuUtilizationNumber")
    def ocpu_utilization_number(self) -> float:
        """
        Number of OCPU utilized
        """
        return pulumi.get(self, "ocpu_utilization_number")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemReplicaResult(dict):
    def __init__(__self__, *,
                 ca_count: int,
                 console_count: int,
                 proxy_count: int):
        """
        :param int ca_count: Number of CA replicas
        :param int console_count: Number of console replicas
        :param int proxy_count: Number of REST proxy replicas
        """
        GetBlockchainPlatformsBlockchainPlatformCollectionItemReplicaResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ca_count=ca_count,
            console_count=console_count,
            proxy_count=proxy_count,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ca_count: int,
             console_count: int,
             proxy_count: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'caCount' in kwargs:
            ca_count = kwargs['caCount']
        if 'consoleCount' in kwargs:
            console_count = kwargs['consoleCount']
        if 'proxyCount' in kwargs:
            proxy_count = kwargs['proxyCount']

        _setter("ca_count", ca_count)
        _setter("console_count", console_count)
        _setter("proxy_count", proxy_count)

    @property
    @pulumi.getter(name="caCount")
    def ca_count(self) -> int:
        """
        Number of CA replicas
        """
        return pulumi.get(self, "ca_count")

    @property
    @pulumi.getter(name="consoleCount")
    def console_count(self) -> int:
        """
        Number of console replicas
        """
        return pulumi.get(self, "console_count")

    @property
    @pulumi.getter(name="proxyCount")
    def proxy_count(self) -> int:
        """
        Number of REST proxy replicas
        """
        return pulumi.get(self, "proxy_count")


@pulumi.output_type
class GetBlockchainPlatformsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetBlockchainPlatformsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOsnOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: float):
        """
        :param float ocpu_allocation_number: Number of OCPU allocation
        """
        GetOsnOcpuAllocationParamResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ocpu_allocation_number=ocpu_allocation_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ocpu_allocation_number: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationNumber' in kwargs:
            ocpu_allocation_number = kwargs['ocpuAllocationNumber']

        _setter("ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetOsnsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetOsnsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOsnsOsnCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOsnsOsnCollectionItemResult']):
        GetOsnsOsnCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetOsnsOsnCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOsnsOsnCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOsnsOsnCollectionItemResult(dict):
    def __init__(__self__, *,
                 ad: str,
                 blockchain_platform_id: str,
                 ocpu_allocation_param: 'outputs.GetOsnsOsnCollectionItemOcpuAllocationParamResult',
                 osn_key: str,
                 state: str):
        """
        :param str ad: Availability Domain of OSN
        :param str blockchain_platform_id: Unique service identifier.
        :param 'GetOsnsOsnCollectionItemOcpuAllocationParamArgs' ocpu_allocation_param: OCPU allocation parameter
        :param str osn_key: OSN identifier
        :param str state: The current state of the OSN.
        """
        GetOsnsOsnCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ad=ad,
            blockchain_platform_id=blockchain_platform_id,
            ocpu_allocation_param=ocpu_allocation_param,
            osn_key=osn_key,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ad: str,
             blockchain_platform_id: str,
             ocpu_allocation_param: 'outputs.GetOsnsOsnCollectionItemOcpuAllocationParamResult',
             osn_key: str,
             state: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'blockchainPlatformId' in kwargs:
            blockchain_platform_id = kwargs['blockchainPlatformId']
        if 'ocpuAllocationParam' in kwargs:
            ocpu_allocation_param = kwargs['ocpuAllocationParam']
        if 'osnKey' in kwargs:
            osn_key = kwargs['osnKey']

        _setter("ad", ad)
        _setter("blockchain_platform_id", blockchain_platform_id)
        _setter("ocpu_allocation_param", ocpu_allocation_param)
        _setter("osn_key", osn_key)
        _setter("state", state)

    @property
    @pulumi.getter
    def ad(self) -> str:
        """
        Availability Domain of OSN
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter(name="blockchainPlatformId")
    def blockchain_platform_id(self) -> str:
        """
        Unique service identifier.
        """
        return pulumi.get(self, "blockchain_platform_id")

    @property
    @pulumi.getter(name="ocpuAllocationParam")
    def ocpu_allocation_param(self) -> 'outputs.GetOsnsOsnCollectionItemOcpuAllocationParamResult':
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_param")

    @property
    @pulumi.getter(name="osnKey")
    def osn_key(self) -> str:
        """
        OSN identifier
        """
        return pulumi.get(self, "osn_key")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the OSN.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetOsnsOsnCollectionItemOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: float):
        """
        :param float ocpu_allocation_number: Number of OCPU allocation
        """
        GetOsnsOsnCollectionItemOcpuAllocationParamResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ocpu_allocation_number=ocpu_allocation_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ocpu_allocation_number: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationNumber' in kwargs:
            ocpu_allocation_number = kwargs['ocpuAllocationNumber']

        _setter("ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetPeerOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: float):
        """
        :param float ocpu_allocation_number: Number of OCPU allocation
        """
        GetPeerOcpuAllocationParamResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ocpu_allocation_number=ocpu_allocation_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ocpu_allocation_number: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationNumber' in kwargs:
            ocpu_allocation_number = kwargs['ocpuAllocationNumber']

        _setter("ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetPeersFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetPeersFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPeersPeerCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetPeersPeerCollectionItemResult']):
        GetPeersPeerCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetPeersPeerCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetPeersPeerCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetPeersPeerCollectionItemResult(dict):
    def __init__(__self__, *,
                 ad: str,
                 alias: str,
                 blockchain_platform_id: str,
                 host: str,
                 ocpu_allocation_param: 'outputs.GetPeersPeerCollectionItemOcpuAllocationParamResult',
                 peer_key: str,
                 role: str,
                 state: str):
        """
        :param str ad: Availability Domain of peer
        :param str alias: peer alias
        :param str blockchain_platform_id: Unique service identifier.
        :param str host: Host on which the Peer exists
        :param 'GetPeersPeerCollectionItemOcpuAllocationParamArgs' ocpu_allocation_param: OCPU allocation parameter
        :param str peer_key: peer identifier
        :param str role: Peer role
        :param str state: The current state of the peer.
        """
        GetPeersPeerCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ad=ad,
            alias=alias,
            blockchain_platform_id=blockchain_platform_id,
            host=host,
            ocpu_allocation_param=ocpu_allocation_param,
            peer_key=peer_key,
            role=role,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ad: str,
             alias: str,
             blockchain_platform_id: str,
             host: str,
             ocpu_allocation_param: 'outputs.GetPeersPeerCollectionItemOcpuAllocationParamResult',
             peer_key: str,
             role: str,
             state: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'blockchainPlatformId' in kwargs:
            blockchain_platform_id = kwargs['blockchainPlatformId']
        if 'ocpuAllocationParam' in kwargs:
            ocpu_allocation_param = kwargs['ocpuAllocationParam']
        if 'peerKey' in kwargs:
            peer_key = kwargs['peerKey']

        _setter("ad", ad)
        _setter("alias", alias)
        _setter("blockchain_platform_id", blockchain_platform_id)
        _setter("host", host)
        _setter("ocpu_allocation_param", ocpu_allocation_param)
        _setter("peer_key", peer_key)
        _setter("role", role)
        _setter("state", state)

    @property
    @pulumi.getter
    def ad(self) -> str:
        """
        Availability Domain of peer
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter
    def alias(self) -> str:
        """
        peer alias
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="blockchainPlatformId")
    def blockchain_platform_id(self) -> str:
        """
        Unique service identifier.
        """
        return pulumi.get(self, "blockchain_platform_id")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Host on which the Peer exists
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ocpuAllocationParam")
    def ocpu_allocation_param(self) -> 'outputs.GetPeersPeerCollectionItemOcpuAllocationParamResult':
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_param")

    @property
    @pulumi.getter(name="peerKey")
    def peer_key(self) -> str:
        """
        peer identifier
        """
        return pulumi.get(self, "peer_key")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Peer role
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the peer.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetPeersPeerCollectionItemOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: float):
        """
        :param float ocpu_allocation_number: Number of OCPU allocation
        """
        GetPeersPeerCollectionItemOcpuAllocationParamResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ocpu_allocation_number=ocpu_allocation_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ocpu_allocation_number: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ocpuAllocationNumber' in kwargs:
            ocpu_allocation_number = kwargs['ocpuAllocationNumber']

        _setter("ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


