# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MigrationPlanArgs', 'MigrationPlan']

@pulumi.input_type
class MigrationPlanArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 migration_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 source_migration_plan_id: Optional[pulumi.Input[str]] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanStrategyArgs']]]] = None,
                 target_environments: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanTargetEnvironmentArgs']]]] = None):
        """
        The set of arguments for constructing a MigrationPlan resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment identifier
        :param pulumi.Input[str] display_name: (Updatable) Migration plan identifier
        :param pulumi.Input[str] migration_id: The OCID of the associated migration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. It exists only for cross-compatibility. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] source_migration_plan_id: Source migraiton plan ID to be cloned.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationPlanStrategyArgs']]] strategies: (Updatable) List of strategies for the resources to be migrated.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationPlanTargetEnvironmentArgs']]] target_environments: (Updatable) List of target environments.
        """
        MigrationPlanArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            display_name=display_name,
            migration_id=migration_id,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            source_migration_plan_id=source_migration_plan_id,
            strategies=strategies,
            target_environments=target_environments,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             display_name: pulumi.Input[str],
             migration_id: pulumi.Input[str],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             source_migration_plan_id: Optional[pulumi.Input[str]] = None,
             strategies: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanStrategyArgs']]]] = None,
             target_environments: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanTargetEnvironmentArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'migrationId' in kwargs:
            migration_id = kwargs['migrationId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'sourceMigrationPlanId' in kwargs:
            source_migration_plan_id = kwargs['sourceMigrationPlanId']
        if 'targetEnvironments' in kwargs:
            target_environments = kwargs['targetEnvironments']

        _setter("compartment_id", compartment_id)
        _setter("display_name", display_name)
        _setter("migration_id", migration_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if source_migration_plan_id is not None:
            _setter("source_migration_plan_id", source_migration_plan_id)
        if strategies is not None:
            _setter("strategies", strategies)
        if target_environments is not None:
            _setter("target_environments", target_environments)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment identifier
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Migration plan identifier
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> pulumi.Input[str]:
        """
        The OCID of the associated migration.
        """
        return pulumi.get(self, "migration_id")

    @migration_id.setter
    def migration_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "migration_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. It exists only for cross-compatibility. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="sourceMigrationPlanId")
    def source_migration_plan_id(self) -> Optional[pulumi.Input[str]]:
        """
        Source migraiton plan ID to be cloned.
        """
        return pulumi.get(self, "source_migration_plan_id")

    @source_migration_plan_id.setter
    def source_migration_plan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_migration_plan_id", value)

    @property
    @pulumi.getter
    def strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanStrategyArgs']]]]:
        """
        (Updatable) List of strategies for the resources to be migrated.
        """
        return pulumi.get(self, "strategies")

    @strategies.setter
    def strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanStrategyArgs']]]]):
        pulumi.set(self, "strategies", value)

    @property
    @pulumi.getter(name="targetEnvironments")
    def target_environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanTargetEnvironmentArgs']]]]:
        """
        (Updatable) List of target environments.
        """
        return pulumi.get(self, "target_environments")

    @target_environments.setter
    def target_environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanTargetEnvironmentArgs']]]]):
        pulumi.set(self, "target_environments", value)


@pulumi.input_type
class _MigrationPlanState:
    def __init__(__self__, *,
                 calculated_limits: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 migration_id: Optional[pulumi.Input[str]] = None,
                 migration_plan_stats: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanMigrationPlanStatArgs']]]] = None,
                 reference_to_rms_stack: Optional[pulumi.Input[str]] = None,
                 source_migration_plan_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanStrategyArgs']]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_environments: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanTargetEnvironmentArgs']]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MigrationPlan resources.
        :param pulumi.Input[Mapping[str, Any]] calculated_limits: Limits of the resources that are needed for migration. Example: {"BlockVolume": 2, "VCN": 1}
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment identifier
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Migration plan identifier
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. It exists only for cross-compatibility. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] migration_id: The OCID of the associated migration.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationPlanMigrationPlanStatArgs']]] migration_plan_stats: Status of the migration plan.
        :param pulumi.Input[str] reference_to_rms_stack: OCID of the referenced ORM job.
        :param pulumi.Input[str] source_migration_plan_id: Source migraiton plan ID to be cloned.
        :param pulumi.Input[str] state: The current state of the migration plan.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationPlanStrategyArgs']]] strategies: (Updatable) List of strategies for the resources to be migrated.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input['MigrationPlanTargetEnvironmentArgs']]] target_environments: (Updatable) List of target environments.
        :param pulumi.Input[str] time_created: The time when the migration plan was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when the migration plan was updated. An RFC3339 formatted datetime string.
        """
        _MigrationPlanState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            calculated_limits=calculated_limits,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            lifecycle_details=lifecycle_details,
            migration_id=migration_id,
            migration_plan_stats=migration_plan_stats,
            reference_to_rms_stack=reference_to_rms_stack,
            source_migration_plan_id=source_migration_plan_id,
            state=state,
            strategies=strategies,
            system_tags=system_tags,
            target_environments=target_environments,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             calculated_limits: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             migration_id: Optional[pulumi.Input[str]] = None,
             migration_plan_stats: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanMigrationPlanStatArgs']]]] = None,
             reference_to_rms_stack: Optional[pulumi.Input[str]] = None,
             source_migration_plan_id: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             strategies: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanStrategyArgs']]]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             target_environments: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanTargetEnvironmentArgs']]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'calculatedLimits' in kwargs:
            calculated_limits = kwargs['calculatedLimits']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'migrationId' in kwargs:
            migration_id = kwargs['migrationId']
        if 'migrationPlanStats' in kwargs:
            migration_plan_stats = kwargs['migrationPlanStats']
        if 'referenceToRmsStack' in kwargs:
            reference_to_rms_stack = kwargs['referenceToRmsStack']
        if 'sourceMigrationPlanId' in kwargs:
            source_migration_plan_id = kwargs['sourceMigrationPlanId']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'targetEnvironments' in kwargs:
            target_environments = kwargs['targetEnvironments']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        if calculated_limits is not None:
            _setter("calculated_limits", calculated_limits)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if migration_id is not None:
            _setter("migration_id", migration_id)
        if migration_plan_stats is not None:
            _setter("migration_plan_stats", migration_plan_stats)
        if reference_to_rms_stack is not None:
            _setter("reference_to_rms_stack", reference_to_rms_stack)
        if source_migration_plan_id is not None:
            _setter("source_migration_plan_id", source_migration_plan_id)
        if state is not None:
            _setter("state", state)
        if strategies is not None:
            _setter("strategies", strategies)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if target_environments is not None:
            _setter("target_environments", target_environments)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="calculatedLimits")
    def calculated_limits(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Limits of the resources that are needed for migration. Example: {"BlockVolume": 2, "VCN": 1}
        """
        return pulumi.get(self, "calculated_limits")

    @calculated_limits.setter
    def calculated_limits(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "calculated_limits", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment identifier
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Migration plan identifier
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. It exists only for cross-compatibility. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the associated migration.
        """
        return pulumi.get(self, "migration_id")

    @migration_id.setter
    def migration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migration_id", value)

    @property
    @pulumi.getter(name="migrationPlanStats")
    def migration_plan_stats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanMigrationPlanStatArgs']]]]:
        """
        Status of the migration plan.
        """
        return pulumi.get(self, "migration_plan_stats")

    @migration_plan_stats.setter
    def migration_plan_stats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanMigrationPlanStatArgs']]]]):
        pulumi.set(self, "migration_plan_stats", value)

    @property
    @pulumi.getter(name="referenceToRmsStack")
    def reference_to_rms_stack(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the referenced ORM job.
        """
        return pulumi.get(self, "reference_to_rms_stack")

    @reference_to_rms_stack.setter
    def reference_to_rms_stack(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reference_to_rms_stack", value)

    @property
    @pulumi.getter(name="sourceMigrationPlanId")
    def source_migration_plan_id(self) -> Optional[pulumi.Input[str]]:
        """
        Source migraiton plan ID to be cloned.
        """
        return pulumi.get(self, "source_migration_plan_id")

    @source_migration_plan_id.setter
    def source_migration_plan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_migration_plan_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the migration plan.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanStrategyArgs']]]]:
        """
        (Updatable) List of strategies for the resources to be migrated.
        """
        return pulumi.get(self, "strategies")

    @strategies.setter
    def strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanStrategyArgs']]]]):
        pulumi.set(self, "strategies", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetEnvironments")
    def target_environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanTargetEnvironmentArgs']]]]:
        """
        (Updatable) List of target environments.
        """
        return pulumi.get(self, "target_environments")

    @target_environments.setter
    def target_environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationPlanTargetEnvironmentArgs']]]]):
        pulumi.set(self, "target_environments", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the migration plan was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the migration plan was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class MigrationPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 migration_id: Optional[pulumi.Input[str]] = None,
                 source_migration_plan_id: Optional[pulumi.Input[str]] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationPlanStrategyArgs']]]]] = None,
                 target_environments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationPlanTargetEnvironmentArgs']]]]] = None,
                 __props__=None):
        """
        This resource provides the Migration Plan resource in Oracle Cloud Infrastructure Cloud Migrations service.

        Creates a migration plan.

        ## Import

        MigrationPlans can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:CloudMigrations/migrationPlan:MigrationPlan test_migration_plan "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment identifier
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Migration plan identifier
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. It exists only for cross-compatibility. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] migration_id: The OCID of the associated migration.
        :param pulumi.Input[str] source_migration_plan_id: Source migraiton plan ID to be cloned.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationPlanStrategyArgs']]]] strategies: (Updatable) List of strategies for the resources to be migrated.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationPlanTargetEnvironmentArgs']]]] target_environments: (Updatable) List of target environments.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MigrationPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Migration Plan resource in Oracle Cloud Infrastructure Cloud Migrations service.

        Creates a migration plan.

        ## Import

        MigrationPlans can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:CloudMigrations/migrationPlan:MigrationPlan test_migration_plan "id"
        ```

        :param str resource_name: The name of the resource.
        :param MigrationPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MigrationPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            MigrationPlanArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 migration_id: Optional[pulumi.Input[str]] = None,
                 source_migration_plan_id: Optional[pulumi.Input[str]] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationPlanStrategyArgs']]]]] = None,
                 target_environments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationPlanTargetEnvironmentArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MigrationPlanArgs.__new__(MigrationPlanArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if migration_id is None and not opts.urn:
                raise TypeError("Missing required property 'migration_id'")
            __props__.__dict__["migration_id"] = migration_id
            __props__.__dict__["source_migration_plan_id"] = source_migration_plan_id
            __props__.__dict__["strategies"] = strategies
            __props__.__dict__["target_environments"] = target_environments
            __props__.__dict__["calculated_limits"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["migration_plan_stats"] = None
            __props__.__dict__["reference_to_rms_stack"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(MigrationPlan, __self__).__init__(
            'oci:CloudMigrations/migrationPlan:MigrationPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            calculated_limits: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            migration_id: Optional[pulumi.Input[str]] = None,
            migration_plan_stats: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationPlanMigrationPlanStatArgs']]]]] = None,
            reference_to_rms_stack: Optional[pulumi.Input[str]] = None,
            source_migration_plan_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            strategies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationPlanStrategyArgs']]]]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            target_environments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationPlanTargetEnvironmentArgs']]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'MigrationPlan':
        """
        Get an existing MigrationPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] calculated_limits: Limits of the resources that are needed for migration. Example: {"BlockVolume": 2, "VCN": 1}
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment identifier
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Migration plan identifier
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. It exists only for cross-compatibility. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] migration_id: The OCID of the associated migration.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationPlanMigrationPlanStatArgs']]]] migration_plan_stats: Status of the migration plan.
        :param pulumi.Input[str] reference_to_rms_stack: OCID of the referenced ORM job.
        :param pulumi.Input[str] source_migration_plan_id: Source migraiton plan ID to be cloned.
        :param pulumi.Input[str] state: The current state of the migration plan.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationPlanStrategyArgs']]]] strategies: (Updatable) List of strategies for the resources to be migrated.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationPlanTargetEnvironmentArgs']]]] target_environments: (Updatable) List of target environments.
        :param pulumi.Input[str] time_created: The time when the migration plan was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when the migration plan was updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MigrationPlanState.__new__(_MigrationPlanState)

        __props__.__dict__["calculated_limits"] = calculated_limits
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["migration_id"] = migration_id
        __props__.__dict__["migration_plan_stats"] = migration_plan_stats
        __props__.__dict__["reference_to_rms_stack"] = reference_to_rms_stack
        __props__.__dict__["source_migration_plan_id"] = source_migration_plan_id
        __props__.__dict__["state"] = state
        __props__.__dict__["strategies"] = strategies
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_environments"] = target_environments
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return MigrationPlan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="calculatedLimits")
    def calculated_limits(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Limits of the resources that are needed for migration. Example: {"BlockVolume": 2, "VCN": 1}
        """
        return pulumi.get(self, "calculated_limits")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Migration plan identifier
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. It exists only for cross-compatibility. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> pulumi.Output[str]:
        """
        The OCID of the associated migration.
        """
        return pulumi.get(self, "migration_id")

    @property
    @pulumi.getter(name="migrationPlanStats")
    def migration_plan_stats(self) -> pulumi.Output[Sequence['outputs.MigrationPlanMigrationPlanStat']]:
        """
        Status of the migration plan.
        """
        return pulumi.get(self, "migration_plan_stats")

    @property
    @pulumi.getter(name="referenceToRmsStack")
    def reference_to_rms_stack(self) -> pulumi.Output[str]:
        """
        OCID of the referenced ORM job.
        """
        return pulumi.get(self, "reference_to_rms_stack")

    @property
    @pulumi.getter(name="sourceMigrationPlanId")
    def source_migration_plan_id(self) -> pulumi.Output[str]:
        """
        Source migraiton plan ID to be cloned.
        """
        return pulumi.get(self, "source_migration_plan_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the migration plan.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def strategies(self) -> pulumi.Output[Sequence['outputs.MigrationPlanStrategy']]:
        """
        (Updatable) List of strategies for the resources to be migrated.
        """
        return pulumi.get(self, "strategies")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetEnvironments")
    def target_environments(self) -> pulumi.Output[Sequence['outputs.MigrationPlanTargetEnvironment']]:
        """
        (Updatable) List of target environments.
        """
        return pulumi.get(self, "target_environments")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time when the migration plan was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time when the migration plan was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

