# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'AtCustomerCccInfrastructureInfrastructureInventoryArgs',
    'AtCustomerCccInfrastructureInfrastructureNetworkConfigurationArgs',
    'AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicArgs',
    'AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicPeerInformationArgs',
    'AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingStaticArgs',
    'AtCustomerCccInfrastructureInfrastructureNetworkConfigurationManagementNodeArgs',
    'AtCustomerCccInfrastructureUpgradeInformationArgs',
    'AtCustomerCccUpgradeScheduleEventArgs',
    'GetAtCustomerCccInfrastructuresFilterArgs',
    'GetAtCustomerCccUpgradeSchedulesFilterArgs',
]

@pulumi.input_type
class AtCustomerCccInfrastructureInfrastructureInventoryArgs:
    def __init__(__self__, *,
                 capacity_storage_tray_count: Optional[pulumi.Input[int]] = None,
                 compute_node_count: Optional[pulumi.Input[int]] = None,
                 management_node_count: Optional[pulumi.Input[int]] = None,
                 performance_storage_tray_count: Optional[pulumi.Input[int]] = None,
                 serial_number: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] capacity_storage_tray_count: The number of storage trays in the Compute Cloud@Customer infrastructure rack that are designated for capacity storage.
        :param pulumi.Input[int] compute_node_count: The number of compute nodes that are available and usable on the Compute Cloud@Customer infrastructure rack. There is no distinction of compute node type in this information.
        :param pulumi.Input[int] management_node_count: The number of management nodes that are available and in active use on the Compute Cloud@Customer infrastructure rack.
        :param pulumi.Input[int] performance_storage_tray_count: The number of storage trays in the Compute Cloud@Customer infrastructure rack that are designated for performance storage.
        :param pulumi.Input[str] serial_number: The serial number of the Compute Cloud@Customer infrastructure rack.
        """
        AtCustomerCccInfrastructureInfrastructureInventoryArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            capacity_storage_tray_count=capacity_storage_tray_count,
            compute_node_count=compute_node_count,
            management_node_count=management_node_count,
            performance_storage_tray_count=performance_storage_tray_count,
            serial_number=serial_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             capacity_storage_tray_count: Optional[pulumi.Input[int]] = None,
             compute_node_count: Optional[pulumi.Input[int]] = None,
             management_node_count: Optional[pulumi.Input[int]] = None,
             performance_storage_tray_count: Optional[pulumi.Input[int]] = None,
             serial_number: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'capacityStorageTrayCount' in kwargs:
            capacity_storage_tray_count = kwargs['capacityStorageTrayCount']
        if 'computeNodeCount' in kwargs:
            compute_node_count = kwargs['computeNodeCount']
        if 'managementNodeCount' in kwargs:
            management_node_count = kwargs['managementNodeCount']
        if 'performanceStorageTrayCount' in kwargs:
            performance_storage_tray_count = kwargs['performanceStorageTrayCount']
        if 'serialNumber' in kwargs:
            serial_number = kwargs['serialNumber']

        if capacity_storage_tray_count is not None:
            _setter("capacity_storage_tray_count", capacity_storage_tray_count)
        if compute_node_count is not None:
            _setter("compute_node_count", compute_node_count)
        if management_node_count is not None:
            _setter("management_node_count", management_node_count)
        if performance_storage_tray_count is not None:
            _setter("performance_storage_tray_count", performance_storage_tray_count)
        if serial_number is not None:
            _setter("serial_number", serial_number)

    @property
    @pulumi.getter(name="capacityStorageTrayCount")
    def capacity_storage_tray_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of storage trays in the Compute Cloud@Customer infrastructure rack that are designated for capacity storage.
        """
        return pulumi.get(self, "capacity_storage_tray_count")

    @capacity_storage_tray_count.setter
    def capacity_storage_tray_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity_storage_tray_count", value)

    @property
    @pulumi.getter(name="computeNodeCount")
    def compute_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of compute nodes that are available and usable on the Compute Cloud@Customer infrastructure rack. There is no distinction of compute node type in this information.
        """
        return pulumi.get(self, "compute_node_count")

    @compute_node_count.setter
    def compute_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compute_node_count", value)

    @property
    @pulumi.getter(name="managementNodeCount")
    def management_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of management nodes that are available and in active use on the Compute Cloud@Customer infrastructure rack.
        """
        return pulumi.get(self, "management_node_count")

    @management_node_count.setter
    def management_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "management_node_count", value)

    @property
    @pulumi.getter(name="performanceStorageTrayCount")
    def performance_storage_tray_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of storage trays in the Compute Cloud@Customer infrastructure rack that are designated for performance storage.
        """
        return pulumi.get(self, "performance_storage_tray_count")

    @performance_storage_tray_count.setter
    def performance_storage_tray_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "performance_storage_tray_count", value)

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[str]]:
        """
        The serial number of the Compute Cloud@Customer infrastructure rack.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial_number", value)


@pulumi.input_type
class AtCustomerCccInfrastructureInfrastructureNetworkConfigurationArgs:
    def __init__(__self__, *,
                 dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 infrastructure_routing_dynamics: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicArgs']]]] = None,
                 infrastructure_routing_statics: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingStaticArgs']]]] = None,
                 management_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationManagementNodeArgs']]]] = None,
                 mgmt_vip_hostname: Optional[pulumi.Input[str]] = None,
                 mgmt_vip_ip: Optional[pulumi.Input[str]] = None,
                 spine_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spine_vip: Optional[pulumi.Input[str]] = None,
                 uplink_domain: Optional[pulumi.Input[str]] = None,
                 uplink_gateway_ip: Optional[pulumi.Input[str]] = None,
                 uplink_netmask: Optional[pulumi.Input[str]] = None,
                 uplink_port_count: Optional[pulumi.Input[int]] = None,
                 uplink_port_forward_error_correction: Optional[pulumi.Input[str]] = None,
                 uplink_port_speed_in_gbps: Optional[pulumi.Input[int]] = None,
                 uplink_vlan_mtu: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_ips: The domain name system (DNS) addresses that the Compute Cloud@Customer infrastructure uses for the data center network.
        :param pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicArgs']]] infrastructure_routing_dynamics: Dynamic routing information for the Compute Cloud@Customer infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingStaticArgs']]] infrastructure_routing_statics: Static routing information for a rack.
        :param pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationManagementNodeArgs']]] management_nodes: Information about the management nodes that are provisioned in the Compute Cloud@Customer infrastructure.
        :param pulumi.Input[str] mgmt_vip_hostname: The hostname corresponding to the virtual IP (VIP) address of the management nodes.
        :param pulumi.Input[str] mgmt_vip_ip: The IP address used as the virtual IP (VIP) address of the management nodes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spine_ips: Addresses of the network spine switches.
        :param pulumi.Input[str] spine_vip: The spine switch public virtual IP (VIP). Traffic routed to the Compute Cloud@Customer infrastructure and  and virtual cloud networks (VCNs) should have this address as next hop.
        :param pulumi.Input[str] uplink_domain: Domain name to be used as the base domain for the internal network and by  public facing services.
        :param pulumi.Input[str] uplink_gateway_ip: Uplink gateway in the datacenter network that the Compute Cloud@Customer connects to.
        :param pulumi.Input[str] uplink_netmask: Netmask of the subnet that the Compute Cloud@Customer infrastructure is connected to.
        :param pulumi.Input[int] uplink_port_count: Number of uplink ports per spine switch. Connectivity is identical on both spine switches. For example, if input is two 100 gigabyte ports; then port-1 and port-2 on both spines will be configured.
        :param pulumi.Input[str] uplink_port_forward_error_correction: The port forward error correction (FEC) setting for the uplink port on the Compute Cloud@Customer infrastructure.
        :param pulumi.Input[int] uplink_port_speed_in_gbps: Uplink port speed defined in gigabytes per second. All uplink ports must have identical speed.
        :param pulumi.Input[int] uplink_vlan_mtu: The virtual local area network (VLAN) maximum transmission unit (MTU) size for the uplink ports.
        """
        AtCustomerCccInfrastructureInfrastructureNetworkConfigurationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dns_ips=dns_ips,
            infrastructure_routing_dynamics=infrastructure_routing_dynamics,
            infrastructure_routing_statics=infrastructure_routing_statics,
            management_nodes=management_nodes,
            mgmt_vip_hostname=mgmt_vip_hostname,
            mgmt_vip_ip=mgmt_vip_ip,
            spine_ips=spine_ips,
            spine_vip=spine_vip,
            uplink_domain=uplink_domain,
            uplink_gateway_ip=uplink_gateway_ip,
            uplink_netmask=uplink_netmask,
            uplink_port_count=uplink_port_count,
            uplink_port_forward_error_correction=uplink_port_forward_error_correction,
            uplink_port_speed_in_gbps=uplink_port_speed_in_gbps,
            uplink_vlan_mtu=uplink_vlan_mtu,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             infrastructure_routing_dynamics: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicArgs']]]] = None,
             infrastructure_routing_statics: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingStaticArgs']]]] = None,
             management_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationManagementNodeArgs']]]] = None,
             mgmt_vip_hostname: Optional[pulumi.Input[str]] = None,
             mgmt_vip_ip: Optional[pulumi.Input[str]] = None,
             spine_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             spine_vip: Optional[pulumi.Input[str]] = None,
             uplink_domain: Optional[pulumi.Input[str]] = None,
             uplink_gateway_ip: Optional[pulumi.Input[str]] = None,
             uplink_netmask: Optional[pulumi.Input[str]] = None,
             uplink_port_count: Optional[pulumi.Input[int]] = None,
             uplink_port_forward_error_correction: Optional[pulumi.Input[str]] = None,
             uplink_port_speed_in_gbps: Optional[pulumi.Input[int]] = None,
             uplink_vlan_mtu: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'dnsIps' in kwargs:
            dns_ips = kwargs['dnsIps']
        if 'infrastructureRoutingDynamics' in kwargs:
            infrastructure_routing_dynamics = kwargs['infrastructureRoutingDynamics']
        if 'infrastructureRoutingStatics' in kwargs:
            infrastructure_routing_statics = kwargs['infrastructureRoutingStatics']
        if 'managementNodes' in kwargs:
            management_nodes = kwargs['managementNodes']
        if 'mgmtVipHostname' in kwargs:
            mgmt_vip_hostname = kwargs['mgmtVipHostname']
        if 'mgmtVipIp' in kwargs:
            mgmt_vip_ip = kwargs['mgmtVipIp']
        if 'spineIps' in kwargs:
            spine_ips = kwargs['spineIps']
        if 'spineVip' in kwargs:
            spine_vip = kwargs['spineVip']
        if 'uplinkDomain' in kwargs:
            uplink_domain = kwargs['uplinkDomain']
        if 'uplinkGatewayIp' in kwargs:
            uplink_gateway_ip = kwargs['uplinkGatewayIp']
        if 'uplinkNetmask' in kwargs:
            uplink_netmask = kwargs['uplinkNetmask']
        if 'uplinkPortCount' in kwargs:
            uplink_port_count = kwargs['uplinkPortCount']
        if 'uplinkPortForwardErrorCorrection' in kwargs:
            uplink_port_forward_error_correction = kwargs['uplinkPortForwardErrorCorrection']
        if 'uplinkPortSpeedInGbps' in kwargs:
            uplink_port_speed_in_gbps = kwargs['uplinkPortSpeedInGbps']
        if 'uplinkVlanMtu' in kwargs:
            uplink_vlan_mtu = kwargs['uplinkVlanMtu']

        if dns_ips is not None:
            _setter("dns_ips", dns_ips)
        if infrastructure_routing_dynamics is not None:
            _setter("infrastructure_routing_dynamics", infrastructure_routing_dynamics)
        if infrastructure_routing_statics is not None:
            _setter("infrastructure_routing_statics", infrastructure_routing_statics)
        if management_nodes is not None:
            _setter("management_nodes", management_nodes)
        if mgmt_vip_hostname is not None:
            _setter("mgmt_vip_hostname", mgmt_vip_hostname)
        if mgmt_vip_ip is not None:
            _setter("mgmt_vip_ip", mgmt_vip_ip)
        if spine_ips is not None:
            _setter("spine_ips", spine_ips)
        if spine_vip is not None:
            _setter("spine_vip", spine_vip)
        if uplink_domain is not None:
            _setter("uplink_domain", uplink_domain)
        if uplink_gateway_ip is not None:
            _setter("uplink_gateway_ip", uplink_gateway_ip)
        if uplink_netmask is not None:
            _setter("uplink_netmask", uplink_netmask)
        if uplink_port_count is not None:
            _setter("uplink_port_count", uplink_port_count)
        if uplink_port_forward_error_correction is not None:
            _setter("uplink_port_forward_error_correction", uplink_port_forward_error_correction)
        if uplink_port_speed_in_gbps is not None:
            _setter("uplink_port_speed_in_gbps", uplink_port_speed_in_gbps)
        if uplink_vlan_mtu is not None:
            _setter("uplink_vlan_mtu", uplink_vlan_mtu)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The domain name system (DNS) addresses that the Compute Cloud@Customer infrastructure uses for the data center network.
        """
        return pulumi.get(self, "dns_ips")

    @dns_ips.setter
    def dns_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_ips", value)

    @property
    @pulumi.getter(name="infrastructureRoutingDynamics")
    def infrastructure_routing_dynamics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicArgs']]]]:
        """
        Dynamic routing information for the Compute Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "infrastructure_routing_dynamics")

    @infrastructure_routing_dynamics.setter
    def infrastructure_routing_dynamics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicArgs']]]]):
        pulumi.set(self, "infrastructure_routing_dynamics", value)

    @property
    @pulumi.getter(name="infrastructureRoutingStatics")
    def infrastructure_routing_statics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingStaticArgs']]]]:
        """
        Static routing information for a rack.
        """
        return pulumi.get(self, "infrastructure_routing_statics")

    @infrastructure_routing_statics.setter
    def infrastructure_routing_statics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingStaticArgs']]]]):
        pulumi.set(self, "infrastructure_routing_statics", value)

    @property
    @pulumi.getter(name="managementNodes")
    def management_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationManagementNodeArgs']]]]:
        """
        Information about the management nodes that are provisioned in the Compute Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "management_nodes")

    @management_nodes.setter
    def management_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationManagementNodeArgs']]]]):
        pulumi.set(self, "management_nodes", value)

    @property
    @pulumi.getter(name="mgmtVipHostname")
    def mgmt_vip_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname corresponding to the virtual IP (VIP) address of the management nodes.
        """
        return pulumi.get(self, "mgmt_vip_hostname")

    @mgmt_vip_hostname.setter
    def mgmt_vip_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mgmt_vip_hostname", value)

    @property
    @pulumi.getter(name="mgmtVipIp")
    def mgmt_vip_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address used as the virtual IP (VIP) address of the management nodes.
        """
        return pulumi.get(self, "mgmt_vip_ip")

    @mgmt_vip_ip.setter
    def mgmt_vip_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mgmt_vip_ip", value)

    @property
    @pulumi.getter(name="spineIps")
    def spine_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Addresses of the network spine switches.
        """
        return pulumi.get(self, "spine_ips")

    @spine_ips.setter
    def spine_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "spine_ips", value)

    @property
    @pulumi.getter(name="spineVip")
    def spine_vip(self) -> Optional[pulumi.Input[str]]:
        """
        The spine switch public virtual IP (VIP). Traffic routed to the Compute Cloud@Customer infrastructure and  and virtual cloud networks (VCNs) should have this address as next hop.
        """
        return pulumi.get(self, "spine_vip")

    @spine_vip.setter
    def spine_vip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spine_vip", value)

    @property
    @pulumi.getter(name="uplinkDomain")
    def uplink_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Domain name to be used as the base domain for the internal network and by  public facing services.
        """
        return pulumi.get(self, "uplink_domain")

    @uplink_domain.setter
    def uplink_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uplink_domain", value)

    @property
    @pulumi.getter(name="uplinkGatewayIp")
    def uplink_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Uplink gateway in the datacenter network that the Compute Cloud@Customer connects to.
        """
        return pulumi.get(self, "uplink_gateway_ip")

    @uplink_gateway_ip.setter
    def uplink_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uplink_gateway_ip", value)

    @property
    @pulumi.getter(name="uplinkNetmask")
    def uplink_netmask(self) -> Optional[pulumi.Input[str]]:
        """
        Netmask of the subnet that the Compute Cloud@Customer infrastructure is connected to.
        """
        return pulumi.get(self, "uplink_netmask")

    @uplink_netmask.setter
    def uplink_netmask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uplink_netmask", value)

    @property
    @pulumi.getter(name="uplinkPortCount")
    def uplink_port_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of uplink ports per spine switch. Connectivity is identical on both spine switches. For example, if input is two 100 gigabyte ports; then port-1 and port-2 on both spines will be configured.
        """
        return pulumi.get(self, "uplink_port_count")

    @uplink_port_count.setter
    def uplink_port_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "uplink_port_count", value)

    @property
    @pulumi.getter(name="uplinkPortForwardErrorCorrection")
    def uplink_port_forward_error_correction(self) -> Optional[pulumi.Input[str]]:
        """
        The port forward error correction (FEC) setting for the uplink port on the Compute Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "uplink_port_forward_error_correction")

    @uplink_port_forward_error_correction.setter
    def uplink_port_forward_error_correction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uplink_port_forward_error_correction", value)

    @property
    @pulumi.getter(name="uplinkPortSpeedInGbps")
    def uplink_port_speed_in_gbps(self) -> Optional[pulumi.Input[int]]:
        """
        Uplink port speed defined in gigabytes per second. All uplink ports must have identical speed.
        """
        return pulumi.get(self, "uplink_port_speed_in_gbps")

    @uplink_port_speed_in_gbps.setter
    def uplink_port_speed_in_gbps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "uplink_port_speed_in_gbps", value)

    @property
    @pulumi.getter(name="uplinkVlanMtu")
    def uplink_vlan_mtu(self) -> Optional[pulumi.Input[int]]:
        """
        The virtual local area network (VLAN) maximum transmission unit (MTU) size for the uplink ports.
        """
        return pulumi.get(self, "uplink_vlan_mtu")

    @uplink_vlan_mtu.setter
    def uplink_vlan_mtu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "uplink_vlan_mtu", value)


@pulumi.input_type
class AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicArgs:
    def __init__(__self__, *,
                 bgp_topology: Optional[pulumi.Input[str]] = None,
                 oracle_asn: Optional[pulumi.Input[int]] = None,
                 peer_informations: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicPeerInformationArgs']]]] = None):
        """
        :param pulumi.Input[str] bgp_topology: The topology in use for the Border Gateway Protocol (BGP) configuration.
        :param pulumi.Input[int] oracle_asn: The Oracle Autonomous System Number (ASN) to control routing and exchange information within the dynamic routing configuration.
        :param pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicPeerInformationArgs']]] peer_informations: The list of peer devices in the dynamic routing configuration.
        """
        AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bgp_topology=bgp_topology,
            oracle_asn=oracle_asn,
            peer_informations=peer_informations,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bgp_topology: Optional[pulumi.Input[str]] = None,
             oracle_asn: Optional[pulumi.Input[int]] = None,
             peer_informations: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicPeerInformationArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'bgpTopology' in kwargs:
            bgp_topology = kwargs['bgpTopology']
        if 'oracleAsn' in kwargs:
            oracle_asn = kwargs['oracleAsn']
        if 'peerInformations' in kwargs:
            peer_informations = kwargs['peerInformations']

        if bgp_topology is not None:
            _setter("bgp_topology", bgp_topology)
        if oracle_asn is not None:
            _setter("oracle_asn", oracle_asn)
        if peer_informations is not None:
            _setter("peer_informations", peer_informations)

    @property
    @pulumi.getter(name="bgpTopology")
    def bgp_topology(self) -> Optional[pulumi.Input[str]]:
        """
        The topology in use for the Border Gateway Protocol (BGP) configuration.
        """
        return pulumi.get(self, "bgp_topology")

    @bgp_topology.setter
    def bgp_topology(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_topology", value)

    @property
    @pulumi.getter(name="oracleAsn")
    def oracle_asn(self) -> Optional[pulumi.Input[int]]:
        """
        The Oracle Autonomous System Number (ASN) to control routing and exchange information within the dynamic routing configuration.
        """
        return pulumi.get(self, "oracle_asn")

    @oracle_asn.setter
    def oracle_asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "oracle_asn", value)

    @property
    @pulumi.getter(name="peerInformations")
    def peer_informations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicPeerInformationArgs']]]]:
        """
        The list of peer devices in the dynamic routing configuration.
        """
        return pulumi.get(self, "peer_informations")

    @peer_informations.setter
    def peer_informations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicPeerInformationArgs']]]]):
        pulumi.set(self, "peer_informations", value)


@pulumi.input_type
class AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicPeerInformationArgs:
    def __init__(__self__, *,
                 asn: Optional[pulumi.Input[int]] = None,
                 ip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] asn: The Autonomous System Number (ASN) of the peer network.
        :param pulumi.Input[str] ip: Address of the management node.
        """
        AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingDynamicPeerInformationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            asn=asn,
            ip=ip,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             asn: Optional[pulumi.Input[int]] = None,
             ip: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if asn is not None:
            _setter("asn", asn)
        if ip is not None:
            _setter("ip", ip)

    @property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[int]]:
        """
        The Autonomous System Number (ASN) of the peer network.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "asn", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        Address of the management node.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingStaticArgs:
    def __init__(__self__, *,
                 uplink_hsrp_group: Optional[pulumi.Input[int]] = None,
                 uplink_vlan: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] uplink_hsrp_group: The uplink Hot Standby Router Protocol (HSRP) group value for the switch in the Compute Cloud@Customer infrastructure.
        :param pulumi.Input[int] uplink_vlan: The virtual local area network (VLAN) identifier used to connect to the uplink (only access mode is supported).
        """
        AtCustomerCccInfrastructureInfrastructureNetworkConfigurationInfrastructureRoutingStaticArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            uplink_hsrp_group=uplink_hsrp_group,
            uplink_vlan=uplink_vlan,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             uplink_hsrp_group: Optional[pulumi.Input[int]] = None,
             uplink_vlan: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'uplinkHsrpGroup' in kwargs:
            uplink_hsrp_group = kwargs['uplinkHsrpGroup']
        if 'uplinkVlan' in kwargs:
            uplink_vlan = kwargs['uplinkVlan']

        if uplink_hsrp_group is not None:
            _setter("uplink_hsrp_group", uplink_hsrp_group)
        if uplink_vlan is not None:
            _setter("uplink_vlan", uplink_vlan)

    @property
    @pulumi.getter(name="uplinkHsrpGroup")
    def uplink_hsrp_group(self) -> Optional[pulumi.Input[int]]:
        """
        The uplink Hot Standby Router Protocol (HSRP) group value for the switch in the Compute Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "uplink_hsrp_group")

    @uplink_hsrp_group.setter
    def uplink_hsrp_group(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "uplink_hsrp_group", value)

    @property
    @pulumi.getter(name="uplinkVlan")
    def uplink_vlan(self) -> Optional[pulumi.Input[int]]:
        """
        The virtual local area network (VLAN) identifier used to connect to the uplink (only access mode is supported).
        """
        return pulumi.get(self, "uplink_vlan")

    @uplink_vlan.setter
    def uplink_vlan(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "uplink_vlan", value)


@pulumi.input_type
class AtCustomerCccInfrastructureInfrastructureNetworkConfigurationManagementNodeArgs:
    def __init__(__self__, *,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] hostname: Hostname for interface to the management node.
        :param pulumi.Input[str] ip: Address of the management node.
        """
        AtCustomerCccInfrastructureInfrastructureNetworkConfigurationManagementNodeArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            hostname=hostname,
            ip=ip,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             hostname: Optional[pulumi.Input[str]] = None,
             ip: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if hostname is not None:
            _setter("hostname", hostname)
        if ip is not None:
            _setter("ip", ip)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname for interface to the management node.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        Address of the management node.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class AtCustomerCccInfrastructureUpgradeInformationArgs:
    def __init__(__self__, *,
                 current_version: Optional[pulumi.Input[str]] = None,
                 is_active: Optional[pulumi.Input[bool]] = None,
                 scheduled_upgrade_duration: Optional[pulumi.Input[str]] = None,
                 time_of_scheduled_upgrade: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] current_version: The current version of software installed on the Compute Cloud@Customer infrastructure.
        :param pulumi.Input[bool] is_active: Indication that the Compute Cloud@Customer infrastructure is in the process of an upgrade or an upgrade activity (such as preloading upgrade images).
        :param pulumi.Input[str] scheduled_upgrade_duration: Expected duration of Compute Cloud@Customer infrastructure scheduled upgrade. The actual upgrade time might be longer or shorter than this duration depending on rack activity, this is only an estimate.
        :param pulumi.Input[str] time_of_scheduled_upgrade: Compute Cloud@Customer infrastructure next upgrade time. The rack might have performance impacts during this time.
        """
        AtCustomerCccInfrastructureUpgradeInformationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            current_version=current_version,
            is_active=is_active,
            scheduled_upgrade_duration=scheduled_upgrade_duration,
            time_of_scheduled_upgrade=time_of_scheduled_upgrade,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             current_version: Optional[pulumi.Input[str]] = None,
             is_active: Optional[pulumi.Input[bool]] = None,
             scheduled_upgrade_duration: Optional[pulumi.Input[str]] = None,
             time_of_scheduled_upgrade: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'currentVersion' in kwargs:
            current_version = kwargs['currentVersion']
        if 'isActive' in kwargs:
            is_active = kwargs['isActive']
        if 'scheduledUpgradeDuration' in kwargs:
            scheduled_upgrade_duration = kwargs['scheduledUpgradeDuration']
        if 'timeOfScheduledUpgrade' in kwargs:
            time_of_scheduled_upgrade = kwargs['timeOfScheduledUpgrade']

        if current_version is not None:
            _setter("current_version", current_version)
        if is_active is not None:
            _setter("is_active", is_active)
        if scheduled_upgrade_duration is not None:
            _setter("scheduled_upgrade_duration", scheduled_upgrade_duration)
        if time_of_scheduled_upgrade is not None:
            _setter("time_of_scheduled_upgrade", time_of_scheduled_upgrade)

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional[pulumi.Input[str]]:
        """
        The current version of software installed on the Compute Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "current_version")

    @current_version.setter
    def current_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_version", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[bool]]:
        """
        Indication that the Compute Cloud@Customer infrastructure is in the process of an upgrade or an upgrade activity (such as preloading upgrade images).
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter(name="scheduledUpgradeDuration")
    def scheduled_upgrade_duration(self) -> Optional[pulumi.Input[str]]:
        """
        Expected duration of Compute Cloud@Customer infrastructure scheduled upgrade. The actual upgrade time might be longer or shorter than this duration depending on rack activity, this is only an estimate.
        """
        return pulumi.get(self, "scheduled_upgrade_duration")

    @scheduled_upgrade_duration.setter
    def scheduled_upgrade_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_upgrade_duration", value)

    @property
    @pulumi.getter(name="timeOfScheduledUpgrade")
    def time_of_scheduled_upgrade(self) -> Optional[pulumi.Input[str]]:
        """
        Compute Cloud@Customer infrastructure next upgrade time. The rack might have performance impacts during this time.
        """
        return pulumi.get(self, "time_of_scheduled_upgrade")

    @time_of_scheduled_upgrade.setter
    def time_of_scheduled_upgrade(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_scheduled_upgrade", value)


@pulumi.input_type
class AtCustomerCccUpgradeScheduleEventArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 schedule_event_duration: pulumi.Input[str],
                 time_start: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 schedule_event_recurrences: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: (Updatable) A description of the Compute Cloud@Customer upgrade schedule time block.
        :param pulumi.Input[str] schedule_event_duration: (Updatable) The duration of this block of time. The duration must be specified and be of the ISO-8601 format for durations.
        :param pulumi.Input[str] time_start: (Updatable) The date and time when the Compute Cloud@Customer upgrade schedule event starts, inclusive. An RFC3339 formatted UTC datetime string. For an event with recurrences, this is the date that a recurrence can start being applied.
        :param pulumi.Input[str] name: Generated name associated with the event.
        :param pulumi.Input[str] schedule_event_recurrences: (Updatable) Frequency of recurrence of schedule block. When this field is not included, the event is assumed to be a one time occurrence. The frequency field is strictly parsed and must conform to RFC-5545 formatting for recurrences.
        """
        AtCustomerCccUpgradeScheduleEventArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            schedule_event_duration=schedule_event_duration,
            time_start=time_start,
            name=name,
            schedule_event_recurrences=schedule_event_recurrences,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: pulumi.Input[str],
             schedule_event_duration: pulumi.Input[str],
             time_start: pulumi.Input[str],
             name: Optional[pulumi.Input[str]] = None,
             schedule_event_recurrences: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'scheduleEventDuration' in kwargs:
            schedule_event_duration = kwargs['scheduleEventDuration']
        if 'timeStart' in kwargs:
            time_start = kwargs['timeStart']
        if 'scheduleEventRecurrences' in kwargs:
            schedule_event_recurrences = kwargs['scheduleEventRecurrences']

        _setter("description", description)
        _setter("schedule_event_duration", schedule_event_duration)
        _setter("time_start", time_start)
        if name is not None:
            _setter("name", name)
        if schedule_event_recurrences is not None:
            _setter("schedule_event_recurrences", schedule_event_recurrences)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        (Updatable) A description of the Compute Cloud@Customer upgrade schedule time block.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="scheduleEventDuration")
    def schedule_event_duration(self) -> pulumi.Input[str]:
        """
        (Updatable) The duration of this block of time. The duration must be specified and be of the ISO-8601 format for durations.
        """
        return pulumi.get(self, "schedule_event_duration")

    @schedule_event_duration.setter
    def schedule_event_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule_event_duration", value)

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> pulumi.Input[str]:
        """
        (Updatable) The date and time when the Compute Cloud@Customer upgrade schedule event starts, inclusive. An RFC3339 formatted UTC datetime string. For an event with recurrences, this is the date that a recurrence can start being applied.
        """
        return pulumi.get(self, "time_start")

    @time_start.setter
    def time_start(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_start", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Generated name associated with the event.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="scheduleEventRecurrences")
    def schedule_event_recurrences(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Frequency of recurrence of schedule block. When this field is not included, the event is assumed to be a one time occurrence. The frequency field is strictly parsed and must conform to RFC-5545 formatting for recurrences.
        """
        return pulumi.get(self, "schedule_event_recurrences")

    @schedule_event_recurrences.setter
    def schedule_event_recurrences(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_event_recurrences", value)


@pulumi.input_type
class GetAtCustomerCccInfrastructuresFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetAtCustomerCccInfrastructuresFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetAtCustomerCccUpgradeSchedulesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Generated name associated with the event.
        """
        GetAtCustomerCccUpgradeSchedulesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Generated name associated with the event.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


