# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDrgRouteDistributionResult',
    'AwaitableGetDrgRouteDistributionResult',
    'get_drg_route_distribution',
    'get_drg_route_distribution_output',
]

@pulumi.output_type
class GetDrgRouteDistributionResult:
    """
    A collection of values returned by getDrgRouteDistribution.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, distribution_type=None, drg_id=None, drg_route_distribution_id=None, freeform_tags=None, id=None, state=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if distribution_type and not isinstance(distribution_type, str):
            raise TypeError("Expected argument 'distribution_type' to be a str")
        pulumi.set(__self__, "distribution_type", distribution_type)
        if drg_id and not isinstance(drg_id, str):
            raise TypeError("Expected argument 'drg_id' to be a str")
        pulumi.set(__self__, "drg_id", drg_id)
        if drg_route_distribution_id and not isinstance(drg_route_distribution_id, str):
            raise TypeError("Expected argument 'drg_route_distribution_id' to be a str")
        pulumi.set(__self__, "drg_route_distribution_id", drg_route_distribution_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the route distribution.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> str:
        """
        Whether this distribution defines how routes get imported into route tables or exported through DRG attachments.
        """
        return pulumi.get(self, "distribution_type")

    @property
    @pulumi.getter(name="drgId")
    def drg_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG that contains this route distribution.
        """
        return pulumi.get(self, "drg_id")

    @property
    @pulumi.getter(name="drgRouteDistributionId")
    def drg_route_distribution_id(self) -> str:
        return pulumi.get(self, "drg_route_distribution_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The route distribution's Oracle ID ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The route distribution's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the route distribution was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetDrgRouteDistributionResult(GetDrgRouteDistributionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDrgRouteDistributionResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            distribution_type=self.distribution_type,
            drg_id=self.drg_id,
            drg_route_distribution_id=self.drg_route_distribution_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            state=self.state,
            time_created=self.time_created)


def get_drg_route_distribution(drg_route_distribution_id: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDrgRouteDistributionResult:
    """
    This data source provides details about a specific Drg Route Distribution resource in Oracle Cloud Infrastructure Core service.

    Gets the specified route distribution's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_drg_route_distribution = oci.Core.get_drg_route_distribution(drg_route_distribution_id=oci_core_drg_route_distribution["test_drg_route_distribution"]["id"])
    ```


    :param str drg_route_distribution_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route distribution.
    """
    __args__ = dict()
    __args__['drgRouteDistributionId'] = drg_route_distribution_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getDrgRouteDistribution:getDrgRouteDistribution', __args__, opts=opts, typ=GetDrgRouteDistributionResult).value

    return AwaitableGetDrgRouteDistributionResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        distribution_type=pulumi.get(__ret__, 'distribution_type'),
        drg_id=pulumi.get(__ret__, 'drg_id'),
        drg_route_distribution_id=pulumi.get(__ret__, 'drg_route_distribution_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_drg_route_distribution)
def get_drg_route_distribution_output(drg_route_distribution_id: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDrgRouteDistributionResult]:
    """
    This data source provides details about a specific Drg Route Distribution resource in Oracle Cloud Infrastructure Core service.

    Gets the specified route distribution's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_drg_route_distribution = oci.Core.get_drg_route_distribution(drg_route_distribution_id=oci_core_drg_route_distribution["test_drg_route_distribution"]["id"])
    ```


    :param str drg_route_distribution_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route distribution.
    """
    ...
