# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetFastConnectProviderServiceResult',
    'AwaitableGetFastConnectProviderServiceResult',
    'get_fast_connect_provider_service',
    'get_fast_connect_provider_service_output',
]

@pulumi.output_type
class GetFastConnectProviderServiceResult:
    """
    A collection of values returned by getFastConnectProviderService.
    """
    def __init__(__self__, bandwith_shape_management=None, customer_asn_management=None, description=None, id=None, private_peering_bgp_management=None, provider_name=None, provider_service_id=None, provider_service_key_management=None, provider_service_name=None, public_peering_bgp_management=None, required_total_cross_connects=None, supported_virtual_circuit_types=None, type=None):
        if bandwith_shape_management and not isinstance(bandwith_shape_management, str):
            raise TypeError("Expected argument 'bandwith_shape_management' to be a str")
        pulumi.set(__self__, "bandwith_shape_management", bandwith_shape_management)
        if customer_asn_management and not isinstance(customer_asn_management, str):
            raise TypeError("Expected argument 'customer_asn_management' to be a str")
        pulumi.set(__self__, "customer_asn_management", customer_asn_management)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if private_peering_bgp_management and not isinstance(private_peering_bgp_management, str):
            raise TypeError("Expected argument 'private_peering_bgp_management' to be a str")
        pulumi.set(__self__, "private_peering_bgp_management", private_peering_bgp_management)
        if provider_name and not isinstance(provider_name, str):
            raise TypeError("Expected argument 'provider_name' to be a str")
        pulumi.set(__self__, "provider_name", provider_name)
        if provider_service_id and not isinstance(provider_service_id, str):
            raise TypeError("Expected argument 'provider_service_id' to be a str")
        pulumi.set(__self__, "provider_service_id", provider_service_id)
        if provider_service_key_management and not isinstance(provider_service_key_management, str):
            raise TypeError("Expected argument 'provider_service_key_management' to be a str")
        pulumi.set(__self__, "provider_service_key_management", provider_service_key_management)
        if provider_service_name and not isinstance(provider_service_name, str):
            raise TypeError("Expected argument 'provider_service_name' to be a str")
        pulumi.set(__self__, "provider_service_name", provider_service_name)
        if public_peering_bgp_management and not isinstance(public_peering_bgp_management, str):
            raise TypeError("Expected argument 'public_peering_bgp_management' to be a str")
        pulumi.set(__self__, "public_peering_bgp_management", public_peering_bgp_management)
        if required_total_cross_connects and not isinstance(required_total_cross_connects, int):
            raise TypeError("Expected argument 'required_total_cross_connects' to be a int")
        pulumi.set(__self__, "required_total_cross_connects", required_total_cross_connects)
        if supported_virtual_circuit_types and not isinstance(supported_virtual_circuit_types, list):
            raise TypeError("Expected argument 'supported_virtual_circuit_types' to be a list")
        pulumi.set(__self__, "supported_virtual_circuit_types", supported_virtual_circuit_types)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="bandwithShapeManagement")
    def bandwith_shape_management(self) -> str:
        """
        Who is responsible for managing the virtual circuit bandwidth.
        """
        return pulumi.get(self, "bandwith_shape_management")

    @property
    @pulumi.getter(name="customerAsnManagement")
    def customer_asn_management(self) -> str:
        """
        Who is responsible for managing the ASN information for the network at the other end of the connection from Oracle.
        """
        return pulumi.get(self, "customer_asn_management")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The location of the provider's website or portal. This portal is where you can get information about the provider service, create a virtual circuit connection from the provider to Oracle Cloud Infrastructure, and retrieve your provider service key for that virtual circuit connection.  Example: `https://example.com`
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="privatePeeringBgpManagement")
    def private_peering_bgp_management(self) -> str:
        """
        Who is responsible for managing the private peering BGP information.
        """
        return pulumi.get(self, "private_peering_bgp_management")

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> str:
        """
        The name of the provider.
        """
        return pulumi.get(self, "provider_name")

    @property
    @pulumi.getter(name="providerServiceId")
    def provider_service_id(self) -> str:
        return pulumi.get(self, "provider_service_id")

    @property
    @pulumi.getter(name="providerServiceKeyManagement")
    def provider_service_key_management(self) -> str:
        """
        Who is responsible for managing the provider service key.
        """
        return pulumi.get(self, "provider_service_key_management")

    @property
    @pulumi.getter(name="providerServiceName")
    def provider_service_name(self) -> str:
        """
        The name of the service offered by the provider.
        """
        return pulumi.get(self, "provider_service_name")

    @property
    @pulumi.getter(name="publicPeeringBgpManagement")
    def public_peering_bgp_management(self) -> str:
        """
        Who is responsible for managing the public peering BGP information.
        """
        return pulumi.get(self, "public_peering_bgp_management")

    @property
    @pulumi.getter(name="requiredTotalCrossConnects")
    def required_total_cross_connects(self) -> int:
        """
        Total number of cross-connect or cross-connect groups required for the virtual circuit.
        """
        return pulumi.get(self, "required_total_cross_connects")

    @property
    @pulumi.getter(name="supportedVirtualCircuitTypes")
    def supported_virtual_circuit_types(self) -> Sequence[str]:
        """
        An array of virtual circuit types supported by this service.
        """
        return pulumi.get(self, "supported_virtual_circuit_types")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Provider service type.
        """
        return pulumi.get(self, "type")


class AwaitableGetFastConnectProviderServiceResult(GetFastConnectProviderServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFastConnectProviderServiceResult(
            bandwith_shape_management=self.bandwith_shape_management,
            customer_asn_management=self.customer_asn_management,
            description=self.description,
            id=self.id,
            private_peering_bgp_management=self.private_peering_bgp_management,
            provider_name=self.provider_name,
            provider_service_id=self.provider_service_id,
            provider_service_key_management=self.provider_service_key_management,
            provider_service_name=self.provider_service_name,
            public_peering_bgp_management=self.public_peering_bgp_management,
            required_total_cross_connects=self.required_total_cross_connects,
            supported_virtual_circuit_types=self.supported_virtual_circuit_types,
            type=self.type)


def get_fast_connect_provider_service(provider_service_id: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFastConnectProviderServiceResult:
    """
    This data source provides details about a specific Fast Connect Provider Service resource in Oracle Cloud Infrastructure Core service.

    Gets the specified provider service.
    For more information, see [FastConnect Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnect.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fast_connect_provider_service = oci.Core.get_fast_connect_provider_service(provider_service_id=data["oci_core_fast_connect_provider_services"]["test_fast_connect_provider_services"]["fast_connect_provider_services"][0]["id"])
    ```


    :param str provider_service_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the provider service.
    """
    __args__ = dict()
    __args__['providerServiceId'] = provider_service_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getFastConnectProviderService:getFastConnectProviderService', __args__, opts=opts, typ=GetFastConnectProviderServiceResult).value

    return AwaitableGetFastConnectProviderServiceResult(
        bandwith_shape_management=pulumi.get(__ret__, 'bandwith_shape_management'),
        customer_asn_management=pulumi.get(__ret__, 'customer_asn_management'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        private_peering_bgp_management=pulumi.get(__ret__, 'private_peering_bgp_management'),
        provider_name=pulumi.get(__ret__, 'provider_name'),
        provider_service_id=pulumi.get(__ret__, 'provider_service_id'),
        provider_service_key_management=pulumi.get(__ret__, 'provider_service_key_management'),
        provider_service_name=pulumi.get(__ret__, 'provider_service_name'),
        public_peering_bgp_management=pulumi.get(__ret__, 'public_peering_bgp_management'),
        required_total_cross_connects=pulumi.get(__ret__, 'required_total_cross_connects'),
        supported_virtual_circuit_types=pulumi.get(__ret__, 'supported_virtual_circuit_types'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_fast_connect_provider_service)
def get_fast_connect_provider_service_output(provider_service_id: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFastConnectProviderServiceResult]:
    """
    This data source provides details about a specific Fast Connect Provider Service resource in Oracle Cloud Infrastructure Core service.

    Gets the specified provider service.
    For more information, see [FastConnect Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnect.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fast_connect_provider_service = oci.Core.get_fast_connect_provider_service(provider_service_id=data["oci_core_fast_connect_provider_services"]["test_fast_connect_provider_services"]["fast_connect_provider_services"][0]["id"])
    ```


    :param str provider_service_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the provider service.
    """
    ...
