# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutonomousVmClusterArgs', 'AutonomousVmCluster']

@pulumi.input_type
class AutonomousVmClusterArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 exadata_infrastructure_id: pulumi.Input[str],
                 vm_cluster_network_id: pulumi.Input[str],
                 autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 compute_model: Optional[pulumi.Input[str]] = None,
                 cpu_core_count_per_node: Optional[pulumi.Input[int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 is_mtls_enabled: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 maintenance_window_details: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousVmClusterMaintenanceWindowDetailArgs']]]] = None,
                 memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[int]] = None,
                 scan_listener_port_non_tls: Optional[pulumi.Input[int]] = None,
                 scan_listener_port_tls: Optional[pulumi.Input[int]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 total_container_databases: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a AutonomousVmCluster resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] display_name: The user-friendly name for the Autonomous VM cluster. The name does not need to be unique.
        :param pulumi.Input[str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[str] vm_cluster_network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[float] autonomous_data_storage_size_in_tbs: The data disk group size to be allocated for Autonomous Databases, in TBs.
        :param pulumi.Input[str] compute_model: The compute model of the Autonomous VM Cluster.
        :param pulumi.Input[int] cpu_core_count_per_node: The number of CPU cores to enable per VM cluster node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_servers: The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Db servers.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_local_backup_enabled: If true, database backup on local Exadata storage is configured for the Autonomous VM cluster. If false, database backup on local Exadata storage is not available in the Autonomous VM cluster.
        :param pulumi.Input[bool] is_mtls_enabled: Enable mutual TLS(mTLS) authentication for database while provisioning a VMCluster. Default is TLS.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the Autonomous VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousVmClusterMaintenanceWindowDetailArgs']]] maintenance_window_details: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) to be enabled per OCPU or ECPU.
        :param pulumi.Input[int] scan_listener_port_non_tls: The SCAN Listener Non TLS port number. Default value is 1521.
        :param pulumi.Input[int] scan_listener_port_tls: The SCAN Listener TLS port number. Default value is 2484.
        :param pulumi.Input[str] time_zone: The time zone to use for the Autonomous VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[int] total_container_databases: The total number of Autonomous Container Databases that can be created.
        """
        AutonomousVmClusterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            display_name=display_name,
            exadata_infrastructure_id=exadata_infrastructure_id,
            vm_cluster_network_id=vm_cluster_network_id,
            autonomous_data_storage_size_in_tbs=autonomous_data_storage_size_in_tbs,
            compute_model=compute_model,
            cpu_core_count_per_node=cpu_core_count_per_node,
            db_servers=db_servers,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            is_local_backup_enabled=is_local_backup_enabled,
            is_mtls_enabled=is_mtls_enabled,
            license_model=license_model,
            maintenance_window_details=maintenance_window_details,
            memory_per_oracle_compute_unit_in_gbs=memory_per_oracle_compute_unit_in_gbs,
            scan_listener_port_non_tls=scan_listener_port_non_tls,
            scan_listener_port_tls=scan_listener_port_tls,
            time_zone=time_zone,
            total_container_databases=total_container_databases,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             display_name: pulumi.Input[str],
             exadata_infrastructure_id: pulumi.Input[str],
             vm_cluster_network_id: pulumi.Input[str],
             autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
             compute_model: Optional[pulumi.Input[str]] = None,
             cpu_core_count_per_node: Optional[pulumi.Input[int]] = None,
             db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             is_local_backup_enabled: Optional[pulumi.Input[bool]] = None,
             is_mtls_enabled: Optional[pulumi.Input[bool]] = None,
             license_model: Optional[pulumi.Input[str]] = None,
             maintenance_window_details: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousVmClusterMaintenanceWindowDetailArgs']]]] = None,
             memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[int]] = None,
             scan_listener_port_non_tls: Optional[pulumi.Input[int]] = None,
             scan_listener_port_tls: Optional[pulumi.Input[int]] = None,
             time_zone: Optional[pulumi.Input[str]] = None,
             total_container_databases: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'exadataInfrastructureId' in kwargs:
            exadata_infrastructure_id = kwargs['exadataInfrastructureId']
        if 'vmClusterNetworkId' in kwargs:
            vm_cluster_network_id = kwargs['vmClusterNetworkId']
        if 'autonomousDataStorageSizeInTbs' in kwargs:
            autonomous_data_storage_size_in_tbs = kwargs['autonomousDataStorageSizeInTbs']
        if 'computeModel' in kwargs:
            compute_model = kwargs['computeModel']
        if 'cpuCoreCountPerNode' in kwargs:
            cpu_core_count_per_node = kwargs['cpuCoreCountPerNode']
        if 'dbServers' in kwargs:
            db_servers = kwargs['dbServers']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isLocalBackupEnabled' in kwargs:
            is_local_backup_enabled = kwargs['isLocalBackupEnabled']
        if 'isMtlsEnabled' in kwargs:
            is_mtls_enabled = kwargs['isMtlsEnabled']
        if 'licenseModel' in kwargs:
            license_model = kwargs['licenseModel']
        if 'maintenanceWindowDetails' in kwargs:
            maintenance_window_details = kwargs['maintenanceWindowDetails']
        if 'memoryPerOracleComputeUnitInGbs' in kwargs:
            memory_per_oracle_compute_unit_in_gbs = kwargs['memoryPerOracleComputeUnitInGbs']
        if 'scanListenerPortNonTls' in kwargs:
            scan_listener_port_non_tls = kwargs['scanListenerPortNonTls']
        if 'scanListenerPortTls' in kwargs:
            scan_listener_port_tls = kwargs['scanListenerPortTls']
        if 'timeZone' in kwargs:
            time_zone = kwargs['timeZone']
        if 'totalContainerDatabases' in kwargs:
            total_container_databases = kwargs['totalContainerDatabases']

        _setter("compartment_id", compartment_id)
        _setter("display_name", display_name)
        _setter("exadata_infrastructure_id", exadata_infrastructure_id)
        _setter("vm_cluster_network_id", vm_cluster_network_id)
        if autonomous_data_storage_size_in_tbs is not None:
            _setter("autonomous_data_storage_size_in_tbs", autonomous_data_storage_size_in_tbs)
        if compute_model is not None:
            _setter("compute_model", compute_model)
        if cpu_core_count_per_node is not None:
            _setter("cpu_core_count_per_node", cpu_core_count_per_node)
        if db_servers is not None:
            _setter("db_servers", db_servers)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if is_local_backup_enabled is not None:
            _setter("is_local_backup_enabled", is_local_backup_enabled)
        if is_mtls_enabled is not None:
            _setter("is_mtls_enabled", is_mtls_enabled)
        if license_model is not None:
            _setter("license_model", license_model)
        if maintenance_window_details is not None:
            _setter("maintenance_window_details", maintenance_window_details)
        if memory_per_oracle_compute_unit_in_gbs is not None:
            _setter("memory_per_oracle_compute_unit_in_gbs", memory_per_oracle_compute_unit_in_gbs)
        if scan_listener_port_non_tls is not None:
            _setter("scan_listener_port_non_tls", scan_listener_port_non_tls)
        if scan_listener_port_tls is not None:
            _setter("scan_listener_port_tls", scan_listener_port_tls)
        if time_zone is not None:
            _setter("time_zone", time_zone)
        if total_container_databases is not None:
            _setter("total_container_databases", total_container_databases)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The user-friendly name for the Autonomous VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="vmClusterNetworkId")
    def vm_cluster_network_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vm_cluster_network_id")

    @vm_cluster_network_id.setter
    def vm_cluster_network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vm_cluster_network_id", value)

    @property
    @pulumi.getter(name="autonomousDataStorageSizeInTbs")
    def autonomous_data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        The data disk group size to be allocated for Autonomous Databases, in TBs.
        """
        return pulumi.get(self, "autonomous_data_storage_size_in_tbs")

    @autonomous_data_storage_size_in_tbs.setter
    def autonomous_data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "autonomous_data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[str]]:
        """
        The compute model of the Autonomous VM Cluster.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_model", value)

    @property
    @pulumi.getter(name="cpuCoreCountPerNode")
    def cpu_core_count_per_node(self) -> Optional[pulumi.Input[int]]:
        """
        The number of CPU cores to enable per VM cluster node.
        """
        return pulumi.get(self, "cpu_core_count_per_node")

    @cpu_core_count_per_node.setter
    def cpu_core_count_per_node(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count_per_node", value)

    @property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Db servers.
        """
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "db_servers", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, database backup on local Exadata storage is configured for the Autonomous VM cluster. If false, database backup on local Exadata storage is not available in the Autonomous VM cluster.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @is_local_backup_enabled.setter
    def is_local_backup_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_local_backup_enabled", value)

    @property
    @pulumi.getter(name="isMtlsEnabled")
    def is_mtls_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable mutual TLS(mTLS) authentication for database while provisioning a VMCluster. Default is TLS.
        """
        return pulumi.get(self, "is_mtls_enabled")

    @is_mtls_enabled.setter
    def is_mtls_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_mtls_enabled", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle license model that applies to the Autonomous VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="maintenanceWindowDetails")
    def maintenance_window_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousVmClusterMaintenanceWindowDetailArgs']]]]:
        """
        (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_window_details")

    @maintenance_window_details.setter
    def maintenance_window_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousVmClusterMaintenanceWindowDetailArgs']]]]):
        pulumi.set(self, "maintenance_window_details", value)

    @property
    @pulumi.getter(name="memoryPerOracleComputeUnitInGbs")
    def memory_per_oracle_compute_unit_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of memory (in GBs) to be enabled per OCPU or ECPU.
        """
        return pulumi.get(self, "memory_per_oracle_compute_unit_in_gbs")

    @memory_per_oracle_compute_unit_in_gbs.setter
    def memory_per_oracle_compute_unit_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_per_oracle_compute_unit_in_gbs", value)

    @property
    @pulumi.getter(name="scanListenerPortNonTls")
    def scan_listener_port_non_tls(self) -> Optional[pulumi.Input[int]]:
        """
        The SCAN Listener Non TLS port number. Default value is 1521.
        """
        return pulumi.get(self, "scan_listener_port_non_tls")

    @scan_listener_port_non_tls.setter
    def scan_listener_port_non_tls(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scan_listener_port_non_tls", value)

    @property
    @pulumi.getter(name="scanListenerPortTls")
    def scan_listener_port_tls(self) -> Optional[pulumi.Input[int]]:
        """
        The SCAN Listener TLS port number. Default value is 2484.
        """
        return pulumi.get(self, "scan_listener_port_tls")

    @scan_listener_port_tls.setter
    def scan_listener_port_tls(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scan_listener_port_tls", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone to use for the Autonomous VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="totalContainerDatabases")
    def total_container_databases(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of Autonomous Container Databases that can be created.
        """
        return pulumi.get(self, "total_container_databases")

    @total_container_databases.setter
    def total_container_databases(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_container_databases", value)


@pulumi.input_type
class _AutonomousVmClusterState:
    def __init__(__self__, *,
                 autonomous_data_storage_percentage: Optional[pulumi.Input[float]] = None,
                 autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 available_autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 available_container_databases: Optional[pulumi.Input[int]] = None,
                 available_cpus: Optional[pulumi.Input[int]] = None,
                 available_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_model: Optional[pulumi.Input[str]] = None,
                 cpu_core_count_per_node: Optional[pulumi.Input[int]] = None,
                 cpu_percentage: Optional[pulumi.Input[float]] = None,
                 cpus_enabled: Optional[pulumi.Input[int]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[float]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 is_mtls_enabled: Optional[pulumi.Input[bool]] = None,
                 last_maintenance_run_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 maintenance_window_details: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousVmClusterMaintenanceWindowDetailArgs']]]] = None,
                 maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousVmClusterMaintenanceWindowArgs']]]] = None,
                 memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[int]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 next_maintenance_run_id: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 non_provisionable_autonomous_container_databases: Optional[pulumi.Input[int]] = None,
                 ocpus_enabled: Optional[pulumi.Input[float]] = None,
                 provisioned_autonomous_container_databases: Optional[pulumi.Input[int]] = None,
                 provisioned_cpus: Optional[pulumi.Input[float]] = None,
                 reclaimable_cpus: Optional[pulumi.Input[int]] = None,
                 reserved_cpus: Optional[pulumi.Input[float]] = None,
                 scan_listener_port_non_tls: Optional[pulumi.Input[int]] = None,
                 scan_listener_port_tls: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_database_ssl_certificate_expires: Optional[pulumi.Input[str]] = None,
                 time_ords_certificate_expires: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 total_autonomous_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
                 total_container_databases: Optional[pulumi.Input[int]] = None,
                 vm_cluster_network_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AutonomousVmCluster resources.
        :param pulumi.Input[float] autonomous_data_storage_size_in_tbs: The data disk group size to be allocated for Autonomous Databases, in TBs.
        :param pulumi.Input[float] available_autonomous_data_storage_size_in_tbs: The data disk group size available for Autonomous Databases, in TBs.
        :param pulumi.Input[int] available_container_databases: The number of Autonomous Container Databases that can be created with the currently available local storage.
        :param pulumi.Input[int] available_cpus: The numnber of CPU cores available.
        :param pulumi.Input[float] available_data_storage_size_in_tbs: **Deprecated.** Use `availableAutonomousDataStorageSizeInTBs` for Autonomous Databases' data storage availability in TBs.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] compute_model: The compute model of the Autonomous VM Cluster.
        :param pulumi.Input[int] cpu_core_count_per_node: The number of CPU cores to enable per VM cluster node.
        :param pulumi.Input[int] cpus_enabled: The number of enabled CPU cores.
        :param pulumi.Input[float] data_storage_size_in_tbs: The total data storage allocated in TBs
        :param pulumi.Input[int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_servers: The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Db servers.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-friendly name for the Autonomous VM cluster. The name does not need to be unique.
        :param pulumi.Input[str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_local_backup_enabled: If true, database backup on local Exadata storage is configured for the Autonomous VM cluster. If false, database backup on local Exadata storage is not available in the Autonomous VM cluster.
        :param pulumi.Input[bool] is_mtls_enabled: Enable mutual TLS(mTLS) authentication for database while provisioning a VMCluster. Default is TLS.
        :param pulumi.Input[str] last_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the Autonomous VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousVmClusterMaintenanceWindowDetailArgs']]] maintenance_window_details: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousVmClusterMaintenanceWindowArgs']]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) to be enabled per OCPU or ECPU.
        :param pulumi.Input[int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[str] next_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        :param pulumi.Input[int] node_count: The number of nodes in the Autonomous VM Cluster.
        :param pulumi.Input[float] ocpus_enabled: The number of enabled OCPU cores.
        :param pulumi.Input[int] reclaimable_cpus: For Autonomous Databases on Dedicated Exadata Infrastructure:
               * These are the CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.
               * The CPU type (OCPUs or ECPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model.
        :param pulumi.Input[int] scan_listener_port_non_tls: The SCAN Listener Non TLS port number. Default value is 1521.
        :param pulumi.Input[int] scan_listener_port_tls: The SCAN Listener TLS port number. Default value is 2484.
        :param pulumi.Input[str] state: The current state of the Autonomous VM cluster.
        :param pulumi.Input[str] time_created: The date and time that the Autonomous VM cluster was created.
        :param pulumi.Input[str] time_database_ssl_certificate_expires: The date and time of Database SSL certificate expiration.
        :param pulumi.Input[str] time_ords_certificate_expires: The date and time of ORDS certificate expiration.
        :param pulumi.Input[str] time_zone: The time zone to use for the Autonomous VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[int] total_container_databases: The total number of Autonomous Container Databases that can be created.
        :param pulumi.Input[str] vm_cluster_network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        _AutonomousVmClusterState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            autonomous_data_storage_percentage=autonomous_data_storage_percentage,
            autonomous_data_storage_size_in_tbs=autonomous_data_storage_size_in_tbs,
            available_autonomous_data_storage_size_in_tbs=available_autonomous_data_storage_size_in_tbs,
            available_container_databases=available_container_databases,
            available_cpus=available_cpus,
            available_data_storage_size_in_tbs=available_data_storage_size_in_tbs,
            compartment_id=compartment_id,
            compute_model=compute_model,
            cpu_core_count_per_node=cpu_core_count_per_node,
            cpu_percentage=cpu_percentage,
            cpus_enabled=cpus_enabled,
            data_storage_size_in_gb=data_storage_size_in_gb,
            data_storage_size_in_tbs=data_storage_size_in_tbs,
            db_node_storage_size_in_gbs=db_node_storage_size_in_gbs,
            db_servers=db_servers,
            defined_tags=defined_tags,
            display_name=display_name,
            exadata_infrastructure_id=exadata_infrastructure_id,
            freeform_tags=freeform_tags,
            is_local_backup_enabled=is_local_backup_enabled,
            is_mtls_enabled=is_mtls_enabled,
            last_maintenance_run_id=last_maintenance_run_id,
            license_model=license_model,
            lifecycle_details=lifecycle_details,
            maintenance_window_details=maintenance_window_details,
            maintenance_windows=maintenance_windows,
            memory_per_oracle_compute_unit_in_gbs=memory_per_oracle_compute_unit_in_gbs,
            memory_size_in_gbs=memory_size_in_gbs,
            next_maintenance_run_id=next_maintenance_run_id,
            node_count=node_count,
            non_provisionable_autonomous_container_databases=non_provisionable_autonomous_container_databases,
            ocpus_enabled=ocpus_enabled,
            provisioned_autonomous_container_databases=provisioned_autonomous_container_databases,
            provisioned_cpus=provisioned_cpus,
            reclaimable_cpus=reclaimable_cpus,
            reserved_cpus=reserved_cpus,
            scan_listener_port_non_tls=scan_listener_port_non_tls,
            scan_listener_port_tls=scan_listener_port_tls,
            state=state,
            time_created=time_created,
            time_database_ssl_certificate_expires=time_database_ssl_certificate_expires,
            time_ords_certificate_expires=time_ords_certificate_expires,
            time_zone=time_zone,
            total_autonomous_data_storage_in_tbs=total_autonomous_data_storage_in_tbs,
            total_container_databases=total_container_databases,
            vm_cluster_network_id=vm_cluster_network_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             autonomous_data_storage_percentage: Optional[pulumi.Input[float]] = None,
             autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
             available_autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
             available_container_databases: Optional[pulumi.Input[int]] = None,
             available_cpus: Optional[pulumi.Input[int]] = None,
             available_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             compute_model: Optional[pulumi.Input[str]] = None,
             cpu_core_count_per_node: Optional[pulumi.Input[int]] = None,
             cpu_percentage: Optional[pulumi.Input[float]] = None,
             cpus_enabled: Optional[pulumi.Input[int]] = None,
             data_storage_size_in_gb: Optional[pulumi.Input[float]] = None,
             data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
             db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
             db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             is_local_backup_enabled: Optional[pulumi.Input[bool]] = None,
             is_mtls_enabled: Optional[pulumi.Input[bool]] = None,
             last_maintenance_run_id: Optional[pulumi.Input[str]] = None,
             license_model: Optional[pulumi.Input[str]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             maintenance_window_details: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousVmClusterMaintenanceWindowDetailArgs']]]] = None,
             maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousVmClusterMaintenanceWindowArgs']]]] = None,
             memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[int]] = None,
             memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
             next_maintenance_run_id: Optional[pulumi.Input[str]] = None,
             node_count: Optional[pulumi.Input[int]] = None,
             non_provisionable_autonomous_container_databases: Optional[pulumi.Input[int]] = None,
             ocpus_enabled: Optional[pulumi.Input[float]] = None,
             provisioned_autonomous_container_databases: Optional[pulumi.Input[int]] = None,
             provisioned_cpus: Optional[pulumi.Input[float]] = None,
             reclaimable_cpus: Optional[pulumi.Input[int]] = None,
             reserved_cpus: Optional[pulumi.Input[float]] = None,
             scan_listener_port_non_tls: Optional[pulumi.Input[int]] = None,
             scan_listener_port_tls: Optional[pulumi.Input[int]] = None,
             state: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_database_ssl_certificate_expires: Optional[pulumi.Input[str]] = None,
             time_ords_certificate_expires: Optional[pulumi.Input[str]] = None,
             time_zone: Optional[pulumi.Input[str]] = None,
             total_autonomous_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
             total_container_databases: Optional[pulumi.Input[int]] = None,
             vm_cluster_network_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'autonomousDataStoragePercentage' in kwargs:
            autonomous_data_storage_percentage = kwargs['autonomousDataStoragePercentage']
        if 'autonomousDataStorageSizeInTbs' in kwargs:
            autonomous_data_storage_size_in_tbs = kwargs['autonomousDataStorageSizeInTbs']
        if 'availableAutonomousDataStorageSizeInTbs' in kwargs:
            available_autonomous_data_storage_size_in_tbs = kwargs['availableAutonomousDataStorageSizeInTbs']
        if 'availableContainerDatabases' in kwargs:
            available_container_databases = kwargs['availableContainerDatabases']
        if 'availableCpus' in kwargs:
            available_cpus = kwargs['availableCpus']
        if 'availableDataStorageSizeInTbs' in kwargs:
            available_data_storage_size_in_tbs = kwargs['availableDataStorageSizeInTbs']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'computeModel' in kwargs:
            compute_model = kwargs['computeModel']
        if 'cpuCoreCountPerNode' in kwargs:
            cpu_core_count_per_node = kwargs['cpuCoreCountPerNode']
        if 'cpuPercentage' in kwargs:
            cpu_percentage = kwargs['cpuPercentage']
        if 'cpusEnabled' in kwargs:
            cpus_enabled = kwargs['cpusEnabled']
        if 'dataStorageSizeInGb' in kwargs:
            data_storage_size_in_gb = kwargs['dataStorageSizeInGb']
        if 'dataStorageSizeInTbs' in kwargs:
            data_storage_size_in_tbs = kwargs['dataStorageSizeInTbs']
        if 'dbNodeStorageSizeInGbs' in kwargs:
            db_node_storage_size_in_gbs = kwargs['dbNodeStorageSizeInGbs']
        if 'dbServers' in kwargs:
            db_servers = kwargs['dbServers']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'exadataInfrastructureId' in kwargs:
            exadata_infrastructure_id = kwargs['exadataInfrastructureId']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isLocalBackupEnabled' in kwargs:
            is_local_backup_enabled = kwargs['isLocalBackupEnabled']
        if 'isMtlsEnabled' in kwargs:
            is_mtls_enabled = kwargs['isMtlsEnabled']
        if 'lastMaintenanceRunId' in kwargs:
            last_maintenance_run_id = kwargs['lastMaintenanceRunId']
        if 'licenseModel' in kwargs:
            license_model = kwargs['licenseModel']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'maintenanceWindowDetails' in kwargs:
            maintenance_window_details = kwargs['maintenanceWindowDetails']
        if 'maintenanceWindows' in kwargs:
            maintenance_windows = kwargs['maintenanceWindows']
        if 'memoryPerOracleComputeUnitInGbs' in kwargs:
            memory_per_oracle_compute_unit_in_gbs = kwargs['memoryPerOracleComputeUnitInGbs']
        if 'memorySizeInGbs' in kwargs:
            memory_size_in_gbs = kwargs['memorySizeInGbs']
        if 'nextMaintenanceRunId' in kwargs:
            next_maintenance_run_id = kwargs['nextMaintenanceRunId']
        if 'nodeCount' in kwargs:
            node_count = kwargs['nodeCount']
        if 'nonProvisionableAutonomousContainerDatabases' in kwargs:
            non_provisionable_autonomous_container_databases = kwargs['nonProvisionableAutonomousContainerDatabases']
        if 'ocpusEnabled' in kwargs:
            ocpus_enabled = kwargs['ocpusEnabled']
        if 'provisionedAutonomousContainerDatabases' in kwargs:
            provisioned_autonomous_container_databases = kwargs['provisionedAutonomousContainerDatabases']
        if 'provisionedCpus' in kwargs:
            provisioned_cpus = kwargs['provisionedCpus']
        if 'reclaimableCpus' in kwargs:
            reclaimable_cpus = kwargs['reclaimableCpus']
        if 'reservedCpus' in kwargs:
            reserved_cpus = kwargs['reservedCpus']
        if 'scanListenerPortNonTls' in kwargs:
            scan_listener_port_non_tls = kwargs['scanListenerPortNonTls']
        if 'scanListenerPortTls' in kwargs:
            scan_listener_port_tls = kwargs['scanListenerPortTls']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeDatabaseSslCertificateExpires' in kwargs:
            time_database_ssl_certificate_expires = kwargs['timeDatabaseSslCertificateExpires']
        if 'timeOrdsCertificateExpires' in kwargs:
            time_ords_certificate_expires = kwargs['timeOrdsCertificateExpires']
        if 'timeZone' in kwargs:
            time_zone = kwargs['timeZone']
        if 'totalAutonomousDataStorageInTbs' in kwargs:
            total_autonomous_data_storage_in_tbs = kwargs['totalAutonomousDataStorageInTbs']
        if 'totalContainerDatabases' in kwargs:
            total_container_databases = kwargs['totalContainerDatabases']
        if 'vmClusterNetworkId' in kwargs:
            vm_cluster_network_id = kwargs['vmClusterNetworkId']

        if autonomous_data_storage_percentage is not None:
            _setter("autonomous_data_storage_percentage", autonomous_data_storage_percentage)
        if autonomous_data_storage_size_in_tbs is not None:
            _setter("autonomous_data_storage_size_in_tbs", autonomous_data_storage_size_in_tbs)
        if available_autonomous_data_storage_size_in_tbs is not None:
            _setter("available_autonomous_data_storage_size_in_tbs", available_autonomous_data_storage_size_in_tbs)
        if available_container_databases is not None:
            _setter("available_container_databases", available_container_databases)
        if available_cpus is not None:
            _setter("available_cpus", available_cpus)
        if available_data_storage_size_in_tbs is not None:
            _setter("available_data_storage_size_in_tbs", available_data_storage_size_in_tbs)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if compute_model is not None:
            _setter("compute_model", compute_model)
        if cpu_core_count_per_node is not None:
            _setter("cpu_core_count_per_node", cpu_core_count_per_node)
        if cpu_percentage is not None:
            _setter("cpu_percentage", cpu_percentage)
        if cpus_enabled is not None:
            _setter("cpus_enabled", cpus_enabled)
        if data_storage_size_in_gb is not None:
            _setter("data_storage_size_in_gb", data_storage_size_in_gb)
        if data_storage_size_in_tbs is not None:
            _setter("data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            _setter("db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_servers is not None:
            _setter("db_servers", db_servers)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if exadata_infrastructure_id is not None:
            _setter("exadata_infrastructure_id", exadata_infrastructure_id)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if is_local_backup_enabled is not None:
            _setter("is_local_backup_enabled", is_local_backup_enabled)
        if is_mtls_enabled is not None:
            _setter("is_mtls_enabled", is_mtls_enabled)
        if last_maintenance_run_id is not None:
            _setter("last_maintenance_run_id", last_maintenance_run_id)
        if license_model is not None:
            _setter("license_model", license_model)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if maintenance_window_details is not None:
            _setter("maintenance_window_details", maintenance_window_details)
        if maintenance_windows is not None:
            _setter("maintenance_windows", maintenance_windows)
        if memory_per_oracle_compute_unit_in_gbs is not None:
            _setter("memory_per_oracle_compute_unit_in_gbs", memory_per_oracle_compute_unit_in_gbs)
        if memory_size_in_gbs is not None:
            _setter("memory_size_in_gbs", memory_size_in_gbs)
        if next_maintenance_run_id is not None:
            _setter("next_maintenance_run_id", next_maintenance_run_id)
        if node_count is not None:
            _setter("node_count", node_count)
        if non_provisionable_autonomous_container_databases is not None:
            _setter("non_provisionable_autonomous_container_databases", non_provisionable_autonomous_container_databases)
        if ocpus_enabled is not None:
            _setter("ocpus_enabled", ocpus_enabled)
        if provisioned_autonomous_container_databases is not None:
            _setter("provisioned_autonomous_container_databases", provisioned_autonomous_container_databases)
        if provisioned_cpus is not None:
            _setter("provisioned_cpus", provisioned_cpus)
        if reclaimable_cpus is not None:
            _setter("reclaimable_cpus", reclaimable_cpus)
        if reserved_cpus is not None:
            _setter("reserved_cpus", reserved_cpus)
        if scan_listener_port_non_tls is not None:
            _setter("scan_listener_port_non_tls", scan_listener_port_non_tls)
        if scan_listener_port_tls is not None:
            _setter("scan_listener_port_tls", scan_listener_port_tls)
        if state is not None:
            _setter("state", state)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_database_ssl_certificate_expires is not None:
            _setter("time_database_ssl_certificate_expires", time_database_ssl_certificate_expires)
        if time_ords_certificate_expires is not None:
            _setter("time_ords_certificate_expires", time_ords_certificate_expires)
        if time_zone is not None:
            _setter("time_zone", time_zone)
        if total_autonomous_data_storage_in_tbs is not None:
            _setter("total_autonomous_data_storage_in_tbs", total_autonomous_data_storage_in_tbs)
        if total_container_databases is not None:
            _setter("total_container_databases", total_container_databases)
        if vm_cluster_network_id is not None:
            _setter("vm_cluster_network_id", vm_cluster_network_id)

    @property
    @pulumi.getter(name="autonomousDataStoragePercentage")
    def autonomous_data_storage_percentage(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "autonomous_data_storage_percentage")

    @autonomous_data_storage_percentage.setter
    def autonomous_data_storage_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "autonomous_data_storage_percentage", value)

    @property
    @pulumi.getter(name="autonomousDataStorageSizeInTbs")
    def autonomous_data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        The data disk group size to be allocated for Autonomous Databases, in TBs.
        """
        return pulumi.get(self, "autonomous_data_storage_size_in_tbs")

    @autonomous_data_storage_size_in_tbs.setter
    def autonomous_data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "autonomous_data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="availableAutonomousDataStorageSizeInTbs")
    def available_autonomous_data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        The data disk group size available for Autonomous Databases, in TBs.
        """
        return pulumi.get(self, "available_autonomous_data_storage_size_in_tbs")

    @available_autonomous_data_storage_size_in_tbs.setter
    def available_autonomous_data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "available_autonomous_data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="availableContainerDatabases")
    def available_container_databases(self) -> Optional[pulumi.Input[int]]:
        """
        The number of Autonomous Container Databases that can be created with the currently available local storage.
        """
        return pulumi.get(self, "available_container_databases")

    @available_container_databases.setter
    def available_container_databases(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "available_container_databases", value)

    @property
    @pulumi.getter(name="availableCpus")
    def available_cpus(self) -> Optional[pulumi.Input[int]]:
        """
        The numnber of CPU cores available.
        """
        return pulumi.get(self, "available_cpus")

    @available_cpus.setter
    def available_cpus(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "available_cpus", value)

    @property
    @pulumi.getter(name="availableDataStorageSizeInTbs")
    def available_data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        **Deprecated.** Use `availableAutonomousDataStorageSizeInTBs` for Autonomous Databases' data storage availability in TBs.
        """
        return pulumi.get(self, "available_data_storage_size_in_tbs")

    @available_data_storage_size_in_tbs.setter
    def available_data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "available_data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[str]]:
        """
        The compute model of the Autonomous VM Cluster.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_model", value)

    @property
    @pulumi.getter(name="cpuCoreCountPerNode")
    def cpu_core_count_per_node(self) -> Optional[pulumi.Input[int]]:
        """
        The number of CPU cores to enable per VM cluster node.
        """
        return pulumi.get(self, "cpu_core_count_per_node")

    @cpu_core_count_per_node.setter
    def cpu_core_count_per_node(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count_per_node", value)

    @property
    @pulumi.getter(name="cpuPercentage")
    def cpu_percentage(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "cpu_percentage")

    @cpu_percentage.setter
    def cpu_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu_percentage", value)

    @property
    @pulumi.getter(name="cpusEnabled")
    def cpus_enabled(self) -> Optional[pulumi.Input[int]]:
        """
        The number of enabled CPU cores.
        """
        return pulumi.get(self, "cpus_enabled")

    @cpus_enabled.setter
    def cpus_enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpus_enabled", value)

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "data_storage_size_in_gb")

    @data_storage_size_in_gb.setter
    def data_storage_size_in_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "data_storage_size_in_gb", value)

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        The total data storage allocated in TBs
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Db servers.
        """
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "db_servers", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name for the Autonomous VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, database backup on local Exadata storage is configured for the Autonomous VM cluster. If false, database backup on local Exadata storage is not available in the Autonomous VM cluster.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @is_local_backup_enabled.setter
    def is_local_backup_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_local_backup_enabled", value)

    @property
    @pulumi.getter(name="isMtlsEnabled")
    def is_mtls_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable mutual TLS(mTLS) authentication for database while provisioning a VMCluster. Default is TLS.
        """
        return pulumi.get(self, "is_mtls_enabled")

    @is_mtls_enabled.setter
    def is_mtls_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_mtls_enabled", value)

    @property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @last_maintenance_run_id.setter
    def last_maintenance_run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_maintenance_run_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle license model that applies to the Autonomous VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="maintenanceWindowDetails")
    def maintenance_window_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousVmClusterMaintenanceWindowDetailArgs']]]]:
        """
        (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_window_details")

    @maintenance_window_details.setter
    def maintenance_window_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousVmClusterMaintenanceWindowDetailArgs']]]]):
        pulumi.set(self, "maintenance_window_details", value)

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousVmClusterMaintenanceWindowArgs']]]]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @maintenance_windows.setter
    def maintenance_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousVmClusterMaintenanceWindowArgs']]]]):
        pulumi.set(self, "maintenance_windows", value)

    @property
    @pulumi.getter(name="memoryPerOracleComputeUnitInGbs")
    def memory_per_oracle_compute_unit_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of memory (in GBs) to be enabled per OCPU or ECPU.
        """
        return pulumi.get(self, "memory_per_oracle_compute_unit_in_gbs")

    @memory_per_oracle_compute_unit_in_gbs.setter
    def memory_per_oracle_compute_unit_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_per_oracle_compute_unit_in_gbs", value)

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @next_maintenance_run_id.setter
    def next_maintenance_run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_maintenance_run_id", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes in the Autonomous VM Cluster.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nonProvisionableAutonomousContainerDatabases")
    def non_provisionable_autonomous_container_databases(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "non_provisionable_autonomous_container_databases")

    @non_provisionable_autonomous_container_databases.setter
    def non_provisionable_autonomous_container_databases(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "non_provisionable_autonomous_container_databases", value)

    @property
    @pulumi.getter(name="ocpusEnabled")
    def ocpus_enabled(self) -> Optional[pulumi.Input[float]]:
        """
        The number of enabled OCPU cores.
        """
        return pulumi.get(self, "ocpus_enabled")

    @ocpus_enabled.setter
    def ocpus_enabled(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ocpus_enabled", value)

    @property
    @pulumi.getter(name="provisionedAutonomousContainerDatabases")
    def provisioned_autonomous_container_databases(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "provisioned_autonomous_container_databases")

    @provisioned_autonomous_container_databases.setter
    def provisioned_autonomous_container_databases(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provisioned_autonomous_container_databases", value)

    @property
    @pulumi.getter(name="provisionedCpus")
    def provisioned_cpus(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "provisioned_cpus")

    @provisioned_cpus.setter
    def provisioned_cpus(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "provisioned_cpus", value)

    @property
    @pulumi.getter(name="reclaimableCpus")
    def reclaimable_cpus(self) -> Optional[pulumi.Input[int]]:
        """
        For Autonomous Databases on Dedicated Exadata Infrastructure:
        * These are the CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.
        * The CPU type (OCPUs or ECPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model.
        """
        return pulumi.get(self, "reclaimable_cpus")

    @reclaimable_cpus.setter
    def reclaimable_cpus(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reclaimable_cpus", value)

    @property
    @pulumi.getter(name="reservedCpus")
    def reserved_cpus(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "reserved_cpus")

    @reserved_cpus.setter
    def reserved_cpus(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "reserved_cpus", value)

    @property
    @pulumi.getter(name="scanListenerPortNonTls")
    def scan_listener_port_non_tls(self) -> Optional[pulumi.Input[int]]:
        """
        The SCAN Listener Non TLS port number. Default value is 1521.
        """
        return pulumi.get(self, "scan_listener_port_non_tls")

    @scan_listener_port_non_tls.setter
    def scan_listener_port_non_tls(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scan_listener_port_non_tls", value)

    @property
    @pulumi.getter(name="scanListenerPortTls")
    def scan_listener_port_tls(self) -> Optional[pulumi.Input[int]]:
        """
        The SCAN Listener TLS port number. Default value is 2484.
        """
        return pulumi.get(self, "scan_listener_port_tls")

    @scan_listener_port_tls.setter
    def scan_listener_port_tls(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scan_listener_port_tls", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Autonomous VM cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time that the Autonomous VM cluster was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeDatabaseSslCertificateExpires")
    def time_database_ssl_certificate_expires(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of Database SSL certificate expiration.
        """
        return pulumi.get(self, "time_database_ssl_certificate_expires")

    @time_database_ssl_certificate_expires.setter
    def time_database_ssl_certificate_expires(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_database_ssl_certificate_expires", value)

    @property
    @pulumi.getter(name="timeOrdsCertificateExpires")
    def time_ords_certificate_expires(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of ORDS certificate expiration.
        """
        return pulumi.get(self, "time_ords_certificate_expires")

    @time_ords_certificate_expires.setter
    def time_ords_certificate_expires(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_ords_certificate_expires", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone to use for the Autonomous VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="totalAutonomousDataStorageInTbs")
    def total_autonomous_data_storage_in_tbs(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "total_autonomous_data_storage_in_tbs")

    @total_autonomous_data_storage_in_tbs.setter
    def total_autonomous_data_storage_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "total_autonomous_data_storage_in_tbs", value)

    @property
    @pulumi.getter(name="totalContainerDatabases")
    def total_container_databases(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of Autonomous Container Databases that can be created.
        """
        return pulumi.get(self, "total_container_databases")

    @total_container_databases.setter
    def total_container_databases(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_container_databases", value)

    @property
    @pulumi.getter(name="vmClusterNetworkId")
    def vm_cluster_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vm_cluster_network_id")

    @vm_cluster_network_id.setter
    def vm_cluster_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_cluster_network_id", value)


class AutonomousVmCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_model: Optional[pulumi.Input[str]] = None,
                 cpu_core_count_per_node: Optional[pulumi.Input[int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 is_mtls_enabled: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 maintenance_window_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AutonomousVmClusterMaintenanceWindowDetailArgs']]]]] = None,
                 memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[int]] = None,
                 scan_listener_port_non_tls: Optional[pulumi.Input[int]] = None,
                 scan_listener_port_tls: Optional[pulumi.Input[int]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 total_container_databases: Optional[pulumi.Input[int]] = None,
                 vm_cluster_network_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Autonomous Vm Cluster resource in Oracle Cloud Infrastructure Database service.

        Creates an Autonomous VM cluster for Exadata Cloud@Customer. To create an Autonomous VM Cluster in the Oracle cloud, see [CreateCloudAutonomousVmCluster](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudAutonomousVmCluster/CreateCloudAutonomousVmCluster).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_vm_cluster = oci.database.AutonomousVmCluster("testAutonomousVmCluster",
            compartment_id=var["compartment_id"],
            display_name=var["autonomous_vm_cluster_display_name"],
            exadata_infrastructure_id=oci_database_exadata_infrastructure["test_exadata_infrastructure"]["id"],
            vm_cluster_network_id=oci_database_vm_cluster_network["test_vm_cluster_network"]["id"],
            autonomous_data_storage_size_in_tbs=var["autonomous_vm_cluster_autonomous_data_storage_size_in_tbs"],
            compute_model=var["autonomous_vm_cluster_compute_model"],
            cpu_core_count_per_node=var["autonomous_vm_cluster_cpu_core_count_per_node"],
            db_servers=var["autonomous_vm_cluster_db_servers"],
            defined_tags=var["autonomous_vm_cluster_defined_tags"],
            freeform_tags={
                "Department": "Finance",
            },
            is_local_backup_enabled=var["autonomous_vm_cluster_is_local_backup_enabled"],
            is_mtls_enabled=var["autonomous_vm_cluster_is_mtls_enabled"],
            license_model=var["autonomous_vm_cluster_license_model"],
            maintenance_window_details=[oci.database.AutonomousVmClusterMaintenanceWindowDetailArgs(
                days_of_weeks=[oci.database.AutonomousVmClusterMaintenanceWindowDetailDaysOfWeekArgs(
                    name=var["autonomous_vm_cluster_maintenance_window_details_days_of_week_name"],
                )],
                hours_of_days=var["autonomous_vm_cluster_maintenance_window_details_hours_of_day"],
                lead_time_in_weeks=var["autonomous_vm_cluster_maintenance_window_details_lead_time_in_weeks"],
                months=[oci.database.AutonomousVmClusterMaintenanceWindowDetailMonthArgs(
                    name=var["autonomous_vm_cluster_maintenance_window_details_months_name"],
                )],
                patching_mode=var["autonomous_vm_cluster_maintenance_window_details_patching_mode"],
                preference=var["autonomous_vm_cluster_maintenance_window_details_preference"],
                weeks_of_months=var["autonomous_vm_cluster_maintenance_window_details_weeks_of_month"],
            )],
            memory_per_oracle_compute_unit_in_gbs=var["autonomous_vm_cluster_memory_per_oracle_compute_unit_in_gbs"],
            scan_listener_port_non_tls=var["autonomous_vm_cluster_scan_listener_port_non_tls"],
            scan_listener_port_tls=var["autonomous_vm_cluster_scan_listener_port_tls"],
            time_zone=var["autonomous_vm_cluster_time_zone"],
            total_container_databases=var["autonomous_vm_cluster_total_container_databases"])
        ```

        ## Import

        AutonomousVmClusters can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Database/autonomousVmCluster:AutonomousVmCluster test_autonomous_vm_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] autonomous_data_storage_size_in_tbs: The data disk group size to be allocated for Autonomous Databases, in TBs.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] compute_model: The compute model of the Autonomous VM Cluster.
        :param pulumi.Input[int] cpu_core_count_per_node: The number of CPU cores to enable per VM cluster node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_servers: The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Db servers.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-friendly name for the Autonomous VM cluster. The name does not need to be unique.
        :param pulumi.Input[str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_local_backup_enabled: If true, database backup on local Exadata storage is configured for the Autonomous VM cluster. If false, database backup on local Exadata storage is not available in the Autonomous VM cluster.
        :param pulumi.Input[bool] is_mtls_enabled: Enable mutual TLS(mTLS) authentication for database while provisioning a VMCluster. Default is TLS.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the Autonomous VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AutonomousVmClusterMaintenanceWindowDetailArgs']]]] maintenance_window_details: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) to be enabled per OCPU or ECPU.
        :param pulumi.Input[int] scan_listener_port_non_tls: The SCAN Listener Non TLS port number. Default value is 1521.
        :param pulumi.Input[int] scan_listener_port_tls: The SCAN Listener TLS port number. Default value is 2484.
        :param pulumi.Input[str] time_zone: The time zone to use for the Autonomous VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[int] total_container_databases: The total number of Autonomous Container Databases that can be created.
        :param pulumi.Input[str] vm_cluster_network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutonomousVmClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Autonomous Vm Cluster resource in Oracle Cloud Infrastructure Database service.

        Creates an Autonomous VM cluster for Exadata Cloud@Customer. To create an Autonomous VM Cluster in the Oracle cloud, see [CreateCloudAutonomousVmCluster](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudAutonomousVmCluster/CreateCloudAutonomousVmCluster).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_vm_cluster = oci.database.AutonomousVmCluster("testAutonomousVmCluster",
            compartment_id=var["compartment_id"],
            display_name=var["autonomous_vm_cluster_display_name"],
            exadata_infrastructure_id=oci_database_exadata_infrastructure["test_exadata_infrastructure"]["id"],
            vm_cluster_network_id=oci_database_vm_cluster_network["test_vm_cluster_network"]["id"],
            autonomous_data_storage_size_in_tbs=var["autonomous_vm_cluster_autonomous_data_storage_size_in_tbs"],
            compute_model=var["autonomous_vm_cluster_compute_model"],
            cpu_core_count_per_node=var["autonomous_vm_cluster_cpu_core_count_per_node"],
            db_servers=var["autonomous_vm_cluster_db_servers"],
            defined_tags=var["autonomous_vm_cluster_defined_tags"],
            freeform_tags={
                "Department": "Finance",
            },
            is_local_backup_enabled=var["autonomous_vm_cluster_is_local_backup_enabled"],
            is_mtls_enabled=var["autonomous_vm_cluster_is_mtls_enabled"],
            license_model=var["autonomous_vm_cluster_license_model"],
            maintenance_window_details=[oci.database.AutonomousVmClusterMaintenanceWindowDetailArgs(
                days_of_weeks=[oci.database.AutonomousVmClusterMaintenanceWindowDetailDaysOfWeekArgs(
                    name=var["autonomous_vm_cluster_maintenance_window_details_days_of_week_name"],
                )],
                hours_of_days=var["autonomous_vm_cluster_maintenance_window_details_hours_of_day"],
                lead_time_in_weeks=var["autonomous_vm_cluster_maintenance_window_details_lead_time_in_weeks"],
                months=[oci.database.AutonomousVmClusterMaintenanceWindowDetailMonthArgs(
                    name=var["autonomous_vm_cluster_maintenance_window_details_months_name"],
                )],
                patching_mode=var["autonomous_vm_cluster_maintenance_window_details_patching_mode"],
                preference=var["autonomous_vm_cluster_maintenance_window_details_preference"],
                weeks_of_months=var["autonomous_vm_cluster_maintenance_window_details_weeks_of_month"],
            )],
            memory_per_oracle_compute_unit_in_gbs=var["autonomous_vm_cluster_memory_per_oracle_compute_unit_in_gbs"],
            scan_listener_port_non_tls=var["autonomous_vm_cluster_scan_listener_port_non_tls"],
            scan_listener_port_tls=var["autonomous_vm_cluster_scan_listener_port_tls"],
            time_zone=var["autonomous_vm_cluster_time_zone"],
            total_container_databases=var["autonomous_vm_cluster_total_container_databases"])
        ```

        ## Import

        AutonomousVmClusters can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Database/autonomousVmCluster:AutonomousVmCluster test_autonomous_vm_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param AutonomousVmClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousVmClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            AutonomousVmClusterArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_model: Optional[pulumi.Input[str]] = None,
                 cpu_core_count_per_node: Optional[pulumi.Input[int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 is_mtls_enabled: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 maintenance_window_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AutonomousVmClusterMaintenanceWindowDetailArgs']]]]] = None,
                 memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[int]] = None,
                 scan_listener_port_non_tls: Optional[pulumi.Input[int]] = None,
                 scan_listener_port_tls: Optional[pulumi.Input[int]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 total_container_databases: Optional[pulumi.Input[int]] = None,
                 vm_cluster_network_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousVmClusterArgs.__new__(AutonomousVmClusterArgs)

            __props__.__dict__["autonomous_data_storage_size_in_tbs"] = autonomous_data_storage_size_in_tbs
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["compute_model"] = compute_model
            __props__.__dict__["cpu_core_count_per_node"] = cpu_core_count_per_node
            __props__.__dict__["db_servers"] = db_servers
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if exadata_infrastructure_id is None and not opts.urn:
                raise TypeError("Missing required property 'exadata_infrastructure_id'")
            __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_local_backup_enabled"] = is_local_backup_enabled
            __props__.__dict__["is_mtls_enabled"] = is_mtls_enabled
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["maintenance_window_details"] = maintenance_window_details
            __props__.__dict__["memory_per_oracle_compute_unit_in_gbs"] = memory_per_oracle_compute_unit_in_gbs
            __props__.__dict__["scan_listener_port_non_tls"] = scan_listener_port_non_tls
            __props__.__dict__["scan_listener_port_tls"] = scan_listener_port_tls
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["total_container_databases"] = total_container_databases
            if vm_cluster_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'vm_cluster_network_id'")
            __props__.__dict__["vm_cluster_network_id"] = vm_cluster_network_id
            __props__.__dict__["autonomous_data_storage_percentage"] = None
            __props__.__dict__["available_autonomous_data_storage_size_in_tbs"] = None
            __props__.__dict__["available_container_databases"] = None
            __props__.__dict__["available_cpus"] = None
            __props__.__dict__["available_data_storage_size_in_tbs"] = None
            __props__.__dict__["cpu_percentage"] = None
            __props__.__dict__["cpus_enabled"] = None
            __props__.__dict__["data_storage_size_in_gb"] = None
            __props__.__dict__["data_storage_size_in_tbs"] = None
            __props__.__dict__["db_node_storage_size_in_gbs"] = None
            __props__.__dict__["last_maintenance_run_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["maintenance_windows"] = None
            __props__.__dict__["memory_size_in_gbs"] = None
            __props__.__dict__["next_maintenance_run_id"] = None
            __props__.__dict__["node_count"] = None
            __props__.__dict__["non_provisionable_autonomous_container_databases"] = None
            __props__.__dict__["ocpus_enabled"] = None
            __props__.__dict__["provisioned_autonomous_container_databases"] = None
            __props__.__dict__["provisioned_cpus"] = None
            __props__.__dict__["reclaimable_cpus"] = None
            __props__.__dict__["reserved_cpus"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_database_ssl_certificate_expires"] = None
            __props__.__dict__["time_ords_certificate_expires"] = None
            __props__.__dict__["total_autonomous_data_storage_in_tbs"] = None
        super(AutonomousVmCluster, __self__).__init__(
            'oci:Database/autonomousVmCluster:AutonomousVmCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autonomous_data_storage_percentage: Optional[pulumi.Input[float]] = None,
            autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            available_autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            available_container_databases: Optional[pulumi.Input[int]] = None,
            available_cpus: Optional[pulumi.Input[int]] = None,
            available_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            compute_model: Optional[pulumi.Input[str]] = None,
            cpu_core_count_per_node: Optional[pulumi.Input[int]] = None,
            cpu_percentage: Optional[pulumi.Input[float]] = None,
            cpus_enabled: Optional[pulumi.Input[int]] = None,
            data_storage_size_in_gb: Optional[pulumi.Input[float]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
            db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_local_backup_enabled: Optional[pulumi.Input[bool]] = None,
            is_mtls_enabled: Optional[pulumi.Input[bool]] = None,
            last_maintenance_run_id: Optional[pulumi.Input[str]] = None,
            license_model: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            maintenance_window_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AutonomousVmClusterMaintenanceWindowDetailArgs']]]]] = None,
            maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AutonomousVmClusterMaintenanceWindowArgs']]]]] = None,
            memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[int]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
            next_maintenance_run_id: Optional[pulumi.Input[str]] = None,
            node_count: Optional[pulumi.Input[int]] = None,
            non_provisionable_autonomous_container_databases: Optional[pulumi.Input[int]] = None,
            ocpus_enabled: Optional[pulumi.Input[float]] = None,
            provisioned_autonomous_container_databases: Optional[pulumi.Input[int]] = None,
            provisioned_cpus: Optional[pulumi.Input[float]] = None,
            reclaimable_cpus: Optional[pulumi.Input[int]] = None,
            reserved_cpus: Optional[pulumi.Input[float]] = None,
            scan_listener_port_non_tls: Optional[pulumi.Input[int]] = None,
            scan_listener_port_tls: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_database_ssl_certificate_expires: Optional[pulumi.Input[str]] = None,
            time_ords_certificate_expires: Optional[pulumi.Input[str]] = None,
            time_zone: Optional[pulumi.Input[str]] = None,
            total_autonomous_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
            total_container_databases: Optional[pulumi.Input[int]] = None,
            vm_cluster_network_id: Optional[pulumi.Input[str]] = None) -> 'AutonomousVmCluster':
        """
        Get an existing AutonomousVmCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] autonomous_data_storage_size_in_tbs: The data disk group size to be allocated for Autonomous Databases, in TBs.
        :param pulumi.Input[float] available_autonomous_data_storage_size_in_tbs: The data disk group size available for Autonomous Databases, in TBs.
        :param pulumi.Input[int] available_container_databases: The number of Autonomous Container Databases that can be created with the currently available local storage.
        :param pulumi.Input[int] available_cpus: The numnber of CPU cores available.
        :param pulumi.Input[float] available_data_storage_size_in_tbs: **Deprecated.** Use `availableAutonomousDataStorageSizeInTBs` for Autonomous Databases' data storage availability in TBs.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] compute_model: The compute model of the Autonomous VM Cluster.
        :param pulumi.Input[int] cpu_core_count_per_node: The number of CPU cores to enable per VM cluster node.
        :param pulumi.Input[int] cpus_enabled: The number of enabled CPU cores.
        :param pulumi.Input[float] data_storage_size_in_tbs: The total data storage allocated in TBs
        :param pulumi.Input[int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_servers: The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Db servers.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-friendly name for the Autonomous VM cluster. The name does not need to be unique.
        :param pulumi.Input[str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_local_backup_enabled: If true, database backup on local Exadata storage is configured for the Autonomous VM cluster. If false, database backup on local Exadata storage is not available in the Autonomous VM cluster.
        :param pulumi.Input[bool] is_mtls_enabled: Enable mutual TLS(mTLS) authentication for database while provisioning a VMCluster. Default is TLS.
        :param pulumi.Input[str] last_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the Autonomous VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AutonomousVmClusterMaintenanceWindowDetailArgs']]]] maintenance_window_details: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AutonomousVmClusterMaintenanceWindowArgs']]]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) to be enabled per OCPU or ECPU.
        :param pulumi.Input[int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[str] next_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        :param pulumi.Input[int] node_count: The number of nodes in the Autonomous VM Cluster.
        :param pulumi.Input[float] ocpus_enabled: The number of enabled OCPU cores.
        :param pulumi.Input[int] reclaimable_cpus: For Autonomous Databases on Dedicated Exadata Infrastructure:
               * These are the CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.
               * The CPU type (OCPUs or ECPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model.
        :param pulumi.Input[int] scan_listener_port_non_tls: The SCAN Listener Non TLS port number. Default value is 1521.
        :param pulumi.Input[int] scan_listener_port_tls: The SCAN Listener TLS port number. Default value is 2484.
        :param pulumi.Input[str] state: The current state of the Autonomous VM cluster.
        :param pulumi.Input[str] time_created: The date and time that the Autonomous VM cluster was created.
        :param pulumi.Input[str] time_database_ssl_certificate_expires: The date and time of Database SSL certificate expiration.
        :param pulumi.Input[str] time_ords_certificate_expires: The date and time of ORDS certificate expiration.
        :param pulumi.Input[str] time_zone: The time zone to use for the Autonomous VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[int] total_container_databases: The total number of Autonomous Container Databases that can be created.
        :param pulumi.Input[str] vm_cluster_network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousVmClusterState.__new__(_AutonomousVmClusterState)

        __props__.__dict__["autonomous_data_storage_percentage"] = autonomous_data_storage_percentage
        __props__.__dict__["autonomous_data_storage_size_in_tbs"] = autonomous_data_storage_size_in_tbs
        __props__.__dict__["available_autonomous_data_storage_size_in_tbs"] = available_autonomous_data_storage_size_in_tbs
        __props__.__dict__["available_container_databases"] = available_container_databases
        __props__.__dict__["available_cpus"] = available_cpus
        __props__.__dict__["available_data_storage_size_in_tbs"] = available_data_storage_size_in_tbs
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_model"] = compute_model
        __props__.__dict__["cpu_core_count_per_node"] = cpu_core_count_per_node
        __props__.__dict__["cpu_percentage"] = cpu_percentage
        __props__.__dict__["cpus_enabled"] = cpus_enabled
        __props__.__dict__["data_storage_size_in_gb"] = data_storage_size_in_gb
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
        __props__.__dict__["db_servers"] = db_servers
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_local_backup_enabled"] = is_local_backup_enabled
        __props__.__dict__["is_mtls_enabled"] = is_mtls_enabled
        __props__.__dict__["last_maintenance_run_id"] = last_maintenance_run_id
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["maintenance_window_details"] = maintenance_window_details
        __props__.__dict__["maintenance_windows"] = maintenance_windows
        __props__.__dict__["memory_per_oracle_compute_unit_in_gbs"] = memory_per_oracle_compute_unit_in_gbs
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["next_maintenance_run_id"] = next_maintenance_run_id
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["non_provisionable_autonomous_container_databases"] = non_provisionable_autonomous_container_databases
        __props__.__dict__["ocpus_enabled"] = ocpus_enabled
        __props__.__dict__["provisioned_autonomous_container_databases"] = provisioned_autonomous_container_databases
        __props__.__dict__["provisioned_cpus"] = provisioned_cpus
        __props__.__dict__["reclaimable_cpus"] = reclaimable_cpus
        __props__.__dict__["reserved_cpus"] = reserved_cpus
        __props__.__dict__["scan_listener_port_non_tls"] = scan_listener_port_non_tls
        __props__.__dict__["scan_listener_port_tls"] = scan_listener_port_tls
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_database_ssl_certificate_expires"] = time_database_ssl_certificate_expires
        __props__.__dict__["time_ords_certificate_expires"] = time_ords_certificate_expires
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["total_autonomous_data_storage_in_tbs"] = total_autonomous_data_storage_in_tbs
        __props__.__dict__["total_container_databases"] = total_container_databases
        __props__.__dict__["vm_cluster_network_id"] = vm_cluster_network_id
        return AutonomousVmCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autonomousDataStoragePercentage")
    def autonomous_data_storage_percentage(self) -> pulumi.Output[float]:
        return pulumi.get(self, "autonomous_data_storage_percentage")

    @property
    @pulumi.getter(name="autonomousDataStorageSizeInTbs")
    def autonomous_data_storage_size_in_tbs(self) -> pulumi.Output[float]:
        """
        The data disk group size to be allocated for Autonomous Databases, in TBs.
        """
        return pulumi.get(self, "autonomous_data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="availableAutonomousDataStorageSizeInTbs")
    def available_autonomous_data_storage_size_in_tbs(self) -> pulumi.Output[float]:
        """
        The data disk group size available for Autonomous Databases, in TBs.
        """
        return pulumi.get(self, "available_autonomous_data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="availableContainerDatabases")
    def available_container_databases(self) -> pulumi.Output[int]:
        """
        The number of Autonomous Container Databases that can be created with the currently available local storage.
        """
        return pulumi.get(self, "available_container_databases")

    @property
    @pulumi.getter(name="availableCpus")
    def available_cpus(self) -> pulumi.Output[int]:
        """
        The numnber of CPU cores available.
        """
        return pulumi.get(self, "available_cpus")

    @property
    @pulumi.getter(name="availableDataStorageSizeInTbs")
    def available_data_storage_size_in_tbs(self) -> pulumi.Output[float]:
        """
        **Deprecated.** Use `availableAutonomousDataStorageSizeInTBs` for Autonomous Databases' data storage availability in TBs.
        """
        return pulumi.get(self, "available_data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> pulumi.Output[str]:
        """
        The compute model of the Autonomous VM Cluster.
        """
        return pulumi.get(self, "compute_model")

    @property
    @pulumi.getter(name="cpuCoreCountPerNode")
    def cpu_core_count_per_node(self) -> pulumi.Output[int]:
        """
        The number of CPU cores to enable per VM cluster node.
        """
        return pulumi.get(self, "cpu_core_count_per_node")

    @property
    @pulumi.getter(name="cpuPercentage")
    def cpu_percentage(self) -> pulumi.Output[float]:
        return pulumi.get(self, "cpu_percentage")

    @property
    @pulumi.getter(name="cpusEnabled")
    def cpus_enabled(self) -> pulumi.Output[int]:
        """
        The number of enabled CPU cores.
        """
        return pulumi.get(self, "cpus_enabled")

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> pulumi.Output[float]:
        return pulumi.get(self, "data_storage_size_in_gb")

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[float]:
        """
        The total data storage allocated in TBs
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Db servers.
        """
        return pulumi.get(self, "db_servers")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The user-friendly name for the Autonomous VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> pulumi.Output[bool]:
        """
        If true, database backup on local Exadata storage is configured for the Autonomous VM cluster. If false, database backup on local Exadata storage is not available in the Autonomous VM cluster.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @property
    @pulumi.getter(name="isMtlsEnabled")
    def is_mtls_enabled(self) -> pulumi.Output[bool]:
        """
        Enable mutual TLS(mTLS) authentication for database while provisioning a VMCluster. Default is TLS.
        """
        return pulumi.get(self, "is_mtls_enabled")

    @property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[str]:
        """
        (Updatable) The Oracle license model that applies to the Autonomous VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceWindowDetails")
    def maintenance_window_details(self) -> pulumi.Output[Sequence['outputs.AutonomousVmClusterMaintenanceWindowDetail']]:
        """
        (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_window_details")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> pulumi.Output[Sequence['outputs.AutonomousVmClusterMaintenanceWindow']]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="memoryPerOracleComputeUnitInGbs")
    def memory_per_oracle_compute_unit_in_gbs(self) -> pulumi.Output[int]:
        """
        The amount of memory (in GBs) to be enabled per OCPU or ECPU.
        """
        return pulumi.get(self, "memory_per_oracle_compute_unit_in_gbs")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[int]:
        """
        The number of nodes in the Autonomous VM Cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nonProvisionableAutonomousContainerDatabases")
    def non_provisionable_autonomous_container_databases(self) -> pulumi.Output[int]:
        return pulumi.get(self, "non_provisionable_autonomous_container_databases")

    @property
    @pulumi.getter(name="ocpusEnabled")
    def ocpus_enabled(self) -> pulumi.Output[float]:
        """
        The number of enabled OCPU cores.
        """
        return pulumi.get(self, "ocpus_enabled")

    @property
    @pulumi.getter(name="provisionedAutonomousContainerDatabases")
    def provisioned_autonomous_container_databases(self) -> pulumi.Output[int]:
        return pulumi.get(self, "provisioned_autonomous_container_databases")

    @property
    @pulumi.getter(name="provisionedCpus")
    def provisioned_cpus(self) -> pulumi.Output[float]:
        return pulumi.get(self, "provisioned_cpus")

    @property
    @pulumi.getter(name="reclaimableCpus")
    def reclaimable_cpus(self) -> pulumi.Output[int]:
        """
        For Autonomous Databases on Dedicated Exadata Infrastructure:
        * These are the CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.
        * The CPU type (OCPUs or ECPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model.
        """
        return pulumi.get(self, "reclaimable_cpus")

    @property
    @pulumi.getter(name="reservedCpus")
    def reserved_cpus(self) -> pulumi.Output[float]:
        return pulumi.get(self, "reserved_cpus")

    @property
    @pulumi.getter(name="scanListenerPortNonTls")
    def scan_listener_port_non_tls(self) -> pulumi.Output[int]:
        """
        The SCAN Listener Non TLS port number. Default value is 1521.
        """
        return pulumi.get(self, "scan_listener_port_non_tls")

    @property
    @pulumi.getter(name="scanListenerPortTls")
    def scan_listener_port_tls(self) -> pulumi.Output[int]:
        """
        The SCAN Listener TLS port number. Default value is 2484.
        """
        return pulumi.get(self, "scan_listener_port_tls")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Autonomous VM cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time that the Autonomous VM cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeDatabaseSslCertificateExpires")
    def time_database_ssl_certificate_expires(self) -> pulumi.Output[str]:
        """
        The date and time of Database SSL certificate expiration.
        """
        return pulumi.get(self, "time_database_ssl_certificate_expires")

    @property
    @pulumi.getter(name="timeOrdsCertificateExpires")
    def time_ords_certificate_expires(self) -> pulumi.Output[str]:
        """
        The date and time of ORDS certificate expiration.
        """
        return pulumi.get(self, "time_ords_certificate_expires")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        The time zone to use for the Autonomous VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="totalAutonomousDataStorageInTbs")
    def total_autonomous_data_storage_in_tbs(self) -> pulumi.Output[float]:
        return pulumi.get(self, "total_autonomous_data_storage_in_tbs")

    @property
    @pulumi.getter(name="totalContainerDatabases")
    def total_container_databases(self) -> pulumi.Output[int]:
        """
        The total number of Autonomous Container Databases that can be created.
        """
        return pulumi.get(self, "total_container_databases")

    @property
    @pulumi.getter(name="vmClusterNetworkId")
    def vm_cluster_network_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vm_cluster_network_id")

