# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExadataInfrastructureArgs', 'ExadataInfrastructure']

@pulumi.input_type
class ExadataInfrastructureArgs:
    def __init__(__self__, *,
                 admin_network_cidr: pulumi.Input[str],
                 cloud_control_plane_server1: pulumi.Input[str],
                 cloud_control_plane_server2: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 dns_servers: pulumi.Input[Sequence[pulumi.Input[str]]],
                 gateway: pulumi.Input[str],
                 infini_band_network_cidr: pulumi.Input[str],
                 netmask: pulumi.Input[str],
                 ntp_servers: pulumi.Input[Sequence[pulumi.Input[str]]],
                 shape: pulumi.Input[str],
                 time_zone: pulumi.Input[str],
                 activation_file: Optional[pulumi.Input[str]] = None,
                 additional_storage_count: Optional[pulumi.Input[int]] = None,
                 compute_count: Optional[pulumi.Input[int]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureContactArgs']]]] = None,
                 corporate_proxy: Optional[pulumi.Input[str]] = None,
                 create_async: Optional[pulumi.Input[bool]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_cps_offline_report_enabled: Optional[pulumi.Input[bool]] = None,
                 is_multi_rack_deployment: Optional[pulumi.Input[bool]] = None,
                 maintenance_window: Optional[pulumi.Input['ExadataInfrastructureMaintenanceWindowArgs']] = None,
                 multi_rack_configuration_file: Optional[pulumi.Input[str]] = None,
                 network_bonding_mode_details: Optional[pulumi.Input['ExadataInfrastructureNetworkBondingModeDetailsArgs']] = None,
                 storage_count: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a ExadataInfrastructure resource.
        :param pulumi.Input[str] admin_network_cidr: (Updatable) The CIDR block for the Exadata administration network.
        :param pulumi.Input[str] cloud_control_plane_server1: (Updatable) The IP address for the first control plane server.
        :param pulumi.Input[str] cloud_control_plane_server2: (Updatable) The IP address for the second control plane server.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] display_name: The user-friendly name for the Exadata infrastructure. The name does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: (Updatable) The list of DNS server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[str] gateway: (Updatable) The gateway for the control plane network.
        :param pulumi.Input[str] infini_band_network_cidr: (Updatable) The CIDR block for the Exadata InfiniBand interconnect.
        :param pulumi.Input[str] netmask: (Updatable) The netmask for the control plane network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ntp_servers: (Updatable) The list of NTP server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[str] shape: The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        :param pulumi.Input[str] time_zone: (Updatable) The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[str] activation_file: (Updatable) The activation zip file. If provided in config, exadata infrastructure will be activated after creation. Updates are not allowed on activated exadata infrastructure.
        :param pulumi.Input[int] additional_storage_count: The requested number of additional storage servers for the Exadata infrastructure.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[int] compute_count: The number of compute servers for the Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureContactArgs']]] contacts: (Updatable) The list of contacts for the Exadata infrastructure.
        :param pulumi.Input[str] corporate_proxy: (Updatable) The corporate network proxy for access to the control plane network. Oracle recommends using an HTTPS proxy when possible for enhanced security.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_cps_offline_report_enabled: (Updatable) Indicates whether cps offline diagnostic report is enabled for this Exadata infrastructure. This will allow a customer to quickly check status themselves and fix problems on their end, saving time and frustration for both Oracle and the customer when they find the CPS in a disconnected state.You can enable offline diagnostic report during Exadata infrastructure provisioning. You can also disable or enable it at any time using the UpdateExadatainfrastructure API.
        :param pulumi.Input[bool] is_multi_rack_deployment: (Updatable) Indicates if deployment is Multi-Rack or not.
        :param pulumi.Input['ExadataInfrastructureMaintenanceWindowArgs'] maintenance_window: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[str] multi_rack_configuration_file: (Updatable) The base64 encoded Multi-Rack configuration json file.
        :param pulumi.Input['ExadataInfrastructureNetworkBondingModeDetailsArgs'] network_bonding_mode_details: (Updatable) Details of bonding mode for Client and Backup and DR networks of an Exadata infrastructure.
        :param pulumi.Input[int] storage_count: The number of storage servers for the Exadata infrastructure.
        """
        ExadataInfrastructureArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            admin_network_cidr=admin_network_cidr,
            cloud_control_plane_server1=cloud_control_plane_server1,
            cloud_control_plane_server2=cloud_control_plane_server2,
            compartment_id=compartment_id,
            display_name=display_name,
            dns_servers=dns_servers,
            gateway=gateway,
            infini_band_network_cidr=infini_band_network_cidr,
            netmask=netmask,
            ntp_servers=ntp_servers,
            shape=shape,
            time_zone=time_zone,
            activation_file=activation_file,
            additional_storage_count=additional_storage_count,
            compute_count=compute_count,
            contacts=contacts,
            corporate_proxy=corporate_proxy,
            create_async=create_async,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            is_cps_offline_report_enabled=is_cps_offline_report_enabled,
            is_multi_rack_deployment=is_multi_rack_deployment,
            maintenance_window=maintenance_window,
            multi_rack_configuration_file=multi_rack_configuration_file,
            network_bonding_mode_details=network_bonding_mode_details,
            storage_count=storage_count,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             admin_network_cidr: pulumi.Input[str],
             cloud_control_plane_server1: pulumi.Input[str],
             cloud_control_plane_server2: pulumi.Input[str],
             compartment_id: pulumi.Input[str],
             display_name: pulumi.Input[str],
             dns_servers: pulumi.Input[Sequence[pulumi.Input[str]]],
             gateway: pulumi.Input[str],
             infini_band_network_cidr: pulumi.Input[str],
             netmask: pulumi.Input[str],
             ntp_servers: pulumi.Input[Sequence[pulumi.Input[str]]],
             shape: pulumi.Input[str],
             time_zone: pulumi.Input[str],
             activation_file: Optional[pulumi.Input[str]] = None,
             additional_storage_count: Optional[pulumi.Input[int]] = None,
             compute_count: Optional[pulumi.Input[int]] = None,
             contacts: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureContactArgs']]]] = None,
             corporate_proxy: Optional[pulumi.Input[str]] = None,
             create_async: Optional[pulumi.Input[bool]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             is_cps_offline_report_enabled: Optional[pulumi.Input[bool]] = None,
             is_multi_rack_deployment: Optional[pulumi.Input[bool]] = None,
             maintenance_window: Optional[pulumi.Input['ExadataInfrastructureMaintenanceWindowArgs']] = None,
             multi_rack_configuration_file: Optional[pulumi.Input[str]] = None,
             network_bonding_mode_details: Optional[pulumi.Input['ExadataInfrastructureNetworkBondingModeDetailsArgs']] = None,
             storage_count: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'adminNetworkCidr' in kwargs:
            admin_network_cidr = kwargs['adminNetworkCidr']
        if 'cloudControlPlaneServer1' in kwargs:
            cloud_control_plane_server1 = kwargs['cloudControlPlaneServer1']
        if 'cloudControlPlaneServer2' in kwargs:
            cloud_control_plane_server2 = kwargs['cloudControlPlaneServer2']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'dnsServers' in kwargs:
            dns_servers = kwargs['dnsServers']
        if 'infiniBandNetworkCidr' in kwargs:
            infini_band_network_cidr = kwargs['infiniBandNetworkCidr']
        if 'ntpServers' in kwargs:
            ntp_servers = kwargs['ntpServers']
        if 'timeZone' in kwargs:
            time_zone = kwargs['timeZone']
        if 'activationFile' in kwargs:
            activation_file = kwargs['activationFile']
        if 'additionalStorageCount' in kwargs:
            additional_storage_count = kwargs['additionalStorageCount']
        if 'computeCount' in kwargs:
            compute_count = kwargs['computeCount']
        if 'corporateProxy' in kwargs:
            corporate_proxy = kwargs['corporateProxy']
        if 'createAsync' in kwargs:
            create_async = kwargs['createAsync']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isCpsOfflineReportEnabled' in kwargs:
            is_cps_offline_report_enabled = kwargs['isCpsOfflineReportEnabled']
        if 'isMultiRackDeployment' in kwargs:
            is_multi_rack_deployment = kwargs['isMultiRackDeployment']
        if 'maintenanceWindow' in kwargs:
            maintenance_window = kwargs['maintenanceWindow']
        if 'multiRackConfigurationFile' in kwargs:
            multi_rack_configuration_file = kwargs['multiRackConfigurationFile']
        if 'networkBondingModeDetails' in kwargs:
            network_bonding_mode_details = kwargs['networkBondingModeDetails']
        if 'storageCount' in kwargs:
            storage_count = kwargs['storageCount']

        _setter("admin_network_cidr", admin_network_cidr)
        _setter("cloud_control_plane_server1", cloud_control_plane_server1)
        _setter("cloud_control_plane_server2", cloud_control_plane_server2)
        _setter("compartment_id", compartment_id)
        _setter("display_name", display_name)
        _setter("dns_servers", dns_servers)
        _setter("gateway", gateway)
        _setter("infini_band_network_cidr", infini_band_network_cidr)
        _setter("netmask", netmask)
        _setter("ntp_servers", ntp_servers)
        _setter("shape", shape)
        _setter("time_zone", time_zone)
        if activation_file is not None:
            _setter("activation_file", activation_file)
        if additional_storage_count is not None:
            _setter("additional_storage_count", additional_storage_count)
        if compute_count is not None:
            _setter("compute_count", compute_count)
        if contacts is not None:
            _setter("contacts", contacts)
        if corporate_proxy is not None:
            _setter("corporate_proxy", corporate_proxy)
        if create_async is not None:
            _setter("create_async", create_async)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if is_cps_offline_report_enabled is not None:
            _setter("is_cps_offline_report_enabled", is_cps_offline_report_enabled)
        if is_multi_rack_deployment is not None:
            _setter("is_multi_rack_deployment", is_multi_rack_deployment)
        if maintenance_window is not None:
            _setter("maintenance_window", maintenance_window)
        if multi_rack_configuration_file is not None:
            _setter("multi_rack_configuration_file", multi_rack_configuration_file)
        if network_bonding_mode_details is not None:
            _setter("network_bonding_mode_details", network_bonding_mode_details)
        if storage_count is not None:
            _setter("storage_count", storage_count)

    @property
    @pulumi.getter(name="adminNetworkCidr")
    def admin_network_cidr(self) -> pulumi.Input[str]:
        """
        (Updatable) The CIDR block for the Exadata administration network.
        """
        return pulumi.get(self, "admin_network_cidr")

    @admin_network_cidr.setter
    def admin_network_cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_network_cidr", value)

    @property
    @pulumi.getter(name="cloudControlPlaneServer1")
    def cloud_control_plane_server1(self) -> pulumi.Input[str]:
        """
        (Updatable) The IP address for the first control plane server.
        """
        return pulumi.get(self, "cloud_control_plane_server1")

    @cloud_control_plane_server1.setter
    def cloud_control_plane_server1(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloud_control_plane_server1", value)

    @property
    @pulumi.getter(name="cloudControlPlaneServer2")
    def cloud_control_plane_server2(self) -> pulumi.Input[str]:
        """
        (Updatable) The IP address for the second control plane server.
        """
        return pulumi.get(self, "cloud_control_plane_server2")

    @cloud_control_plane_server2.setter
    def cloud_control_plane_server2(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloud_control_plane_server2", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The user-friendly name for the Exadata infrastructure. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) The list of DNS server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Input[str]:
        """
        (Updatable) The gateway for the control plane network.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="infiniBandNetworkCidr")
    def infini_band_network_cidr(self) -> pulumi.Input[str]:
        """
        (Updatable) The CIDR block for the Exadata InfiniBand interconnect.
        """
        return pulumi.get(self, "infini_band_network_cidr")

    @infini_band_network_cidr.setter
    def infini_band_network_cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "infini_band_network_cidr", value)

    @property
    @pulumi.getter
    def netmask(self) -> pulumi.Input[str]:
        """
        (Updatable) The netmask for the control plane network.
        """
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: pulumi.Input[str]):
        pulumi.set(self, "netmask", value)

    @property
    @pulumi.getter(name="ntpServers")
    def ntp_servers(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) The list of NTP server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "ntp_servers")

    @ntp_servers.setter
    def ntp_servers(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "ntp_servers", value)

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Input[str]:
        """
        The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: pulumi.Input[str]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Input[str]:
        """
        (Updatable) The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="activationFile")
    def activation_file(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The activation zip file. If provided in config, exadata infrastructure will be activated after creation. Updates are not allowed on activated exadata infrastructure.
        """
        return pulumi.get(self, "activation_file")

    @activation_file.setter
    def activation_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_file", value)

    @property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> Optional[pulumi.Input[int]]:
        """
        The requested number of additional storage servers for the Exadata infrastructure.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "additional_storage_count")

    @additional_storage_count.setter
    def additional_storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_storage_count", value)

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of compute servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compute_count", value)

    @property
    @pulumi.getter
    def contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureContactArgs']]]]:
        """
        (Updatable) The list of contacts for the Exadata infrastructure.
        """
        return pulumi.get(self, "contacts")

    @contacts.setter
    def contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureContactArgs']]]]):
        pulumi.set(self, "contacts", value)

    @property
    @pulumi.getter(name="corporateProxy")
    def corporate_proxy(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The corporate network proxy for access to the control plane network. Oracle recommends using an HTTPS proxy when possible for enhanced security.
        """
        return pulumi.get(self, "corporate_proxy")

    @corporate_proxy.setter
    def corporate_proxy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "corporate_proxy", value)

    @property
    @pulumi.getter(name="createAsync")
    def create_async(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "create_async")

    @create_async.setter
    def create_async(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_async", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isCpsOfflineReportEnabled")
    def is_cps_offline_report_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether cps offline diagnostic report is enabled for this Exadata infrastructure. This will allow a customer to quickly check status themselves and fix problems on their end, saving time and frustration for both Oracle and the customer when they find the CPS in a disconnected state.You can enable offline diagnostic report during Exadata infrastructure provisioning. You can also disable or enable it at any time using the UpdateExadatainfrastructure API.
        """
        return pulumi.get(self, "is_cps_offline_report_enabled")

    @is_cps_offline_report_enabled.setter
    def is_cps_offline_report_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cps_offline_report_enabled", value)

    @property
    @pulumi.getter(name="isMultiRackDeployment")
    def is_multi_rack_deployment(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if deployment is Multi-Rack or not.
        """
        return pulumi.get(self, "is_multi_rack_deployment")

    @is_multi_rack_deployment.setter
    def is_multi_rack_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_multi_rack_deployment", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['ExadataInfrastructureMaintenanceWindowArgs']]:
        """
        (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['ExadataInfrastructureMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="multiRackConfigurationFile")
    def multi_rack_configuration_file(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded Multi-Rack configuration json file.
        """
        return pulumi.get(self, "multi_rack_configuration_file")

    @multi_rack_configuration_file.setter
    def multi_rack_configuration_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_rack_configuration_file", value)

    @property
    @pulumi.getter(name="networkBondingModeDetails")
    def network_bonding_mode_details(self) -> Optional[pulumi.Input['ExadataInfrastructureNetworkBondingModeDetailsArgs']]:
        """
        (Updatable) Details of bonding mode for Client and Backup and DR networks of an Exadata infrastructure.
        """
        return pulumi.get(self, "network_bonding_mode_details")

    @network_bonding_mode_details.setter
    def network_bonding_mode_details(self, value: Optional[pulumi.Input['ExadataInfrastructureNetworkBondingModeDetailsArgs']]):
        pulumi.set(self, "network_bonding_mode_details", value)

    @property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_count")

    @storage_count.setter
    def storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_count", value)


@pulumi.input_type
class _ExadataInfrastructureState:
    def __init__(__self__, *,
                 activated_storage_count: Optional[pulumi.Input[int]] = None,
                 activation_file: Optional[pulumi.Input[str]] = None,
                 additional_compute_count: Optional[pulumi.Input[int]] = None,
                 additional_compute_system_model: Optional[pulumi.Input[str]] = None,
                 additional_storage_count: Optional[pulumi.Input[int]] = None,
                 admin_network_cidr: Optional[pulumi.Input[str]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server1: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server2: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[int]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureContactArgs']]]] = None,
                 corporate_proxy: Optional[pulumi.Input[str]] = None,
                 cpus_enabled: Optional[pulumi.Input[int]] = None,
                 create_async: Optional[pulumi.Input[bool]] = None,
                 csi_number: Optional[pulumi.Input[str]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 db_server_version: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 gateway: Optional[pulumi.Input[str]] = None,
                 infini_band_network_cidr: Optional[pulumi.Input[str]] = None,
                 is_cps_offline_report_enabled: Optional[pulumi.Input[bool]] = None,
                 is_multi_rack_deployment: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 maintenance_slo_status: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input['ExadataInfrastructureMaintenanceWindowArgs']] = None,
                 max_cpu_count: Optional[pulumi.Input[int]] = None,
                 max_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
                 max_db_node_storage_in_gbs: Optional[pulumi.Input[int]] = None,
                 max_memory_in_gbs: Optional[pulumi.Input[int]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 monthly_db_server_version: Optional[pulumi.Input[str]] = None,
                 multi_rack_configuration_file: Optional[pulumi.Input[str]] = None,
                 netmask: Optional[pulumi.Input[str]] = None,
                 network_bonding_mode_details: Optional[pulumi.Input['ExadataInfrastructureNetworkBondingModeDetailsArgs']] = None,
                 ntp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rack_serial_number: Optional[pulumi.Input[str]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage_count: Optional[pulumi.Input[int]] = None,
                 storage_server_version: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExadataInfrastructure resources.
        :param pulumi.Input[int] activated_storage_count: The requested number of additional storage servers activated for the Exadata infrastructure.
        :param pulumi.Input[str] activation_file: (Updatable) The activation zip file. If provided in config, exadata infrastructure will be activated after creation. Updates are not allowed on activated exadata infrastructure.
        :param pulumi.Input[int] additional_compute_count: The requested number of additional compute servers for the Exadata infrastructure.
        :param pulumi.Input[str] additional_compute_system_model: Oracle Exadata System Model specification. The system model determines the amount of compute or storage server resources available for use. For more information, please see [System and Shape Configuration Options] (https://docs.oracle.com/en/engineered-systems/exadata-cloud-at-customer/ecccm/ecc-system-config-options.html#GUID-9E090174-5C57-4EB1-9243-B470F9F10D6B)
        :param pulumi.Input[int] additional_storage_count: The requested number of additional storage servers for the Exadata infrastructure.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] admin_network_cidr: (Updatable) The CIDR block for the Exadata administration network.
        :param pulumi.Input[str] availability_domain: The name of the availability domain that the Exadata infrastructure is located in.
        :param pulumi.Input[str] cloud_control_plane_server1: (Updatable) The IP address for the first control plane server.
        :param pulumi.Input[str] cloud_control_plane_server2: (Updatable) The IP address for the second control plane server.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] compute_count: The number of compute servers for the Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureContactArgs']]] contacts: (Updatable) The list of contacts for the Exadata infrastructure.
        :param pulumi.Input[str] corporate_proxy: (Updatable) The corporate network proxy for access to the control plane network. Oracle recommends using an HTTPS proxy when possible for enhanced security.
        :param pulumi.Input[int] cpus_enabled: The number of enabled CPU cores.
        :param pulumi.Input[str] csi_number: The CSI Number of the Exadata infrastructure.
        :param pulumi.Input[float] data_storage_size_in_tbs: Size, in terabytes, of the DATA disk group.
        :param pulumi.Input[int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[str] db_server_version: The software version of the database servers (dom0) in the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-friendly name for the Exadata infrastructure. The name does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: (Updatable) The list of DNS server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gateway: (Updatable) The gateway for the control plane network.
        :param pulumi.Input[str] infini_band_network_cidr: (Updatable) The CIDR block for the Exadata InfiniBand interconnect.
        :param pulumi.Input[bool] is_cps_offline_report_enabled: (Updatable) Indicates whether cps offline diagnostic report is enabled for this Exadata infrastructure. This will allow a customer to quickly check status themselves and fix problems on their end, saving time and frustration for both Oracle and the customer when they find the CPS in a disconnected state.You can enable offline diagnostic report during Exadata infrastructure provisioning. You can also disable or enable it at any time using the UpdateExadatainfrastructure API.
        :param pulumi.Input[bool] is_multi_rack_deployment: (Updatable) Indicates if deployment is Multi-Rack or not.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] maintenance_slo_status: A field to capture ‘Maintenance SLO Status’ for the Exadata infrastructure with values ‘OK’, ‘DEGRADED’. Default is ‘OK’ when the infrastructure is provisioned.
        :param pulumi.Input['ExadataInfrastructureMaintenanceWindowArgs'] maintenance_window: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] max_cpu_count: The total number of CPU cores available.
        :param pulumi.Input[float] max_data_storage_in_tbs: The total available DATA disk group size.
        :param pulumi.Input[int] max_db_node_storage_in_gbs: The total local node storage available in GBs.
        :param pulumi.Input[int] max_memory_in_gbs: The total memory available in GBs.
        :param pulumi.Input[int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[str] monthly_db_server_version: The monthly software version of the database servers (dom0) in the Exadata infrastructure.
        :param pulumi.Input[str] multi_rack_configuration_file: (Updatable) The base64 encoded Multi-Rack configuration json file.
        :param pulumi.Input[str] netmask: (Updatable) The netmask for the control plane network.
        :param pulumi.Input['ExadataInfrastructureNetworkBondingModeDetailsArgs'] network_bonding_mode_details: (Updatable) Details of bonding mode for Client and Backup and DR networks of an Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ntp_servers: (Updatable) The list of NTP server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[str] rack_serial_number: The serial number for the Exadata infrastructure.
        :param pulumi.Input[str] shape: The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        :param pulumi.Input[str] state: The current lifecycle state of the Exadata infrastructure.
        :param pulumi.Input[int] storage_count: The number of storage servers for the Exadata infrastructure.
        :param pulumi.Input[str] storage_server_version: The software version of the storage servers (cells) in the Exadata infrastructure.
        :param pulumi.Input[str] time_created: The date and time the Exadata infrastructure was created.
        :param pulumi.Input[str] time_zone: (Updatable) The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        _ExadataInfrastructureState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            activated_storage_count=activated_storage_count,
            activation_file=activation_file,
            additional_compute_count=additional_compute_count,
            additional_compute_system_model=additional_compute_system_model,
            additional_storage_count=additional_storage_count,
            admin_network_cidr=admin_network_cidr,
            availability_domain=availability_domain,
            cloud_control_plane_server1=cloud_control_plane_server1,
            cloud_control_plane_server2=cloud_control_plane_server2,
            compartment_id=compartment_id,
            compute_count=compute_count,
            contacts=contacts,
            corporate_proxy=corporate_proxy,
            cpus_enabled=cpus_enabled,
            create_async=create_async,
            csi_number=csi_number,
            data_storage_size_in_tbs=data_storage_size_in_tbs,
            db_node_storage_size_in_gbs=db_node_storage_size_in_gbs,
            db_server_version=db_server_version,
            defined_tags=defined_tags,
            display_name=display_name,
            dns_servers=dns_servers,
            freeform_tags=freeform_tags,
            gateway=gateway,
            infini_band_network_cidr=infini_band_network_cidr,
            is_cps_offline_report_enabled=is_cps_offline_report_enabled,
            is_multi_rack_deployment=is_multi_rack_deployment,
            lifecycle_details=lifecycle_details,
            maintenance_slo_status=maintenance_slo_status,
            maintenance_window=maintenance_window,
            max_cpu_count=max_cpu_count,
            max_data_storage_in_tbs=max_data_storage_in_tbs,
            max_db_node_storage_in_gbs=max_db_node_storage_in_gbs,
            max_memory_in_gbs=max_memory_in_gbs,
            memory_size_in_gbs=memory_size_in_gbs,
            monthly_db_server_version=monthly_db_server_version,
            multi_rack_configuration_file=multi_rack_configuration_file,
            netmask=netmask,
            network_bonding_mode_details=network_bonding_mode_details,
            ntp_servers=ntp_servers,
            rack_serial_number=rack_serial_number,
            shape=shape,
            state=state,
            storage_count=storage_count,
            storage_server_version=storage_server_version,
            time_created=time_created,
            time_zone=time_zone,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             activated_storage_count: Optional[pulumi.Input[int]] = None,
             activation_file: Optional[pulumi.Input[str]] = None,
             additional_compute_count: Optional[pulumi.Input[int]] = None,
             additional_compute_system_model: Optional[pulumi.Input[str]] = None,
             additional_storage_count: Optional[pulumi.Input[int]] = None,
             admin_network_cidr: Optional[pulumi.Input[str]] = None,
             availability_domain: Optional[pulumi.Input[str]] = None,
             cloud_control_plane_server1: Optional[pulumi.Input[str]] = None,
             cloud_control_plane_server2: Optional[pulumi.Input[str]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             compute_count: Optional[pulumi.Input[int]] = None,
             contacts: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureContactArgs']]]] = None,
             corporate_proxy: Optional[pulumi.Input[str]] = None,
             cpus_enabled: Optional[pulumi.Input[int]] = None,
             create_async: Optional[pulumi.Input[bool]] = None,
             csi_number: Optional[pulumi.Input[str]] = None,
             data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
             db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
             db_server_version: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             gateway: Optional[pulumi.Input[str]] = None,
             infini_band_network_cidr: Optional[pulumi.Input[str]] = None,
             is_cps_offline_report_enabled: Optional[pulumi.Input[bool]] = None,
             is_multi_rack_deployment: Optional[pulumi.Input[bool]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             maintenance_slo_status: Optional[pulumi.Input[str]] = None,
             maintenance_window: Optional[pulumi.Input['ExadataInfrastructureMaintenanceWindowArgs']] = None,
             max_cpu_count: Optional[pulumi.Input[int]] = None,
             max_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
             max_db_node_storage_in_gbs: Optional[pulumi.Input[int]] = None,
             max_memory_in_gbs: Optional[pulumi.Input[int]] = None,
             memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
             monthly_db_server_version: Optional[pulumi.Input[str]] = None,
             multi_rack_configuration_file: Optional[pulumi.Input[str]] = None,
             netmask: Optional[pulumi.Input[str]] = None,
             network_bonding_mode_details: Optional[pulumi.Input['ExadataInfrastructureNetworkBondingModeDetailsArgs']] = None,
             ntp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             rack_serial_number: Optional[pulumi.Input[str]] = None,
             shape: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             storage_count: Optional[pulumi.Input[int]] = None,
             storage_server_version: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_zone: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'activatedStorageCount' in kwargs:
            activated_storage_count = kwargs['activatedStorageCount']
        if 'activationFile' in kwargs:
            activation_file = kwargs['activationFile']
        if 'additionalComputeCount' in kwargs:
            additional_compute_count = kwargs['additionalComputeCount']
        if 'additionalComputeSystemModel' in kwargs:
            additional_compute_system_model = kwargs['additionalComputeSystemModel']
        if 'additionalStorageCount' in kwargs:
            additional_storage_count = kwargs['additionalStorageCount']
        if 'adminNetworkCidr' in kwargs:
            admin_network_cidr = kwargs['adminNetworkCidr']
        if 'availabilityDomain' in kwargs:
            availability_domain = kwargs['availabilityDomain']
        if 'cloudControlPlaneServer1' in kwargs:
            cloud_control_plane_server1 = kwargs['cloudControlPlaneServer1']
        if 'cloudControlPlaneServer2' in kwargs:
            cloud_control_plane_server2 = kwargs['cloudControlPlaneServer2']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'computeCount' in kwargs:
            compute_count = kwargs['computeCount']
        if 'corporateProxy' in kwargs:
            corporate_proxy = kwargs['corporateProxy']
        if 'cpusEnabled' in kwargs:
            cpus_enabled = kwargs['cpusEnabled']
        if 'createAsync' in kwargs:
            create_async = kwargs['createAsync']
        if 'csiNumber' in kwargs:
            csi_number = kwargs['csiNumber']
        if 'dataStorageSizeInTbs' in kwargs:
            data_storage_size_in_tbs = kwargs['dataStorageSizeInTbs']
        if 'dbNodeStorageSizeInGbs' in kwargs:
            db_node_storage_size_in_gbs = kwargs['dbNodeStorageSizeInGbs']
        if 'dbServerVersion' in kwargs:
            db_server_version = kwargs['dbServerVersion']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'dnsServers' in kwargs:
            dns_servers = kwargs['dnsServers']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'infiniBandNetworkCidr' in kwargs:
            infini_band_network_cidr = kwargs['infiniBandNetworkCidr']
        if 'isCpsOfflineReportEnabled' in kwargs:
            is_cps_offline_report_enabled = kwargs['isCpsOfflineReportEnabled']
        if 'isMultiRackDeployment' in kwargs:
            is_multi_rack_deployment = kwargs['isMultiRackDeployment']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'maintenanceSloStatus' in kwargs:
            maintenance_slo_status = kwargs['maintenanceSloStatus']
        if 'maintenanceWindow' in kwargs:
            maintenance_window = kwargs['maintenanceWindow']
        if 'maxCpuCount' in kwargs:
            max_cpu_count = kwargs['maxCpuCount']
        if 'maxDataStorageInTbs' in kwargs:
            max_data_storage_in_tbs = kwargs['maxDataStorageInTbs']
        if 'maxDbNodeStorageInGbs' in kwargs:
            max_db_node_storage_in_gbs = kwargs['maxDbNodeStorageInGbs']
        if 'maxMemoryInGbs' in kwargs:
            max_memory_in_gbs = kwargs['maxMemoryInGbs']
        if 'memorySizeInGbs' in kwargs:
            memory_size_in_gbs = kwargs['memorySizeInGbs']
        if 'monthlyDbServerVersion' in kwargs:
            monthly_db_server_version = kwargs['monthlyDbServerVersion']
        if 'multiRackConfigurationFile' in kwargs:
            multi_rack_configuration_file = kwargs['multiRackConfigurationFile']
        if 'networkBondingModeDetails' in kwargs:
            network_bonding_mode_details = kwargs['networkBondingModeDetails']
        if 'ntpServers' in kwargs:
            ntp_servers = kwargs['ntpServers']
        if 'rackSerialNumber' in kwargs:
            rack_serial_number = kwargs['rackSerialNumber']
        if 'storageCount' in kwargs:
            storage_count = kwargs['storageCount']
        if 'storageServerVersion' in kwargs:
            storage_server_version = kwargs['storageServerVersion']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeZone' in kwargs:
            time_zone = kwargs['timeZone']

        if activated_storage_count is not None:
            _setter("activated_storage_count", activated_storage_count)
        if activation_file is not None:
            _setter("activation_file", activation_file)
        if additional_compute_count is not None:
            _setter("additional_compute_count", additional_compute_count)
        if additional_compute_system_model is not None:
            _setter("additional_compute_system_model", additional_compute_system_model)
        if additional_storage_count is not None:
            _setter("additional_storage_count", additional_storage_count)
        if admin_network_cidr is not None:
            _setter("admin_network_cidr", admin_network_cidr)
        if availability_domain is not None:
            _setter("availability_domain", availability_domain)
        if cloud_control_plane_server1 is not None:
            _setter("cloud_control_plane_server1", cloud_control_plane_server1)
        if cloud_control_plane_server2 is not None:
            _setter("cloud_control_plane_server2", cloud_control_plane_server2)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if compute_count is not None:
            _setter("compute_count", compute_count)
        if contacts is not None:
            _setter("contacts", contacts)
        if corporate_proxy is not None:
            _setter("corporate_proxy", corporate_proxy)
        if cpus_enabled is not None:
            _setter("cpus_enabled", cpus_enabled)
        if create_async is not None:
            _setter("create_async", create_async)
        if csi_number is not None:
            _setter("csi_number", csi_number)
        if data_storage_size_in_tbs is not None:
            _setter("data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            _setter("db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_server_version is not None:
            _setter("db_server_version", db_server_version)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if dns_servers is not None:
            _setter("dns_servers", dns_servers)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if gateway is not None:
            _setter("gateway", gateway)
        if infini_band_network_cidr is not None:
            _setter("infini_band_network_cidr", infini_band_network_cidr)
        if is_cps_offline_report_enabled is not None:
            _setter("is_cps_offline_report_enabled", is_cps_offline_report_enabled)
        if is_multi_rack_deployment is not None:
            _setter("is_multi_rack_deployment", is_multi_rack_deployment)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if maintenance_slo_status is not None:
            _setter("maintenance_slo_status", maintenance_slo_status)
        if maintenance_window is not None:
            _setter("maintenance_window", maintenance_window)
        if max_cpu_count is not None:
            _setter("max_cpu_count", max_cpu_count)
        if max_data_storage_in_tbs is not None:
            _setter("max_data_storage_in_tbs", max_data_storage_in_tbs)
        if max_db_node_storage_in_gbs is not None:
            _setter("max_db_node_storage_in_gbs", max_db_node_storage_in_gbs)
        if max_memory_in_gbs is not None:
            _setter("max_memory_in_gbs", max_memory_in_gbs)
        if memory_size_in_gbs is not None:
            _setter("memory_size_in_gbs", memory_size_in_gbs)
        if monthly_db_server_version is not None:
            _setter("monthly_db_server_version", monthly_db_server_version)
        if multi_rack_configuration_file is not None:
            _setter("multi_rack_configuration_file", multi_rack_configuration_file)
        if netmask is not None:
            _setter("netmask", netmask)
        if network_bonding_mode_details is not None:
            _setter("network_bonding_mode_details", network_bonding_mode_details)
        if ntp_servers is not None:
            _setter("ntp_servers", ntp_servers)
        if rack_serial_number is not None:
            _setter("rack_serial_number", rack_serial_number)
        if shape is not None:
            _setter("shape", shape)
        if state is not None:
            _setter("state", state)
        if storage_count is not None:
            _setter("storage_count", storage_count)
        if storage_server_version is not None:
            _setter("storage_server_version", storage_server_version)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_zone is not None:
            _setter("time_zone", time_zone)

    @property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> Optional[pulumi.Input[int]]:
        """
        The requested number of additional storage servers activated for the Exadata infrastructure.
        """
        return pulumi.get(self, "activated_storage_count")

    @activated_storage_count.setter
    def activated_storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "activated_storage_count", value)

    @property
    @pulumi.getter(name="activationFile")
    def activation_file(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The activation zip file. If provided in config, exadata infrastructure will be activated after creation. Updates are not allowed on activated exadata infrastructure.
        """
        return pulumi.get(self, "activation_file")

    @activation_file.setter
    def activation_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_file", value)

    @property
    @pulumi.getter(name="additionalComputeCount")
    def additional_compute_count(self) -> Optional[pulumi.Input[int]]:
        """
        The requested number of additional compute servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_compute_count")

    @additional_compute_count.setter
    def additional_compute_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_compute_count", value)

    @property
    @pulumi.getter(name="additionalComputeSystemModel")
    def additional_compute_system_model(self) -> Optional[pulumi.Input[str]]:
        """
        Oracle Exadata System Model specification. The system model determines the amount of compute or storage server resources available for use. For more information, please see [System and Shape Configuration Options] (https://docs.oracle.com/en/engineered-systems/exadata-cloud-at-customer/ecccm/ecc-system-config-options.html#GUID-9E090174-5C57-4EB1-9243-B470F9F10D6B)
        """
        return pulumi.get(self, "additional_compute_system_model")

    @additional_compute_system_model.setter
    def additional_compute_system_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_compute_system_model", value)

    @property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> Optional[pulumi.Input[int]]:
        """
        The requested number of additional storage servers for the Exadata infrastructure.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "additional_storage_count")

    @additional_storage_count.setter
    def additional_storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_storage_count", value)

    @property
    @pulumi.getter(name="adminNetworkCidr")
    def admin_network_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The CIDR block for the Exadata administration network.
        """
        return pulumi.get(self, "admin_network_cidr")

    @admin_network_cidr.setter
    def admin_network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_network_cidr", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the availability domain that the Exadata infrastructure is located in.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="cloudControlPlaneServer1")
    def cloud_control_plane_server1(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The IP address for the first control plane server.
        """
        return pulumi.get(self, "cloud_control_plane_server1")

    @cloud_control_plane_server1.setter
    def cloud_control_plane_server1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_control_plane_server1", value)

    @property
    @pulumi.getter(name="cloudControlPlaneServer2")
    def cloud_control_plane_server2(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The IP address for the second control plane server.
        """
        return pulumi.get(self, "cloud_control_plane_server2")

    @cloud_control_plane_server2.setter
    def cloud_control_plane_server2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_control_plane_server2", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of compute servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compute_count", value)

    @property
    @pulumi.getter
    def contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureContactArgs']]]]:
        """
        (Updatable) The list of contacts for the Exadata infrastructure.
        """
        return pulumi.get(self, "contacts")

    @contacts.setter
    def contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureContactArgs']]]]):
        pulumi.set(self, "contacts", value)

    @property
    @pulumi.getter(name="corporateProxy")
    def corporate_proxy(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The corporate network proxy for access to the control plane network. Oracle recommends using an HTTPS proxy when possible for enhanced security.
        """
        return pulumi.get(self, "corporate_proxy")

    @corporate_proxy.setter
    def corporate_proxy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "corporate_proxy", value)

    @property
    @pulumi.getter(name="cpusEnabled")
    def cpus_enabled(self) -> Optional[pulumi.Input[int]]:
        """
        The number of enabled CPU cores.
        """
        return pulumi.get(self, "cpus_enabled")

    @cpus_enabled.setter
    def cpus_enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpus_enabled", value)

    @property
    @pulumi.getter(name="createAsync")
    def create_async(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "create_async")

    @create_async.setter
    def create_async(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_async", value)

    @property
    @pulumi.getter(name="csiNumber")
    def csi_number(self) -> Optional[pulumi.Input[str]]:
        """
        The CSI Number of the Exadata infrastructure.
        """
        return pulumi.get(self, "csi_number")

    @csi_number.setter
    def csi_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csi_number", value)

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        Size, in terabytes, of the DATA disk group.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="dbServerVersion")
    def db_server_version(self) -> Optional[pulumi.Input[str]]:
        """
        The software version of the database servers (dom0) in the Exadata infrastructure.
        """
        return pulumi.get(self, "db_server_version")

    @db_server_version.setter
    def db_server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_server_version", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name for the Exadata infrastructure. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The list of DNS server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The gateway for the control plane network.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="infiniBandNetworkCidr")
    def infini_band_network_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The CIDR block for the Exadata InfiniBand interconnect.
        """
        return pulumi.get(self, "infini_band_network_cidr")

    @infini_band_network_cidr.setter
    def infini_band_network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infini_band_network_cidr", value)

    @property
    @pulumi.getter(name="isCpsOfflineReportEnabled")
    def is_cps_offline_report_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether cps offline diagnostic report is enabled for this Exadata infrastructure. This will allow a customer to quickly check status themselves and fix problems on their end, saving time and frustration for both Oracle and the customer when they find the CPS in a disconnected state.You can enable offline diagnostic report during Exadata infrastructure provisioning. You can also disable or enable it at any time using the UpdateExadatainfrastructure API.
        """
        return pulumi.get(self, "is_cps_offline_report_enabled")

    @is_cps_offline_report_enabled.setter
    def is_cps_offline_report_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cps_offline_report_enabled", value)

    @property
    @pulumi.getter(name="isMultiRackDeployment")
    def is_multi_rack_deployment(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if deployment is Multi-Rack or not.
        """
        return pulumi.get(self, "is_multi_rack_deployment")

    @is_multi_rack_deployment.setter
    def is_multi_rack_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_multi_rack_deployment", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="maintenanceSloStatus")
    def maintenance_slo_status(self) -> Optional[pulumi.Input[str]]:
        """
        A field to capture ‘Maintenance SLO Status’ for the Exadata infrastructure with values ‘OK’, ‘DEGRADED’. Default is ‘OK’ when the infrastructure is provisioned.
        """
        return pulumi.get(self, "maintenance_slo_status")

    @maintenance_slo_status.setter
    def maintenance_slo_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_slo_status", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['ExadataInfrastructureMaintenanceWindowArgs']]:
        """
        (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['ExadataInfrastructureMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of CPU cores available.
        """
        return pulumi.get(self, "max_cpu_count")

    @max_cpu_count.setter
    def max_cpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_cpu_count", value)

    @property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        The total available DATA disk group size.
        """
        return pulumi.get(self, "max_data_storage_in_tbs")

    @max_data_storage_in_tbs.setter
    def max_data_storage_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_data_storage_in_tbs", value)

    @property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The total local node storage available in GBs.
        """
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @max_db_node_storage_in_gbs.setter
    def max_db_node_storage_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_db_node_storage_in_gbs", value)

    @property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The total memory available in GBs.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @max_memory_in_gbs.setter
    def max_memory_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_memory_in_gbs", value)

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @property
    @pulumi.getter(name="monthlyDbServerVersion")
    def monthly_db_server_version(self) -> Optional[pulumi.Input[str]]:
        """
        The monthly software version of the database servers (dom0) in the Exadata infrastructure.
        """
        return pulumi.get(self, "monthly_db_server_version")

    @monthly_db_server_version.setter
    def monthly_db_server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monthly_db_server_version", value)

    @property
    @pulumi.getter(name="multiRackConfigurationFile")
    def multi_rack_configuration_file(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded Multi-Rack configuration json file.
        """
        return pulumi.get(self, "multi_rack_configuration_file")

    @multi_rack_configuration_file.setter
    def multi_rack_configuration_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_rack_configuration_file", value)

    @property
    @pulumi.getter
    def netmask(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The netmask for the control plane network.
        """
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netmask", value)

    @property
    @pulumi.getter(name="networkBondingModeDetails")
    def network_bonding_mode_details(self) -> Optional[pulumi.Input['ExadataInfrastructureNetworkBondingModeDetailsArgs']]:
        """
        (Updatable) Details of bonding mode for Client and Backup and DR networks of an Exadata infrastructure.
        """
        return pulumi.get(self, "network_bonding_mode_details")

    @network_bonding_mode_details.setter
    def network_bonding_mode_details(self, value: Optional[pulumi.Input['ExadataInfrastructureNetworkBondingModeDetailsArgs']]):
        pulumi.set(self, "network_bonding_mode_details", value)

    @property
    @pulumi.getter(name="ntpServers")
    def ntp_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The list of NTP server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "ntp_servers")

    @ntp_servers.setter
    def ntp_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ntp_servers", value)

    @property
    @pulumi.getter(name="rackSerialNumber")
    def rack_serial_number(self) -> Optional[pulumi.Input[str]]:
        """
        The serial number for the Exadata infrastructure.
        """
        return pulumi.get(self, "rack_serial_number")

    @rack_serial_number.setter
    def rack_serial_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rack_serial_number", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the Exadata infrastructure.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_count")

    @storage_count.setter
    def storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_count", value)

    @property
    @pulumi.getter(name="storageServerVersion")
    def storage_server_version(self) -> Optional[pulumi.Input[str]]:
        """
        The software version of the storage servers (cells) in the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_server_version")

    @storage_server_version.setter
    def storage_server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_server_version", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the Exadata infrastructure was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


class ExadataInfrastructure(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_file: Optional[pulumi.Input[str]] = None,
                 additional_storage_count: Optional[pulumi.Input[int]] = None,
                 admin_network_cidr: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server1: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server2: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[int]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExadataInfrastructureContactArgs']]]]] = None,
                 corporate_proxy: Optional[pulumi.Input[str]] = None,
                 create_async: Optional[pulumi.Input[bool]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 gateway: Optional[pulumi.Input[str]] = None,
                 infini_band_network_cidr: Optional[pulumi.Input[str]] = None,
                 is_cps_offline_report_enabled: Optional[pulumi.Input[bool]] = None,
                 is_multi_rack_deployment: Optional[pulumi.Input[bool]] = None,
                 maintenance_window: Optional[pulumi.Input[pulumi.InputType['ExadataInfrastructureMaintenanceWindowArgs']]] = None,
                 multi_rack_configuration_file: Optional[pulumi.Input[str]] = None,
                 netmask: Optional[pulumi.Input[str]] = None,
                 network_bonding_mode_details: Optional[pulumi.Input[pulumi.InputType['ExadataInfrastructureNetworkBondingModeDetailsArgs']]] = None,
                 ntp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 storage_count: Optional[pulumi.Input[int]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Exadata Infrastructure resource in Oracle Cloud Infrastructure Database service.

        Creates an Exadata infrastructure resource. Applies to Exadata Cloud@Customer instances only.
        To create an Exadata Cloud Service infrastructure resource, use the  [CreateCloudExadataInfrastructure](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudExadataInfrastructure/CreateCloudExadataInfrastructure) operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_exadata_infrastructure = oci.database.ExadataInfrastructure("testExadataInfrastructure",
            admin_network_cidr=var["exadata_infrastructure_admin_network_cidr"],
            cloud_control_plane_server1=var["exadata_infrastructure_cloud_control_plane_server1"],
            cloud_control_plane_server2=var["exadata_infrastructure_cloud_control_plane_server2"],
            compartment_id=var["compartment_id"],
            display_name=var["exadata_infrastructure_display_name"],
            dns_servers=var["exadata_infrastructure_dns_server"],
            gateway=var["exadata_infrastructure_gateway"],
            infini_band_network_cidr=var["exadata_infrastructure_infini_band_network_cidr"],
            netmask=var["exadata_infrastructure_netmask"],
            ntp_servers=var["exadata_infrastructure_ntp_server"],
            shape=var["exadata_infrastructure_shape"],
            time_zone=var["exadata_infrastructure_time_zone"],
            activation_file=var["exadata_infrastructure_activation_file"],
            compute_count=var["exadata_infrastructure_compute_count"],
            contacts=[oci.database.ExadataInfrastructureContactArgs(
                email=var["exadata_infrastructure_contacts_email"],
                is_primary=var["exadata_infrastructure_contacts_is_primary"],
                name=var["exadata_infrastructure_contacts_name"],
                is_contact_mos_validated=var["exadata_infrastructure_contacts_is_contact_mos_validated"],
                phone_number=var["exadata_infrastructure_contacts_phone_number"],
            )],
            corporate_proxy=var["exadata_infrastructure_corporate_proxy"],
            defined_tags=var["exadata_infrastructure_defined_tags"],
            freeform_tags={
                "Department": "Finance",
            },
            is_cps_offline_report_enabled=var["exadata_infrastructure_is_cps_offline_report_enabled"],
            is_multi_rack_deployment=var["exadata_infrastructure_is_multi_rack_deployment"],
            maintenance_window=oci.database.ExadataInfrastructureMaintenanceWindowArgs(
                custom_action_timeout_in_mins=var["exadata_infrastructure_maintenance_window_custom_action_timeout_in_mins"],
                days_of_weeks=[oci.database.ExadataInfrastructureMaintenanceWindowDaysOfWeekArgs(
                    name=var["exadata_infrastructure_maintenance_window_days_of_week_name"],
                )],
                hours_of_days=var["exadata_infrastructure_maintenance_window_hours_of_day"],
                is_custom_action_timeout_enabled=var["exadata_infrastructure_maintenance_window_is_custom_action_timeout_enabled"],
                is_monthly_patching_enabled=var["exadata_infrastructure_maintenance_window_is_monthly_patching_enabled"],
                lead_time_in_weeks=var["exadata_infrastructure_maintenance_window_lead_time_in_weeks"],
                months=[oci.database.ExadataInfrastructureMaintenanceWindowMonthArgs(
                    name=var["exadata_infrastructure_maintenance_window_months_name"],
                )],
                patching_mode=var["exadata_infrastructure_maintenance_window_patching_mode"],
                preference=var["exadata_infrastructure_maintenance_window_preference"],
                weeks_of_months=var["exadata_infrastructure_maintenance_window_weeks_of_month"],
            ),
            multi_rack_configuration_file=var["exadata_infrastructure_multi_rack_configuration_file"],
            network_bonding_mode_details=oci.database.ExadataInfrastructureNetworkBondingModeDetailsArgs(
                backup_network_bonding_mode=var["exadata_infrastructure_network_bonding_mode_details_backup_network_bonding_mode"],
                client_network_bonding_mode=var["exadata_infrastructure_network_bonding_mode_details_client_network_bonding_mode"],
                dr_network_bonding_mode=var["exadata_infrastructure_network_bonding_mode_details_dr_network_bonding_mode"],
            ),
            storage_count=var["exadata_infrastructure_storage_count"])
        ```

        ## Import

        ExadataInfrastructures can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Database/exadataInfrastructure:ExadataInfrastructure test_exadata_infrastructure "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] activation_file: (Updatable) The activation zip file. If provided in config, exadata infrastructure will be activated after creation. Updates are not allowed on activated exadata infrastructure.
        :param pulumi.Input[int] additional_storage_count: The requested number of additional storage servers for the Exadata infrastructure.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] admin_network_cidr: (Updatable) The CIDR block for the Exadata administration network.
        :param pulumi.Input[str] cloud_control_plane_server1: (Updatable) The IP address for the first control plane server.
        :param pulumi.Input[str] cloud_control_plane_server2: (Updatable) The IP address for the second control plane server.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] compute_count: The number of compute servers for the Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExadataInfrastructureContactArgs']]]] contacts: (Updatable) The list of contacts for the Exadata infrastructure.
        :param pulumi.Input[str] corporate_proxy: (Updatable) The corporate network proxy for access to the control plane network. Oracle recommends using an HTTPS proxy when possible for enhanced security.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-friendly name for the Exadata infrastructure. The name does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: (Updatable) The list of DNS server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gateway: (Updatable) The gateway for the control plane network.
        :param pulumi.Input[str] infini_band_network_cidr: (Updatable) The CIDR block for the Exadata InfiniBand interconnect.
        :param pulumi.Input[bool] is_cps_offline_report_enabled: (Updatable) Indicates whether cps offline diagnostic report is enabled for this Exadata infrastructure. This will allow a customer to quickly check status themselves and fix problems on their end, saving time and frustration for both Oracle and the customer when they find the CPS in a disconnected state.You can enable offline diagnostic report during Exadata infrastructure provisioning. You can also disable or enable it at any time using the UpdateExadatainfrastructure API.
        :param pulumi.Input[bool] is_multi_rack_deployment: (Updatable) Indicates if deployment is Multi-Rack or not.
        :param pulumi.Input[pulumi.InputType['ExadataInfrastructureMaintenanceWindowArgs']] maintenance_window: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[str] multi_rack_configuration_file: (Updatable) The base64 encoded Multi-Rack configuration json file.
        :param pulumi.Input[str] netmask: (Updatable) The netmask for the control plane network.
        :param pulumi.Input[pulumi.InputType['ExadataInfrastructureNetworkBondingModeDetailsArgs']] network_bonding_mode_details: (Updatable) Details of bonding mode for Client and Backup and DR networks of an Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ntp_servers: (Updatable) The list of NTP server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[str] shape: The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        :param pulumi.Input[int] storage_count: The number of storage servers for the Exadata infrastructure.
        :param pulumi.Input[str] time_zone: (Updatable) The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExadataInfrastructureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Exadata Infrastructure resource in Oracle Cloud Infrastructure Database service.

        Creates an Exadata infrastructure resource. Applies to Exadata Cloud@Customer instances only.
        To create an Exadata Cloud Service infrastructure resource, use the  [CreateCloudExadataInfrastructure](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudExadataInfrastructure/CreateCloudExadataInfrastructure) operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_exadata_infrastructure = oci.database.ExadataInfrastructure("testExadataInfrastructure",
            admin_network_cidr=var["exadata_infrastructure_admin_network_cidr"],
            cloud_control_plane_server1=var["exadata_infrastructure_cloud_control_plane_server1"],
            cloud_control_plane_server2=var["exadata_infrastructure_cloud_control_plane_server2"],
            compartment_id=var["compartment_id"],
            display_name=var["exadata_infrastructure_display_name"],
            dns_servers=var["exadata_infrastructure_dns_server"],
            gateway=var["exadata_infrastructure_gateway"],
            infini_band_network_cidr=var["exadata_infrastructure_infini_band_network_cidr"],
            netmask=var["exadata_infrastructure_netmask"],
            ntp_servers=var["exadata_infrastructure_ntp_server"],
            shape=var["exadata_infrastructure_shape"],
            time_zone=var["exadata_infrastructure_time_zone"],
            activation_file=var["exadata_infrastructure_activation_file"],
            compute_count=var["exadata_infrastructure_compute_count"],
            contacts=[oci.database.ExadataInfrastructureContactArgs(
                email=var["exadata_infrastructure_contacts_email"],
                is_primary=var["exadata_infrastructure_contacts_is_primary"],
                name=var["exadata_infrastructure_contacts_name"],
                is_contact_mos_validated=var["exadata_infrastructure_contacts_is_contact_mos_validated"],
                phone_number=var["exadata_infrastructure_contacts_phone_number"],
            )],
            corporate_proxy=var["exadata_infrastructure_corporate_proxy"],
            defined_tags=var["exadata_infrastructure_defined_tags"],
            freeform_tags={
                "Department": "Finance",
            },
            is_cps_offline_report_enabled=var["exadata_infrastructure_is_cps_offline_report_enabled"],
            is_multi_rack_deployment=var["exadata_infrastructure_is_multi_rack_deployment"],
            maintenance_window=oci.database.ExadataInfrastructureMaintenanceWindowArgs(
                custom_action_timeout_in_mins=var["exadata_infrastructure_maintenance_window_custom_action_timeout_in_mins"],
                days_of_weeks=[oci.database.ExadataInfrastructureMaintenanceWindowDaysOfWeekArgs(
                    name=var["exadata_infrastructure_maintenance_window_days_of_week_name"],
                )],
                hours_of_days=var["exadata_infrastructure_maintenance_window_hours_of_day"],
                is_custom_action_timeout_enabled=var["exadata_infrastructure_maintenance_window_is_custom_action_timeout_enabled"],
                is_monthly_patching_enabled=var["exadata_infrastructure_maintenance_window_is_monthly_patching_enabled"],
                lead_time_in_weeks=var["exadata_infrastructure_maintenance_window_lead_time_in_weeks"],
                months=[oci.database.ExadataInfrastructureMaintenanceWindowMonthArgs(
                    name=var["exadata_infrastructure_maintenance_window_months_name"],
                )],
                patching_mode=var["exadata_infrastructure_maintenance_window_patching_mode"],
                preference=var["exadata_infrastructure_maintenance_window_preference"],
                weeks_of_months=var["exadata_infrastructure_maintenance_window_weeks_of_month"],
            ),
            multi_rack_configuration_file=var["exadata_infrastructure_multi_rack_configuration_file"],
            network_bonding_mode_details=oci.database.ExadataInfrastructureNetworkBondingModeDetailsArgs(
                backup_network_bonding_mode=var["exadata_infrastructure_network_bonding_mode_details_backup_network_bonding_mode"],
                client_network_bonding_mode=var["exadata_infrastructure_network_bonding_mode_details_client_network_bonding_mode"],
                dr_network_bonding_mode=var["exadata_infrastructure_network_bonding_mode_details_dr_network_bonding_mode"],
            ),
            storage_count=var["exadata_infrastructure_storage_count"])
        ```

        ## Import

        ExadataInfrastructures can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Database/exadataInfrastructure:ExadataInfrastructure test_exadata_infrastructure "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExadataInfrastructureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExadataInfrastructureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ExadataInfrastructureArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_file: Optional[pulumi.Input[str]] = None,
                 additional_storage_count: Optional[pulumi.Input[int]] = None,
                 admin_network_cidr: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server1: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server2: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[int]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExadataInfrastructureContactArgs']]]]] = None,
                 corporate_proxy: Optional[pulumi.Input[str]] = None,
                 create_async: Optional[pulumi.Input[bool]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 gateway: Optional[pulumi.Input[str]] = None,
                 infini_band_network_cidr: Optional[pulumi.Input[str]] = None,
                 is_cps_offline_report_enabled: Optional[pulumi.Input[bool]] = None,
                 is_multi_rack_deployment: Optional[pulumi.Input[bool]] = None,
                 maintenance_window: Optional[pulumi.Input[pulumi.InputType['ExadataInfrastructureMaintenanceWindowArgs']]] = None,
                 multi_rack_configuration_file: Optional[pulumi.Input[str]] = None,
                 netmask: Optional[pulumi.Input[str]] = None,
                 network_bonding_mode_details: Optional[pulumi.Input[pulumi.InputType['ExadataInfrastructureNetworkBondingModeDetailsArgs']]] = None,
                 ntp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 storage_count: Optional[pulumi.Input[int]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExadataInfrastructureArgs.__new__(ExadataInfrastructureArgs)

            __props__.__dict__["activation_file"] = activation_file
            __props__.__dict__["additional_storage_count"] = additional_storage_count
            if admin_network_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'admin_network_cidr'")
            __props__.__dict__["admin_network_cidr"] = admin_network_cidr
            if cloud_control_plane_server1 is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_control_plane_server1'")
            __props__.__dict__["cloud_control_plane_server1"] = cloud_control_plane_server1
            if cloud_control_plane_server2 is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_control_plane_server2'")
            __props__.__dict__["cloud_control_plane_server2"] = cloud_control_plane_server2
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["compute_count"] = compute_count
            __props__.__dict__["contacts"] = contacts
            __props__.__dict__["corporate_proxy"] = corporate_proxy
            __props__.__dict__["create_async"] = create_async
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if dns_servers is None and not opts.urn:
                raise TypeError("Missing required property 'dns_servers'")
            __props__.__dict__["dns_servers"] = dns_servers
            __props__.__dict__["freeform_tags"] = freeform_tags
            if gateway is None and not opts.urn:
                raise TypeError("Missing required property 'gateway'")
            __props__.__dict__["gateway"] = gateway
            if infini_band_network_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'infini_band_network_cidr'")
            __props__.__dict__["infini_band_network_cidr"] = infini_band_network_cidr
            __props__.__dict__["is_cps_offline_report_enabled"] = is_cps_offline_report_enabled
            __props__.__dict__["is_multi_rack_deployment"] = is_multi_rack_deployment
            if maintenance_window is not None and not isinstance(maintenance_window, ExadataInfrastructureMaintenanceWindowArgs):
                maintenance_window = maintenance_window or {}
                def _setter(key, value):
                    maintenance_window[key] = value
                ExadataInfrastructureMaintenanceWindowArgs._configure(_setter, **maintenance_window)
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["multi_rack_configuration_file"] = multi_rack_configuration_file
            if netmask is None and not opts.urn:
                raise TypeError("Missing required property 'netmask'")
            __props__.__dict__["netmask"] = netmask
            if network_bonding_mode_details is not None and not isinstance(network_bonding_mode_details, ExadataInfrastructureNetworkBondingModeDetailsArgs):
                network_bonding_mode_details = network_bonding_mode_details or {}
                def _setter(key, value):
                    network_bonding_mode_details[key] = value
                ExadataInfrastructureNetworkBondingModeDetailsArgs._configure(_setter, **network_bonding_mode_details)
            __props__.__dict__["network_bonding_mode_details"] = network_bonding_mode_details
            if ntp_servers is None and not opts.urn:
                raise TypeError("Missing required property 'ntp_servers'")
            __props__.__dict__["ntp_servers"] = ntp_servers
            if shape is None and not opts.urn:
                raise TypeError("Missing required property 'shape'")
            __props__.__dict__["shape"] = shape
            __props__.__dict__["storage_count"] = storage_count
            if time_zone is None and not opts.urn:
                raise TypeError("Missing required property 'time_zone'")
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["activated_storage_count"] = None
            __props__.__dict__["additional_compute_count"] = None
            __props__.__dict__["additional_compute_system_model"] = None
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["cpus_enabled"] = None
            __props__.__dict__["csi_number"] = None
            __props__.__dict__["data_storage_size_in_tbs"] = None
            __props__.__dict__["db_node_storage_size_in_gbs"] = None
            __props__.__dict__["db_server_version"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["maintenance_slo_status"] = None
            __props__.__dict__["max_cpu_count"] = None
            __props__.__dict__["max_data_storage_in_tbs"] = None
            __props__.__dict__["max_db_node_storage_in_gbs"] = None
            __props__.__dict__["max_memory_in_gbs"] = None
            __props__.__dict__["memory_size_in_gbs"] = None
            __props__.__dict__["monthly_db_server_version"] = None
            __props__.__dict__["rack_serial_number"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["storage_server_version"] = None
            __props__.__dict__["time_created"] = None
        super(ExadataInfrastructure, __self__).__init__(
            'oci:Database/exadataInfrastructure:ExadataInfrastructure',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activated_storage_count: Optional[pulumi.Input[int]] = None,
            activation_file: Optional[pulumi.Input[str]] = None,
            additional_compute_count: Optional[pulumi.Input[int]] = None,
            additional_compute_system_model: Optional[pulumi.Input[str]] = None,
            additional_storage_count: Optional[pulumi.Input[int]] = None,
            admin_network_cidr: Optional[pulumi.Input[str]] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            cloud_control_plane_server1: Optional[pulumi.Input[str]] = None,
            cloud_control_plane_server2: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            compute_count: Optional[pulumi.Input[int]] = None,
            contacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExadataInfrastructureContactArgs']]]]] = None,
            corporate_proxy: Optional[pulumi.Input[str]] = None,
            cpus_enabled: Optional[pulumi.Input[int]] = None,
            create_async: Optional[pulumi.Input[bool]] = None,
            csi_number: Optional[pulumi.Input[str]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
            db_server_version: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            gateway: Optional[pulumi.Input[str]] = None,
            infini_band_network_cidr: Optional[pulumi.Input[str]] = None,
            is_cps_offline_report_enabled: Optional[pulumi.Input[bool]] = None,
            is_multi_rack_deployment: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            maintenance_slo_status: Optional[pulumi.Input[str]] = None,
            maintenance_window: Optional[pulumi.Input[pulumi.InputType['ExadataInfrastructureMaintenanceWindowArgs']]] = None,
            max_cpu_count: Optional[pulumi.Input[int]] = None,
            max_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
            max_db_node_storage_in_gbs: Optional[pulumi.Input[int]] = None,
            max_memory_in_gbs: Optional[pulumi.Input[int]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
            monthly_db_server_version: Optional[pulumi.Input[str]] = None,
            multi_rack_configuration_file: Optional[pulumi.Input[str]] = None,
            netmask: Optional[pulumi.Input[str]] = None,
            network_bonding_mode_details: Optional[pulumi.Input[pulumi.InputType['ExadataInfrastructureNetworkBondingModeDetailsArgs']]] = None,
            ntp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            rack_serial_number: Optional[pulumi.Input[str]] = None,
            shape: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            storage_count: Optional[pulumi.Input[int]] = None,
            storage_server_version: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_zone: Optional[pulumi.Input[str]] = None) -> 'ExadataInfrastructure':
        """
        Get an existing ExadataInfrastructure resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] activated_storage_count: The requested number of additional storage servers activated for the Exadata infrastructure.
        :param pulumi.Input[str] activation_file: (Updatable) The activation zip file. If provided in config, exadata infrastructure will be activated after creation. Updates are not allowed on activated exadata infrastructure.
        :param pulumi.Input[int] additional_compute_count: The requested number of additional compute servers for the Exadata infrastructure.
        :param pulumi.Input[str] additional_compute_system_model: Oracle Exadata System Model specification. The system model determines the amount of compute or storage server resources available for use. For more information, please see [System and Shape Configuration Options] (https://docs.oracle.com/en/engineered-systems/exadata-cloud-at-customer/ecccm/ecc-system-config-options.html#GUID-9E090174-5C57-4EB1-9243-B470F9F10D6B)
        :param pulumi.Input[int] additional_storage_count: The requested number of additional storage servers for the Exadata infrastructure.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] admin_network_cidr: (Updatable) The CIDR block for the Exadata administration network.
        :param pulumi.Input[str] availability_domain: The name of the availability domain that the Exadata infrastructure is located in.
        :param pulumi.Input[str] cloud_control_plane_server1: (Updatable) The IP address for the first control plane server.
        :param pulumi.Input[str] cloud_control_plane_server2: (Updatable) The IP address for the second control plane server.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] compute_count: The number of compute servers for the Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExadataInfrastructureContactArgs']]]] contacts: (Updatable) The list of contacts for the Exadata infrastructure.
        :param pulumi.Input[str] corporate_proxy: (Updatable) The corporate network proxy for access to the control plane network. Oracle recommends using an HTTPS proxy when possible for enhanced security.
        :param pulumi.Input[int] cpus_enabled: The number of enabled CPU cores.
        :param pulumi.Input[str] csi_number: The CSI Number of the Exadata infrastructure.
        :param pulumi.Input[float] data_storage_size_in_tbs: Size, in terabytes, of the DATA disk group.
        :param pulumi.Input[int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[str] db_server_version: The software version of the database servers (dom0) in the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-friendly name for the Exadata infrastructure. The name does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: (Updatable) The list of DNS server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gateway: (Updatable) The gateway for the control plane network.
        :param pulumi.Input[str] infini_band_network_cidr: (Updatable) The CIDR block for the Exadata InfiniBand interconnect.
        :param pulumi.Input[bool] is_cps_offline_report_enabled: (Updatable) Indicates whether cps offline diagnostic report is enabled for this Exadata infrastructure. This will allow a customer to quickly check status themselves and fix problems on their end, saving time and frustration for both Oracle and the customer when they find the CPS in a disconnected state.You can enable offline diagnostic report during Exadata infrastructure provisioning. You can also disable or enable it at any time using the UpdateExadatainfrastructure API.
        :param pulumi.Input[bool] is_multi_rack_deployment: (Updatable) Indicates if deployment is Multi-Rack or not.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] maintenance_slo_status: A field to capture ‘Maintenance SLO Status’ for the Exadata infrastructure with values ‘OK’, ‘DEGRADED’. Default is ‘OK’ when the infrastructure is provisioned.
        :param pulumi.Input[pulumi.InputType['ExadataInfrastructureMaintenanceWindowArgs']] maintenance_window: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] max_cpu_count: The total number of CPU cores available.
        :param pulumi.Input[float] max_data_storage_in_tbs: The total available DATA disk group size.
        :param pulumi.Input[int] max_db_node_storage_in_gbs: The total local node storage available in GBs.
        :param pulumi.Input[int] max_memory_in_gbs: The total memory available in GBs.
        :param pulumi.Input[int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[str] monthly_db_server_version: The monthly software version of the database servers (dom0) in the Exadata infrastructure.
        :param pulumi.Input[str] multi_rack_configuration_file: (Updatable) The base64 encoded Multi-Rack configuration json file.
        :param pulumi.Input[str] netmask: (Updatable) The netmask for the control plane network.
        :param pulumi.Input[pulumi.InputType['ExadataInfrastructureNetworkBondingModeDetailsArgs']] network_bonding_mode_details: (Updatable) Details of bonding mode for Client and Backup and DR networks of an Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ntp_servers: (Updatable) The list of NTP server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[str] rack_serial_number: The serial number for the Exadata infrastructure.
        :param pulumi.Input[str] shape: The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        :param pulumi.Input[str] state: The current lifecycle state of the Exadata infrastructure.
        :param pulumi.Input[int] storage_count: The number of storage servers for the Exadata infrastructure.
        :param pulumi.Input[str] storage_server_version: The software version of the storage servers (cells) in the Exadata infrastructure.
        :param pulumi.Input[str] time_created: The date and time the Exadata infrastructure was created.
        :param pulumi.Input[str] time_zone: (Updatable) The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExadataInfrastructureState.__new__(_ExadataInfrastructureState)

        __props__.__dict__["activated_storage_count"] = activated_storage_count
        __props__.__dict__["activation_file"] = activation_file
        __props__.__dict__["additional_compute_count"] = additional_compute_count
        __props__.__dict__["additional_compute_system_model"] = additional_compute_system_model
        __props__.__dict__["additional_storage_count"] = additional_storage_count
        __props__.__dict__["admin_network_cidr"] = admin_network_cidr
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["cloud_control_plane_server1"] = cloud_control_plane_server1
        __props__.__dict__["cloud_control_plane_server2"] = cloud_control_plane_server2
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_count"] = compute_count
        __props__.__dict__["contacts"] = contacts
        __props__.__dict__["corporate_proxy"] = corporate_proxy
        __props__.__dict__["cpus_enabled"] = cpus_enabled
        __props__.__dict__["create_async"] = create_async
        __props__.__dict__["csi_number"] = csi_number
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
        __props__.__dict__["db_server_version"] = db_server_version
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dns_servers"] = dns_servers
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["gateway"] = gateway
        __props__.__dict__["infini_band_network_cidr"] = infini_band_network_cidr
        __props__.__dict__["is_cps_offline_report_enabled"] = is_cps_offline_report_enabled
        __props__.__dict__["is_multi_rack_deployment"] = is_multi_rack_deployment
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["maintenance_slo_status"] = maintenance_slo_status
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["max_cpu_count"] = max_cpu_count
        __props__.__dict__["max_data_storage_in_tbs"] = max_data_storage_in_tbs
        __props__.__dict__["max_db_node_storage_in_gbs"] = max_db_node_storage_in_gbs
        __props__.__dict__["max_memory_in_gbs"] = max_memory_in_gbs
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["monthly_db_server_version"] = monthly_db_server_version
        __props__.__dict__["multi_rack_configuration_file"] = multi_rack_configuration_file
        __props__.__dict__["netmask"] = netmask
        __props__.__dict__["network_bonding_mode_details"] = network_bonding_mode_details
        __props__.__dict__["ntp_servers"] = ntp_servers
        __props__.__dict__["rack_serial_number"] = rack_serial_number
        __props__.__dict__["shape"] = shape
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_count"] = storage_count
        __props__.__dict__["storage_server_version"] = storage_server_version
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_zone"] = time_zone
        return ExadataInfrastructure(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> pulumi.Output[int]:
        """
        The requested number of additional storage servers activated for the Exadata infrastructure.
        """
        return pulumi.get(self, "activated_storage_count")

    @property
    @pulumi.getter(name="activationFile")
    def activation_file(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The activation zip file. If provided in config, exadata infrastructure will be activated after creation. Updates are not allowed on activated exadata infrastructure.
        """
        return pulumi.get(self, "activation_file")

    @property
    @pulumi.getter(name="additionalComputeCount")
    def additional_compute_count(self) -> pulumi.Output[int]:
        """
        The requested number of additional compute servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_compute_count")

    @property
    @pulumi.getter(name="additionalComputeSystemModel")
    def additional_compute_system_model(self) -> pulumi.Output[str]:
        """
        Oracle Exadata System Model specification. The system model determines the amount of compute or storage server resources available for use. For more information, please see [System and Shape Configuration Options] (https://docs.oracle.com/en/engineered-systems/exadata-cloud-at-customer/ecccm/ecc-system-config-options.html#GUID-9E090174-5C57-4EB1-9243-B470F9F10D6B)
        """
        return pulumi.get(self, "additional_compute_system_model")

    @property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> pulumi.Output[int]:
        """
        The requested number of additional storage servers for the Exadata infrastructure.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "additional_storage_count")

    @property
    @pulumi.getter(name="adminNetworkCidr")
    def admin_network_cidr(self) -> pulumi.Output[str]:
        """
        (Updatable) The CIDR block for the Exadata administration network.
        """
        return pulumi.get(self, "admin_network_cidr")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The name of the availability domain that the Exadata infrastructure is located in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="cloudControlPlaneServer1")
    def cloud_control_plane_server1(self) -> pulumi.Output[str]:
        """
        (Updatable) The IP address for the first control plane server.
        """
        return pulumi.get(self, "cloud_control_plane_server1")

    @property
    @pulumi.getter(name="cloudControlPlaneServer2")
    def cloud_control_plane_server2(self) -> pulumi.Output[str]:
        """
        (Updatable) The IP address for the second control plane server.
        """
        return pulumi.get(self, "cloud_control_plane_server2")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Output[int]:
        """
        The number of compute servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "compute_count")

    @property
    @pulumi.getter
    def contacts(self) -> pulumi.Output[Optional[Sequence['outputs.ExadataInfrastructureContact']]]:
        """
        (Updatable) The list of contacts for the Exadata infrastructure.
        """
        return pulumi.get(self, "contacts")

    @property
    @pulumi.getter(name="corporateProxy")
    def corporate_proxy(self) -> pulumi.Output[str]:
        """
        (Updatable) The corporate network proxy for access to the control plane network. Oracle recommends using an HTTPS proxy when possible for enhanced security.
        """
        return pulumi.get(self, "corporate_proxy")

    @property
    @pulumi.getter(name="cpusEnabled")
    def cpus_enabled(self) -> pulumi.Output[int]:
        """
        The number of enabled CPU cores.
        """
        return pulumi.get(self, "cpus_enabled")

    @property
    @pulumi.getter(name="createAsync")
    def create_async(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "create_async")

    @property
    @pulumi.getter(name="csiNumber")
    def csi_number(self) -> pulumi.Output[str]:
        """
        The CSI Number of the Exadata infrastructure.
        """
        return pulumi.get(self, "csi_number")

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[float]:
        """
        Size, in terabytes, of the DATA disk group.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="dbServerVersion")
    def db_server_version(self) -> pulumi.Output[str]:
        """
        The software version of the database servers (dom0) in the Exadata infrastructure.
        """
        return pulumi.get(self, "db_server_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The user-friendly name for the Exadata infrastructure. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The list of DNS server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Output[str]:
        """
        (Updatable) The gateway for the control plane network.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="infiniBandNetworkCidr")
    def infini_band_network_cidr(self) -> pulumi.Output[str]:
        """
        (Updatable) The CIDR block for the Exadata InfiniBand interconnect.
        """
        return pulumi.get(self, "infini_band_network_cidr")

    @property
    @pulumi.getter(name="isCpsOfflineReportEnabled")
    def is_cps_offline_report_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates whether cps offline diagnostic report is enabled for this Exadata infrastructure. This will allow a customer to quickly check status themselves and fix problems on their end, saving time and frustration for both Oracle and the customer when they find the CPS in a disconnected state.You can enable offline diagnostic report during Exadata infrastructure provisioning. You can also disable or enable it at any time using the UpdateExadatainfrastructure API.
        """
        return pulumi.get(self, "is_cps_offline_report_enabled")

    @property
    @pulumi.getter(name="isMultiRackDeployment")
    def is_multi_rack_deployment(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates if deployment is Multi-Rack or not.
        """
        return pulumi.get(self, "is_multi_rack_deployment")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceSloStatus")
    def maintenance_slo_status(self) -> pulumi.Output[str]:
        """
        A field to capture ‘Maintenance SLO Status’ for the Exadata infrastructure with values ‘OK’, ‘DEGRADED’. Default is ‘OK’ when the infrastructure is provisioned.
        """
        return pulumi.get(self, "maintenance_slo_status")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.ExadataInfrastructureMaintenanceWindow']:
        """
        (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> pulumi.Output[int]:
        """
        The total number of CPU cores available.
        """
        return pulumi.get(self, "max_cpu_count")

    @property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> pulumi.Output[float]:
        """
        The total available DATA disk group size.
        """
        return pulumi.get(self, "max_data_storage_in_tbs")

    @property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> pulumi.Output[int]:
        """
        The total local node storage available in GBs.
        """
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> pulumi.Output[int]:
        """
        The total memory available in GBs.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter(name="monthlyDbServerVersion")
    def monthly_db_server_version(self) -> pulumi.Output[str]:
        """
        The monthly software version of the database servers (dom0) in the Exadata infrastructure.
        """
        return pulumi.get(self, "monthly_db_server_version")

    @property
    @pulumi.getter(name="multiRackConfigurationFile")
    def multi_rack_configuration_file(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The base64 encoded Multi-Rack configuration json file.
        """
        return pulumi.get(self, "multi_rack_configuration_file")

    @property
    @pulumi.getter
    def netmask(self) -> pulumi.Output[str]:
        """
        (Updatable) The netmask for the control plane network.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="networkBondingModeDetails")
    def network_bonding_mode_details(self) -> pulumi.Output['outputs.ExadataInfrastructureNetworkBondingModeDetails']:
        """
        (Updatable) Details of bonding mode for Client and Backup and DR networks of an Exadata infrastructure.
        """
        return pulumi.get(self, "network_bonding_mode_details")

    @property
    @pulumi.getter(name="ntpServers")
    def ntp_servers(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The list of NTP server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "ntp_servers")

    @property
    @pulumi.getter(name="rackSerialNumber")
    def rack_serial_number(self) -> pulumi.Output[str]:
        """
        The serial number for the Exadata infrastructure.
        """
        return pulumi.get(self, "rack_serial_number")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[str]:
        """
        The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the Exadata infrastructure.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> pulumi.Output[int]:
        """
        The number of storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_count")

    @property
    @pulumi.getter(name="storageServerVersion")
    def storage_server_version(self) -> pulumi.Output[str]:
        """
        The software version of the storage servers (cells) in the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_server_version")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the Exadata infrastructure was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        (Updatable) The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

