# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalPluggableDatabaseArgs', 'ExternalPluggableDatabase']

@pulumi.input_type
class ExternalPluggableDatabaseArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 external_container_database_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 source_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ExternalPluggableDatabase resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the external database. The name does not have to be unique.
        :param pulumi.Input[str] external_container_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalContainerDatabaseDetails) that contains the specified [external pluggable database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalPluggableDatabaseDetails) resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the the non-container database that was converted to a pluggable database to create this resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ExternalPluggableDatabaseArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            display_name=display_name,
            external_container_database_id=external_container_database_id,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            source_id=source_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             display_name: pulumi.Input[str],
             external_container_database_id: pulumi.Input[str],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             source_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'externalContainerDatabaseId' in kwargs:
            external_container_database_id = kwargs['externalContainerDatabaseId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'sourceId' in kwargs:
            source_id = kwargs['sourceId']

        _setter("compartment_id", compartment_id)
        _setter("display_name", display_name)
        _setter("external_container_database_id", external_container_database_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if source_id is not None:
            _setter("source_id", source_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The user-friendly name for the external database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="externalContainerDatabaseId")
    def external_container_database_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalContainerDatabaseDetails) that contains the specified [external pluggable database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalPluggableDatabaseDetails) resource.
        """
        return pulumi.get(self, "external_container_database_id")

    @external_container_database_id.setter
    def external_container_database_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_container_database_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the the non-container database that was converted to a pluggable database to create this resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_id", value)


@pulumi.input_type
class _ExternalPluggableDatabaseState:
    def __init__(__self__, *,
                 character_set: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 database_configuration: Optional[pulumi.Input[str]] = None,
                 database_edition: Optional[pulumi.Input[str]] = None,
                 database_management_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalPluggableDatabaseDatabaseManagementConfigArgs']]]] = None,
                 database_version: Optional[pulumi.Input[str]] = None,
                 db_id: Optional[pulumi.Input[str]] = None,
                 db_packs: Optional[pulumi.Input[str]] = None,
                 db_unique_name: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 external_container_database_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 ncharacter_set: Optional[pulumi.Input[str]] = None,
                 operations_insights_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalPluggableDatabaseOperationsInsightsConfigArgs']]]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 stack_monitoring_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalPluggableDatabaseStackMonitoringConfigArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExternalPluggableDatabase resources.
        :param pulumi.Input[str] character_set: The character set of the external database.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] database_configuration: The Oracle Database configuration
        :param pulumi.Input[str] database_edition: The Oracle Database edition.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalPluggableDatabaseDatabaseManagementConfigArgs']]] database_management_configs: The configuration of the Database Management service.
        :param pulumi.Input[str] database_version: The Oracle Database version.
        :param pulumi.Input[str] db_id: The Oracle Database ID, which identifies an Oracle Database located outside of Oracle Cloud.
        :param pulumi.Input[str] db_packs: The database packs licensed for the external Oracle Database.
        :param pulumi.Input[str] db_unique_name: The `DB_UNIQUE_NAME` of the external database.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the external database. The name does not have to be unique.
        :param pulumi.Input[str] external_container_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalContainerDatabaseDetails) that contains the specified [external pluggable database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalPluggableDatabaseDetails) resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] ncharacter_set: The national character of the external database.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalPluggableDatabaseOperationsInsightsConfigArgs']]] operations_insights_configs: The configuration of Operations Insights for the external database
        :param pulumi.Input[str] source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the the non-container database that was converted to a pluggable database to create this resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['ExternalPluggableDatabaseStackMonitoringConfigArgs']]] stack_monitoring_configs: The configuration of Stack Monitoring for the external database.
        :param pulumi.Input[str] state: The current state of the Oracle Cloud Infrastructure external database resource.
        :param pulumi.Input[str] time_created: The date and time the database was created.
        :param pulumi.Input[str] time_zone: The time zone of the external database. It is a time zone offset (a character type in the format '[+|-]TZH:TZM') or a time zone region name, depending on how the time zone value was specified when the database was created / last altered.
        """
        _ExternalPluggableDatabaseState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            character_set=character_set,
            compartment_id=compartment_id,
            database_configuration=database_configuration,
            database_edition=database_edition,
            database_management_configs=database_management_configs,
            database_version=database_version,
            db_id=db_id,
            db_packs=db_packs,
            db_unique_name=db_unique_name,
            defined_tags=defined_tags,
            display_name=display_name,
            external_container_database_id=external_container_database_id,
            freeform_tags=freeform_tags,
            lifecycle_details=lifecycle_details,
            ncharacter_set=ncharacter_set,
            operations_insights_configs=operations_insights_configs,
            source_id=source_id,
            stack_monitoring_configs=stack_monitoring_configs,
            state=state,
            time_created=time_created,
            time_zone=time_zone,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             character_set: Optional[pulumi.Input[str]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             database_configuration: Optional[pulumi.Input[str]] = None,
             database_edition: Optional[pulumi.Input[str]] = None,
             database_management_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalPluggableDatabaseDatabaseManagementConfigArgs']]]] = None,
             database_version: Optional[pulumi.Input[str]] = None,
             db_id: Optional[pulumi.Input[str]] = None,
             db_packs: Optional[pulumi.Input[str]] = None,
             db_unique_name: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             external_container_database_id: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             ncharacter_set: Optional[pulumi.Input[str]] = None,
             operations_insights_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalPluggableDatabaseOperationsInsightsConfigArgs']]]] = None,
             source_id: Optional[pulumi.Input[str]] = None,
             stack_monitoring_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalPluggableDatabaseStackMonitoringConfigArgs']]]] = None,
             state: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_zone: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'characterSet' in kwargs:
            character_set = kwargs['characterSet']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'databaseConfiguration' in kwargs:
            database_configuration = kwargs['databaseConfiguration']
        if 'databaseEdition' in kwargs:
            database_edition = kwargs['databaseEdition']
        if 'databaseManagementConfigs' in kwargs:
            database_management_configs = kwargs['databaseManagementConfigs']
        if 'databaseVersion' in kwargs:
            database_version = kwargs['databaseVersion']
        if 'dbId' in kwargs:
            db_id = kwargs['dbId']
        if 'dbPacks' in kwargs:
            db_packs = kwargs['dbPacks']
        if 'dbUniqueName' in kwargs:
            db_unique_name = kwargs['dbUniqueName']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'externalContainerDatabaseId' in kwargs:
            external_container_database_id = kwargs['externalContainerDatabaseId']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'ncharacterSet' in kwargs:
            ncharacter_set = kwargs['ncharacterSet']
        if 'operationsInsightsConfigs' in kwargs:
            operations_insights_configs = kwargs['operationsInsightsConfigs']
        if 'sourceId' in kwargs:
            source_id = kwargs['sourceId']
        if 'stackMonitoringConfigs' in kwargs:
            stack_monitoring_configs = kwargs['stackMonitoringConfigs']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeZone' in kwargs:
            time_zone = kwargs['timeZone']

        if character_set is not None:
            _setter("character_set", character_set)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if database_configuration is not None:
            _setter("database_configuration", database_configuration)
        if database_edition is not None:
            _setter("database_edition", database_edition)
        if database_management_configs is not None:
            _setter("database_management_configs", database_management_configs)
        if database_version is not None:
            _setter("database_version", database_version)
        if db_id is not None:
            _setter("db_id", db_id)
        if db_packs is not None:
            _setter("db_packs", db_packs)
        if db_unique_name is not None:
            _setter("db_unique_name", db_unique_name)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if external_container_database_id is not None:
            _setter("external_container_database_id", external_container_database_id)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if ncharacter_set is not None:
            _setter("ncharacter_set", ncharacter_set)
        if operations_insights_configs is not None:
            _setter("operations_insights_configs", operations_insights_configs)
        if source_id is not None:
            _setter("source_id", source_id)
        if stack_monitoring_configs is not None:
            _setter("stack_monitoring_configs", stack_monitoring_configs)
        if state is not None:
            _setter("state", state)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_zone is not None:
            _setter("time_zone", time_zone)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[pulumi.Input[str]]:
        """
        The character set of the external database.
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "character_set", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="databaseConfiguration")
    def database_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Database configuration
        """
        return pulumi.get(self, "database_configuration")

    @database_configuration.setter
    def database_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_configuration", value)

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Database edition.
        """
        return pulumi.get(self, "database_edition")

    @database_edition.setter
    def database_edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_edition", value)

    @property
    @pulumi.getter(name="databaseManagementConfigs")
    def database_management_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalPluggableDatabaseDatabaseManagementConfigArgs']]]]:
        """
        The configuration of the Database Management service.
        """
        return pulumi.get(self, "database_management_configs")

    @database_management_configs.setter
    def database_management_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalPluggableDatabaseDatabaseManagementConfigArgs']]]]):
        pulumi.set(self, "database_management_configs", value)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Database version.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter(name="dbId")
    def db_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Database ID, which identifies an Oracle Database located outside of Oracle Cloud.
        """
        return pulumi.get(self, "db_id")

    @db_id.setter
    def db_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_id", value)

    @property
    @pulumi.getter(name="dbPacks")
    def db_packs(self) -> Optional[pulumi.Input[str]]:
        """
        The database packs licensed for the external Oracle Database.
        """
        return pulumi.get(self, "db_packs")

    @db_packs.setter
    def db_packs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_packs", value)

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> Optional[pulumi.Input[str]]:
        """
        The `DB_UNIQUE_NAME` of the external database.
        """
        return pulumi.get(self, "db_unique_name")

    @db_unique_name.setter
    def db_unique_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_unique_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The user-friendly name for the external database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="externalContainerDatabaseId")
    def external_container_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalContainerDatabaseDetails) that contains the specified [external pluggable database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalPluggableDatabaseDetails) resource.
        """
        return pulumi.get(self, "external_container_database_id")

    @external_container_database_id.setter
    def external_container_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_container_database_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> Optional[pulumi.Input[str]]:
        """
        The national character of the external database.
        """
        return pulumi.get(self, "ncharacter_set")

    @ncharacter_set.setter
    def ncharacter_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ncharacter_set", value)

    @property
    @pulumi.getter(name="operationsInsightsConfigs")
    def operations_insights_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalPluggableDatabaseOperationsInsightsConfigArgs']]]]:
        """
        The configuration of Operations Insights for the external database
        """
        return pulumi.get(self, "operations_insights_configs")

    @operations_insights_configs.setter
    def operations_insights_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalPluggableDatabaseOperationsInsightsConfigArgs']]]]):
        pulumi.set(self, "operations_insights_configs", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the the non-container database that was converted to a pluggable database to create this resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="stackMonitoringConfigs")
    def stack_monitoring_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalPluggableDatabaseStackMonitoringConfigArgs']]]]:
        """
        The configuration of Stack Monitoring for the external database.
        """
        return pulumi.get(self, "stack_monitoring_configs")

    @stack_monitoring_configs.setter
    def stack_monitoring_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalPluggableDatabaseStackMonitoringConfigArgs']]]]):
        pulumi.set(self, "stack_monitoring_configs", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Oracle Cloud Infrastructure external database resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the database was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone of the external database. It is a time zone offset (a character type in the format '[+|-]TZH:TZM') or a time zone region name, depending on how the time zone value was specified when the database was created / last altered.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


class ExternalPluggableDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 external_container_database_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the External Pluggable Database resource in Oracle Cloud Infrastructure Database service.

        Registers a new [ExternalPluggableDatabase](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalPluggableDatabaseDetails)
        resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_pluggable_database = oci.database.ExternalPluggableDatabase("testExternalPluggableDatabase",
            compartment_id=var["compartment_id"],
            display_name=var["external_pluggable_database_display_name"],
            external_container_database_id=oci_database_external_container_database["test_external_container_database"]["id"],
            defined_tags=var["external_pluggable_database_defined_tags"],
            freeform_tags={
                "Department": "Finance",
            },
            source_id=oci_database_source["test_source"]["id"])
        ```

        ## Import

        ExternalPluggableDatabases can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Database/externalPluggableDatabase:ExternalPluggableDatabase test_external_pluggable_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the external database. The name does not have to be unique.
        :param pulumi.Input[str] external_container_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalContainerDatabaseDetails) that contains the specified [external pluggable database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalPluggableDatabaseDetails) resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the the non-container database that was converted to a pluggable database to create this resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalPluggableDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the External Pluggable Database resource in Oracle Cloud Infrastructure Database service.

        Registers a new [ExternalPluggableDatabase](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalPluggableDatabaseDetails)
        resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_pluggable_database = oci.database.ExternalPluggableDatabase("testExternalPluggableDatabase",
            compartment_id=var["compartment_id"],
            display_name=var["external_pluggable_database_display_name"],
            external_container_database_id=oci_database_external_container_database["test_external_container_database"]["id"],
            defined_tags=var["external_pluggable_database_defined_tags"],
            freeform_tags={
                "Department": "Finance",
            },
            source_id=oci_database_source["test_source"]["id"])
        ```

        ## Import

        ExternalPluggableDatabases can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Database/externalPluggableDatabase:ExternalPluggableDatabase test_external_pluggable_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExternalPluggableDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalPluggableDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ExternalPluggableDatabaseArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 external_container_database_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalPluggableDatabaseArgs.__new__(ExternalPluggableDatabaseArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if external_container_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_container_database_id'")
            __props__.__dict__["external_container_database_id"] = external_container_database_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["source_id"] = source_id
            __props__.__dict__["character_set"] = None
            __props__.__dict__["database_configuration"] = None
            __props__.__dict__["database_edition"] = None
            __props__.__dict__["database_management_configs"] = None
            __props__.__dict__["database_version"] = None
            __props__.__dict__["db_id"] = None
            __props__.__dict__["db_packs"] = None
            __props__.__dict__["db_unique_name"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["ncharacter_set"] = None
            __props__.__dict__["operations_insights_configs"] = None
            __props__.__dict__["stack_monitoring_configs"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_zone"] = None
        super(ExternalPluggableDatabase, __self__).__init__(
            'oci:Database/externalPluggableDatabase:ExternalPluggableDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            character_set: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            database_configuration: Optional[pulumi.Input[str]] = None,
            database_edition: Optional[pulumi.Input[str]] = None,
            database_management_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalPluggableDatabaseDatabaseManagementConfigArgs']]]]] = None,
            database_version: Optional[pulumi.Input[str]] = None,
            db_id: Optional[pulumi.Input[str]] = None,
            db_packs: Optional[pulumi.Input[str]] = None,
            db_unique_name: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            external_container_database_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            ncharacter_set: Optional[pulumi.Input[str]] = None,
            operations_insights_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalPluggableDatabaseOperationsInsightsConfigArgs']]]]] = None,
            source_id: Optional[pulumi.Input[str]] = None,
            stack_monitoring_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalPluggableDatabaseStackMonitoringConfigArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_zone: Optional[pulumi.Input[str]] = None) -> 'ExternalPluggableDatabase':
        """
        Get an existing ExternalPluggableDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] character_set: The character set of the external database.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] database_configuration: The Oracle Database configuration
        :param pulumi.Input[str] database_edition: The Oracle Database edition.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalPluggableDatabaseDatabaseManagementConfigArgs']]]] database_management_configs: The configuration of the Database Management service.
        :param pulumi.Input[str] database_version: The Oracle Database version.
        :param pulumi.Input[str] db_id: The Oracle Database ID, which identifies an Oracle Database located outside of Oracle Cloud.
        :param pulumi.Input[str] db_packs: The database packs licensed for the external Oracle Database.
        :param pulumi.Input[str] db_unique_name: The `DB_UNIQUE_NAME` of the external database.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the external database. The name does not have to be unique.
        :param pulumi.Input[str] external_container_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalContainerDatabaseDetails) that contains the specified [external pluggable database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalPluggableDatabaseDetails) resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] ncharacter_set: The national character of the external database.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalPluggableDatabaseOperationsInsightsConfigArgs']]]] operations_insights_configs: The configuration of Operations Insights for the external database
        :param pulumi.Input[str] source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the the non-container database that was converted to a pluggable database to create this resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalPluggableDatabaseStackMonitoringConfigArgs']]]] stack_monitoring_configs: The configuration of Stack Monitoring for the external database.
        :param pulumi.Input[str] state: The current state of the Oracle Cloud Infrastructure external database resource.
        :param pulumi.Input[str] time_created: The date and time the database was created.
        :param pulumi.Input[str] time_zone: The time zone of the external database. It is a time zone offset (a character type in the format '[+|-]TZH:TZM') or a time zone region name, depending on how the time zone value was specified when the database was created / last altered.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalPluggableDatabaseState.__new__(_ExternalPluggableDatabaseState)

        __props__.__dict__["character_set"] = character_set
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["database_configuration"] = database_configuration
        __props__.__dict__["database_edition"] = database_edition
        __props__.__dict__["database_management_configs"] = database_management_configs
        __props__.__dict__["database_version"] = database_version
        __props__.__dict__["db_id"] = db_id
        __props__.__dict__["db_packs"] = db_packs
        __props__.__dict__["db_unique_name"] = db_unique_name
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["external_container_database_id"] = external_container_database_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["ncharacter_set"] = ncharacter_set
        __props__.__dict__["operations_insights_configs"] = operations_insights_configs
        __props__.__dict__["source_id"] = source_id
        __props__.__dict__["stack_monitoring_configs"] = stack_monitoring_configs
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_zone"] = time_zone
        return ExternalPluggableDatabase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Output[str]:
        """
        The character set of the external database.
        """
        return pulumi.get(self, "character_set")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseConfiguration")
    def database_configuration(self) -> pulumi.Output[str]:
        """
        The Oracle Database configuration
        """
        return pulumi.get(self, "database_configuration")

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> pulumi.Output[str]:
        """
        The Oracle Database edition.
        """
        return pulumi.get(self, "database_edition")

    @property
    @pulumi.getter(name="databaseManagementConfigs")
    def database_management_configs(self) -> pulumi.Output[Sequence['outputs.ExternalPluggableDatabaseDatabaseManagementConfig']]:
        """
        The configuration of the Database Management service.
        """
        return pulumi.get(self, "database_management_configs")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> pulumi.Output[str]:
        """
        The Oracle Database version.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="dbId")
    def db_id(self) -> pulumi.Output[str]:
        """
        The Oracle Database ID, which identifies an Oracle Database located outside of Oracle Cloud.
        """
        return pulumi.get(self, "db_id")

    @property
    @pulumi.getter(name="dbPacks")
    def db_packs(self) -> pulumi.Output[str]:
        """
        The database packs licensed for the external Oracle Database.
        """
        return pulumi.get(self, "db_packs")

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> pulumi.Output[str]:
        """
        The `DB_UNIQUE_NAME` of the external database.
        """
        return pulumi.get(self, "db_unique_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The user-friendly name for the external database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalContainerDatabaseId")
    def external_container_database_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalContainerDatabaseDetails) that contains the specified [external pluggable database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalPluggableDatabaseDetails) resource.
        """
        return pulumi.get(self, "external_container_database_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> pulumi.Output[str]:
        """
        The national character of the external database.
        """
        return pulumi.get(self, "ncharacter_set")

    @property
    @pulumi.getter(name="operationsInsightsConfigs")
    def operations_insights_configs(self) -> pulumi.Output[Sequence['outputs.ExternalPluggableDatabaseOperationsInsightsConfig']]:
        """
        The configuration of Operations Insights for the external database
        """
        return pulumi.get(self, "operations_insights_configs")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the the non-container database that was converted to a pluggable database to create this resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter(name="stackMonitoringConfigs")
    def stack_monitoring_configs(self) -> pulumi.Output[Sequence['outputs.ExternalPluggableDatabaseStackMonitoringConfig']]:
        """
        The configuration of Stack Monitoring for the external database.
        """
        return pulumi.get(self, "stack_monitoring_configs")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Oracle Cloud Infrastructure external database resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the database was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        The time zone of the external database. It is a time zone offset (a character type in the format '[+|-]TZH:TZM') or a time zone region name, depending on how the time zone value was specified when the database was created / last altered.
        """
        return pulumi.get(self, "time_zone")

