# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousContainerDatabaseVersionsResult',
    'AwaitableGetAutonomousContainerDatabaseVersionsResult',
    'get_autonomous_container_database_versions',
    'get_autonomous_container_database_versions_output',
]

@pulumi.output_type
class GetAutonomousContainerDatabaseVersionsResult:
    """
    A collection of values returned by getAutonomousContainerDatabaseVersions.
    """
    def __init__(__self__, autonomous_container_database_versions=None, compartment_id=None, filters=None, id=None, service_component=None):
        if autonomous_container_database_versions and not isinstance(autonomous_container_database_versions, list):
            raise TypeError("Expected argument 'autonomous_container_database_versions' to be a list")
        pulumi.set(__self__, "autonomous_container_database_versions", autonomous_container_database_versions)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_component and not isinstance(service_component, str):
            raise TypeError("Expected argument 'service_component' to be a str")
        pulumi.set(__self__, "service_component", service_component)

    @property
    @pulumi.getter(name="autonomousContainerDatabaseVersions")
    def autonomous_container_database_versions(self) -> Sequence['outputs.GetAutonomousContainerDatabaseVersionsAutonomousContainerDatabaseVersionResult']:
        """
        The list of autonomous_container_database_versions.
        """
        return pulumi.get(self, "autonomous_container_database_versions")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousContainerDatabaseVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceComponent")
    def service_component(self) -> str:
        return pulumi.get(self, "service_component")


class AwaitableGetAutonomousContainerDatabaseVersionsResult(GetAutonomousContainerDatabaseVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousContainerDatabaseVersionsResult(
            autonomous_container_database_versions=self.autonomous_container_database_versions,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            service_component=self.service_component)


def get_autonomous_container_database_versions(compartment_id: Optional[str] = None,
                                               filters: Optional[Sequence[pulumi.InputType['GetAutonomousContainerDatabaseVersionsFilterArgs']]] = None,
                                               service_component: Optional[str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousContainerDatabaseVersionsResult:
    """
    This data source provides the list of Autonomous Container Database Versions in Oracle Cloud Infrastructure Database service.

    Gets a list of supported Autonomous Container Database versions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_container_database_versions = oci.Database.get_autonomous_container_database_versions(compartment_id=var["compartment_id"],
        service_component=var["autonomous_container_database_version_service_component"])
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str service_component: The service component to use, either ADBD or EXACC.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['serviceComponent'] = service_component
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousContainerDatabaseVersions:getAutonomousContainerDatabaseVersions', __args__, opts=opts, typ=GetAutonomousContainerDatabaseVersionsResult).value

    return AwaitableGetAutonomousContainerDatabaseVersionsResult(
        autonomous_container_database_versions=pulumi.get(__ret__, 'autonomous_container_database_versions'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        service_component=pulumi.get(__ret__, 'service_component'))


@_utilities.lift_output_func(get_autonomous_container_database_versions)
def get_autonomous_container_database_versions_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                                      filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetAutonomousContainerDatabaseVersionsFilterArgs']]]]] = None,
                                                      service_component: Optional[pulumi.Input[str]] = None,
                                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutonomousContainerDatabaseVersionsResult]:
    """
    This data source provides the list of Autonomous Container Database Versions in Oracle Cloud Infrastructure Database service.

    Gets a list of supported Autonomous Container Database versions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_container_database_versions = oci.Database.get_autonomous_container_database_versions(compartment_id=var["compartment_id"],
        service_component=var["autonomous_container_database_version_service_component"])
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str service_component: The service component to use, either ADBD or EXACC.
    """
    ...
