# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAutonomousDatabaseInstanceWalletManagementResult',
    'AwaitableGetAutonomousDatabaseInstanceWalletManagementResult',
    'get_autonomous_database_instance_wallet_management',
    'get_autonomous_database_instance_wallet_management_output',
]

@pulumi.output_type
class GetAutonomousDatabaseInstanceWalletManagementResult:
    """
    A collection of values returned by getAutonomousDatabaseInstanceWalletManagement.
    """
    def __init__(__self__, autonomous_database_id=None, grace_period=None, id=None, should_rotate=None, state=None, time_rotated=None):
        if autonomous_database_id and not isinstance(autonomous_database_id, str):
            raise TypeError("Expected argument 'autonomous_database_id' to be a str")
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if grace_period and not isinstance(grace_period, int):
            raise TypeError("Expected argument 'grace_period' to be a int")
        pulumi.set(__self__, "grace_period", grace_period)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if should_rotate and not isinstance(should_rotate, bool):
            raise TypeError("Expected argument 'should_rotate' to be a bool")
        pulumi.set(__self__, "should_rotate", should_rotate)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_rotated and not isinstance(time_rotated, str):
            raise TypeError("Expected argument 'time_rotated' to be a str")
        pulumi.set(__self__, "time_rotated", time_rotated)

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> str:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_database_id")

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> int:
        return pulumi.get(self, "grace_period")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="shouldRotate")
    def should_rotate(self) -> bool:
        """
        Indicates whether to rotate the wallet or not. If `false`, the wallet will not be rotated. The default is `false`.
        """
        return pulumi.get(self, "should_rotate")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the Autonomous Database wallet.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeRotated")
    def time_rotated(self) -> str:
        """
        The date and time the wallet was last rotated.
        """
        return pulumi.get(self, "time_rotated")


class AwaitableGetAutonomousDatabaseInstanceWalletManagementResult(GetAutonomousDatabaseInstanceWalletManagementResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabaseInstanceWalletManagementResult(
            autonomous_database_id=self.autonomous_database_id,
            grace_period=self.grace_period,
            id=self.id,
            should_rotate=self.should_rotate,
            state=self.state,
            time_rotated=self.time_rotated)


def get_autonomous_database_instance_wallet_management(autonomous_database_id: Optional[str] = None,
                                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabaseInstanceWalletManagementResult:
    """
    This data source provides details about a specific Autonomous Database Instance Wallet Management resource in Oracle Cloud Infrastructure Database service.

    Gets the wallet details for the specified Autonomous Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_instance_wallet_management = oci.Database.get_autonomous_database_instance_wallet_management(autonomous_database_id=oci_database_autonomous_database["test_autonomous_database"]["id"])
    ```


    :param str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDatabaseInstanceWalletManagement:getAutonomousDatabaseInstanceWalletManagement', __args__, opts=opts, typ=GetAutonomousDatabaseInstanceWalletManagementResult).value

    return AwaitableGetAutonomousDatabaseInstanceWalletManagementResult(
        autonomous_database_id=pulumi.get(__ret__, 'autonomous_database_id'),
        grace_period=pulumi.get(__ret__, 'grace_period'),
        id=pulumi.get(__ret__, 'id'),
        should_rotate=pulumi.get(__ret__, 'should_rotate'),
        state=pulumi.get(__ret__, 'state'),
        time_rotated=pulumi.get(__ret__, 'time_rotated'))


@_utilities.lift_output_func(get_autonomous_database_instance_wallet_management)
def get_autonomous_database_instance_wallet_management_output(autonomous_database_id: Optional[pulumi.Input[str]] = None,
                                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutonomousDatabaseInstanceWalletManagementResult]:
    """
    This data source provides details about a specific Autonomous Database Instance Wallet Management resource in Oracle Cloud Infrastructure Database service.

    Gets the wallet details for the specified Autonomous Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_instance_wallet_management = oci.Database.get_autonomous_database_instance_wallet_management(autonomous_database_id=oci_database_autonomous_database["test_autonomous_database"]["id"])
    ```


    :param str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
