# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbServerResult',
    'AwaitableGetDbServerResult',
    'get_db_server',
    'get_db_server_output',
]

@pulumi.output_type
class GetDbServerResult:
    """
    A collection of values returned by getDbServer.
    """
    def __init__(__self__, autonomous_virtual_machine_ids=None, autonomous_vm_cluster_ids=None, compartment_id=None, cpu_core_count=None, db_node_ids=None, db_node_storage_size_in_gbs=None, db_server_id=None, db_server_patching_details=None, defined_tags=None, display_name=None, exadata_infrastructure_id=None, freeform_tags=None, id=None, lifecycle_details=None, max_cpu_count=None, max_db_node_storage_in_gbs=None, max_memory_in_gbs=None, memory_size_in_gbs=None, shape=None, state=None, time_created=None, vm_cluster_ids=None):
        if autonomous_virtual_machine_ids and not isinstance(autonomous_virtual_machine_ids, list):
            raise TypeError("Expected argument 'autonomous_virtual_machine_ids' to be a list")
        pulumi.set(__self__, "autonomous_virtual_machine_ids", autonomous_virtual_machine_ids)
        if autonomous_vm_cluster_ids and not isinstance(autonomous_vm_cluster_ids, list):
            raise TypeError("Expected argument 'autonomous_vm_cluster_ids' to be a list")
        pulumi.set(__self__, "autonomous_vm_cluster_ids", autonomous_vm_cluster_ids)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if cpu_core_count and not isinstance(cpu_core_count, int):
            raise TypeError("Expected argument 'cpu_core_count' to be a int")
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if db_node_ids and not isinstance(db_node_ids, list):
            raise TypeError("Expected argument 'db_node_ids' to be a list")
        pulumi.set(__self__, "db_node_ids", db_node_ids)
        if db_node_storage_size_in_gbs and not isinstance(db_node_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'db_node_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_server_id and not isinstance(db_server_id, str):
            raise TypeError("Expected argument 'db_server_id' to be a str")
        pulumi.set(__self__, "db_server_id", db_server_id)
        if db_server_patching_details and not isinstance(db_server_patching_details, list):
            raise TypeError("Expected argument 'db_server_patching_details' to be a list")
        pulumi.set(__self__, "db_server_patching_details", db_server_patching_details)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if exadata_infrastructure_id and not isinstance(exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if max_cpu_count and not isinstance(max_cpu_count, int):
            raise TypeError("Expected argument 'max_cpu_count' to be a int")
        pulumi.set(__self__, "max_cpu_count", max_cpu_count)
        if max_db_node_storage_in_gbs and not isinstance(max_db_node_storage_in_gbs, int):
            raise TypeError("Expected argument 'max_db_node_storage_in_gbs' to be a int")
        pulumi.set(__self__, "max_db_node_storage_in_gbs", max_db_node_storage_in_gbs)
        if max_memory_in_gbs and not isinstance(max_memory_in_gbs, int):
            raise TypeError("Expected argument 'max_memory_in_gbs' to be a int")
        pulumi.set(__self__, "max_memory_in_gbs", max_memory_in_gbs)
        if memory_size_in_gbs and not isinstance(memory_size_in_gbs, int):
            raise TypeError("Expected argument 'memory_size_in_gbs' to be a int")
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if vm_cluster_ids and not isinstance(vm_cluster_ids, list):
            raise TypeError("Expected argument 'vm_cluster_ids' to be a list")
        pulumi.set(__self__, "vm_cluster_ids", vm_cluster_ids)

    @property
    @pulumi.getter(name="autonomousVirtualMachineIds")
    def autonomous_virtual_machine_ids(self) -> Sequence[str]:
        """
        The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Virtual Machines associated with the Db server.
        """
        return pulumi.get(self, "autonomous_virtual_machine_ids")

    @property
    @pulumi.getter(name="autonomousVmClusterIds")
    def autonomous_vm_cluster_ids(self) -> Sequence[str]:
        """
        The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous VM Clusters associated with the Db server.
        """
        return pulumi.get(self, "autonomous_vm_cluster_ids")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> int:
        """
        The number of CPU cores enabled on the Db server.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="dbNodeIds")
    def db_node_ids(self) -> Sequence[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Db nodes associated with the Db server.
        """
        return pulumi.get(self, "db_node_ids")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> int:
        """
        The allocated local node storage in GBs on the Db server.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="dbServerId")
    def db_server_id(self) -> str:
        return pulumi.get(self, "db_server_id")

    @property
    @pulumi.getter(name="dbServerPatchingDetails")
    def db_server_patching_details(self) -> Sequence['outputs.GetDbServerDbServerPatchingDetailResult']:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "db_server_patching_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the Db server. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> int:
        """
        The total number of CPU cores available.
        """
        return pulumi.get(self, "max_cpu_count")

    @property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> int:
        """
        The total local node storage available in GBs.
        """
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> int:
        """
        The total memory available in GBs.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> int:
        """
        The allocated memory in GBs on the Db server.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        The shape of the Db server. The shape determines the amount of CPU, storage, and memory resources available.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Db server.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time that the Db Server was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vmClusterIds")
    def vm_cluster_ids(self) -> Sequence[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM Clusters associated with the Db server.
        """
        return pulumi.get(self, "vm_cluster_ids")


class AwaitableGetDbServerResult(GetDbServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbServerResult(
            autonomous_virtual_machine_ids=self.autonomous_virtual_machine_ids,
            autonomous_vm_cluster_ids=self.autonomous_vm_cluster_ids,
            compartment_id=self.compartment_id,
            cpu_core_count=self.cpu_core_count,
            db_node_ids=self.db_node_ids,
            db_node_storage_size_in_gbs=self.db_node_storage_size_in_gbs,
            db_server_id=self.db_server_id,
            db_server_patching_details=self.db_server_patching_details,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            exadata_infrastructure_id=self.exadata_infrastructure_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            max_cpu_count=self.max_cpu_count,
            max_db_node_storage_in_gbs=self.max_db_node_storage_in_gbs,
            max_memory_in_gbs=self.max_memory_in_gbs,
            memory_size_in_gbs=self.memory_size_in_gbs,
            shape=self.shape,
            state=self.state,
            time_created=self.time_created,
            vm_cluster_ids=self.vm_cluster_ids)


def get_db_server(db_server_id: Optional[str] = None,
                  exadata_infrastructure_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbServerResult:
    """
    This data source provides details about a specific Db Server resource in Oracle Cloud Infrastructure Database service.

    Gets information about the Exadata Db server.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_server = oci.Database.get_db_server(db_server_id=oci_database_db_server["test_db_server"]["id"],
        exadata_infrastructure_id=oci_database_exadata_infrastructure["test_exadata_infrastructure"]["id"])
    ```


    :param str db_server_id: The DB server [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ExadataInfrastructure.
    """
    __args__ = dict()
    __args__['dbServerId'] = db_server_id
    __args__['exadataInfrastructureId'] = exadata_infrastructure_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbServer:getDbServer', __args__, opts=opts, typ=GetDbServerResult).value

    return AwaitableGetDbServerResult(
        autonomous_virtual_machine_ids=pulumi.get(__ret__, 'autonomous_virtual_machine_ids'),
        autonomous_vm_cluster_ids=pulumi.get(__ret__, 'autonomous_vm_cluster_ids'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        cpu_core_count=pulumi.get(__ret__, 'cpu_core_count'),
        db_node_ids=pulumi.get(__ret__, 'db_node_ids'),
        db_node_storage_size_in_gbs=pulumi.get(__ret__, 'db_node_storage_size_in_gbs'),
        db_server_id=pulumi.get(__ret__, 'db_server_id'),
        db_server_patching_details=pulumi.get(__ret__, 'db_server_patching_details'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__ret__, 'exadata_infrastructure_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        max_cpu_count=pulumi.get(__ret__, 'max_cpu_count'),
        max_db_node_storage_in_gbs=pulumi.get(__ret__, 'max_db_node_storage_in_gbs'),
        max_memory_in_gbs=pulumi.get(__ret__, 'max_memory_in_gbs'),
        memory_size_in_gbs=pulumi.get(__ret__, 'memory_size_in_gbs'),
        shape=pulumi.get(__ret__, 'shape'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        vm_cluster_ids=pulumi.get(__ret__, 'vm_cluster_ids'))


@_utilities.lift_output_func(get_db_server)
def get_db_server_output(db_server_id: Optional[pulumi.Input[str]] = None,
                         exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbServerResult]:
    """
    This data source provides details about a specific Db Server resource in Oracle Cloud Infrastructure Database service.

    Gets information about the Exadata Db server.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_server = oci.Database.get_db_server(db_server_id=oci_database_db_server["test_db_server"]["id"],
        exadata_infrastructure_id=oci_database_exadata_infrastructure["test_exadata_infrastructure"]["id"])
    ```


    :param str db_server_id: The DB server [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ExadataInfrastructure.
    """
    ...
