# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDbManagementPrivateEndpointResult',
    'AwaitableGetDbManagementPrivateEndpointResult',
    'get_db_management_private_endpoint',
    'get_db_management_private_endpoint_output',
]

@pulumi.output_type
class GetDbManagementPrivateEndpointResult:
    """
    A collection of values returned by getDbManagementPrivateEndpoint.
    """
    def __init__(__self__, compartment_id=None, db_management_private_endpoint_id=None, description=None, id=None, is_cluster=None, name=None, nsg_ids=None, private_ip=None, state=None, subnet_id=None, time_created=None, vcn_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_management_private_endpoint_id and not isinstance(db_management_private_endpoint_id, str):
            raise TypeError("Expected argument 'db_management_private_endpoint_id' to be a str")
        pulumi.set(__self__, "db_management_private_endpoint_id", db_management_private_endpoint_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_cluster and not isinstance(is_cluster, bool):
            raise TypeError("Expected argument 'is_cluster' to be a bool")
        pulumi.set(__self__, "is_cluster", is_cluster)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbManagementPrivateEndpointId")
    def db_management_private_endpoint_id(self) -> str:
        return pulumi.get(self, "db_management_private_endpoint_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Database Management private endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> bool:
        """
        Specifies whether the Database Management private endpoint can be used for Oracle Databases in a cluster.
        """
        return pulumi.get(self, "is_cluster")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The display name of the Database Management private endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        The OCIDs of the Network Security Groups to which the Database Management private endpoint belongs.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The IP addresses assigned to the Database Management private endpoint.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the Database Management private endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the Database Managament private endpoint was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
        """
        return pulumi.get(self, "vcn_id")


class AwaitableGetDbManagementPrivateEndpointResult(GetDbManagementPrivateEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbManagementPrivateEndpointResult(
            compartment_id=self.compartment_id,
            db_management_private_endpoint_id=self.db_management_private_endpoint_id,
            description=self.description,
            id=self.id,
            is_cluster=self.is_cluster,
            name=self.name,
            nsg_ids=self.nsg_ids,
            private_ip=self.private_ip,
            state=self.state,
            subnet_id=self.subnet_id,
            time_created=self.time_created,
            vcn_id=self.vcn_id)


def get_db_management_private_endpoint(db_management_private_endpoint_id: Optional[str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbManagementPrivateEndpointResult:
    """
    This data source provides details about a specific Db Management Private Endpoint resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details of a specific Database Management private endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_management_private_endpoint = oci.DatabaseManagement.get_db_management_private_endpoint(db_management_private_endpoint_id=oci_database_management_db_management_private_endpoint["test_db_management_private_endpoint"]["id"])
    ```


    :param str db_management_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint.
    """
    __args__ = dict()
    __args__['dbManagementPrivateEndpointId'] = db_management_private_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getDbManagementPrivateEndpoint:getDbManagementPrivateEndpoint', __args__, opts=opts, typ=GetDbManagementPrivateEndpointResult).value

    return AwaitableGetDbManagementPrivateEndpointResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_management_private_endpoint_id=pulumi.get(__ret__, 'db_management_private_endpoint_id'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        is_cluster=pulumi.get(__ret__, 'is_cluster'),
        name=pulumi.get(__ret__, 'name'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        private_ip=pulumi.get(__ret__, 'private_ip'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))


@_utilities.lift_output_func(get_db_management_private_endpoint)
def get_db_management_private_endpoint_output(db_management_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbManagementPrivateEndpointResult]:
    """
    This data source provides details about a specific Db Management Private Endpoint resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details of a specific Database Management private endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_management_private_endpoint = oci.DatabaseManagement.get_db_management_private_endpoint(db_management_private_endpoint_id=oci_database_management_db_management_private_endpoint["test_db_management_private_endpoint"]["id"])
    ```


    :param str db_management_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint.
    """
    ...
