# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetJobExecutionsStatusesResult',
    'AwaitableGetJobExecutionsStatusesResult',
    'get_job_executions_statuses',
    'get_job_executions_statuses_output',
]

@pulumi.output_type
class GetJobExecutionsStatusesResult:
    """
    A collection of values returned by getJobExecutionsStatuses.
    """
    def __init__(__self__, compartment_id=None, end_time=None, filters=None, id=None, job_executions_status_summary_collections=None, managed_database_group_id=None, managed_database_id=None, name=None, start_time=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if job_executions_status_summary_collections and not isinstance(job_executions_status_summary_collections, list):
            raise TypeError("Expected argument 'job_executions_status_summary_collections' to be a list")
        pulumi.set(__self__, "job_executions_status_summary_collections", job_executions_status_summary_collections)
        if managed_database_group_id and not isinstance(managed_database_group_id, str):
            raise TypeError("Expected argument 'managed_database_group_id' to be a str")
        pulumi.set(__self__, "managed_database_group_id", managed_database_group_id)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetJobExecutionsStatusesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jobExecutionsStatusSummaryCollections")
    def job_executions_status_summary_collections(self) -> Sequence['outputs.GetJobExecutionsStatusesJobExecutionsStatusSummaryCollectionResult']:
        """
        The list of job_executions_status_summary_collection.
        """
        return pulumi.get(self, "job_executions_status_summary_collections")

    @property
    @pulumi.getter(name="managedDatabaseGroupId")
    def managed_database_group_id(self) -> Optional[str]:
        return pulumi.get(self, "managed_database_group_id")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> Optional[str]:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        return pulumi.get(self, "start_time")


class AwaitableGetJobExecutionsStatusesResult(GetJobExecutionsStatusesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobExecutionsStatusesResult(
            compartment_id=self.compartment_id,
            end_time=self.end_time,
            filters=self.filters,
            id=self.id,
            job_executions_status_summary_collections=self.job_executions_status_summary_collections,
            managed_database_group_id=self.managed_database_group_id,
            managed_database_id=self.managed_database_id,
            name=self.name,
            start_time=self.start_time)


def get_job_executions_statuses(compartment_id: Optional[str] = None,
                                end_time: Optional[str] = None,
                                filters: Optional[Sequence[pulumi.InputType['GetJobExecutionsStatusesFilterArgs']]] = None,
                                id: Optional[str] = None,
                                managed_database_group_id: Optional[str] = None,
                                managed_database_id: Optional[str] = None,
                                name: Optional[str] = None,
                                start_time: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobExecutionsStatusesResult:
    """
    This data source provides the list of Job Executions Statuses in Oracle Cloud Infrastructure Database Management service.

    Gets the number of job executions grouped by status for a job, Managed Database, or Database Group in a specific compartment. Only one of the parameters, jobId, managedDatabaseId, or managedDatabaseGroupId should be provided.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_job_executions_statuses = oci.DatabaseManagement.get_job_executions_statuses(compartment_id=var["compartment_id"],
        end_time=var["job_executions_status_end_time"],
        start_time=var["job_executions_status_start_time"],
        id=var["job_executions_status_id"],
        managed_database_group_id=oci_database_management_managed_database_group["test_managed_database_group"]["id"],
        managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        name=var["job_executions_status_name"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str end_time: The end time of the time range to retrieve the status summary of job executions in UTC in ISO-8601 format, which is "yyyy-MM-dd'T'hh:mm:ss.sss'Z'".
    :param str id: The identifier of the resource.
    :param str managed_database_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database Group.
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: A filter to return only resources that match the entire name.
    :param str start_time: The start time of the time range to retrieve the status summary of job executions in UTC in ISO-8601 format, which is "yyyy-MM-dd'T'hh:mm:ss.sss'Z'".
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['endTime'] = end_time
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['managedDatabaseGroupId'] = managed_database_group_id
    __args__['managedDatabaseId'] = managed_database_id
    __args__['name'] = name
    __args__['startTime'] = start_time
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getJobExecutionsStatuses:getJobExecutionsStatuses', __args__, opts=opts, typ=GetJobExecutionsStatusesResult).value

    return AwaitableGetJobExecutionsStatusesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        end_time=pulumi.get(__ret__, 'end_time'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        job_executions_status_summary_collections=pulumi.get(__ret__, 'job_executions_status_summary_collections'),
        managed_database_group_id=pulumi.get(__ret__, 'managed_database_group_id'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        name=pulumi.get(__ret__, 'name'),
        start_time=pulumi.get(__ret__, 'start_time'))


@_utilities.lift_output_func(get_job_executions_statuses)
def get_job_executions_statuses_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                       end_time: Optional[pulumi.Input[str]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetJobExecutionsStatusesFilterArgs']]]]] = None,
                                       id: Optional[pulumi.Input[Optional[str]]] = None,
                                       managed_database_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       managed_database_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       name: Optional[pulumi.Input[Optional[str]]] = None,
                                       start_time: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetJobExecutionsStatusesResult]:
    """
    This data source provides the list of Job Executions Statuses in Oracle Cloud Infrastructure Database Management service.

    Gets the number of job executions grouped by status for a job, Managed Database, or Database Group in a specific compartment. Only one of the parameters, jobId, managedDatabaseId, or managedDatabaseGroupId should be provided.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_job_executions_statuses = oci.DatabaseManagement.get_job_executions_statuses(compartment_id=var["compartment_id"],
        end_time=var["job_executions_status_end_time"],
        start_time=var["job_executions_status_start_time"],
        id=var["job_executions_status_id"],
        managed_database_group_id=oci_database_management_managed_database_group["test_managed_database_group"]["id"],
        managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        name=var["job_executions_status_name"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str end_time: The end time of the time range to retrieve the status summary of job executions in UTC in ISO-8601 format, which is "yyyy-MM-dd'T'hh:mm:ss.sss'Z'".
    :param str id: The identifier of the resource.
    :param str managed_database_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database Group.
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: A filter to return only resources that match the entire name.
    :param str start_time: The start time of the time range to retrieve the status summary of job executions in UTC in ISO-8601 format, which is "yyyy-MM-dd'T'hh:mm:ss.sss'Z'".
    """
    ...
