# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedDatabaseCursorCacheStatementsResult',
    'AwaitableGetManagedDatabaseCursorCacheStatementsResult',
    'get_managed_database_cursor_cache_statements',
    'get_managed_database_cursor_cache_statements_output',
]

@pulumi.output_type
class GetManagedDatabaseCursorCacheStatementsResult:
    """
    A collection of values returned by getManagedDatabaseCursorCacheStatements.
    """
    def __init__(__self__, cursor_cache_statement_collections=None, filters=None, id=None, limit=None, managed_database_id=None, sql_text=None):
        if cursor_cache_statement_collections and not isinstance(cursor_cache_statement_collections, list):
            raise TypeError("Expected argument 'cursor_cache_statement_collections' to be a list")
        pulumi.set(__self__, "cursor_cache_statement_collections", cursor_cache_statement_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if sql_text and not isinstance(sql_text, str):
            raise TypeError("Expected argument 'sql_text' to be a str")
        pulumi.set(__self__, "sql_text", sql_text)

    @property
    @pulumi.getter(name="cursorCacheStatementCollections")
    def cursor_cache_statement_collections(self) -> Sequence['outputs.GetManagedDatabaseCursorCacheStatementsCursorCacheStatementCollectionResult']:
        """
        The list of cursor_cache_statement_collection.
        """
        return pulumi.get(self, "cursor_cache_statement_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedDatabaseCursorCacheStatementsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def limit(self) -> Optional[int]:
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter(name="sqlText")
    def sql_text(self) -> Optional[str]:
        """
        The first thousand characters of the SQL text.
        """
        return pulumi.get(self, "sql_text")


class AwaitableGetManagedDatabaseCursorCacheStatementsResult(GetManagedDatabaseCursorCacheStatementsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseCursorCacheStatementsResult(
            cursor_cache_statement_collections=self.cursor_cache_statement_collections,
            filters=self.filters,
            id=self.id,
            limit=self.limit,
            managed_database_id=self.managed_database_id,
            sql_text=self.sql_text)


def get_managed_database_cursor_cache_statements(filters: Optional[Sequence[pulumi.InputType['GetManagedDatabaseCursorCacheStatementsFilterArgs']]] = None,
                                                 limit: Optional[int] = None,
                                                 managed_database_id: Optional[str] = None,
                                                 sql_text: Optional[str] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseCursorCacheStatementsResult:
    """
    This data source provides the list of Managed Database Cursor Cache Statements in Oracle Cloud Infrastructure Database Management service.

    Lists the SQL statements from shared SQL area, also called the cursor cache.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_cursor_cache_statements = oci.DatabaseManagement.get_managed_database_cursor_cache_statements(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        sql_text=var["managed_database_cursor_cache_statement_sql_text"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str sql_text: A filter to return all the SQL plan baselines that match the SQL text. By default, the search is case insensitive. To run an exact or case-sensitive search, double-quote the search string. You may also use the '%' symbol as a wildcard.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['limit'] = limit
    __args__['managedDatabaseId'] = managed_database_id
    __args__['sqlText'] = sql_text
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseCursorCacheStatements:getManagedDatabaseCursorCacheStatements', __args__, opts=opts, typ=GetManagedDatabaseCursorCacheStatementsResult).value

    return AwaitableGetManagedDatabaseCursorCacheStatementsResult(
        cursor_cache_statement_collections=pulumi.get(__ret__, 'cursor_cache_statement_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        sql_text=pulumi.get(__ret__, 'sql_text'))


@_utilities.lift_output_func(get_managed_database_cursor_cache_statements)
def get_managed_database_cursor_cache_statements_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagedDatabaseCursorCacheStatementsFilterArgs']]]]] = None,
                                                        limit: Optional[pulumi.Input[Optional[int]]] = None,
                                                        managed_database_id: Optional[pulumi.Input[str]] = None,
                                                        sql_text: Optional[pulumi.Input[Optional[str]]] = None,
                                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseCursorCacheStatementsResult]:
    """
    This data source provides the list of Managed Database Cursor Cache Statements in Oracle Cloud Infrastructure Database Management service.

    Lists the SQL statements from shared SQL area, also called the cursor cache.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_cursor_cache_statements = oci.DatabaseManagement.get_managed_database_cursor_cache_statements(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        sql_text=var["managed_database_cursor_cache_statement_sql_text"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str sql_text: A filter to return all the SQL plan baselines that match the SQL text. By default, the search is case insensitive. To run an exact or case-sensitive search, double-quote the search string. You may also use the '%' symbol as a wildcard.
    """
    ...
