# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetManagedDatabaseOptimizerStatisticsAdvisorExecutionScriptResult',
    'AwaitableGetManagedDatabaseOptimizerStatisticsAdvisorExecutionScriptResult',
    'get_managed_database_optimizer_statistics_advisor_execution_script',
    'get_managed_database_optimizer_statistics_advisor_execution_script_output',
]

@pulumi.output_type
class GetManagedDatabaseOptimizerStatisticsAdvisorExecutionScriptResult:
    """
    A collection of values returned by getManagedDatabaseOptimizerStatisticsAdvisorExecutionScript.
    """
    def __init__(__self__, execution_name=None, id=None, managed_database_id=None, script=None, task_name=None):
        if execution_name and not isinstance(execution_name, str):
            raise TypeError("Expected argument 'execution_name' to be a str")
        pulumi.set(__self__, "execution_name", execution_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if script and not isinstance(script, str):
            raise TypeError("Expected argument 'script' to be a str")
        pulumi.set(__self__, "script", script)
        if task_name and not isinstance(task_name, str):
            raise TypeError("Expected argument 'task_name' to be a str")
        pulumi.set(__self__, "task_name", task_name)

    @property
    @pulumi.getter(name="executionName")
    def execution_name(self) -> str:
        return pulumi.get(self, "execution_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter
    def script(self) -> str:
        """
        The Optimizer Statistics Advisor execution script.
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter(name="taskName")
    def task_name(self) -> str:
        return pulumi.get(self, "task_name")


class AwaitableGetManagedDatabaseOptimizerStatisticsAdvisorExecutionScriptResult(GetManagedDatabaseOptimizerStatisticsAdvisorExecutionScriptResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseOptimizerStatisticsAdvisorExecutionScriptResult(
            execution_name=self.execution_name,
            id=self.id,
            managed_database_id=self.managed_database_id,
            script=self.script,
            task_name=self.task_name)


def get_managed_database_optimizer_statistics_advisor_execution_script(execution_name: Optional[str] = None,
                                                                       managed_database_id: Optional[str] = None,
                                                                       task_name: Optional[str] = None,
                                                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseOptimizerStatisticsAdvisorExecutionScriptResult:
    """
    This data source provides details about a specific Managed Database Optimizer Statistics Advisor Execution Script resource in Oracle Cloud Infrastructure Database Management service.

    Gets the Oracle system-generated script for the specified Optimizer Statistics Advisor execution.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_optimizer_statistics_advisor_execution_script = oci.DatabaseManagement.get_managed_database_optimizer_statistics_advisor_execution_script(execution_name=var["managed_database_optimizer_statistics_advisor_execution_script_execution_name"],
        managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        task_name=var["managed_database_optimizer_statistics_advisor_execution_script_task_name"])
    ```


    :param str execution_name: The name of the Optimizer Statistics Advisor execution.
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str task_name: The name of the optimizer statistics collection execution task.
    """
    __args__ = dict()
    __args__['executionName'] = execution_name
    __args__['managedDatabaseId'] = managed_database_id
    __args__['taskName'] = task_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseOptimizerStatisticsAdvisorExecutionScript:getManagedDatabaseOptimizerStatisticsAdvisorExecutionScript', __args__, opts=opts, typ=GetManagedDatabaseOptimizerStatisticsAdvisorExecutionScriptResult).value

    return AwaitableGetManagedDatabaseOptimizerStatisticsAdvisorExecutionScriptResult(
        execution_name=pulumi.get(__ret__, 'execution_name'),
        id=pulumi.get(__ret__, 'id'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        script=pulumi.get(__ret__, 'script'),
        task_name=pulumi.get(__ret__, 'task_name'))


@_utilities.lift_output_func(get_managed_database_optimizer_statistics_advisor_execution_script)
def get_managed_database_optimizer_statistics_advisor_execution_script_output(execution_name: Optional[pulumi.Input[str]] = None,
                                                                              managed_database_id: Optional[pulumi.Input[str]] = None,
                                                                              task_name: Optional[pulumi.Input[str]] = None,
                                                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseOptimizerStatisticsAdvisorExecutionScriptResult]:
    """
    This data source provides details about a specific Managed Database Optimizer Statistics Advisor Execution Script resource in Oracle Cloud Infrastructure Database Management service.

    Gets the Oracle system-generated script for the specified Optimizer Statistics Advisor execution.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_optimizer_statistics_advisor_execution_script = oci.DatabaseManagement.get_managed_database_optimizer_statistics_advisor_execution_script(execution_name=var["managed_database_optimizer_statistics_advisor_execution_script_execution_name"],
        managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        task_name=var["managed_database_optimizer_statistics_advisor_execution_script_task_name"])
    ```


    :param str execution_name: The name of the Optimizer Statistics Advisor execution.
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str task_name: The name of the optimizer statistics collection execution task.
    """
    ...
