# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedDatabaseUserObjectPrivilegesResult',
    'AwaitableGetManagedDatabaseUserObjectPrivilegesResult',
    'get_managed_database_user_object_privileges',
    'get_managed_database_user_object_privileges_output',
]

@pulumi.output_type
class GetManagedDatabaseUserObjectPrivilegesResult:
    """
    A collection of values returned by getManagedDatabaseUserObjectPrivileges.
    """
    def __init__(__self__, filters=None, id=None, managed_database_id=None, name=None, object_privilege_collections=None, user_name=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if object_privilege_collections and not isinstance(object_privilege_collections, list):
            raise TypeError("Expected argument 'object_privilege_collections' to be a list")
        pulumi.set(__self__, "object_privilege_collections", object_privilege_collections)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedDatabaseUserObjectPrivilegesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the privilege on the object.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectPrivilegeCollections")
    def object_privilege_collections(self) -> Sequence['outputs.GetManagedDatabaseUserObjectPrivilegesObjectPrivilegeCollectionResult']:
        """
        The list of object_privilege_collection.
        """
        return pulumi.get(self, "object_privilege_collections")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        return pulumi.get(self, "user_name")


class AwaitableGetManagedDatabaseUserObjectPrivilegesResult(GetManagedDatabaseUserObjectPrivilegesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseUserObjectPrivilegesResult(
            filters=self.filters,
            id=self.id,
            managed_database_id=self.managed_database_id,
            name=self.name,
            object_privilege_collections=self.object_privilege_collections,
            user_name=self.user_name)


def get_managed_database_user_object_privileges(filters: Optional[Sequence[pulumi.InputType['GetManagedDatabaseUserObjectPrivilegesFilterArgs']]] = None,
                                                managed_database_id: Optional[str] = None,
                                                name: Optional[str] = None,
                                                user_name: Optional[str] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseUserObjectPrivilegesResult:
    """
    This data source provides the list of Managed Database User Object Privileges in Oracle Cloud Infrastructure Database Management service.

    Gets the list of object privileges granted to a specific user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_user_object_privileges = oci.DatabaseManagement.get_managed_database_user_object_privileges(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        user_name=oci_identity_user["test_user"]["name"],
        name=var["managed_database_user_object_privilege_name"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: A filter to return only resources that match the entire name.
    :param str user_name: The name of the user whose details are to be viewed.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['managedDatabaseId'] = managed_database_id
    __args__['name'] = name
    __args__['userName'] = user_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseUserObjectPrivileges:getManagedDatabaseUserObjectPrivileges', __args__, opts=opts, typ=GetManagedDatabaseUserObjectPrivilegesResult).value

    return AwaitableGetManagedDatabaseUserObjectPrivilegesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        name=pulumi.get(__ret__, 'name'),
        object_privilege_collections=pulumi.get(__ret__, 'object_privilege_collections'),
        user_name=pulumi.get(__ret__, 'user_name'))


@_utilities.lift_output_func(get_managed_database_user_object_privileges)
def get_managed_database_user_object_privileges_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagedDatabaseUserObjectPrivilegesFilterArgs']]]]] = None,
                                                       managed_database_id: Optional[pulumi.Input[str]] = None,
                                                       name: Optional[pulumi.Input[Optional[str]]] = None,
                                                       user_name: Optional[pulumi.Input[str]] = None,
                                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseUserObjectPrivilegesResult]:
    """
    This data source provides the list of Managed Database User Object Privileges in Oracle Cloud Infrastructure Database Management service.

    Gets the list of object privileges granted to a specific user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_user_object_privileges = oci.DatabaseManagement.get_managed_database_user_object_privileges(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        user_name=oci_identity_user["test_user"]["name"],
        name=var["managed_database_user_object_privilege_name"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: A filter to return only resources that match the entire name.
    :param str user_name: The name of the user whose details are to be viewed.
    """
    ...
