# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedDatabaseUsersResult',
    'AwaitableGetManagedDatabaseUsersResult',
    'get_managed_database_users',
    'get_managed_database_users_output',
]

@pulumi.output_type
class GetManagedDatabaseUsersResult:
    """
    A collection of values returned by getManagedDatabaseUsers.
    """
    def __init__(__self__, filters=None, id=None, managed_database_id=None, name=None, user_collections=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if user_collections and not isinstance(user_collections, list):
            raise TypeError("Expected argument 'user_collections' to be a list")
        pulumi.set(__self__, "user_collections", user_collections)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedDatabaseUsersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the User.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="userCollections")
    def user_collections(self) -> Sequence['outputs.GetManagedDatabaseUsersUserCollectionResult']:
        """
        The list of user_collection.
        """
        return pulumi.get(self, "user_collections")


class AwaitableGetManagedDatabaseUsersResult(GetManagedDatabaseUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseUsersResult(
            filters=self.filters,
            id=self.id,
            managed_database_id=self.managed_database_id,
            name=self.name,
            user_collections=self.user_collections)


def get_managed_database_users(filters: Optional[Sequence[pulumi.InputType['GetManagedDatabaseUsersFilterArgs']]] = None,
                               managed_database_id: Optional[str] = None,
                               name: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseUsersResult:
    """
    This data source provides the list of Managed Database Users in Oracle Cloud Infrastructure Database Management service.

    Gets the list of users for the specified managedDatabaseId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_users = oci.DatabaseManagement.get_managed_database_users(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        name=var["managed_database_user_name"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: A filter to return only resources that match the entire name.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['managedDatabaseId'] = managed_database_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseUsers:getManagedDatabaseUsers', __args__, opts=opts, typ=GetManagedDatabaseUsersResult).value

    return AwaitableGetManagedDatabaseUsersResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        name=pulumi.get(__ret__, 'name'),
        user_collections=pulumi.get(__ret__, 'user_collections'))


@_utilities.lift_output_func(get_managed_database_users)
def get_managed_database_users_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagedDatabaseUsersFilterArgs']]]]] = None,
                                      managed_database_id: Optional[pulumi.Input[str]] = None,
                                      name: Optional[pulumi.Input[Optional[str]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseUsersResult]:
    """
    This data source provides the list of Managed Database Users in Oracle Cloud Infrastructure Database Management service.

    Gets the list of users for the specified managedDatabaseId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_users = oci.DatabaseManagement.get_managed_database_users(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        name=var["managed_database_user_name"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: A filter to return only resources that match the entire name.
    """
    ...
