# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedDatabasesChangeDatabaseParameterArgs', 'ManagedDatabasesChangeDatabaseParameter']

@pulumi.input_type
class ManagedDatabasesChangeDatabaseParameterArgs:
    def __init__(__self__, *,
                 credentials: pulumi.Input['ManagedDatabasesChangeDatabaseParameterCredentialsArgs'],
                 managed_database_id: pulumi.Input[str],
                 parameters: pulumi.Input[Sequence[pulumi.Input['ManagedDatabasesChangeDatabaseParameterParameterArgs']]],
                 scope: pulumi.Input[str]):
        """
        The set of arguments for constructing a ManagedDatabasesChangeDatabaseParameter resource.
        :param pulumi.Input['ManagedDatabasesChangeDatabaseParameterCredentialsArgs'] credentials: The database credentials used to perform management activity.
        :param pulumi.Input[str] managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedDatabasesChangeDatabaseParameterParameterArgs']]] parameters: A list of database parameters and their values.
        :param pulumi.Input[str] scope: The clause used to specify when the parameter change takes effect.
               
               Use `MEMORY` to make the change in memory and affect it immediately. Use `SPFILE` to make the change in the server parameter file. The change takes effect when the database is next shut down and started up again. Use `BOTH` to make the change in memory and in the server parameter file. The change takes effect immediately and persists after the database is shut down and started up again.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ManagedDatabasesChangeDatabaseParameterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            credentials=credentials,
            managed_database_id=managed_database_id,
            parameters=parameters,
            scope=scope,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             credentials: pulumi.Input['ManagedDatabasesChangeDatabaseParameterCredentialsArgs'],
             managed_database_id: pulumi.Input[str],
             parameters: pulumi.Input[Sequence[pulumi.Input['ManagedDatabasesChangeDatabaseParameterParameterArgs']]],
             scope: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'managedDatabaseId' in kwargs:
            managed_database_id = kwargs['managedDatabaseId']

        _setter("credentials", credentials)
        _setter("managed_database_id", managed_database_id)
        _setter("parameters", parameters)
        _setter("scope", scope)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input['ManagedDatabasesChangeDatabaseParameterCredentialsArgs']:
        """
        The database credentials used to perform management activity.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input['ManagedDatabasesChangeDatabaseParameterCredentialsArgs']):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        """
        return pulumi.get(self, "managed_database_id")

    @managed_database_id.setter
    def managed_database_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "managed_database_id", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input[Sequence[pulumi.Input['ManagedDatabasesChangeDatabaseParameterParameterArgs']]]:
        """
        A list of database parameters and their values.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input[Sequence[pulumi.Input['ManagedDatabasesChangeDatabaseParameterParameterArgs']]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[str]:
        """
        The clause used to specify when the parameter change takes effect.

        Use `MEMORY` to make the change in memory and affect it immediately. Use `SPFILE` to make the change in the server parameter file. The change takes effect when the database is next shut down and started up again. Use `BOTH` to make the change in memory and in the server parameter file. The change takes effect immediately and persists after the database is shut down and started up again.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[str]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _ManagedDatabasesChangeDatabaseParameterState:
    def __init__(__self__, *,
                 credentials: Optional[pulumi.Input['ManagedDatabasesChangeDatabaseParameterCredentialsArgs']] = None,
                 managed_database_id: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabasesChangeDatabaseParameterParameterArgs']]]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ManagedDatabasesChangeDatabaseParameter resources.
        :param pulumi.Input['ManagedDatabasesChangeDatabaseParameterCredentialsArgs'] credentials: The database credentials used to perform management activity.
        :param pulumi.Input[str] managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedDatabasesChangeDatabaseParameterParameterArgs']]] parameters: A list of database parameters and their values.
        :param pulumi.Input[str] scope: The clause used to specify when the parameter change takes effect.
               
               Use `MEMORY` to make the change in memory and affect it immediately. Use `SPFILE` to make the change in the server parameter file. The change takes effect when the database is next shut down and started up again. Use `BOTH` to make the change in memory and in the server parameter file. The change takes effect immediately and persists after the database is shut down and started up again.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        _ManagedDatabasesChangeDatabaseParameterState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            credentials=credentials,
            managed_database_id=managed_database_id,
            parameters=parameters,
            scope=scope,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             credentials: Optional[pulumi.Input['ManagedDatabasesChangeDatabaseParameterCredentialsArgs']] = None,
             managed_database_id: Optional[pulumi.Input[str]] = None,
             parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabasesChangeDatabaseParameterParameterArgs']]]] = None,
             scope: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'managedDatabaseId' in kwargs:
            managed_database_id = kwargs['managedDatabaseId']

        if credentials is not None:
            _setter("credentials", credentials)
        if managed_database_id is not None:
            _setter("managed_database_id", managed_database_id)
        if parameters is not None:
            _setter("parameters", parameters)
        if scope is not None:
            _setter("scope", scope)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['ManagedDatabasesChangeDatabaseParameterCredentialsArgs']]:
        """
        The database credentials used to perform management activity.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['ManagedDatabasesChangeDatabaseParameterCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        """
        return pulumi.get(self, "managed_database_id")

    @managed_database_id.setter
    def managed_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_database_id", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabasesChangeDatabaseParameterParameterArgs']]]]:
        """
        A list of database parameters and their values.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabasesChangeDatabaseParameterParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The clause used to specify when the parameter change takes effect.

        Use `MEMORY` to make the change in memory and affect it immediately. Use `SPFILE` to make the change in the server parameter file. The change takes effect when the database is next shut down and started up again. Use `BOTH` to make the change in memory and in the server parameter file. The change takes effect immediately and persists after the database is shut down and started up again.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


class ManagedDatabasesChangeDatabaseParameter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials: Optional[pulumi.Input[pulumi.InputType['ManagedDatabasesChangeDatabaseParameterCredentialsArgs']]] = None,
                 managed_database_id: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedDatabasesChangeDatabaseParameterParameterArgs']]]]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Managed Databases Change Database Parameter resource in Oracle Cloud Infrastructure Database Management service.

        Changes database parameter values. There are two kinds of database
        parameters:

        - Dynamic parameters: They can be changed for the current Oracle
          Database instance. The changes take effect immediately.
        - Static parameters: They cannot be changed for the current instance.
          You must change these parameters and then restart the database before
          changes take effect.

        **Note:** If the instance is started using a text initialization
        parameter file, the parameter changes are applicable only for the
        current instance. You must update them manually to be passed to
        a future instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_databases_change_database_parameter = oci.database_management.ManagedDatabasesChangeDatabaseParameter("testManagedDatabasesChangeDatabaseParameter",
            credentials=oci.database_management.ManagedDatabasesChangeDatabaseParameterCredentialsArgs(
                password=var["managed_databases_change_database_parameter_credentials_password"],
                role=var["managed_databases_change_database_parameter_credentials_role"],
                secret_id=oci_vault_secret["test_secret"]["id"],
                user_name=oci_identity_user["test_user"]["name"],
            ),
            managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
            parameters=[oci.database_management.ManagedDatabasesChangeDatabaseParameterParameterArgs(
                name=var["managed_databases_change_database_parameter_parameters_name"],
                value=var["managed_databases_change_database_parameter_parameters_value"],
                update_comment=var["managed_databases_change_database_parameter_parameters_update_comment"],
            )],
            scope=var["managed_databases_change_database_parameter_scope"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ManagedDatabasesChangeDatabaseParameterCredentialsArgs']] credentials: The database credentials used to perform management activity.
        :param pulumi.Input[str] managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedDatabasesChangeDatabaseParameterParameterArgs']]]] parameters: A list of database parameters and their values.
        :param pulumi.Input[str] scope: The clause used to specify when the parameter change takes effect.
               
               Use `MEMORY` to make the change in memory and affect it immediately. Use `SPFILE` to make the change in the server parameter file. The change takes effect when the database is next shut down and started up again. Use `BOTH` to make the change in memory and in the server parameter file. The change takes effect immediately and persists after the database is shut down and started up again.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedDatabasesChangeDatabaseParameterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Databases Change Database Parameter resource in Oracle Cloud Infrastructure Database Management service.

        Changes database parameter values. There are two kinds of database
        parameters:

        - Dynamic parameters: They can be changed for the current Oracle
          Database instance. The changes take effect immediately.
        - Static parameters: They cannot be changed for the current instance.
          You must change these parameters and then restart the database before
          changes take effect.

        **Note:** If the instance is started using a text initialization
        parameter file, the parameter changes are applicable only for the
        current instance. You must update them manually to be passed to
        a future instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_databases_change_database_parameter = oci.database_management.ManagedDatabasesChangeDatabaseParameter("testManagedDatabasesChangeDatabaseParameter",
            credentials=oci.database_management.ManagedDatabasesChangeDatabaseParameterCredentialsArgs(
                password=var["managed_databases_change_database_parameter_credentials_password"],
                role=var["managed_databases_change_database_parameter_credentials_role"],
                secret_id=oci_vault_secret["test_secret"]["id"],
                user_name=oci_identity_user["test_user"]["name"],
            ),
            managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
            parameters=[oci.database_management.ManagedDatabasesChangeDatabaseParameterParameterArgs(
                name=var["managed_databases_change_database_parameter_parameters_name"],
                value=var["managed_databases_change_database_parameter_parameters_value"],
                update_comment=var["managed_databases_change_database_parameter_parameters_update_comment"],
            )],
            scope=var["managed_databases_change_database_parameter_scope"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ManagedDatabasesChangeDatabaseParameterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedDatabasesChangeDatabaseParameterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ManagedDatabasesChangeDatabaseParameterArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials: Optional[pulumi.Input[pulumi.InputType['ManagedDatabasesChangeDatabaseParameterCredentialsArgs']]] = None,
                 managed_database_id: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedDatabasesChangeDatabaseParameterParameterArgs']]]]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedDatabasesChangeDatabaseParameterArgs.__new__(ManagedDatabasesChangeDatabaseParameterArgs)

            if credentials is not None and not isinstance(credentials, ManagedDatabasesChangeDatabaseParameterCredentialsArgs):
                credentials = credentials or {}
                def _setter(key, value):
                    credentials[key] = value
                ManagedDatabasesChangeDatabaseParameterCredentialsArgs._configure(_setter, **credentials)
            if credentials is None and not opts.urn:
                raise TypeError("Missing required property 'credentials'")
            __props__.__dict__["credentials"] = credentials
            if managed_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_database_id'")
            __props__.__dict__["managed_database_id"] = managed_database_id
            if parameters is None and not opts.urn:
                raise TypeError("Missing required property 'parameters'")
            __props__.__dict__["parameters"] = parameters
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
        super(ManagedDatabasesChangeDatabaseParameter, __self__).__init__(
            'oci:DatabaseManagement/managedDatabasesChangeDatabaseParameter:ManagedDatabasesChangeDatabaseParameter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credentials: Optional[pulumi.Input[pulumi.InputType['ManagedDatabasesChangeDatabaseParameterCredentialsArgs']]] = None,
            managed_database_id: Optional[pulumi.Input[str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedDatabasesChangeDatabaseParameterParameterArgs']]]]] = None,
            scope: Optional[pulumi.Input[str]] = None) -> 'ManagedDatabasesChangeDatabaseParameter':
        """
        Get an existing ManagedDatabasesChangeDatabaseParameter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ManagedDatabasesChangeDatabaseParameterCredentialsArgs']] credentials: The database credentials used to perform management activity.
        :param pulumi.Input[str] managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedDatabasesChangeDatabaseParameterParameterArgs']]]] parameters: A list of database parameters and their values.
        :param pulumi.Input[str] scope: The clause used to specify when the parameter change takes effect.
               
               Use `MEMORY` to make the change in memory and affect it immediately. Use `SPFILE` to make the change in the server parameter file. The change takes effect when the database is next shut down and started up again. Use `BOTH` to make the change in memory and in the server parameter file. The change takes effect immediately and persists after the database is shut down and started up again.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedDatabasesChangeDatabaseParameterState.__new__(_ManagedDatabasesChangeDatabaseParameterState)

        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["managed_database_id"] = managed_database_id
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["scope"] = scope
        return ManagedDatabasesChangeDatabaseParameter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Output['outputs.ManagedDatabasesChangeDatabaseParameterCredentials']:
        """
        The database credentials used to perform management activity.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        """
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.ManagedDatabasesChangeDatabaseParameterParameter']]:
        """
        A list of database parameters and their values.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[str]:
        """
        The clause used to specify when the parameter change takes effect.

        Use `MEMORY` to make the change in memory and affect it immediately. Use `SPFILE` to make the change in the server parameter file. The change takes effect when the database is next shut down and started up again. Use `BOTH` to make the change in memory and in the server parameter file. The change takes effect immediately and persists after the database is shut down and started up again.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scope")

