# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ApplicationApplicationLogConfig',
    'ApplicationDriverShapeConfig',
    'ApplicationExecutorShapeConfig',
    'ApplicationParameter',
    'InvokeRunApplicationLogConfig',
    'InvokeRunDriverShapeConfig',
    'InvokeRunExecutorShapeConfig',
    'InvokeRunParameter',
    'PoolConfiguration',
    'PoolConfigurationShapeConfig',
    'PoolPoolMetric',
    'PoolPoolMetricActivelyUsedNodeCount',
    'PoolSchedule',
    'PrivateEndpointScanDetail',
    'RunStatementOutput',
    'RunStatementOutputData',
    'SqlEndpointDriverShapeConfig',
    'SqlEndpointExecutorShapeConfig',
    'SqlEndpointNetworkConfiguration',
    'SqlEndpointNetworkConfigurationAccessControlRule',
    'GetApplicationApplicationLogConfigResult',
    'GetApplicationDriverShapeConfigResult',
    'GetApplicationExecutorShapeConfigResult',
    'GetApplicationParameterResult',
    'GetApplicationsApplicationResult',
    'GetApplicationsApplicationApplicationLogConfigResult',
    'GetApplicationsApplicationDriverShapeConfigResult',
    'GetApplicationsApplicationExecutorShapeConfigResult',
    'GetApplicationsApplicationParameterResult',
    'GetApplicationsFilterResult',
    'GetInvokeRunApplicationLogConfigResult',
    'GetInvokeRunDriverShapeConfigResult',
    'GetInvokeRunExecutorShapeConfigResult',
    'GetInvokeRunParameterResult',
    'GetInvokeRunsFilterResult',
    'GetInvokeRunsRunResult',
    'GetInvokeRunsRunApplicationLogConfigResult',
    'GetInvokeRunsRunDriverShapeConfigResult',
    'GetInvokeRunsRunExecutorShapeConfigResult',
    'GetInvokeRunsRunParameterResult',
    'GetPoolConfigurationResult',
    'GetPoolConfigurationShapeConfigResult',
    'GetPoolPoolMetricResult',
    'GetPoolPoolMetricActivelyUsedNodeCountResult',
    'GetPoolScheduleResult',
    'GetPoolsFilterResult',
    'GetPoolsPoolCollectionResult',
    'GetPoolsPoolCollectionItemResult',
    'GetPoolsPoolCollectionItemConfigurationResult',
    'GetPoolsPoolCollectionItemConfigurationShapeConfigResult',
    'GetPoolsPoolCollectionItemPoolMetricResult',
    'GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountResult',
    'GetPoolsPoolCollectionItemScheduleResult',
    'GetPrivateEndpointScanDetailResult',
    'GetPrivateEndpointsFilterResult',
    'GetPrivateEndpointsPrivateEndpointCollectionResult',
    'GetPrivateEndpointsPrivateEndpointCollectionItemResult',
    'GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailResult',
    'GetRunLogsFilterResult',
    'GetRunLogsRunLogResult',
    'GetRunStatementOutputResult',
    'GetRunStatementOutputDataResult',
    'GetRunStatementsFilterResult',
    'GetRunStatementsStatementCollectionResult',
    'GetRunStatementsStatementCollectionItemResult',
    'GetRunStatementsStatementCollectionItemOutputResult',
    'GetRunStatementsStatementCollectionItemOutputDataResult',
    'GetSqlEndpointDriverShapeConfigResult',
    'GetSqlEndpointExecutorShapeConfigResult',
    'GetSqlEndpointNetworkConfigurationResult',
    'GetSqlEndpointNetworkConfigurationAccessControlRuleResult',
    'GetSqlEndpointsFilterResult',
    'GetSqlEndpointsSqlEndpointCollectionResult',
    'GetSqlEndpointsSqlEndpointCollectionItemResult',
    'GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigResult',
    'GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigResult',
    'GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationResult',
    'GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleResult',
]

@pulumi.output_type
class ApplicationApplicationLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupId":
            suggest = "log_group_id"
        elif key == "logId":
            suggest = "log_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationApplicationLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationApplicationLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationApplicationLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_id: str,
                 log_id: str):
        """
        :param str log_group_id: (Updatable) The log group id for where log objects will be for Data Flow Runs.
        :param str log_id: (Updatable) The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        ApplicationApplicationLogConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            log_group_id=log_group_id,
            log_id=log_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             log_group_id: str,
             log_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'logGroupId' in kwargs:
            log_group_id = kwargs['logGroupId']
        if 'logId' in kwargs:
            log_id = kwargs['logId']

        _setter("log_group_id", log_group_id)
        _setter("log_id", log_id)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> str:
        """
        (Updatable) The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> str:
        """
        (Updatable) The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class ApplicationDriverShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationDriverShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationDriverShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationDriverShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[float] = None,
                 ocpus: Optional[float] = None):
        """
        :param float memory_in_gbs: (Updatable) The amount of memory used for the driver or executors.
        :param float ocpus: (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        ApplicationDriverShapeConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: Optional[float] = None,
             ocpus: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        if memory_in_gbs is not None:
            _setter("memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[float]:
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[float]:
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class ApplicationExecutorShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationExecutorShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationExecutorShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationExecutorShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[float] = None,
                 ocpus: Optional[float] = None):
        """
        :param float memory_in_gbs: (Updatable) The amount of memory used for the driver or executors.
        :param float ocpus: (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        ApplicationExecutorShapeConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: Optional[float] = None,
             ocpus: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        if memory_in_gbs is not None:
            _setter("memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[float]:
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[float]:
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class ApplicationParameter(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: (Updatable) The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param str value: (Updatable) The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        ApplicationParameter._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Updatable) The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        (Updatable) The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InvokeRunApplicationLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupId":
            suggest = "log_group_id"
        elif key == "logId":
            suggest = "log_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InvokeRunApplicationLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InvokeRunApplicationLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InvokeRunApplicationLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_id: str,
                 log_id: str):
        """
        :param str log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param str log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        InvokeRunApplicationLogConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            log_group_id=log_group_id,
            log_id=log_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             log_group_id: str,
             log_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'logGroupId' in kwargs:
            log_group_id = kwargs['logGroupId']
        if 'logId' in kwargs:
            log_id = kwargs['logId']

        _setter("log_group_id", log_group_id)
        _setter("log_id", log_id)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> str:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> str:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class InvokeRunDriverShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InvokeRunDriverShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InvokeRunDriverShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InvokeRunDriverShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[float] = None,
                 ocpus: Optional[float] = None):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        InvokeRunDriverShapeConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: Optional[float] = None,
             ocpus: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        if memory_in_gbs is not None:
            _setter("memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[float]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[float]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class InvokeRunExecutorShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InvokeRunExecutorShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InvokeRunExecutorShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InvokeRunExecutorShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[float] = None,
                 ocpus: Optional[float] = None):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        InvokeRunExecutorShapeConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: Optional[float] = None,
             ocpus: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        if memory_in_gbs is not None:
            _setter("memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[float]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[float]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class InvokeRunParameter(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param str value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        InvokeRunParameter._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PoolConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shapeConfig":
            suggest = "shape_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max: Optional[int] = None,
                 min: Optional[int] = None,
                 shape: Optional[str] = None,
                 shape_config: Optional['outputs.PoolConfigurationShapeConfig'] = None):
        """
        :param int max: (Updatable) Maximum number of compute instances in the pool for a given compute shape.
        :param int min: (Updatable) Minimum number of compute instances in the pool for a given compute shape.
        :param str shape: (Updatable) The compute shape of the resources you would like to provision.
        :param 'PoolConfigurationShapeConfigArgs' shape_config: (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        PoolConfiguration._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            max=max,
            min=min,
            shape=shape,
            shape_config=shape_config,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             max: Optional[int] = None,
             min: Optional[int] = None,
             shape: Optional[str] = None,
             shape_config: Optional['outputs.PoolConfigurationShapeConfig'] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'shapeConfig' in kwargs:
            shape_config = kwargs['shapeConfig']

        if max is not None:
            _setter("max", max)
        if min is not None:
            _setter("min", min)
        if shape is not None:
            _setter("shape", shape)
        if shape_config is not None:
            _setter("shape_config", shape_config)

    @property
    @pulumi.getter
    def max(self) -> Optional[int]:
        """
        (Updatable) Maximum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[int]:
        """
        (Updatable) Minimum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter
    def shape(self) -> Optional[str]:
        """
        (Updatable) The compute shape of the resources you would like to provision.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="shapeConfig")
    def shape_config(self) -> Optional['outputs.PoolConfigurationShapeConfig']:
        """
        (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "shape_config")


@pulumi.output_type
class PoolConfigurationShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolConfigurationShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolConfigurationShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolConfigurationShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[float] = None,
                 ocpus: Optional[float] = None):
        """
        :param float memory_in_gbs: (Updatable) The amount of memory used for the driver or executors.
        :param float ocpus: (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        PoolConfigurationShapeConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: Optional[float] = None,
             ocpus: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        if memory_in_gbs is not None:
            _setter("memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[float]:
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[float]:
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class PoolPoolMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeRunsCount":
            suggest = "active_runs_count"
        elif key == "activelyUsedNodeCounts":
            suggest = "actively_used_node_counts"
        elif key == "timeLastMetricsUpdated":
            suggest = "time_last_metrics_updated"
        elif key == "timeLastStarted":
            suggest = "time_last_started"
        elif key == "timeLastStopped":
            suggest = "time_last_stopped"
        elif key == "timeLastUsed":
            suggest = "time_last_used"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolPoolMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolPoolMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolPoolMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_runs_count: Optional[str] = None,
                 actively_used_node_counts: Optional[Sequence['outputs.PoolPoolMetricActivelyUsedNodeCount']] = None,
                 time_last_metrics_updated: Optional[str] = None,
                 time_last_started: Optional[str] = None,
                 time_last_stopped: Optional[str] = None,
                 time_last_used: Optional[str] = None):
        """
        :param str active_runs_count: The number of runs that are currently running that are using this pool.
        :param Sequence['PoolPoolMetricActivelyUsedNodeCountArgs'] actively_used_node_counts: A count of the nodes that are currently being used for each shape in this pool.
        :param str time_last_metrics_updated: The last time the mertics were updated for this.
        :param str time_last_started: The last time this pool was started.
        :param str time_last_stopped: The last time this pool was stopped.
        :param str time_last_used: The last time a run used this pool.
        """
        PoolPoolMetric._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            active_runs_count=active_runs_count,
            actively_used_node_counts=actively_used_node_counts,
            time_last_metrics_updated=time_last_metrics_updated,
            time_last_started=time_last_started,
            time_last_stopped=time_last_stopped,
            time_last_used=time_last_used,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             active_runs_count: Optional[str] = None,
             actively_used_node_counts: Optional[Sequence['outputs.PoolPoolMetricActivelyUsedNodeCount']] = None,
             time_last_metrics_updated: Optional[str] = None,
             time_last_started: Optional[str] = None,
             time_last_stopped: Optional[str] = None,
             time_last_used: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'activeRunsCount' in kwargs:
            active_runs_count = kwargs['activeRunsCount']
        if 'activelyUsedNodeCounts' in kwargs:
            actively_used_node_counts = kwargs['activelyUsedNodeCounts']
        if 'timeLastMetricsUpdated' in kwargs:
            time_last_metrics_updated = kwargs['timeLastMetricsUpdated']
        if 'timeLastStarted' in kwargs:
            time_last_started = kwargs['timeLastStarted']
        if 'timeLastStopped' in kwargs:
            time_last_stopped = kwargs['timeLastStopped']
        if 'timeLastUsed' in kwargs:
            time_last_used = kwargs['timeLastUsed']

        if active_runs_count is not None:
            _setter("active_runs_count", active_runs_count)
        if actively_used_node_counts is not None:
            _setter("actively_used_node_counts", actively_used_node_counts)
        if time_last_metrics_updated is not None:
            _setter("time_last_metrics_updated", time_last_metrics_updated)
        if time_last_started is not None:
            _setter("time_last_started", time_last_started)
        if time_last_stopped is not None:
            _setter("time_last_stopped", time_last_stopped)
        if time_last_used is not None:
            _setter("time_last_used", time_last_used)

    @property
    @pulumi.getter(name="activeRunsCount")
    def active_runs_count(self) -> Optional[str]:
        """
        The number of runs that are currently running that are using this pool.
        """
        return pulumi.get(self, "active_runs_count")

    @property
    @pulumi.getter(name="activelyUsedNodeCounts")
    def actively_used_node_counts(self) -> Optional[Sequence['outputs.PoolPoolMetricActivelyUsedNodeCount']]:
        """
        A count of the nodes that are currently being used for each shape in this pool.
        """
        return pulumi.get(self, "actively_used_node_counts")

    @property
    @pulumi.getter(name="timeLastMetricsUpdated")
    def time_last_metrics_updated(self) -> Optional[str]:
        """
        The last time the mertics were updated for this.
        """
        return pulumi.get(self, "time_last_metrics_updated")

    @property
    @pulumi.getter(name="timeLastStarted")
    def time_last_started(self) -> Optional[str]:
        """
        The last time this pool was started.
        """
        return pulumi.get(self, "time_last_started")

    @property
    @pulumi.getter(name="timeLastStopped")
    def time_last_stopped(self) -> Optional[str]:
        """
        The last time this pool was stopped.
        """
        return pulumi.get(self, "time_last_stopped")

    @property
    @pulumi.getter(name="timeLastUsed")
    def time_last_used(self) -> Optional[str]:
        """
        The last time a run used this pool.
        """
        return pulumi.get(self, "time_last_used")


@pulumi.output_type
class PoolPoolMetricActivelyUsedNodeCount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logicalShape":
            suggest = "logical_shape"
        elif key == "poolCount":
            suggest = "pool_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolPoolMetricActivelyUsedNodeCount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolPoolMetricActivelyUsedNodeCount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolPoolMetricActivelyUsedNodeCount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 logical_shape: Optional[str] = None,
                 pool_count: Optional[int] = None):
        """
        :param str logical_shape: The compute shape of the nodes that the count is for.
        :param int pool_count: The node count of this compute shape.
        """
        PoolPoolMetricActivelyUsedNodeCount._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            logical_shape=logical_shape,
            pool_count=pool_count,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             logical_shape: Optional[str] = None,
             pool_count: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'logicalShape' in kwargs:
            logical_shape = kwargs['logicalShape']
        if 'poolCount' in kwargs:
            pool_count = kwargs['poolCount']

        if logical_shape is not None:
            _setter("logical_shape", logical_shape)
        if pool_count is not None:
            _setter("pool_count", pool_count)

    @property
    @pulumi.getter(name="logicalShape")
    def logical_shape(self) -> Optional[str]:
        """
        The compute shape of the nodes that the count is for.
        """
        return pulumi.get(self, "logical_shape")

    @property
    @pulumi.getter(name="poolCount")
    def pool_count(self) -> Optional[int]:
        """
        The node count of this compute shape.
        """
        return pulumi.get(self, "pool_count")


@pulumi.output_type
class PoolSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "stopTime":
            suggest = "stop_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: Optional[str] = None,
                 start_time: Optional[int] = None,
                 stop_time: Optional[int] = None):
        """
        :param str day_of_week: (Updatable) Day of the week SUN-SAT
        :param int start_time: (Updatable) Hour of the day to start or stop pool.
        :param int stop_time: (Updatable) Hour of the day to stop the pool.
        """
        PoolSchedule._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            day_of_week=day_of_week,
            start_time=start_time,
            stop_time=stop_time,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             day_of_week: Optional[str] = None,
             start_time: Optional[int] = None,
             stop_time: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'dayOfWeek' in kwargs:
            day_of_week = kwargs['dayOfWeek']
        if 'startTime' in kwargs:
            start_time = kwargs['startTime']
        if 'stopTime' in kwargs:
            stop_time = kwargs['stopTime']

        if day_of_week is not None:
            _setter("day_of_week", day_of_week)
        if start_time is not None:
            _setter("start_time", start_time)
        if stop_time is not None:
            _setter("stop_time", stop_time)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[str]:
        """
        (Updatable) Day of the week SUN-SAT
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[int]:
        """
        (Updatable) Hour of the day to start or stop pool.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="stopTime")
    def stop_time(self) -> Optional[int]:
        """
        (Updatable) Hour of the day to stop the pool.
        """
        return pulumi.get(self, "stop_time")


@pulumi.output_type
class PrivateEndpointScanDetail(dict):
    def __init__(__self__, *,
                 fqdn: Optional[str] = None,
                 port: Optional[str] = None):
        """
        :param str fqdn: (Updatable) A fully-qualified domain name (FQDN).
        :param str port: (Updatable) The port number of the FQDN
        """
        PrivateEndpointScanDetail._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            fqdn=fqdn,
            port=port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             fqdn: Optional[str] = None,
             port: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if fqdn is not None:
            _setter("fqdn", fqdn)
        if port is not None:
            _setter("port", port)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        (Updatable) A fully-qualified domain name (FQDN).
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        (Updatable) The port number of the FQDN
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class RunStatementOutput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorName":
            suggest = "error_name"
        elif key == "errorValue":
            suggest = "error_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunStatementOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunStatementOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunStatementOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datas: Optional[Sequence['outputs.RunStatementOutputData']] = None,
                 error_name: Optional[str] = None,
                 error_value: Optional[str] = None,
                 status: Optional[str] = None,
                 tracebacks: Optional[Sequence[str]] = None):
        """
        :param Sequence['RunStatementOutputDataArgs'] datas: An object representing execution output of a statement.
        :param str error_name: The name of the error in the statement output.
        :param str error_value: The value of the error in the statement output.
        :param str status: Status of the statement output.
        :param Sequence[str] tracebacks: The traceback of the statement output.
        """
        RunStatementOutput._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            datas=datas,
            error_name=error_name,
            error_value=error_value,
            status=status,
            tracebacks=tracebacks,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             datas: Optional[Sequence['outputs.RunStatementOutputData']] = None,
             error_name: Optional[str] = None,
             error_value: Optional[str] = None,
             status: Optional[str] = None,
             tracebacks: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'errorName' in kwargs:
            error_name = kwargs['errorName']
        if 'errorValue' in kwargs:
            error_value = kwargs['errorValue']

        if datas is not None:
            _setter("datas", datas)
        if error_name is not None:
            _setter("error_name", error_name)
        if error_value is not None:
            _setter("error_value", error_value)
        if status is not None:
            _setter("status", status)
        if tracebacks is not None:
            _setter("tracebacks", tracebacks)

    @property
    @pulumi.getter
    def datas(self) -> Optional[Sequence['outputs.RunStatementOutputData']]:
        """
        An object representing execution output of a statement.
        """
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter(name="errorName")
    def error_name(self) -> Optional[str]:
        """
        The name of the error in the statement output.
        """
        return pulumi.get(self, "error_name")

    @property
    @pulumi.getter(name="errorValue")
    def error_value(self) -> Optional[str]:
        """
        The value of the error in the statement output.
        """
        return pulumi.get(self, "error_value")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of the statement output.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tracebacks(self) -> Optional[Sequence[str]]:
        """
        The traceback of the statement output.
        """
        return pulumi.get(self, "tracebacks")


@pulumi.output_type
class RunStatementOutputData(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str type: The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        :param str value: The statement code execution output in html format.
        """
        RunStatementOutputData._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: Optional[str] = None,
             value: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if type is not None:
            _setter("type", type)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The statement code execution output in html format.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SqlEndpointDriverShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlEndpointDriverShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlEndpointDriverShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlEndpointDriverShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[float] = None,
                 ocpus: Optional[float] = None):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        SqlEndpointDriverShapeConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: Optional[float] = None,
             ocpus: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        if memory_in_gbs is not None:
            _setter("memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[float]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[float]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class SqlEndpointExecutorShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlEndpointExecutorShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlEndpointExecutorShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlEndpointExecutorShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[float] = None,
                 ocpus: Optional[float] = None):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        SqlEndpointExecutorShapeConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: Optional[float] = None,
             ocpus: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        if memory_in_gbs is not None:
            _setter("memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[float]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[float]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class SqlEndpointNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkType":
            suggest = "network_type"
        elif key == "accessControlRules":
            suggest = "access_control_rules"
        elif key == "hostNamePrefix":
            suggest = "host_name_prefix"
        elif key == "privateEndpointIp":
            suggest = "private_endpoint_ip"
        elif key == "publicEndpointIp":
            suggest = "public_endpoint_ip"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vcnId":
            suggest = "vcn_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlEndpointNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlEndpointNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlEndpointNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_type: str,
                 access_control_rules: Optional[Sequence['outputs.SqlEndpointNetworkConfigurationAccessControlRule']] = None,
                 host_name_prefix: Optional[str] = None,
                 private_endpoint_ip: Optional[str] = None,
                 public_endpoint_ip: Optional[str] = None,
                 subnet_id: Optional[str] = None,
                 vcn_id: Optional[str] = None):
        """
        :param str network_type: The type of network configuration.
        :param Sequence['SqlEndpointNetworkConfigurationAccessControlRuleArgs'] access_control_rules: A list of SecureAccessControlRule's to which access is limited to
        :param str host_name_prefix: The host name prefix.
        :param str private_endpoint_ip: Ip Address of private endpoint
        :param str public_endpoint_ip: Ip Address of public endpoint
        :param str subnet_id: The VCN Subnet OCID.
        :param str vcn_id: The VCN OCID.
        """
        SqlEndpointNetworkConfiguration._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            network_type=network_type,
            access_control_rules=access_control_rules,
            host_name_prefix=host_name_prefix,
            private_endpoint_ip=private_endpoint_ip,
            public_endpoint_ip=public_endpoint_ip,
            subnet_id=subnet_id,
            vcn_id=vcn_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             network_type: str,
             access_control_rules: Optional[Sequence['outputs.SqlEndpointNetworkConfigurationAccessControlRule']] = None,
             host_name_prefix: Optional[str] = None,
             private_endpoint_ip: Optional[str] = None,
             public_endpoint_ip: Optional[str] = None,
             subnet_id: Optional[str] = None,
             vcn_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'networkType' in kwargs:
            network_type = kwargs['networkType']
        if 'accessControlRules' in kwargs:
            access_control_rules = kwargs['accessControlRules']
        if 'hostNamePrefix' in kwargs:
            host_name_prefix = kwargs['hostNamePrefix']
        if 'privateEndpointIp' in kwargs:
            private_endpoint_ip = kwargs['privateEndpointIp']
        if 'publicEndpointIp' in kwargs:
            public_endpoint_ip = kwargs['publicEndpointIp']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'vcnId' in kwargs:
            vcn_id = kwargs['vcnId']

        _setter("network_type", network_type)
        if access_control_rules is not None:
            _setter("access_control_rules", access_control_rules)
        if host_name_prefix is not None:
            _setter("host_name_prefix", host_name_prefix)
        if private_endpoint_ip is not None:
            _setter("private_endpoint_ip", private_endpoint_ip)
        if public_endpoint_ip is not None:
            _setter("public_endpoint_ip", public_endpoint_ip)
        if subnet_id is not None:
            _setter("subnet_id", subnet_id)
        if vcn_id is not None:
            _setter("vcn_id", vcn_id)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        The type of network configuration.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="accessControlRules")
    def access_control_rules(self) -> Optional[Sequence['outputs.SqlEndpointNetworkConfigurationAccessControlRule']]:
        """
        A list of SecureAccessControlRule's to which access is limited to
        """
        return pulumi.get(self, "access_control_rules")

    @property
    @pulumi.getter(name="hostNamePrefix")
    def host_name_prefix(self) -> Optional[str]:
        """
        The host name prefix.
        """
        return pulumi.get(self, "host_name_prefix")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> Optional[str]:
        """
        Ip Address of private endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter(name="publicEndpointIp")
    def public_endpoint_ip(self) -> Optional[str]:
        """
        Ip Address of public endpoint
        """
        return pulumi.get(self, "public_endpoint_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        The VCN Subnet OCID.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[str]:
        """
        The VCN OCID.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class SqlEndpointNetworkConfigurationAccessControlRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipNotation":
            suggest = "ip_notation"
        elif key == "vcnIps":
            suggest = "vcn_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlEndpointNetworkConfigurationAccessControlRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlEndpointNetworkConfigurationAccessControlRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlEndpointNetworkConfigurationAccessControlRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_notation: Optional[str] = None,
                 value: Optional[str] = None,
                 vcn_ips: Optional[str] = None):
        """
        :param str ip_notation: The type of IP notation.
        :param str value: The associated value of the selected IP notation.
        :param str vcn_ips: A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        SqlEndpointNetworkConfigurationAccessControlRule._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ip_notation=ip_notation,
            value=value,
            vcn_ips=vcn_ips,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ip_notation: Optional[str] = None,
             value: Optional[str] = None,
             vcn_ips: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ipNotation' in kwargs:
            ip_notation = kwargs['ipNotation']
        if 'vcnIps' in kwargs:
            vcn_ips = kwargs['vcnIps']

        if ip_notation is not None:
            _setter("ip_notation", ip_notation)
        if value is not None:
            _setter("value", value)
        if vcn_ips is not None:
            _setter("vcn_ips", vcn_ips)

    @property
    @pulumi.getter(name="ipNotation")
    def ip_notation(self) -> Optional[str]:
        """
        The type of IP notation.
        """
        return pulumi.get(self, "ip_notation")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The associated value of the selected IP notation.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="vcnIps")
    def vcn_ips(self) -> Optional[str]:
        """
        A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        return pulumi.get(self, "vcn_ips")


@pulumi.output_type
class GetApplicationApplicationLogConfigResult(dict):
    def __init__(__self__, *,
                 log_group_id: str,
                 log_id: str):
        """
        :param str log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param str log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        GetApplicationApplicationLogConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            log_group_id=log_group_id,
            log_id=log_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             log_group_id: str,
             log_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'logGroupId' in kwargs:
            log_group_id = kwargs['logGroupId']
        if 'logId' in kwargs:
            log_id = kwargs['logId']

        _setter("log_group_id", log_group_id)
        _setter("log_id", log_id)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> str:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> str:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class GetApplicationDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetApplicationDriverShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetApplicationExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetApplicationExecutorShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetApplicationParameterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param str value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        GetApplicationParameterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetApplicationsApplicationResult(dict):
    def __init__(__self__, *,
                 application_log_configs: Sequence['outputs.GetApplicationsApplicationApplicationLogConfigResult'],
                 archive_uri: str,
                 arguments: Sequence[str],
                 class_name: str,
                 compartment_id: str,
                 configuration: Mapping[str, Any],
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 driver_shape: str,
                 driver_shape_configs: Sequence['outputs.GetApplicationsApplicationDriverShapeConfigResult'],
                 execute: str,
                 executor_shape: str,
                 executor_shape_configs: Sequence['outputs.GetApplicationsApplicationExecutorShapeConfigResult'],
                 file_uri: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 idle_timeout_in_minutes: str,
                 language: str,
                 logs_bucket_uri: str,
                 max_duration_in_minutes: str,
                 metastore_id: str,
                 num_executors: int,
                 owner_principal_id: str,
                 owner_user_name: str,
                 parameters: Sequence['outputs.GetApplicationsApplicationParameterResult'],
                 pool_id: str,
                 private_endpoint_id: str,
                 spark_version: str,
                 state: str,
                 time_created: str,
                 time_updated: str,
                 type: str,
                 warehouse_bucket_uri: str):
        """
        :param Sequence['GetApplicationsApplicationApplicationLogConfigArgs'] application_log_configs: Logging details of Application logs for Data Flow Run.
        :param str archive_uri: A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param Sequence[str] arguments: The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        :param str class_name: The class for the application.
        :param str compartment_id: The OCID of the compartment.
        :param Mapping[str, Any] configuration: The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str description: A user-friendly description.
        :param str display_name: The query parameter for the Spark application name.
        :param str driver_shape: The VM shape for the driver. Sets the driver cores and memory.
        :param Sequence['GetApplicationsApplicationDriverShapeConfigArgs'] driver_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param str execute: The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        :param str executor_shape: The VM shape for the executors. Sets the executor cores and memory.
        :param Sequence['GetApplicationsApplicationExecutorShapeConfigArgs'] executor_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param str file_uri: An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The application ID.
        :param str idle_timeout_in_minutes: The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        :param str language: The Spark language.
        :param str logs_bucket_uri: An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param str max_duration_in_minutes: The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        :param str metastore_id: The OCID of Oracle Cloud Infrastructure Hive Metastore.
        :param int num_executors: The number of executor VMs requested.
        :param str owner_principal_id: The OCID of the user who created the resource.
        :param str owner_user_name: The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        :param Sequence['GetApplicationsApplicationParameterArgs'] parameters: An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        :param str pool_id: The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        :param str private_endpoint_id: The OCID of a private endpoint.
        :param str spark_version: The Spark version utilized to run the application.
        :param str state: The current state of this application.
        :param str time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param str time_updated: The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param str type: The Spark application processing type.
        :param str warehouse_bucket_uri: An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        GetApplicationsApplicationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            application_log_configs=application_log_configs,
            archive_uri=archive_uri,
            arguments=arguments,
            class_name=class_name,
            compartment_id=compartment_id,
            configuration=configuration,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            driver_shape=driver_shape,
            driver_shape_configs=driver_shape_configs,
            execute=execute,
            executor_shape=executor_shape,
            executor_shape_configs=executor_shape_configs,
            file_uri=file_uri,
            freeform_tags=freeform_tags,
            id=id,
            idle_timeout_in_minutes=idle_timeout_in_minutes,
            language=language,
            logs_bucket_uri=logs_bucket_uri,
            max_duration_in_minutes=max_duration_in_minutes,
            metastore_id=metastore_id,
            num_executors=num_executors,
            owner_principal_id=owner_principal_id,
            owner_user_name=owner_user_name,
            parameters=parameters,
            pool_id=pool_id,
            private_endpoint_id=private_endpoint_id,
            spark_version=spark_version,
            state=state,
            time_created=time_created,
            time_updated=time_updated,
            type=type,
            warehouse_bucket_uri=warehouse_bucket_uri,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             application_log_configs: Sequence['outputs.GetApplicationsApplicationApplicationLogConfigResult'],
             archive_uri: str,
             arguments: Sequence[str],
             class_name: str,
             compartment_id: str,
             configuration: Mapping[str, Any],
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             driver_shape: str,
             driver_shape_configs: Sequence['outputs.GetApplicationsApplicationDriverShapeConfigResult'],
             execute: str,
             executor_shape: str,
             executor_shape_configs: Sequence['outputs.GetApplicationsApplicationExecutorShapeConfigResult'],
             file_uri: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             idle_timeout_in_minutes: str,
             language: str,
             logs_bucket_uri: str,
             max_duration_in_minutes: str,
             metastore_id: str,
             num_executors: int,
             owner_principal_id: str,
             owner_user_name: str,
             parameters: Sequence['outputs.GetApplicationsApplicationParameterResult'],
             pool_id: str,
             private_endpoint_id: str,
             spark_version: str,
             state: str,
             time_created: str,
             time_updated: str,
             type: str,
             warehouse_bucket_uri: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'applicationLogConfigs' in kwargs:
            application_log_configs = kwargs['applicationLogConfigs']
        if 'archiveUri' in kwargs:
            archive_uri = kwargs['archiveUri']
        if 'className' in kwargs:
            class_name = kwargs['className']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'driverShape' in kwargs:
            driver_shape = kwargs['driverShape']
        if 'driverShapeConfigs' in kwargs:
            driver_shape_configs = kwargs['driverShapeConfigs']
        if 'executorShape' in kwargs:
            executor_shape = kwargs['executorShape']
        if 'executorShapeConfigs' in kwargs:
            executor_shape_configs = kwargs['executorShapeConfigs']
        if 'fileUri' in kwargs:
            file_uri = kwargs['fileUri']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'idleTimeoutInMinutes' in kwargs:
            idle_timeout_in_minutes = kwargs['idleTimeoutInMinutes']
        if 'logsBucketUri' in kwargs:
            logs_bucket_uri = kwargs['logsBucketUri']
        if 'maxDurationInMinutes' in kwargs:
            max_duration_in_minutes = kwargs['maxDurationInMinutes']
        if 'metastoreId' in kwargs:
            metastore_id = kwargs['metastoreId']
        if 'numExecutors' in kwargs:
            num_executors = kwargs['numExecutors']
        if 'ownerPrincipalId' in kwargs:
            owner_principal_id = kwargs['ownerPrincipalId']
        if 'ownerUserName' in kwargs:
            owner_user_name = kwargs['ownerUserName']
        if 'poolId' in kwargs:
            pool_id = kwargs['poolId']
        if 'privateEndpointId' in kwargs:
            private_endpoint_id = kwargs['privateEndpointId']
        if 'sparkVersion' in kwargs:
            spark_version = kwargs['sparkVersion']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'warehouseBucketUri' in kwargs:
            warehouse_bucket_uri = kwargs['warehouseBucketUri']

        _setter("application_log_configs", application_log_configs)
        _setter("archive_uri", archive_uri)
        _setter("arguments", arguments)
        _setter("class_name", class_name)
        _setter("compartment_id", compartment_id)
        _setter("configuration", configuration)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("driver_shape", driver_shape)
        _setter("driver_shape_configs", driver_shape_configs)
        _setter("execute", execute)
        _setter("executor_shape", executor_shape)
        _setter("executor_shape_configs", executor_shape_configs)
        _setter("file_uri", file_uri)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("idle_timeout_in_minutes", idle_timeout_in_minutes)
        _setter("language", language)
        _setter("logs_bucket_uri", logs_bucket_uri)
        _setter("max_duration_in_minutes", max_duration_in_minutes)
        _setter("metastore_id", metastore_id)
        _setter("num_executors", num_executors)
        _setter("owner_principal_id", owner_principal_id)
        _setter("owner_user_name", owner_user_name)
        _setter("parameters", parameters)
        _setter("pool_id", pool_id)
        _setter("private_endpoint_id", private_endpoint_id)
        _setter("spark_version", spark_version)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("type", type)
        _setter("warehouse_bucket_uri", warehouse_bucket_uri)

    @property
    @pulumi.getter(name="applicationLogConfigs")
    def application_log_configs(self) -> Sequence['outputs.GetApplicationsApplicationApplicationLogConfigResult']:
        """
        Logging details of Application logs for Data Flow Run.
        """
        return pulumi.get(self, "application_log_configs")

    @property
    @pulumi.getter(name="archiveUri")
    def archive_uri(self) -> str:
        """
        A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "archive_uri")

    @property
    @pulumi.getter
    def arguments(self) -> Sequence[str]:
        """
        The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> str:
        """
        The class for the application.
        """
        return pulumi.get(self, "class_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configuration(self) -> Mapping[str, Any]:
        """
        The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-friendly description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The query parameter for the Spark application name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> str:
        """
        The VM shape for the driver. Sets the driver cores and memory.
        """
        return pulumi.get(self, "driver_shape")

    @property
    @pulumi.getter(name="driverShapeConfigs")
    def driver_shape_configs(self) -> Sequence['outputs.GetApplicationsApplicationDriverShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_configs")

    @property
    @pulumi.getter
    def execute(self) -> str:
        """
        The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        """
        return pulumi.get(self, "execute")

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> str:
        """
        The VM shape for the executors. Sets the executor cores and memory.
        """
        return pulumi.get(self, "executor_shape")

    @property
    @pulumi.getter(name="executorShapeConfigs")
    def executor_shape_configs(self) -> Sequence['outputs.GetApplicationsApplicationExecutorShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_configs")

    @property
    @pulumi.getter(name="fileUri")
    def file_uri(self) -> str:
        """
        An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "file_uri")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The application ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> str:
        """
        The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter
    def language(self) -> str:
        """
        The Spark language.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="logsBucketUri")
    def logs_bucket_uri(self) -> str:
        """
        An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "logs_bucket_uri")

    @property
    @pulumi.getter(name="maxDurationInMinutes")
    def max_duration_in_minutes(self) -> str:
        """
        The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        """
        return pulumi.get(self, "max_duration_in_minutes")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> str:
        """
        The OCID of Oracle Cloud Infrastructure Hive Metastore.
        """
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter(name="numExecutors")
    def num_executors(self) -> int:
        """
        The number of executor VMs requested.
        """
        return pulumi.get(self, "num_executors")

    @property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> str:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> str:
        """
        The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        """
        return pulumi.get(self, "owner_user_name")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetApplicationsApplicationParameterResult']:
        """
        An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> str:
        """
        The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> str:
        """
        The OCID of a private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> str:
        """
        The Spark version utilized to run the application.
        """
        return pulumi.get(self, "spark_version")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of this application.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The Spark application processing type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> str:
        """
        An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "warehouse_bucket_uri")


@pulumi.output_type
class GetApplicationsApplicationApplicationLogConfigResult(dict):
    def __init__(__self__, *,
                 log_group_id: str,
                 log_id: str):
        """
        :param str log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param str log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        GetApplicationsApplicationApplicationLogConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            log_group_id=log_group_id,
            log_id=log_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             log_group_id: str,
             log_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'logGroupId' in kwargs:
            log_group_id = kwargs['logGroupId']
        if 'logId' in kwargs:
            log_id = kwargs['logId']

        _setter("log_group_id", log_group_id)
        _setter("log_id", log_id)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> str:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> str:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class GetApplicationsApplicationDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetApplicationsApplicationDriverShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetApplicationsApplicationExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetApplicationsApplicationExecutorShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetApplicationsApplicationParameterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param str value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        GetApplicationsApplicationParameterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetApplicationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        GetApplicationsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetInvokeRunApplicationLogConfigResult(dict):
    def __init__(__self__, *,
                 log_group_id: str,
                 log_id: str):
        """
        :param str log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param str log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        GetInvokeRunApplicationLogConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            log_group_id=log_group_id,
            log_id=log_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             log_group_id: str,
             log_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'logGroupId' in kwargs:
            log_group_id = kwargs['logGroupId']
        if 'logId' in kwargs:
            log_id = kwargs['logId']

        _setter("log_group_id", log_group_id)
        _setter("log_id", log_id)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> str:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> str:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class GetInvokeRunDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetInvokeRunDriverShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetInvokeRunExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetInvokeRunExecutorShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetInvokeRunParameterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param str value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        GetInvokeRunParameterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetInvokeRunsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        GetInvokeRunsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetInvokeRunsRunResult(dict):
    def __init__(__self__, *,
                 application_id: str,
                 application_log_configs: Sequence['outputs.GetInvokeRunsRunApplicationLogConfigResult'],
                 archive_uri: str,
                 arguments: Sequence[str],
                 asynchronous: bool,
                 class_name: str,
                 compartment_id: str,
                 configuration: Mapping[str, Any],
                 data_read_in_bytes: str,
                 data_written_in_bytes: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 driver_shape: str,
                 driver_shape_configs: Sequence['outputs.GetInvokeRunsRunDriverShapeConfigResult'],
                 execute: str,
                 executor_shape: str,
                 executor_shape_configs: Sequence['outputs.GetInvokeRunsRunExecutorShapeConfigResult'],
                 file_uri: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 idle_timeout_in_minutes: str,
                 language: str,
                 lifecycle_details: str,
                 logs_bucket_uri: str,
                 max_duration_in_minutes: str,
                 metastore_id: str,
                 num_executors: int,
                 opc_request_id: str,
                 owner_principal_id: str,
                 owner_user_name: str,
                 parameters: Sequence['outputs.GetInvokeRunsRunParameterResult'],
                 pool_id: str,
                 private_endpoint_dns_zones: Sequence[str],
                 private_endpoint_id: str,
                 private_endpoint_max_host_count: int,
                 private_endpoint_nsg_ids: Sequence[str],
                 private_endpoint_subnet_id: str,
                 run_duration_in_milliseconds: str,
                 spark_version: str,
                 state: str,
                 time_created: str,
                 time_updated: str,
                 total_ocpu: int,
                 type: str,
                 warehouse_bucket_uri: str):
        """
        :param str application_id: The ID of the application.
        :param Sequence['GetInvokeRunsRunApplicationLogConfigArgs'] application_log_configs: Logging details of Application logs for Data Flow Run.
        :param str archive_uri: A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param Sequence[str] arguments: The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        :param str class_name: The class for the application.
        :param str compartment_id: The OCID of the compartment.
        :param Mapping[str, Any] configuration: The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param str data_read_in_bytes: The data read by the run in bytes.
        :param str data_written_in_bytes: The data written by the run in bytes.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: The query parameter for the Spark application name.
        :param str driver_shape: The VM shape for the driver. Sets the driver cores and memory.
        :param Sequence['GetInvokeRunsRunDriverShapeConfigArgs'] driver_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param str execute: The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        :param str executor_shape: The VM shape for the executors. Sets the executor cores and memory.
        :param Sequence['GetInvokeRunsRunExecutorShapeConfigArgs'] executor_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param str file_uri: An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The ID of a run.
        :param str idle_timeout_in_minutes: The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        :param str language: The Spark language.
        :param str lifecycle_details: The detailed messages about the lifecycle state.
        :param str logs_bucket_uri: An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param str max_duration_in_minutes: The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        :param str metastore_id: The OCID of Oracle Cloud Infrastructure Hive Metastore.
        :param int num_executors: The number of executor VMs requested.
        :param str opc_request_id: Unique Oracle assigned identifier for the request. If you need to contact Oracle about a particular request, please provide the request ID.
        :param str owner_principal_id: The OCID of the user who created the resource.
        :param str owner_user_name: The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        :param Sequence['GetInvokeRunsRunParameterArgs'] parameters: An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        :param str pool_id: The ID of the pool.
        :param Sequence[str] private_endpoint_dns_zones: An array of DNS zone names. Example: `[ "app.examplecorp.com", "app.examplecorp2.com" ]`
        :param str private_endpoint_id: The OCID of a private endpoint.
        :param int private_endpoint_max_host_count: The maximum number of hosts to be accessed through the private endpoint. This value is used to calculate the relevant CIDR block and should be a multiple of 256.  If the value is not a multiple of 256, it is rounded up to the next multiple of 256. For example, 300 is rounded up to 512.
        :param Sequence[str] private_endpoint_nsg_ids: An array of network security group OCIDs.
        :param str private_endpoint_subnet_id: The OCID of a subnet.
        :param str run_duration_in_milliseconds: The duration of the run in milliseconds.
        :param str spark_version: The Spark version utilized to run the application.
        :param str state: The LifecycleState of the run.
        :param str time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param str time_updated: The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param int total_ocpu: The total number of oCPU requested by the run.
        :param str type: The Spark application processing type.
        :param str warehouse_bucket_uri: An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        GetInvokeRunsRunResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            application_id=application_id,
            application_log_configs=application_log_configs,
            archive_uri=archive_uri,
            arguments=arguments,
            asynchronous=asynchronous,
            class_name=class_name,
            compartment_id=compartment_id,
            configuration=configuration,
            data_read_in_bytes=data_read_in_bytes,
            data_written_in_bytes=data_written_in_bytes,
            defined_tags=defined_tags,
            display_name=display_name,
            driver_shape=driver_shape,
            driver_shape_configs=driver_shape_configs,
            execute=execute,
            executor_shape=executor_shape,
            executor_shape_configs=executor_shape_configs,
            file_uri=file_uri,
            freeform_tags=freeform_tags,
            id=id,
            idle_timeout_in_minutes=idle_timeout_in_minutes,
            language=language,
            lifecycle_details=lifecycle_details,
            logs_bucket_uri=logs_bucket_uri,
            max_duration_in_minutes=max_duration_in_minutes,
            metastore_id=metastore_id,
            num_executors=num_executors,
            opc_request_id=opc_request_id,
            owner_principal_id=owner_principal_id,
            owner_user_name=owner_user_name,
            parameters=parameters,
            pool_id=pool_id,
            private_endpoint_dns_zones=private_endpoint_dns_zones,
            private_endpoint_id=private_endpoint_id,
            private_endpoint_max_host_count=private_endpoint_max_host_count,
            private_endpoint_nsg_ids=private_endpoint_nsg_ids,
            private_endpoint_subnet_id=private_endpoint_subnet_id,
            run_duration_in_milliseconds=run_duration_in_milliseconds,
            spark_version=spark_version,
            state=state,
            time_created=time_created,
            time_updated=time_updated,
            total_ocpu=total_ocpu,
            type=type,
            warehouse_bucket_uri=warehouse_bucket_uri,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             application_id: str,
             application_log_configs: Sequence['outputs.GetInvokeRunsRunApplicationLogConfigResult'],
             archive_uri: str,
             arguments: Sequence[str],
             asynchronous: bool,
             class_name: str,
             compartment_id: str,
             configuration: Mapping[str, Any],
             data_read_in_bytes: str,
             data_written_in_bytes: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             driver_shape: str,
             driver_shape_configs: Sequence['outputs.GetInvokeRunsRunDriverShapeConfigResult'],
             execute: str,
             executor_shape: str,
             executor_shape_configs: Sequence['outputs.GetInvokeRunsRunExecutorShapeConfigResult'],
             file_uri: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             idle_timeout_in_minutes: str,
             language: str,
             lifecycle_details: str,
             logs_bucket_uri: str,
             max_duration_in_minutes: str,
             metastore_id: str,
             num_executors: int,
             opc_request_id: str,
             owner_principal_id: str,
             owner_user_name: str,
             parameters: Sequence['outputs.GetInvokeRunsRunParameterResult'],
             pool_id: str,
             private_endpoint_dns_zones: Sequence[str],
             private_endpoint_id: str,
             private_endpoint_max_host_count: int,
             private_endpoint_nsg_ids: Sequence[str],
             private_endpoint_subnet_id: str,
             run_duration_in_milliseconds: str,
             spark_version: str,
             state: str,
             time_created: str,
             time_updated: str,
             total_ocpu: int,
             type: str,
             warehouse_bucket_uri: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'applicationId' in kwargs:
            application_id = kwargs['applicationId']
        if 'applicationLogConfigs' in kwargs:
            application_log_configs = kwargs['applicationLogConfigs']
        if 'archiveUri' in kwargs:
            archive_uri = kwargs['archiveUri']
        if 'className' in kwargs:
            class_name = kwargs['className']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'dataReadInBytes' in kwargs:
            data_read_in_bytes = kwargs['dataReadInBytes']
        if 'dataWrittenInBytes' in kwargs:
            data_written_in_bytes = kwargs['dataWrittenInBytes']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'driverShape' in kwargs:
            driver_shape = kwargs['driverShape']
        if 'driverShapeConfigs' in kwargs:
            driver_shape_configs = kwargs['driverShapeConfigs']
        if 'executorShape' in kwargs:
            executor_shape = kwargs['executorShape']
        if 'executorShapeConfigs' in kwargs:
            executor_shape_configs = kwargs['executorShapeConfigs']
        if 'fileUri' in kwargs:
            file_uri = kwargs['fileUri']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'idleTimeoutInMinutes' in kwargs:
            idle_timeout_in_minutes = kwargs['idleTimeoutInMinutes']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'logsBucketUri' in kwargs:
            logs_bucket_uri = kwargs['logsBucketUri']
        if 'maxDurationInMinutes' in kwargs:
            max_duration_in_minutes = kwargs['maxDurationInMinutes']
        if 'metastoreId' in kwargs:
            metastore_id = kwargs['metastoreId']
        if 'numExecutors' in kwargs:
            num_executors = kwargs['numExecutors']
        if 'opcRequestId' in kwargs:
            opc_request_id = kwargs['opcRequestId']
        if 'ownerPrincipalId' in kwargs:
            owner_principal_id = kwargs['ownerPrincipalId']
        if 'ownerUserName' in kwargs:
            owner_user_name = kwargs['ownerUserName']
        if 'poolId' in kwargs:
            pool_id = kwargs['poolId']
        if 'privateEndpointDnsZones' in kwargs:
            private_endpoint_dns_zones = kwargs['privateEndpointDnsZones']
        if 'privateEndpointId' in kwargs:
            private_endpoint_id = kwargs['privateEndpointId']
        if 'privateEndpointMaxHostCount' in kwargs:
            private_endpoint_max_host_count = kwargs['privateEndpointMaxHostCount']
        if 'privateEndpointNsgIds' in kwargs:
            private_endpoint_nsg_ids = kwargs['privateEndpointNsgIds']
        if 'privateEndpointSubnetId' in kwargs:
            private_endpoint_subnet_id = kwargs['privateEndpointSubnetId']
        if 'runDurationInMilliseconds' in kwargs:
            run_duration_in_milliseconds = kwargs['runDurationInMilliseconds']
        if 'sparkVersion' in kwargs:
            spark_version = kwargs['sparkVersion']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'totalOcpu' in kwargs:
            total_ocpu = kwargs['totalOcpu']
        if 'warehouseBucketUri' in kwargs:
            warehouse_bucket_uri = kwargs['warehouseBucketUri']

        _setter("application_id", application_id)
        _setter("application_log_configs", application_log_configs)
        _setter("archive_uri", archive_uri)
        _setter("arguments", arguments)
        _setter("asynchronous", asynchronous)
        _setter("class_name", class_name)
        _setter("compartment_id", compartment_id)
        _setter("configuration", configuration)
        _setter("data_read_in_bytes", data_read_in_bytes)
        _setter("data_written_in_bytes", data_written_in_bytes)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("driver_shape", driver_shape)
        _setter("driver_shape_configs", driver_shape_configs)
        _setter("execute", execute)
        _setter("executor_shape", executor_shape)
        _setter("executor_shape_configs", executor_shape_configs)
        _setter("file_uri", file_uri)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("idle_timeout_in_minutes", idle_timeout_in_minutes)
        _setter("language", language)
        _setter("lifecycle_details", lifecycle_details)
        _setter("logs_bucket_uri", logs_bucket_uri)
        _setter("max_duration_in_minutes", max_duration_in_minutes)
        _setter("metastore_id", metastore_id)
        _setter("num_executors", num_executors)
        _setter("opc_request_id", opc_request_id)
        _setter("owner_principal_id", owner_principal_id)
        _setter("owner_user_name", owner_user_name)
        _setter("parameters", parameters)
        _setter("pool_id", pool_id)
        _setter("private_endpoint_dns_zones", private_endpoint_dns_zones)
        _setter("private_endpoint_id", private_endpoint_id)
        _setter("private_endpoint_max_host_count", private_endpoint_max_host_count)
        _setter("private_endpoint_nsg_ids", private_endpoint_nsg_ids)
        _setter("private_endpoint_subnet_id", private_endpoint_subnet_id)
        _setter("run_duration_in_milliseconds", run_duration_in_milliseconds)
        _setter("spark_version", spark_version)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("total_ocpu", total_ocpu)
        _setter("type", type)
        _setter("warehouse_bucket_uri", warehouse_bucket_uri)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> str:
        """
        The ID of the application.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="applicationLogConfigs")
    def application_log_configs(self) -> Sequence['outputs.GetInvokeRunsRunApplicationLogConfigResult']:
        """
        Logging details of Application logs for Data Flow Run.
        """
        return pulumi.get(self, "application_log_configs")

    @property
    @pulumi.getter(name="archiveUri")
    def archive_uri(self) -> str:
        """
        A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "archive_uri")

    @property
    @pulumi.getter
    def arguments(self) -> Sequence[str]:
        """
        The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def asynchronous(self) -> bool:
        return pulumi.get(self, "asynchronous")

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> str:
        """
        The class for the application.
        """
        return pulumi.get(self, "class_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configuration(self) -> Mapping[str, Any]:
        """
        The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="dataReadInBytes")
    def data_read_in_bytes(self) -> str:
        """
        The data read by the run in bytes.
        """
        return pulumi.get(self, "data_read_in_bytes")

    @property
    @pulumi.getter(name="dataWrittenInBytes")
    def data_written_in_bytes(self) -> str:
        """
        The data written by the run in bytes.
        """
        return pulumi.get(self, "data_written_in_bytes")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The query parameter for the Spark application name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> str:
        """
        The VM shape for the driver. Sets the driver cores and memory.
        """
        return pulumi.get(self, "driver_shape")

    @property
    @pulumi.getter(name="driverShapeConfigs")
    def driver_shape_configs(self) -> Sequence['outputs.GetInvokeRunsRunDriverShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_configs")

    @property
    @pulumi.getter
    def execute(self) -> str:
        """
        The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        """
        return pulumi.get(self, "execute")

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> str:
        """
        The VM shape for the executors. Sets the executor cores and memory.
        """
        return pulumi.get(self, "executor_shape")

    @property
    @pulumi.getter(name="executorShapeConfigs")
    def executor_shape_configs(self) -> Sequence['outputs.GetInvokeRunsRunExecutorShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_configs")

    @property
    @pulumi.getter(name="fileUri")
    def file_uri(self) -> str:
        """
        An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "file_uri")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of a run.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> str:
        """
        The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter
    def language(self) -> str:
        """
        The Spark language.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        The detailed messages about the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="logsBucketUri")
    def logs_bucket_uri(self) -> str:
        """
        An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "logs_bucket_uri")

    @property
    @pulumi.getter(name="maxDurationInMinutes")
    def max_duration_in_minutes(self) -> str:
        """
        The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        """
        return pulumi.get(self, "max_duration_in_minutes")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> str:
        """
        The OCID of Oracle Cloud Infrastructure Hive Metastore.
        """
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter(name="numExecutors")
    def num_executors(self) -> int:
        """
        The number of executor VMs requested.
        """
        return pulumi.get(self, "num_executors")

    @property
    @pulumi.getter(name="opcRequestId")
    def opc_request_id(self) -> str:
        """
        Unique Oracle assigned identifier for the request. If you need to contact Oracle about a particular request, please provide the request ID.
        """
        return pulumi.get(self, "opc_request_id")

    @property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> str:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> str:
        """
        The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        """
        return pulumi.get(self, "owner_user_name")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetInvokeRunsRunParameterResult']:
        """
        An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> str:
        """
        The ID of the pool.
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter(name="privateEndpointDnsZones")
    def private_endpoint_dns_zones(self) -> Sequence[str]:
        """
        An array of DNS zone names. Example: `[ "app.examplecorp.com", "app.examplecorp2.com" ]`
        """
        return pulumi.get(self, "private_endpoint_dns_zones")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> str:
        """
        The OCID of a private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter(name="privateEndpointMaxHostCount")
    def private_endpoint_max_host_count(self) -> int:
        """
        The maximum number of hosts to be accessed through the private endpoint. This value is used to calculate the relevant CIDR block and should be a multiple of 256.  If the value is not a multiple of 256, it is rounded up to the next multiple of 256. For example, 300 is rounded up to 512.
        """
        return pulumi.get(self, "private_endpoint_max_host_count")

    @property
    @pulumi.getter(name="privateEndpointNsgIds")
    def private_endpoint_nsg_ids(self) -> Sequence[str]:
        """
        An array of network security group OCIDs.
        """
        return pulumi.get(self, "private_endpoint_nsg_ids")

    @property
    @pulumi.getter(name="privateEndpointSubnetId")
    def private_endpoint_subnet_id(self) -> str:
        """
        The OCID of a subnet.
        """
        return pulumi.get(self, "private_endpoint_subnet_id")

    @property
    @pulumi.getter(name="runDurationInMilliseconds")
    def run_duration_in_milliseconds(self) -> str:
        """
        The duration of the run in milliseconds.
        """
        return pulumi.get(self, "run_duration_in_milliseconds")

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> str:
        """
        The Spark version utilized to run the application.
        """
        return pulumi.get(self, "spark_version")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The LifecycleState of the run.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalOcpu")
    def total_ocpu(self) -> int:
        """
        The total number of oCPU requested by the run.
        """
        return pulumi.get(self, "total_ocpu")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The Spark application processing type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> str:
        """
        An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "warehouse_bucket_uri")


@pulumi.output_type
class GetInvokeRunsRunApplicationLogConfigResult(dict):
    def __init__(__self__, *,
                 log_group_id: str,
                 log_id: str):
        """
        :param str log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param str log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        GetInvokeRunsRunApplicationLogConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            log_group_id=log_group_id,
            log_id=log_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             log_group_id: str,
             log_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'logGroupId' in kwargs:
            log_group_id = kwargs['logGroupId']
        if 'logId' in kwargs:
            log_id = kwargs['logId']

        _setter("log_group_id", log_group_id)
        _setter("log_id", log_id)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> str:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> str:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class GetInvokeRunsRunDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetInvokeRunsRunDriverShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetInvokeRunsRunExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetInvokeRunsRunExecutorShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetInvokeRunsRunParameterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param str value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        GetInvokeRunsRunParameterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetPoolConfigurationResult(dict):
    def __init__(__self__, *,
                 max: int,
                 min: int,
                 shape: str,
                 shape_configs: Sequence['outputs.GetPoolConfigurationShapeConfigResult']):
        """
        :param int max: Maximum number of compute instances in the pool for a given compute shape.
        :param int min: Minimum number of compute instances in the pool for a given compute shape.
        :param str shape: The compute shape of the resources you would like to provision.
        :param Sequence['GetPoolConfigurationShapeConfigArgs'] shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        GetPoolConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            max=max,
            min=min,
            shape=shape,
            shape_configs=shape_configs,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             max: int,
             min: int,
             shape: str,
             shape_configs: Sequence['outputs.GetPoolConfigurationShapeConfigResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'shapeConfigs' in kwargs:
            shape_configs = kwargs['shapeConfigs']

        _setter("max", max)
        _setter("min", min)
        _setter("shape", shape)
        _setter("shape_configs", shape_configs)

    @property
    @pulumi.getter
    def max(self) -> int:
        """
        Maximum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> int:
        """
        Minimum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        The compute shape of the resources you would like to provision.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="shapeConfigs")
    def shape_configs(self) -> Sequence['outputs.GetPoolConfigurationShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "shape_configs")


@pulumi.output_type
class GetPoolConfigurationShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetPoolConfigurationShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetPoolPoolMetricResult(dict):
    def __init__(__self__, *,
                 active_runs_count: str,
                 actively_used_node_counts: Sequence['outputs.GetPoolPoolMetricActivelyUsedNodeCountResult'],
                 time_last_metrics_updated: str,
                 time_last_started: str,
                 time_last_stopped: str,
                 time_last_used: str):
        """
        :param str active_runs_count: The number of runs that are currently running that are using this pool.
        :param Sequence['GetPoolPoolMetricActivelyUsedNodeCountArgs'] actively_used_node_counts: A count of the nodes that are currently being used for each shape in this pool.
        :param str time_last_metrics_updated: The last time the mertics were updated for this.
        :param str time_last_started: The last time this pool was started.
        :param str time_last_stopped: The last time this pool was stopped.
        :param str time_last_used: The last time a run used this pool.
        """
        GetPoolPoolMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            active_runs_count=active_runs_count,
            actively_used_node_counts=actively_used_node_counts,
            time_last_metrics_updated=time_last_metrics_updated,
            time_last_started=time_last_started,
            time_last_stopped=time_last_stopped,
            time_last_used=time_last_used,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             active_runs_count: str,
             actively_used_node_counts: Sequence['outputs.GetPoolPoolMetricActivelyUsedNodeCountResult'],
             time_last_metrics_updated: str,
             time_last_started: str,
             time_last_stopped: str,
             time_last_used: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'activeRunsCount' in kwargs:
            active_runs_count = kwargs['activeRunsCount']
        if 'activelyUsedNodeCounts' in kwargs:
            actively_used_node_counts = kwargs['activelyUsedNodeCounts']
        if 'timeLastMetricsUpdated' in kwargs:
            time_last_metrics_updated = kwargs['timeLastMetricsUpdated']
        if 'timeLastStarted' in kwargs:
            time_last_started = kwargs['timeLastStarted']
        if 'timeLastStopped' in kwargs:
            time_last_stopped = kwargs['timeLastStopped']
        if 'timeLastUsed' in kwargs:
            time_last_used = kwargs['timeLastUsed']

        _setter("active_runs_count", active_runs_count)
        _setter("actively_used_node_counts", actively_used_node_counts)
        _setter("time_last_metrics_updated", time_last_metrics_updated)
        _setter("time_last_started", time_last_started)
        _setter("time_last_stopped", time_last_stopped)
        _setter("time_last_used", time_last_used)

    @property
    @pulumi.getter(name="activeRunsCount")
    def active_runs_count(self) -> str:
        """
        The number of runs that are currently running that are using this pool.
        """
        return pulumi.get(self, "active_runs_count")

    @property
    @pulumi.getter(name="activelyUsedNodeCounts")
    def actively_used_node_counts(self) -> Sequence['outputs.GetPoolPoolMetricActivelyUsedNodeCountResult']:
        """
        A count of the nodes that are currently being used for each shape in this pool.
        """
        return pulumi.get(self, "actively_used_node_counts")

    @property
    @pulumi.getter(name="timeLastMetricsUpdated")
    def time_last_metrics_updated(self) -> str:
        """
        The last time the mertics were updated for this.
        """
        return pulumi.get(self, "time_last_metrics_updated")

    @property
    @pulumi.getter(name="timeLastStarted")
    def time_last_started(self) -> str:
        """
        The last time this pool was started.
        """
        return pulumi.get(self, "time_last_started")

    @property
    @pulumi.getter(name="timeLastStopped")
    def time_last_stopped(self) -> str:
        """
        The last time this pool was stopped.
        """
        return pulumi.get(self, "time_last_stopped")

    @property
    @pulumi.getter(name="timeLastUsed")
    def time_last_used(self) -> str:
        """
        The last time a run used this pool.
        """
        return pulumi.get(self, "time_last_used")


@pulumi.output_type
class GetPoolPoolMetricActivelyUsedNodeCountResult(dict):
    def __init__(__self__, *,
                 logical_shape: str,
                 pool_count: int):
        """
        :param str logical_shape: The compute shape of the nodes that the count is for.
        :param int pool_count: The node count of this compute shape.
        """
        GetPoolPoolMetricActivelyUsedNodeCountResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            logical_shape=logical_shape,
            pool_count=pool_count,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             logical_shape: str,
             pool_count: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'logicalShape' in kwargs:
            logical_shape = kwargs['logicalShape']
        if 'poolCount' in kwargs:
            pool_count = kwargs['poolCount']

        _setter("logical_shape", logical_shape)
        _setter("pool_count", pool_count)

    @property
    @pulumi.getter(name="logicalShape")
    def logical_shape(self) -> str:
        """
        The compute shape of the nodes that the count is for.
        """
        return pulumi.get(self, "logical_shape")

    @property
    @pulumi.getter(name="poolCount")
    def pool_count(self) -> int:
        """
        The node count of this compute shape.
        """
        return pulumi.get(self, "pool_count")


@pulumi.output_type
class GetPoolScheduleResult(dict):
    def __init__(__self__, *,
                 day_of_week: str,
                 start_time: int,
                 stop_time: int):
        """
        :param str day_of_week: Day of the week SUN-SAT
        :param int start_time: Hour of the day to start or stop pool.
        :param int stop_time: Hour of the day to stop the pool.
        """
        GetPoolScheduleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            day_of_week=day_of_week,
            start_time=start_time,
            stop_time=stop_time,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             day_of_week: str,
             start_time: int,
             stop_time: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'dayOfWeek' in kwargs:
            day_of_week = kwargs['dayOfWeek']
        if 'startTime' in kwargs:
            start_time = kwargs['startTime']
        if 'stopTime' in kwargs:
            stop_time = kwargs['stopTime']

        _setter("day_of_week", day_of_week)
        _setter("start_time", start_time)
        _setter("stop_time", stop_time)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> str:
        """
        Day of the week SUN-SAT
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> int:
        """
        Hour of the day to start or stop pool.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="stopTime")
    def stop_time(self) -> int:
        """
        Hour of the day to stop the pool.
        """
        return pulumi.get(self, "stop_time")


@pulumi.output_type
class GetPoolsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetPoolsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPoolsPoolCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetPoolsPoolCollectionItemResult']):
        GetPoolsPoolCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetPoolsPoolCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetPoolsPoolCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetPoolsPoolCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 configurations: Sequence['outputs.GetPoolsPoolCollectionItemConfigurationResult'],
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 idle_timeout_in_minutes: int,
                 lifecycle_details: str,
                 owner_principal_id: str,
                 owner_user_name: str,
                 pool_metrics: Sequence['outputs.GetPoolsPoolCollectionItemPoolMetricResult'],
                 schedules: Sequence['outputs.GetPoolsPoolCollectionItemScheduleResult'],
                 state: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The OCID of the compartment.
        :param Sequence['GetPoolsPoolCollectionItemConfigurationArgs'] configurations: List of PoolConfig items.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str description: A user-friendly description. Avoid entering confidential information.
        :param str display_name: The query parameter for the Spark application name.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        :param int idle_timeout_in_minutes: Optional timeout value in minutes used to auto stop Pools. A Pool will be auto stopped after inactivity for this amount of time period. If value not set, pool will not be auto stopped auto.
        :param str lifecycle_details: The detailed messages about the lifecycle state.
        :param str owner_principal_id: The OCID of the user who created the resource.
        :param str owner_user_name: The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        :param Sequence['GetPoolsPoolCollectionItemPoolMetricArgs'] pool_metrics: A collection of metrics related to a particular pool.
        :param Sequence['GetPoolsPoolCollectionItemScheduleArgs'] schedules: A list of schedules for pool to auto start and stop.
        :param str state: The LifecycleState of the pool.
        :param str time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param str time_updated: The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        GetPoolsPoolCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            configurations=configurations,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            idle_timeout_in_minutes=idle_timeout_in_minutes,
            lifecycle_details=lifecycle_details,
            owner_principal_id=owner_principal_id,
            owner_user_name=owner_user_name,
            pool_metrics=pool_metrics,
            schedules=schedules,
            state=state,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             configurations: Sequence['outputs.GetPoolsPoolCollectionItemConfigurationResult'],
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             idle_timeout_in_minutes: int,
             lifecycle_details: str,
             owner_principal_id: str,
             owner_user_name: str,
             pool_metrics: Sequence['outputs.GetPoolsPoolCollectionItemPoolMetricResult'],
             schedules: Sequence['outputs.GetPoolsPoolCollectionItemScheduleResult'],
             state: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'idleTimeoutInMinutes' in kwargs:
            idle_timeout_in_minutes = kwargs['idleTimeoutInMinutes']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'ownerPrincipalId' in kwargs:
            owner_principal_id = kwargs['ownerPrincipalId']
        if 'ownerUserName' in kwargs:
            owner_user_name = kwargs['ownerUserName']
        if 'poolMetrics' in kwargs:
            pool_metrics = kwargs['poolMetrics']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("compartment_id", compartment_id)
        _setter("configurations", configurations)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("idle_timeout_in_minutes", idle_timeout_in_minutes)
        _setter("lifecycle_details", lifecycle_details)
        _setter("owner_principal_id", owner_principal_id)
        _setter("owner_user_name", owner_user_name)
        _setter("pool_metrics", pool_metrics)
        _setter("schedules", schedules)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetPoolsPoolCollectionItemConfigurationResult']:
        """
        List of PoolConfig items.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-friendly description. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The query parameter for the Spark application name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> int:
        """
        Optional timeout value in minutes used to auto stop Pools. A Pool will be auto stopped after inactivity for this amount of time period. If value not set, pool will not be auto stopped auto.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        The detailed messages about the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> str:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> str:
        """
        The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        """
        return pulumi.get(self, "owner_user_name")

    @property
    @pulumi.getter(name="poolMetrics")
    def pool_metrics(self) -> Sequence['outputs.GetPoolsPoolCollectionItemPoolMetricResult']:
        """
        A collection of metrics related to a particular pool.
        """
        return pulumi.get(self, "pool_metrics")

    @property
    @pulumi.getter
    def schedules(self) -> Sequence['outputs.GetPoolsPoolCollectionItemScheduleResult']:
        """
        A list of schedules for pool to auto start and stop.
        """
        return pulumi.get(self, "schedules")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The LifecycleState of the pool.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetPoolsPoolCollectionItemConfigurationResult(dict):
    def __init__(__self__, *,
                 max: int,
                 min: int,
                 shape: str,
                 shape_configs: Sequence['outputs.GetPoolsPoolCollectionItemConfigurationShapeConfigResult']):
        """
        :param int max: Maximum number of compute instances in the pool for a given compute shape.
        :param int min: Minimum number of compute instances in the pool for a given compute shape.
        :param str shape: The compute shape of the resources you would like to provision.
        :param Sequence['GetPoolsPoolCollectionItemConfigurationShapeConfigArgs'] shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        GetPoolsPoolCollectionItemConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            max=max,
            min=min,
            shape=shape,
            shape_configs=shape_configs,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             max: int,
             min: int,
             shape: str,
             shape_configs: Sequence['outputs.GetPoolsPoolCollectionItemConfigurationShapeConfigResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'shapeConfigs' in kwargs:
            shape_configs = kwargs['shapeConfigs']

        _setter("max", max)
        _setter("min", min)
        _setter("shape", shape)
        _setter("shape_configs", shape_configs)

    @property
    @pulumi.getter
    def max(self) -> int:
        """
        Maximum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> int:
        """
        Minimum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        The compute shape of the resources you would like to provision.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="shapeConfigs")
    def shape_configs(self) -> Sequence['outputs.GetPoolsPoolCollectionItemConfigurationShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "shape_configs")


@pulumi.output_type
class GetPoolsPoolCollectionItemConfigurationShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetPoolsPoolCollectionItemConfigurationShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetPoolsPoolCollectionItemPoolMetricResult(dict):
    def __init__(__self__, *,
                 active_runs_count: str,
                 actively_used_node_counts: Sequence['outputs.GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountResult'],
                 time_last_metrics_updated: str,
                 time_last_started: str,
                 time_last_stopped: str,
                 time_last_used: str):
        """
        :param str active_runs_count: The number of runs that are currently running that are using this pool.
        :param Sequence['GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountArgs'] actively_used_node_counts: A count of the nodes that are currently being used for each shape in this pool.
        :param str time_last_metrics_updated: The last time the mertics were updated for this.
        :param str time_last_started: The last time this pool was started.
        :param str time_last_stopped: The last time this pool was stopped.
        :param str time_last_used: The last time a run used this pool.
        """
        GetPoolsPoolCollectionItemPoolMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            active_runs_count=active_runs_count,
            actively_used_node_counts=actively_used_node_counts,
            time_last_metrics_updated=time_last_metrics_updated,
            time_last_started=time_last_started,
            time_last_stopped=time_last_stopped,
            time_last_used=time_last_used,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             active_runs_count: str,
             actively_used_node_counts: Sequence['outputs.GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountResult'],
             time_last_metrics_updated: str,
             time_last_started: str,
             time_last_stopped: str,
             time_last_used: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'activeRunsCount' in kwargs:
            active_runs_count = kwargs['activeRunsCount']
        if 'activelyUsedNodeCounts' in kwargs:
            actively_used_node_counts = kwargs['activelyUsedNodeCounts']
        if 'timeLastMetricsUpdated' in kwargs:
            time_last_metrics_updated = kwargs['timeLastMetricsUpdated']
        if 'timeLastStarted' in kwargs:
            time_last_started = kwargs['timeLastStarted']
        if 'timeLastStopped' in kwargs:
            time_last_stopped = kwargs['timeLastStopped']
        if 'timeLastUsed' in kwargs:
            time_last_used = kwargs['timeLastUsed']

        _setter("active_runs_count", active_runs_count)
        _setter("actively_used_node_counts", actively_used_node_counts)
        _setter("time_last_metrics_updated", time_last_metrics_updated)
        _setter("time_last_started", time_last_started)
        _setter("time_last_stopped", time_last_stopped)
        _setter("time_last_used", time_last_used)

    @property
    @pulumi.getter(name="activeRunsCount")
    def active_runs_count(self) -> str:
        """
        The number of runs that are currently running that are using this pool.
        """
        return pulumi.get(self, "active_runs_count")

    @property
    @pulumi.getter(name="activelyUsedNodeCounts")
    def actively_used_node_counts(self) -> Sequence['outputs.GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountResult']:
        """
        A count of the nodes that are currently being used for each shape in this pool.
        """
        return pulumi.get(self, "actively_used_node_counts")

    @property
    @pulumi.getter(name="timeLastMetricsUpdated")
    def time_last_metrics_updated(self) -> str:
        """
        The last time the mertics were updated for this.
        """
        return pulumi.get(self, "time_last_metrics_updated")

    @property
    @pulumi.getter(name="timeLastStarted")
    def time_last_started(self) -> str:
        """
        The last time this pool was started.
        """
        return pulumi.get(self, "time_last_started")

    @property
    @pulumi.getter(name="timeLastStopped")
    def time_last_stopped(self) -> str:
        """
        The last time this pool was stopped.
        """
        return pulumi.get(self, "time_last_stopped")

    @property
    @pulumi.getter(name="timeLastUsed")
    def time_last_used(self) -> str:
        """
        The last time a run used this pool.
        """
        return pulumi.get(self, "time_last_used")


@pulumi.output_type
class GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountResult(dict):
    def __init__(__self__, *,
                 logical_shape: str,
                 pool_count: int):
        """
        :param str logical_shape: The compute shape of the nodes that the count is for.
        :param int pool_count: The node count of this compute shape.
        """
        GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            logical_shape=logical_shape,
            pool_count=pool_count,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             logical_shape: str,
             pool_count: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'logicalShape' in kwargs:
            logical_shape = kwargs['logicalShape']
        if 'poolCount' in kwargs:
            pool_count = kwargs['poolCount']

        _setter("logical_shape", logical_shape)
        _setter("pool_count", pool_count)

    @property
    @pulumi.getter(name="logicalShape")
    def logical_shape(self) -> str:
        """
        The compute shape of the nodes that the count is for.
        """
        return pulumi.get(self, "logical_shape")

    @property
    @pulumi.getter(name="poolCount")
    def pool_count(self) -> int:
        """
        The node count of this compute shape.
        """
        return pulumi.get(self, "pool_count")


@pulumi.output_type
class GetPoolsPoolCollectionItemScheduleResult(dict):
    def __init__(__self__, *,
                 day_of_week: str,
                 start_time: int,
                 stop_time: int):
        """
        :param str day_of_week: Day of the week SUN-SAT
        :param int start_time: Hour of the day to start or stop pool.
        :param int stop_time: Hour of the day to stop the pool.
        """
        GetPoolsPoolCollectionItemScheduleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            day_of_week=day_of_week,
            start_time=start_time,
            stop_time=stop_time,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             day_of_week: str,
             start_time: int,
             stop_time: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'dayOfWeek' in kwargs:
            day_of_week = kwargs['dayOfWeek']
        if 'startTime' in kwargs:
            start_time = kwargs['startTime']
        if 'stopTime' in kwargs:
            stop_time = kwargs['stopTime']

        _setter("day_of_week", day_of_week)
        _setter("start_time", start_time)
        _setter("stop_time", stop_time)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> str:
        """
        Day of the week SUN-SAT
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> int:
        """
        Hour of the day to start or stop pool.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="stopTime")
    def stop_time(self) -> int:
        """
        Hour of the day to stop the pool.
        """
        return pulumi.get(self, "stop_time")


@pulumi.output_type
class GetPrivateEndpointScanDetailResult(dict):
    def __init__(__self__, *,
                 fqdn: str,
                 port: str):
        """
        :param str fqdn: A fully-qualified domain name (FQDN).
        :param str port: The port number of the FQDN
        """
        GetPrivateEndpointScanDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            fqdn=fqdn,
            port=port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             fqdn: str,
             port: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("fqdn", fqdn)
        _setter("port", port)

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        A fully-qualified domain name (FQDN).
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        The port number of the FQDN
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetPrivateEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetPrivateEndpointsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPrivateEndpointsPrivateEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemResult']):
        GetPrivateEndpointsPrivateEndpointCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetPrivateEndpointsPrivateEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 dns_zones: Sequence[str],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_details: str,
                 max_host_count: int,
                 nsg_ids: Sequence[str],
                 owner_principal_id: str,
                 owner_user_name: str,
                 scan_details: Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailResult'],
                 state: str,
                 subnet_id: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The OCID of the compartment.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str description: A user-friendly description. Avoid entering confidential information.
        :param str display_name: The query parameter for the Spark application name. Note: At a time only one optional filter can be used with `compartment_id` to get the list of Private Endpoint resources.
        :param Sequence[str] dns_zones: An array of DNS zone names. Example: `[ "app.examplecorp.com", "app.examplecorp2.com" ]`
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of a private endpoint.
        :param str lifecycle_details: The detailed messages about the lifecycle state.
        :param int max_host_count: The maximum number of hosts to be accessed through the private endpoint. This value is used to calculate the relevant CIDR block and should be a multiple of 256.  If the value is not a multiple of 256, it is rounded up to the next multiple of 256. For example, 300 is rounded up to 512.
        :param Sequence[str] nsg_ids: An array of network security group OCIDs.
        :param str owner_principal_id: The OCID of the user who created the resource.
        :param str owner_user_name: The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        :param Sequence['GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailArgs'] scan_details: An array of fqdn/port pairs used to create private endpoint. Each object is a simple key-value pair with FQDN as key and port number as value. [ { fqdn: "scan1.oracle.com", port: "1521"}, { fqdn: "scan2.oracle.com", port: "1521" } ]
        :param str state: The LifecycleState of the private endpoint.
        :param str subnet_id: The OCID of a subnet.
        :param str time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param str time_updated: The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        GetPrivateEndpointsPrivateEndpointCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            dns_zones=dns_zones,
            freeform_tags=freeform_tags,
            id=id,
            lifecycle_details=lifecycle_details,
            max_host_count=max_host_count,
            nsg_ids=nsg_ids,
            owner_principal_id=owner_principal_id,
            owner_user_name=owner_user_name,
            scan_details=scan_details,
            state=state,
            subnet_id=subnet_id,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             dns_zones: Sequence[str],
             freeform_tags: Mapping[str, Any],
             id: str,
             lifecycle_details: str,
             max_host_count: int,
             nsg_ids: Sequence[str],
             owner_principal_id: str,
             owner_user_name: str,
             scan_details: Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailResult'],
             state: str,
             subnet_id: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'dnsZones' in kwargs:
            dns_zones = kwargs['dnsZones']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'maxHostCount' in kwargs:
            max_host_count = kwargs['maxHostCount']
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']
        if 'ownerPrincipalId' in kwargs:
            owner_principal_id = kwargs['ownerPrincipalId']
        if 'ownerUserName' in kwargs:
            owner_user_name = kwargs['ownerUserName']
        if 'scanDetails' in kwargs:
            scan_details = kwargs['scanDetails']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("dns_zones", dns_zones)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("lifecycle_details", lifecycle_details)
        _setter("max_host_count", max_host_count)
        _setter("nsg_ids", nsg_ids)
        _setter("owner_principal_id", owner_principal_id)
        _setter("owner_user_name", owner_user_name)
        _setter("scan_details", scan_details)
        _setter("state", state)
        _setter("subnet_id", subnet_id)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-friendly description. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The query parameter for the Spark application name. Note: At a time only one optional filter can be used with `compartment_id` to get the list of Private Endpoint resources.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsZones")
    def dns_zones(self) -> Sequence[str]:
        """
        An array of DNS zone names. Example: `[ "app.examplecorp.com", "app.examplecorp2.com" ]`
        """
        return pulumi.get(self, "dns_zones")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of a private endpoint.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        The detailed messages about the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maxHostCount")
    def max_host_count(self) -> int:
        """
        The maximum number of hosts to be accessed through the private endpoint. This value is used to calculate the relevant CIDR block and should be a multiple of 256.  If the value is not a multiple of 256, it is rounded up to the next multiple of 256. For example, 300 is rounded up to 512.
        """
        return pulumi.get(self, "max_host_count")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        An array of network security group OCIDs.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> str:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> str:
        """
        The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        """
        return pulumi.get(self, "owner_user_name")

    @property
    @pulumi.getter(name="scanDetails")
    def scan_details(self) -> Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailResult']:
        """
        An array of fqdn/port pairs used to create private endpoint. Each object is a simple key-value pair with FQDN as key and port number as value. [ { fqdn: "scan1.oracle.com", port: "1521"}, { fqdn: "scan2.oracle.com", port: "1521" } ]
        """
        return pulumi.get(self, "scan_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The LifecycleState of the private endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of a subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailResult(dict):
    def __init__(__self__, *,
                 fqdn: str,
                 port: str):
        """
        :param str fqdn: A fully-qualified domain name (FQDN).
        :param str port: The port number of the FQDN
        """
        GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            fqdn=fqdn,
            port=port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             fqdn: str,
             port: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("fqdn", fqdn)
        _setter("port", port)

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        A fully-qualified domain name (FQDN).
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        The port number of the FQDN
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetRunLogsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetRunLogsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRunLogsRunLogResult(dict):
    def __init__(__self__, *,
                 name: str,
                 run_id: str,
                 size_in_bytes: str,
                 source: str,
                 time_created: str,
                 type: str):
        """
        :param str run_id: The unique ID for the run
        """
        GetRunLogsRunLogResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            run_id=run_id,
            size_in_bytes=size_in_bytes,
            source=source,
            time_created=time_created,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             run_id: str,
             size_in_bytes: str,
             source: str,
             time_created: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'runId' in kwargs:
            run_id = kwargs['runId']
        if 'sizeInBytes' in kwargs:
            size_in_bytes = kwargs['sizeInBytes']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("name", name)
        _setter("run_id", run_id)
        _setter("size_in_bytes", size_in_bytes)
        _setter("source", source)
        _setter("time_created", time_created)
        _setter("type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> str:
        """
        The unique ID for the run
        """
        return pulumi.get(self, "run_id")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> str:
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter
    def source(self) -> str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRunStatementOutputResult(dict):
    def __init__(__self__, *,
                 datas: Sequence['outputs.GetRunStatementOutputDataResult'],
                 error_name: str,
                 error_value: str,
                 status: str,
                 tracebacks: Sequence[str]):
        """
        :param Sequence['GetRunStatementOutputDataArgs'] datas: An object representing execution output of a statement.
        :param str error_name: The name of the error in the statement output.
        :param str error_value: The value of the error in the statement output.
        :param str status: Status of the statement output.
        :param Sequence[str] tracebacks: The traceback of the statement output.
        """
        GetRunStatementOutputResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            datas=datas,
            error_name=error_name,
            error_value=error_value,
            status=status,
            tracebacks=tracebacks,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             datas: Sequence['outputs.GetRunStatementOutputDataResult'],
             error_name: str,
             error_value: str,
             status: str,
             tracebacks: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'errorName' in kwargs:
            error_name = kwargs['errorName']
        if 'errorValue' in kwargs:
            error_value = kwargs['errorValue']

        _setter("datas", datas)
        _setter("error_name", error_name)
        _setter("error_value", error_value)
        _setter("status", status)
        _setter("tracebacks", tracebacks)

    @property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.GetRunStatementOutputDataResult']:
        """
        An object representing execution output of a statement.
        """
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter(name="errorName")
    def error_name(self) -> str:
        """
        The name of the error in the statement output.
        """
        return pulumi.get(self, "error_name")

    @property
    @pulumi.getter(name="errorValue")
    def error_value(self) -> str:
        """
        The value of the error in the statement output.
        """
        return pulumi.get(self, "error_value")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the statement output.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tracebacks(self) -> Sequence[str]:
        """
        The traceback of the statement output.
        """
        return pulumi.get(self, "tracebacks")


@pulumi.output_type
class GetRunStatementOutputDataResult(dict):
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        :param str type: The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        :param str value: The statement code execution output in html format.
        """
        GetRunStatementOutputDataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("type", type)
        _setter("value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The statement code execution output in html format.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetRunStatementsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetRunStatementsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRunStatementsStatementCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRunStatementsStatementCollectionItemResult']):
        GetRunStatementsStatementCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetRunStatementsStatementCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRunStatementsStatementCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRunStatementsStatementCollectionItemResult(dict):
    def __init__(__self__, *,
                 code: str,
                 id: str,
                 outputs: Sequence['outputs.GetRunStatementsStatementCollectionItemOutputResult'],
                 progress: float,
                 run_id: str,
                 state: str,
                 time_completed: str,
                 time_created: str):
        """
        :param str code: The statement code to execute. Example: `println(sc.version)`
        :param str id: The statement ID.
        :param Sequence['GetRunStatementsStatementCollectionItemOutputArgs'] outputs: The execution output of a statement.
        :param float progress: The execution progress.
        :param str run_id: The unique ID for the run
        :param str state: The LifecycleState of the statement.
        :param str time_completed: The date and time a statement execution was completed, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2022-05-31T21:10:29.600Z`
        :param str time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        GetRunStatementsStatementCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            code=code,
            id=id,
            outputs=outputs,
            progress=progress,
            run_id=run_id,
            state=state,
            time_completed=time_completed,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             code: str,
             id: str,
             outputs: Sequence['outputs.GetRunStatementsStatementCollectionItemOutputResult'],
             progress: float,
             run_id: str,
             state: str,
             time_completed: str,
             time_created: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'runId' in kwargs:
            run_id = kwargs['runId']
        if 'timeCompleted' in kwargs:
            time_completed = kwargs['timeCompleted']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("code", code)
        _setter("id", id)
        _setter("outputs", outputs)
        _setter("progress", progress)
        _setter("run_id", run_id)
        _setter("state", state)
        _setter("time_completed", time_completed)
        _setter("time_created", time_created)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The statement code to execute. Example: `println(sc.version)`
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The statement ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def outputs(self) -> Sequence['outputs.GetRunStatementsStatementCollectionItemOutputResult']:
        """
        The execution output of a statement.
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter
    def progress(self) -> float:
        """
        The execution progress.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> str:
        """
        The unique ID for the run
        """
        return pulumi.get(self, "run_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The LifecycleState of the statement.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCompleted")
    def time_completed(self) -> str:
        """
        The date and time a statement execution was completed, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2022-05-31T21:10:29.600Z`
        """
        return pulumi.get(self, "time_completed")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetRunStatementsStatementCollectionItemOutputResult(dict):
    def __init__(__self__, *,
                 datas: Sequence['outputs.GetRunStatementsStatementCollectionItemOutputDataResult'],
                 error_name: str,
                 error_value: str,
                 status: str,
                 tracebacks: Sequence[str]):
        """
        :param Sequence['GetRunStatementsStatementCollectionItemOutputDataArgs'] datas: An object representing execution output of a statement.
        :param str error_name: The name of the error in the statement output.
        :param str error_value: The value of the error in the statement output.
        :param str status: Status of the statement output.
        :param Sequence[str] tracebacks: The traceback of the statement output.
        """
        GetRunStatementsStatementCollectionItemOutputResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            datas=datas,
            error_name=error_name,
            error_value=error_value,
            status=status,
            tracebacks=tracebacks,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             datas: Sequence['outputs.GetRunStatementsStatementCollectionItemOutputDataResult'],
             error_name: str,
             error_value: str,
             status: str,
             tracebacks: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'errorName' in kwargs:
            error_name = kwargs['errorName']
        if 'errorValue' in kwargs:
            error_value = kwargs['errorValue']

        _setter("datas", datas)
        _setter("error_name", error_name)
        _setter("error_value", error_value)
        _setter("status", status)
        _setter("tracebacks", tracebacks)

    @property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.GetRunStatementsStatementCollectionItemOutputDataResult']:
        """
        An object representing execution output of a statement.
        """
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter(name="errorName")
    def error_name(self) -> str:
        """
        The name of the error in the statement output.
        """
        return pulumi.get(self, "error_name")

    @property
    @pulumi.getter(name="errorValue")
    def error_value(self) -> str:
        """
        The value of the error in the statement output.
        """
        return pulumi.get(self, "error_value")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the statement output.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tracebacks(self) -> Sequence[str]:
        """
        The traceback of the statement output.
        """
        return pulumi.get(self, "tracebacks")


@pulumi.output_type
class GetRunStatementsStatementCollectionItemOutputDataResult(dict):
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        :param str type: The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        :param str value: The statement code execution output in html format.
        """
        GetRunStatementsStatementCollectionItemOutputDataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("type", type)
        _setter("value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The statement code execution output in html format.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetSqlEndpointDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetSqlEndpointDriverShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetSqlEndpointExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetSqlEndpointExecutorShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetSqlEndpointNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 access_control_rules: Sequence['outputs.GetSqlEndpointNetworkConfigurationAccessControlRuleResult'],
                 host_name_prefix: str,
                 network_type: str,
                 private_endpoint_ip: str,
                 public_endpoint_ip: str,
                 subnet_id: str,
                 vcn_id: str):
        """
        :param Sequence['GetSqlEndpointNetworkConfigurationAccessControlRuleArgs'] access_control_rules: A list of SecureAccessControlRule's to which access is limited to
        :param str host_name_prefix: The host name prefix.
        :param str network_type: The type of network configuration.
        :param str private_endpoint_ip: Ip Address of private endpoint
        :param str public_endpoint_ip: Ip Address of public endpoint
        :param str subnet_id: The VCN Subnet OCID.
        :param str vcn_id: The VCN OCID.
        """
        GetSqlEndpointNetworkConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_control_rules=access_control_rules,
            host_name_prefix=host_name_prefix,
            network_type=network_type,
            private_endpoint_ip=private_endpoint_ip,
            public_endpoint_ip=public_endpoint_ip,
            subnet_id=subnet_id,
            vcn_id=vcn_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_control_rules: Sequence['outputs.GetSqlEndpointNetworkConfigurationAccessControlRuleResult'],
             host_name_prefix: str,
             network_type: str,
             private_endpoint_ip: str,
             public_endpoint_ip: str,
             subnet_id: str,
             vcn_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'accessControlRules' in kwargs:
            access_control_rules = kwargs['accessControlRules']
        if 'hostNamePrefix' in kwargs:
            host_name_prefix = kwargs['hostNamePrefix']
        if 'networkType' in kwargs:
            network_type = kwargs['networkType']
        if 'privateEndpointIp' in kwargs:
            private_endpoint_ip = kwargs['privateEndpointIp']
        if 'publicEndpointIp' in kwargs:
            public_endpoint_ip = kwargs['publicEndpointIp']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'vcnId' in kwargs:
            vcn_id = kwargs['vcnId']

        _setter("access_control_rules", access_control_rules)
        _setter("host_name_prefix", host_name_prefix)
        _setter("network_type", network_type)
        _setter("private_endpoint_ip", private_endpoint_ip)
        _setter("public_endpoint_ip", public_endpoint_ip)
        _setter("subnet_id", subnet_id)
        _setter("vcn_id", vcn_id)

    @property
    @pulumi.getter(name="accessControlRules")
    def access_control_rules(self) -> Sequence['outputs.GetSqlEndpointNetworkConfigurationAccessControlRuleResult']:
        """
        A list of SecureAccessControlRule's to which access is limited to
        """
        return pulumi.get(self, "access_control_rules")

    @property
    @pulumi.getter(name="hostNamePrefix")
    def host_name_prefix(self) -> str:
        """
        The host name prefix.
        """
        return pulumi.get(self, "host_name_prefix")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        The type of network configuration.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> str:
        """
        Ip Address of private endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter(name="publicEndpointIp")
    def public_endpoint_ip(self) -> str:
        """
        Ip Address of public endpoint
        """
        return pulumi.get(self, "public_endpoint_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The VCN Subnet OCID.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        The VCN OCID.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetSqlEndpointNetworkConfigurationAccessControlRuleResult(dict):
    def __init__(__self__, *,
                 ip_notation: str,
                 value: str,
                 vcn_ips: str):
        """
        :param str ip_notation: The type of IP notation.
        :param str value: The associated value of the selected IP notation.
        :param str vcn_ips: A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        GetSqlEndpointNetworkConfigurationAccessControlRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ip_notation=ip_notation,
            value=value,
            vcn_ips=vcn_ips,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ip_notation: str,
             value: str,
             vcn_ips: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ipNotation' in kwargs:
            ip_notation = kwargs['ipNotation']
        if 'vcnIps' in kwargs:
            vcn_ips = kwargs['vcnIps']

        _setter("ip_notation", ip_notation)
        _setter("value", value)
        _setter("vcn_ips", vcn_ips)

    @property
    @pulumi.getter(name="ipNotation")
    def ip_notation(self) -> str:
        """
        The type of IP notation.
        """
        return pulumi.get(self, "ip_notation")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The associated value of the selected IP notation.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="vcnIps")
    def vcn_ips(self) -> str:
        """
        A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        return pulumi.get(self, "vcn_ips")


@pulumi.output_type
class GetSqlEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetSqlEndpointsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemResult']):
        GetSqlEndpointsSqlEndpointCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 driver_shape: str,
                 driver_shape_configs: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigResult'],
                 executor_shape: str,
                 executor_shape_configs: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigResult'],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 jdbc_endpoint_url: str,
                 lake_id: str,
                 last_accepted_request_token: str,
                 max_executor_count: int,
                 metastore_id: str,
                 min_executor_count: int,
                 network_configurations: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationResult'],
                 spark_advanced_configurations: Mapping[str, Any],
                 sql_endpoint_version: str,
                 state: str,
                 state_message: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str,
                 warehouse_bucket_uri: str):
        """
        :param str compartment_id: The OCID of the compartment in which to query resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str description: The description of the SQL Endpoint.
        :param str display_name: The query parameter for the Spark application name.
        :param str driver_shape: The shape of the SQL Endpoint driver instance.
        :param Sequence['GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigArgs'] driver_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param str executor_shape: The shape of the SQL Endpoint executor instance.
        :param Sequence['GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigArgs'] executor_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The provision identifier that is immutable on creation.
        :param str jdbc_endpoint_url: The JDBC URL field. For example, jdbc:spark://{serviceFQDN}:443/default;SparkServerType=DFI
        :param str lake_id: The OCID of Oracle Cloud Infrastructure Lake.
        :param str last_accepted_request_token: This token is used by Splat, and indicates that the service accepts the request, and that the request is currently being processed.
        :param int max_executor_count: The maximum number of executors.
        :param str metastore_id: The OCID of Oracle Cloud Infrastructure Hive Metastore.
        :param int min_executor_count: The minimum number of executors.
        :param Sequence['GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationArgs'] network_configurations: The network configuration of a SQL Endpoint.
        :param Mapping[str, Any] spark_advanced_configurations: The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param str sql_endpoint_version: The version of SQL Endpoint.
        :param str state: A filter to return only those resources whose sqlEndpointLifecycleState matches the given sqlEndpointLifecycleState.
        :param str state_message: A message describing the reason why the resource is in it's current state. Helps bubble up errors in state changes. For example, it can be used to provide actionable information for a resource in the Failed state.
        :param Mapping[str, Any] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param str time_created: The time the Sql Endpoint was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time the Sql Endpoint was updated. An RFC3339 formatted datetime string.
        :param str warehouse_bucket_uri: The warehouse bucket URI. It is a Oracle Cloud Infrastructure Object Storage bucket URI as defined here https://docs.oracle.com/en/cloud/paas/atp-cloud/atpud/object-storage-uris.html
        """
        GetSqlEndpointsSqlEndpointCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            driver_shape=driver_shape,
            driver_shape_configs=driver_shape_configs,
            executor_shape=executor_shape,
            executor_shape_configs=executor_shape_configs,
            freeform_tags=freeform_tags,
            id=id,
            jdbc_endpoint_url=jdbc_endpoint_url,
            lake_id=lake_id,
            last_accepted_request_token=last_accepted_request_token,
            max_executor_count=max_executor_count,
            metastore_id=metastore_id,
            min_executor_count=min_executor_count,
            network_configurations=network_configurations,
            spark_advanced_configurations=spark_advanced_configurations,
            sql_endpoint_version=sql_endpoint_version,
            state=state,
            state_message=state_message,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
            warehouse_bucket_uri=warehouse_bucket_uri,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             driver_shape: str,
             driver_shape_configs: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigResult'],
             executor_shape: str,
             executor_shape_configs: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigResult'],
             freeform_tags: Mapping[str, Any],
             id: str,
             jdbc_endpoint_url: str,
             lake_id: str,
             last_accepted_request_token: str,
             max_executor_count: int,
             metastore_id: str,
             min_executor_count: int,
             network_configurations: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationResult'],
             spark_advanced_configurations: Mapping[str, Any],
             sql_endpoint_version: str,
             state: str,
             state_message: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             warehouse_bucket_uri: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'driverShape' in kwargs:
            driver_shape = kwargs['driverShape']
        if 'driverShapeConfigs' in kwargs:
            driver_shape_configs = kwargs['driverShapeConfigs']
        if 'executorShape' in kwargs:
            executor_shape = kwargs['executorShape']
        if 'executorShapeConfigs' in kwargs:
            executor_shape_configs = kwargs['executorShapeConfigs']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'jdbcEndpointUrl' in kwargs:
            jdbc_endpoint_url = kwargs['jdbcEndpointUrl']
        if 'lakeId' in kwargs:
            lake_id = kwargs['lakeId']
        if 'lastAcceptedRequestToken' in kwargs:
            last_accepted_request_token = kwargs['lastAcceptedRequestToken']
        if 'maxExecutorCount' in kwargs:
            max_executor_count = kwargs['maxExecutorCount']
        if 'metastoreId' in kwargs:
            metastore_id = kwargs['metastoreId']
        if 'minExecutorCount' in kwargs:
            min_executor_count = kwargs['minExecutorCount']
        if 'networkConfigurations' in kwargs:
            network_configurations = kwargs['networkConfigurations']
        if 'sparkAdvancedConfigurations' in kwargs:
            spark_advanced_configurations = kwargs['sparkAdvancedConfigurations']
        if 'sqlEndpointVersion' in kwargs:
            sql_endpoint_version = kwargs['sqlEndpointVersion']
        if 'stateMessage' in kwargs:
            state_message = kwargs['stateMessage']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'warehouseBucketUri' in kwargs:
            warehouse_bucket_uri = kwargs['warehouseBucketUri']

        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("driver_shape", driver_shape)
        _setter("driver_shape_configs", driver_shape_configs)
        _setter("executor_shape", executor_shape)
        _setter("executor_shape_configs", executor_shape_configs)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("jdbc_endpoint_url", jdbc_endpoint_url)
        _setter("lake_id", lake_id)
        _setter("last_accepted_request_token", last_accepted_request_token)
        _setter("max_executor_count", max_executor_count)
        _setter("metastore_id", metastore_id)
        _setter("min_executor_count", min_executor_count)
        _setter("network_configurations", network_configurations)
        _setter("spark_advanced_configurations", spark_advanced_configurations)
        _setter("sql_endpoint_version", sql_endpoint_version)
        _setter("state", state)
        _setter("state_message", state_message)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("warehouse_bucket_uri", warehouse_bucket_uri)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment in which to query resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the SQL Endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The query parameter for the Spark application name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> str:
        """
        The shape of the SQL Endpoint driver instance.
        """
        return pulumi.get(self, "driver_shape")

    @property
    @pulumi.getter(name="driverShapeConfigs")
    def driver_shape_configs(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_configs")

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> str:
        """
        The shape of the SQL Endpoint executor instance.
        """
        return pulumi.get(self, "executor_shape")

    @property
    @pulumi.getter(name="executorShapeConfigs")
    def executor_shape_configs(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_configs")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provision identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jdbcEndpointUrl")
    def jdbc_endpoint_url(self) -> str:
        """
        The JDBC URL field. For example, jdbc:spark://{serviceFQDN}:443/default;SparkServerType=DFI
        """
        return pulumi.get(self, "jdbc_endpoint_url")

    @property
    @pulumi.getter(name="lakeId")
    def lake_id(self) -> str:
        """
        The OCID of Oracle Cloud Infrastructure Lake.
        """
        return pulumi.get(self, "lake_id")

    @property
    @pulumi.getter(name="lastAcceptedRequestToken")
    def last_accepted_request_token(self) -> str:
        """
        This token is used by Splat, and indicates that the service accepts the request, and that the request is currently being processed.
        """
        return pulumi.get(self, "last_accepted_request_token")

    @property
    @pulumi.getter(name="maxExecutorCount")
    def max_executor_count(self) -> int:
        """
        The maximum number of executors.
        """
        return pulumi.get(self, "max_executor_count")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> str:
        """
        The OCID of Oracle Cloud Infrastructure Hive Metastore.
        """
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter(name="minExecutorCount")
    def min_executor_count(self) -> int:
        """
        The minimum number of executors.
        """
        return pulumi.get(self, "min_executor_count")

    @property
    @pulumi.getter(name="networkConfigurations")
    def network_configurations(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationResult']:
        """
        The network configuration of a SQL Endpoint.
        """
        return pulumi.get(self, "network_configurations")

    @property
    @pulumi.getter(name="sparkAdvancedConfigurations")
    def spark_advanced_configurations(self) -> Mapping[str, Any]:
        """
        The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "spark_advanced_configurations")

    @property
    @pulumi.getter(name="sqlEndpointVersion")
    def sql_endpoint_version(self) -> str:
        """
        The version of SQL Endpoint.
        """
        return pulumi.get(self, "sql_endpoint_version")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only those resources whose sqlEndpointLifecycleState matches the given sqlEndpointLifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> str:
        """
        A message describing the reason why the resource is in it's current state. Helps bubble up errors in state changes. For example, it can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the Sql Endpoint was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the Sql Endpoint was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> str:
        """
        The warehouse bucket URI. It is a Oracle Cloud Infrastructure Object Storage bucket URI as defined here https://docs.oracle.com/en/cloud/paas/atp-cloud/atpud/object-storage-uris.html
        """
        return pulumi.get(self, "warehouse_bucket_uri")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The amount of memory used for the driver or executors.
        :param float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 access_control_rules: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleResult'],
                 host_name_prefix: str,
                 network_type: str,
                 private_endpoint_ip: str,
                 public_endpoint_ip: str,
                 subnet_id: str,
                 vcn_id: str):
        """
        :param Sequence['GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleArgs'] access_control_rules: A list of SecureAccessControlRule's to which access is limited to
        :param str host_name_prefix: The host name prefix.
        :param str network_type: The type of network configuration.
        :param str private_endpoint_ip: Ip Address of private endpoint
        :param str public_endpoint_ip: Ip Address of public endpoint
        :param str subnet_id: The VCN Subnet OCID.
        :param str vcn_id: The VCN OCID.
        """
        GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_control_rules=access_control_rules,
            host_name_prefix=host_name_prefix,
            network_type=network_type,
            private_endpoint_ip=private_endpoint_ip,
            public_endpoint_ip=public_endpoint_ip,
            subnet_id=subnet_id,
            vcn_id=vcn_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_control_rules: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleResult'],
             host_name_prefix: str,
             network_type: str,
             private_endpoint_ip: str,
             public_endpoint_ip: str,
             subnet_id: str,
             vcn_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'accessControlRules' in kwargs:
            access_control_rules = kwargs['accessControlRules']
        if 'hostNamePrefix' in kwargs:
            host_name_prefix = kwargs['hostNamePrefix']
        if 'networkType' in kwargs:
            network_type = kwargs['networkType']
        if 'privateEndpointIp' in kwargs:
            private_endpoint_ip = kwargs['privateEndpointIp']
        if 'publicEndpointIp' in kwargs:
            public_endpoint_ip = kwargs['publicEndpointIp']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'vcnId' in kwargs:
            vcn_id = kwargs['vcnId']

        _setter("access_control_rules", access_control_rules)
        _setter("host_name_prefix", host_name_prefix)
        _setter("network_type", network_type)
        _setter("private_endpoint_ip", private_endpoint_ip)
        _setter("public_endpoint_ip", public_endpoint_ip)
        _setter("subnet_id", subnet_id)
        _setter("vcn_id", vcn_id)

    @property
    @pulumi.getter(name="accessControlRules")
    def access_control_rules(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleResult']:
        """
        A list of SecureAccessControlRule's to which access is limited to
        """
        return pulumi.get(self, "access_control_rules")

    @property
    @pulumi.getter(name="hostNamePrefix")
    def host_name_prefix(self) -> str:
        """
        The host name prefix.
        """
        return pulumi.get(self, "host_name_prefix")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        The type of network configuration.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> str:
        """
        Ip Address of private endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter(name="publicEndpointIp")
    def public_endpoint_ip(self) -> str:
        """
        Ip Address of public endpoint
        """
        return pulumi.get(self, "public_endpoint_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The VCN Subnet OCID.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        The VCN OCID.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleResult(dict):
    def __init__(__self__, *,
                 ip_notation: str,
                 value: str,
                 vcn_ips: str):
        """
        :param str ip_notation: The type of IP notation.
        :param str value: The associated value of the selected IP notation.
        :param str vcn_ips: A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ip_notation=ip_notation,
            value=value,
            vcn_ips=vcn_ips,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ip_notation: str,
             value: str,
             vcn_ips: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ipNotation' in kwargs:
            ip_notation = kwargs['ipNotation']
        if 'vcnIps' in kwargs:
            vcn_ips = kwargs['vcnIps']

        _setter("ip_notation", ip_notation)
        _setter("value", value)
        _setter("vcn_ips", vcn_ips)

    @property
    @pulumi.getter(name="ipNotation")
    def ip_notation(self) -> str:
        """
        The type of IP notation.
        """
        return pulumi.get(self, "ip_notation")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The associated value of the selected IP notation.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="vcnIps")
    def vcn_ips(self) -> str:
        """
        A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        return pulumi.get(self, "vcn_ips")


