# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAlertAnalyticResult',
    'AwaitableGetAlertAnalyticResult',
    'get_alert_analytic',
    'get_alert_analytic_output',
]

@pulumi.output_type
class GetAlertAnalyticResult:
    """
    A collection of values returned by getAlertAnalytic.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, group_bies=None, id=None, items=None, query_time_zone=None, scim_query=None, summary_fields=None, time_ended=None, time_started=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if group_bies and not isinstance(group_bies, list):
            raise TypeError("Expected argument 'group_bies' to be a list")
        pulumi.set(__self__, "group_bies", group_bies)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if query_time_zone and not isinstance(query_time_zone, str):
            raise TypeError("Expected argument 'query_time_zone' to be a str")
        pulumi.set(__self__, "query_time_zone", query_time_zone)
        if scim_query and not isinstance(scim_query, str):
            raise TypeError("Expected argument 'scim_query' to be a str")
        pulumi.set(__self__, "scim_query", scim_query)
        if summary_fields and not isinstance(summary_fields, list):
            raise TypeError("Expected argument 'summary_fields' to be a list")
        pulumi.set(__self__, "summary_fields", summary_fields)
        if time_ended and not isinstance(time_ended, str):
            raise TypeError("Expected argument 'time_ended' to be a str")
        pulumi.set(__self__, "time_ended", time_ended)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[Sequence[str]]:
        """
        GroupBy value used in aggregation.
        """
        return pulumi.get(self, "group_bies")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAlertAnalyticItemResult']:
        """
        The aggregated data point items.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="queryTimeZone")
    def query_time_zone(self) -> Optional[str]:
        return pulumi.get(self, "query_time_zone")

    @property
    @pulumi.getter(name="scimQuery")
    def scim_query(self) -> Optional[str]:
        return pulumi.get(self, "scim_query")

    @property
    @pulumi.getter(name="summaryFields")
    def summary_fields(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "summary_fields")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[str]:
        """
        The time at which the aggregation ended.
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[str]:
        """
        The time at which the aggregation started.
        """
        return pulumi.get(self, "time_started")


class AwaitableGetAlertAnalyticResult(GetAlertAnalyticResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertAnalyticResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            group_bies=self.group_bies,
            id=self.id,
            items=self.items,
            query_time_zone=self.query_time_zone,
            scim_query=self.scim_query,
            summary_fields=self.summary_fields,
            time_ended=self.time_ended,
            time_started=self.time_started)


def get_alert_analytic(access_level: Optional[str] = None,
                       compartment_id: Optional[str] = None,
                       compartment_id_in_subtree: Optional[bool] = None,
                       group_bies: Optional[Sequence[str]] = None,
                       query_time_zone: Optional[str] = None,
                       scim_query: Optional[str] = None,
                       summary_fields: Optional[Sequence[str]] = None,
                       time_ended: Optional[str] = None,
                       time_started: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertAnalyticResult:
    """
    This data source provides details about a specific Alert Analytic resource in Oracle Cloud Infrastructure Data Safe service.

    Returns aggregation details of alerts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert_analytic = oci.DataSafe.get_alert_analytic(compartment_id=var["compartment_id"],
        access_level=var["alert_analytic_access_level"],
        compartment_id_in_subtree=var["alert_analytic_compartment_id_in_subtree"],
        group_bies=var["alert_analytic_group_by"],
        query_time_zone=var["alert_analytic_query_time_zone"],
        scim_query=var["alert_analytic_scim_query"],
        summary_fields=var["alert_analytic_summary_field"],
        time_ended=var["alert_analytic_time_ended"],
        time_started=var["alert_analytic_time_started"])
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param Sequence[str] group_bies: A groupBy can only be used in combination with summaryField parameter. A groupBy value has to be a subset of the values mentioned in summaryField parameter.
    :param str query_time_zone: Default time zone is UTC if no time zone provided. The date-time considerations of the resource will be in accordance with the specified time zone.
    :param str scim_query: The scimQuery query parameter accepts filter expressions that use the syntax described in Section 3.2.2.2 of the System for Cross-Domain Identity Management (SCIM) specification, which is available at [RFC3339](https://tools.ietf.org/html/draft-ietf-scim-api-12). In SCIM filtering expressions, text, date, and time values must be enclosed in quotation marks, with date and time values using ISO-8601 format. (Numeric and boolean values should not be quoted.)
           
           **Example:** query=(timeCreated ge '2021-06-04T01-00-26') and (targetNames eq 'target_1') Supported fields: severity status alertType targetIds targetNames operationTime lifecycleState displayName timeCreated timeUpdated
    :param Sequence[str] summary_fields: Specifies a subset of summarized fields to be returned in the response.
    :param str time_ended: An optional filter to return audit events whose creation time in the database is less than and equal to the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    :param str time_started: An optional filter to return audit events whose creation time in the database is greater than and equal to the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['groupBies'] = group_bies
    __args__['queryTimeZone'] = query_time_zone
    __args__['scimQuery'] = scim_query
    __args__['summaryFields'] = summary_fields
    __args__['timeEnded'] = time_ended
    __args__['timeStarted'] = time_started
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAlertAnalytic:getAlertAnalytic', __args__, opts=opts, typ=GetAlertAnalyticResult).value

    return AwaitableGetAlertAnalyticResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        group_bies=pulumi.get(__ret__, 'group_bies'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        query_time_zone=pulumi.get(__ret__, 'query_time_zone'),
        scim_query=pulumi.get(__ret__, 'scim_query'),
        summary_fields=pulumi.get(__ret__, 'summary_fields'),
        time_ended=pulumi.get(__ret__, 'time_ended'),
        time_started=pulumi.get(__ret__, 'time_started'))


@_utilities.lift_output_func(get_alert_analytic)
def get_alert_analytic_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                              compartment_id: Optional[pulumi.Input[str]] = None,
                              compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                              group_bies: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                              query_time_zone: Optional[pulumi.Input[Optional[str]]] = None,
                              scim_query: Optional[pulumi.Input[Optional[str]]] = None,
                              summary_fields: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                              time_ended: Optional[pulumi.Input[Optional[str]]] = None,
                              time_started: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAlertAnalyticResult]:
    """
    This data source provides details about a specific Alert Analytic resource in Oracle Cloud Infrastructure Data Safe service.

    Returns aggregation details of alerts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert_analytic = oci.DataSafe.get_alert_analytic(compartment_id=var["compartment_id"],
        access_level=var["alert_analytic_access_level"],
        compartment_id_in_subtree=var["alert_analytic_compartment_id_in_subtree"],
        group_bies=var["alert_analytic_group_by"],
        query_time_zone=var["alert_analytic_query_time_zone"],
        scim_query=var["alert_analytic_scim_query"],
        summary_fields=var["alert_analytic_summary_field"],
        time_ended=var["alert_analytic_time_ended"],
        time_started=var["alert_analytic_time_started"])
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param Sequence[str] group_bies: A groupBy can only be used in combination with summaryField parameter. A groupBy value has to be a subset of the values mentioned in summaryField parameter.
    :param str query_time_zone: Default time zone is UTC if no time zone provided. The date-time considerations of the resource will be in accordance with the specified time zone.
    :param str scim_query: The scimQuery query parameter accepts filter expressions that use the syntax described in Section 3.2.2.2 of the System for Cross-Domain Identity Management (SCIM) specification, which is available at [RFC3339](https://tools.ietf.org/html/draft-ietf-scim-api-12). In SCIM filtering expressions, text, date, and time values must be enclosed in quotation marks, with date and time values using ISO-8601 format. (Numeric and boolean values should not be quoted.)
           
           **Example:** query=(timeCreated ge '2021-06-04T01-00-26') and (targetNames eq 'target_1') Supported fields: severity status alertType targetIds targetNames operationTime lifecycleState displayName timeCreated timeUpdated
    :param Sequence[str] summary_fields: Specifies a subset of summarized fields to be returned in the response.
    :param str time_ended: An optional filter to return audit events whose creation time in the database is less than and equal to the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    :param str time_started: An optional filter to return audit events whose creation time in the database is greater than and equal to the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    """
    ...
