# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDiscoveryJobResult',
    'AwaitableGetDiscoveryJobResult',
    'get_discovery_job',
    'get_discovery_job_output',
]

@pulumi.output_type
class GetDiscoveryJobResult:
    """
    A collection of values returned by getDiscoveryJob.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, discovery_job_id=None, discovery_type=None, display_name=None, freeform_tags=None, id=None, is_app_defined_relation_discovery_enabled=None, is_include_all_schemas=None, is_include_all_sensitive_types=None, is_sample_data_collection_enabled=None, schemas_for_discoveries=None, sensitive_data_model_id=None, sensitive_type_ids_for_discoveries=None, state=None, system_tags=None, target_id=None, time_finished=None, time_started=None, total_columns_scanned=None, total_deleted_sensitive_columns=None, total_modified_sensitive_columns=None, total_new_sensitive_columns=None, total_objects_scanned=None, total_schemas_scanned=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if discovery_job_id and not isinstance(discovery_job_id, str):
            raise TypeError("Expected argument 'discovery_job_id' to be a str")
        pulumi.set(__self__, "discovery_job_id", discovery_job_id)
        if discovery_type and not isinstance(discovery_type, str):
            raise TypeError("Expected argument 'discovery_type' to be a str")
        pulumi.set(__self__, "discovery_type", discovery_type)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_app_defined_relation_discovery_enabled and not isinstance(is_app_defined_relation_discovery_enabled, bool):
            raise TypeError("Expected argument 'is_app_defined_relation_discovery_enabled' to be a bool")
        pulumi.set(__self__, "is_app_defined_relation_discovery_enabled", is_app_defined_relation_discovery_enabled)
        if is_include_all_schemas and not isinstance(is_include_all_schemas, bool):
            raise TypeError("Expected argument 'is_include_all_schemas' to be a bool")
        pulumi.set(__self__, "is_include_all_schemas", is_include_all_schemas)
        if is_include_all_sensitive_types and not isinstance(is_include_all_sensitive_types, bool):
            raise TypeError("Expected argument 'is_include_all_sensitive_types' to be a bool")
        pulumi.set(__self__, "is_include_all_sensitive_types", is_include_all_sensitive_types)
        if is_sample_data_collection_enabled and not isinstance(is_sample_data_collection_enabled, bool):
            raise TypeError("Expected argument 'is_sample_data_collection_enabled' to be a bool")
        pulumi.set(__self__, "is_sample_data_collection_enabled", is_sample_data_collection_enabled)
        if schemas_for_discoveries and not isinstance(schemas_for_discoveries, list):
            raise TypeError("Expected argument 'schemas_for_discoveries' to be a list")
        pulumi.set(__self__, "schemas_for_discoveries", schemas_for_discoveries)
        if sensitive_data_model_id and not isinstance(sensitive_data_model_id, str):
            raise TypeError("Expected argument 'sensitive_data_model_id' to be a str")
        pulumi.set(__self__, "sensitive_data_model_id", sensitive_data_model_id)
        if sensitive_type_ids_for_discoveries and not isinstance(sensitive_type_ids_for_discoveries, list):
            raise TypeError("Expected argument 'sensitive_type_ids_for_discoveries' to be a list")
        pulumi.set(__self__, "sensitive_type_ids_for_discoveries", sensitive_type_ids_for_discoveries)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if time_finished and not isinstance(time_finished, str):
            raise TypeError("Expected argument 'time_finished' to be a str")
        pulumi.set(__self__, "time_finished", time_finished)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if total_columns_scanned and not isinstance(total_columns_scanned, str):
            raise TypeError("Expected argument 'total_columns_scanned' to be a str")
        pulumi.set(__self__, "total_columns_scanned", total_columns_scanned)
        if total_deleted_sensitive_columns and not isinstance(total_deleted_sensitive_columns, str):
            raise TypeError("Expected argument 'total_deleted_sensitive_columns' to be a str")
        pulumi.set(__self__, "total_deleted_sensitive_columns", total_deleted_sensitive_columns)
        if total_modified_sensitive_columns and not isinstance(total_modified_sensitive_columns, str):
            raise TypeError("Expected argument 'total_modified_sensitive_columns' to be a str")
        pulumi.set(__self__, "total_modified_sensitive_columns", total_modified_sensitive_columns)
        if total_new_sensitive_columns and not isinstance(total_new_sensitive_columns, str):
            raise TypeError("Expected argument 'total_new_sensitive_columns' to be a str")
        pulumi.set(__self__, "total_new_sensitive_columns", total_new_sensitive_columns)
        if total_objects_scanned and not isinstance(total_objects_scanned, str):
            raise TypeError("Expected argument 'total_objects_scanned' to be a str")
        pulumi.set(__self__, "total_objects_scanned", total_objects_scanned)
        if total_schemas_scanned and not isinstance(total_schemas_scanned, str):
            raise TypeError("Expected argument 'total_schemas_scanned' to be a str")
        pulumi.set(__self__, "total_schemas_scanned", total_schemas_scanned)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the discovery job.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="discoveryJobId")
    def discovery_job_id(self) -> str:
        return pulumi.get(self, "discovery_job_id")

    @property
    @pulumi.getter(name="discoveryType")
    def discovery_type(self) -> str:
        """
        The type of the discovery job. It defines the job's scope. NEW identifies new sensitive columns in the target database that are not in the sensitive data model. DELETED identifies columns that are present in the sensitive data model but have been deleted from the target database. MODIFIED identifies columns that are present in the target database as well as the sensitive data model but some of their attributes have been modified. ALL covers all the above three scenarios and reports new, deleted and modified columns.
        """
        return pulumi.get(self, "discovery_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the discovery job.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the discovery job.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAppDefinedRelationDiscoveryEnabled")
    def is_app_defined_relation_discovery_enabled(self) -> bool:
        """
        Indicates if the discovery job should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        """
        return pulumi.get(self, "is_app_defined_relation_discovery_enabled")

    @property
    @pulumi.getter(name="isIncludeAllSchemas")
    def is_include_all_schemas(self) -> bool:
        """
        Indicates if all the schemas in the associated target database are used for data discovery. If it's set to true, the schemasForDiscovery attribute is ignored and all schemas are used.
        """
        return pulumi.get(self, "is_include_all_schemas")

    @property
    @pulumi.getter(name="isIncludeAllSensitiveTypes")
    def is_include_all_sensitive_types(self) -> bool:
        """
        Indicates if all the existing sensitive types are used for data discovery. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used.
        """
        return pulumi.get(self, "is_include_all_sensitive_types")

    @property
    @pulumi.getter(name="isSampleDataCollectionEnabled")
    def is_sample_data_collection_enabled(self) -> bool:
        """
        Indicates if the discovery job should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        """
        return pulumi.get(self, "is_sample_data_collection_enabled")

    @property
    @pulumi.getter(name="schemasForDiscoveries")
    def schemas_for_discoveries(self) -> Sequence[str]:
        """
        The schemas used for data discovery.
        """
        return pulumi.get(self, "schemas_for_discoveries")

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> str:
        """
        The OCID of the sensitive data model associated with the discovery job.
        """
        return pulumi.get(self, "sensitive_data_model_id")

    @property
    @pulumi.getter(name="sensitiveTypeIdsForDiscoveries")
    def sensitive_type_ids_for_discoveries(self) -> Sequence[str]:
        """
        The OCIDs of the sensitive types used for data discovery.
        """
        return pulumi.get(self, "sensitive_type_ids_for_discoveries")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the discovery job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The OCID of the target database associated with the discovery job.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> str:
        """
        The date and time the discovery job finished, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)..
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The date and time the discovery job started, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="totalColumnsScanned")
    def total_columns_scanned(self) -> str:
        """
        The total number of columns scanned by the discovery job.
        """
        return pulumi.get(self, "total_columns_scanned")

    @property
    @pulumi.getter(name="totalDeletedSensitiveColumns")
    def total_deleted_sensitive_columns(self) -> str:
        """
        The total number of deleted sensitive columns identified by the discovery job.
        """
        return pulumi.get(self, "total_deleted_sensitive_columns")

    @property
    @pulumi.getter(name="totalModifiedSensitiveColumns")
    def total_modified_sensitive_columns(self) -> str:
        """
        The total number of modified sensitive columns identified by the discovery job.
        """
        return pulumi.get(self, "total_modified_sensitive_columns")

    @property
    @pulumi.getter(name="totalNewSensitiveColumns")
    def total_new_sensitive_columns(self) -> str:
        """
        The total number of new sensitive columns identified by the discovery job.
        """
        return pulumi.get(self, "total_new_sensitive_columns")

    @property
    @pulumi.getter(name="totalObjectsScanned")
    def total_objects_scanned(self) -> str:
        """
        The total number of objects (tables and editioning views) scanned by the discovery job.
        """
        return pulumi.get(self, "total_objects_scanned")

    @property
    @pulumi.getter(name="totalSchemasScanned")
    def total_schemas_scanned(self) -> str:
        """
        The total number of schemas scanned by the discovery job.
        """
        return pulumi.get(self, "total_schemas_scanned")


class AwaitableGetDiscoveryJobResult(GetDiscoveryJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiscoveryJobResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            discovery_job_id=self.discovery_job_id,
            discovery_type=self.discovery_type,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_app_defined_relation_discovery_enabled=self.is_app_defined_relation_discovery_enabled,
            is_include_all_schemas=self.is_include_all_schemas,
            is_include_all_sensitive_types=self.is_include_all_sensitive_types,
            is_sample_data_collection_enabled=self.is_sample_data_collection_enabled,
            schemas_for_discoveries=self.schemas_for_discoveries,
            sensitive_data_model_id=self.sensitive_data_model_id,
            sensitive_type_ids_for_discoveries=self.sensitive_type_ids_for_discoveries,
            state=self.state,
            system_tags=self.system_tags,
            target_id=self.target_id,
            time_finished=self.time_finished,
            time_started=self.time_started,
            total_columns_scanned=self.total_columns_scanned,
            total_deleted_sensitive_columns=self.total_deleted_sensitive_columns,
            total_modified_sensitive_columns=self.total_modified_sensitive_columns,
            total_new_sensitive_columns=self.total_new_sensitive_columns,
            total_objects_scanned=self.total_objects_scanned,
            total_schemas_scanned=self.total_schemas_scanned)


def get_discovery_job(discovery_job_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiscoveryJobResult:
    """
    This data source provides details about a specific Discovery Job resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified discovery job.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_discovery_job = oci.DataSafe.get_discovery_job(discovery_job_id=oci_data_safe_discovery_job["test_discovery_job"]["id"])
    ```


    :param str discovery_job_id: The OCID of the discovery job.
    """
    __args__ = dict()
    __args__['discoveryJobId'] = discovery_job_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getDiscoveryJob:getDiscoveryJob', __args__, opts=opts, typ=GetDiscoveryJobResult).value

    return AwaitableGetDiscoveryJobResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        discovery_job_id=pulumi.get(__ret__, 'discovery_job_id'),
        discovery_type=pulumi.get(__ret__, 'discovery_type'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_app_defined_relation_discovery_enabled=pulumi.get(__ret__, 'is_app_defined_relation_discovery_enabled'),
        is_include_all_schemas=pulumi.get(__ret__, 'is_include_all_schemas'),
        is_include_all_sensitive_types=pulumi.get(__ret__, 'is_include_all_sensitive_types'),
        is_sample_data_collection_enabled=pulumi.get(__ret__, 'is_sample_data_collection_enabled'),
        schemas_for_discoveries=pulumi.get(__ret__, 'schemas_for_discoveries'),
        sensitive_data_model_id=pulumi.get(__ret__, 'sensitive_data_model_id'),
        sensitive_type_ids_for_discoveries=pulumi.get(__ret__, 'sensitive_type_ids_for_discoveries'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_id=pulumi.get(__ret__, 'target_id'),
        time_finished=pulumi.get(__ret__, 'time_finished'),
        time_started=pulumi.get(__ret__, 'time_started'),
        total_columns_scanned=pulumi.get(__ret__, 'total_columns_scanned'),
        total_deleted_sensitive_columns=pulumi.get(__ret__, 'total_deleted_sensitive_columns'),
        total_modified_sensitive_columns=pulumi.get(__ret__, 'total_modified_sensitive_columns'),
        total_new_sensitive_columns=pulumi.get(__ret__, 'total_new_sensitive_columns'),
        total_objects_scanned=pulumi.get(__ret__, 'total_objects_scanned'),
        total_schemas_scanned=pulumi.get(__ret__, 'total_schemas_scanned'))


@_utilities.lift_output_func(get_discovery_job)
def get_discovery_job_output(discovery_job_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDiscoveryJobResult]:
    """
    This data source provides details about a specific Discovery Job resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified discovery job.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_discovery_job = oci.DataSafe.get_discovery_job(discovery_job_id=oci_data_safe_discovery_job["test_discovery_job"]["id"])
    ```


    :param str discovery_job_id: The OCID of the discovery job.
    """
    ...
