# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSensitiveDataModelSensitiveSchemasResult',
    'AwaitableGetSensitiveDataModelSensitiveSchemasResult',
    'get_sensitive_data_model_sensitive_schemas',
    'get_sensitive_data_model_sensitive_schemas_output',
]

@pulumi.output_type
class GetSensitiveDataModelSensitiveSchemasResult:
    """
    A collection of values returned by getSensitiveDataModelSensitiveSchemas.
    """
    def __init__(__self__, filters=None, id=None, schema_names=None, sensitive_data_model_id=None, sensitive_schema_collections=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if schema_names and not isinstance(schema_names, list):
            raise TypeError("Expected argument 'schema_names' to be a list")
        pulumi.set(__self__, "schema_names", schema_names)
        if sensitive_data_model_id and not isinstance(sensitive_data_model_id, str):
            raise TypeError("Expected argument 'sensitive_data_model_id' to be a str")
        pulumi.set(__self__, "sensitive_data_model_id", sensitive_data_model_id)
        if sensitive_schema_collections and not isinstance(sensitive_schema_collections, list):
            raise TypeError("Expected argument 'sensitive_schema_collections' to be a list")
        pulumi.set(__self__, "sensitive_schema_collections", sensitive_schema_collections)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSensitiveDataModelSensitiveSchemasFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="schemaNames")
    def schema_names(self) -> Optional[Sequence[str]]:
        """
        The database schema that contains the sensitive column.
        """
        return pulumi.get(self, "schema_names")

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> str:
        return pulumi.get(self, "sensitive_data_model_id")

    @property
    @pulumi.getter(name="sensitiveSchemaCollections")
    def sensitive_schema_collections(self) -> Sequence['outputs.GetSensitiveDataModelSensitiveSchemasSensitiveSchemaCollectionResult']:
        """
        The list of sensitive_schema_collection.
        """
        return pulumi.get(self, "sensitive_schema_collections")


class AwaitableGetSensitiveDataModelSensitiveSchemasResult(GetSensitiveDataModelSensitiveSchemasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSensitiveDataModelSensitiveSchemasResult(
            filters=self.filters,
            id=self.id,
            schema_names=self.schema_names,
            sensitive_data_model_id=self.sensitive_data_model_id,
            sensitive_schema_collections=self.sensitive_schema_collections)


def get_sensitive_data_model_sensitive_schemas(filters: Optional[Sequence[pulumi.InputType['GetSensitiveDataModelSensitiveSchemasFilterArgs']]] = None,
                                               schema_names: Optional[Sequence[str]] = None,
                                               sensitive_data_model_id: Optional[str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSensitiveDataModelSensitiveSchemasResult:
    """
    This data source provides the list of Sensitive Data Model Sensitive Schemas in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of sensitive schemas present in the specified sensitive data model based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_data_model_sensitive_schemas = oci.DataSafe.get_sensitive_data_model_sensitive_schemas(sensitive_data_model_id=oci_data_safe_sensitive_data_model["test_sensitive_data_model"]["id"],
        schema_names=var["sensitive_data_model_sensitive_schema_schema_name"])
    ```


    :param Sequence[str] schema_names: A filter to return only items related to specific schema name.
    :param str sensitive_data_model_id: The OCID of the sensitive data model.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['schemaNames'] = schema_names
    __args__['sensitiveDataModelId'] = sensitive_data_model_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSensitiveDataModelSensitiveSchemas:getSensitiveDataModelSensitiveSchemas', __args__, opts=opts, typ=GetSensitiveDataModelSensitiveSchemasResult).value

    return AwaitableGetSensitiveDataModelSensitiveSchemasResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        schema_names=pulumi.get(__ret__, 'schema_names'),
        sensitive_data_model_id=pulumi.get(__ret__, 'sensitive_data_model_id'),
        sensitive_schema_collections=pulumi.get(__ret__, 'sensitive_schema_collections'))


@_utilities.lift_output_func(get_sensitive_data_model_sensitive_schemas)
def get_sensitive_data_model_sensitive_schemas_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSensitiveDataModelSensitiveSchemasFilterArgs']]]]] = None,
                                                      schema_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                      sensitive_data_model_id: Optional[pulumi.Input[str]] = None,
                                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSensitiveDataModelSensitiveSchemasResult]:
    """
    This data source provides the list of Sensitive Data Model Sensitive Schemas in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of sensitive schemas present in the specified sensitive data model based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_data_model_sensitive_schemas = oci.DataSafe.get_sensitive_data_model_sensitive_schemas(sensitive_data_model_id=oci_data_safe_sensitive_data_model["test_sensitive_data_model"]["id"],
        schema_names=var["sensitive_data_model_sensitive_schema_schema_name"])
    ```


    :param Sequence[str] schema_names: A filter to return only items related to specific schema name.
    :param str sensitive_data_model_id: The OCID of the sensitive data model.
    """
    ...
