# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 job_configuration_details: pulumi.Input['JobJobConfigurationDetailsArgs'],
                 job_infrastructure_configuration_details: pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs'],
                 project_id: pulumi.Input[str],
                 artifact_content_disposition: Optional[pulumi.Input[str]] = None,
                 artifact_content_length: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 delete_related_job_runs: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 job_artifact: Optional[pulumi.Input[str]] = None,
                 job_log_configuration_details: Optional[pulumi.Input['JobJobLogConfigurationDetailsArgs']] = None,
                 job_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input['JobJobConfigurationDetailsArgs'] job_configuration_details: The job configuration details
        :param pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs'] job_infrastructure_configuration_details: (Updatable) The job infrastructure configuration details (shape, block storage, etc.)
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
        :param pulumi.Input[str] artifact_content_disposition: This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=job-artifact.py`
        :param pulumi.Input[str] artifact_content_length: The content length of the body.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[bool] delete_related_job_runs: (Updatable) Delete all related JobRuns upon deletion of the Job.
        :param pulumi.Input[str] description: (Updatable) A short description of the job.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] job_artifact: The job artifact to upload. This can be done in a separate step or from cli/sdk. The Job will remain in "Creating" state until its artifact is uploaded.
        :param pulumi.Input['JobJobLogConfigurationDetailsArgs'] job_log_configuration_details: Logging configuration for resource.
        :param pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]] job_storage_mount_configuration_details_lists: (Updatable) Collection of JobStorageMountConfigurationDetails.
        """
        JobArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            job_configuration_details=job_configuration_details,
            job_infrastructure_configuration_details=job_infrastructure_configuration_details,
            project_id=project_id,
            artifact_content_disposition=artifact_content_disposition,
            artifact_content_length=artifact_content_length,
            defined_tags=defined_tags,
            delete_related_job_runs=delete_related_job_runs,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            job_artifact=job_artifact,
            job_log_configuration_details=job_log_configuration_details,
            job_storage_mount_configuration_details_lists=job_storage_mount_configuration_details_lists,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             job_configuration_details: pulumi.Input['JobJobConfigurationDetailsArgs'],
             job_infrastructure_configuration_details: pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs'],
             project_id: pulumi.Input[str],
             artifact_content_disposition: Optional[pulumi.Input[str]] = None,
             artifact_content_length: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             delete_related_job_runs: Optional[pulumi.Input[bool]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             job_artifact: Optional[pulumi.Input[str]] = None,
             job_log_configuration_details: Optional[pulumi.Input['JobJobLogConfigurationDetailsArgs']] = None,
             job_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'jobConfigurationDetails' in kwargs:
            job_configuration_details = kwargs['jobConfigurationDetails']
        if 'jobInfrastructureConfigurationDetails' in kwargs:
            job_infrastructure_configuration_details = kwargs['jobInfrastructureConfigurationDetails']
        if 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if 'artifactContentDisposition' in kwargs:
            artifact_content_disposition = kwargs['artifactContentDisposition']
        if 'artifactContentLength' in kwargs:
            artifact_content_length = kwargs['artifactContentLength']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'deleteRelatedJobRuns' in kwargs:
            delete_related_job_runs = kwargs['deleteRelatedJobRuns']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'jobArtifact' in kwargs:
            job_artifact = kwargs['jobArtifact']
        if 'jobLogConfigurationDetails' in kwargs:
            job_log_configuration_details = kwargs['jobLogConfigurationDetails']
        if 'jobStorageMountConfigurationDetailsLists' in kwargs:
            job_storage_mount_configuration_details_lists = kwargs['jobStorageMountConfigurationDetailsLists']

        _setter("compartment_id", compartment_id)
        _setter("job_configuration_details", job_configuration_details)
        _setter("job_infrastructure_configuration_details", job_infrastructure_configuration_details)
        _setter("project_id", project_id)
        if artifact_content_disposition is not None:
            _setter("artifact_content_disposition", artifact_content_disposition)
        if artifact_content_length is not None:
            _setter("artifact_content_length", artifact_content_length)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if delete_related_job_runs is not None:
            _setter("delete_related_job_runs", delete_related_job_runs)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if job_artifact is not None:
            _setter("job_artifact", job_artifact)
        if job_log_configuration_details is not None:
            _setter("job_log_configuration_details", job_log_configuration_details)
        if job_storage_mount_configuration_details_lists is not None:
            _setter("job_storage_mount_configuration_details_lists", job_storage_mount_configuration_details_lists)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="jobConfigurationDetails")
    def job_configuration_details(self) -> pulumi.Input['JobJobConfigurationDetailsArgs']:
        """
        The job configuration details
        """
        return pulumi.get(self, "job_configuration_details")

    @job_configuration_details.setter
    def job_configuration_details(self, value: pulumi.Input['JobJobConfigurationDetailsArgs']):
        pulumi.set(self, "job_configuration_details", value)

    @property
    @pulumi.getter(name="jobInfrastructureConfigurationDetails")
    def job_infrastructure_configuration_details(self) -> pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs']:
        """
        (Updatable) The job infrastructure configuration details (shape, block storage, etc.)
        """
        return pulumi.get(self, "job_infrastructure_configuration_details")

    @job_infrastructure_configuration_details.setter
    def job_infrastructure_configuration_details(self, value: pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs']):
        pulumi.set(self, "job_infrastructure_configuration_details", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="artifactContentDisposition")
    def artifact_content_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=job-artifact.py`
        """
        return pulumi.get(self, "artifact_content_disposition")

    @artifact_content_disposition.setter
    def artifact_content_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_content_disposition", value)

    @property
    @pulumi.getter(name="artifactContentLength")
    def artifact_content_length(self) -> Optional[pulumi.Input[str]]:
        """
        The content length of the body.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "artifact_content_length")

    @artifact_content_length.setter
    def artifact_content_length(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_content_length", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deleteRelatedJobRuns")
    def delete_related_job_runs(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Delete all related JobRuns upon deletion of the Job.
        """
        return pulumi.get(self, "delete_related_job_runs")

    @delete_related_job_runs.setter
    def delete_related_job_runs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_related_job_runs", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A short description of the job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="jobArtifact")
    def job_artifact(self) -> Optional[pulumi.Input[str]]:
        """
        The job artifact to upload. This can be done in a separate step or from cli/sdk. The Job will remain in "Creating" state until its artifact is uploaded.
        """
        return pulumi.get(self, "job_artifact")

    @job_artifact.setter
    def job_artifact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_artifact", value)

    @property
    @pulumi.getter(name="jobLogConfigurationDetails")
    def job_log_configuration_details(self) -> Optional[pulumi.Input['JobJobLogConfigurationDetailsArgs']]:
        """
        Logging configuration for resource.
        """
        return pulumi.get(self, "job_log_configuration_details")

    @job_log_configuration_details.setter
    def job_log_configuration_details(self, value: Optional[pulumi.Input['JobJobLogConfigurationDetailsArgs']]):
        pulumi.set(self, "job_log_configuration_details", value)

    @property
    @pulumi.getter(name="jobStorageMountConfigurationDetailsLists")
    def job_storage_mount_configuration_details_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]]]:
        """
        (Updatable) Collection of JobStorageMountConfigurationDetails.
        """
        return pulumi.get(self, "job_storage_mount_configuration_details_lists")

    @job_storage_mount_configuration_details_lists.setter
    def job_storage_mount_configuration_details_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]]]):
        pulumi.set(self, "job_storage_mount_configuration_details_lists", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 artifact_content_disposition: Optional[pulumi.Input[str]] = None,
                 artifact_content_length: Optional[pulumi.Input[str]] = None,
                 artifact_content_md5: Optional[pulumi.Input[str]] = None,
                 artifact_last_modified: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 delete_related_job_runs: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 empty_artifact: Optional[pulumi.Input[bool]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 job_artifact: Optional[pulumi.Input[str]] = None,
                 job_configuration_details: Optional[pulumi.Input['JobJobConfigurationDetailsArgs']] = None,
                 job_infrastructure_configuration_details: Optional[pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs']] = None,
                 job_log_configuration_details: Optional[pulumi.Input['JobJobLogConfigurationDetailsArgs']] = None,
                 job_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[str] artifact_content_disposition: This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=job-artifact.py`
        :param pulumi.Input[str] artifact_content_length: The content length of the body.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the project.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[bool] delete_related_job_runs: (Updatable) Delete all related JobRuns upon deletion of the Job.
        :param pulumi.Input[str] description: (Updatable) A short description of the job.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] job_artifact: The job artifact to upload. This can be done in a separate step or from cli/sdk. The Job will remain in "Creating" state until its artifact is uploaded.
        :param pulumi.Input['JobJobConfigurationDetailsArgs'] job_configuration_details: The job configuration details
        :param pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs'] job_infrastructure_configuration_details: (Updatable) The job infrastructure configuration details (shape, block storage, etc.)
        :param pulumi.Input['JobJobLogConfigurationDetailsArgs'] job_log_configuration_details: Logging configuration for resource.
        :param pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]] job_storage_mount_configuration_details_lists: (Updatable) Collection of JobStorageMountConfigurationDetails.
        :param pulumi.Input[str] lifecycle_details: The state of the job.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
        :param pulumi.Input[str] state: The state of the job.
        :param pulumi.Input[str] time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        """
        _JobState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            artifact_content_disposition=artifact_content_disposition,
            artifact_content_length=artifact_content_length,
            artifact_content_md5=artifact_content_md5,
            artifact_last_modified=artifact_last_modified,
            compartment_id=compartment_id,
            created_by=created_by,
            defined_tags=defined_tags,
            delete_related_job_runs=delete_related_job_runs,
            description=description,
            display_name=display_name,
            empty_artifact=empty_artifact,
            freeform_tags=freeform_tags,
            job_artifact=job_artifact,
            job_configuration_details=job_configuration_details,
            job_infrastructure_configuration_details=job_infrastructure_configuration_details,
            job_log_configuration_details=job_log_configuration_details,
            job_storage_mount_configuration_details_lists=job_storage_mount_configuration_details_lists,
            lifecycle_details=lifecycle_details,
            project_id=project_id,
            state=state,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             artifact_content_disposition: Optional[pulumi.Input[str]] = None,
             artifact_content_length: Optional[pulumi.Input[str]] = None,
             artifact_content_md5: Optional[pulumi.Input[str]] = None,
             artifact_last_modified: Optional[pulumi.Input[str]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             created_by: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             delete_related_job_runs: Optional[pulumi.Input[bool]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             empty_artifact: Optional[pulumi.Input[bool]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             job_artifact: Optional[pulumi.Input[str]] = None,
             job_configuration_details: Optional[pulumi.Input['JobJobConfigurationDetailsArgs']] = None,
             job_infrastructure_configuration_details: Optional[pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs']] = None,
             job_log_configuration_details: Optional[pulumi.Input['JobJobLogConfigurationDetailsArgs']] = None,
             job_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             project_id: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'artifactContentDisposition' in kwargs:
            artifact_content_disposition = kwargs['artifactContentDisposition']
        if 'artifactContentLength' in kwargs:
            artifact_content_length = kwargs['artifactContentLength']
        if 'artifactContentMd5' in kwargs:
            artifact_content_md5 = kwargs['artifactContentMd5']
        if 'artifactLastModified' in kwargs:
            artifact_last_modified = kwargs['artifactLastModified']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'createdBy' in kwargs:
            created_by = kwargs['createdBy']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'deleteRelatedJobRuns' in kwargs:
            delete_related_job_runs = kwargs['deleteRelatedJobRuns']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'emptyArtifact' in kwargs:
            empty_artifact = kwargs['emptyArtifact']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'jobArtifact' in kwargs:
            job_artifact = kwargs['jobArtifact']
        if 'jobConfigurationDetails' in kwargs:
            job_configuration_details = kwargs['jobConfigurationDetails']
        if 'jobInfrastructureConfigurationDetails' in kwargs:
            job_infrastructure_configuration_details = kwargs['jobInfrastructureConfigurationDetails']
        if 'jobLogConfigurationDetails' in kwargs:
            job_log_configuration_details = kwargs['jobLogConfigurationDetails']
        if 'jobStorageMountConfigurationDetailsLists' in kwargs:
            job_storage_mount_configuration_details_lists = kwargs['jobStorageMountConfigurationDetailsLists']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        if artifact_content_disposition is not None:
            _setter("artifact_content_disposition", artifact_content_disposition)
        if artifact_content_length is not None:
            _setter("artifact_content_length", artifact_content_length)
        if artifact_content_md5 is not None:
            _setter("artifact_content_md5", artifact_content_md5)
        if artifact_last_modified is not None:
            _setter("artifact_last_modified", artifact_last_modified)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if created_by is not None:
            _setter("created_by", created_by)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if delete_related_job_runs is not None:
            _setter("delete_related_job_runs", delete_related_job_runs)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if empty_artifact is not None:
            _setter("empty_artifact", empty_artifact)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if job_artifact is not None:
            _setter("job_artifact", job_artifact)
        if job_configuration_details is not None:
            _setter("job_configuration_details", job_configuration_details)
        if job_infrastructure_configuration_details is not None:
            _setter("job_infrastructure_configuration_details", job_infrastructure_configuration_details)
        if job_log_configuration_details is not None:
            _setter("job_log_configuration_details", job_log_configuration_details)
        if job_storage_mount_configuration_details_lists is not None:
            _setter("job_storage_mount_configuration_details_lists", job_storage_mount_configuration_details_lists)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if project_id is not None:
            _setter("project_id", project_id)
        if state is not None:
            _setter("state", state)
        if time_created is not None:
            _setter("time_created", time_created)

    @property
    @pulumi.getter(name="artifactContentDisposition")
    def artifact_content_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=job-artifact.py`
        """
        return pulumi.get(self, "artifact_content_disposition")

    @artifact_content_disposition.setter
    def artifact_content_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_content_disposition", value)

    @property
    @pulumi.getter(name="artifactContentLength")
    def artifact_content_length(self) -> Optional[pulumi.Input[str]]:
        """
        The content length of the body.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "artifact_content_length")

    @artifact_content_length.setter
    def artifact_content_length(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_content_length", value)

    @property
    @pulumi.getter(name="artifactContentMd5")
    def artifact_content_md5(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "artifact_content_md5")

    @artifact_content_md5.setter
    def artifact_content_md5(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_content_md5", value)

    @property
    @pulumi.getter(name="artifactLastModified")
    def artifact_last_modified(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "artifact_last_modified")

    @artifact_last_modified.setter
    def artifact_last_modified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_last_modified", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the project.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deleteRelatedJobRuns")
    def delete_related_job_runs(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Delete all related JobRuns upon deletion of the Job.
        """
        return pulumi.get(self, "delete_related_job_runs")

    @delete_related_job_runs.setter
    def delete_related_job_runs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_related_job_runs", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A short description of the job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="emptyArtifact")
    def empty_artifact(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "empty_artifact")

    @empty_artifact.setter
    def empty_artifact(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "empty_artifact", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="jobArtifact")
    def job_artifact(self) -> Optional[pulumi.Input[str]]:
        """
        The job artifact to upload. This can be done in a separate step or from cli/sdk. The Job will remain in "Creating" state until its artifact is uploaded.
        """
        return pulumi.get(self, "job_artifact")

    @job_artifact.setter
    def job_artifact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_artifact", value)

    @property
    @pulumi.getter(name="jobConfigurationDetails")
    def job_configuration_details(self) -> Optional[pulumi.Input['JobJobConfigurationDetailsArgs']]:
        """
        The job configuration details
        """
        return pulumi.get(self, "job_configuration_details")

    @job_configuration_details.setter
    def job_configuration_details(self, value: Optional[pulumi.Input['JobJobConfigurationDetailsArgs']]):
        pulumi.set(self, "job_configuration_details", value)

    @property
    @pulumi.getter(name="jobInfrastructureConfigurationDetails")
    def job_infrastructure_configuration_details(self) -> Optional[pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs']]:
        """
        (Updatable) The job infrastructure configuration details (shape, block storage, etc.)
        """
        return pulumi.get(self, "job_infrastructure_configuration_details")

    @job_infrastructure_configuration_details.setter
    def job_infrastructure_configuration_details(self, value: Optional[pulumi.Input['JobJobInfrastructureConfigurationDetailsArgs']]):
        pulumi.set(self, "job_infrastructure_configuration_details", value)

    @property
    @pulumi.getter(name="jobLogConfigurationDetails")
    def job_log_configuration_details(self) -> Optional[pulumi.Input['JobJobLogConfigurationDetailsArgs']]:
        """
        Logging configuration for resource.
        """
        return pulumi.get(self, "job_log_configuration_details")

    @job_log_configuration_details.setter
    def job_log_configuration_details(self, value: Optional[pulumi.Input['JobJobLogConfigurationDetailsArgs']]):
        pulumi.set(self, "job_log_configuration_details", value)

    @property
    @pulumi.getter(name="jobStorageMountConfigurationDetailsLists")
    def job_storage_mount_configuration_details_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]]]:
        """
        (Updatable) Collection of JobStorageMountConfigurationDetails.
        """
        return pulumi.get(self, "job_storage_mount_configuration_details_lists")

    @job_storage_mount_configuration_details_lists.setter
    def job_storage_mount_configuration_details_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageMountConfigurationDetailsListArgs']]]]):
        pulumi.set(self, "job_storage_mount_configuration_details_lists", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the job.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the job.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_content_disposition: Optional[pulumi.Input[str]] = None,
                 artifact_content_length: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 delete_related_job_runs: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 job_artifact: Optional[pulumi.Input[str]] = None,
                 job_configuration_details: Optional[pulumi.Input[pulumi.InputType['JobJobConfigurationDetailsArgs']]] = None,
                 job_infrastructure_configuration_details: Optional[pulumi.Input[pulumi.InputType['JobJobInfrastructureConfigurationDetailsArgs']]] = None,
                 job_log_configuration_details: Optional[pulumi.Input[pulumi.InputType['JobJobLogConfigurationDetailsArgs']]] = None,
                 job_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobJobStorageMountConfigurationDetailsListArgs']]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Job resource in Oracle Cloud Infrastructure Data Science service.

        Creates a job.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_job = oci.data_science.Job("testJob",
            compartment_id=var["compartment_id"],
            job_configuration_details=oci.data_science.JobJobConfigurationDetailsArgs(
                job_type=var["job_job_configuration_details_job_type"],
                command_line_arguments=var["job_job_configuration_details_command_line_arguments"],
                environment_variables=var["job_job_configuration_details_environment_variables"],
                maximum_runtime_in_minutes=var["job_job_configuration_details_maximum_runtime_in_minutes"],
            ),
            job_infrastructure_configuration_details=oci.data_science.JobJobInfrastructureConfigurationDetailsArgs(
                block_storage_size_in_gbs=var["job_job_infrastructure_configuration_details_block_storage_size_in_gbs"],
                job_infrastructure_type=var["job_job_infrastructure_configuration_details_job_infrastructure_type"],
                shape_name=oci_core_shape["test_shape"]["name"],
                job_shape_config_details=oci.data_science.JobJobInfrastructureConfigurationDetailsJobShapeConfigDetailsArgs(
                    memory_in_gbs=var["job_job_infrastructure_configuration_details_job_shape_config_details_memory_in_gbs"],
                    ocpus=var["job_job_infrastructure_configuration_details_job_shape_config_details_ocpus"],
                ),
                subnet_id=oci_core_subnet["test_subnet"]["id"],
            ),
            project_id=oci_datascience_project["test_project"]["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["job_description"],
            display_name=var["job_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            job_log_configuration_details=oci.data_science.JobJobLogConfigurationDetailsArgs(
                enable_auto_log_creation=var["job_job_log_configuration_details_enable_auto_log_creation"],
                enable_logging=var["job_job_log_configuration_details_enable_logging"],
                log_group_id=oci_logging_log_group["test_log_group"]["id"],
                log_id=oci_logging_log["test_log"]["id"],
            ),
            job_storage_mount_configuration_details_lists=[oci.data_science.JobJobStorageMountConfigurationDetailsListArgs(
                destination_directory_name=var["job_job_storage_mount_configuration_details_list_destination_directory_name"],
                storage_type=var["job_job_storage_mount_configuration_details_list_storage_type"],
                bucket=var["job_job_storage_mount_configuration_details_list_bucket"],
                destination_path=var["job_job_storage_mount_configuration_details_list_destination_path"],
                export_id=oci_file_storage_export["test_export"]["id"],
                mount_target_id=oci_file_storage_mount_target["test_mount_target"]["id"],
                namespace=var["job_job_storage_mount_configuration_details_list_namespace"],
                prefix=var["job_job_storage_mount_configuration_details_list_prefix"],
            )])
        ```

        ## Import

        Jobs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataScience/job:Job test_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artifact_content_disposition: This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=job-artifact.py`
        :param pulumi.Input[str] artifact_content_length: The content length of the body.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[bool] delete_related_job_runs: (Updatable) Delete all related JobRuns upon deletion of the Job.
        :param pulumi.Input[str] description: (Updatable) A short description of the job.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] job_artifact: The job artifact to upload. This can be done in a separate step or from cli/sdk. The Job will remain in "Creating" state until its artifact is uploaded.
        :param pulumi.Input[pulumi.InputType['JobJobConfigurationDetailsArgs']] job_configuration_details: The job configuration details
        :param pulumi.Input[pulumi.InputType['JobJobInfrastructureConfigurationDetailsArgs']] job_infrastructure_configuration_details: (Updatable) The job infrastructure configuration details (shape, block storage, etc.)
        :param pulumi.Input[pulumi.InputType['JobJobLogConfigurationDetailsArgs']] job_log_configuration_details: Logging configuration for resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobJobStorageMountConfigurationDetailsListArgs']]]] job_storage_mount_configuration_details_lists: (Updatable) Collection of JobStorageMountConfigurationDetails.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Job resource in Oracle Cloud Infrastructure Data Science service.

        Creates a job.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_job = oci.data_science.Job("testJob",
            compartment_id=var["compartment_id"],
            job_configuration_details=oci.data_science.JobJobConfigurationDetailsArgs(
                job_type=var["job_job_configuration_details_job_type"],
                command_line_arguments=var["job_job_configuration_details_command_line_arguments"],
                environment_variables=var["job_job_configuration_details_environment_variables"],
                maximum_runtime_in_minutes=var["job_job_configuration_details_maximum_runtime_in_minutes"],
            ),
            job_infrastructure_configuration_details=oci.data_science.JobJobInfrastructureConfigurationDetailsArgs(
                block_storage_size_in_gbs=var["job_job_infrastructure_configuration_details_block_storage_size_in_gbs"],
                job_infrastructure_type=var["job_job_infrastructure_configuration_details_job_infrastructure_type"],
                shape_name=oci_core_shape["test_shape"]["name"],
                job_shape_config_details=oci.data_science.JobJobInfrastructureConfigurationDetailsJobShapeConfigDetailsArgs(
                    memory_in_gbs=var["job_job_infrastructure_configuration_details_job_shape_config_details_memory_in_gbs"],
                    ocpus=var["job_job_infrastructure_configuration_details_job_shape_config_details_ocpus"],
                ),
                subnet_id=oci_core_subnet["test_subnet"]["id"],
            ),
            project_id=oci_datascience_project["test_project"]["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["job_description"],
            display_name=var["job_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            job_log_configuration_details=oci.data_science.JobJobLogConfigurationDetailsArgs(
                enable_auto_log_creation=var["job_job_log_configuration_details_enable_auto_log_creation"],
                enable_logging=var["job_job_log_configuration_details_enable_logging"],
                log_group_id=oci_logging_log_group["test_log_group"]["id"],
                log_id=oci_logging_log["test_log"]["id"],
            ),
            job_storage_mount_configuration_details_lists=[oci.data_science.JobJobStorageMountConfigurationDetailsListArgs(
                destination_directory_name=var["job_job_storage_mount_configuration_details_list_destination_directory_name"],
                storage_type=var["job_job_storage_mount_configuration_details_list_storage_type"],
                bucket=var["job_job_storage_mount_configuration_details_list_bucket"],
                destination_path=var["job_job_storage_mount_configuration_details_list_destination_path"],
                export_id=oci_file_storage_export["test_export"]["id"],
                mount_target_id=oci_file_storage_mount_target["test_mount_target"]["id"],
                namespace=var["job_job_storage_mount_configuration_details_list_namespace"],
                prefix=var["job_job_storage_mount_configuration_details_list_prefix"],
            )])
        ```

        ## Import

        Jobs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataScience/job:Job test_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            JobArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_content_disposition: Optional[pulumi.Input[str]] = None,
                 artifact_content_length: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 delete_related_job_runs: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 job_artifact: Optional[pulumi.Input[str]] = None,
                 job_configuration_details: Optional[pulumi.Input[pulumi.InputType['JobJobConfigurationDetailsArgs']]] = None,
                 job_infrastructure_configuration_details: Optional[pulumi.Input[pulumi.InputType['JobJobInfrastructureConfigurationDetailsArgs']]] = None,
                 job_log_configuration_details: Optional[pulumi.Input[pulumi.InputType['JobJobLogConfigurationDetailsArgs']]] = None,
                 job_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobJobStorageMountConfigurationDetailsListArgs']]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["artifact_content_disposition"] = artifact_content_disposition
            __props__.__dict__["artifact_content_length"] = artifact_content_length
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["delete_related_job_runs"] = delete_related_job_runs
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["job_artifact"] = job_artifact
            if job_configuration_details is not None and not isinstance(job_configuration_details, JobJobConfigurationDetailsArgs):
                job_configuration_details = job_configuration_details or {}
                def _setter(key, value):
                    job_configuration_details[key] = value
                JobJobConfigurationDetailsArgs._configure(_setter, **job_configuration_details)
            if job_configuration_details is None and not opts.urn:
                raise TypeError("Missing required property 'job_configuration_details'")
            __props__.__dict__["job_configuration_details"] = job_configuration_details
            if job_infrastructure_configuration_details is not None and not isinstance(job_infrastructure_configuration_details, JobJobInfrastructureConfigurationDetailsArgs):
                job_infrastructure_configuration_details = job_infrastructure_configuration_details or {}
                def _setter(key, value):
                    job_infrastructure_configuration_details[key] = value
                JobJobInfrastructureConfigurationDetailsArgs._configure(_setter, **job_infrastructure_configuration_details)
            if job_infrastructure_configuration_details is None and not opts.urn:
                raise TypeError("Missing required property 'job_infrastructure_configuration_details'")
            __props__.__dict__["job_infrastructure_configuration_details"] = job_infrastructure_configuration_details
            if job_log_configuration_details is not None and not isinstance(job_log_configuration_details, JobJobLogConfigurationDetailsArgs):
                job_log_configuration_details = job_log_configuration_details or {}
                def _setter(key, value):
                    job_log_configuration_details[key] = value
                JobJobLogConfigurationDetailsArgs._configure(_setter, **job_log_configuration_details)
            __props__.__dict__["job_log_configuration_details"] = job_log_configuration_details
            __props__.__dict__["job_storage_mount_configuration_details_lists"] = job_storage_mount_configuration_details_lists
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["artifact_content_md5"] = None
            __props__.__dict__["artifact_last_modified"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["empty_artifact"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(Job, __self__).__init__(
            'oci:DataScience/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            artifact_content_disposition: Optional[pulumi.Input[str]] = None,
            artifact_content_length: Optional[pulumi.Input[str]] = None,
            artifact_content_md5: Optional[pulumi.Input[str]] = None,
            artifact_last_modified: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            delete_related_job_runs: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            empty_artifact: Optional[pulumi.Input[bool]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            job_artifact: Optional[pulumi.Input[str]] = None,
            job_configuration_details: Optional[pulumi.Input[pulumi.InputType['JobJobConfigurationDetailsArgs']]] = None,
            job_infrastructure_configuration_details: Optional[pulumi.Input[pulumi.InputType['JobJobInfrastructureConfigurationDetailsArgs']]] = None,
            job_log_configuration_details: Optional[pulumi.Input[pulumi.InputType['JobJobLogConfigurationDetailsArgs']]] = None,
            job_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobJobStorageMountConfigurationDetailsListArgs']]]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artifact_content_disposition: This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=job-artifact.py`
        :param pulumi.Input[str] artifact_content_length: The content length of the body.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the project.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[bool] delete_related_job_runs: (Updatable) Delete all related JobRuns upon deletion of the Job.
        :param pulumi.Input[str] description: (Updatable) A short description of the job.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] job_artifact: The job artifact to upload. This can be done in a separate step or from cli/sdk. The Job will remain in "Creating" state until its artifact is uploaded.
        :param pulumi.Input[pulumi.InputType['JobJobConfigurationDetailsArgs']] job_configuration_details: The job configuration details
        :param pulumi.Input[pulumi.InputType['JobJobInfrastructureConfigurationDetailsArgs']] job_infrastructure_configuration_details: (Updatable) The job infrastructure configuration details (shape, block storage, etc.)
        :param pulumi.Input[pulumi.InputType['JobJobLogConfigurationDetailsArgs']] job_log_configuration_details: Logging configuration for resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobJobStorageMountConfigurationDetailsListArgs']]]] job_storage_mount_configuration_details_lists: (Updatable) Collection of JobStorageMountConfigurationDetails.
        :param pulumi.Input[str] lifecycle_details: The state of the job.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
        :param pulumi.Input[str] state: The state of the job.
        :param pulumi.Input[str] time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["artifact_content_disposition"] = artifact_content_disposition
        __props__.__dict__["artifact_content_length"] = artifact_content_length
        __props__.__dict__["artifact_content_md5"] = artifact_content_md5
        __props__.__dict__["artifact_last_modified"] = artifact_last_modified
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["delete_related_job_runs"] = delete_related_job_runs
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["empty_artifact"] = empty_artifact
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["job_artifact"] = job_artifact
        __props__.__dict__["job_configuration_details"] = job_configuration_details
        __props__.__dict__["job_infrastructure_configuration_details"] = job_infrastructure_configuration_details
        __props__.__dict__["job_log_configuration_details"] = job_log_configuration_details
        __props__.__dict__["job_storage_mount_configuration_details_lists"] = job_storage_mount_configuration_details_lists
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="artifactContentDisposition")
    def artifact_content_disposition(self) -> pulumi.Output[Optional[str]]:
        """
        This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=job-artifact.py`
        """
        return pulumi.get(self, "artifact_content_disposition")

    @property
    @pulumi.getter(name="artifactContentLength")
    def artifact_content_length(self) -> pulumi.Output[Optional[str]]:
        """
        The content length of the body.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "artifact_content_length")

    @property
    @pulumi.getter(name="artifactContentMd5")
    def artifact_content_md5(self) -> pulumi.Output[str]:
        return pulumi.get(self, "artifact_content_md5")

    @property
    @pulumi.getter(name="artifactLastModified")
    def artifact_last_modified(self) -> pulumi.Output[str]:
        return pulumi.get(self, "artifact_last_modified")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the job.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the project.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deleteRelatedJobRuns")
    def delete_related_job_runs(self) -> pulumi.Output[Optional[bool]]:
        """
        (Updatable) Delete all related JobRuns upon deletion of the Job.
        """
        return pulumi.get(self, "delete_related_job_runs")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) A short description of the job.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="emptyArtifact")
    def empty_artifact(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "empty_artifact")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="jobArtifact")
    def job_artifact(self) -> pulumi.Output[Optional[str]]:
        """
        The job artifact to upload. This can be done in a separate step or from cli/sdk. The Job will remain in "Creating" state until its artifact is uploaded.
        """
        return pulumi.get(self, "job_artifact")

    @property
    @pulumi.getter(name="jobConfigurationDetails")
    def job_configuration_details(self) -> pulumi.Output['outputs.JobJobConfigurationDetails']:
        """
        The job configuration details
        """
        return pulumi.get(self, "job_configuration_details")

    @property
    @pulumi.getter(name="jobInfrastructureConfigurationDetails")
    def job_infrastructure_configuration_details(self) -> pulumi.Output['outputs.JobJobInfrastructureConfigurationDetails']:
        """
        (Updatable) The job infrastructure configuration details (shape, block storage, etc.)
        """
        return pulumi.get(self, "job_infrastructure_configuration_details")

    @property
    @pulumi.getter(name="jobLogConfigurationDetails")
    def job_log_configuration_details(self) -> pulumi.Output['outputs.JobJobLogConfigurationDetails']:
        """
        Logging configuration for resource.
        """
        return pulumi.get(self, "job_log_configuration_details")

    @property
    @pulumi.getter(name="jobStorageMountConfigurationDetailsLists")
    def job_storage_mount_configuration_details_lists(self) -> pulumi.Output[Sequence['outputs.JobJobStorageMountConfigurationDetailsList']]:
        """
        (Updatable) Collection of JobStorageMountConfigurationDetails.
        """
        return pulumi.get(self, "job_storage_mount_configuration_details_lists")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        The state of the job.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the job with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        """
        return pulumi.get(self, "time_created")

