# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BuildRunArgs', 'BuildRun']

@pulumi.input_type
class BuildRunArgs:
    def __init__(__self__, *,
                 build_pipeline_id: pulumi.Input[str],
                 build_run_arguments: Optional[pulumi.Input['BuildRunBuildRunArgumentsArgs']] = None,
                 commit_info: Optional[pulumi.Input['BuildRunCommitInfoArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a BuildRun resource.
        :param pulumi.Input[str] build_pipeline_id: The OCID of the build pipeline.
        :param pulumi.Input['BuildRunBuildRunArgumentsArgs'] build_run_arguments: Specifies list of arguments passed along with the build run.
        :param pulumi.Input['BuildRunCommitInfoArgs'] commit_info: Commit details that need to be used for the build run.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Build run display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        BuildRunArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            build_pipeline_id=build_pipeline_id,
            build_run_arguments=build_run_arguments,
            commit_info=commit_info,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             build_pipeline_id: pulumi.Input[str],
             build_run_arguments: Optional[pulumi.Input['BuildRunBuildRunArgumentsArgs']] = None,
             commit_info: Optional[pulumi.Input['BuildRunCommitInfoArgs']] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'buildPipelineId' in kwargs:
            build_pipeline_id = kwargs['buildPipelineId']
        if 'buildRunArguments' in kwargs:
            build_run_arguments = kwargs['buildRunArguments']
        if 'commitInfo' in kwargs:
            commit_info = kwargs['commitInfo']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']

        _setter("build_pipeline_id", build_pipeline_id)
        if build_run_arguments is not None:
            _setter("build_run_arguments", build_run_arguments)
        if commit_info is not None:
            _setter("commit_info", commit_info)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="buildPipelineId")
    def build_pipeline_id(self) -> pulumi.Input[str]:
        """
        The OCID of the build pipeline.
        """
        return pulumi.get(self, "build_pipeline_id")

    @build_pipeline_id.setter
    def build_pipeline_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "build_pipeline_id", value)

    @property
    @pulumi.getter(name="buildRunArguments")
    def build_run_arguments(self) -> Optional[pulumi.Input['BuildRunBuildRunArgumentsArgs']]:
        """
        Specifies list of arguments passed along with the build run.
        """
        return pulumi.get(self, "build_run_arguments")

    @build_run_arguments.setter
    def build_run_arguments(self, value: Optional[pulumi.Input['BuildRunBuildRunArgumentsArgs']]):
        pulumi.set(self, "build_run_arguments", value)

    @property
    @pulumi.getter(name="commitInfo")
    def commit_info(self) -> Optional[pulumi.Input['BuildRunCommitInfoArgs']]:
        """
        Commit details that need to be used for the build run.
        """
        return pulumi.get(self, "commit_info")

    @commit_info.setter
    def commit_info(self, value: Optional[pulumi.Input['BuildRunCommitInfoArgs']]):
        pulumi.set(self, "commit_info", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Build run display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _BuildRunState:
    def __init__(__self__, *,
                 build_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildOutputArgs']]]] = None,
                 build_pipeline_id: Optional[pulumi.Input[str]] = None,
                 build_run_arguments: Optional[pulumi.Input['BuildRunBuildRunArgumentsArgs']] = None,
                 build_run_progresses: Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunProgressArgs']]]] = None,
                 build_run_sources: Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunSourceArgs']]]] = None,
                 commit_info: Optional[pulumi.Input['BuildRunCommitInfoArgs']] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BuildRun resources.
        :param pulumi.Input[Sequence[pulumi.Input['BuildRunBuildOutputArgs']]] build_outputs: Outputs from the build.
        :param pulumi.Input[str] build_pipeline_id: The OCID of the build pipeline.
        :param pulumi.Input['BuildRunBuildRunArgumentsArgs'] build_run_arguments: Specifies list of arguments passed along with the build run.
        :param pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunProgressArgs']]] build_run_progresses: The run progress details of a build run.
        :param pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunSourceArgs']]] build_run_sources: The source from which the build run is triggered.
        :param pulumi.Input['BuildRunCommitInfoArgs'] commit_info: Commit details that need to be used for the build run.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment where the build is running.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Build run display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] project_id: The OCID of the DevOps project.
        :param pulumi.Input[str] state: The current state of the build run.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the build run was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[str] time_updated: The time the build run was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        _BuildRunState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            build_outputs=build_outputs,
            build_pipeline_id=build_pipeline_id,
            build_run_arguments=build_run_arguments,
            build_run_progresses=build_run_progresses,
            build_run_sources=build_run_sources,
            commit_info=commit_info,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            lifecycle_details=lifecycle_details,
            project_id=project_id,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             build_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildOutputArgs']]]] = None,
             build_pipeline_id: Optional[pulumi.Input[str]] = None,
             build_run_arguments: Optional[pulumi.Input['BuildRunBuildRunArgumentsArgs']] = None,
             build_run_progresses: Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunProgressArgs']]]] = None,
             build_run_sources: Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunSourceArgs']]]] = None,
             commit_info: Optional[pulumi.Input['BuildRunCommitInfoArgs']] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             project_id: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'buildOutputs' in kwargs:
            build_outputs = kwargs['buildOutputs']
        if 'buildPipelineId' in kwargs:
            build_pipeline_id = kwargs['buildPipelineId']
        if 'buildRunArguments' in kwargs:
            build_run_arguments = kwargs['buildRunArguments']
        if 'buildRunProgresses' in kwargs:
            build_run_progresses = kwargs['buildRunProgresses']
        if 'buildRunSources' in kwargs:
            build_run_sources = kwargs['buildRunSources']
        if 'commitInfo' in kwargs:
            commit_info = kwargs['commitInfo']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        if build_outputs is not None:
            _setter("build_outputs", build_outputs)
        if build_pipeline_id is not None:
            _setter("build_pipeline_id", build_pipeline_id)
        if build_run_arguments is not None:
            _setter("build_run_arguments", build_run_arguments)
        if build_run_progresses is not None:
            _setter("build_run_progresses", build_run_progresses)
        if build_run_sources is not None:
            _setter("build_run_sources", build_run_sources)
        if commit_info is not None:
            _setter("commit_info", commit_info)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if project_id is not None:
            _setter("project_id", project_id)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="buildOutputs")
    def build_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildOutputArgs']]]]:
        """
        Outputs from the build.
        """
        return pulumi.get(self, "build_outputs")

    @build_outputs.setter
    def build_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildOutputArgs']]]]):
        pulumi.set(self, "build_outputs", value)

    @property
    @pulumi.getter(name="buildPipelineId")
    def build_pipeline_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the build pipeline.
        """
        return pulumi.get(self, "build_pipeline_id")

    @build_pipeline_id.setter
    def build_pipeline_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_pipeline_id", value)

    @property
    @pulumi.getter(name="buildRunArguments")
    def build_run_arguments(self) -> Optional[pulumi.Input['BuildRunBuildRunArgumentsArgs']]:
        """
        Specifies list of arguments passed along with the build run.
        """
        return pulumi.get(self, "build_run_arguments")

    @build_run_arguments.setter
    def build_run_arguments(self, value: Optional[pulumi.Input['BuildRunBuildRunArgumentsArgs']]):
        pulumi.set(self, "build_run_arguments", value)

    @property
    @pulumi.getter(name="buildRunProgresses")
    def build_run_progresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunProgressArgs']]]]:
        """
        The run progress details of a build run.
        """
        return pulumi.get(self, "build_run_progresses")

    @build_run_progresses.setter
    def build_run_progresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunProgressArgs']]]]):
        pulumi.set(self, "build_run_progresses", value)

    @property
    @pulumi.getter(name="buildRunSources")
    def build_run_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunSourceArgs']]]]:
        """
        The source from which the build run is triggered.
        """
        return pulumi.get(self, "build_run_sources")

    @build_run_sources.setter
    def build_run_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BuildRunBuildRunSourceArgs']]]]):
        pulumi.set(self, "build_run_sources", value)

    @property
    @pulumi.getter(name="commitInfo")
    def commit_info(self) -> Optional[pulumi.Input['BuildRunCommitInfoArgs']]:
        """
        Commit details that need to be used for the build run.
        """
        return pulumi.get(self, "commit_info")

    @commit_info.setter
    def commit_info(self, value: Optional[pulumi.Input['BuildRunCommitInfoArgs']]):
        pulumi.set(self, "commit_info", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment where the build is running.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Build run display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the DevOps project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the build run.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the build run was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the build run was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class BuildRun(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_pipeline_id: Optional[pulumi.Input[str]] = None,
                 build_run_arguments: Optional[pulumi.Input[pulumi.InputType['BuildRunBuildRunArgumentsArgs']]] = None,
                 commit_info: Optional[pulumi.Input[pulumi.InputType['BuildRunCommitInfoArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        """
        This resource provides the Build Run resource in Oracle Cloud Infrastructure Devops service.

        Starts a build pipeline run for a predefined build pipeline. Please ensure the completion of any work request for creation/updation of Build Pipeline before starting a Build Run.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_build_run = oci.dev_ops.BuildRun("testBuildRun",
            build_pipeline_id=oci_devops_build_pipeline["test_build_pipeline"]["id"],
            build_run_arguments=oci.dev_ops.BuildRunBuildRunArgumentsArgs(
                items=[oci.dev_ops.BuildRunBuildRunArgumentsItemArgs(
                    name=var["build_run_build_run_arguments_items_name"],
                    value=var["build_run_build_run_arguments_items_value"],
                )],
            ),
            commit_info=oci.dev_ops.BuildRunCommitInfoArgs(
                commit_hash=var["build_run_commit_info_commit_hash"],
                repository_branch=var["build_run_commit_info_repository_branch"],
                repository_url=var["build_run_commit_info_repository_url"],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=var["build_run_display_name"],
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        BuildRuns can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DevOps/buildRun:BuildRun test_build_run "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] build_pipeline_id: The OCID of the build pipeline.
        :param pulumi.Input[pulumi.InputType['BuildRunBuildRunArgumentsArgs']] build_run_arguments: Specifies list of arguments passed along with the build run.
        :param pulumi.Input[pulumi.InputType['BuildRunCommitInfoArgs']] commit_info: Commit details that need to be used for the build run.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Build run display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BuildRunArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Build Run resource in Oracle Cloud Infrastructure Devops service.

        Starts a build pipeline run for a predefined build pipeline. Please ensure the completion of any work request for creation/updation of Build Pipeline before starting a Build Run.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_build_run = oci.dev_ops.BuildRun("testBuildRun",
            build_pipeline_id=oci_devops_build_pipeline["test_build_pipeline"]["id"],
            build_run_arguments=oci.dev_ops.BuildRunBuildRunArgumentsArgs(
                items=[oci.dev_ops.BuildRunBuildRunArgumentsItemArgs(
                    name=var["build_run_build_run_arguments_items_name"],
                    value=var["build_run_build_run_arguments_items_value"],
                )],
            ),
            commit_info=oci.dev_ops.BuildRunCommitInfoArgs(
                commit_hash=var["build_run_commit_info_commit_hash"],
                repository_branch=var["build_run_commit_info_repository_branch"],
                repository_url=var["build_run_commit_info_repository_url"],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=var["build_run_display_name"],
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        BuildRuns can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DevOps/buildRun:BuildRun test_build_run "id"
        ```

        :param str resource_name: The name of the resource.
        :param BuildRunArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BuildRunArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            BuildRunArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_pipeline_id: Optional[pulumi.Input[str]] = None,
                 build_run_arguments: Optional[pulumi.Input[pulumi.InputType['BuildRunBuildRunArgumentsArgs']]] = None,
                 commit_info: Optional[pulumi.Input[pulumi.InputType['BuildRunCommitInfoArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BuildRunArgs.__new__(BuildRunArgs)

            if build_pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'build_pipeline_id'")
            __props__.__dict__["build_pipeline_id"] = build_pipeline_id
            if build_run_arguments is not None and not isinstance(build_run_arguments, BuildRunBuildRunArgumentsArgs):
                build_run_arguments = build_run_arguments or {}
                def _setter(key, value):
                    build_run_arguments[key] = value
                BuildRunBuildRunArgumentsArgs._configure(_setter, **build_run_arguments)
            __props__.__dict__["build_run_arguments"] = build_run_arguments
            if commit_info is not None and not isinstance(commit_info, BuildRunCommitInfoArgs):
                commit_info = commit_info or {}
                def _setter(key, value):
                    commit_info[key] = value
                BuildRunCommitInfoArgs._configure(_setter, **commit_info)
            __props__.__dict__["commit_info"] = commit_info
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["build_outputs"] = None
            __props__.__dict__["build_run_progresses"] = None
            __props__.__dict__["build_run_sources"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(BuildRun, __self__).__init__(
            'oci:DevOps/buildRun:BuildRun',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            build_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BuildRunBuildOutputArgs']]]]] = None,
            build_pipeline_id: Optional[pulumi.Input[str]] = None,
            build_run_arguments: Optional[pulumi.Input[pulumi.InputType['BuildRunBuildRunArgumentsArgs']]] = None,
            build_run_progresses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BuildRunBuildRunProgressArgs']]]]] = None,
            build_run_sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BuildRunBuildRunSourceArgs']]]]] = None,
            commit_info: Optional[pulumi.Input[pulumi.InputType['BuildRunCommitInfoArgs']]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'BuildRun':
        """
        Get an existing BuildRun resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BuildRunBuildOutputArgs']]]] build_outputs: Outputs from the build.
        :param pulumi.Input[str] build_pipeline_id: The OCID of the build pipeline.
        :param pulumi.Input[pulumi.InputType['BuildRunBuildRunArgumentsArgs']] build_run_arguments: Specifies list of arguments passed along with the build run.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BuildRunBuildRunProgressArgs']]]] build_run_progresses: The run progress details of a build run.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BuildRunBuildRunSourceArgs']]]] build_run_sources: The source from which the build run is triggered.
        :param pulumi.Input[pulumi.InputType['BuildRunCommitInfoArgs']] commit_info: Commit details that need to be used for the build run.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment where the build is running.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Build run display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] project_id: The OCID of the DevOps project.
        :param pulumi.Input[str] state: The current state of the build run.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the build run was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[str] time_updated: The time the build run was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BuildRunState.__new__(_BuildRunState)

        __props__.__dict__["build_outputs"] = build_outputs
        __props__.__dict__["build_pipeline_id"] = build_pipeline_id
        __props__.__dict__["build_run_arguments"] = build_run_arguments
        __props__.__dict__["build_run_progresses"] = build_run_progresses
        __props__.__dict__["build_run_sources"] = build_run_sources
        __props__.__dict__["commit_info"] = commit_info
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return BuildRun(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="buildOutputs")
    def build_outputs(self) -> pulumi.Output[Sequence['outputs.BuildRunBuildOutput']]:
        """
        Outputs from the build.
        """
        return pulumi.get(self, "build_outputs")

    @property
    @pulumi.getter(name="buildPipelineId")
    def build_pipeline_id(self) -> pulumi.Output[str]:
        """
        The OCID of the build pipeline.
        """
        return pulumi.get(self, "build_pipeline_id")

    @property
    @pulumi.getter(name="buildRunArguments")
    def build_run_arguments(self) -> pulumi.Output['outputs.BuildRunBuildRunArguments']:
        """
        Specifies list of arguments passed along with the build run.
        """
        return pulumi.get(self, "build_run_arguments")

    @property
    @pulumi.getter(name="buildRunProgresses")
    def build_run_progresses(self) -> pulumi.Output[Sequence['outputs.BuildRunBuildRunProgress']]:
        """
        The run progress details of a build run.
        """
        return pulumi.get(self, "build_run_progresses")

    @property
    @pulumi.getter(name="buildRunSources")
    def build_run_sources(self) -> pulumi.Output[Sequence['outputs.BuildRunBuildRunSource']]:
        """
        The source from which the build run is triggered.
        """
        return pulumi.get(self, "build_run_sources")

    @property
    @pulumi.getter(name="commitInfo")
    def commit_info(self) -> pulumi.Output['outputs.BuildRunCommitInfo']:
        """
        Commit details that need to be used for the build run.
        """
        return pulumi.get(self, "commit_info")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment where the build is running.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Build run display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The OCID of the DevOps project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the build run.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the build run was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the build run was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

