# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetRepositoryCommitResult',
    'AwaitableGetRepositoryCommitResult',
    'get_repository_commit',
    'get_repository_commit_output',
]

@pulumi.output_type
class GetRepositoryCommitResult:
    """
    A collection of values returned by getRepositoryCommit.
    """
    def __init__(__self__, author_email=None, author_name=None, commit_id=None, commit_message=None, committer_email=None, committer_name=None, id=None, parent_commit_ids=None, repository_id=None, time_created=None, tree_id=None):
        if author_email and not isinstance(author_email, str):
            raise TypeError("Expected argument 'author_email' to be a str")
        pulumi.set(__self__, "author_email", author_email)
        if author_name and not isinstance(author_name, str):
            raise TypeError("Expected argument 'author_name' to be a str")
        pulumi.set(__self__, "author_name", author_name)
        if commit_id and not isinstance(commit_id, str):
            raise TypeError("Expected argument 'commit_id' to be a str")
        pulumi.set(__self__, "commit_id", commit_id)
        if commit_message and not isinstance(commit_message, str):
            raise TypeError("Expected argument 'commit_message' to be a str")
        pulumi.set(__self__, "commit_message", commit_message)
        if committer_email and not isinstance(committer_email, str):
            raise TypeError("Expected argument 'committer_email' to be a str")
        pulumi.set(__self__, "committer_email", committer_email)
        if committer_name and not isinstance(committer_name, str):
            raise TypeError("Expected argument 'committer_name' to be a str")
        pulumi.set(__self__, "committer_name", committer_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if parent_commit_ids and not isinstance(parent_commit_ids, list):
            raise TypeError("Expected argument 'parent_commit_ids' to be a list")
        pulumi.set(__self__, "parent_commit_ids", parent_commit_ids)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if tree_id and not isinstance(tree_id, str):
            raise TypeError("Expected argument 'tree_id' to be a str")
        pulumi.set(__self__, "tree_id", tree_id)

    @property
    @pulumi.getter(name="authorEmail")
    def author_email(self) -> str:
        """
        Email of the author of the repository.
        """
        return pulumi.get(self, "author_email")

    @property
    @pulumi.getter(name="authorName")
    def author_name(self) -> str:
        """
        Name of the author of the repository.
        """
        return pulumi.get(self, "author_name")

    @property
    @pulumi.getter(name="commitId")
    def commit_id(self) -> str:
        """
        Commit hash pointed to by reference name.
        """
        return pulumi.get(self, "commit_id")

    @property
    @pulumi.getter(name="commitMessage")
    def commit_message(self) -> str:
        """
        The commit message.
        """
        return pulumi.get(self, "commit_message")

    @property
    @pulumi.getter(name="committerEmail")
    def committer_email(self) -> str:
        """
        Email of who creates the commit.
        """
        return pulumi.get(self, "committer_email")

    @property
    @pulumi.getter(name="committerName")
    def committer_name(self) -> str:
        """
        Name of who creates the commit.
        """
        return pulumi.get(self, "committer_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="parentCommitIds")
    def parent_commit_ids(self) -> Sequence[str]:
        """
        An array of parent commit IDs of created commit.
        """
        return pulumi.get(self, "parent_commit_ids")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time at which commit was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="treeId")
    def tree_id(self) -> str:
        """
        Tree information for the specified commit.
        """
        return pulumi.get(self, "tree_id")


class AwaitableGetRepositoryCommitResult(GetRepositoryCommitResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryCommitResult(
            author_email=self.author_email,
            author_name=self.author_name,
            commit_id=self.commit_id,
            commit_message=self.commit_message,
            committer_email=self.committer_email,
            committer_name=self.committer_name,
            id=self.id,
            parent_commit_ids=self.parent_commit_ids,
            repository_id=self.repository_id,
            time_created=self.time_created,
            tree_id=self.tree_id)


def get_repository_commit(commit_id: Optional[str] = None,
                          repository_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryCommitResult:
    """
    This data source provides details about a specific Repository Commit resource in Oracle Cloud Infrastructure Devops service.

    Retrieves a repository's commit by commit ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_commit = oci.DevOps.get_repository_commit(commit_id=oci_devops_commit["test_commit"]["id"],
        repository_id=oci_devops_repository["test_repository"]["id"])
    ```


    :param str commit_id: A filter to return only resources that match the given commit ID.
    :param str repository_id: Unique repository identifier.
    """
    __args__ = dict()
    __args__['commitId'] = commit_id
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getRepositoryCommit:getRepositoryCommit', __args__, opts=opts, typ=GetRepositoryCommitResult).value

    return AwaitableGetRepositoryCommitResult(
        author_email=pulumi.get(__ret__, 'author_email'),
        author_name=pulumi.get(__ret__, 'author_name'),
        commit_id=pulumi.get(__ret__, 'commit_id'),
        commit_message=pulumi.get(__ret__, 'commit_message'),
        committer_email=pulumi.get(__ret__, 'committer_email'),
        committer_name=pulumi.get(__ret__, 'committer_name'),
        id=pulumi.get(__ret__, 'id'),
        parent_commit_ids=pulumi.get(__ret__, 'parent_commit_ids'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        tree_id=pulumi.get(__ret__, 'tree_id'))


@_utilities.lift_output_func(get_repository_commit)
def get_repository_commit_output(commit_id: Optional[pulumi.Input[str]] = None,
                                 repository_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRepositoryCommitResult]:
    """
    This data source provides details about a specific Repository Commit resource in Oracle Cloud Infrastructure Devops service.

    Retrieves a repository's commit by commit ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_commit = oci.DevOps.get_repository_commit(commit_id=oci_devops_commit["test_commit"]["id"],
        repository_id=oci_devops_repository["test_repository"]["id"])
    ```


    :param str commit_id: A filter to return only resources that match the given commit ID.
    :param str repository_id: Unique repository identifier.
    """
    ...
