# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DrPlanExecutionArgs', 'DrPlanExecution']

@pulumi.input_type
class DrPlanExecutionArgs:
    def __init__(__self__, *,
                 execution_options: pulumi.Input['DrPlanExecutionExecutionOptionsArgs'],
                 plan_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a DrPlanExecution resource.
        :param pulumi.Input['DrPlanExecutionExecutionOptionsArgs'] execution_options: The options for a plan execution.
        :param pulumi.Input[str] plan_id: The OCID of the DR Plan.  Example: `ocid1.drplan.oc1.iad.&lt;unique_id&gt;` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) The display name of the DR Plan Execution.  Example: `Execution - EBS Switchover PHX to IAD`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        DrPlanExecutionArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            execution_options=execution_options,
            plan_id=plan_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             execution_options: pulumi.Input['DrPlanExecutionExecutionOptionsArgs'],
             plan_id: pulumi.Input[str],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'executionOptions' in kwargs:
            execution_options = kwargs['executionOptions']
        if 'planId' in kwargs:
            plan_id = kwargs['planId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']

        _setter("execution_options", execution_options)
        _setter("plan_id", plan_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="executionOptions")
    def execution_options(self) -> pulumi.Input['DrPlanExecutionExecutionOptionsArgs']:
        """
        The options for a plan execution.
        """
        return pulumi.get(self, "execution_options")

    @execution_options.setter
    def execution_options(self, value: pulumi.Input['DrPlanExecutionExecutionOptionsArgs']):
        pulumi.set(self, "execution_options", value)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Input[str]:
        """
        The OCID of the DR Plan.  Example: `ocid1.drplan.oc1.iad.&lt;unique_id&gt;` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the DR Plan Execution.  Example: `Execution - EBS Switchover PHX to IAD`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _DrPlanExecutionState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dr_protection_group_id: Optional[pulumi.Input[str]] = None,
                 execution_duration_in_sec: Optional[pulumi.Input[int]] = None,
                 execution_options: Optional[pulumi.Input['DrPlanExecutionExecutionOptionsArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 group_executions: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionArgs']]]] = None,
                 life_cycle_details: Optional[pulumi.Input[str]] = None,
                 log_locations: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionLogLocationArgs']]]] = None,
                 peer_dr_protection_group_id: Optional[pulumi.Input[str]] = None,
                 peer_region: Optional[pulumi.Input[str]] = None,
                 plan_execution_type: Optional[pulumi.Input[str]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_ended: Optional[pulumi.Input[str]] = None,
                 time_started: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DrPlanExecution resources.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment containing this DR Plan Execution.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) The display name of the DR Plan Execution.  Example: `Execution - EBS Switchover PHX to IAD`
        :param pulumi.Input[str] dr_protection_group_id: The OCID of the DR Protection Group to which this DR Plan Execution belongs.  Example: `ocid1.drprotectiongroup.oc1.iad.&lt;unique_id&gt;`
        :param pulumi.Input[int] execution_duration_in_sec: The total duration in seconds taken to complete step execution.  Example: `35`
        :param pulumi.Input['DrPlanExecutionExecutionOptionsArgs'] execution_options: The options for a plan execution.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionArgs']]] group_executions: A list of groups executed in this DR Plan Execution.
        :param pulumi.Input[str] life_cycle_details: A message describing the DR Plan Execution's current state in more detail.  Example: `The DR Plan Execution [Execution - EBS Switchover PHX to IAD] is currently in progress`
        :param pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionLogLocationArgs']]] log_locations: Information about an Object Storage log location for a DR Protection Group.
        :param pulumi.Input[str] peer_dr_protection_group_id: The OCID of peer (remote) DR Protection Group associated with this plan's DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.phx.&lt;unique_id&gt;`
        :param pulumi.Input[str] peer_region: The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        :param pulumi.Input[str] plan_execution_type: The type of the plan execution.
        :param pulumi.Input[str] plan_id: The OCID of the DR Plan.  Example: `ocid1.drplan.oc1.iad.&lt;unique_id&gt;` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the DR Plan Execution.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time at which DR Plan Execution was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[str] time_ended: The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[str] time_started: The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[str] time_updated: The time at which DR Plan Execution was last updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        _DrPlanExecutionState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            dr_protection_group_id=dr_protection_group_id,
            execution_duration_in_sec=execution_duration_in_sec,
            execution_options=execution_options,
            freeform_tags=freeform_tags,
            group_executions=group_executions,
            life_cycle_details=life_cycle_details,
            log_locations=log_locations,
            peer_dr_protection_group_id=peer_dr_protection_group_id,
            peer_region=peer_region,
            plan_execution_type=plan_execution_type,
            plan_id=plan_id,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_ended=time_ended,
            time_started=time_started,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             dr_protection_group_id: Optional[pulumi.Input[str]] = None,
             execution_duration_in_sec: Optional[pulumi.Input[int]] = None,
             execution_options: Optional[pulumi.Input['DrPlanExecutionExecutionOptionsArgs']] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             group_executions: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionArgs']]]] = None,
             life_cycle_details: Optional[pulumi.Input[str]] = None,
             log_locations: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionLogLocationArgs']]]] = None,
             peer_dr_protection_group_id: Optional[pulumi.Input[str]] = None,
             peer_region: Optional[pulumi.Input[str]] = None,
             plan_execution_type: Optional[pulumi.Input[str]] = None,
             plan_id: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_ended: Optional[pulumi.Input[str]] = None,
             time_started: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'drProtectionGroupId' in kwargs:
            dr_protection_group_id = kwargs['drProtectionGroupId']
        if 'executionDurationInSec' in kwargs:
            execution_duration_in_sec = kwargs['executionDurationInSec']
        if 'executionOptions' in kwargs:
            execution_options = kwargs['executionOptions']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'groupExecutions' in kwargs:
            group_executions = kwargs['groupExecutions']
        if 'lifeCycleDetails' in kwargs:
            life_cycle_details = kwargs['lifeCycleDetails']
        if 'logLocations' in kwargs:
            log_locations = kwargs['logLocations']
        if 'peerDrProtectionGroupId' in kwargs:
            peer_dr_protection_group_id = kwargs['peerDrProtectionGroupId']
        if 'peerRegion' in kwargs:
            peer_region = kwargs['peerRegion']
        if 'planExecutionType' in kwargs:
            plan_execution_type = kwargs['planExecutionType']
        if 'planId' in kwargs:
            plan_id = kwargs['planId']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeEnded' in kwargs:
            time_ended = kwargs['timeEnded']
        if 'timeStarted' in kwargs:
            time_started = kwargs['timeStarted']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if dr_protection_group_id is not None:
            _setter("dr_protection_group_id", dr_protection_group_id)
        if execution_duration_in_sec is not None:
            _setter("execution_duration_in_sec", execution_duration_in_sec)
        if execution_options is not None:
            _setter("execution_options", execution_options)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if group_executions is not None:
            _setter("group_executions", group_executions)
        if life_cycle_details is not None:
            _setter("life_cycle_details", life_cycle_details)
        if log_locations is not None:
            _setter("log_locations", log_locations)
        if peer_dr_protection_group_id is not None:
            _setter("peer_dr_protection_group_id", peer_dr_protection_group_id)
        if peer_region is not None:
            _setter("peer_region", peer_region)
        if plan_execution_type is not None:
            _setter("plan_execution_type", plan_execution_type)
        if plan_id is not None:
            _setter("plan_id", plan_id)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_ended is not None:
            _setter("time_ended", time_ended)
        if time_started is not None:
            _setter("time_started", time_started)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment containing this DR Plan Execution.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the DR Plan Execution.  Example: `Execution - EBS Switchover PHX to IAD`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the DR Protection Group to which this DR Plan Execution belongs.  Example: `ocid1.drprotectiongroup.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @dr_protection_group_id.setter
    def dr_protection_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dr_protection_group_id", value)

    @property
    @pulumi.getter(name="executionDurationInSec")
    def execution_duration_in_sec(self) -> Optional[pulumi.Input[int]]:
        """
        The total duration in seconds taken to complete step execution.  Example: `35`
        """
        return pulumi.get(self, "execution_duration_in_sec")

    @execution_duration_in_sec.setter
    def execution_duration_in_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "execution_duration_in_sec", value)

    @property
    @pulumi.getter(name="executionOptions")
    def execution_options(self) -> Optional[pulumi.Input['DrPlanExecutionExecutionOptionsArgs']]:
        """
        The options for a plan execution.
        """
        return pulumi.get(self, "execution_options")

    @execution_options.setter
    def execution_options(self, value: Optional[pulumi.Input['DrPlanExecutionExecutionOptionsArgs']]):
        pulumi.set(self, "execution_options", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="groupExecutions")
    def group_executions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionArgs']]]]:
        """
        A list of groups executed in this DR Plan Execution.
        """
        return pulumi.get(self, "group_executions")

    @group_executions.setter
    def group_executions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionArgs']]]]):
        pulumi.set(self, "group_executions", value)

    @property
    @pulumi.getter(name="lifeCycleDetails")
    def life_cycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the DR Plan Execution's current state in more detail.  Example: `The DR Plan Execution [Execution - EBS Switchover PHX to IAD] is currently in progress`
        """
        return pulumi.get(self, "life_cycle_details")

    @life_cycle_details.setter
    def life_cycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "life_cycle_details", value)

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionLogLocationArgs']]]]:
        """
        Information about an Object Storage log location for a DR Protection Group.
        """
        return pulumi.get(self, "log_locations")

    @log_locations.setter
    def log_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionLogLocationArgs']]]]):
        pulumi.set(self, "log_locations", value)

    @property
    @pulumi.getter(name="peerDrProtectionGroupId")
    def peer_dr_protection_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of peer (remote) DR Protection Group associated with this plan's DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "peer_dr_protection_group_id")

    @peer_dr_protection_group_id.setter
    def peer_dr_protection_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_dr_protection_group_id", value)

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "peer_region")

    @peer_region.setter
    def peer_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_region", value)

    @property
    @pulumi.getter(name="planExecutionType")
    def plan_execution_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the plan execution.
        """
        return pulumi.get(self, "plan_execution_type")

    @plan_execution_type.setter
    def plan_execution_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan_execution_type", value)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the DR Plan.  Example: `ocid1.drplan.oc1.iad.&lt;unique_id&gt;` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the DR Plan Execution.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time at which DR Plan Execution was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_ended")

    @time_ended.setter
    def time_ended(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_ended", value)

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_started", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which DR Plan Execution was last updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class DrPlanExecution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 execution_options: Optional[pulumi.Input[pulumi.InputType['DrPlanExecutionExecutionOptionsArgs']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Dr Plan Execution resource in Oracle Cloud Infrastructure Disaster Recovery service.

        Execute a DR Plan for a DR Protection Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_dr_plan_execution = oci.disaster_recovery.DrPlanExecution("testDrPlanExecution",
            execution_options=oci.disaster_recovery.DrPlanExecutionExecutionOptionsArgs(
                plan_execution_type=var["dr_plan_execution_execution_options_plan_execution_type"],
                are_prechecks_enabled=var["dr_plan_execution_execution_options_are_prechecks_enabled"],
                are_warnings_ignored=var["dr_plan_execution_execution_options_are_warnings_ignored"],
            ),
            plan_id=oci_disaster_recovery_plan["test_plan"]["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["dr_plan_execution_display_name"],
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        DrPlanExecutions can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DisasterRecovery/drPlanExecution:DrPlanExecution test_dr_plan_execution "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) The display name of the DR Plan Execution.  Example: `Execution - EBS Switchover PHX to IAD`
        :param pulumi.Input[pulumi.InputType['DrPlanExecutionExecutionOptionsArgs']] execution_options: The options for a plan execution.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] plan_id: The OCID of the DR Plan.  Example: `ocid1.drplan.oc1.iad.&lt;unique_id&gt;` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DrPlanExecutionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Dr Plan Execution resource in Oracle Cloud Infrastructure Disaster Recovery service.

        Execute a DR Plan for a DR Protection Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_dr_plan_execution = oci.disaster_recovery.DrPlanExecution("testDrPlanExecution",
            execution_options=oci.disaster_recovery.DrPlanExecutionExecutionOptionsArgs(
                plan_execution_type=var["dr_plan_execution_execution_options_plan_execution_type"],
                are_prechecks_enabled=var["dr_plan_execution_execution_options_are_prechecks_enabled"],
                are_warnings_ignored=var["dr_plan_execution_execution_options_are_warnings_ignored"],
            ),
            plan_id=oci_disaster_recovery_plan["test_plan"]["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["dr_plan_execution_display_name"],
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        DrPlanExecutions can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DisasterRecovery/drPlanExecution:DrPlanExecution test_dr_plan_execution "id"
        ```

        :param str resource_name: The name of the resource.
        :param DrPlanExecutionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DrPlanExecutionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            DrPlanExecutionArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 execution_options: Optional[pulumi.Input[pulumi.InputType['DrPlanExecutionExecutionOptionsArgs']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DrPlanExecutionArgs.__new__(DrPlanExecutionArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            if execution_options is not None and not isinstance(execution_options, DrPlanExecutionExecutionOptionsArgs):
                execution_options = execution_options or {}
                def _setter(key, value):
                    execution_options[key] = value
                DrPlanExecutionExecutionOptionsArgs._configure(_setter, **execution_options)
            if execution_options is None and not opts.urn:
                raise TypeError("Missing required property 'execution_options'")
            __props__.__dict__["execution_options"] = execution_options
            __props__.__dict__["freeform_tags"] = freeform_tags
            if plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'plan_id'")
            __props__.__dict__["plan_id"] = plan_id
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["dr_protection_group_id"] = None
            __props__.__dict__["execution_duration_in_sec"] = None
            __props__.__dict__["group_executions"] = None
            __props__.__dict__["life_cycle_details"] = None
            __props__.__dict__["log_locations"] = None
            __props__.__dict__["peer_dr_protection_group_id"] = None
            __props__.__dict__["peer_region"] = None
            __props__.__dict__["plan_execution_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_ended"] = None
            __props__.__dict__["time_started"] = None
            __props__.__dict__["time_updated"] = None
        super(DrPlanExecution, __self__).__init__(
            'oci:DisasterRecovery/drPlanExecution:DrPlanExecution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            dr_protection_group_id: Optional[pulumi.Input[str]] = None,
            execution_duration_in_sec: Optional[pulumi.Input[int]] = None,
            execution_options: Optional[pulumi.Input[pulumi.InputType['DrPlanExecutionExecutionOptionsArgs']]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            group_executions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DrPlanExecutionGroupExecutionArgs']]]]] = None,
            life_cycle_details: Optional[pulumi.Input[str]] = None,
            log_locations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DrPlanExecutionLogLocationArgs']]]]] = None,
            peer_dr_protection_group_id: Optional[pulumi.Input[str]] = None,
            peer_region: Optional[pulumi.Input[str]] = None,
            plan_execution_type: Optional[pulumi.Input[str]] = None,
            plan_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_ended: Optional[pulumi.Input[str]] = None,
            time_started: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'DrPlanExecution':
        """
        Get an existing DrPlanExecution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment containing this DR Plan Execution.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) The display name of the DR Plan Execution.  Example: `Execution - EBS Switchover PHX to IAD`
        :param pulumi.Input[str] dr_protection_group_id: The OCID of the DR Protection Group to which this DR Plan Execution belongs.  Example: `ocid1.drprotectiongroup.oc1.iad.&lt;unique_id&gt;`
        :param pulumi.Input[int] execution_duration_in_sec: The total duration in seconds taken to complete step execution.  Example: `35`
        :param pulumi.Input[pulumi.InputType['DrPlanExecutionExecutionOptionsArgs']] execution_options: The options for a plan execution.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DrPlanExecutionGroupExecutionArgs']]]] group_executions: A list of groups executed in this DR Plan Execution.
        :param pulumi.Input[str] life_cycle_details: A message describing the DR Plan Execution's current state in more detail.  Example: `The DR Plan Execution [Execution - EBS Switchover PHX to IAD] is currently in progress`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DrPlanExecutionLogLocationArgs']]]] log_locations: Information about an Object Storage log location for a DR Protection Group.
        :param pulumi.Input[str] peer_dr_protection_group_id: The OCID of peer (remote) DR Protection Group associated with this plan's DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.phx.&lt;unique_id&gt;`
        :param pulumi.Input[str] peer_region: The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        :param pulumi.Input[str] plan_execution_type: The type of the plan execution.
        :param pulumi.Input[str] plan_id: The OCID of the DR Plan.  Example: `ocid1.drplan.oc1.iad.&lt;unique_id&gt;` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the DR Plan Execution.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time at which DR Plan Execution was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[str] time_ended: The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[str] time_started: The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[str] time_updated: The time at which DR Plan Execution was last updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DrPlanExecutionState.__new__(_DrPlanExecutionState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dr_protection_group_id"] = dr_protection_group_id
        __props__.__dict__["execution_duration_in_sec"] = execution_duration_in_sec
        __props__.__dict__["execution_options"] = execution_options
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["group_executions"] = group_executions
        __props__.__dict__["life_cycle_details"] = life_cycle_details
        __props__.__dict__["log_locations"] = log_locations
        __props__.__dict__["peer_dr_protection_group_id"] = peer_dr_protection_group_id
        __props__.__dict__["peer_region"] = peer_region
        __props__.__dict__["plan_execution_type"] = plan_execution_type
        __props__.__dict__["plan_id"] = plan_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_ended"] = time_ended
        __props__.__dict__["time_started"] = time_started
        __props__.__dict__["time_updated"] = time_updated
        return DrPlanExecution(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment containing this DR Plan Execution.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the DR Plan Execution.  Example: `Execution - EBS Switchover PHX to IAD`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> pulumi.Output[str]:
        """
        The OCID of the DR Protection Group to which this DR Plan Execution belongs.  Example: `ocid1.drprotectiongroup.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @property
    @pulumi.getter(name="executionDurationInSec")
    def execution_duration_in_sec(self) -> pulumi.Output[int]:
        """
        The total duration in seconds taken to complete step execution.  Example: `35`
        """
        return pulumi.get(self, "execution_duration_in_sec")

    @property
    @pulumi.getter(name="executionOptions")
    def execution_options(self) -> pulumi.Output['outputs.DrPlanExecutionExecutionOptions']:
        """
        The options for a plan execution.
        """
        return pulumi.get(self, "execution_options")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="groupExecutions")
    def group_executions(self) -> pulumi.Output[Sequence['outputs.DrPlanExecutionGroupExecution']]:
        """
        A list of groups executed in this DR Plan Execution.
        """
        return pulumi.get(self, "group_executions")

    @property
    @pulumi.getter(name="lifeCycleDetails")
    def life_cycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the DR Plan Execution's current state in more detail.  Example: `The DR Plan Execution [Execution - EBS Switchover PHX to IAD] is currently in progress`
        """
        return pulumi.get(self, "life_cycle_details")

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> pulumi.Output[Sequence['outputs.DrPlanExecutionLogLocation']]:
        """
        Information about an Object Storage log location for a DR Protection Group.
        """
        return pulumi.get(self, "log_locations")

    @property
    @pulumi.getter(name="peerDrProtectionGroupId")
    def peer_dr_protection_group_id(self) -> pulumi.Output[str]:
        """
        The OCID of peer (remote) DR Protection Group associated with this plan's DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "peer_dr_protection_group_id")

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> pulumi.Output[str]:
        """
        The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "peer_region")

    @property
    @pulumi.getter(name="planExecutionType")
    def plan_execution_type(self) -> pulumi.Output[str]:
        """
        The type of the plan execution.
        """
        return pulumi.get(self, "plan_execution_type")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Output[str]:
        """
        The OCID of the DR Plan.  Example: `ocid1.drplan.oc1.iad.&lt;unique_id&gt;` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the DR Plan Execution.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time at which DR Plan Execution was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> pulumi.Output[str]:
        """
        The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> pulumi.Output[str]:
        """
        The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time at which DR Plan Execution was last updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_updated")

