# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDkimResult',
    'AwaitableGetDkimResult',
    'get_dkim',
    'get_dkim_output',
]

@pulumi.output_type
class GetDkimResult:
    """
    A collection of values returned by getDkim.
    """
    def __init__(__self__, cname_record_value=None, compartment_id=None, defined_tags=None, description=None, dkim_id=None, dns_subdomain_name=None, email_domain_id=None, freeform_tags=None, id=None, lifecycle_details=None, name=None, state=None, system_tags=None, time_created=None, time_updated=None, txt_record_value=None):
        if cname_record_value and not isinstance(cname_record_value, str):
            raise TypeError("Expected argument 'cname_record_value' to be a str")
        pulumi.set(__self__, "cname_record_value", cname_record_value)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dkim_id and not isinstance(dkim_id, str):
            raise TypeError("Expected argument 'dkim_id' to be a str")
        pulumi.set(__self__, "dkim_id", dkim_id)
        if dns_subdomain_name and not isinstance(dns_subdomain_name, str):
            raise TypeError("Expected argument 'dns_subdomain_name' to be a str")
        pulumi.set(__self__, "dns_subdomain_name", dns_subdomain_name)
        if email_domain_id and not isinstance(email_domain_id, str):
            raise TypeError("Expected argument 'email_domain_id' to be a str")
        pulumi.set(__self__, "email_domain_id", email_domain_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if txt_record_value and not isinstance(txt_record_value, str):
            raise TypeError("Expected argument 'txt_record_value' to be a str")
        pulumi.set(__self__, "txt_record_value", txt_record_value)

    @property
    @pulumi.getter(name="cnameRecordValue")
    def cname_record_value(self) -> str:
        """
        The DNS CNAME record value to provision to the DKIM DNS subdomain, when using the CNAME method for DKIM setup (preferred).
        """
        return pulumi.get(self, "cname_record_value")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains this DKIM.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the DKIM. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dkimId")
    def dkim_id(self) -> str:
        return pulumi.get(self, "dkim_id")

    @property
    @pulumi.getter(name="dnsSubdomainName")
    def dns_subdomain_name(self) -> str:
        """
        The name of the DNS subdomain that must be provisioned to enable email recipients to verify DKIM signatures. It is usually created with a CNAME record set to the cnameRecordValue
        """
        return pulumi.get(self, "dns_subdomain_name")

    @property
    @pulumi.getter(name="emailDomainId")
    def email_domain_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the email domain that this DKIM belongs to.
        """
        return pulumi.get(self, "email_domain_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DKIM.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The DKIM selector. If the same domain is managed in more than one region, each region must use different selectors.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the DKIM.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the DKIM was created. Times are expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, "YYYY-MM-ddThh:mmZ".  Example: `2021-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time of the last change to the DKIM configuration, due to a state change or an update operation. Times are expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, "YYYY-MM-ddThh:mmZ".
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="txtRecordValue")
    def txt_record_value(self) -> str:
        """
        The DNS TXT record value to provision to the DKIM DNS subdomain in place of using a CNAME record. This is used in cases where a CNAME can not be used, such as when the cnameRecordValue would exceed the maximum length for a DNS entry. This can also be used by customers who have an existing procedure to directly provision TXT records for DKIM. Be aware that many DNS APIs will require you to break this string into segments of less than 255 characters.
        """
        return pulumi.get(self, "txt_record_value")


class AwaitableGetDkimResult(GetDkimResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDkimResult(
            cname_record_value=self.cname_record_value,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            dkim_id=self.dkim_id,
            dns_subdomain_name=self.dns_subdomain_name,
            email_domain_id=self.email_domain_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            name=self.name,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            txt_record_value=self.txt_record_value)


def get_dkim(dkim_id: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDkimResult:
    """
    This data source provides details about a specific Dkim resource in Oracle Cloud Infrastructure Email service.

    Retrieves the specified DKIM.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dkim = oci.Email.get_dkim(dkim_id=oci_email_dkim["test_dkim"]["id"])
    ```


    :param str dkim_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this DKIM.
    """
    __args__ = dict()
    __args__['dkimId'] = dkim_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Email/getDkim:getDkim', __args__, opts=opts, typ=GetDkimResult).value

    return AwaitableGetDkimResult(
        cname_record_value=pulumi.get(__ret__, 'cname_record_value'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        dkim_id=pulumi.get(__ret__, 'dkim_id'),
        dns_subdomain_name=pulumi.get(__ret__, 'dns_subdomain_name'),
        email_domain_id=pulumi.get(__ret__, 'email_domain_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        txt_record_value=pulumi.get(__ret__, 'txt_record_value'))


@_utilities.lift_output_func(get_dkim)
def get_dkim_output(dkim_id: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDkimResult]:
    """
    This data source provides details about a specific Dkim resource in Oracle Cloud Infrastructure Email service.

    Retrieves the specified DKIM.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dkim = oci.Email.get_dkim(dkim_id=oci_email_dkim["test_dkim"]["id"])
    ```


    :param str dkim_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this DKIM.
    """
    ...
