# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['PingProbeArgs', 'PingProbe']

@pulumi.input_type
class PingProbeArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 targets: pulumi.Input[Sequence[pulumi.Input[str]]],
                 port: Optional[pulumi.Input[int]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 vantage_point_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a PingProbe resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[str] protocol: The protocols for ping probes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] targets: A list of targets (hostnames or IP addresses) of the probe.
        :param pulumi.Input[int] port: The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        :param pulumi.Input[int] timeout_in_seconds: The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vantage_point_names: A list of names of vantage points from which to execute the probe.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        PingProbeArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            protocol=protocol,
            targets=targets,
            port=port,
            timeout_in_seconds=timeout_in_seconds,
            vantage_point_names=vantage_point_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             protocol: pulumi.Input[str],
             targets: pulumi.Input[Sequence[pulumi.Input[str]]],
             port: Optional[pulumi.Input[int]] = None,
             timeout_in_seconds: Optional[pulumi.Input[int]] = None,
             vantage_point_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'timeoutInSeconds' in kwargs:
            timeout_in_seconds = kwargs['timeoutInSeconds']
        if 'vantagePointNames' in kwargs:
            vantage_point_names = kwargs['vantagePointNames']

        _setter("compartment_id", compartment_id)
        _setter("protocol", protocol)
        _setter("targets", targets)
        if port is not None:
            _setter("port", port)
        if timeout_in_seconds is not None:
            _setter("timeout_in_seconds", timeout_in_seconds)
        if vantage_point_names is not None:
            _setter("vantage_point_names", vantage_point_names)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocols for ping probes.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of targets (hostnames or IP addresses) of the probe.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @property
    @pulumi.getter(name="vantagePointNames")
    def vantage_point_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of names of vantage points from which to execute the probe.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vantage_point_names")

    @vantage_point_names.setter
    def vantage_point_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vantage_point_names", value)


@pulumi.input_type
class _PingProbeState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 home_region: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 results_url: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 vantage_point_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering PingProbe resources.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[str] home_region: The region where updates must be made and where results must be fetched from.
        :param pulumi.Input[int] port: The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        :param pulumi.Input[str] protocol: The protocols for ping probes.
        :param pulumi.Input[str] results_url: A URL for fetching the probe results.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] targets: A list of targets (hostnames or IP addresses) of the probe.
        :param pulumi.Input[str] time_created: The RFC 3339-formatted creation date and time of the probe.
        :param pulumi.Input[int] timeout_in_seconds: The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vantage_point_names: A list of names of vantage points from which to execute the probe.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        _PingProbeState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            home_region=home_region,
            port=port,
            protocol=protocol,
            results_url=results_url,
            targets=targets,
            time_created=time_created,
            timeout_in_seconds=timeout_in_seconds,
            vantage_point_names=vantage_point_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             home_region: Optional[pulumi.Input[str]] = None,
             port: Optional[pulumi.Input[int]] = None,
             protocol: Optional[pulumi.Input[str]] = None,
             results_url: Optional[pulumi.Input[str]] = None,
             targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             timeout_in_seconds: Optional[pulumi.Input[int]] = None,
             vantage_point_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'homeRegion' in kwargs:
            home_region = kwargs['homeRegion']
        if 'resultsUrl' in kwargs:
            results_url = kwargs['resultsUrl']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeoutInSeconds' in kwargs:
            timeout_in_seconds = kwargs['timeoutInSeconds']
        if 'vantagePointNames' in kwargs:
            vantage_point_names = kwargs['vantagePointNames']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if home_region is not None:
            _setter("home_region", home_region)
        if port is not None:
            _setter("port", port)
        if protocol is not None:
            _setter("protocol", protocol)
        if results_url is not None:
            _setter("results_url", results_url)
        if targets is not None:
            _setter("targets", targets)
        if time_created is not None:
            _setter("time_created", time_created)
        if timeout_in_seconds is not None:
            _setter("timeout_in_seconds", timeout_in_seconds)
        if vantage_point_names is not None:
            _setter("vantage_point_names", vantage_point_names)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region where updates must be made and where results must be fetched from.
        """
        return pulumi.get(self, "home_region")

    @home_region.setter
    def home_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "home_region", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocols for ping probes.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="resultsUrl")
    def results_url(self) -> Optional[pulumi.Input[str]]:
        """
        A URL for fetching the probe results.
        """
        return pulumi.get(self, "results_url")

    @results_url.setter
    def results_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "results_url", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of targets (hostnames or IP addresses) of the probe.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The RFC 3339-formatted creation date and time of the probe.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @property
    @pulumi.getter(name="vantagePointNames")
    def vantage_point_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of names of vantage points from which to execute the probe.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vantage_point_names")

    @vantage_point_names.setter
    def vantage_point_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vantage_point_names", value)


class PingProbe(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 vantage_point_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource provides the Ping Probe resource in Oracle Cloud Infrastructure Health Checks service.

        Creates an on-demand ping probe. The location response header contains the URL for
        fetching probe results.

        *Note:* The on-demand probe configuration is not saved.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_ping_probe = oci.health_checks.PingProbe("testPingProbe",
            compartment_id=var["compartment_id"],
            protocol=var["ping_probe_protocol"],
            targets=var["ping_probe_targets"],
            port=var["ping_probe_port"],
            timeout_in_seconds=var["ping_probe_timeout_in_seconds"],
            vantage_point_names=var["ping_probe_vantage_point_names"])
        ```

        ## Import

        PingProbes can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:HealthChecks/pingProbe:PingProbe test_ping_probe "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[int] port: The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        :param pulumi.Input[str] protocol: The protocols for ping probes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] targets: A list of targets (hostnames or IP addresses) of the probe.
        :param pulumi.Input[int] timeout_in_seconds: The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vantage_point_names: A list of names of vantage points from which to execute the probe.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PingProbeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Ping Probe resource in Oracle Cloud Infrastructure Health Checks service.

        Creates an on-demand ping probe. The location response header contains the URL for
        fetching probe results.

        *Note:* The on-demand probe configuration is not saved.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_ping_probe = oci.health_checks.PingProbe("testPingProbe",
            compartment_id=var["compartment_id"],
            protocol=var["ping_probe_protocol"],
            targets=var["ping_probe_targets"],
            port=var["ping_probe_port"],
            timeout_in_seconds=var["ping_probe_timeout_in_seconds"],
            vantage_point_names=var["ping_probe_vantage_point_names"])
        ```

        ## Import

        PingProbes can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:HealthChecks/pingProbe:PingProbe test_ping_probe "id"
        ```

        :param str resource_name: The name of the resource.
        :param PingProbeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PingProbeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            PingProbeArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 vantage_point_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PingProbeArgs.__new__(PingProbeArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["port"] = port
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if targets is None and not opts.urn:
                raise TypeError("Missing required property 'targets'")
            __props__.__dict__["targets"] = targets
            __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
            __props__.__dict__["vantage_point_names"] = vantage_point_names
            __props__.__dict__["home_region"] = None
            __props__.__dict__["results_url"] = None
            __props__.__dict__["time_created"] = None
        super(PingProbe, __self__).__init__(
            'oci:HealthChecks/pingProbe:PingProbe',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            home_region: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            results_url: Optional[pulumi.Input[str]] = None,
            targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            timeout_in_seconds: Optional[pulumi.Input[int]] = None,
            vantage_point_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'PingProbe':
        """
        Get an existing PingProbe resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[str] home_region: The region where updates must be made and where results must be fetched from.
        :param pulumi.Input[int] port: The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        :param pulumi.Input[str] protocol: The protocols for ping probes.
        :param pulumi.Input[str] results_url: A URL for fetching the probe results.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] targets: A list of targets (hostnames or IP addresses) of the probe.
        :param pulumi.Input[str] time_created: The RFC 3339-formatted creation date and time of the probe.
        :param pulumi.Input[int] timeout_in_seconds: The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vantage_point_names: A list of names of vantage points from which to execute the probe.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PingProbeState.__new__(_PingProbeState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["home_region"] = home_region
        __props__.__dict__["port"] = port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["results_url"] = results_url
        __props__.__dict__["targets"] = targets
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
        __props__.__dict__["vantage_point_names"] = vantage_point_names
        return PingProbe(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> pulumi.Output[str]:
        """
        The region where updates must be made and where results must be fetched from.
        """
        return pulumi.get(self, "home_region")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        The protocols for ping probes.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="resultsUrl")
    def results_url(self) -> pulumi.Output[str]:
        """
        A URL for fetching the probe results.
        """
        return pulumi.get(self, "results_url")

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of targets (hostnames or IP addresses) of the probe.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The RFC 3339-formatted creation date and time of the probe.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> pulumi.Output[int]:
        """
        The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter(name="vantagePointNames")
    def vantage_point_names(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of names of vantage points from which to execute the probe.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vantage_point_names")

