# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetIamWorkRequestResult',
    'AwaitableGetIamWorkRequestResult',
    'get_iam_work_request',
    'get_iam_work_request_output',
]

@pulumi.output_type
class GetIamWorkRequestResult:
    """
    A collection of values returned by getIamWorkRequest.
    """
    def __init__(__self__, compartment_id=None, iam_work_request_id=None, id=None, operation_type=None, percent_complete=None, resources=None, status=None, time_accepted=None, time_finished=None, time_started=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if iam_work_request_id and not isinstance(iam_work_request_id, str):
            raise TypeError("Expected argument 'iam_work_request_id' to be a str")
        pulumi.set(__self__, "iam_work_request_id", iam_work_request_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if operation_type and not isinstance(operation_type, str):
            raise TypeError("Expected argument 'operation_type' to be a str")
        pulumi.set(__self__, "operation_type", operation_type)
        if percent_complete and not isinstance(percent_complete, float):
            raise TypeError("Expected argument 'percent_complete' to be a float")
        pulumi.set(__self__, "percent_complete", percent_complete)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if time_accepted and not isinstance(time_accepted, str):
            raise TypeError("Expected argument 'time_accepted' to be a str")
        pulumi.set(__self__, "time_accepted", time_accepted)
        if time_finished and not isinstance(time_finished, str):
            raise TypeError("Expected argument 'time_finished' to be a str")
        pulumi.set(__self__, "time_finished", time_finished)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing this IAM work request.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="iamWorkRequestId")
    def iam_work_request_id(self) -> str:
        return pulumi.get(self, "iam_work_request_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> str:
        """
        The asynchronous operation tracked by this IAM work request.
        """
        return pulumi.get(self, "operation_type")

    @property
    @pulumi.getter(name="percentComplete")
    def percent_complete(self) -> float:
        """
        How much progress the operation has made.
        """
        return pulumi.get(self, "percent_complete")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetIamWorkRequestResourceResult']:
        """
        The resources this work request affects.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the work request
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> str:
        """
        Date and time the work was accepted, in the format defined by RFC3339. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_accepted")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> str:
        """
        Date and time the work completed, in the format defined by RFC3339. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        Date and time the work started, in the format defined by RFC3339. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_started")


class AwaitableGetIamWorkRequestResult(GetIamWorkRequestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIamWorkRequestResult(
            compartment_id=self.compartment_id,
            iam_work_request_id=self.iam_work_request_id,
            id=self.id,
            operation_type=self.operation_type,
            percent_complete=self.percent_complete,
            resources=self.resources,
            status=self.status,
            time_accepted=self.time_accepted,
            time_finished=self.time_finished,
            time_started=self.time_started)


def get_iam_work_request(iam_work_request_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIamWorkRequestResult:
    """
    This data source provides details about a specific Iam Work Request resource in Oracle Cloud Infrastructure Identity service.

    Gets details on a specified IAM work request. For asynchronous operations in Identity and Access Management service, opc-work-request-id header values contains
    iam work request id that can be provided in this API to track the current status of the operation.

    - If workrequest exists, returns 202 ACCEPTED
    - If workrequest does not exist, returns 404 NOT FOUND

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_iam_work_request = oci.Identity.get_iam_work_request(iam_work_request_id=oci_identity_iam_work_request["test_iam_work_request"]["id"])
    ```


    :param str iam_work_request_id: The OCID of the IAM work request.
    """
    __args__ = dict()
    __args__['iamWorkRequestId'] = iam_work_request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getIamWorkRequest:getIamWorkRequest', __args__, opts=opts, typ=GetIamWorkRequestResult).value

    return AwaitableGetIamWorkRequestResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        iam_work_request_id=pulumi.get(__ret__, 'iam_work_request_id'),
        id=pulumi.get(__ret__, 'id'),
        operation_type=pulumi.get(__ret__, 'operation_type'),
        percent_complete=pulumi.get(__ret__, 'percent_complete'),
        resources=pulumi.get(__ret__, 'resources'),
        status=pulumi.get(__ret__, 'status'),
        time_accepted=pulumi.get(__ret__, 'time_accepted'),
        time_finished=pulumi.get(__ret__, 'time_finished'),
        time_started=pulumi.get(__ret__, 'time_started'))


@_utilities.lift_output_func(get_iam_work_request)
def get_iam_work_request_output(iam_work_request_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIamWorkRequestResult]:
    """
    This data source provides details about a specific Iam Work Request resource in Oracle Cloud Infrastructure Identity service.

    Gets details on a specified IAM work request. For asynchronous operations in Identity and Access Management service, opc-work-request-id header values contains
    iam work request id that can be provided in this API to track the current status of the operation.

    - If workrequest exists, returns 202 ACCEPTED
    - If workrequest does not exist, returns 404 NOT FOUND

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_iam_work_request = oci.Identity.get_iam_work_request(iam_work_request_id=oci_identity_iam_work_request["test_iam_work_request"]["id"])
    ```


    :param str iam_work_request_id: The OCID of the IAM work request.
    """
    ...
