# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VerifyArgs', 'Verify']

@pulumi.input_type
class VerifyArgs:
    def __init__(__self__, *,
                 crypto_endpoint: pulumi.Input[str],
                 key_id: pulumi.Input[str],
                 key_version_id: pulumi.Input[str],
                 message: pulumi.Input[str],
                 signature: pulumi.Input[str],
                 signing_algorithm: pulumi.Input[str],
                 message_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Verify resource.
        :param pulumi.Input[str] crypto_endpoint: The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,', 'GenerateDataEncryptionKey', 'Sign' and 'Verify' operations. see Vault Crypto endpoint.
        :param pulumi.Input[str] key_id: The OCID of the key used to sign the message.
        :param pulumi.Input[str] key_version_id: The OCID of the key version used to sign the message.
        :param pulumi.Input[str] message: The base64-encoded binary data object denoting the message or message digest to sign. You can have a message up to 4096 bytes in size. To sign a larger message, provide the message digest.
        :param pulumi.Input[str] signature: The base64-encoded binary data object denoting the cryptographic signature generated for the message.
        :param pulumi.Input[str] signing_algorithm: The algorithm to use to sign the message or message digest. For RSA keys, supported signature schemes include PKCS #1 and RSASSA-PSS, along with different hashing algorithms. For ECDSA keys, ECDSA is the supported signature scheme with different hashing algorithms. When you pass a message digest for signing, ensure that you specify the same hashing algorithm as used when creating the message digest. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] message_type: Denotes whether the value of the message parameter is a raw message or a message digest. The default value, `RAW`, indicates a message. To indicate a message digest, use `DIGEST`.
        """
        VerifyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            crypto_endpoint=crypto_endpoint,
            key_id=key_id,
            key_version_id=key_version_id,
            message=message,
            signature=signature,
            signing_algorithm=signing_algorithm,
            message_type=message_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             crypto_endpoint: pulumi.Input[str],
             key_id: pulumi.Input[str],
             key_version_id: pulumi.Input[str],
             message: pulumi.Input[str],
             signature: pulumi.Input[str],
             signing_algorithm: pulumi.Input[str],
             message_type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cryptoEndpoint' in kwargs:
            crypto_endpoint = kwargs['cryptoEndpoint']
        if 'keyId' in kwargs:
            key_id = kwargs['keyId']
        if 'keyVersionId' in kwargs:
            key_version_id = kwargs['keyVersionId']
        if 'signingAlgorithm' in kwargs:
            signing_algorithm = kwargs['signingAlgorithm']
        if 'messageType' in kwargs:
            message_type = kwargs['messageType']

        _setter("crypto_endpoint", crypto_endpoint)
        _setter("key_id", key_id)
        _setter("key_version_id", key_version_id)
        _setter("message", message)
        _setter("signature", signature)
        _setter("signing_algorithm", signing_algorithm)
        if message_type is not None:
            _setter("message_type", message_type)

    @property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> pulumi.Input[str]:
        """
        The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,', 'GenerateDataEncryptionKey', 'Sign' and 'Verify' operations. see Vault Crypto endpoint.
        """
        return pulumi.get(self, "crypto_endpoint")

    @crypto_endpoint.setter
    def crypto_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "crypto_endpoint", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[str]:
        """
        The OCID of the key used to sign the message.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="keyVersionId")
    def key_version_id(self) -> pulumi.Input[str]:
        """
        The OCID of the key version used to sign the message.
        """
        return pulumi.get(self, "key_version_id")

    @key_version_id.setter
    def key_version_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_version_id", value)

    @property
    @pulumi.getter
    def message(self) -> pulumi.Input[str]:
        """
        The base64-encoded binary data object denoting the message or message digest to sign. You can have a message up to 4096 bytes in size. To sign a larger message, provide the message digest.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: pulumi.Input[str]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def signature(self) -> pulumi.Input[str]:
        """
        The base64-encoded binary data object denoting the cryptographic signature generated for the message.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: pulumi.Input[str]):
        pulumi.set(self, "signature", value)

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> pulumi.Input[str]:
        """
        The algorithm to use to sign the message or message digest. For RSA keys, supported signature schemes include PKCS #1 and RSASSA-PSS, along with different hashing algorithms. For ECDSA keys, ECDSA is the supported signature scheme with different hashing algorithms. When you pass a message digest for signing, ensure that you specify the same hashing algorithm as used when creating the message digest. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "signing_algorithm")

    @signing_algorithm.setter
    def signing_algorithm(self, value: pulumi.Input[str]):
        pulumi.set(self, "signing_algorithm", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        Denotes whether the value of the message parameter is a raw message or a message digest. The default value, `RAW`, indicates a message. To indicate a message digest, use `DIGEST`.
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)


@pulumi.input_type
class _VerifyState:
    def __init__(__self__, *,
                 crypto_endpoint: Optional[pulumi.Input[str]] = None,
                 is_signature_valid: Optional[pulumi.Input[bool]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_version_id: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None,
                 signing_algorithm: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Verify resources.
        :param pulumi.Input[str] crypto_endpoint: The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,', 'GenerateDataEncryptionKey', 'Sign' and 'Verify' operations. see Vault Crypto endpoint.
        :param pulumi.Input[bool] is_signature_valid: A Boolean value that indicates whether the signature was verified.
        :param pulumi.Input[str] key_id: The OCID of the key used to sign the message.
        :param pulumi.Input[str] key_version_id: The OCID of the key version used to sign the message.
        :param pulumi.Input[str] message: The base64-encoded binary data object denoting the message or message digest to sign. You can have a message up to 4096 bytes in size. To sign a larger message, provide the message digest.
        :param pulumi.Input[str] message_type: Denotes whether the value of the message parameter is a raw message or a message digest. The default value, `RAW`, indicates a message. To indicate a message digest, use `DIGEST`.
        :param pulumi.Input[str] signature: The base64-encoded binary data object denoting the cryptographic signature generated for the message.
        :param pulumi.Input[str] signing_algorithm: The algorithm to use to sign the message or message digest. For RSA keys, supported signature schemes include PKCS #1 and RSASSA-PSS, along with different hashing algorithms. For ECDSA keys, ECDSA is the supported signature scheme with different hashing algorithms. When you pass a message digest for signing, ensure that you specify the same hashing algorithm as used when creating the message digest. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        _VerifyState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            crypto_endpoint=crypto_endpoint,
            is_signature_valid=is_signature_valid,
            key_id=key_id,
            key_version_id=key_version_id,
            message=message,
            message_type=message_type,
            signature=signature,
            signing_algorithm=signing_algorithm,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             crypto_endpoint: Optional[pulumi.Input[str]] = None,
             is_signature_valid: Optional[pulumi.Input[bool]] = None,
             key_id: Optional[pulumi.Input[str]] = None,
             key_version_id: Optional[pulumi.Input[str]] = None,
             message: Optional[pulumi.Input[str]] = None,
             message_type: Optional[pulumi.Input[str]] = None,
             signature: Optional[pulumi.Input[str]] = None,
             signing_algorithm: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cryptoEndpoint' in kwargs:
            crypto_endpoint = kwargs['cryptoEndpoint']
        if 'isSignatureValid' in kwargs:
            is_signature_valid = kwargs['isSignatureValid']
        if 'keyId' in kwargs:
            key_id = kwargs['keyId']
        if 'keyVersionId' in kwargs:
            key_version_id = kwargs['keyVersionId']
        if 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if 'signingAlgorithm' in kwargs:
            signing_algorithm = kwargs['signingAlgorithm']

        if crypto_endpoint is not None:
            _setter("crypto_endpoint", crypto_endpoint)
        if is_signature_valid is not None:
            _setter("is_signature_valid", is_signature_valid)
        if key_id is not None:
            _setter("key_id", key_id)
        if key_version_id is not None:
            _setter("key_version_id", key_version_id)
        if message is not None:
            _setter("message", message)
        if message_type is not None:
            _setter("message_type", message_type)
        if signature is not None:
            _setter("signature", signature)
        if signing_algorithm is not None:
            _setter("signing_algorithm", signing_algorithm)

    @property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,', 'GenerateDataEncryptionKey', 'Sign' and 'Verify' operations. see Vault Crypto endpoint.
        """
        return pulumi.get(self, "crypto_endpoint")

    @crypto_endpoint.setter
    def crypto_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crypto_endpoint", value)

    @property
    @pulumi.getter(name="isSignatureValid")
    def is_signature_valid(self) -> Optional[pulumi.Input[bool]]:
        """
        A Boolean value that indicates whether the signature was verified.
        """
        return pulumi.get(self, "is_signature_valid")

    @is_signature_valid.setter
    def is_signature_valid(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_signature_valid", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key used to sign the message.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="keyVersionId")
    def key_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key version used to sign the message.
        """
        return pulumi.get(self, "key_version_id")

    @key_version_id.setter
    def key_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_version_id", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        The base64-encoded binary data object denoting the message or message digest to sign. You can have a message up to 4096 bytes in size. To sign a larger message, provide the message digest.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        Denotes whether the value of the message parameter is a raw message or a message digest. The default value, `RAW`, indicates a message. To indicate a message digest, use `DIGEST`.
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input[str]]:
        """
        The base64-encoded binary data object denoting the cryptographic signature generated for the message.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature", value)

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The algorithm to use to sign the message or message digest. For RSA keys, supported signature schemes include PKCS #1 and RSASSA-PSS, along with different hashing algorithms. For ECDSA keys, ECDSA is the supported signature scheme with different hashing algorithms. When you pass a message digest for signing, ensure that you specify the same hashing algorithm as used when creating the message digest. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "signing_algorithm")

    @signing_algorithm.setter
    def signing_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signing_algorithm", value)


class Verify(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crypto_endpoint: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_version_id: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None,
                 signing_algorithm: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Verify resource in Oracle Cloud Infrastructure Kms service.

        Verifies a digital signature that was generated by the [Sign](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/SignedData/Sign) operation
        by using the public key of the same asymmetric key that was used to sign the data. If you want to validate the
        digital signature outside of the service, you can do so by using the public key of the asymmetric key.
        This operation is not supported for keys having protection mode `EXTERNAL`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_verify = oci.kms.Verify("testVerify",
            crypto_endpoint=var["verify_message_crypto_endpoint"],
            key_id=oci_kms_key["test_key"]["id"],
            key_version_id=oci_kms_key_version["test_key_version"]["id"],
            message=var["verify_message"],
            signature=var["verify_signature"],
            signing_algorithm=var["verify_signing_algorithm"],
            message_type=var["verify_message_type"])
        ```

        ## Import

        Verify can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Kms/verify:Verify test_verify "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] crypto_endpoint: The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,', 'GenerateDataEncryptionKey', 'Sign' and 'Verify' operations. see Vault Crypto endpoint.
        :param pulumi.Input[str] key_id: The OCID of the key used to sign the message.
        :param pulumi.Input[str] key_version_id: The OCID of the key version used to sign the message.
        :param pulumi.Input[str] message: The base64-encoded binary data object denoting the message or message digest to sign. You can have a message up to 4096 bytes in size. To sign a larger message, provide the message digest.
        :param pulumi.Input[str] message_type: Denotes whether the value of the message parameter is a raw message or a message digest. The default value, `RAW`, indicates a message. To indicate a message digest, use `DIGEST`.
        :param pulumi.Input[str] signature: The base64-encoded binary data object denoting the cryptographic signature generated for the message.
        :param pulumi.Input[str] signing_algorithm: The algorithm to use to sign the message or message digest. For RSA keys, supported signature schemes include PKCS #1 and RSASSA-PSS, along with different hashing algorithms. For ECDSA keys, ECDSA is the supported signature scheme with different hashing algorithms. When you pass a message digest for signing, ensure that you specify the same hashing algorithm as used when creating the message digest. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VerifyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Verify resource in Oracle Cloud Infrastructure Kms service.

        Verifies a digital signature that was generated by the [Sign](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/SignedData/Sign) operation
        by using the public key of the same asymmetric key that was used to sign the data. If you want to validate the
        digital signature outside of the service, you can do so by using the public key of the asymmetric key.
        This operation is not supported for keys having protection mode `EXTERNAL`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_verify = oci.kms.Verify("testVerify",
            crypto_endpoint=var["verify_message_crypto_endpoint"],
            key_id=oci_kms_key["test_key"]["id"],
            key_version_id=oci_kms_key_version["test_key_version"]["id"],
            message=var["verify_message"],
            signature=var["verify_signature"],
            signing_algorithm=var["verify_signing_algorithm"],
            message_type=var["verify_message_type"])
        ```

        ## Import

        Verify can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Kms/verify:Verify test_verify "id"
        ```

        :param str resource_name: The name of the resource.
        :param VerifyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VerifyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            VerifyArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crypto_endpoint: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_version_id: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None,
                 signing_algorithm: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VerifyArgs.__new__(VerifyArgs)

            if crypto_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'crypto_endpoint'")
            __props__.__dict__["crypto_endpoint"] = crypto_endpoint
            if key_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_id'")
            __props__.__dict__["key_id"] = key_id
            if key_version_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_version_id'")
            __props__.__dict__["key_version_id"] = key_version_id
            if message is None and not opts.urn:
                raise TypeError("Missing required property 'message'")
            __props__.__dict__["message"] = message
            __props__.__dict__["message_type"] = message_type
            if signature is None and not opts.urn:
                raise TypeError("Missing required property 'signature'")
            __props__.__dict__["signature"] = signature
            if signing_algorithm is None and not opts.urn:
                raise TypeError("Missing required property 'signing_algorithm'")
            __props__.__dict__["signing_algorithm"] = signing_algorithm
            __props__.__dict__["is_signature_valid"] = None
        super(Verify, __self__).__init__(
            'oci:Kms/verify:Verify',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            crypto_endpoint: Optional[pulumi.Input[str]] = None,
            is_signature_valid: Optional[pulumi.Input[bool]] = None,
            key_id: Optional[pulumi.Input[str]] = None,
            key_version_id: Optional[pulumi.Input[str]] = None,
            message: Optional[pulumi.Input[str]] = None,
            message_type: Optional[pulumi.Input[str]] = None,
            signature: Optional[pulumi.Input[str]] = None,
            signing_algorithm: Optional[pulumi.Input[str]] = None) -> 'Verify':
        """
        Get an existing Verify resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] crypto_endpoint: The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,', 'GenerateDataEncryptionKey', 'Sign' and 'Verify' operations. see Vault Crypto endpoint.
        :param pulumi.Input[bool] is_signature_valid: A Boolean value that indicates whether the signature was verified.
        :param pulumi.Input[str] key_id: The OCID of the key used to sign the message.
        :param pulumi.Input[str] key_version_id: The OCID of the key version used to sign the message.
        :param pulumi.Input[str] message: The base64-encoded binary data object denoting the message or message digest to sign. You can have a message up to 4096 bytes in size. To sign a larger message, provide the message digest.
        :param pulumi.Input[str] message_type: Denotes whether the value of the message parameter is a raw message or a message digest. The default value, `RAW`, indicates a message. To indicate a message digest, use `DIGEST`.
        :param pulumi.Input[str] signature: The base64-encoded binary data object denoting the cryptographic signature generated for the message.
        :param pulumi.Input[str] signing_algorithm: The algorithm to use to sign the message or message digest. For RSA keys, supported signature schemes include PKCS #1 and RSASSA-PSS, along with different hashing algorithms. For ECDSA keys, ECDSA is the supported signature scheme with different hashing algorithms. When you pass a message digest for signing, ensure that you specify the same hashing algorithm as used when creating the message digest. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VerifyState.__new__(_VerifyState)

        __props__.__dict__["crypto_endpoint"] = crypto_endpoint
        __props__.__dict__["is_signature_valid"] = is_signature_valid
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["key_version_id"] = key_version_id
        __props__.__dict__["message"] = message
        __props__.__dict__["message_type"] = message_type
        __props__.__dict__["signature"] = signature
        __props__.__dict__["signing_algorithm"] = signing_algorithm
        return Verify(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> pulumi.Output[str]:
        """
        The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,', 'GenerateDataEncryptionKey', 'Sign' and 'Verify' operations. see Vault Crypto endpoint.
        """
        return pulumi.get(self, "crypto_endpoint")

    @property
    @pulumi.getter(name="isSignatureValid")
    def is_signature_valid(self) -> pulumi.Output[bool]:
        """
        A Boolean value that indicates whether the signature was verified.
        """
        return pulumi.get(self, "is_signature_valid")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[str]:
        """
        The OCID of the key used to sign the message.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyVersionId")
    def key_version_id(self) -> pulumi.Output[str]:
        """
        The OCID of the key version used to sign the message.
        """
        return pulumi.get(self, "key_version_id")

    @property
    @pulumi.getter
    def message(self) -> pulumi.Output[str]:
        """
        The base64-encoded binary data object denoting the message or message digest to sign. You can have a message up to 4096 bytes in size. To sign a larger message, provide the message digest.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> pulumi.Output[str]:
        """
        Denotes whether the value of the message parameter is a raw message or a message digest. The default value, `RAW`, indicates a message. To indicate a message digest, use `DIGEST`.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def signature(self) -> pulumi.Output[str]:
        """
        The base64-encoded binary data object denoting the cryptographic signature generated for the message.
        """
        return pulumi.get(self, "signature")

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> pulumi.Output[str]:
        """
        The algorithm to use to sign the message or message digest. For RSA keys, supported signature schemes include PKCS #1 and RSASSA-PSS, along with different hashing algorithms. For ECDSA keys, ECDSA is the supported signature scheme with different hashing algorithms. When you pass a message digest for signing, ensure that you specify the same hashing algorithm as used when creating the message digest. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "signing_algorithm")

