# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkFirewallPolicySecurityRuleResult',
    'AwaitableGetNetworkFirewallPolicySecurityRuleResult',
    'get_network_firewall_policy_security_rule',
    'get_network_firewall_policy_security_rule_output',
]

@pulumi.output_type
class GetNetworkFirewallPolicySecurityRuleResult:
    """
    A collection of values returned by getNetworkFirewallPolicySecurityRule.
    """
    def __init__(__self__, action=None, conditions=None, id=None, inspection=None, name=None, network_firewall_policy_id=None, parent_resource_id=None, positions=None, priority_order=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if conditions and not isinstance(conditions, list):
            raise TypeError("Expected argument 'conditions' to be a list")
        pulumi.set(__self__, "conditions", conditions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inspection and not isinstance(inspection, str):
            raise TypeError("Expected argument 'inspection' to be a str")
        pulumi.set(__self__, "inspection", inspection)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_firewall_policy_id and not isinstance(network_firewall_policy_id, str):
            raise TypeError("Expected argument 'network_firewall_policy_id' to be a str")
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if parent_resource_id and not isinstance(parent_resource_id, str):
            raise TypeError("Expected argument 'parent_resource_id' to be a str")
        pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if positions and not isinstance(positions, list):
            raise TypeError("Expected argument 'positions' to be a list")
        pulumi.set(__self__, "positions", positions)
        if priority_order and not isinstance(priority_order, str):
            raise TypeError("Expected argument 'priority_order' to be a str")
        pulumi.set(__self__, "priority_order", priority_order)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Types of Action on the Traffic flow.
        * ALLOW - Allows the traffic.
        * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
        * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
        * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetNetworkFirewallPolicySecurityRuleConditionResult']:
        """
        Criteria to evaluate against network traffic. A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def inspection(self) -> str:
        """
        Type of inspection to affect the Traffic flow. This is only applicable if action is INSPECT.
        * INTRUSION_DETECTION - Intrusion Detection.
        * INTRUSION_PREVENTION - Intrusion Detection and Prevention. Traffic classified as potentially malicious will be rejected as described in `type`.
        """
        return pulumi.get(self, "inspection")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for the Security rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> str:
        """
        OCID of the Network Firewall Policy this security rule belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter
    def positions(self) -> Sequence['outputs.GetNetworkFirewallPolicySecurityRulePositionResult']:
        """
        An object which defines the position of the rule.
        """
        return pulumi.get(self, "positions")

    @property
    @pulumi.getter(name="priorityOrder")
    def priority_order(self) -> str:
        return pulumi.get(self, "priority_order")


class AwaitableGetNetworkFirewallPolicySecurityRuleResult(GetNetworkFirewallPolicySecurityRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkFirewallPolicySecurityRuleResult(
            action=self.action,
            conditions=self.conditions,
            id=self.id,
            inspection=self.inspection,
            name=self.name,
            network_firewall_policy_id=self.network_firewall_policy_id,
            parent_resource_id=self.parent_resource_id,
            positions=self.positions,
            priority_order=self.priority_order)


def get_network_firewall_policy_security_rule(name: Optional[str] = None,
                                              network_firewall_policy_id: Optional[str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkFirewallPolicySecurityRuleResult:
    """
    This data source provides details about a specific Network Firewall Policy Security Rule resource in Oracle Cloud Infrastructure Network Firewall service.

    Get Security Rule by the given name in the context of network firewall policy.


    :param str name: Name for the Security rule, must be unique within the policy.
    :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['networkFirewallPolicyId'] = network_firewall_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:NetworkFirewall/getNetworkFirewallPolicySecurityRule:getNetworkFirewallPolicySecurityRule', __args__, opts=opts, typ=GetNetworkFirewallPolicySecurityRuleResult).value

    return AwaitableGetNetworkFirewallPolicySecurityRuleResult(
        action=pulumi.get(__ret__, 'action'),
        conditions=pulumi.get(__ret__, 'conditions'),
        id=pulumi.get(__ret__, 'id'),
        inspection=pulumi.get(__ret__, 'inspection'),
        name=pulumi.get(__ret__, 'name'),
        network_firewall_policy_id=pulumi.get(__ret__, 'network_firewall_policy_id'),
        parent_resource_id=pulumi.get(__ret__, 'parent_resource_id'),
        positions=pulumi.get(__ret__, 'positions'),
        priority_order=pulumi.get(__ret__, 'priority_order'))


@_utilities.lift_output_func(get_network_firewall_policy_security_rule)
def get_network_firewall_policy_security_rule_output(name: Optional[pulumi.Input[str]] = None,
                                                     network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkFirewallPolicySecurityRuleResult]:
    """
    This data source provides details about a specific Network Firewall Policy Security Rule resource in Oracle Cloud Infrastructure Network Firewall service.

    Get Security Rule by the given name in the context of network firewall policy.


    :param str name: Name for the Security rule, must be unique within the policy.
    :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
    """
    ...
