# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'NetworkFirewallPolicyDecryptionRuleCondition',
    'NetworkFirewallPolicyDecryptionRulePosition',
    'NetworkFirewallPolicySecurityRuleCondition',
    'NetworkFirewallPolicySecurityRulePosition',
    'NetworkFirewallPolicyServicePortRange',
    'NetworkFirewallPolicyUrlListUrl',
    'GetNetworkFirewallPoliciesFilterResult',
    'GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionResult',
    'GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemResult',
    'GetNetworkFirewallPolicyAddressListsAddressListSummaryCollectionResult',
    'GetNetworkFirewallPolicyAddressListsAddressListSummaryCollectionItemResult',
    'GetNetworkFirewallPolicyAddressListsFilterResult',
    'GetNetworkFirewallPolicyApplicationGroupsApplicationGroupSummaryCollectionResult',
    'GetNetworkFirewallPolicyApplicationGroupsApplicationGroupSummaryCollectionItemResult',
    'GetNetworkFirewallPolicyApplicationGroupsFilterResult',
    'GetNetworkFirewallPolicyApplicationsApplicationSummaryCollectionResult',
    'GetNetworkFirewallPolicyApplicationsApplicationSummaryCollectionItemResult',
    'GetNetworkFirewallPolicyApplicationsFilterResult',
    'GetNetworkFirewallPolicyDecryptionProfilesDecryptionProfileSummaryCollectionResult',
    'GetNetworkFirewallPolicyDecryptionProfilesDecryptionProfileSummaryCollectionItemResult',
    'GetNetworkFirewallPolicyDecryptionProfilesFilterResult',
    'GetNetworkFirewallPolicyDecryptionRuleConditionResult',
    'GetNetworkFirewallPolicyDecryptionRulePositionResult',
    'GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionResult',
    'GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemResult',
    'GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemConditionResult',
    'GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemPositionResult',
    'GetNetworkFirewallPolicyDecryptionRulesFilterResult',
    'GetNetworkFirewallPolicyMappedSecretsMappedSecretSummaryCollectionResult',
    'GetNetworkFirewallPolicyMappedSecretsMappedSecretSummaryCollectionItemResult',
    'GetNetworkFirewallPolicySecurityRuleConditionResult',
    'GetNetworkFirewallPolicySecurityRulePositionResult',
    'GetNetworkFirewallPolicySecurityRulesFilterResult',
    'GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionResult',
    'GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemResult',
    'GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemConditionResult',
    'GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemPositionResult',
    'GetNetworkFirewallPolicyServiceListsFilterResult',
    'GetNetworkFirewallPolicyServiceListsServiceListSummaryCollectionResult',
    'GetNetworkFirewallPolicyServiceListsServiceListSummaryCollectionItemResult',
    'GetNetworkFirewallPolicyServicePortRangeResult',
    'GetNetworkFirewallPolicyServicesFilterResult',
    'GetNetworkFirewallPolicyServicesServiceSummaryCollectionResult',
    'GetNetworkFirewallPolicyServicesServiceSummaryCollectionItemResult',
    'GetNetworkFirewallPolicyServicesServiceSummaryCollectionItemPortRangeResult',
    'GetNetworkFirewallPolicyUrlListUrlResult',
    'GetNetworkFirewallPolicyUrlListsFilterResult',
    'GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionResult',
    'GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionItemResult',
    'GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionItemUrlResult',
    'GetNetworkFirewallsFilterResult',
    'GetNetworkFirewallsNetworkFirewallCollectionResult',
    'GetNetworkFirewallsNetworkFirewallCollectionItemResult',
]

@pulumi.output_type
class NetworkFirewallPolicyDecryptionRuleCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationAddresses":
            suggest = "destination_addresses"
        elif key == "sourceAddresses":
            suggest = "source_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFirewallPolicyDecryptionRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFirewallPolicyDecryptionRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFirewallPolicyDecryptionRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_addresses: Optional[Sequence[str]] = None,
                 source_addresses: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] destination_addresses: (Updatable) An array of address list names to be evaluated against the traffic destination address.
        :param Sequence[str] source_addresses: (Updatable) An array of address list names to be evaluated against the traffic source address.
        """
        NetworkFirewallPolicyDecryptionRuleCondition._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            destination_addresses=destination_addresses,
            source_addresses=source_addresses,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             destination_addresses: Optional[Sequence[str]] = None,
             source_addresses: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'destinationAddresses' in kwargs:
            destination_addresses = kwargs['destinationAddresses']
        if 'sourceAddresses' in kwargs:
            source_addresses = kwargs['sourceAddresses']

        if destination_addresses is not None:
            _setter("destination_addresses", destination_addresses)
        if source_addresses is not None:
            _setter("source_addresses", source_addresses)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[Sequence[str]]:
        """
        (Updatable) An array of address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        (Updatable) An array of address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "source_addresses")


@pulumi.output_type
class NetworkFirewallPolicyDecryptionRulePosition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "afterRule":
            suggest = "after_rule"
        elif key == "beforeRule":
            suggest = "before_rule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFirewallPolicyDecryptionRulePosition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFirewallPolicyDecryptionRulePosition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFirewallPolicyDecryptionRulePosition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 after_rule: Optional[str] = None,
                 before_rule: Optional[str] = None):
        """
        :param str after_rule: (Updatable) Identifier for rule after which this rule lies.
        :param str before_rule: (Updatable) Identifier for rule before which this rule lies.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        NetworkFirewallPolicyDecryptionRulePosition._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            after_rule=after_rule,
            before_rule=before_rule,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             after_rule: Optional[str] = None,
             before_rule: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'afterRule' in kwargs:
            after_rule = kwargs['afterRule']
        if 'beforeRule' in kwargs:
            before_rule = kwargs['beforeRule']

        if after_rule is not None:
            _setter("after_rule", after_rule)
        if before_rule is not None:
            _setter("before_rule", before_rule)

    @property
    @pulumi.getter(name="afterRule")
    def after_rule(self) -> Optional[str]:
        """
        (Updatable) Identifier for rule after which this rule lies.
        """
        return pulumi.get(self, "after_rule")

    @property
    @pulumi.getter(name="beforeRule")
    def before_rule(self) -> Optional[str]:
        """
        (Updatable) Identifier for rule before which this rule lies.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "before_rule")


@pulumi.output_type
class NetworkFirewallPolicySecurityRuleCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationAddresses":
            suggest = "destination_addresses"
        elif key == "sourceAddresses":
            suggest = "source_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFirewallPolicySecurityRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFirewallPolicySecurityRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFirewallPolicySecurityRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applications: Sequence[str],
                 destination_addresses: Sequence[str],
                 services: Sequence[str],
                 source_addresses: Sequence[str],
                 urls: Sequence[str]):
        """
        :param Sequence[str] applications: (Updatable) An array of application group names to be evaluated against the traffic protocol and protocol-specific parameters.
        :param Sequence[str] destination_addresses: (Updatable) An array of address list names to be evaluated against the traffic destination address.
        :param Sequence[str] services: (Updatable) An array of service list names to be evaluated against the traffic protocol and protocol-specific parameters.
        :param Sequence[str] source_addresses: (Updatable) An array of address list names to be evaluated against the traffic source address.
        :param Sequence[str] urls: (Updatable) An array of URL list names to be evaluated against the HTTP(S) request target.
        """
        NetworkFirewallPolicySecurityRuleCondition._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            applications=applications,
            destination_addresses=destination_addresses,
            services=services,
            source_addresses=source_addresses,
            urls=urls,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             applications: Sequence[str],
             destination_addresses: Sequence[str],
             services: Sequence[str],
             source_addresses: Sequence[str],
             urls: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'destinationAddresses' in kwargs:
            destination_addresses = kwargs['destinationAddresses']
        if 'sourceAddresses' in kwargs:
            source_addresses = kwargs['sourceAddresses']

        _setter("applications", applications)
        _setter("destination_addresses", destination_addresses)
        _setter("services", services)
        _setter("source_addresses", source_addresses)
        _setter("urls", urls)

    @property
    @pulumi.getter
    def applications(self) -> Sequence[str]:
        """
        (Updatable) An array of application group names to be evaluated against the traffic protocol and protocol-specific parameters.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Sequence[str]:
        """
        (Updatable) An array of address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter
    def services(self) -> Sequence[str]:
        """
        (Updatable) An array of service list names to be evaluated against the traffic protocol and protocol-specific parameters.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Sequence[str]:
        """
        (Updatable) An array of address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter
    def urls(self) -> Sequence[str]:
        """
        (Updatable) An array of URL list names to be evaluated against the HTTP(S) request target.
        """
        return pulumi.get(self, "urls")


@pulumi.output_type
class NetworkFirewallPolicySecurityRulePosition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "afterRule":
            suggest = "after_rule"
        elif key == "beforeRule":
            suggest = "before_rule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFirewallPolicySecurityRulePosition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFirewallPolicySecurityRulePosition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFirewallPolicySecurityRulePosition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 after_rule: Optional[str] = None,
                 before_rule: Optional[str] = None):
        """
        :param str after_rule: (Updatable) Identifier for rule after which this rule lies.
        :param str before_rule: (Updatable) Identifier for rule before which this rule lies.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        NetworkFirewallPolicySecurityRulePosition._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            after_rule=after_rule,
            before_rule=before_rule,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             after_rule: Optional[str] = None,
             before_rule: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'afterRule' in kwargs:
            after_rule = kwargs['afterRule']
        if 'beforeRule' in kwargs:
            before_rule = kwargs['beforeRule']

        if after_rule is not None:
            _setter("after_rule", after_rule)
        if before_rule is not None:
            _setter("before_rule", before_rule)

    @property
    @pulumi.getter(name="afterRule")
    def after_rule(self) -> Optional[str]:
        """
        (Updatable) Identifier for rule after which this rule lies.
        """
        return pulumi.get(self, "after_rule")

    @property
    @pulumi.getter(name="beforeRule")
    def before_rule(self) -> Optional[str]:
        """
        (Updatable) Identifier for rule before which this rule lies.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "before_rule")


@pulumi.output_type
class NetworkFirewallPolicyServicePortRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minimumPort":
            suggest = "minimum_port"
        elif key == "maximumPort":
            suggest = "maximum_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFirewallPolicyServicePortRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFirewallPolicyServicePortRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFirewallPolicyServicePortRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 minimum_port: int,
                 maximum_port: Optional[int] = None):
        """
        :param int minimum_port: (Updatable) The minimum port in the range (inclusive), or the sole port of a single-port range.
        :param int maximum_port: (Updatable) The maximum port in the range (inclusive), which may be absent for a single-port range.
        """
        NetworkFirewallPolicyServicePortRange._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            minimum_port=minimum_port,
            maximum_port=maximum_port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             minimum_port: int,
             maximum_port: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'minimumPort' in kwargs:
            minimum_port = kwargs['minimumPort']
        if 'maximumPort' in kwargs:
            maximum_port = kwargs['maximumPort']

        _setter("minimum_port", minimum_port)
        if maximum_port is not None:
            _setter("maximum_port", maximum_port)

    @property
    @pulumi.getter(name="minimumPort")
    def minimum_port(self) -> int:
        """
        (Updatable) The minimum port in the range (inclusive), or the sole port of a single-port range.
        """
        return pulumi.get(self, "minimum_port")

    @property
    @pulumi.getter(name="maximumPort")
    def maximum_port(self) -> Optional[int]:
        """
        (Updatable) The maximum port in the range (inclusive), which may be absent for a single-port range.
        """
        return pulumi.get(self, "maximum_port")


@pulumi.output_type
class NetworkFirewallPolicyUrlListUrl(dict):
    def __init__(__self__, *,
                 pattern: str,
                 type: str):
        """
        :param str pattern: (Updatable) A string consisting of a concatenation of optional host component and optional path component. The host component may start with `*.` to match the case-insensitive domain and all its subdomains. The path component must start with a `/`, and may end with `*` to match all paths of which it is a case-sensitive prefix. A missing host component matches all request domains, and a missing path component matches all request paths. An empty value matches all requests.
        :param str type: (Updatable) The type of pattern.
               * SIMPLE - The only accepted value is `SIMPLE`. A simple pattern with optional subdomain and/or path suffix wildcards.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        NetworkFirewallPolicyUrlListUrl._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            pattern=pattern,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             pattern: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("pattern", pattern)
        _setter("type", type)

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        (Updatable) A string consisting of a concatenation of optional host component and optional path component. The host component may start with `*.` to match the case-insensitive domain and all its subdomains. The path component must start with a `/`, and may end with `*` to match all paths of which it is a case-sensitive prefix. A missing host component matches all request domains, and a missing path component matches all request paths. An empty value matches all requests.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (Updatable) The type of pattern.
        * SIMPLE - The only accepted value is `SIMPLE`. A simple pattern with optional subdomain and/or path suffix wildcards.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkFirewallPoliciesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetNetworkFirewallPoliciesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemResult']):
        GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 attached_network_firewall_count: int,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_details: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param int attached_network_firewall_count: Count of number of Network Firewall attached to the Policy.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: Unique Network Firewall Policy identifier
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str state: A filter to return only resources with a lifecycleState matching the given value.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time instant at which the Network Firewall Policy was created in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param str time_updated: The time instant at which the Network Firewall Policy was updated in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            attached_network_firewall_count=attached_network_firewall_count,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            lifecycle_details=lifecycle_details,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             attached_network_firewall_count: int,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             lifecycle_details: str,
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'attachedNetworkFirewallCount' in kwargs:
            attached_network_firewall_count = kwargs['attachedNetworkFirewallCount']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("attached_network_firewall_count", attached_network_firewall_count)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("lifecycle_details", lifecycle_details)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="attachedNetworkFirewallCount")
    def attached_network_firewall_count(self) -> int:
        """
        Count of number of Network Firewall attached to the Policy.
        """
        return pulumi.get(self, "attached_network_firewall_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources with a lifecycleState matching the given value.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time instant at which the Network Firewall Policy was created in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time instant at which the Network Firewall Policy was updated in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetNetworkFirewallPolicyAddressListsAddressListSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetNetworkFirewallPolicyAddressListsAddressListSummaryCollectionItemResult']):
        GetNetworkFirewallPolicyAddressListsAddressListSummaryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetNetworkFirewallPolicyAddressListsAddressListSummaryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworkFirewallPolicyAddressListsAddressListSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkFirewallPolicyAddressListsAddressListSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 addresses: Sequence[str],
                 name: str,
                 network_firewall_policy_id: str,
                 parent_resource_id: str,
                 total_addresses: int,
                 type: str):
        """
        :param Sequence[str] addresses: List of addresses.
        :param str name: Unique name to identify the group of addresses to be used in the policy rules.
        :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param str parent_resource_id: OCID of the Network Firewall Policy this Address List belongs to.
        :param int total_addresses: Count of total Addresses in the AddressList
        :param str type: Type of address list.
        """
        GetNetworkFirewallPolicyAddressListsAddressListSummaryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            addresses=addresses,
            name=name,
            network_firewall_policy_id=network_firewall_policy_id,
            parent_resource_id=parent_resource_id,
            total_addresses=total_addresses,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             addresses: Sequence[str],
             name: str,
             network_firewall_policy_id: str,
             parent_resource_id: str,
             total_addresses: int,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'networkFirewallPolicyId' in kwargs:
            network_firewall_policy_id = kwargs['networkFirewallPolicyId']
        if 'parentResourceId' in kwargs:
            parent_resource_id = kwargs['parentResourceId']
        if 'totalAddresses' in kwargs:
            total_addresses = kwargs['totalAddresses']

        _setter("addresses", addresses)
        _setter("name", name)
        _setter("network_firewall_policy_id", network_firewall_policy_id)
        _setter("parent_resource_id", parent_resource_id)
        _setter("total_addresses", total_addresses)
        _setter("type", type)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence[str]:
        """
        List of addresses.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name to identify the group of addresses to be used in the policy rules.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> str:
        """
        OCID of the Network Firewall Policy this Address List belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter(name="totalAddresses")
    def total_addresses(self) -> int:
        """
        Count of total Addresses in the AddressList
        """
        return pulumi.get(self, "total_addresses")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of address list.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkFirewallPolicyAddressListsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Unique name to identify the group of addresses to be used in the policy rules.
        """
        GetNetworkFirewallPolicyAddressListsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name to identify the group of addresses to be used in the policy rules.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkFirewallPolicyApplicationGroupsApplicationGroupSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetNetworkFirewallPolicyApplicationGroupsApplicationGroupSummaryCollectionItemResult']):
        GetNetworkFirewallPolicyApplicationGroupsApplicationGroupSummaryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetNetworkFirewallPolicyApplicationGroupsApplicationGroupSummaryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworkFirewallPolicyApplicationGroupsApplicationGroupSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkFirewallPolicyApplicationGroupsApplicationGroupSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 apps: Sequence[str],
                 name: str,
                 network_firewall_policy_id: str,
                 parent_resource_id: str,
                 total_apps: int):
        """
        :param Sequence[str] apps: List of apps in the group.
        :param str name: Name of the application Group.
        :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param str parent_resource_id: OCID of the Network Firewall Policy this application group belongs to.
        :param int total_apps: Count of total applications in the given application group.
        """
        GetNetworkFirewallPolicyApplicationGroupsApplicationGroupSummaryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            apps=apps,
            name=name,
            network_firewall_policy_id=network_firewall_policy_id,
            parent_resource_id=parent_resource_id,
            total_apps=total_apps,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             apps: Sequence[str],
             name: str,
             network_firewall_policy_id: str,
             parent_resource_id: str,
             total_apps: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'networkFirewallPolicyId' in kwargs:
            network_firewall_policy_id = kwargs['networkFirewallPolicyId']
        if 'parentResourceId' in kwargs:
            parent_resource_id = kwargs['parentResourceId']
        if 'totalApps' in kwargs:
            total_apps = kwargs['totalApps']

        _setter("apps", apps)
        _setter("name", name)
        _setter("network_firewall_policy_id", network_firewall_policy_id)
        _setter("parent_resource_id", parent_resource_id)
        _setter("total_apps", total_apps)

    @property
    @pulumi.getter
    def apps(self) -> Sequence[str]:
        """
        List of apps in the group.
        """
        return pulumi.get(self, "apps")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the application Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> str:
        """
        OCID of the Network Firewall Policy this application group belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter(name="totalApps")
    def total_apps(self) -> int:
        """
        Count of total applications in the given application group.
        """
        return pulumi.get(self, "total_apps")


@pulumi.output_type
class GetNetworkFirewallPolicyApplicationGroupsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of the application Group.
        """
        GetNetworkFirewallPolicyApplicationGroupsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the application Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkFirewallPolicyApplicationsApplicationSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetNetworkFirewallPolicyApplicationsApplicationSummaryCollectionItemResult']):
        GetNetworkFirewallPolicyApplicationsApplicationSummaryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetNetworkFirewallPolicyApplicationsApplicationSummaryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworkFirewallPolicyApplicationsApplicationSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkFirewallPolicyApplicationsApplicationSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 icmp_code: int,
                 icmp_type: int,
                 name: str,
                 network_firewall_policy_id: str,
                 parent_resource_id: str,
                 type: str):
        """
        :param int icmp_code: The value of the ICMP6 message Code (subtype) field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        :param int icmp_type: The value of the ICMP6 message Type field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        :param str name: Name of the application.
        :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param str parent_resource_id: OCID of the Network Firewall Policy this application belongs to.
        :param str type: Describes the type of Application.
        """
        GetNetworkFirewallPolicyApplicationsApplicationSummaryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            icmp_code=icmp_code,
            icmp_type=icmp_type,
            name=name,
            network_firewall_policy_id=network_firewall_policy_id,
            parent_resource_id=parent_resource_id,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             icmp_code: int,
             icmp_type: int,
             name: str,
             network_firewall_policy_id: str,
             parent_resource_id: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'icmpCode' in kwargs:
            icmp_code = kwargs['icmpCode']
        if 'icmpType' in kwargs:
            icmp_type = kwargs['icmpType']
        if 'networkFirewallPolicyId' in kwargs:
            network_firewall_policy_id = kwargs['networkFirewallPolicyId']
        if 'parentResourceId' in kwargs:
            parent_resource_id = kwargs['parentResourceId']

        _setter("icmp_code", icmp_code)
        _setter("icmp_type", icmp_type)
        _setter("name", name)
        _setter("network_firewall_policy_id", network_firewall_policy_id)
        _setter("parent_resource_id", parent_resource_id)
        _setter("type", type)

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> int:
        """
        The value of the ICMP6 message Code (subtype) field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        """
        return pulumi.get(self, "icmp_code")

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> int:
        """
        The value of the ICMP6 message Type field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        """
        return pulumi.get(self, "icmp_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> str:
        """
        OCID of the Network Firewall Policy this application belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Describes the type of Application.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkFirewallPolicyApplicationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of the application.
        """
        GetNetworkFirewallPolicyApplicationsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkFirewallPolicyDecryptionProfilesDecryptionProfileSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetNetworkFirewallPolicyDecryptionProfilesDecryptionProfileSummaryCollectionItemResult']):
        GetNetworkFirewallPolicyDecryptionProfilesDecryptionProfileSummaryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetNetworkFirewallPolicyDecryptionProfilesDecryptionProfileSummaryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworkFirewallPolicyDecryptionProfilesDecryptionProfileSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkFirewallPolicyDecryptionProfilesDecryptionProfileSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 are_certificate_extensions_restricted: bool,
                 is_auto_include_alt_name: bool,
                 is_expired_certificate_blocked: bool,
                 is_out_of_capacity_blocked: bool,
                 is_revocation_status_timeout_blocked: bool,
                 is_unknown_revocation_status_blocked: bool,
                 is_unsupported_cipher_blocked: bool,
                 is_unsupported_version_blocked: bool,
                 is_untrusted_issuer_blocked: bool,
                 name: str,
                 network_firewall_policy_id: str,
                 parent_resource_id: str,
                 type: str):
        """
        :param bool are_certificate_extensions_restricted: Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.
        :param bool is_auto_include_alt_name: Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.
        :param bool is_expired_certificate_blocked: Whether to block sessions if server's certificate is expired.
        :param bool is_out_of_capacity_blocked: Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.
        :param bool is_revocation_status_timeout_blocked: Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).
        :param bool is_unknown_revocation_status_blocked: Whether to block sessions if the revocation status check for server's certificate results in "unknown".
        :param bool is_unsupported_cipher_blocked: Whether to block sessions if SSL cipher suite is not supported.
        :param bool is_unsupported_version_blocked: Whether to block sessions if SSL version is not supported.
        :param bool is_untrusted_issuer_blocked: Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).
        :param str name: Unique Name of the decryption profile.
        :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param str parent_resource_id: OCID of the Network Firewall Policy this decryption profile belongs to.
        :param str type: Describes the type of Decryption Profile SslForwardProxy or SslInboundInspection.
        """
        GetNetworkFirewallPolicyDecryptionProfilesDecryptionProfileSummaryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            are_certificate_extensions_restricted=are_certificate_extensions_restricted,
            is_auto_include_alt_name=is_auto_include_alt_name,
            is_expired_certificate_blocked=is_expired_certificate_blocked,
            is_out_of_capacity_blocked=is_out_of_capacity_blocked,
            is_revocation_status_timeout_blocked=is_revocation_status_timeout_blocked,
            is_unknown_revocation_status_blocked=is_unknown_revocation_status_blocked,
            is_unsupported_cipher_blocked=is_unsupported_cipher_blocked,
            is_unsupported_version_blocked=is_unsupported_version_blocked,
            is_untrusted_issuer_blocked=is_untrusted_issuer_blocked,
            name=name,
            network_firewall_policy_id=network_firewall_policy_id,
            parent_resource_id=parent_resource_id,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             are_certificate_extensions_restricted: bool,
             is_auto_include_alt_name: bool,
             is_expired_certificate_blocked: bool,
             is_out_of_capacity_blocked: bool,
             is_revocation_status_timeout_blocked: bool,
             is_unknown_revocation_status_blocked: bool,
             is_unsupported_cipher_blocked: bool,
             is_unsupported_version_blocked: bool,
             is_untrusted_issuer_blocked: bool,
             name: str,
             network_firewall_policy_id: str,
             parent_resource_id: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'areCertificateExtensionsRestricted' in kwargs:
            are_certificate_extensions_restricted = kwargs['areCertificateExtensionsRestricted']
        if 'isAutoIncludeAltName' in kwargs:
            is_auto_include_alt_name = kwargs['isAutoIncludeAltName']
        if 'isExpiredCertificateBlocked' in kwargs:
            is_expired_certificate_blocked = kwargs['isExpiredCertificateBlocked']
        if 'isOutOfCapacityBlocked' in kwargs:
            is_out_of_capacity_blocked = kwargs['isOutOfCapacityBlocked']
        if 'isRevocationStatusTimeoutBlocked' in kwargs:
            is_revocation_status_timeout_blocked = kwargs['isRevocationStatusTimeoutBlocked']
        if 'isUnknownRevocationStatusBlocked' in kwargs:
            is_unknown_revocation_status_blocked = kwargs['isUnknownRevocationStatusBlocked']
        if 'isUnsupportedCipherBlocked' in kwargs:
            is_unsupported_cipher_blocked = kwargs['isUnsupportedCipherBlocked']
        if 'isUnsupportedVersionBlocked' in kwargs:
            is_unsupported_version_blocked = kwargs['isUnsupportedVersionBlocked']
        if 'isUntrustedIssuerBlocked' in kwargs:
            is_untrusted_issuer_blocked = kwargs['isUntrustedIssuerBlocked']
        if 'networkFirewallPolicyId' in kwargs:
            network_firewall_policy_id = kwargs['networkFirewallPolicyId']
        if 'parentResourceId' in kwargs:
            parent_resource_id = kwargs['parentResourceId']

        _setter("are_certificate_extensions_restricted", are_certificate_extensions_restricted)
        _setter("is_auto_include_alt_name", is_auto_include_alt_name)
        _setter("is_expired_certificate_blocked", is_expired_certificate_blocked)
        _setter("is_out_of_capacity_blocked", is_out_of_capacity_blocked)
        _setter("is_revocation_status_timeout_blocked", is_revocation_status_timeout_blocked)
        _setter("is_unknown_revocation_status_blocked", is_unknown_revocation_status_blocked)
        _setter("is_unsupported_cipher_blocked", is_unsupported_cipher_blocked)
        _setter("is_unsupported_version_blocked", is_unsupported_version_blocked)
        _setter("is_untrusted_issuer_blocked", is_untrusted_issuer_blocked)
        _setter("name", name)
        _setter("network_firewall_policy_id", network_firewall_policy_id)
        _setter("parent_resource_id", parent_resource_id)
        _setter("type", type)

    @property
    @pulumi.getter(name="areCertificateExtensionsRestricted")
    def are_certificate_extensions_restricted(self) -> bool:
        """
        Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.
        """
        return pulumi.get(self, "are_certificate_extensions_restricted")

    @property
    @pulumi.getter(name="isAutoIncludeAltName")
    def is_auto_include_alt_name(self) -> bool:
        """
        Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.
        """
        return pulumi.get(self, "is_auto_include_alt_name")

    @property
    @pulumi.getter(name="isExpiredCertificateBlocked")
    def is_expired_certificate_blocked(self) -> bool:
        """
        Whether to block sessions if server's certificate is expired.
        """
        return pulumi.get(self, "is_expired_certificate_blocked")

    @property
    @pulumi.getter(name="isOutOfCapacityBlocked")
    def is_out_of_capacity_blocked(self) -> bool:
        """
        Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.
        """
        return pulumi.get(self, "is_out_of_capacity_blocked")

    @property
    @pulumi.getter(name="isRevocationStatusTimeoutBlocked")
    def is_revocation_status_timeout_blocked(self) -> bool:
        """
        Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).
        """
        return pulumi.get(self, "is_revocation_status_timeout_blocked")

    @property
    @pulumi.getter(name="isUnknownRevocationStatusBlocked")
    def is_unknown_revocation_status_blocked(self) -> bool:
        """
        Whether to block sessions if the revocation status check for server's certificate results in "unknown".
        """
        return pulumi.get(self, "is_unknown_revocation_status_blocked")

    @property
    @pulumi.getter(name="isUnsupportedCipherBlocked")
    def is_unsupported_cipher_blocked(self) -> bool:
        """
        Whether to block sessions if SSL cipher suite is not supported.
        """
        return pulumi.get(self, "is_unsupported_cipher_blocked")

    @property
    @pulumi.getter(name="isUnsupportedVersionBlocked")
    def is_unsupported_version_blocked(self) -> bool:
        """
        Whether to block sessions if SSL version is not supported.
        """
        return pulumi.get(self, "is_unsupported_version_blocked")

    @property
    @pulumi.getter(name="isUntrustedIssuerBlocked")
    def is_untrusted_issuer_blocked(self) -> bool:
        """
        Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).
        """
        return pulumi.get(self, "is_untrusted_issuer_blocked")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique Name of the decryption profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> str:
        """
        OCID of the Network Firewall Policy this decryption profile belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Describes the type of Decryption Profile SslForwardProxy or SslInboundInspection.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkFirewallPolicyDecryptionProfilesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Unique Name of the decryption profile.
        """
        GetNetworkFirewallPolicyDecryptionProfilesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique Name of the decryption profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkFirewallPolicyDecryptionRuleConditionResult(dict):
    def __init__(__self__, *,
                 destination_addresses: Sequence[str],
                 source_addresses: Sequence[str]):
        """
        :param Sequence[str] destination_addresses: An array of IP address list names to be evaluated against the traffic destination address.
        :param Sequence[str] source_addresses: An array of IP address list names to be evaluated against the traffic source address.
        """
        GetNetworkFirewallPolicyDecryptionRuleConditionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            destination_addresses=destination_addresses,
            source_addresses=source_addresses,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             destination_addresses: Sequence[str],
             source_addresses: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'destinationAddresses' in kwargs:
            destination_addresses = kwargs['destinationAddresses']
        if 'sourceAddresses' in kwargs:
            source_addresses = kwargs['sourceAddresses']

        _setter("destination_addresses", destination_addresses)
        _setter("source_addresses", source_addresses)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Sequence[str]:
        """
        An array of IP address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Sequence[str]:
        """
        An array of IP address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "source_addresses")


@pulumi.output_type
class GetNetworkFirewallPolicyDecryptionRulePositionResult(dict):
    def __init__(__self__, *,
                 after_rule: str,
                 before_rule: str):
        """
        :param str after_rule: Identifier for rule after which this rule lies.
        :param str before_rule: Identifier for rule before which this rule lies.
        """
        GetNetworkFirewallPolicyDecryptionRulePositionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            after_rule=after_rule,
            before_rule=before_rule,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             after_rule: str,
             before_rule: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'afterRule' in kwargs:
            after_rule = kwargs['afterRule']
        if 'beforeRule' in kwargs:
            before_rule = kwargs['beforeRule']

        _setter("after_rule", after_rule)
        _setter("before_rule", before_rule)

    @property
    @pulumi.getter(name="afterRule")
    def after_rule(self) -> str:
        """
        Identifier for rule after which this rule lies.
        """
        return pulumi.get(self, "after_rule")

    @property
    @pulumi.getter(name="beforeRule")
    def before_rule(self) -> str:
        """
        Identifier for rule before which this rule lies.
        """
        return pulumi.get(self, "before_rule")


@pulumi.output_type
class GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemResult']):
        GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 action: str,
                 condition: 'outputs.GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemConditionResult',
                 name: str,
                 network_firewall_policy_id: str,
                 parent_resource_id: str,
                 position: 'outputs.GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemPositionResult',
                 decryption_profile: Optional[str] = None,
                 priority_order: Optional[str] = None,
                 secret: Optional[str] = None):
        """
        :param str action: Action:
               * NO_DECRYPT - Matching traffic is not decrypted.
               * DECRYPT - Matching traffic is decrypted with the specified `secret` according to the specified `decryptionProfile`.
        :param 'GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemConditionArgs' condition: Match criteria used in Decryption Rule used on the firewall policy rules.
        :param str name: Name for the decryption rule, must be unique within the policy.
        :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param str parent_resource_id: OCID of the Network Firewall Policy this decryption rule belongs to.
        :param 'GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemPositionArgs' position: An object which defines the position of the rule.
        :param str decryption_profile: The name of the decryption profile to use.
        :param str secret: The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            condition=condition,
            name=name,
            network_firewall_policy_id=network_firewall_policy_id,
            parent_resource_id=parent_resource_id,
            position=position,
            decryption_profile=decryption_profile,
            priority_order=priority_order,
            secret=secret,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: str,
             condition: 'outputs.GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemConditionResult',
             name: str,
             network_firewall_policy_id: str,
             parent_resource_id: str,
             position: 'outputs.GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemPositionResult',
             decryption_profile: Optional[str] = None,
             priority_order: Optional[str] = None,
             secret: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'networkFirewallPolicyId' in kwargs:
            network_firewall_policy_id = kwargs['networkFirewallPolicyId']
        if 'parentResourceId' in kwargs:
            parent_resource_id = kwargs['parentResourceId']
        if 'decryptionProfile' in kwargs:
            decryption_profile = kwargs['decryptionProfile']
        if 'priorityOrder' in kwargs:
            priority_order = kwargs['priorityOrder']

        _setter("action", action)
        _setter("condition", condition)
        _setter("name", name)
        _setter("network_firewall_policy_id", network_firewall_policy_id)
        _setter("parent_resource_id", parent_resource_id)
        _setter("position", position)
        if decryption_profile is not None:
            _setter("decryption_profile", decryption_profile)
        if priority_order is not None:
            _setter("priority_order", priority_order)
        if secret is not None:
            _setter("secret", secret)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Action:
        * NO_DECRYPT - Matching traffic is not decrypted.
        * DECRYPT - Matching traffic is decrypted with the specified `secret` according to the specified `decryptionProfile`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemConditionResult':
        """
        Match criteria used in Decryption Rule used on the firewall policy rules.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for the decryption rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> str:
        """
        OCID of the Network Firewall Policy this decryption rule belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter
    def position(self) -> 'outputs.GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemPositionResult':
        """
        An object which defines the position of the rule.
        """
        return pulumi.get(self, "position")

    @property
    @pulumi.getter(name="decryptionProfile")
    def decryption_profile(self) -> Optional[str]:
        """
        The name of the decryption profile to use.
        """
        return pulumi.get(self, "decryption_profile")

    @property
    @pulumi.getter(name="priorityOrder")
    def priority_order(self) -> Optional[str]:
        return pulumi.get(self, "priority_order")

    @property
    @pulumi.getter
    def secret(self) -> Optional[str]:
        """
        The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemConditionResult(dict):
    def __init__(__self__, *,
                 destination_addresses: Optional[Sequence[str]] = None,
                 source_addresses: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] destination_addresses: An array of IP address list names to be evaluated against the traffic destination address.
        :param Sequence[str] source_addresses: An array of IP address list names to be evaluated against the traffic source address.
        """
        GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemConditionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            destination_addresses=destination_addresses,
            source_addresses=source_addresses,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             destination_addresses: Optional[Sequence[str]] = None,
             source_addresses: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'destinationAddresses' in kwargs:
            destination_addresses = kwargs['destinationAddresses']
        if 'sourceAddresses' in kwargs:
            source_addresses = kwargs['sourceAddresses']

        if destination_addresses is not None:
            _setter("destination_addresses", destination_addresses)
        if source_addresses is not None:
            _setter("source_addresses", source_addresses)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[Sequence[str]]:
        """
        An array of IP address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        An array of IP address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "source_addresses")


@pulumi.output_type
class GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemPositionResult(dict):
    def __init__(__self__, *,
                 after_rule: Optional[str] = None,
                 before_rule: Optional[str] = None):
        """
        :param str after_rule: Identifier for rule after which this rule lies.
        :param str before_rule: Identifier for rule before which this rule lies.
        """
        GetNetworkFirewallPolicyDecryptionRulesDecryptionRuleSummaryCollectionItemPositionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            after_rule=after_rule,
            before_rule=before_rule,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             after_rule: Optional[str] = None,
             before_rule: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'afterRule' in kwargs:
            after_rule = kwargs['afterRule']
        if 'beforeRule' in kwargs:
            before_rule = kwargs['beforeRule']

        if after_rule is not None:
            _setter("after_rule", after_rule)
        if before_rule is not None:
            _setter("before_rule", before_rule)

    @property
    @pulumi.getter(name="afterRule")
    def after_rule(self) -> Optional[str]:
        """
        Identifier for rule after which this rule lies.
        """
        return pulumi.get(self, "after_rule")

    @property
    @pulumi.getter(name="beforeRule")
    def before_rule(self) -> Optional[str]:
        """
        Identifier for rule before which this rule lies.
        """
        return pulumi.get(self, "before_rule")


@pulumi.output_type
class GetNetworkFirewallPolicyDecryptionRulesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name for the decryption rule, must be unique within the policy.
        """
        GetNetworkFirewallPolicyDecryptionRulesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for the decryption rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkFirewallPolicyMappedSecretsMappedSecretSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetNetworkFirewallPolicyMappedSecretsMappedSecretSummaryCollectionItemResult']):
        GetNetworkFirewallPolicyMappedSecretsMappedSecretSummaryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetNetworkFirewallPolicyMappedSecretsMappedSecretSummaryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworkFirewallPolicyMappedSecretsMappedSecretSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkFirewallPolicyMappedSecretsMappedSecretSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 name: str,
                 network_firewall_policy_id: str,
                 parent_resource_id: str,
                 source: str,
                 type: str,
                 vault_secret_id: str,
                 version_number: int):
        """
        :param str name: Name of the secret.
        :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param str parent_resource_id: OCID of the Network Firewall Policy this Mapped Secret belongs to.
        :param str source: Source of the secrets, where the secrets are stored.
        :param str type: Type of the secrets mapped based on the policy.
        :param str vault_secret_id: OCID for the Vault Secret to be used.
        :param int version_number: Version number of the secret to be used.
        """
        GetNetworkFirewallPolicyMappedSecretsMappedSecretSummaryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            network_firewall_policy_id=network_firewall_policy_id,
            parent_resource_id=parent_resource_id,
            source=source,
            type=type,
            vault_secret_id=vault_secret_id,
            version_number=version_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             network_firewall_policy_id: str,
             parent_resource_id: str,
             source: str,
             type: str,
             vault_secret_id: str,
             version_number: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'networkFirewallPolicyId' in kwargs:
            network_firewall_policy_id = kwargs['networkFirewallPolicyId']
        if 'parentResourceId' in kwargs:
            parent_resource_id = kwargs['parentResourceId']
        if 'vaultSecretId' in kwargs:
            vault_secret_id = kwargs['vaultSecretId']
        if 'versionNumber' in kwargs:
            version_number = kwargs['versionNumber']

        _setter("name", name)
        _setter("network_firewall_policy_id", network_firewall_policy_id)
        _setter("parent_resource_id", parent_resource_id)
        _setter("source", source)
        _setter("type", type)
        _setter("vault_secret_id", vault_secret_id)
        _setter("version_number", version_number)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the secret.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> str:
        """
        OCID of the Network Firewall Policy this Mapped Secret belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        Source of the secrets, where the secrets are stored.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the secrets mapped based on the policy.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vaultSecretId")
    def vault_secret_id(self) -> str:
        """
        OCID for the Vault Secret to be used.
        """
        return pulumi.get(self, "vault_secret_id")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> int:
        """
        Version number of the secret to be used.
        """
        return pulumi.get(self, "version_number")


@pulumi.output_type
class GetNetworkFirewallPolicySecurityRuleConditionResult(dict):
    def __init__(__self__, *,
                 applications: Sequence[str],
                 destination_addresses: Sequence[str],
                 services: Sequence[str],
                 source_addresses: Sequence[str],
                 urls: Sequence[str]):
        """
        :param Sequence[str] applications: An array of application list names to be evaluated against the traffic protocol and protocol-specific parameters.
        :param Sequence[str] destination_addresses: An array of IP address list names to be evaluated against the traffic destination address.
        :param Sequence[str] services: An array of service list names to be evaluated against the traffic protocol and protocol-specific parameters.
        :param Sequence[str] source_addresses: An array of IP address list names to be evaluated against the traffic source address.
        :param Sequence[str] urls: An array of URL pattern list names to be evaluated against the HTTP(S) request target.
        """
        GetNetworkFirewallPolicySecurityRuleConditionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            applications=applications,
            destination_addresses=destination_addresses,
            services=services,
            source_addresses=source_addresses,
            urls=urls,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             applications: Sequence[str],
             destination_addresses: Sequence[str],
             services: Sequence[str],
             source_addresses: Sequence[str],
             urls: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'destinationAddresses' in kwargs:
            destination_addresses = kwargs['destinationAddresses']
        if 'sourceAddresses' in kwargs:
            source_addresses = kwargs['sourceAddresses']

        _setter("applications", applications)
        _setter("destination_addresses", destination_addresses)
        _setter("services", services)
        _setter("source_addresses", source_addresses)
        _setter("urls", urls)

    @property
    @pulumi.getter
    def applications(self) -> Sequence[str]:
        """
        An array of application list names to be evaluated against the traffic protocol and protocol-specific parameters.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Sequence[str]:
        """
        An array of IP address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter
    def services(self) -> Sequence[str]:
        """
        An array of service list names to be evaluated against the traffic protocol and protocol-specific parameters.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Sequence[str]:
        """
        An array of IP address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter
    def urls(self) -> Sequence[str]:
        """
        An array of URL pattern list names to be evaluated against the HTTP(S) request target.
        """
        return pulumi.get(self, "urls")


@pulumi.output_type
class GetNetworkFirewallPolicySecurityRulePositionResult(dict):
    def __init__(__self__, *,
                 after_rule: str,
                 before_rule: str):
        """
        :param str after_rule: Identifier for rule after which this rule lies.
        :param str before_rule: Identifier for rule before which this rule lies.
        """
        GetNetworkFirewallPolicySecurityRulePositionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            after_rule=after_rule,
            before_rule=before_rule,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             after_rule: str,
             before_rule: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'afterRule' in kwargs:
            after_rule = kwargs['afterRule']
        if 'beforeRule' in kwargs:
            before_rule = kwargs['beforeRule']

        _setter("after_rule", after_rule)
        _setter("before_rule", before_rule)

    @property
    @pulumi.getter(name="afterRule")
    def after_rule(self) -> str:
        """
        Identifier for rule after which this rule lies.
        """
        return pulumi.get(self, "after_rule")

    @property
    @pulumi.getter(name="beforeRule")
    def before_rule(self) -> str:
        """
        Identifier for rule before which this rule lies.
        """
        return pulumi.get(self, "before_rule")


@pulumi.output_type
class GetNetworkFirewallPolicySecurityRulesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name for the Security rule, must be unique within the policy.
        """
        GetNetworkFirewallPolicySecurityRulesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for the Security rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemResult']):
        GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 action: str,
                 condition: 'outputs.GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemConditionResult',
                 name: str,
                 network_firewall_policy_id: str,
                 parent_resource_id: str,
                 positions: Sequence['outputs.GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemPositionResult'],
                 inspection: Optional[str] = None,
                 priority_order: Optional[str] = None):
        """
        :param str action: Types of Action on the Traffic flow.
               * ALLOW - Allows the traffic.
               * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
               * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
               * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.
        :param 'GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemConditionArgs' condition: Criteria to evaluate against network traffic. A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
        :param str name: Name for the Security rule, must be unique within the policy.
        :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param str parent_resource_id: OCID of the Network Firewall Policy this security rule belongs to.
        :param Sequence['GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemPositionArgs'] positions: An object which defines the position of the rule.
        :param str inspection: Type of inspection to affect the Traffic flow. This is only applicable if action is INSPECT.
               * INTRUSION_DETECTION - Intrusion Detection.
               * INTRUSION_PREVENTION - Intrusion Detection and Prevention. Traffic classified as potentially malicious will be rejected as described in `type`.
        """
        GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            condition=condition,
            name=name,
            network_firewall_policy_id=network_firewall_policy_id,
            parent_resource_id=parent_resource_id,
            positions=positions,
            inspection=inspection,
            priority_order=priority_order,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: str,
             condition: 'outputs.GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemConditionResult',
             name: str,
             network_firewall_policy_id: str,
             parent_resource_id: str,
             positions: Sequence['outputs.GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemPositionResult'],
             inspection: Optional[str] = None,
             priority_order: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'networkFirewallPolicyId' in kwargs:
            network_firewall_policy_id = kwargs['networkFirewallPolicyId']
        if 'parentResourceId' in kwargs:
            parent_resource_id = kwargs['parentResourceId']
        if 'priorityOrder' in kwargs:
            priority_order = kwargs['priorityOrder']

        _setter("action", action)
        _setter("condition", condition)
        _setter("name", name)
        _setter("network_firewall_policy_id", network_firewall_policy_id)
        _setter("parent_resource_id", parent_resource_id)
        _setter("positions", positions)
        if inspection is not None:
            _setter("inspection", inspection)
        if priority_order is not None:
            _setter("priority_order", priority_order)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Types of Action on the Traffic flow.
        * ALLOW - Allows the traffic.
        * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
        * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
        * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemConditionResult':
        """
        Criteria to evaluate against network traffic. A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for the Security rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> str:
        """
        OCID of the Network Firewall Policy this security rule belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter
    def positions(self) -> Sequence['outputs.GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemPositionResult']:
        """
        An object which defines the position of the rule.
        """
        return pulumi.get(self, "positions")

    @property
    @pulumi.getter
    def inspection(self) -> Optional[str]:
        """
        Type of inspection to affect the Traffic flow. This is only applicable if action is INSPECT.
        * INTRUSION_DETECTION - Intrusion Detection.
        * INTRUSION_PREVENTION - Intrusion Detection and Prevention. Traffic classified as potentially malicious will be rejected as described in `type`.
        """
        return pulumi.get(self, "inspection")

    @property
    @pulumi.getter(name="priorityOrder")
    def priority_order(self) -> Optional[str]:
        return pulumi.get(self, "priority_order")


@pulumi.output_type
class GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemConditionResult(dict):
    def __init__(__self__, *,
                 applications: Sequence[str],
                 destination_addresses: Sequence[str],
                 services: Sequence[str],
                 source_addresses: Sequence[str],
                 urls: Sequence[str]):
        """
        :param Sequence[str] applications: An array of application list names to be evaluated against the traffic protocol and protocol-specific parameters.
        :param Sequence[str] destination_addresses: An array of IP address list names to be evaluated against the traffic destination address.
        :param Sequence[str] services: An array of service list names to be evaluated against the traffic protocol and protocol-specific parameters.
        :param Sequence[str] source_addresses: An array of IP address list names to be evaluated against the traffic source address.
        :param Sequence[str] urls: An array of URL pattern list names to be evaluated against the HTTP(S) request target.
        """
        GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemConditionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            applications=applications,
            destination_addresses=destination_addresses,
            services=services,
            source_addresses=source_addresses,
            urls=urls,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             applications: Sequence[str],
             destination_addresses: Sequence[str],
             services: Sequence[str],
             source_addresses: Sequence[str],
             urls: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'destinationAddresses' in kwargs:
            destination_addresses = kwargs['destinationAddresses']
        if 'sourceAddresses' in kwargs:
            source_addresses = kwargs['sourceAddresses']

        _setter("applications", applications)
        _setter("destination_addresses", destination_addresses)
        _setter("services", services)
        _setter("source_addresses", source_addresses)
        _setter("urls", urls)

    @property
    @pulumi.getter
    def applications(self) -> Sequence[str]:
        """
        An array of application list names to be evaluated against the traffic protocol and protocol-specific parameters.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Sequence[str]:
        """
        An array of IP address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter
    def services(self) -> Sequence[str]:
        """
        An array of service list names to be evaluated against the traffic protocol and protocol-specific parameters.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Sequence[str]:
        """
        An array of IP address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter
    def urls(self) -> Sequence[str]:
        """
        An array of URL pattern list names to be evaluated against the HTTP(S) request target.
        """
        return pulumi.get(self, "urls")


@pulumi.output_type
class GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemPositionResult(dict):
    def __init__(__self__, *,
                 after_rule: Optional[str] = None,
                 before_rule: Optional[str] = None):
        """
        :param str after_rule: Identifier for rule after which this rule lies.
        :param str before_rule: Identifier for rule before which this rule lies.
        """
        GetNetworkFirewallPolicySecurityRulesSecurityRuleSummaryCollectionItemPositionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            after_rule=after_rule,
            before_rule=before_rule,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             after_rule: Optional[str] = None,
             before_rule: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'afterRule' in kwargs:
            after_rule = kwargs['afterRule']
        if 'beforeRule' in kwargs:
            before_rule = kwargs['beforeRule']

        if after_rule is not None:
            _setter("after_rule", after_rule)
        if before_rule is not None:
            _setter("before_rule", before_rule)

    @property
    @pulumi.getter(name="afterRule")
    def after_rule(self) -> Optional[str]:
        """
        Identifier for rule after which this rule lies.
        """
        return pulumi.get(self, "after_rule")

    @property
    @pulumi.getter(name="beforeRule")
    def before_rule(self) -> Optional[str]:
        """
        Identifier for rule before which this rule lies.
        """
        return pulumi.get(self, "before_rule")


@pulumi.output_type
class GetNetworkFirewallPolicyServiceListsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of the service Group.
        """
        GetNetworkFirewallPolicyServiceListsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the service Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkFirewallPolicyServiceListsServiceListSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetNetworkFirewallPolicyServiceListsServiceListSummaryCollectionItemResult']):
        GetNetworkFirewallPolicyServiceListsServiceListSummaryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetNetworkFirewallPolicyServiceListsServiceListSummaryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworkFirewallPolicyServiceListsServiceListSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkFirewallPolicyServiceListsServiceListSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 name: str,
                 network_firewall_policy_id: str,
                 parent_resource_id: str,
                 services: Sequence[str],
                 total_services: int):
        """
        :param str name: Name of the service Group.
        :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param str parent_resource_id: OCID of the Network Firewall Policy this serviceList belongs to.
        :param Sequence[str] services: List of services in the group.
        :param int total_services: Count of total services in the given service List.
        """
        GetNetworkFirewallPolicyServiceListsServiceListSummaryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            network_firewall_policy_id=network_firewall_policy_id,
            parent_resource_id=parent_resource_id,
            services=services,
            total_services=total_services,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             network_firewall_policy_id: str,
             parent_resource_id: str,
             services: Sequence[str],
             total_services: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'networkFirewallPolicyId' in kwargs:
            network_firewall_policy_id = kwargs['networkFirewallPolicyId']
        if 'parentResourceId' in kwargs:
            parent_resource_id = kwargs['parentResourceId']
        if 'totalServices' in kwargs:
            total_services = kwargs['totalServices']

        _setter("name", name)
        _setter("network_firewall_policy_id", network_firewall_policy_id)
        _setter("parent_resource_id", parent_resource_id)
        _setter("services", services)
        _setter("total_services", total_services)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the service Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> str:
        """
        OCID of the Network Firewall Policy this serviceList belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter
    def services(self) -> Sequence[str]:
        """
        List of services in the group.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="totalServices")
    def total_services(self) -> int:
        """
        Count of total services in the given service List.
        """
        return pulumi.get(self, "total_services")


@pulumi.output_type
class GetNetworkFirewallPolicyServicePortRangeResult(dict):
    def __init__(__self__, *,
                 maximum_port: int,
                 minimum_port: int):
        """
        :param int maximum_port: The maximum port in the range (inclusive), which may be absent for a single-port range.
        :param int minimum_port: The minimum port in the range (inclusive), or the sole port of a single-port range.
        """
        GetNetworkFirewallPolicyServicePortRangeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            maximum_port=maximum_port,
            minimum_port=minimum_port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             maximum_port: int,
             minimum_port: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'maximumPort' in kwargs:
            maximum_port = kwargs['maximumPort']
        if 'minimumPort' in kwargs:
            minimum_port = kwargs['minimumPort']

        _setter("maximum_port", maximum_port)
        _setter("minimum_port", minimum_port)

    @property
    @pulumi.getter(name="maximumPort")
    def maximum_port(self) -> int:
        """
        The maximum port in the range (inclusive), which may be absent for a single-port range.
        """
        return pulumi.get(self, "maximum_port")

    @property
    @pulumi.getter(name="minimumPort")
    def minimum_port(self) -> int:
        """
        The minimum port in the range (inclusive), or the sole port of a single-port range.
        """
        return pulumi.get(self, "minimum_port")


@pulumi.output_type
class GetNetworkFirewallPolicyServicesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of the service.
        """
        GetNetworkFirewallPolicyServicesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkFirewallPolicyServicesServiceSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetNetworkFirewallPolicyServicesServiceSummaryCollectionItemResult']):
        GetNetworkFirewallPolicyServicesServiceSummaryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetNetworkFirewallPolicyServicesServiceSummaryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworkFirewallPolicyServicesServiceSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkFirewallPolicyServicesServiceSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 name: str,
                 network_firewall_policy_id: str,
                 parent_resource_id: str,
                 port_ranges: Sequence['outputs.GetNetworkFirewallPolicyServicesServiceSummaryCollectionItemPortRangeResult'],
                 type: str):
        """
        :param str name: Name of the service.
        :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param str parent_resource_id: OCID of the Network Firewall Policy this service belongs to.
        :param Sequence['GetNetworkFirewallPolicyServicesServiceSummaryCollectionItemPortRangeArgs'] port_ranges: List of port-ranges used.
        :param str type: Describes the type of Service.
        """
        GetNetworkFirewallPolicyServicesServiceSummaryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            network_firewall_policy_id=network_firewall_policy_id,
            parent_resource_id=parent_resource_id,
            port_ranges=port_ranges,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             network_firewall_policy_id: str,
             parent_resource_id: str,
             port_ranges: Sequence['outputs.GetNetworkFirewallPolicyServicesServiceSummaryCollectionItemPortRangeResult'],
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'networkFirewallPolicyId' in kwargs:
            network_firewall_policy_id = kwargs['networkFirewallPolicyId']
        if 'parentResourceId' in kwargs:
            parent_resource_id = kwargs['parentResourceId']
        if 'portRanges' in kwargs:
            port_ranges = kwargs['portRanges']

        _setter("name", name)
        _setter("network_firewall_policy_id", network_firewall_policy_id)
        _setter("parent_resource_id", parent_resource_id)
        _setter("port_ranges", port_ranges)
        _setter("type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> str:
        """
        OCID of the Network Firewall Policy this service belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> Sequence['outputs.GetNetworkFirewallPolicyServicesServiceSummaryCollectionItemPortRangeResult']:
        """
        List of port-ranges used.
        """
        return pulumi.get(self, "port_ranges")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Describes the type of Service.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkFirewallPolicyServicesServiceSummaryCollectionItemPortRangeResult(dict):
    def __init__(__self__, *,
                 maximum_port: int,
                 minimum_port: int):
        """
        :param int maximum_port: The maximum port in the range (inclusive), which may be absent for a single-port range.
        :param int minimum_port: The minimum port in the range (inclusive), or the sole port of a single-port range.
        """
        GetNetworkFirewallPolicyServicesServiceSummaryCollectionItemPortRangeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            maximum_port=maximum_port,
            minimum_port=minimum_port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             maximum_port: int,
             minimum_port: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'maximumPort' in kwargs:
            maximum_port = kwargs['maximumPort']
        if 'minimumPort' in kwargs:
            minimum_port = kwargs['minimumPort']

        _setter("maximum_port", maximum_port)
        _setter("minimum_port", minimum_port)

    @property
    @pulumi.getter(name="maximumPort")
    def maximum_port(self) -> int:
        """
        The maximum port in the range (inclusive), which may be absent for a single-port range.
        """
        return pulumi.get(self, "maximum_port")

    @property
    @pulumi.getter(name="minimumPort")
    def minimum_port(self) -> int:
        """
        The minimum port in the range (inclusive), or the sole port of a single-port range.
        """
        return pulumi.get(self, "minimum_port")


@pulumi.output_type
class GetNetworkFirewallPolicyUrlListUrlResult(dict):
    def __init__(__self__, *,
                 pattern: str,
                 type: str):
        """
        :param str pattern: A string consisting of a concatenation of optional host component and optional path component. The host component may start with `*.` to match the case-insensitive domain and all its subdomains. The path component must start with a `/`, and may end with `*` to match all paths of which it is a case-sensitive prefix. A missing host component matches all request domains, and a missing path component matches all request paths. An empty value matches all requests.
        :param str type: The type of pattern.
               * SIMPLE - A simple pattern with optional subdomain and/or path suffix wildcards.
        """
        GetNetworkFirewallPolicyUrlListUrlResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            pattern=pattern,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             pattern: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("pattern", pattern)
        _setter("type", type)

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        A string consisting of a concatenation of optional host component and optional path component. The host component may start with `*.` to match the case-insensitive domain and all its subdomains. The path component must start with a `/`, and may end with `*` to match all paths of which it is a case-sensitive prefix. A missing host component matches all request domains, and a missing path component matches all request paths. An empty value matches all requests.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of pattern.
        * SIMPLE - A simple pattern with optional subdomain and/or path suffix wildcards.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkFirewallPolicyUrlListsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Unique name identifier for the URL list.
        """
        GetNetworkFirewallPolicyUrlListsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name identifier for the URL list.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionItemResult']):
        GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 name: str,
                 network_firewall_policy_id: str,
                 parent_resource_id: str,
                 total_urls: int,
                 urls: Sequence['outputs.GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionItemUrlResult']):
        """
        :param str name: Unique name identifier for the URL list.
        :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param str parent_resource_id: OCID of the Network Firewall Policy this URL List belongs to.
        :param int total_urls: Total count of URLs in the URL List
        :param Sequence['GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionItemUrlArgs'] urls: List of urls.
        """
        GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            network_firewall_policy_id=network_firewall_policy_id,
            parent_resource_id=parent_resource_id,
            total_urls=total_urls,
            urls=urls,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             network_firewall_policy_id: str,
             parent_resource_id: str,
             total_urls: int,
             urls: Sequence['outputs.GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionItemUrlResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'networkFirewallPolicyId' in kwargs:
            network_firewall_policy_id = kwargs['networkFirewallPolicyId']
        if 'parentResourceId' in kwargs:
            parent_resource_id = kwargs['parentResourceId']
        if 'totalUrls' in kwargs:
            total_urls = kwargs['totalUrls']

        _setter("name", name)
        _setter("network_firewall_policy_id", network_firewall_policy_id)
        _setter("parent_resource_id", parent_resource_id)
        _setter("total_urls", total_urls)
        _setter("urls", urls)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name identifier for the URL list.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> str:
        """
        OCID of the Network Firewall Policy this URL List belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter(name="totalUrls")
    def total_urls(self) -> int:
        """
        Total count of URLs in the URL List
        """
        return pulumi.get(self, "total_urls")

    @property
    @pulumi.getter
    def urls(self) -> Sequence['outputs.GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionItemUrlResult']:
        """
        List of urls.
        """
        return pulumi.get(self, "urls")


@pulumi.output_type
class GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionItemUrlResult(dict):
    def __init__(__self__, *,
                 pattern: str,
                 type: str):
        """
        :param str pattern: A string consisting of a concatenation of optional host component and optional path component. The host component may start with `*.` to match the case-insensitive domain and all its subdomains. The path component must start with a `/`, and may end with `*` to match all paths of which it is a case-sensitive prefix. A missing host component matches all request domains, and a missing path component matches all request paths. An empty value matches all requests.
        :param str type: The type of pattern.
               * SIMPLE - A simple pattern with optional subdomain and/or path suffix wildcards.
        """
        GetNetworkFirewallPolicyUrlListsUrlListSummaryCollectionItemUrlResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            pattern=pattern,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             pattern: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("pattern", pattern)
        _setter("type", type)

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        A string consisting of a concatenation of optional host component and optional path component. The host component may start with `*.` to match the case-insensitive domain and all its subdomains. The path component must start with a `/`, and may end with `*` to match all paths of which it is a case-sensitive prefix. A missing host component matches all request domains, and a missing path component matches all request paths. An empty value matches all requests.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of pattern.
        * SIMPLE - A simple pattern with optional subdomain and/or path suffix wildcards.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkFirewallsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetNetworkFirewallsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkFirewallsNetworkFirewallCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetNetworkFirewallsNetworkFirewallCollectionItemResult']):
        GetNetworkFirewallsNetworkFirewallCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetNetworkFirewallsNetworkFirewallCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworkFirewallsNetworkFirewallCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkFirewallsNetworkFirewallCollectionItemResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 ipv4address: str,
                 ipv6address: str,
                 lifecycle_details: str,
                 network_firewall_policy_id: str,
                 network_security_group_ids: Sequence[str],
                 state: str,
                 subnet_id: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param str availability_domain: A filter to return only resources that are present within the specified availability domain. To get a list of availability domains for a tenancy, use [ListAvailabilityDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/AvailabilityDomain/ListAvailabilityDomains) operation. Example: `kIdk:PHX-AD-1`
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Network Firewall resource.
        :param str ipv4address: IPv4 address for the Network Firewall.
        :param str ipv6address: IPv6 address for the Network Firewall.
        :param str lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in 'FAILED' state.
        :param str network_firewall_policy_id: A filter to return only resources that match the entire networkFirewallPolicyId given.
        :param Sequence[str] network_security_group_ids: An array of network security groups [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the Network Firewall.
        :param str state: A filter to return only resources with a lifecycleState matching the given value.
        :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the Network Firewall.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time at which the Network Firewall was created in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param str time_updated: The time at which the Network Firewall was updated in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        GetNetworkFirewallsNetworkFirewallCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            ipv4address=ipv4address,
            ipv6address=ipv6address,
            lifecycle_details=lifecycle_details,
            network_firewall_policy_id=network_firewall_policy_id,
            network_security_group_ids=network_security_group_ids,
            state=state,
            subnet_id=subnet_id,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: str,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             ipv4address: str,
             ipv6address: str,
             lifecycle_details: str,
             network_firewall_policy_id: str,
             network_security_group_ids: Sequence[str],
             state: str,
             subnet_id: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'availabilityDomain' in kwargs:
            availability_domain = kwargs['availabilityDomain']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'networkFirewallPolicyId' in kwargs:
            network_firewall_policy_id = kwargs['networkFirewallPolicyId']
        if 'networkSecurityGroupIds' in kwargs:
            network_security_group_ids = kwargs['networkSecurityGroupIds']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("availability_domain", availability_domain)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("ipv4address", ipv4address)
        _setter("ipv6address", ipv6address)
        _setter("lifecycle_details", lifecycle_details)
        _setter("network_firewall_policy_id", network_firewall_policy_id)
        _setter("network_security_group_ids", network_security_group_ids)
        _setter("state", state)
        _setter("subnet_id", subnet_id)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        A filter to return only resources that are present within the specified availability domain. To get a list of availability domains for a tenancy, use [ListAvailabilityDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/AvailabilityDomain/ListAvailabilityDomains) operation. Example: `kIdk:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Network Firewall resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ipv4address(self) -> str:
        """
        IPv4 address for the Network Firewall.
        """
        return pulumi.get(self, "ipv4address")

    @property
    @pulumi.getter
    def ipv6address(self) -> str:
        """
        IPv6 address for the Network Firewall.
        """
        return pulumi.get(self, "ipv6address")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in 'FAILED' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        """
        A filter to return only resources that match the entire networkFirewallPolicyId given.
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Sequence[str]:
        """
        An array of network security groups [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the Network Firewall.
        """
        return pulumi.get(self, "network_security_group_ids")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources with a lifecycleState matching the given value.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the Network Firewall.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time at which the Network Firewall was created in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time at which the Network Firewall was updated in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


