# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BucketRetentionRule',
    'BucketRetentionRuleDuration',
    'ObjectLifecyclePolicyRule',
    'ObjectLifecyclePolicyRuleObjectNameFilter',
    'StorageObjectSourceUriDetails',
    'GetBucketRetentionRuleResult',
    'GetBucketRetentionRuleDurationResult',
    'GetBucketSummariesBucketSummaryResult',
    'GetBucketSummariesBucketSummaryRetentionRuleResult',
    'GetBucketSummariesBucketSummaryRetentionRuleDurationResult',
    'GetBucketSummariesFilterResult',
    'GetObjectLifecyclePolicyRuleResult',
    'GetObjectLifecyclePolicyRuleObjectNameFilterResult',
    'GetObjectVersionsFilterResult',
    'GetObjectVersionsItemResult',
    'GetObjectsFilterResult',
    'GetObjectsObjectResult',
    'GetPreauthrequestsFilterResult',
    'GetPreauthrequestsPreauthenticatedRequestResult',
    'GetReplicationPoliciesFilterResult',
    'GetReplicationPoliciesReplicationPolicyResult',
    'GetReplicationSourcesFilterResult',
    'GetReplicationSourcesReplicationSourceResult',
]

@pulumi.output_type
class BucketRetentionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "retentionRuleId":
            suggest = "retention_rule_id"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeModified":
            suggest = "time_modified"
        elif key == "timeRuleLocked":
            suggest = "time_rule_locked"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRetentionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRetentionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRetentionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 duration: Optional['outputs.BucketRetentionRuleDuration'] = None,
                 retention_rule_id: Optional[str] = None,
                 time_created: Optional[str] = None,
                 time_modified: Optional[str] = None,
                 time_rule_locked: Optional[str] = None):
        """
        :param str display_name: A user-specified name for the retention rule. Names can be helpful in identifying retention rules. The name should be unique. This attribute is a forcenew attribute
        :param 'BucketRetentionRuleDurationArgs' duration: (Updatable)
        :param str retention_rule_id: Unique identifier for the retention rule.
        :param str time_created: The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        :param str time_modified: The date and time that the retention rule was modified as per [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param str time_rule_locked: (Updatable) The date and time as per [RFC 3339](https://tools.ietf.org/html/rfc3339) after which this rule is locked and can only be deleted by deleting the bucket. Once a rule is locked, only increases in the duration are allowed and no other properties can be changed. This property cannot be updated for rules that are in a locked state. Specifying it when a duration is not specified is considered an error.
        """
        BucketRetentionRule._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            duration=duration,
            retention_rule_id=retention_rule_id,
            time_created=time_created,
            time_modified=time_modified,
            time_rule_locked=time_rule_locked,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: str,
             duration: Optional['outputs.BucketRetentionRuleDuration'] = None,
             retention_rule_id: Optional[str] = None,
             time_created: Optional[str] = None,
             time_modified: Optional[str] = None,
             time_rule_locked: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'retentionRuleId' in kwargs:
            retention_rule_id = kwargs['retentionRuleId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeModified' in kwargs:
            time_modified = kwargs['timeModified']
        if 'timeRuleLocked' in kwargs:
            time_rule_locked = kwargs['timeRuleLocked']

        _setter("display_name", display_name)
        if duration is not None:
            _setter("duration", duration)
        if retention_rule_id is not None:
            _setter("retention_rule_id", retention_rule_id)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_modified is not None:
            _setter("time_modified", time_modified)
        if time_rule_locked is not None:
            _setter("time_rule_locked", time_rule_locked)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-specified name for the retention rule. Names can be helpful in identifying retention rules. The name should be unique. This attribute is a forcenew attribute
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def duration(self) -> Optional['outputs.BucketRetentionRuleDuration']:
        """
        (Updatable)
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="retentionRuleId")
    def retention_rule_id(self) -> Optional[str]:
        """
        Unique identifier for the retention rule.
        """
        return pulumi.get(self, "retention_rule_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[str]:
        """
        The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> Optional[str]:
        """
        The date and time that the retention rule was modified as per [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_modified")

    @property
    @pulumi.getter(name="timeRuleLocked")
    def time_rule_locked(self) -> Optional[str]:
        """
        (Updatable) The date and time as per [RFC 3339](https://tools.ietf.org/html/rfc3339) after which this rule is locked and can only be deleted by deleting the bucket. Once a rule is locked, only increases in the duration are allowed and no other properties can be changed. This property cannot be updated for rules that are in a locked state. Specifying it when a duration is not specified is considered an error.
        """
        return pulumi.get(self, "time_rule_locked")


@pulumi.output_type
class BucketRetentionRuleDuration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeAmount":
            suggest = "time_amount"
        elif key == "timeUnit":
            suggest = "time_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRetentionRuleDuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRetentionRuleDuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRetentionRuleDuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_amount: str,
                 time_unit: str):
        """
        :param str time_amount: (Updatable) The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified timestamp.
        :param str time_unit: (Updatable) The unit that should be used to interpret timeAmount.
        """
        BucketRetentionRuleDuration._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            time_amount=time_amount,
            time_unit=time_unit,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             time_amount: str,
             time_unit: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'timeAmount' in kwargs:
            time_amount = kwargs['timeAmount']
        if 'timeUnit' in kwargs:
            time_unit = kwargs['timeUnit']

        _setter("time_amount", time_amount)
        _setter("time_unit", time_unit)

    @property
    @pulumi.getter(name="timeAmount")
    def time_amount(self) -> str:
        """
        (Updatable) The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified timestamp.
        """
        return pulumi.get(self, "time_amount")

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> str:
        """
        (Updatable) The unit that should be used to interpret timeAmount.
        """
        return pulumi.get(self, "time_unit")


@pulumi.output_type
class ObjectLifecyclePolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "timeAmount":
            suggest = "time_amount"
        elif key == "timeUnit":
            suggest = "time_unit"
        elif key == "objectNameFilter":
            suggest = "object_name_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectLifecyclePolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectLifecyclePolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectLifecyclePolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 is_enabled: bool,
                 name: str,
                 time_amount: str,
                 time_unit: str,
                 object_name_filter: Optional['outputs.ObjectLifecyclePolicyRuleObjectNameFilter'] = None,
                 target: Optional[str] = None):
        """
        :param str action: (Updatable) The action of the object lifecycle policy rule. Rules using the action 'ARCHIVE' move objects from Standard and InfrequentAccess storage tiers into the [Archive storage tier](https://docs.cloud.oracle.com/iaas/Content/Archive/Concepts/archivestorageoverview.htm). Rules using the action 'INFREQUENT_ACCESS' move objects from Standard storage tier into the Infrequent Access Storage tier. Objects that are already in InfrequentAccess tier or in Archive tier are left untouched. Rules using the action 'DELETE' permanently delete objects from buckets. Rules using 'ABORT' abort the uncommitted multipart-uploads and permanently delete their parts from buckets.
        :param bool is_enabled: (Updatable) A Boolean that determines whether this rule is currently enabled.
        :param str name: (Updatable) The name of the lifecycle rule to be applied.
        :param str time_amount: (Updatable) Specifies the age of objects to apply the rule to. The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified time.
        :param str time_unit: (Updatable) The unit that should be used to interpret timeAmount.  Days are defined as starting and ending at midnight UTC. Years are defined as 365.2425 days long and likewise round up to the next midnight UTC. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param 'ObjectLifecyclePolicyRuleObjectNameFilterArgs' object_name_filter: (Updatable) A filter that compares object names to a set of prefixes or patterns to determine if a rule applies to a given object. The filter can contain include glob patterns, exclude glob patterns and inclusion prefixes. The inclusion prefixes property is kept for backward compatibility. It is recommended to use inclusion patterns instead of prefixes. Exclusions take precedence over inclusions.
        :param str target: (Updatable) The target of the object lifecycle policy rule. The values of target can be either "objects", "multipart-uploads" or "previous-object-versions". This field when declared as "objects" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for objects. This field when declared as "previous-object-versions" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for previous versions of existing objects. This field when declared as "multipart-uploads" is used to specify the ABORT (only) rule for uncommitted multipart-uploads.
        """
        ObjectLifecyclePolicyRule._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            is_enabled=is_enabled,
            name=name,
            time_amount=time_amount,
            time_unit=time_unit,
            object_name_filter=object_name_filter,
            target=target,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: str,
             is_enabled: bool,
             name: str,
             time_amount: str,
             time_unit: str,
             object_name_filter: Optional['outputs.ObjectLifecyclePolicyRuleObjectNameFilter'] = None,
             target: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isEnabled' in kwargs:
            is_enabled = kwargs['isEnabled']
        if 'timeAmount' in kwargs:
            time_amount = kwargs['timeAmount']
        if 'timeUnit' in kwargs:
            time_unit = kwargs['timeUnit']
        if 'objectNameFilter' in kwargs:
            object_name_filter = kwargs['objectNameFilter']

        _setter("action", action)
        _setter("is_enabled", is_enabled)
        _setter("name", name)
        _setter("time_amount", time_amount)
        _setter("time_unit", time_unit)
        if object_name_filter is not None:
            _setter("object_name_filter", object_name_filter)
        if target is not None:
            _setter("target", target)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        (Updatable) The action of the object lifecycle policy rule. Rules using the action 'ARCHIVE' move objects from Standard and InfrequentAccess storage tiers into the [Archive storage tier](https://docs.cloud.oracle.com/iaas/Content/Archive/Concepts/archivestorageoverview.htm). Rules using the action 'INFREQUENT_ACCESS' move objects from Standard storage tier into the Infrequent Access Storage tier. Objects that are already in InfrequentAccess tier or in Archive tier are left untouched. Rules using the action 'DELETE' permanently delete objects from buckets. Rules using 'ABORT' abort the uncommitted multipart-uploads and permanently delete their parts from buckets.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        (Updatable) A Boolean that determines whether this rule is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Updatable) The name of the lifecycle rule to be applied.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="timeAmount")
    def time_amount(self) -> str:
        """
        (Updatable) Specifies the age of objects to apply the rule to. The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified time.
        """
        return pulumi.get(self, "time_amount")

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> str:
        """
        (Updatable) The unit that should be used to interpret timeAmount.  Days are defined as starting and ending at midnight UTC. Years are defined as 365.2425 days long and likewise round up to the next midnight UTC. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_unit")

    @property
    @pulumi.getter(name="objectNameFilter")
    def object_name_filter(self) -> Optional['outputs.ObjectLifecyclePolicyRuleObjectNameFilter']:
        """
        (Updatable) A filter that compares object names to a set of prefixes or patterns to determine if a rule applies to a given object. The filter can contain include glob patterns, exclude glob patterns and inclusion prefixes. The inclusion prefixes property is kept for backward compatibility. It is recommended to use inclusion patterns instead of prefixes. Exclusions take precedence over inclusions.
        """
        return pulumi.get(self, "object_name_filter")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        (Updatable) The target of the object lifecycle policy rule. The values of target can be either "objects", "multipart-uploads" or "previous-object-versions". This field when declared as "objects" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for objects. This field when declared as "previous-object-versions" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for previous versions of existing objects. This field when declared as "multipart-uploads" is used to specify the ABORT (only) rule for uncommitted multipart-uploads.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ObjectLifecyclePolicyRuleObjectNameFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusionPatterns":
            suggest = "exclusion_patterns"
        elif key == "inclusionPatterns":
            suggest = "inclusion_patterns"
        elif key == "inclusionPrefixes":
            suggest = "inclusion_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectLifecyclePolicyRuleObjectNameFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectLifecyclePolicyRuleObjectNameFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectLifecyclePolicyRuleObjectNameFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclusion_patterns: Optional[Sequence[str]] = None,
                 inclusion_patterns: Optional[Sequence[str]] = None,
                 inclusion_prefixes: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] exclusion_patterns: (Updatable) An array of glob patterns to match the object names to exclude. An empty array is ignored. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.
               
               The special pattern characters have the following meanings:
               
               \\           Escapes the following character
               *           Matches any string of characters. ?           Matches any single character . [...]       Matches a group of characters. A group of characters can be: A set of characters, for example: [Zafg9@]. This matches any character in the brackets. A range of characters, for example: [a-z]. This matches any character in the range. [a-f] is equivalent to [abcdef]. For character ranges only the CHARACTER-CHARACTER pattern is supported. [ab-yz] is not valid [a-mn-z] is not valid Character ranges can not start with ^ or : To include a '-' in the range, make it the first or last character.
        :param Sequence[str] inclusion_patterns: (Updatable) An array of glob patterns to match the object names to include. An empty array includes all objects in the bucket. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.
               
               The special pattern characters have the following meanings:
               
               \\           Escapes the following character
               *           Matches any string of characters. ?           Matches any single character . [...]       Matches a group of characters. A group of characters can be: A set of characters, for example: [Zafg9@]. This matches any character in the brackets. A range of characters, for example: [a-z]. This matches any character in the range. [a-f] is equivalent to [abcdef]. For character ranges only the CHARACTER-CHARACTER pattern is supported. [ab-yz] is not valid [a-mn-z] is not valid Character ranges can not start with ^ or : To include a '-' in the range, make it the first or last character.
        :param Sequence[str] inclusion_prefixes: (Updatable) An array of object name prefixes that the rule will apply to. An empty array means to include all objects.
        """
        ObjectLifecyclePolicyRuleObjectNameFilter._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            exclusion_patterns=exclusion_patterns,
            inclusion_patterns=inclusion_patterns,
            inclusion_prefixes=inclusion_prefixes,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             exclusion_patterns: Optional[Sequence[str]] = None,
             inclusion_patterns: Optional[Sequence[str]] = None,
             inclusion_prefixes: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'exclusionPatterns' in kwargs:
            exclusion_patterns = kwargs['exclusionPatterns']
        if 'inclusionPatterns' in kwargs:
            inclusion_patterns = kwargs['inclusionPatterns']
        if 'inclusionPrefixes' in kwargs:
            inclusion_prefixes = kwargs['inclusionPrefixes']

        if exclusion_patterns is not None:
            _setter("exclusion_patterns", exclusion_patterns)
        if inclusion_patterns is not None:
            _setter("inclusion_patterns", inclusion_patterns)
        if inclusion_prefixes is not None:
            _setter("inclusion_prefixes", inclusion_prefixes)

    @property
    @pulumi.getter(name="exclusionPatterns")
    def exclusion_patterns(self) -> Optional[Sequence[str]]:
        """
        (Updatable) An array of glob patterns to match the object names to exclude. An empty array is ignored. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.

        The special pattern characters have the following meanings:

        \\           Escapes the following character
        *           Matches any string of characters. ?           Matches any single character . [...]       Matches a group of characters. A group of characters can be: A set of characters, for example: [Zafg9@]. This matches any character in the brackets. A range of characters, for example: [a-z]. This matches any character in the range. [a-f] is equivalent to [abcdef]. For character ranges only the CHARACTER-CHARACTER pattern is supported. [ab-yz] is not valid [a-mn-z] is not valid Character ranges can not start with ^ or : To include a '-' in the range, make it the first or last character.
        """
        return pulumi.get(self, "exclusion_patterns")

    @property
    @pulumi.getter(name="inclusionPatterns")
    def inclusion_patterns(self) -> Optional[Sequence[str]]:
        """
        (Updatable) An array of glob patterns to match the object names to include. An empty array includes all objects in the bucket. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.

        The special pattern characters have the following meanings:

        \\           Escapes the following character
        *           Matches any string of characters. ?           Matches any single character . [...]       Matches a group of characters. A group of characters can be: A set of characters, for example: [Zafg9@]. This matches any character in the brackets. A range of characters, for example: [a-z]. This matches any character in the range. [a-f] is equivalent to [abcdef]. For character ranges only the CHARACTER-CHARACTER pattern is supported. [ab-yz] is not valid [a-mn-z] is not valid Character ranges can not start with ^ or : To include a '-' in the range, make it the first or last character.
        """
        return pulumi.get(self, "inclusion_patterns")

    @property
    @pulumi.getter(name="inclusionPrefixes")
    def inclusion_prefixes(self) -> Optional[Sequence[str]]:
        """
        (Updatable) An array of object name prefixes that the rule will apply to. An empty array means to include all objects.
        """
        return pulumi.get(self, "inclusion_prefixes")


@pulumi.output_type
class StorageObjectSourceUriDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationObjectIfMatchEtag":
            suggest = "destination_object_if_match_etag"
        elif key == "destinationObjectIfNoneMatchEtag":
            suggest = "destination_object_if_none_match_etag"
        elif key == "sourceObjectIfMatchEtag":
            suggest = "source_object_if_match_etag"
        elif key == "sourceVersionId":
            suggest = "source_version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageObjectSourceUriDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageObjectSourceUriDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageObjectSourceUriDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 object: str,
                 region: str,
                 destination_object_if_match_etag: Optional[str] = None,
                 destination_object_if_none_match_etag: Optional[str] = None,
                 source_object_if_match_etag: Optional[str] = None,
                 source_version_id: Optional[str] = None):
        """
        :param str bucket: The name of the bucket for the source object.
        :param str namespace: The top-level namespace of the source object.
        :param str object: The name of the source object.
        :param str region: The region of the source object.
        :param str destination_object_if_match_etag: The entity tag to match the target object.
        :param str destination_object_if_none_match_etag: The entity tag to not match the target object.
        :param str source_object_if_match_etag: The entity tag to match the source object.
        :param str source_version_id: The version id of the object to be restored.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        StorageObjectSourceUriDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            object=object,
            region=region,
            destination_object_if_match_etag=destination_object_if_match_etag,
            destination_object_if_none_match_etag=destination_object_if_none_match_etag,
            source_object_if_match_etag=source_object_if_match_etag,
            source_version_id=source_version_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             namespace: str,
             object: str,
             region: str,
             destination_object_if_match_etag: Optional[str] = None,
             destination_object_if_none_match_etag: Optional[str] = None,
             source_object_if_match_etag: Optional[str] = None,
             source_version_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'destinationObjectIfMatchEtag' in kwargs:
            destination_object_if_match_etag = kwargs['destinationObjectIfMatchEtag']
        if 'destinationObjectIfNoneMatchEtag' in kwargs:
            destination_object_if_none_match_etag = kwargs['destinationObjectIfNoneMatchEtag']
        if 'sourceObjectIfMatchEtag' in kwargs:
            source_object_if_match_etag = kwargs['sourceObjectIfMatchEtag']
        if 'sourceVersionId' in kwargs:
            source_version_id = kwargs['sourceVersionId']

        _setter("bucket", bucket)
        _setter("namespace", namespace)
        _setter("object", object)
        _setter("region", region)
        if destination_object_if_match_etag is not None:
            _setter("destination_object_if_match_etag", destination_object_if_match_etag)
        if destination_object_if_none_match_etag is not None:
            _setter("destination_object_if_none_match_etag", destination_object_if_none_match_etag)
        if source_object_if_match_etag is not None:
            _setter("source_object_if_match_etag", source_object_if_match_etag)
        if source_version_id is not None:
            _setter("source_version_id", source_version_id)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the bucket for the source object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The top-level namespace of the source object.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The name of the source object.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region of the source object.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="destinationObjectIfMatchEtag")
    def destination_object_if_match_etag(self) -> Optional[str]:
        """
        The entity tag to match the target object.
        """
        return pulumi.get(self, "destination_object_if_match_etag")

    @property
    @pulumi.getter(name="destinationObjectIfNoneMatchEtag")
    def destination_object_if_none_match_etag(self) -> Optional[str]:
        """
        The entity tag to not match the target object.
        """
        return pulumi.get(self, "destination_object_if_none_match_etag")

    @property
    @pulumi.getter(name="sourceObjectIfMatchEtag")
    def source_object_if_match_etag(self) -> Optional[str]:
        """
        The entity tag to match the source object.
        """
        return pulumi.get(self, "source_object_if_match_etag")

    @property
    @pulumi.getter(name="sourceVersionId")
    def source_version_id(self) -> Optional[str]:
        """
        The version id of the object to be restored.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_version_id")


@pulumi.output_type
class GetBucketRetentionRuleResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 durations: Sequence['outputs.GetBucketRetentionRuleDurationResult'],
                 retention_rule_id: str,
                 time_created: str,
                 time_modified: str,
                 time_rule_locked: str):
        """
        :param str display_name: User specified name for the retention rule.
        :param str retention_rule_id: Unique identifier for the retention rule.
        :param str time_created: The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        :param str time_modified: The date and time that the retention rule was modified as per [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param str time_rule_locked: The date and time as per [RFC 3339](https://tools.ietf.org/html/rfc3339) after which this rule becomes locked. and can only be deleted by deleting the bucket.
        """
        GetBucketRetentionRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            durations=durations,
            retention_rule_id=retention_rule_id,
            time_created=time_created,
            time_modified=time_modified,
            time_rule_locked=time_rule_locked,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: str,
             durations: Sequence['outputs.GetBucketRetentionRuleDurationResult'],
             retention_rule_id: str,
             time_created: str,
             time_modified: str,
             time_rule_locked: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'retentionRuleId' in kwargs:
            retention_rule_id = kwargs['retentionRuleId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeModified' in kwargs:
            time_modified = kwargs['timeModified']
        if 'timeRuleLocked' in kwargs:
            time_rule_locked = kwargs['timeRuleLocked']

        _setter("display_name", display_name)
        _setter("durations", durations)
        _setter("retention_rule_id", retention_rule_id)
        _setter("time_created", time_created)
        _setter("time_modified", time_modified)
        _setter("time_rule_locked", time_rule_locked)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        User specified name for the retention rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def durations(self) -> Sequence['outputs.GetBucketRetentionRuleDurationResult']:
        return pulumi.get(self, "durations")

    @property
    @pulumi.getter(name="retentionRuleId")
    def retention_rule_id(self) -> str:
        """
        Unique identifier for the retention rule.
        """
        return pulumi.get(self, "retention_rule_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> str:
        """
        The date and time that the retention rule was modified as per [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_modified")

    @property
    @pulumi.getter(name="timeRuleLocked")
    def time_rule_locked(self) -> str:
        """
        The date and time as per [RFC 3339](https://tools.ietf.org/html/rfc3339) after which this rule becomes locked. and can only be deleted by deleting the bucket.
        """
        return pulumi.get(self, "time_rule_locked")


@pulumi.output_type
class GetBucketRetentionRuleDurationResult(dict):
    def __init__(__self__, *,
                 time_amount: str,
                 time_unit: str):
        """
        :param str time_amount: The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified timestamp.
        :param str time_unit: The unit that should be used to interpret timeAmount.
        """
        GetBucketRetentionRuleDurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            time_amount=time_amount,
            time_unit=time_unit,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             time_amount: str,
             time_unit: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'timeAmount' in kwargs:
            time_amount = kwargs['timeAmount']
        if 'timeUnit' in kwargs:
            time_unit = kwargs['timeUnit']

        _setter("time_amount", time_amount)
        _setter("time_unit", time_unit)

    @property
    @pulumi.getter(name="timeAmount")
    def time_amount(self) -> str:
        """
        The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified timestamp.
        """
        return pulumi.get(self, "time_amount")

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> str:
        """
        The unit that should be used to interpret timeAmount.
        """
        return pulumi.get(self, "time_unit")


@pulumi.output_type
class GetBucketSummariesBucketSummaryResult(dict):
    def __init__(__self__, *,
                 access_type: str,
                 approximate_count: str,
                 approximate_size: str,
                 auto_tiering: str,
                 bucket_id: str,
                 compartment_id: str,
                 created_by: str,
                 defined_tags: Mapping[str, Any],
                 etag: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_read_only: bool,
                 kms_key_id: str,
                 metadata: Mapping[str, Any],
                 name: str,
                 namespace: str,
                 object_events_enabled: bool,
                 object_lifecycle_policy_etag: str,
                 replication_enabled: bool,
                 retention_rules: Sequence['outputs.GetBucketSummariesBucketSummaryRetentionRuleResult'],
                 storage_tier: str,
                 time_created: str,
                 versioning: str):
        """
        :param str access_type: The type of public access enabled on this bucket. A bucket is set to `NoPublicAccess` by default, which only allows an authenticated caller to access the bucket and its contents. When `ObjectRead` is enabled on the bucket, public access is allowed for the `GetObject`, `HeadObject`, and `ListObjects` operations. When `ObjectReadWithoutList` is enabled on the bucket, public access is allowed for the `GetObject` and `HeadObject` operations.
        :param str approximate_count: The approximate number of objects in the bucket. Count statistics are reported periodically. You will see a lag between what is displayed and the actual object count.
        :param str approximate_size: The approximate total size in bytes of all objects in the bucket. Size statistics are reported periodically. You will see a lag between what is displayed and the actual size of the bucket.
        :param str auto_tiering: The auto tiering status on the bucket. A bucket is created with auto tiering `Disabled` by default. For auto tiering `InfrequentAccess`, objects are transitioned automatically between the 'Standard' and 'InfrequentAccess' tiers based on the access pattern of the objects.
        :param str compartment_id: The ID of the compartment in which to list buckets.
        :param str created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the bucket.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str etag: The entity tag (ETag) for the bucket.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param bool is_read_only: Whether or not this bucket is read only. By default, `isReadOnly` is set to `false`. This will be set to 'true' when this bucket is configured as a destination in a replication policy.
        :param str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a master encryption key used to call the Key Management service to generate a data encryption key or to encrypt or decrypt a data encryption key.
        :param Mapping[str, Any] metadata: Arbitrary string keys and values for user-defined metadata.
        :param str name: The name of the bucket. Avoid entering confidential information. Example: my-new-bucket1
        :param str namespace: The Object Storage namespace used for the request.
        :param bool object_events_enabled: Whether or not events are emitted for object state changes in this bucket. By default, `objectEventsEnabled` is set to `false`. Set `objectEventsEnabled` to `true` to emit events for object state changes. For more information about events, see [Overview of Events](https://docs.cloud.oracle.com/iaas/Content/Events/Concepts/eventsoverview.htm).
        :param str object_lifecycle_policy_etag: The entity tag (ETag) for the live object lifecycle policy on the bucket.
        :param bool replication_enabled: Whether or not this bucket is a replication source. By default, `replicationEnabled` is set to `false`. This will be set to 'true' when you create a replication policy for the bucket.
        :param str storage_tier: The storage tier type assigned to the bucket. A bucket is set to `Standard` tier by default, which means objects uploaded or copied to the bucket will be in the standard storage tier. When the `Archive` tier type is set explicitly for a bucket, objects uploaded or copied to the bucket will be stored in archive storage. The `storageTier` property is immutable after bucket is created.
        :param str time_created: The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        :param str versioning: The versioning status on the bucket. A bucket is created with versioning `Disabled` by default. For versioning `Enabled`, objects are protected from overwrites and deletes, by maintaining their version history. When versioning is `Suspended`, the previous versions will still remain but new versions will no longer be created when overwitten or deleted.
        """
        GetBucketSummariesBucketSummaryResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_type=access_type,
            approximate_count=approximate_count,
            approximate_size=approximate_size,
            auto_tiering=auto_tiering,
            bucket_id=bucket_id,
            compartment_id=compartment_id,
            created_by=created_by,
            defined_tags=defined_tags,
            etag=etag,
            freeform_tags=freeform_tags,
            id=id,
            is_read_only=is_read_only,
            kms_key_id=kms_key_id,
            metadata=metadata,
            name=name,
            namespace=namespace,
            object_events_enabled=object_events_enabled,
            object_lifecycle_policy_etag=object_lifecycle_policy_etag,
            replication_enabled=replication_enabled,
            retention_rules=retention_rules,
            storage_tier=storage_tier,
            time_created=time_created,
            versioning=versioning,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_type: str,
             approximate_count: str,
             approximate_size: str,
             auto_tiering: str,
             bucket_id: str,
             compartment_id: str,
             created_by: str,
             defined_tags: Mapping[str, Any],
             etag: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_read_only: bool,
             kms_key_id: str,
             metadata: Mapping[str, Any],
             name: str,
             namespace: str,
             object_events_enabled: bool,
             object_lifecycle_policy_etag: str,
             replication_enabled: bool,
             retention_rules: Sequence['outputs.GetBucketSummariesBucketSummaryRetentionRuleResult'],
             storage_tier: str,
             time_created: str,
             versioning: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'accessType' in kwargs:
            access_type = kwargs['accessType']
        if 'approximateCount' in kwargs:
            approximate_count = kwargs['approximateCount']
        if 'approximateSize' in kwargs:
            approximate_size = kwargs['approximateSize']
        if 'autoTiering' in kwargs:
            auto_tiering = kwargs['autoTiering']
        if 'bucketId' in kwargs:
            bucket_id = kwargs['bucketId']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'createdBy' in kwargs:
            created_by = kwargs['createdBy']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isReadOnly' in kwargs:
            is_read_only = kwargs['isReadOnly']
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']
        if 'objectEventsEnabled' in kwargs:
            object_events_enabled = kwargs['objectEventsEnabled']
        if 'objectLifecyclePolicyEtag' in kwargs:
            object_lifecycle_policy_etag = kwargs['objectLifecyclePolicyEtag']
        if 'replicationEnabled' in kwargs:
            replication_enabled = kwargs['replicationEnabled']
        if 'retentionRules' in kwargs:
            retention_rules = kwargs['retentionRules']
        if 'storageTier' in kwargs:
            storage_tier = kwargs['storageTier']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("access_type", access_type)
        _setter("approximate_count", approximate_count)
        _setter("approximate_size", approximate_size)
        _setter("auto_tiering", auto_tiering)
        _setter("bucket_id", bucket_id)
        _setter("compartment_id", compartment_id)
        _setter("created_by", created_by)
        _setter("defined_tags", defined_tags)
        _setter("etag", etag)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_read_only", is_read_only)
        _setter("kms_key_id", kms_key_id)
        _setter("metadata", metadata)
        _setter("name", name)
        _setter("namespace", namespace)
        _setter("object_events_enabled", object_events_enabled)
        _setter("object_lifecycle_policy_etag", object_lifecycle_policy_etag)
        _setter("replication_enabled", replication_enabled)
        _setter("retention_rules", retention_rules)
        _setter("storage_tier", storage_tier)
        _setter("time_created", time_created)
        _setter("versioning", versioning)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> str:
        """
        The type of public access enabled on this bucket. A bucket is set to `NoPublicAccess` by default, which only allows an authenticated caller to access the bucket and its contents. When `ObjectRead` is enabled on the bucket, public access is allowed for the `GetObject`, `HeadObject`, and `ListObjects` operations. When `ObjectReadWithoutList` is enabled on the bucket, public access is allowed for the `GetObject` and `HeadObject` operations.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="approximateCount")
    def approximate_count(self) -> str:
        """
        The approximate number of objects in the bucket. Count statistics are reported periodically. You will see a lag between what is displayed and the actual object count.
        """
        return pulumi.get(self, "approximate_count")

    @property
    @pulumi.getter(name="approximateSize")
    def approximate_size(self) -> str:
        """
        The approximate total size in bytes of all objects in the bucket. Size statistics are reported periodically. You will see a lag between what is displayed and the actual size of the bucket.
        """
        return pulumi.get(self, "approximate_size")

    @property
    @pulumi.getter(name="autoTiering")
    def auto_tiering(self) -> str:
        """
        The auto tiering status on the bucket. A bucket is created with auto tiering `Disabled` by default. For auto tiering `InfrequentAccess`, objects are transitioned automatically between the 'Standard' and 'InfrequentAccess' tiers based on the access pattern of the objects.
        """
        return pulumi.get(self, "auto_tiering")

    @property
    @pulumi.getter(name="bucketId")
    def bucket_id(self) -> str:
        return pulumi.get(self, "bucket_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list buckets.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the bucket.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        The entity tag (ETag) for the bucket.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isReadOnly")
    def is_read_only(self) -> bool:
        """
        Whether or not this bucket is read only. By default, `isReadOnly` is set to `false`. This will be set to 'true' when this bucket is configured as a destination in a replication policy.
        """
        return pulumi.get(self, "is_read_only")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a master encryption key used to call the Key Management service to generate a data encryption key or to encrypt or decrypt a data encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, Any]:
        """
        Arbitrary string keys and values for user-defined metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the bucket. Avoid entering confidential information. Example: my-new-bucket1
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The Object Storage namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectEventsEnabled")
    def object_events_enabled(self) -> bool:
        """
        Whether or not events are emitted for object state changes in this bucket. By default, `objectEventsEnabled` is set to `false`. Set `objectEventsEnabled` to `true` to emit events for object state changes. For more information about events, see [Overview of Events](https://docs.cloud.oracle.com/iaas/Content/Events/Concepts/eventsoverview.htm).
        """
        return pulumi.get(self, "object_events_enabled")

    @property
    @pulumi.getter(name="objectLifecyclePolicyEtag")
    def object_lifecycle_policy_etag(self) -> str:
        """
        The entity tag (ETag) for the live object lifecycle policy on the bucket.
        """
        return pulumi.get(self, "object_lifecycle_policy_etag")

    @property
    @pulumi.getter(name="replicationEnabled")
    def replication_enabled(self) -> bool:
        """
        Whether or not this bucket is a replication source. By default, `replicationEnabled` is set to `false`. This will be set to 'true' when you create a replication policy for the bucket.
        """
        return pulumi.get(self, "replication_enabled")

    @property
    @pulumi.getter(name="retentionRules")
    def retention_rules(self) -> Sequence['outputs.GetBucketSummariesBucketSummaryRetentionRuleResult']:
        return pulumi.get(self, "retention_rules")

    @property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> str:
        """
        The storage tier type assigned to the bucket. A bucket is set to `Standard` tier by default, which means objects uploaded or copied to the bucket will be in the standard storage tier. When the `Archive` tier type is set explicitly for a bucket, objects uploaded or copied to the bucket will be stored in archive storage. The `storageTier` property is immutable after bucket is created.
        """
        return pulumi.get(self, "storage_tier")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def versioning(self) -> str:
        """
        The versioning status on the bucket. A bucket is created with versioning `Disabled` by default. For versioning `Enabled`, objects are protected from overwrites and deletes, by maintaining their version history. When versioning is `Suspended`, the previous versions will still remain but new versions will no longer be created when overwitten or deleted.
        """
        return pulumi.get(self, "versioning")


@pulumi.output_type
class GetBucketSummariesBucketSummaryRetentionRuleResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 durations: Sequence['outputs.GetBucketSummariesBucketSummaryRetentionRuleDurationResult'],
                 retention_rule_id: str,
                 time_created: str,
                 time_modified: str,
                 time_rule_locked: str):
        """
        :param str time_created: The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        """
        GetBucketSummariesBucketSummaryRetentionRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            durations=durations,
            retention_rule_id=retention_rule_id,
            time_created=time_created,
            time_modified=time_modified,
            time_rule_locked=time_rule_locked,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: str,
             durations: Sequence['outputs.GetBucketSummariesBucketSummaryRetentionRuleDurationResult'],
             retention_rule_id: str,
             time_created: str,
             time_modified: str,
             time_rule_locked: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'retentionRuleId' in kwargs:
            retention_rule_id = kwargs['retentionRuleId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeModified' in kwargs:
            time_modified = kwargs['timeModified']
        if 'timeRuleLocked' in kwargs:
            time_rule_locked = kwargs['timeRuleLocked']

        _setter("display_name", display_name)
        _setter("durations", durations)
        _setter("retention_rule_id", retention_rule_id)
        _setter("time_created", time_created)
        _setter("time_modified", time_modified)
        _setter("time_rule_locked", time_rule_locked)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def durations(self) -> Sequence['outputs.GetBucketSummariesBucketSummaryRetentionRuleDurationResult']:
        return pulumi.get(self, "durations")

    @property
    @pulumi.getter(name="retentionRuleId")
    def retention_rule_id(self) -> str:
        return pulumi.get(self, "retention_rule_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> str:
        return pulumi.get(self, "time_modified")

    @property
    @pulumi.getter(name="timeRuleLocked")
    def time_rule_locked(self) -> str:
        return pulumi.get(self, "time_rule_locked")


@pulumi.output_type
class GetBucketSummariesBucketSummaryRetentionRuleDurationResult(dict):
    def __init__(__self__, *,
                 time_amount: str,
                 time_unit: str):
        GetBucketSummariesBucketSummaryRetentionRuleDurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            time_amount=time_amount,
            time_unit=time_unit,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             time_amount: str,
             time_unit: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'timeAmount' in kwargs:
            time_amount = kwargs['timeAmount']
        if 'timeUnit' in kwargs:
            time_unit = kwargs['timeUnit']

        _setter("time_amount", time_amount)
        _setter("time_unit", time_unit)

    @property
    @pulumi.getter(name="timeAmount")
    def time_amount(self) -> str:
        return pulumi.get(self, "time_amount")

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> str:
        return pulumi.get(self, "time_unit")


@pulumi.output_type
class GetBucketSummariesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the bucket. Avoid entering confidential information. Example: my-new-bucket1
        """
        GetBucketSummariesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the bucket. Avoid entering confidential information. Example: my-new-bucket1
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetObjectLifecyclePolicyRuleResult(dict):
    def __init__(__self__, *,
                 action: str,
                 is_enabled: bool,
                 name: str,
                 object_name_filters: Sequence['outputs.GetObjectLifecyclePolicyRuleObjectNameFilterResult'],
                 target: str,
                 time_amount: str,
                 time_unit: str):
        """
        :param str action: The action of the object lifecycle policy rule. Rules using the action 'ARCHIVE' move objects from Standard and InfrequentAccess storage tiers into the [Archive storage tier](https://docs.cloud.oracle.com/iaas/Content/Archive/Concepts/archivestorageoverview.htm). Rules using the action 'INFREQUENT_ACCESS' move objects from Standard storage tier into the Infrequent Access Storage tier. Objects that are already in InfrequentAccess tier or in Archive tier are left untouched. Rules using the action 'DELETE' permanently delete objects from buckets. Rules using 'ABORT' abort the uncommitted multipart-uploads and permanently delete their parts from buckets.
        :param bool is_enabled: A Boolean that determines whether this rule is currently enabled.
        :param str name: The name of the lifecycle rule to be applied.
        :param Sequence['GetObjectLifecyclePolicyRuleObjectNameFilterArgs'] object_name_filters: A filter that compares object names to a set of prefixes or patterns to determine if a rule applies to a given object. The filter can contain include glob patterns, exclude glob patterns and inclusion prefixes. The inclusion prefixes property is kept for backward compatibility. It is recommended to use inclusion patterns instead of prefixes. Exclusions take precedence over inclusions.
        :param str target: The target of the object lifecycle policy rule. The values of target can be either "objects", "multipart-uploads" or "previous-object-versions". This field when declared as "objects" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for objects. This field when declared as "previous-object-versions" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for previous versions of existing objects. This field when declared as "multipart-uploads" is used to specify the ABORT (only) rule for uncommitted multipart-uploads.
        :param str time_amount: Specifies the age of objects to apply the rule to. The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified time.
        :param str time_unit: The unit that should be used to interpret timeAmount.  Days are defined as starting and ending at midnight UTC. Years are defined as 365.2425 days long and likewise round up to the next midnight UTC.
        """
        GetObjectLifecyclePolicyRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            is_enabled=is_enabled,
            name=name,
            object_name_filters=object_name_filters,
            target=target,
            time_amount=time_amount,
            time_unit=time_unit,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: str,
             is_enabled: bool,
             name: str,
             object_name_filters: Sequence['outputs.GetObjectLifecyclePolicyRuleObjectNameFilterResult'],
             target: str,
             time_amount: str,
             time_unit: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isEnabled' in kwargs:
            is_enabled = kwargs['isEnabled']
        if 'objectNameFilters' in kwargs:
            object_name_filters = kwargs['objectNameFilters']
        if 'timeAmount' in kwargs:
            time_amount = kwargs['timeAmount']
        if 'timeUnit' in kwargs:
            time_unit = kwargs['timeUnit']

        _setter("action", action)
        _setter("is_enabled", is_enabled)
        _setter("name", name)
        _setter("object_name_filters", object_name_filters)
        _setter("target", target)
        _setter("time_amount", time_amount)
        _setter("time_unit", time_unit)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action of the object lifecycle policy rule. Rules using the action 'ARCHIVE' move objects from Standard and InfrequentAccess storage tiers into the [Archive storage tier](https://docs.cloud.oracle.com/iaas/Content/Archive/Concepts/archivestorageoverview.htm). Rules using the action 'INFREQUENT_ACCESS' move objects from Standard storage tier into the Infrequent Access Storage tier. Objects that are already in InfrequentAccess tier or in Archive tier are left untouched. Rules using the action 'DELETE' permanently delete objects from buckets. Rules using 'ABORT' abort the uncommitted multipart-uploads and permanently delete their parts from buckets.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        A Boolean that determines whether this rule is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the lifecycle rule to be applied.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectNameFilters")
    def object_name_filters(self) -> Sequence['outputs.GetObjectLifecyclePolicyRuleObjectNameFilterResult']:
        """
        A filter that compares object names to a set of prefixes or patterns to determine if a rule applies to a given object. The filter can contain include glob patterns, exclude glob patterns and inclusion prefixes. The inclusion prefixes property is kept for backward compatibility. It is recommended to use inclusion patterns instead of prefixes. Exclusions take precedence over inclusions.
        """
        return pulumi.get(self, "object_name_filters")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        The target of the object lifecycle policy rule. The values of target can be either "objects", "multipart-uploads" or "previous-object-versions". This field when declared as "objects" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for objects. This field when declared as "previous-object-versions" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for previous versions of existing objects. This field when declared as "multipart-uploads" is used to specify the ABORT (only) rule for uncommitted multipart-uploads.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="timeAmount")
    def time_amount(self) -> str:
        """
        Specifies the age of objects to apply the rule to. The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified time.
        """
        return pulumi.get(self, "time_amount")

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> str:
        """
        The unit that should be used to interpret timeAmount.  Days are defined as starting and ending at midnight UTC. Years are defined as 365.2425 days long and likewise round up to the next midnight UTC.
        """
        return pulumi.get(self, "time_unit")


@pulumi.output_type
class GetObjectLifecyclePolicyRuleObjectNameFilterResult(dict):
    def __init__(__self__, *,
                 exclusion_patterns: Sequence[str],
                 inclusion_patterns: Sequence[str],
                 inclusion_prefixes: Sequence[str]):
        """
        :param Sequence[str] exclusion_patterns: An array of glob patterns to match the object names to exclude. An empty array is ignored. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.
        :param Sequence[str] inclusion_patterns: An array of glob patterns to match the object names to include. An empty array includes all objects in the bucket. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.
        :param Sequence[str] inclusion_prefixes: An array of object name prefixes that the rule will apply to. An empty array means to include all objects.
        """
        GetObjectLifecyclePolicyRuleObjectNameFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            exclusion_patterns=exclusion_patterns,
            inclusion_patterns=inclusion_patterns,
            inclusion_prefixes=inclusion_prefixes,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             exclusion_patterns: Sequence[str],
             inclusion_patterns: Sequence[str],
             inclusion_prefixes: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'exclusionPatterns' in kwargs:
            exclusion_patterns = kwargs['exclusionPatterns']
        if 'inclusionPatterns' in kwargs:
            inclusion_patterns = kwargs['inclusionPatterns']
        if 'inclusionPrefixes' in kwargs:
            inclusion_prefixes = kwargs['inclusionPrefixes']

        _setter("exclusion_patterns", exclusion_patterns)
        _setter("inclusion_patterns", inclusion_patterns)
        _setter("inclusion_prefixes", inclusion_prefixes)

    @property
    @pulumi.getter(name="exclusionPatterns")
    def exclusion_patterns(self) -> Sequence[str]:
        """
        An array of glob patterns to match the object names to exclude. An empty array is ignored. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.
        """
        return pulumi.get(self, "exclusion_patterns")

    @property
    @pulumi.getter(name="inclusionPatterns")
    def inclusion_patterns(self) -> Sequence[str]:
        """
        An array of glob patterns to match the object names to include. An empty array includes all objects in the bucket. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.
        """
        return pulumi.get(self, "inclusion_patterns")

    @property
    @pulumi.getter(name="inclusionPrefixes")
    def inclusion_prefixes(self) -> Sequence[str]:
        """
        An array of object name prefixes that the rule will apply to. An empty array means to include all objects.
        """
        return pulumi.get(self, "inclusion_prefixes")


@pulumi.output_type
class GetObjectVersionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the object. Avoid entering confidential information. Example: test/object1.log
        """
        GetObjectVersionsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the object. Avoid entering confidential information. Example: test/object1.log
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetObjectVersionsItemResult(dict):
    def __init__(__self__, *,
                 archival_state: str,
                 etag: str,
                 is_delete_marker: bool,
                 md5: str,
                 name: str,
                 size: str,
                 storage_tier: str,
                 time_created: str,
                 time_modified: str,
                 version_id: str):
        """
        :param str archival_state: Archival state of an object. This field is set only for objects in Archive tier.
        :param str etag: The current entity tag (ETag) for the object.
        :param bool is_delete_marker: This flag will indicate if the version is deleted or not.
        :param str md5: Base64-encoded MD5 hash of the object data.
        :param str name: The name of the object. Avoid entering confidential information. Example: test/object1.log
        :param str size: Size of the object in bytes.
        :param str storage_tier: The storage tier that the object is stored in.
        :param str time_created: The date and time the object was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        :param str time_modified: The date and time the object was modified, as described in [RFC 2616](https://tools.ietf.org/rfc/rfc2616#section-14.29).
        :param str version_id: VersionId of the object.
        """
        GetObjectVersionsItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            archival_state=archival_state,
            etag=etag,
            is_delete_marker=is_delete_marker,
            md5=md5,
            name=name,
            size=size,
            storage_tier=storage_tier,
            time_created=time_created,
            time_modified=time_modified,
            version_id=version_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             archival_state: str,
             etag: str,
             is_delete_marker: bool,
             md5: str,
             name: str,
             size: str,
             storage_tier: str,
             time_created: str,
             time_modified: str,
             version_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'archivalState' in kwargs:
            archival_state = kwargs['archivalState']
        if 'isDeleteMarker' in kwargs:
            is_delete_marker = kwargs['isDeleteMarker']
        if 'storageTier' in kwargs:
            storage_tier = kwargs['storageTier']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeModified' in kwargs:
            time_modified = kwargs['timeModified']
        if 'versionId' in kwargs:
            version_id = kwargs['versionId']

        _setter("archival_state", archival_state)
        _setter("etag", etag)
        _setter("is_delete_marker", is_delete_marker)
        _setter("md5", md5)
        _setter("name", name)
        _setter("size", size)
        _setter("storage_tier", storage_tier)
        _setter("time_created", time_created)
        _setter("time_modified", time_modified)
        _setter("version_id", version_id)

    @property
    @pulumi.getter(name="archivalState")
    def archival_state(self) -> str:
        """
        Archival state of an object. This field is set only for objects in Archive tier.
        """
        return pulumi.get(self, "archival_state")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        The current entity tag (ETag) for the object.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="isDeleteMarker")
    def is_delete_marker(self) -> bool:
        """
        This flag will indicate if the version is deleted or not.
        """
        return pulumi.get(self, "is_delete_marker")

    @property
    @pulumi.getter
    def md5(self) -> str:
        """
        Base64-encoded MD5 hash of the object data.
        """
        return pulumi.get(self, "md5")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the object. Avoid entering confidential information. Example: test/object1.log
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> str:
        """
        Size of the object in bytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> str:
        """
        The storage tier that the object is stored in.
        """
        return pulumi.get(self, "storage_tier")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the object was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> str:
        """
        The date and time the object was modified, as described in [RFC 2616](https://tools.ietf.org/rfc/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_modified")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> str:
        """
        VersionId of the object.
        """
        return pulumi.get(self, "version_id")


@pulumi.output_type
class GetObjectsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the object.
        """
        GetObjectsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the object.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetObjectsObjectResult(dict):
    def __init__(__self__, *,
                 archival_state: str,
                 etag: str,
                 md5: str,
                 name: str,
                 size: str,
                 storage_tier: str,
                 time_created: str,
                 time_modified: str):
        """
        :param str etag: The current entity tag (ETag) for the object.
        :param str md5: Base64-encoded MD5 hash of the object data.
        :param str name: The name of the object.
        :param str size: Size of the object in bytes.
        :param str storage_tier: The storage tier that the object is stored in.
               * `archival-state` - Archival state of an object. This field is set only for objects in Archive tier.
        :param str time_created: The date and time the object was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        :param str time_modified: The date and time the object was modified, as described in [RFC 2616](https://tools.ietf.org/rfc/rfc2616#section-14.29).
        """
        GetObjectsObjectResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            archival_state=archival_state,
            etag=etag,
            md5=md5,
            name=name,
            size=size,
            storage_tier=storage_tier,
            time_created=time_created,
            time_modified=time_modified,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             archival_state: str,
             etag: str,
             md5: str,
             name: str,
             size: str,
             storage_tier: str,
             time_created: str,
             time_modified: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'archivalState' in kwargs:
            archival_state = kwargs['archivalState']
        if 'storageTier' in kwargs:
            storage_tier = kwargs['storageTier']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeModified' in kwargs:
            time_modified = kwargs['timeModified']

        _setter("archival_state", archival_state)
        _setter("etag", etag)
        _setter("md5", md5)
        _setter("name", name)
        _setter("size", size)
        _setter("storage_tier", storage_tier)
        _setter("time_created", time_created)
        _setter("time_modified", time_modified)

    @property
    @pulumi.getter(name="archivalState")
    def archival_state(self) -> str:
        return pulumi.get(self, "archival_state")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        The current entity tag (ETag) for the object.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def md5(self) -> str:
        """
        Base64-encoded MD5 hash of the object data.
        """
        return pulumi.get(self, "md5")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the object.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> str:
        """
        Size of the object in bytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> str:
        """
        The storage tier that the object is stored in.
        * `archival-state` - Archival state of an object. This field is set only for objects in Archive tier.
        """
        return pulumi.get(self, "storage_tier")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the object was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> str:
        """
        The date and time the object was modified, as described in [RFC 2616](https://tools.ietf.org/rfc/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_modified")


@pulumi.output_type
class GetPreauthrequestsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The user-provided name of the pre-authenticated request.
        """
        GetPreauthrequestsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The user-provided name of the pre-authenticated request.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPreauthrequestsPreauthenticatedRequestResult(dict):
    def __init__(__self__, *,
                 access_type: str,
                 access_uri: str,
                 bucket: str,
                 bucket_listing_action: str,
                 full_path: str,
                 id: str,
                 name: str,
                 namespace: str,
                 object: str,
                 object_name: str,
                 par_id: str,
                 time_created: str,
                 time_expires: str):
        """
        :param str access_type: The operation that can be performed on this resource.
        :param str access_uri: The URI to embed in the URL when using the pre-authenticated request.
        :param str bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        :param str bucket_listing_action: Specifies whether a list operation is allowed on a PAR with accessType "AnyObjectRead" or "AnyObjectReadWrite". Deny: Prevents the user from performing a list operation. ListObjects: Authorizes the user to perform a list operation.
        :param str id: The unique identifier to use when directly addressing the pre-authenticated request.
        :param str name: The user-provided name of the pre-authenticated request.
        :param str namespace: The Object Storage namespace used for the request.
        :param str object: Deprecated. Instead use `object_name`.The name of the object that is being granted access to by the pre-authenticated request. Avoid entering confidential information. The object name can be null and if so, the pre-authenticated request grants access to the entire bucket. Example: test/object1.log
        :param str object_name: The name of the object that is being granted access to by the pre-authenticated request. Avoid entering confidential information. The object name can be null and if so, the pre-authenticated request grants access to the entire bucket. Example: test/object1.log
        :param str time_created: The date when the pre-authenticated request was created as per specification [RFC 3339](https://tools.ietf.org/html/rfc3339).
        :param str time_expires: The expiration date for the pre-authenticated request as per [RFC 3339](https://tools.ietf.org/html/rfc3339). After this date the pre-authenticated request will no longer be valid.
        """
        GetPreauthrequestsPreauthenticatedRequestResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_type=access_type,
            access_uri=access_uri,
            bucket=bucket,
            bucket_listing_action=bucket_listing_action,
            full_path=full_path,
            id=id,
            name=name,
            namespace=namespace,
            object=object,
            object_name=object_name,
            par_id=par_id,
            time_created=time_created,
            time_expires=time_expires,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_type: str,
             access_uri: str,
             bucket: str,
             bucket_listing_action: str,
             full_path: str,
             id: str,
             name: str,
             namespace: str,
             object: str,
             object_name: str,
             par_id: str,
             time_created: str,
             time_expires: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'accessType' in kwargs:
            access_type = kwargs['accessType']
        if 'accessUri' in kwargs:
            access_uri = kwargs['accessUri']
        if 'bucketListingAction' in kwargs:
            bucket_listing_action = kwargs['bucketListingAction']
        if 'fullPath' in kwargs:
            full_path = kwargs['fullPath']
        if 'objectName' in kwargs:
            object_name = kwargs['objectName']
        if 'parId' in kwargs:
            par_id = kwargs['parId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeExpires' in kwargs:
            time_expires = kwargs['timeExpires']

        _setter("access_type", access_type)
        _setter("access_uri", access_uri)
        _setter("bucket", bucket)
        _setter("bucket_listing_action", bucket_listing_action)
        _setter("full_path", full_path)
        _setter("id", id)
        _setter("name", name)
        _setter("namespace", namespace)
        _setter("object", object)
        _setter("object_name", object_name)
        _setter("par_id", par_id)
        _setter("time_created", time_created)
        _setter("time_expires", time_expires)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> str:
        """
        The operation that can be performed on this resource.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="accessUri")
    def access_uri(self) -> str:
        """
        The URI to embed in the URL when using the pre-authenticated request.
        """
        return pulumi.get(self, "access_uri")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="bucketListingAction")
    def bucket_listing_action(self) -> str:
        """
        Specifies whether a list operation is allowed on a PAR with accessType "AnyObjectRead" or "AnyObjectReadWrite". Deny: Prevents the user from performing a list operation. ListObjects: Authorizes the user to perform a list operation.
        """
        return pulumi.get(self, "bucket_listing_action")

    @property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> str:
        return pulumi.get(self, "full_path")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique identifier to use when directly addressing the pre-authenticated request.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The user-provided name of the pre-authenticated request.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The Object Storage namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Deprecated. Instead use `object_name`.The name of the object that is being granted access to by the pre-authenticated request. Avoid entering confidential information. The object name can be null and if so, the pre-authenticated request grants access to the entire bucket. Example: test/object1.log
        """
        warnings.warn("""The 'object' field has been deprecated. Please use 'object_name' instead.""", DeprecationWarning)
        pulumi.log.warn("""object is deprecated: The 'object' field has been deprecated. Please use 'object_name' instead.""")

        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="objectName")
    def object_name(self) -> str:
        """
        The name of the object that is being granted access to by the pre-authenticated request. Avoid entering confidential information. The object name can be null and if so, the pre-authenticated request grants access to the entire bucket. Example: test/object1.log
        """
        return pulumi.get(self, "object_name")

    @property
    @pulumi.getter(name="parId")
    def par_id(self) -> str:
        return pulumi.get(self, "par_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date when the pre-authenticated request was created as per specification [RFC 3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeExpires")
    def time_expires(self) -> str:
        """
        The expiration date for the pre-authenticated request as per [RFC 3339](https://tools.ietf.org/html/rfc3339). After this date the pre-authenticated request will no longer be valid.
        """
        return pulumi.get(self, "time_expires")


@pulumi.output_type
class GetReplicationPoliciesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the policy.
        """
        GetReplicationPoliciesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetReplicationPoliciesReplicationPolicyResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 delete_object_in_destination_bucket: str,
                 destination_bucket_name: str,
                 destination_region_name: str,
                 id: str,
                 name: str,
                 namespace: str,
                 status: str,
                 status_message: str,
                 time_created: str,
                 time_last_sync: str):
        """
        :param str bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        :param str destination_bucket_name: The bucket to replicate to in the destination region. Replication policy creation does not automatically create a destination bucket. Create the destination bucket before creating the policy.
        :param str destination_region_name: The destination region to replicate to, for example "us-ashburn-1".
        :param str id: The id of the replication policy.
        :param str name: The name of the policy.
        :param str namespace: The Object Storage namespace used for the request.
        :param str status: The replication status of the policy. If the status is CLIENT_ERROR, once the user fixes the issue described in the status message, the status will become ACTIVE.
        :param str status_message: A human-readable description of the status.
        :param str time_created: The date when the replication policy was created as per [RFC 3339](https://tools.ietf.org/html/rfc3339).
        :param str time_last_sync: Changes made to the source bucket before this time has been replicated.
        """
        GetReplicationPoliciesReplicationPolicyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            delete_object_in_destination_bucket=delete_object_in_destination_bucket,
            destination_bucket_name=destination_bucket_name,
            destination_region_name=destination_region_name,
            id=id,
            name=name,
            namespace=namespace,
            status=status,
            status_message=status_message,
            time_created=time_created,
            time_last_sync=time_last_sync,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             delete_object_in_destination_bucket: str,
             destination_bucket_name: str,
             destination_region_name: str,
             id: str,
             name: str,
             namespace: str,
             status: str,
             status_message: str,
             time_created: str,
             time_last_sync: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'deleteObjectInDestinationBucket' in kwargs:
            delete_object_in_destination_bucket = kwargs['deleteObjectInDestinationBucket']
        if 'destinationBucketName' in kwargs:
            destination_bucket_name = kwargs['destinationBucketName']
        if 'destinationRegionName' in kwargs:
            destination_region_name = kwargs['destinationRegionName']
        if 'statusMessage' in kwargs:
            status_message = kwargs['statusMessage']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeLastSync' in kwargs:
            time_last_sync = kwargs['timeLastSync']

        _setter("bucket", bucket)
        _setter("delete_object_in_destination_bucket", delete_object_in_destination_bucket)
        _setter("destination_bucket_name", destination_bucket_name)
        _setter("destination_region_name", destination_region_name)
        _setter("id", id)
        _setter("name", name)
        _setter("namespace", namespace)
        _setter("status", status)
        _setter("status_message", status_message)
        _setter("time_created", time_created)
        _setter("time_last_sync", time_last_sync)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="deleteObjectInDestinationBucket")
    def delete_object_in_destination_bucket(self) -> str:
        warnings.warn("""The 'delete_object_in_destination_bucket' field has been deprecated. It is no longer supported.""", DeprecationWarning)
        pulumi.log.warn("""delete_object_in_destination_bucket is deprecated: The 'delete_object_in_destination_bucket' field has been deprecated. It is no longer supported.""")

        return pulumi.get(self, "delete_object_in_destination_bucket")

    @property
    @pulumi.getter(name="destinationBucketName")
    def destination_bucket_name(self) -> str:
        """
        The bucket to replicate to in the destination region. Replication policy creation does not automatically create a destination bucket. Create the destination bucket before creating the policy.
        """
        return pulumi.get(self, "destination_bucket_name")

    @property
    @pulumi.getter(name="destinationRegionName")
    def destination_region_name(self) -> str:
        """
        The destination region to replicate to, for example "us-ashburn-1".
        """
        return pulumi.get(self, "destination_region_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the replication policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The Object Storage namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The replication status of the policy. If the status is CLIENT_ERROR, once the user fixes the issue described in the status message, the status will become ACTIVE.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        A human-readable description of the status.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date when the replication policy was created as per [RFC 3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastSync")
    def time_last_sync(self) -> str:
        """
        Changes made to the source bucket before this time has been replicated.
        """
        return pulumi.get(self, "time_last_sync")


@pulumi.output_type
class GetReplicationSourcesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetReplicationSourcesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetReplicationSourcesReplicationSourceResult(dict):
    def __init__(__self__, *,
                 policy_name: str,
                 source_bucket_name: str,
                 source_region_name: str):
        """
        :param str policy_name: The name of the policy.
        :param str source_bucket_name: The source bucket replicating data from.
        :param str source_region_name: The source region replicating data from, for example "us-ashburn-1".
        """
        GetReplicationSourcesReplicationSourceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            policy_name=policy_name,
            source_bucket_name=source_bucket_name,
            source_region_name=source_region_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             policy_name: str,
             source_bucket_name: str,
             source_region_name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'policyName' in kwargs:
            policy_name = kwargs['policyName']
        if 'sourceBucketName' in kwargs:
            source_bucket_name = kwargs['sourceBucketName']
        if 'sourceRegionName' in kwargs:
            source_region_name = kwargs['sourceRegionName']

        _setter("policy_name", policy_name)
        _setter("source_bucket_name", source_bucket_name)
        _setter("source_region_name", source_region_name)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        The name of the policy.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="sourceBucketName")
    def source_bucket_name(self) -> str:
        """
        The source bucket replicating data from.
        """
        return pulumi.get(self, "source_bucket_name")

    @property
    @pulumi.getter(name="sourceRegionName")
    def source_region_name(self) -> str:
        """
        The source region replicating data from, for example "us-ashburn-1".
        """
        return pulumi.get(self, "source_region_name")


