# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetOdaPrivateEndpointScanProxyResult',
    'AwaitableGetOdaPrivateEndpointScanProxyResult',
    'get_oda_private_endpoint_scan_proxy',
    'get_oda_private_endpoint_scan_proxy_output',
]

@pulumi.output_type
class GetOdaPrivateEndpointScanProxyResult:
    """
    A collection of values returned by getOdaPrivateEndpointScanProxy.
    """
    def __init__(__self__, id=None, oda_private_endpoint_id=None, oda_private_endpoint_scan_proxy_id=None, protocol=None, scan_listener_infos=None, scan_listener_type=None, state=None, time_created=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if oda_private_endpoint_id and not isinstance(oda_private_endpoint_id, str):
            raise TypeError("Expected argument 'oda_private_endpoint_id' to be a str")
        pulumi.set(__self__, "oda_private_endpoint_id", oda_private_endpoint_id)
        if oda_private_endpoint_scan_proxy_id and not isinstance(oda_private_endpoint_scan_proxy_id, str):
            raise TypeError("Expected argument 'oda_private_endpoint_scan_proxy_id' to be a str")
        pulumi.set(__self__, "oda_private_endpoint_scan_proxy_id", oda_private_endpoint_scan_proxy_id)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if scan_listener_infos and not isinstance(scan_listener_infos, list):
            raise TypeError("Expected argument 'scan_listener_infos' to be a list")
        pulumi.set(__self__, "scan_listener_infos", scan_listener_infos)
        if scan_listener_type and not isinstance(scan_listener_type, str):
            raise TypeError("Expected argument 'scan_listener_type' to be a str")
        pulumi.set(__self__, "scan_listener_type", scan_listener_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ODA Private Endpoint Scan Proxy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="odaPrivateEndpointId")
    def oda_private_endpoint_id(self) -> str:
        return pulumi.get(self, "oda_private_endpoint_id")

    @property
    @pulumi.getter(name="odaPrivateEndpointScanProxyId")
    def oda_private_endpoint_scan_proxy_id(self) -> str:
        return pulumi.get(self, "oda_private_endpoint_scan_proxy_id")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for communication between client, scanProxy and RAC's scan listeners
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="scanListenerInfos")
    def scan_listener_infos(self) -> Sequence['outputs.GetOdaPrivateEndpointScanProxyScanListenerInfoResult']:
        """
        The FQDN/IPs and port information of customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_infos")

    @property
    @pulumi.getter(name="scanListenerType")
    def scan_listener_type(self) -> str:
        """
        Type indicating whether Scan listener is specified by its FQDN or list of IPs
        """
        return pulumi.get(self, "scan_listener_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the ODA Private Endpoint Scan Proxy.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")


class AwaitableGetOdaPrivateEndpointScanProxyResult(GetOdaPrivateEndpointScanProxyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOdaPrivateEndpointScanProxyResult(
            id=self.id,
            oda_private_endpoint_id=self.oda_private_endpoint_id,
            oda_private_endpoint_scan_proxy_id=self.oda_private_endpoint_scan_proxy_id,
            protocol=self.protocol,
            scan_listener_infos=self.scan_listener_infos,
            scan_listener_type=self.scan_listener_type,
            state=self.state,
            time_created=self.time_created)


def get_oda_private_endpoint_scan_proxy(oda_private_endpoint_id: Optional[str] = None,
                                        oda_private_endpoint_scan_proxy_id: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOdaPrivateEndpointScanProxyResult:
    """
    This data source provides details about a specific Oda Private Endpoint Scan Proxy resource in Oracle Cloud Infrastructure Digital Assistant service.

    Gets the specified ODA Private Endpoint Scan Proxy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oda_private_endpoint_scan_proxy = oci.Oda.get_oda_private_endpoint_scan_proxy(oda_private_endpoint_id=oci_oda_oda_private_endpoint["test_oda_private_endpoint"]["id"],
        oda_private_endpoint_scan_proxy_id=oci_oda_oda_private_endpoint_scan_proxy["test_oda_private_endpoint_scan_proxy"]["id"])
    ```


    :param str oda_private_endpoint_id: Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str oda_private_endpoint_scan_proxy_id: Unique ODA Private Endpoint Scan Proxy identifier.
    """
    __args__ = dict()
    __args__['odaPrivateEndpointId'] = oda_private_endpoint_id
    __args__['odaPrivateEndpointScanProxyId'] = oda_private_endpoint_scan_proxy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Oda/getOdaPrivateEndpointScanProxy:getOdaPrivateEndpointScanProxy', __args__, opts=opts, typ=GetOdaPrivateEndpointScanProxyResult).value

    return AwaitableGetOdaPrivateEndpointScanProxyResult(
        id=pulumi.get(__ret__, 'id'),
        oda_private_endpoint_id=pulumi.get(__ret__, 'oda_private_endpoint_id'),
        oda_private_endpoint_scan_proxy_id=pulumi.get(__ret__, 'oda_private_endpoint_scan_proxy_id'),
        protocol=pulumi.get(__ret__, 'protocol'),
        scan_listener_infos=pulumi.get(__ret__, 'scan_listener_infos'),
        scan_listener_type=pulumi.get(__ret__, 'scan_listener_type'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_oda_private_endpoint_scan_proxy)
def get_oda_private_endpoint_scan_proxy_output(oda_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                                               oda_private_endpoint_scan_proxy_id: Optional[pulumi.Input[str]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOdaPrivateEndpointScanProxyResult]:
    """
    This data source provides details about a specific Oda Private Endpoint Scan Proxy resource in Oracle Cloud Infrastructure Digital Assistant service.

    Gets the specified ODA Private Endpoint Scan Proxy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oda_private_endpoint_scan_proxy = oci.Oda.get_oda_private_endpoint_scan_proxy(oda_private_endpoint_id=oci_oda_oda_private_endpoint["test_oda_private_endpoint"]["id"],
        oda_private_endpoint_scan_proxy_id=oci_oda_oda_private_endpoint_scan_proxy["test_oda_private_endpoint_scan_proxy"]["id"])
    ```


    :param str oda_private_endpoint_id: Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str oda_private_endpoint_scan_proxy_id: Unique ODA Private Endpoint Scan Proxy identifier.
    """
    ...
