# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OdaPrivateEndpointScanProxyArgs', 'OdaPrivateEndpointScanProxy']

@pulumi.input_type
class OdaPrivateEndpointScanProxyArgs:
    def __init__(__self__, *,
                 oda_private_endpoint_id: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 scan_listener_infos: pulumi.Input[Sequence[pulumi.Input['OdaPrivateEndpointScanProxyScanListenerInfoArgs']]],
                 scan_listener_type: pulumi.Input[str]):
        """
        The set of arguments for constructing a OdaPrivateEndpointScanProxy resource.
        :param pulumi.Input[str] oda_private_endpoint_id: Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] protocol: The protocol used for communication between client, scanProxy and RAC's scan listeners
        :param pulumi.Input[Sequence[pulumi.Input['OdaPrivateEndpointScanProxyScanListenerInfoArgs']]] scan_listener_infos: The FQDN/IPs and port information of customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param pulumi.Input[str] scan_listener_type: Type indicating whether Scan listener is specified by its FQDN or list of IPs 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        OdaPrivateEndpointScanProxyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            oda_private_endpoint_id=oda_private_endpoint_id,
            protocol=protocol,
            scan_listener_infos=scan_listener_infos,
            scan_listener_type=scan_listener_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             oda_private_endpoint_id: pulumi.Input[str],
             protocol: pulumi.Input[str],
             scan_listener_infos: pulumi.Input[Sequence[pulumi.Input['OdaPrivateEndpointScanProxyScanListenerInfoArgs']]],
             scan_listener_type: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'odaPrivateEndpointId' in kwargs:
            oda_private_endpoint_id = kwargs['odaPrivateEndpointId']
        if 'scanListenerInfos' in kwargs:
            scan_listener_infos = kwargs['scanListenerInfos']
        if 'scanListenerType' in kwargs:
            scan_listener_type = kwargs['scanListenerType']

        _setter("oda_private_endpoint_id", oda_private_endpoint_id)
        _setter("protocol", protocol)
        _setter("scan_listener_infos", scan_listener_infos)
        _setter("scan_listener_type", scan_listener_type)

    @property
    @pulumi.getter(name="odaPrivateEndpointId")
    def oda_private_endpoint_id(self) -> pulumi.Input[str]:
        """
        Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "oda_private_endpoint_id")

    @oda_private_endpoint_id.setter
    def oda_private_endpoint_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "oda_private_endpoint_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol used for communication between client, scanProxy and RAC's scan listeners
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="scanListenerInfos")
    def scan_listener_infos(self) -> pulumi.Input[Sequence[pulumi.Input['OdaPrivateEndpointScanProxyScanListenerInfoArgs']]]:
        """
        The FQDN/IPs and port information of customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_infos")

    @scan_listener_infos.setter
    def scan_listener_infos(self, value: pulumi.Input[Sequence[pulumi.Input['OdaPrivateEndpointScanProxyScanListenerInfoArgs']]]):
        pulumi.set(self, "scan_listener_infos", value)

    @property
    @pulumi.getter(name="scanListenerType")
    def scan_listener_type(self) -> pulumi.Input[str]:
        """
        Type indicating whether Scan listener is specified by its FQDN or list of IPs 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scan_listener_type")

    @scan_listener_type.setter
    def scan_listener_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "scan_listener_type", value)


@pulumi.input_type
class _OdaPrivateEndpointScanProxyState:
    def __init__(__self__, *,
                 oda_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 scan_listener_infos: Optional[pulumi.Input[Sequence[pulumi.Input['OdaPrivateEndpointScanProxyScanListenerInfoArgs']]]] = None,
                 scan_listener_type: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OdaPrivateEndpointScanProxy resources.
        :param pulumi.Input[str] oda_private_endpoint_id: Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] protocol: The protocol used for communication between client, scanProxy and RAC's scan listeners
        :param pulumi.Input[Sequence[pulumi.Input['OdaPrivateEndpointScanProxyScanListenerInfoArgs']]] scan_listener_infos: The FQDN/IPs and port information of customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param pulumi.Input[str] scan_listener_type: Type indicating whether Scan listener is specified by its FQDN or list of IPs 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the ODA Private Endpoint Scan Proxy.
        :param pulumi.Input[str] time_created: When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        _OdaPrivateEndpointScanProxyState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            oda_private_endpoint_id=oda_private_endpoint_id,
            protocol=protocol,
            scan_listener_infos=scan_listener_infos,
            scan_listener_type=scan_listener_type,
            state=state,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             oda_private_endpoint_id: Optional[pulumi.Input[str]] = None,
             protocol: Optional[pulumi.Input[str]] = None,
             scan_listener_infos: Optional[pulumi.Input[Sequence[pulumi.Input['OdaPrivateEndpointScanProxyScanListenerInfoArgs']]]] = None,
             scan_listener_type: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'odaPrivateEndpointId' in kwargs:
            oda_private_endpoint_id = kwargs['odaPrivateEndpointId']
        if 'scanListenerInfos' in kwargs:
            scan_listener_infos = kwargs['scanListenerInfos']
        if 'scanListenerType' in kwargs:
            scan_listener_type = kwargs['scanListenerType']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        if oda_private_endpoint_id is not None:
            _setter("oda_private_endpoint_id", oda_private_endpoint_id)
        if protocol is not None:
            _setter("protocol", protocol)
        if scan_listener_infos is not None:
            _setter("scan_listener_infos", scan_listener_infos)
        if scan_listener_type is not None:
            _setter("scan_listener_type", scan_listener_type)
        if state is not None:
            _setter("state", state)
        if time_created is not None:
            _setter("time_created", time_created)

    @property
    @pulumi.getter(name="odaPrivateEndpointId")
    def oda_private_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "oda_private_endpoint_id")

    @oda_private_endpoint_id.setter
    def oda_private_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oda_private_endpoint_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol used for communication between client, scanProxy and RAC's scan listeners
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="scanListenerInfos")
    def scan_listener_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OdaPrivateEndpointScanProxyScanListenerInfoArgs']]]]:
        """
        The FQDN/IPs and port information of customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_infos")

    @scan_listener_infos.setter
    def scan_listener_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OdaPrivateEndpointScanProxyScanListenerInfoArgs']]]]):
        pulumi.set(self, "scan_listener_infos", value)

    @property
    @pulumi.getter(name="scanListenerType")
    def scan_listener_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type indicating whether Scan listener is specified by its FQDN or list of IPs 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scan_listener_type")

    @scan_listener_type.setter
    def scan_listener_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scan_listener_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the ODA Private Endpoint Scan Proxy.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class OdaPrivateEndpointScanProxy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 oda_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 scan_listener_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OdaPrivateEndpointScanProxyScanListenerInfoArgs']]]]] = None,
                 scan_listener_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Oda Private Endpoint Scan Proxy resource in Oracle Cloud Infrastructure Digital Assistant service.

        Starts an asynchronous job to create an ODA Private Endpoint Scan Proxy.

        To monitor the status of the job, take the `opc-work-request-id` response
        header value and use it to call `GET /workRequests/{workRequestID}`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_oda_private_endpoint_scan_proxy = oci.oda.OdaPrivateEndpointScanProxy("testOdaPrivateEndpointScanProxy",
            oda_private_endpoint_id=oci_oda_oda_private_endpoint["test_oda_private_endpoint"]["id"],
            protocol=var["oda_private_endpoint_scan_proxy_protocol"],
            scan_listener_infos=[oci.oda.OdaPrivateEndpointScanProxyScanListenerInfoArgs(
                scan_listener_fqdn=var["oda_private_endpoint_scan_proxy_scan_listener_infos_scan_listener_fqdn"],
                scan_listener_ip=var["oda_private_endpoint_scan_proxy_scan_listener_infos_scan_listener_ip"],
                scan_listener_port=var["oda_private_endpoint_scan_proxy_scan_listener_infos_scan_listener_port"],
            )],
            scan_listener_type=var["oda_private_endpoint_scan_proxy_scan_listener_type"])
        ```

        ## Import

        OdaPrivateEndpointScanProxies can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Oda/odaPrivateEndpointScanProxy:OdaPrivateEndpointScanProxy test_oda_private_endpoint_scan_proxy "odaPrivateEndpoints/{odaPrivateEndpointId}/odaPrivateEndpointScanProxies/{odaPrivateEndpointScanProxyId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] oda_private_endpoint_id: Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] protocol: The protocol used for communication between client, scanProxy and RAC's scan listeners
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OdaPrivateEndpointScanProxyScanListenerInfoArgs']]]] scan_listener_infos: The FQDN/IPs and port information of customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param pulumi.Input[str] scan_listener_type: Type indicating whether Scan listener is specified by its FQDN or list of IPs 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OdaPrivateEndpointScanProxyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Oda Private Endpoint Scan Proxy resource in Oracle Cloud Infrastructure Digital Assistant service.

        Starts an asynchronous job to create an ODA Private Endpoint Scan Proxy.

        To monitor the status of the job, take the `opc-work-request-id` response
        header value and use it to call `GET /workRequests/{workRequestID}`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_oda_private_endpoint_scan_proxy = oci.oda.OdaPrivateEndpointScanProxy("testOdaPrivateEndpointScanProxy",
            oda_private_endpoint_id=oci_oda_oda_private_endpoint["test_oda_private_endpoint"]["id"],
            protocol=var["oda_private_endpoint_scan_proxy_protocol"],
            scan_listener_infos=[oci.oda.OdaPrivateEndpointScanProxyScanListenerInfoArgs(
                scan_listener_fqdn=var["oda_private_endpoint_scan_proxy_scan_listener_infos_scan_listener_fqdn"],
                scan_listener_ip=var["oda_private_endpoint_scan_proxy_scan_listener_infos_scan_listener_ip"],
                scan_listener_port=var["oda_private_endpoint_scan_proxy_scan_listener_infos_scan_listener_port"],
            )],
            scan_listener_type=var["oda_private_endpoint_scan_proxy_scan_listener_type"])
        ```

        ## Import

        OdaPrivateEndpointScanProxies can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Oda/odaPrivateEndpointScanProxy:OdaPrivateEndpointScanProxy test_oda_private_endpoint_scan_proxy "odaPrivateEndpoints/{odaPrivateEndpointId}/odaPrivateEndpointScanProxies/{odaPrivateEndpointScanProxyId}"
        ```

        :param str resource_name: The name of the resource.
        :param OdaPrivateEndpointScanProxyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OdaPrivateEndpointScanProxyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            OdaPrivateEndpointScanProxyArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 oda_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 scan_listener_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OdaPrivateEndpointScanProxyScanListenerInfoArgs']]]]] = None,
                 scan_listener_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OdaPrivateEndpointScanProxyArgs.__new__(OdaPrivateEndpointScanProxyArgs)

            if oda_private_endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'oda_private_endpoint_id'")
            __props__.__dict__["oda_private_endpoint_id"] = oda_private_endpoint_id
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if scan_listener_infos is None and not opts.urn:
                raise TypeError("Missing required property 'scan_listener_infos'")
            __props__.__dict__["scan_listener_infos"] = scan_listener_infos
            if scan_listener_type is None and not opts.urn:
                raise TypeError("Missing required property 'scan_listener_type'")
            __props__.__dict__["scan_listener_type"] = scan_listener_type
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(OdaPrivateEndpointScanProxy, __self__).__init__(
            'oci:Oda/odaPrivateEndpointScanProxy:OdaPrivateEndpointScanProxy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            oda_private_endpoint_id: Optional[pulumi.Input[str]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            scan_listener_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OdaPrivateEndpointScanProxyScanListenerInfoArgs']]]]] = None,
            scan_listener_type: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'OdaPrivateEndpointScanProxy':
        """
        Get an existing OdaPrivateEndpointScanProxy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] oda_private_endpoint_id: Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] protocol: The protocol used for communication between client, scanProxy and RAC's scan listeners
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OdaPrivateEndpointScanProxyScanListenerInfoArgs']]]] scan_listener_infos: The FQDN/IPs and port information of customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param pulumi.Input[str] scan_listener_type: Type indicating whether Scan listener is specified by its FQDN or list of IPs 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the ODA Private Endpoint Scan Proxy.
        :param pulumi.Input[str] time_created: When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OdaPrivateEndpointScanProxyState.__new__(_OdaPrivateEndpointScanProxyState)

        __props__.__dict__["oda_private_endpoint_id"] = oda_private_endpoint_id
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["scan_listener_infos"] = scan_listener_infos
        __props__.__dict__["scan_listener_type"] = scan_listener_type
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return OdaPrivateEndpointScanProxy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="odaPrivateEndpointId")
    def oda_private_endpoint_id(self) -> pulumi.Output[str]:
        """
        Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "oda_private_endpoint_id")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        The protocol used for communication between client, scanProxy and RAC's scan listeners
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="scanListenerInfos")
    def scan_listener_infos(self) -> pulumi.Output[Sequence['outputs.OdaPrivateEndpointScanProxyScanListenerInfo']]:
        """
        The FQDN/IPs and port information of customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_infos")

    @property
    @pulumi.getter(name="scanListenerType")
    def scan_listener_type(self) -> pulumi.Output[str]:
        """
        Type indicating whether Scan listener is specified by its FQDN or list of IPs 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scan_listener_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the ODA Private Endpoint Scan Proxy.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

