# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccessRequestHistoryItemResult',
    'GetAccessRequestsAccessRequestCollectionResult',
    'GetAccessRequestsAccessRequestCollectionItemResult',
    'GetAccessRequestsFilterResult',
    'GetActionPropertyResult',
    'GetActionsFilterResult',
    'GetActionsOperatorActionCollectionResult',
    'GetActionsOperatorActionCollectionItemResult',
    'GetActionsOperatorActionCollectionItemPropertyResult',
    'GetControlAssignmentsFilterResult',
    'GetControlAssignmentsOperatorControlAssignmentCollectionResult',
    'GetControlAssignmentsOperatorControlAssignmentCollectionItemResult',
    'GetControlsFilterResult',
    'GetControlsOperatorControlCollectionResult',
    'GetControlsOperatorControlCollectionItemResult',
]

@pulumi.output_type
class GetAccessRequestHistoryItemResult(dict):
    def __init__(__self__, *,
                 actions_lists: Sequence[str],
                 description: str,
                 duration: int,
                 is_auto_approved: bool,
                 state: str,
                 time_of_action: str,
                 user_id: str):
        """
        :param Sequence[str] actions_lists: List of operator actions for which approvals were requested by the operator.
        :param str description: Reason or description about the cause of change.
        :param int duration: Duration for approval of request or extension depending on the type of action.
        :param bool is_auto_approved: Whether the access request was automatically approved.
        :param str state: The current state of the AccessRequest.
        :param str time_of_action: Time when the respective action happened in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param str user_id: Approver who modified the access request.
        """
        GetAccessRequestHistoryItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            actions_lists=actions_lists,
            description=description,
            duration=duration,
            is_auto_approved=is_auto_approved,
            state=state,
            time_of_action=time_of_action,
            user_id=user_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             actions_lists: Sequence[str],
             description: str,
             duration: int,
             is_auto_approved: bool,
             state: str,
             time_of_action: str,
             user_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'actionsLists' in kwargs:
            actions_lists = kwargs['actionsLists']
        if 'isAutoApproved' in kwargs:
            is_auto_approved = kwargs['isAutoApproved']
        if 'timeOfAction' in kwargs:
            time_of_action = kwargs['timeOfAction']
        if 'userId' in kwargs:
            user_id = kwargs['userId']

        _setter("actions_lists", actions_lists)
        _setter("description", description)
        _setter("duration", duration)
        _setter("is_auto_approved", is_auto_approved)
        _setter("state", state)
        _setter("time_of_action", time_of_action)
        _setter("user_id", user_id)

    @property
    @pulumi.getter(name="actionsLists")
    def actions_lists(self) -> Sequence[str]:
        """
        List of operator actions for which approvals were requested by the operator.
        """
        return pulumi.get(self, "actions_lists")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Reason or description about the cause of change.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def duration(self) -> int:
        """
        Duration for approval of request or extension depending on the type of action.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="isAutoApproved")
    def is_auto_approved(self) -> bool:
        """
        Whether the access request was automatically approved.
        """
        return pulumi.get(self, "is_auto_approved")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the AccessRequest.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeOfAction")
    def time_of_action(self) -> str:
        """
        Time when the respective action happened in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_action")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        Approver who modified the access request.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetAccessRequestsAccessRequestCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetAccessRequestsAccessRequestCollectionItemResult']):
        GetAccessRequestsAccessRequestCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetAccessRequestsAccessRequestCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAccessRequestsAccessRequestCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetAccessRequestsAccessRequestCollectionItemResult(dict):
    def __init__(__self__, *,
                 access_reason_summary: str,
                 action_requests_lists: Sequence[str],
                 approver_comment: str,
                 audit_types: Sequence[str],
                 closure_comment: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 duration: int,
                 extend_duration: int,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_auto_approved: bool,
                 lifecycle_details: str,
                 opctl_additional_message: str,
                 opctl_id: str,
                 opctl_name: str,
                 operator_id: str,
                 reason: str,
                 request_id: str,
                 resource_id: str,
                 resource_name: str,
                 resource_type: str,
                 severity: str,
                 state: str,
                 sub_resource_lists: Sequence[str],
                 system_message: str,
                 time_of_creation: str,
                 time_of_modification: str,
                 time_of_user_creation: str,
                 user_id: str,
                 workflow_ids: Sequence[str]):
        """
        :param str access_reason_summary: Summary comment by the operator creating the access request.
        :param Sequence[str] action_requests_lists: List of operator actions for which approval is sought by the operator user.
        :param str approver_comment: The last recent Comment entered by the approver of the request.
        :param Sequence[str] audit_types: Specifies the type of auditing to be enabled. There are two levels of auditing: command-level and keystroke-level.  By default, auditing is enabled at the command level i.e., each command issued by the operator is audited. When keystroke-level is chosen,  in addition to command level logging, key strokes are also logged.
        :param str closure_comment: The comment entered by the operator while closing the request.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param int duration: Duration in hours for which access is sought on the target resource.
        :param int extend_duration: Duration in hours for which extension access is sought on the target resource.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        :param str id: The OCID of the access request.
        :param bool is_auto_approved: Whether the access request was automatically approved.
        :param str lifecycle_details: more in detail about the lifeCycleState.
        :param str opctl_additional_message: Additional message specific to the access request that can be specified by the approver at the time of approval.
        :param str opctl_id: The OCID of the operator control governing the target resource.
        :param str opctl_name: Name of the Operator control governing the target resource.
        :param str operator_id: A unique identifier associated with the operator who raised the request. This identifier can not be used directly to identify the operator. You need to provide this identifier if you would like Oracle to provide additional information about the operator action within Oracle tenancy.
        :param str reason: Summary reason for which the operator is requesting access on the target resource.
        :param str request_id: This is an automatic identifier generated by the system which is easier for human comprehension.
        :param str resource_id: The OCID of the target resource associated with the access request. The operator raises an access request to get approval to  access the target resource.
        :param str resource_name: A filter to return only resources that match the given ResourceName.
        :param str resource_type: A filter to return only lists of resources that match the entire given service type.
        :param str severity: Priority assigned to the access request by the operator
        :param str state: A filter to return only resources whose lifecycleState matches the given AccessRequest lifecycleState.
        :param Sequence[str] sub_resource_lists: The subresources requested for approval.
        :param str system_message: System message that will be displayed to the operator at login to the target resource.
        :param str time_of_creation: Time when the access request was created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param str time_of_modification: Time when the access request was last modified in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param str time_of_user_creation: The time when access request is scheduled to be approved in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        :param str user_id: The OCID of the user that last modified the access request.
        :param Sequence[str] workflow_ids: The OCID of the workflow associated with the access request. This is needed if you want to contact Oracle Support for a stuck access request or for an access request that encounters an internal error.
        """
        GetAccessRequestsAccessRequestCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_reason_summary=access_reason_summary,
            action_requests_lists=action_requests_lists,
            approver_comment=approver_comment,
            audit_types=audit_types,
            closure_comment=closure_comment,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            duration=duration,
            extend_duration=extend_duration,
            freeform_tags=freeform_tags,
            id=id,
            is_auto_approved=is_auto_approved,
            lifecycle_details=lifecycle_details,
            opctl_additional_message=opctl_additional_message,
            opctl_id=opctl_id,
            opctl_name=opctl_name,
            operator_id=operator_id,
            reason=reason,
            request_id=request_id,
            resource_id=resource_id,
            resource_name=resource_name,
            resource_type=resource_type,
            severity=severity,
            state=state,
            sub_resource_lists=sub_resource_lists,
            system_message=system_message,
            time_of_creation=time_of_creation,
            time_of_modification=time_of_modification,
            time_of_user_creation=time_of_user_creation,
            user_id=user_id,
            workflow_ids=workflow_ids,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_reason_summary: str,
             action_requests_lists: Sequence[str],
             approver_comment: str,
             audit_types: Sequence[str],
             closure_comment: str,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             duration: int,
             extend_duration: int,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_auto_approved: bool,
             lifecycle_details: str,
             opctl_additional_message: str,
             opctl_id: str,
             opctl_name: str,
             operator_id: str,
             reason: str,
             request_id: str,
             resource_id: str,
             resource_name: str,
             resource_type: str,
             severity: str,
             state: str,
             sub_resource_lists: Sequence[str],
             system_message: str,
             time_of_creation: str,
             time_of_modification: str,
             time_of_user_creation: str,
             user_id: str,
             workflow_ids: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'accessReasonSummary' in kwargs:
            access_reason_summary = kwargs['accessReasonSummary']
        if 'actionRequestsLists' in kwargs:
            action_requests_lists = kwargs['actionRequestsLists']
        if 'approverComment' in kwargs:
            approver_comment = kwargs['approverComment']
        if 'auditTypes' in kwargs:
            audit_types = kwargs['auditTypes']
        if 'closureComment' in kwargs:
            closure_comment = kwargs['closureComment']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'extendDuration' in kwargs:
            extend_duration = kwargs['extendDuration']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isAutoApproved' in kwargs:
            is_auto_approved = kwargs['isAutoApproved']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'opctlAdditionalMessage' in kwargs:
            opctl_additional_message = kwargs['opctlAdditionalMessage']
        if 'opctlId' in kwargs:
            opctl_id = kwargs['opctlId']
        if 'opctlName' in kwargs:
            opctl_name = kwargs['opctlName']
        if 'operatorId' in kwargs:
            operator_id = kwargs['operatorId']
        if 'requestId' in kwargs:
            request_id = kwargs['requestId']
        if 'resourceId' in kwargs:
            resource_id = kwargs['resourceId']
        if 'resourceName' in kwargs:
            resource_name = kwargs['resourceName']
        if 'resourceType' in kwargs:
            resource_type = kwargs['resourceType']
        if 'subResourceLists' in kwargs:
            sub_resource_lists = kwargs['subResourceLists']
        if 'systemMessage' in kwargs:
            system_message = kwargs['systemMessage']
        if 'timeOfCreation' in kwargs:
            time_of_creation = kwargs['timeOfCreation']
        if 'timeOfModification' in kwargs:
            time_of_modification = kwargs['timeOfModification']
        if 'timeOfUserCreation' in kwargs:
            time_of_user_creation = kwargs['timeOfUserCreation']
        if 'userId' in kwargs:
            user_id = kwargs['userId']
        if 'workflowIds' in kwargs:
            workflow_ids = kwargs['workflowIds']

        _setter("access_reason_summary", access_reason_summary)
        _setter("action_requests_lists", action_requests_lists)
        _setter("approver_comment", approver_comment)
        _setter("audit_types", audit_types)
        _setter("closure_comment", closure_comment)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("duration", duration)
        _setter("extend_duration", extend_duration)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_auto_approved", is_auto_approved)
        _setter("lifecycle_details", lifecycle_details)
        _setter("opctl_additional_message", opctl_additional_message)
        _setter("opctl_id", opctl_id)
        _setter("opctl_name", opctl_name)
        _setter("operator_id", operator_id)
        _setter("reason", reason)
        _setter("request_id", request_id)
        _setter("resource_id", resource_id)
        _setter("resource_name", resource_name)
        _setter("resource_type", resource_type)
        _setter("severity", severity)
        _setter("state", state)
        _setter("sub_resource_lists", sub_resource_lists)
        _setter("system_message", system_message)
        _setter("time_of_creation", time_of_creation)
        _setter("time_of_modification", time_of_modification)
        _setter("time_of_user_creation", time_of_user_creation)
        _setter("user_id", user_id)
        _setter("workflow_ids", workflow_ids)

    @property
    @pulumi.getter(name="accessReasonSummary")
    def access_reason_summary(self) -> str:
        """
        Summary comment by the operator creating the access request.
        """
        return pulumi.get(self, "access_reason_summary")

    @property
    @pulumi.getter(name="actionRequestsLists")
    def action_requests_lists(self) -> Sequence[str]:
        """
        List of operator actions for which approval is sought by the operator user.
        """
        return pulumi.get(self, "action_requests_lists")

    @property
    @pulumi.getter(name="approverComment")
    def approver_comment(self) -> str:
        """
        The last recent Comment entered by the approver of the request.
        """
        return pulumi.get(self, "approver_comment")

    @property
    @pulumi.getter(name="auditTypes")
    def audit_types(self) -> Sequence[str]:
        """
        Specifies the type of auditing to be enabled. There are two levels of auditing: command-level and keystroke-level.  By default, auditing is enabled at the command level i.e., each command issued by the operator is audited. When keystroke-level is chosen,  in addition to command level logging, key strokes are also logged.
        """
        return pulumi.get(self, "audit_types")

    @property
    @pulumi.getter(name="closureComment")
    def closure_comment(self) -> str:
        """
        The comment entered by the operator while closing the request.
        """
        return pulumi.get(self, "closure_comment")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def duration(self) -> int:
        """
        Duration in hours for which access is sought on the target resource.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="extendDuration")
    def extend_duration(self) -> int:
        """
        Duration in hours for which extension access is sought on the target resource.
        """
        return pulumi.get(self, "extend_duration")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the access request.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutoApproved")
    def is_auto_approved(self) -> bool:
        """
        Whether the access request was automatically approved.
        """
        return pulumi.get(self, "is_auto_approved")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        more in detail about the lifeCycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="opctlAdditionalMessage")
    def opctl_additional_message(self) -> str:
        """
        Additional message specific to the access request that can be specified by the approver at the time of approval.
        """
        return pulumi.get(self, "opctl_additional_message")

    @property
    @pulumi.getter(name="opctlId")
    def opctl_id(self) -> str:
        """
        The OCID of the operator control governing the target resource.
        """
        return pulumi.get(self, "opctl_id")

    @property
    @pulumi.getter(name="opctlName")
    def opctl_name(self) -> str:
        """
        Name of the Operator control governing the target resource.
        """
        return pulumi.get(self, "opctl_name")

    @property
    @pulumi.getter(name="operatorId")
    def operator_id(self) -> str:
        """
        A unique identifier associated with the operator who raised the request. This identifier can not be used directly to identify the operator. You need to provide this identifier if you would like Oracle to provide additional information about the operator action within Oracle tenancy.
        """
        return pulumi.get(self, "operator_id")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        Summary reason for which the operator is requesting access on the target resource.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> str:
        """
        This is an automatic identifier generated by the system which is easier for human comprehension.
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The OCID of the target resource associated with the access request. The operator raises an access request to get approval to  access the target resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        A filter to return only resources that match the given ResourceName.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        A filter to return only lists of resources that match the entire given service type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Priority assigned to the access request by the operator
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources whose lifecycleState matches the given AccessRequest lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subResourceLists")
    def sub_resource_lists(self) -> Sequence[str]:
        """
        The subresources requested for approval.
        """
        return pulumi.get(self, "sub_resource_lists")

    @property
    @pulumi.getter(name="systemMessage")
    def system_message(self) -> str:
        """
        System message that will be displayed to the operator at login to the target resource.
        """
        return pulumi.get(self, "system_message")

    @property
    @pulumi.getter(name="timeOfCreation")
    def time_of_creation(self) -> str:
        """
        Time when the access request was created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_creation")

    @property
    @pulumi.getter(name="timeOfModification")
    def time_of_modification(self) -> str:
        """
        Time when the access request was last modified in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_modification")

    @property
    @pulumi.getter(name="timeOfUserCreation")
    def time_of_user_creation(self) -> str:
        """
        The time when access request is scheduled to be approved in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_user_creation")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The OCID of the user that last modified the access request.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="workflowIds")
    def workflow_ids(self) -> Sequence[str]:
        """
        The OCID of the workflow associated with the access request. This is needed if you want to contact Oracle Support for a stuck access request or for an access request that encounters an internal error.
        """
        return pulumi.get(self, "workflow_ids")


@pulumi.output_type
class GetAccessRequestsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetAccessRequestsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetActionPropertyResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Name of the property
        :param str value: value of the property
        """
        GetActionPropertyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        value of the property
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetActionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the entire display name given.
        """
        GetActionsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetActionsOperatorActionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetActionsOperatorActionCollectionItemResult']):
        GetActionsOperatorActionCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetActionsOperatorActionCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetActionsOperatorActionCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetActionsOperatorActionCollectionItemResult(dict):
    def __init__(__self__, *,
                 component: str,
                 customer_display_name: str,
                 description: str,
                 id: str,
                 name: str,
                 properties: Sequence['outputs.GetActionsOperatorActionCollectionItemPropertyResult'],
                 resource_type: str,
                 compartment_id: Optional[str] = None,
                 state: Optional[str] = None):
        """
        :param str component: Name of the infrastructure layer associated with the operator action.
        :param str customer_display_name: Display Name of the operator action.
        :param str description: Description of the operator action in terms of associated risk profile, and characteristics of the operating system commands made available to the operator under this operator action.
        :param str id: Unique Oracle assigned identifier for the operator action.
        :param str name: A filter to return only resources that match the entire display name given.
        :param Sequence['GetActionsOperatorActionCollectionItemPropertyArgs'] properties: Fine grained properties associated with the operator control.
        :param str resource_type: A filter to return only lists of resources that match the entire given service type.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str state: A filter to return only resources whose lifecycleState matches the given OperatorAction lifecycleState.
        """
        GetActionsOperatorActionCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            component=component,
            customer_display_name=customer_display_name,
            description=description,
            id=id,
            name=name,
            properties=properties,
            resource_type=resource_type,
            compartment_id=compartment_id,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             component: str,
             customer_display_name: str,
             description: str,
             id: str,
             name: str,
             properties: Sequence['outputs.GetActionsOperatorActionCollectionItemPropertyResult'],
             resource_type: str,
             compartment_id: Optional[str] = None,
             state: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'customerDisplayName' in kwargs:
            customer_display_name = kwargs['customerDisplayName']
        if 'resourceType' in kwargs:
            resource_type = kwargs['resourceType']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']

        _setter("component", component)
        _setter("customer_display_name", customer_display_name)
        _setter("description", description)
        _setter("id", id)
        _setter("name", name)
        _setter("properties", properties)
        _setter("resource_type", resource_type)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if state is not None:
            _setter("state", state)

    @property
    @pulumi.getter
    def component(self) -> str:
        """
        Name of the infrastructure layer associated with the operator action.
        """
        return pulumi.get(self, "component")

    @property
    @pulumi.getter(name="customerDisplayName")
    def customer_display_name(self) -> str:
        """
        Display Name of the operator action.
        """
        return pulumi.get(self, "customer_display_name")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the operator action in terms of associated risk profile, and characteristics of the operating system commands made available to the operator under this operator action.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique Oracle assigned identifier for the operator action.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetActionsOperatorActionCollectionItemPropertyResult']:
        """
        Fine grained properties associated with the operator control.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        A filter to return only lists of resources that match the entire given service type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        A filter to return only resources whose lifecycleState matches the given OperatorAction lifecycleState.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetActionsOperatorActionCollectionItemPropertyResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: A filter to return only resources that match the entire display name given.
        :param str value: value of the property
        """
        GetActionsOperatorActionCollectionItemPropertyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        value of the property
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetControlAssignmentsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetControlAssignmentsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetControlAssignmentsOperatorControlAssignmentCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetControlAssignmentsOperatorControlAssignmentCollectionItemResult']):
        GetControlAssignmentsOperatorControlAssignmentCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetControlAssignmentsOperatorControlAssignmentCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetControlAssignmentsOperatorControlAssignmentCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetControlAssignmentsOperatorControlAssignmentCollectionItemResult(dict):
    def __init__(__self__, *,
                 assigner_id: str,
                 comment: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 detachment_description: str,
                 error_code: int,
                 error_message: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_auto_approve_during_maintenance: bool,
                 is_default_assignment: bool,
                 is_enforced_always: bool,
                 is_log_forwarded: bool,
                 lifecycle_details: str,
                 operator_control_id: str,
                 remote_syslog_server_address: str,
                 remote_syslog_server_ca_cert: str,
                 remote_syslog_server_port: int,
                 resource_compartment_id: str,
                 resource_id: str,
                 resource_name: str,
                 resource_type: str,
                 state: str,
                 time_assignment_from: str,
                 time_assignment_to: str,
                 time_of_assignment: str,
                 time_of_deletion: str,
                 unassigner_id: str):
        """
        :param str assigner_id: The OCID of the user who created this operator control assignment.
        :param str comment: Comment about the assignment of the operator control to this target resource.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param str detachment_description: description containing reason for releasing of OperatorControl.
        :param int error_code: The code identifying the error occurred during Assignment operation.
        :param str error_message: The message describing the error occurred during Assignment operation.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        :param str id: The OCID of the operator control assignment.
        :param bool is_auto_approve_during_maintenance: The boolean if true would autoApprove during maintenance.
        :param bool is_default_assignment: Whether the assignment is a default assignment.
        :param bool is_enforced_always: If set, then the target resource is always governed by the operator control.
        :param bool is_log_forwarded: If set indicates that the audit logs are being forwarded to the relevant remote logging server
        :param str lifecycle_details: More in detail about the lifeCycleState.
        :param str operator_control_id: The OCID of the operator control.
        :param str remote_syslog_server_address: The address of the remote syslog server where the audit logs are being forwarded to. Address in host or IP format.
        :param str remote_syslog_server_ca_cert: The CA certificate of the remote syslog server.
        :param int remote_syslog_server_port: The listening port of the remote syslog server. The port range is 0 - 65535. Only TCP supported.
        :param str resource_compartment_id: The OCID of the compartment that contains the target resource.
        :param str resource_id: The OCID of the target resource.
        :param str resource_name: A filter to return only resources that match the given ResourceName.
        :param str resource_type: A filter to return only lists of resources that match the entire given service type.
        :param str state: A filter to return only resources whose lifecycleState matches the given OperatorControlAssignment lifecycleState.
        :param str time_assignment_from: The time at which the target resource will be brought under the governance of the operator control expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: '2020-05-22T21:10:29.600Z'
        :param str time_assignment_to: The time at which the target resource will leave the governance of the operator control expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param str time_of_assignment: Time when the operator control assignment is created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param str time_of_deletion: Time on which the operator control assignment was deleted in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z'
        :param str unassigner_id: User id who released the operatorControl.
        """
        GetControlAssignmentsOperatorControlAssignmentCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            assigner_id=assigner_id,
            comment=comment,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            detachment_description=detachment_description,
            error_code=error_code,
            error_message=error_message,
            freeform_tags=freeform_tags,
            id=id,
            is_auto_approve_during_maintenance=is_auto_approve_during_maintenance,
            is_default_assignment=is_default_assignment,
            is_enforced_always=is_enforced_always,
            is_log_forwarded=is_log_forwarded,
            lifecycle_details=lifecycle_details,
            operator_control_id=operator_control_id,
            remote_syslog_server_address=remote_syslog_server_address,
            remote_syslog_server_ca_cert=remote_syslog_server_ca_cert,
            remote_syslog_server_port=remote_syslog_server_port,
            resource_compartment_id=resource_compartment_id,
            resource_id=resource_id,
            resource_name=resource_name,
            resource_type=resource_type,
            state=state,
            time_assignment_from=time_assignment_from,
            time_assignment_to=time_assignment_to,
            time_of_assignment=time_of_assignment,
            time_of_deletion=time_of_deletion,
            unassigner_id=unassigner_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             assigner_id: str,
             comment: str,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             detachment_description: str,
             error_code: int,
             error_message: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_auto_approve_during_maintenance: bool,
             is_default_assignment: bool,
             is_enforced_always: bool,
             is_log_forwarded: bool,
             lifecycle_details: str,
             operator_control_id: str,
             remote_syslog_server_address: str,
             remote_syslog_server_ca_cert: str,
             remote_syslog_server_port: int,
             resource_compartment_id: str,
             resource_id: str,
             resource_name: str,
             resource_type: str,
             state: str,
             time_assignment_from: str,
             time_assignment_to: str,
             time_of_assignment: str,
             time_of_deletion: str,
             unassigner_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'assignerId' in kwargs:
            assigner_id = kwargs['assignerId']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'detachmentDescription' in kwargs:
            detachment_description = kwargs['detachmentDescription']
        if 'errorCode' in kwargs:
            error_code = kwargs['errorCode']
        if 'errorMessage' in kwargs:
            error_message = kwargs['errorMessage']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isAutoApproveDuringMaintenance' in kwargs:
            is_auto_approve_during_maintenance = kwargs['isAutoApproveDuringMaintenance']
        if 'isDefaultAssignment' in kwargs:
            is_default_assignment = kwargs['isDefaultAssignment']
        if 'isEnforcedAlways' in kwargs:
            is_enforced_always = kwargs['isEnforcedAlways']
        if 'isLogForwarded' in kwargs:
            is_log_forwarded = kwargs['isLogForwarded']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'operatorControlId' in kwargs:
            operator_control_id = kwargs['operatorControlId']
        if 'remoteSyslogServerAddress' in kwargs:
            remote_syslog_server_address = kwargs['remoteSyslogServerAddress']
        if 'remoteSyslogServerCaCert' in kwargs:
            remote_syslog_server_ca_cert = kwargs['remoteSyslogServerCaCert']
        if 'remoteSyslogServerPort' in kwargs:
            remote_syslog_server_port = kwargs['remoteSyslogServerPort']
        if 'resourceCompartmentId' in kwargs:
            resource_compartment_id = kwargs['resourceCompartmentId']
        if 'resourceId' in kwargs:
            resource_id = kwargs['resourceId']
        if 'resourceName' in kwargs:
            resource_name = kwargs['resourceName']
        if 'resourceType' in kwargs:
            resource_type = kwargs['resourceType']
        if 'timeAssignmentFrom' in kwargs:
            time_assignment_from = kwargs['timeAssignmentFrom']
        if 'timeAssignmentTo' in kwargs:
            time_assignment_to = kwargs['timeAssignmentTo']
        if 'timeOfAssignment' in kwargs:
            time_of_assignment = kwargs['timeOfAssignment']
        if 'timeOfDeletion' in kwargs:
            time_of_deletion = kwargs['timeOfDeletion']
        if 'unassignerId' in kwargs:
            unassigner_id = kwargs['unassignerId']

        _setter("assigner_id", assigner_id)
        _setter("comment", comment)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("detachment_description", detachment_description)
        _setter("error_code", error_code)
        _setter("error_message", error_message)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_auto_approve_during_maintenance", is_auto_approve_during_maintenance)
        _setter("is_default_assignment", is_default_assignment)
        _setter("is_enforced_always", is_enforced_always)
        _setter("is_log_forwarded", is_log_forwarded)
        _setter("lifecycle_details", lifecycle_details)
        _setter("operator_control_id", operator_control_id)
        _setter("remote_syslog_server_address", remote_syslog_server_address)
        _setter("remote_syslog_server_ca_cert", remote_syslog_server_ca_cert)
        _setter("remote_syslog_server_port", remote_syslog_server_port)
        _setter("resource_compartment_id", resource_compartment_id)
        _setter("resource_id", resource_id)
        _setter("resource_name", resource_name)
        _setter("resource_type", resource_type)
        _setter("state", state)
        _setter("time_assignment_from", time_assignment_from)
        _setter("time_assignment_to", time_assignment_to)
        _setter("time_of_assignment", time_of_assignment)
        _setter("time_of_deletion", time_of_deletion)
        _setter("unassigner_id", unassigner_id)

    @property
    @pulumi.getter(name="assignerId")
    def assigner_id(self) -> str:
        """
        The OCID of the user who created this operator control assignment.
        """
        return pulumi.get(self, "assigner_id")

    @property
    @pulumi.getter
    def comment(self) -> str:
        """
        Comment about the assignment of the operator control to this target resource.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="detachmentDescription")
    def detachment_description(self) -> str:
        """
        description containing reason for releasing of OperatorControl.
        """
        return pulumi.get(self, "detachment_description")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> int:
        """
        The code identifying the error occurred during Assignment operation.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        The message describing the error occurred during Assignment operation.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the operator control assignment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutoApproveDuringMaintenance")
    def is_auto_approve_during_maintenance(self) -> bool:
        """
        The boolean if true would autoApprove during maintenance.
        """
        return pulumi.get(self, "is_auto_approve_during_maintenance")

    @property
    @pulumi.getter(name="isDefaultAssignment")
    def is_default_assignment(self) -> bool:
        """
        Whether the assignment is a default assignment.
        """
        return pulumi.get(self, "is_default_assignment")

    @property
    @pulumi.getter(name="isEnforcedAlways")
    def is_enforced_always(self) -> bool:
        """
        If set, then the target resource is always governed by the operator control.
        """
        return pulumi.get(self, "is_enforced_always")

    @property
    @pulumi.getter(name="isLogForwarded")
    def is_log_forwarded(self) -> bool:
        """
        If set indicates that the audit logs are being forwarded to the relevant remote logging server
        """
        return pulumi.get(self, "is_log_forwarded")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        More in detail about the lifeCycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="operatorControlId")
    def operator_control_id(self) -> str:
        """
        The OCID of the operator control.
        """
        return pulumi.get(self, "operator_control_id")

    @property
    @pulumi.getter(name="remoteSyslogServerAddress")
    def remote_syslog_server_address(self) -> str:
        """
        The address of the remote syslog server where the audit logs are being forwarded to. Address in host or IP format.
        """
        return pulumi.get(self, "remote_syslog_server_address")

    @property
    @pulumi.getter(name="remoteSyslogServerCaCert")
    def remote_syslog_server_ca_cert(self) -> str:
        """
        The CA certificate of the remote syslog server.
        """
        return pulumi.get(self, "remote_syslog_server_ca_cert")

    @property
    @pulumi.getter(name="remoteSyslogServerPort")
    def remote_syslog_server_port(self) -> int:
        """
        The listening port of the remote syslog server. The port range is 0 - 65535. Only TCP supported.
        """
        return pulumi.get(self, "remote_syslog_server_port")

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the target resource.
        """
        return pulumi.get(self, "resource_compartment_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The OCID of the target resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        A filter to return only resources that match the given ResourceName.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        A filter to return only lists of resources that match the entire given service type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources whose lifecycleState matches the given OperatorControlAssignment lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeAssignmentFrom")
    def time_assignment_from(self) -> str:
        """
        The time at which the target resource will be brought under the governance of the operator control expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_assignment_from")

    @property
    @pulumi.getter(name="timeAssignmentTo")
    def time_assignment_to(self) -> str:
        """
        The time at which the target resource will leave the governance of the operator control expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_assignment_to")

    @property
    @pulumi.getter(name="timeOfAssignment")
    def time_of_assignment(self) -> str:
        """
        Time when the operator control assignment is created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_assignment")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        Time on which the operator control assignment was deleted in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="unassignerId")
    def unassigner_id(self) -> str:
        """
        User id who released the operatorControl.
        """
        return pulumi.get(self, "unassigner_id")


@pulumi.output_type
class GetControlsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetControlsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetControlsOperatorControlCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetControlsOperatorControlCollectionItemResult']):
        GetControlsOperatorControlCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetControlsOperatorControlCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetControlsOperatorControlCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetControlsOperatorControlCollectionItemResult(dict):
    def __init__(__self__, *,
                 approval_required_op_action_lists: Sequence[str],
                 approver_groups_lists: Sequence[str],
                 approvers_lists: Sequence[str],
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 email_id_lists: Sequence[str],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_default_operator_control: bool,
                 is_fully_pre_approved: bool,
                 last_modified_info: str,
                 operator_control_name: str,
                 pre_approved_op_action_lists: Sequence[str],
                 resource_type: str,
                 state: str,
                 system_message: str,
                 time_of_creation: str,
                 time_of_deletion: str,
                 time_of_modification: str):
        """
        :param Sequence[str] approval_required_op_action_lists: List of operator actions that need explicit approval. Any operator action not in the pre-approved list will require explicit approval. Access requests associated with a resource governed by this operator control will be require explicit approval if the access request contains any operator action in this list.
        :param Sequence[str] approver_groups_lists: List of user groups who can approve an access request associated with a target resource under the governance of this operator control.
        :param Sequence[str] approvers_lists: List of users who can approve an access request associated with a target resource under the governance of this operator control.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param str description: Description of operator control.
        :param Sequence[str] email_id_lists: List of emailId.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        :param str id: The OCID of the operator control.
        :param bool is_default_operator_control: Whether the operator control is a default Operator Control.
        :param bool is_fully_pre_approved: Whether all the operator actions have been pre-approved. If yes, all access requests associated with a resource governed by this operator control  will be auto-approved.
        :param str last_modified_info: Description associated with the latest modification of the operator control.
        :param str operator_control_name: Name of the operator control. The name must be unique.
        :param Sequence[str] pre_approved_op_action_lists: List of pre-approved operator actions. Access requests associated with a resource governed by this operator control will be automatically approved if the access request only contain operator actions in the pre-approved list.
        :param str resource_type: A filter to return only lists of resources that match the entire given service type.
        :param str state: A filter to return only resources whose lifecycleState matches the given OperatorControl lifecycleState.
        :param str system_message: System message that would be displayed to the operator users on accessing the target resource under the governance of this operator control.
        :param str time_of_creation: Time when the operator control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param str time_of_deletion: Time when deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'. Note a deleted operator control still stays in the system, so that you can still audit operator actions associated with access requests raised on target resources governed by the deleted operator control.
        :param str time_of_modification: Time when the operator control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        GetControlsOperatorControlCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            approval_required_op_action_lists=approval_required_op_action_lists,
            approver_groups_lists=approver_groups_lists,
            approvers_lists=approvers_lists,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            email_id_lists=email_id_lists,
            freeform_tags=freeform_tags,
            id=id,
            is_default_operator_control=is_default_operator_control,
            is_fully_pre_approved=is_fully_pre_approved,
            last_modified_info=last_modified_info,
            operator_control_name=operator_control_name,
            pre_approved_op_action_lists=pre_approved_op_action_lists,
            resource_type=resource_type,
            state=state,
            system_message=system_message,
            time_of_creation=time_of_creation,
            time_of_deletion=time_of_deletion,
            time_of_modification=time_of_modification,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             approval_required_op_action_lists: Sequence[str],
             approver_groups_lists: Sequence[str],
             approvers_lists: Sequence[str],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             email_id_lists: Sequence[str],
             freeform_tags: Mapping[str, Any],
             id: str,
             is_default_operator_control: bool,
             is_fully_pre_approved: bool,
             last_modified_info: str,
             operator_control_name: str,
             pre_approved_op_action_lists: Sequence[str],
             resource_type: str,
             state: str,
             system_message: str,
             time_of_creation: str,
             time_of_deletion: str,
             time_of_modification: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'approvalRequiredOpActionLists' in kwargs:
            approval_required_op_action_lists = kwargs['approvalRequiredOpActionLists']
        if 'approverGroupsLists' in kwargs:
            approver_groups_lists = kwargs['approverGroupsLists']
        if 'approversLists' in kwargs:
            approvers_lists = kwargs['approversLists']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'emailIdLists' in kwargs:
            email_id_lists = kwargs['emailIdLists']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isDefaultOperatorControl' in kwargs:
            is_default_operator_control = kwargs['isDefaultOperatorControl']
        if 'isFullyPreApproved' in kwargs:
            is_fully_pre_approved = kwargs['isFullyPreApproved']
        if 'lastModifiedInfo' in kwargs:
            last_modified_info = kwargs['lastModifiedInfo']
        if 'operatorControlName' in kwargs:
            operator_control_name = kwargs['operatorControlName']
        if 'preApprovedOpActionLists' in kwargs:
            pre_approved_op_action_lists = kwargs['preApprovedOpActionLists']
        if 'resourceType' in kwargs:
            resource_type = kwargs['resourceType']
        if 'systemMessage' in kwargs:
            system_message = kwargs['systemMessage']
        if 'timeOfCreation' in kwargs:
            time_of_creation = kwargs['timeOfCreation']
        if 'timeOfDeletion' in kwargs:
            time_of_deletion = kwargs['timeOfDeletion']
        if 'timeOfModification' in kwargs:
            time_of_modification = kwargs['timeOfModification']

        _setter("approval_required_op_action_lists", approval_required_op_action_lists)
        _setter("approver_groups_lists", approver_groups_lists)
        _setter("approvers_lists", approvers_lists)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("email_id_lists", email_id_lists)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_default_operator_control", is_default_operator_control)
        _setter("is_fully_pre_approved", is_fully_pre_approved)
        _setter("last_modified_info", last_modified_info)
        _setter("operator_control_name", operator_control_name)
        _setter("pre_approved_op_action_lists", pre_approved_op_action_lists)
        _setter("resource_type", resource_type)
        _setter("state", state)
        _setter("system_message", system_message)
        _setter("time_of_creation", time_of_creation)
        _setter("time_of_deletion", time_of_deletion)
        _setter("time_of_modification", time_of_modification)

    @property
    @pulumi.getter(name="approvalRequiredOpActionLists")
    def approval_required_op_action_lists(self) -> Sequence[str]:
        """
        List of operator actions that need explicit approval. Any operator action not in the pre-approved list will require explicit approval. Access requests associated with a resource governed by this operator control will be require explicit approval if the access request contains any operator action in this list.
        """
        return pulumi.get(self, "approval_required_op_action_lists")

    @property
    @pulumi.getter(name="approverGroupsLists")
    def approver_groups_lists(self) -> Sequence[str]:
        """
        List of user groups who can approve an access request associated with a target resource under the governance of this operator control.
        """
        return pulumi.get(self, "approver_groups_lists")

    @property
    @pulumi.getter(name="approversLists")
    def approvers_lists(self) -> Sequence[str]:
        """
        List of users who can approve an access request associated with a target resource under the governance of this operator control.
        """
        return pulumi.get(self, "approvers_lists")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of operator control.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="emailIdLists")
    def email_id_lists(self) -> Sequence[str]:
        """
        List of emailId.
        """
        return pulumi.get(self, "email_id_lists")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the operator control.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefaultOperatorControl")
    def is_default_operator_control(self) -> bool:
        """
        Whether the operator control is a default Operator Control.
        """
        return pulumi.get(self, "is_default_operator_control")

    @property
    @pulumi.getter(name="isFullyPreApproved")
    def is_fully_pre_approved(self) -> bool:
        """
        Whether all the operator actions have been pre-approved. If yes, all access requests associated with a resource governed by this operator control  will be auto-approved.
        """
        return pulumi.get(self, "is_fully_pre_approved")

    @property
    @pulumi.getter(name="lastModifiedInfo")
    def last_modified_info(self) -> str:
        """
        Description associated with the latest modification of the operator control.
        """
        return pulumi.get(self, "last_modified_info")

    @property
    @pulumi.getter(name="operatorControlName")
    def operator_control_name(self) -> str:
        """
        Name of the operator control. The name must be unique.
        """
        return pulumi.get(self, "operator_control_name")

    @property
    @pulumi.getter(name="preApprovedOpActionLists")
    def pre_approved_op_action_lists(self) -> Sequence[str]:
        """
        List of pre-approved operator actions. Access requests associated with a resource governed by this operator control will be automatically approved if the access request only contain operator actions in the pre-approved list.
        """
        return pulumi.get(self, "pre_approved_op_action_lists")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        A filter to return only lists of resources that match the entire given service type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources whose lifecycleState matches the given OperatorControl lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemMessage")
    def system_message(self) -> str:
        """
        System message that would be displayed to the operator users on accessing the target resource under the governance of this operator control.
        """
        return pulumi.get(self, "system_message")

    @property
    @pulumi.getter(name="timeOfCreation")
    def time_of_creation(self) -> str:
        """
        Time when the operator control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_creation")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        Time when deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'. Note a deleted operator control still stays in the system, so that you can still audit operator actions associated with access requests raised on target resources governed by the deleted operator control.
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="timeOfModification")
    def time_of_modification(self) -> str:
        """
        Time when the operator control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_modification")


