# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetOperationsInsightsWarehouseResult',
    'AwaitableGetOperationsInsightsWarehouseResult',
    'get_operations_insights_warehouse',
    'get_operations_insights_warehouse_output',
]

@pulumi.output_type
class GetOperationsInsightsWarehouseResult:
    """
    A collection of values returned by getOperationsInsightsWarehouse.
    """
    def __init__(__self__, compartment_id=None, cpu_allocated=None, cpu_used=None, defined_tags=None, display_name=None, dynamic_group_id=None, freeform_tags=None, id=None, lifecycle_details=None, operations_insights_tenancy_id=None, operations_insights_warehouse_id=None, state=None, storage_allocated_in_gbs=None, storage_used_in_gbs=None, system_tags=None, time_created=None, time_last_wallet_rotated=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if cpu_allocated and not isinstance(cpu_allocated, float):
            raise TypeError("Expected argument 'cpu_allocated' to be a float")
        pulumi.set(__self__, "cpu_allocated", cpu_allocated)
        if cpu_used and not isinstance(cpu_used, float):
            raise TypeError("Expected argument 'cpu_used' to be a float")
        pulumi.set(__self__, "cpu_used", cpu_used)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dynamic_group_id and not isinstance(dynamic_group_id, str):
            raise TypeError("Expected argument 'dynamic_group_id' to be a str")
        pulumi.set(__self__, "dynamic_group_id", dynamic_group_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if operations_insights_tenancy_id and not isinstance(operations_insights_tenancy_id, str):
            raise TypeError("Expected argument 'operations_insights_tenancy_id' to be a str")
        pulumi.set(__self__, "operations_insights_tenancy_id", operations_insights_tenancy_id)
        if operations_insights_warehouse_id and not isinstance(operations_insights_warehouse_id, str):
            raise TypeError("Expected argument 'operations_insights_warehouse_id' to be a str")
        pulumi.set(__self__, "operations_insights_warehouse_id", operations_insights_warehouse_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if storage_allocated_in_gbs and not isinstance(storage_allocated_in_gbs, float):
            raise TypeError("Expected argument 'storage_allocated_in_gbs' to be a float")
        pulumi.set(__self__, "storage_allocated_in_gbs", storage_allocated_in_gbs)
        if storage_used_in_gbs and not isinstance(storage_used_in_gbs, float):
            raise TypeError("Expected argument 'storage_used_in_gbs' to be a float")
        pulumi.set(__self__, "storage_used_in_gbs", storage_used_in_gbs)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_wallet_rotated and not isinstance(time_last_wallet_rotated, str):
            raise TypeError("Expected argument 'time_last_wallet_rotated' to be a str")
        pulumi.set(__self__, "time_last_wallet_rotated", time_last_wallet_rotated)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpuAllocated")
    def cpu_allocated(self) -> float:
        """
        Number of OCPUs allocated to OPSI Warehouse ADW.
        """
        return pulumi.get(self, "cpu_allocated")

    @property
    @pulumi.getter(name="cpuUsed")
    def cpu_used(self) -> float:
        """
        Number of OCPUs used by OPSI Warehouse ADW. Can be fractional.
        """
        return pulumi.get(self, "cpu_used")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        User-friedly name of Operations Insights Warehouse that does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dynamicGroupId")
    def dynamic_group_id(self) -> str:
        """
        OCID of the dynamic group created for the warehouse
        """
        return pulumi.get(self, "dynamic_group_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        OPSI Warehouse OCID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="operationsInsightsTenancyId")
    def operations_insights_tenancy_id(self) -> str:
        """
        Tenancy Identifier of Operations Insights service
        """
        return pulumi.get(self, "operations_insights_tenancy_id")

    @property
    @pulumi.getter(name="operationsInsightsWarehouseId")
    def operations_insights_warehouse_id(self) -> str:
        return pulumi.get(self, "operations_insights_warehouse_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Possible lifecycle states
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageAllocatedInGbs")
    def storage_allocated_in_gbs(self) -> float:
        """
        Storage allocated to OPSI Warehouse ADW.
        """
        return pulumi.get(self, "storage_allocated_in_gbs")

    @property
    @pulumi.getter(name="storageUsedInGbs")
    def storage_used_in_gbs(self) -> float:
        """
        Storage by OPSI Warehouse ADW in GB.
        """
        return pulumi.get(self, "storage_used_in_gbs")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time at which the resource was first created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastWalletRotated")
    def time_last_wallet_rotated(self) -> str:
        """
        The time at which the ADW wallet was last rotated for the Operations Insights Warehouse. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_last_wallet_rotated")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetOperationsInsightsWarehouseResult(GetOperationsInsightsWarehouseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOperationsInsightsWarehouseResult(
            compartment_id=self.compartment_id,
            cpu_allocated=self.cpu_allocated,
            cpu_used=self.cpu_used,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            dynamic_group_id=self.dynamic_group_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            operations_insights_tenancy_id=self.operations_insights_tenancy_id,
            operations_insights_warehouse_id=self.operations_insights_warehouse_id,
            state=self.state,
            storage_allocated_in_gbs=self.storage_allocated_in_gbs,
            storage_used_in_gbs=self.storage_used_in_gbs,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_last_wallet_rotated=self.time_last_wallet_rotated,
            time_updated=self.time_updated)


def get_operations_insights_warehouse(operations_insights_warehouse_id: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOperationsInsightsWarehouseResult:
    """
    This data source provides details about a specific Operations Insights Warehouse resource in Oracle Cloud Infrastructure Opsi service.

    Gets details of an Operations Insights Warehouse.
    There is only expected to be 1 warehouse per tenant. The warehouse is expected to be in the root compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_operations_insights_warehouse = oci.Opsi.get_operations_insights_warehouse(operations_insights_warehouse_id=oci_opsi_operations_insights_warehouse["test_operations_insights_warehouse"]["id"])
    ```


    :param str operations_insights_warehouse_id: Unique Operations Insights Warehouse identifier
    """
    __args__ = dict()
    __args__['operationsInsightsWarehouseId'] = operations_insights_warehouse_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getOperationsInsightsWarehouse:getOperationsInsightsWarehouse', __args__, opts=opts, typ=GetOperationsInsightsWarehouseResult).value

    return AwaitableGetOperationsInsightsWarehouseResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        cpu_allocated=pulumi.get(__ret__, 'cpu_allocated'),
        cpu_used=pulumi.get(__ret__, 'cpu_used'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dynamic_group_id=pulumi.get(__ret__, 'dynamic_group_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        operations_insights_tenancy_id=pulumi.get(__ret__, 'operations_insights_tenancy_id'),
        operations_insights_warehouse_id=pulumi.get(__ret__, 'operations_insights_warehouse_id'),
        state=pulumi.get(__ret__, 'state'),
        storage_allocated_in_gbs=pulumi.get(__ret__, 'storage_allocated_in_gbs'),
        storage_used_in_gbs=pulumi.get(__ret__, 'storage_used_in_gbs'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_wallet_rotated=pulumi.get(__ret__, 'time_last_wallet_rotated'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_operations_insights_warehouse)
def get_operations_insights_warehouse_output(operations_insights_warehouse_id: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOperationsInsightsWarehouseResult]:
    """
    This data source provides details about a specific Operations Insights Warehouse resource in Oracle Cloud Infrastructure Opsi service.

    Gets details of an Operations Insights Warehouse.
    There is only expected to be 1 warehouse per tenant. The warehouse is expected to be in the root compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_operations_insights_warehouse = oci.Opsi.get_operations_insights_warehouse(operations_insights_warehouse_id=oci_opsi_operations_insights_warehouse["test_operations_insights_warehouse"]["id"])
    ```


    :param str operations_insights_warehouse_id: Unique Operations Insights Warehouse identifier
    """
    ...
