# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetBillingScheduleBillingScheduleResult',
    'GetBillingScheduleBillingScheduleProductResult',
    'GetBillingScheduleFilterResult',
]

@pulumi.output_type
class GetBillingScheduleBillingScheduleResult(dict):
    def __init__(__self__, *,
                 amount: str,
                 ar_customer_transaction_id: str,
                 ar_invoice_number: str,
                 billing_frequency: str,
                 invoice_status: str,
                 net_unit_price: str,
                 order_number: str,
                 products: Sequence['outputs.GetBillingScheduleBillingScheduleProductResult'],
                 quantity: str,
                 time_end: str,
                 time_invoicing: str,
                 time_start: str):
        """
        :param str amount: Billing schedule line net amount
        :param str ar_customer_transaction_id: Indicates the associated AR Customer transaction id a unique identifier existing on AR.
        :param str ar_invoice_number: Indicates the associated AR Invoice Number
        :param str billing_frequency: Billing frequency
        :param str invoice_status: Billing schedule invoice status
        :param str net_unit_price: Billing schedule net unit price
        :param str order_number: Order number associated with the Subscribed Service
        :param Sequence['GetBillingScheduleBillingScheduleProductArgs'] products: Product description
        :param str quantity: Billing schedule quantity
        :param str time_end: Billing schedule end date
        :param str time_invoicing: Billing schedule invoicing date
        :param str time_start: Billing schedule start date
        """
        GetBillingScheduleBillingScheduleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            amount=amount,
            ar_customer_transaction_id=ar_customer_transaction_id,
            ar_invoice_number=ar_invoice_number,
            billing_frequency=billing_frequency,
            invoice_status=invoice_status,
            net_unit_price=net_unit_price,
            order_number=order_number,
            products=products,
            quantity=quantity,
            time_end=time_end,
            time_invoicing=time_invoicing,
            time_start=time_start,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             amount: str,
             ar_customer_transaction_id: str,
             ar_invoice_number: str,
             billing_frequency: str,
             invoice_status: str,
             net_unit_price: str,
             order_number: str,
             products: Sequence['outputs.GetBillingScheduleBillingScheduleProductResult'],
             quantity: str,
             time_end: str,
             time_invoicing: str,
             time_start: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'arCustomerTransactionId' in kwargs:
            ar_customer_transaction_id = kwargs['arCustomerTransactionId']
        if 'arInvoiceNumber' in kwargs:
            ar_invoice_number = kwargs['arInvoiceNumber']
        if 'billingFrequency' in kwargs:
            billing_frequency = kwargs['billingFrequency']
        if 'invoiceStatus' in kwargs:
            invoice_status = kwargs['invoiceStatus']
        if 'netUnitPrice' in kwargs:
            net_unit_price = kwargs['netUnitPrice']
        if 'orderNumber' in kwargs:
            order_number = kwargs['orderNumber']
        if 'timeEnd' in kwargs:
            time_end = kwargs['timeEnd']
        if 'timeInvoicing' in kwargs:
            time_invoicing = kwargs['timeInvoicing']
        if 'timeStart' in kwargs:
            time_start = kwargs['timeStart']

        _setter("amount", amount)
        _setter("ar_customer_transaction_id", ar_customer_transaction_id)
        _setter("ar_invoice_number", ar_invoice_number)
        _setter("billing_frequency", billing_frequency)
        _setter("invoice_status", invoice_status)
        _setter("net_unit_price", net_unit_price)
        _setter("order_number", order_number)
        _setter("products", products)
        _setter("quantity", quantity)
        _setter("time_end", time_end)
        _setter("time_invoicing", time_invoicing)
        _setter("time_start", time_start)

    @property
    @pulumi.getter
    def amount(self) -> str:
        """
        Billing schedule line net amount
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter(name="arCustomerTransactionId")
    def ar_customer_transaction_id(self) -> str:
        """
        Indicates the associated AR Customer transaction id a unique identifier existing on AR.
        """
        return pulumi.get(self, "ar_customer_transaction_id")

    @property
    @pulumi.getter(name="arInvoiceNumber")
    def ar_invoice_number(self) -> str:
        """
        Indicates the associated AR Invoice Number
        """
        return pulumi.get(self, "ar_invoice_number")

    @property
    @pulumi.getter(name="billingFrequency")
    def billing_frequency(self) -> str:
        """
        Billing frequency
        """
        return pulumi.get(self, "billing_frequency")

    @property
    @pulumi.getter(name="invoiceStatus")
    def invoice_status(self) -> str:
        """
        Billing schedule invoice status
        """
        return pulumi.get(self, "invoice_status")

    @property
    @pulumi.getter(name="netUnitPrice")
    def net_unit_price(self) -> str:
        """
        Billing schedule net unit price
        """
        return pulumi.get(self, "net_unit_price")

    @property
    @pulumi.getter(name="orderNumber")
    def order_number(self) -> str:
        """
        Order number associated with the Subscribed Service
        """
        return pulumi.get(self, "order_number")

    @property
    @pulumi.getter
    def products(self) -> Sequence['outputs.GetBillingScheduleBillingScheduleProductResult']:
        """
        Product description
        """
        return pulumi.get(self, "products")

    @property
    @pulumi.getter
    def quantity(self) -> str:
        """
        Billing schedule quantity
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> str:
        """
        Billing schedule end date
        """
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeInvoicing")
    def time_invoicing(self) -> str:
        """
        Billing schedule invoicing date
        """
        return pulumi.get(self, "time_invoicing")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> str:
        """
        Billing schedule start date
        """
        return pulumi.get(self, "time_start")


@pulumi.output_type
class GetBillingScheduleBillingScheduleProductResult(dict):
    def __init__(__self__, *,
                 name: str,
                 part_number: str):
        """
        :param str name: Product name
        :param str part_number: Indicates the associated AR Invoice Number
        """
        GetBillingScheduleBillingScheduleProductResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            part_number=part_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             part_number: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'partNumber' in kwargs:
            part_number = kwargs['partNumber']

        _setter("name", name)
        _setter("part_number", part_number)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Product name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="partNumber")
    def part_number(self) -> str:
        """
        Indicates the associated AR Invoice Number
        """
        return pulumi.get(self, "part_number")


@pulumi.output_type
class GetBillingScheduleFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Product name
        """
        GetBillingScheduleFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Product name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


