# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ProtectedDatabaseMetric',
    'ProtectedDatabaseRecoveryServiceSubnet',
    'GetProtectedDatabaseMetricResult',
    'GetProtectedDatabaseRecoveryServiceSubnetResult',
    'GetProtectedDatabasesFilterResult',
    'GetProtectedDatabasesProtectedDatabaseCollectionResult',
    'GetProtectedDatabasesProtectedDatabaseCollectionItemResult',
    'GetProtectedDatabasesProtectedDatabaseCollectionItemMetricResult',
    'GetProtectedDatabasesProtectedDatabaseCollectionItemRecoveryServiceSubnetResult',
    'GetProtectionPoliciesFilterResult',
    'GetProtectionPoliciesProtectionPolicyCollectionResult',
    'GetProtectionPoliciesProtectionPolicyCollectionItemResult',
    'GetRecoveryServiceSubnetsFilterResult',
    'GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionResult',
    'GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionItemResult',
]

@pulumi.output_type
class ProtectedDatabaseMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupSpaceEstimateInGbs":
            suggest = "backup_space_estimate_in_gbs"
        elif key == "backupSpaceUsedInGbs":
            suggest = "backup_space_used_in_gbs"
        elif key == "currentRetentionPeriodInSeconds":
            suggest = "current_retention_period_in_seconds"
        elif key == "dbSizeInGbs":
            suggest = "db_size_in_gbs"
        elif key == "isRedoLogsEnabled":
            suggest = "is_redo_logs_enabled"
        elif key == "retentionPeriodInDays":
            suggest = "retention_period_in_days"
        elif key == "unprotectedWindowInSeconds":
            suggest = "unprotected_window_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProtectedDatabaseMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProtectedDatabaseMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProtectedDatabaseMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_space_estimate_in_gbs: Optional[float] = None,
                 backup_space_used_in_gbs: Optional[float] = None,
                 current_retention_period_in_seconds: Optional[float] = None,
                 db_size_in_gbs: Optional[float] = None,
                 is_redo_logs_enabled: Optional[bool] = None,
                 retention_period_in_days: Optional[float] = None,
                 unprotected_window_in_seconds: Optional[float] = None):
        """
        :param float backup_space_estimate_in_gbs: The estimated backup storage space, in gigabytes, required to meet the recovery window goal, including foot print and backups for the protected database.
        :param float backup_space_used_in_gbs: Backup storage space, in gigabytes, utilized by the protected database. Oracle charges for the total storage used.
        :param float current_retention_period_in_seconds: Number of seconds backups are currently retained for this database.
        :param float db_size_in_gbs: The estimated space, in gigabytes, consumed by the protected database. The database size is based on the size of the data files in the catalog, and does not include archive logs.
        :param bool is_redo_logs_enabled: The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        :param float retention_period_in_days: The maximum number of days to retain backups for a protected database.
        :param float unprotected_window_in_seconds: This is the time window when there is data loss exposure. The point after which recovery is impossible unless additional redo is available.  This is the time we received the last backup or last redo-log shipped.
        """
        ProtectedDatabaseMetric._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            backup_space_estimate_in_gbs=backup_space_estimate_in_gbs,
            backup_space_used_in_gbs=backup_space_used_in_gbs,
            current_retention_period_in_seconds=current_retention_period_in_seconds,
            db_size_in_gbs=db_size_in_gbs,
            is_redo_logs_enabled=is_redo_logs_enabled,
            retention_period_in_days=retention_period_in_days,
            unprotected_window_in_seconds=unprotected_window_in_seconds,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             backup_space_estimate_in_gbs: Optional[float] = None,
             backup_space_used_in_gbs: Optional[float] = None,
             current_retention_period_in_seconds: Optional[float] = None,
             db_size_in_gbs: Optional[float] = None,
             is_redo_logs_enabled: Optional[bool] = None,
             retention_period_in_days: Optional[float] = None,
             unprotected_window_in_seconds: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'backupSpaceEstimateInGbs' in kwargs:
            backup_space_estimate_in_gbs = kwargs['backupSpaceEstimateInGbs']
        if 'backupSpaceUsedInGbs' in kwargs:
            backup_space_used_in_gbs = kwargs['backupSpaceUsedInGbs']
        if 'currentRetentionPeriodInSeconds' in kwargs:
            current_retention_period_in_seconds = kwargs['currentRetentionPeriodInSeconds']
        if 'dbSizeInGbs' in kwargs:
            db_size_in_gbs = kwargs['dbSizeInGbs']
        if 'isRedoLogsEnabled' in kwargs:
            is_redo_logs_enabled = kwargs['isRedoLogsEnabled']
        if 'retentionPeriodInDays' in kwargs:
            retention_period_in_days = kwargs['retentionPeriodInDays']
        if 'unprotectedWindowInSeconds' in kwargs:
            unprotected_window_in_seconds = kwargs['unprotectedWindowInSeconds']

        if backup_space_estimate_in_gbs is not None:
            _setter("backup_space_estimate_in_gbs", backup_space_estimate_in_gbs)
        if backup_space_used_in_gbs is not None:
            _setter("backup_space_used_in_gbs", backup_space_used_in_gbs)
        if current_retention_period_in_seconds is not None:
            _setter("current_retention_period_in_seconds", current_retention_period_in_seconds)
        if db_size_in_gbs is not None:
            _setter("db_size_in_gbs", db_size_in_gbs)
        if is_redo_logs_enabled is not None:
            _setter("is_redo_logs_enabled", is_redo_logs_enabled)
        if retention_period_in_days is not None:
            _setter("retention_period_in_days", retention_period_in_days)
        if unprotected_window_in_seconds is not None:
            _setter("unprotected_window_in_seconds", unprotected_window_in_seconds)

    @property
    @pulumi.getter(name="backupSpaceEstimateInGbs")
    def backup_space_estimate_in_gbs(self) -> Optional[float]:
        """
        The estimated backup storage space, in gigabytes, required to meet the recovery window goal, including foot print and backups for the protected database.
        """
        return pulumi.get(self, "backup_space_estimate_in_gbs")

    @property
    @pulumi.getter(name="backupSpaceUsedInGbs")
    def backup_space_used_in_gbs(self) -> Optional[float]:
        """
        Backup storage space, in gigabytes, utilized by the protected database. Oracle charges for the total storage used.
        """
        return pulumi.get(self, "backup_space_used_in_gbs")

    @property
    @pulumi.getter(name="currentRetentionPeriodInSeconds")
    def current_retention_period_in_seconds(self) -> Optional[float]:
        """
        Number of seconds backups are currently retained for this database.
        """
        return pulumi.get(self, "current_retention_period_in_seconds")

    @property
    @pulumi.getter(name="dbSizeInGbs")
    def db_size_in_gbs(self) -> Optional[float]:
        """
        The estimated space, in gigabytes, consumed by the protected database. The database size is based on the size of the data files in the catalog, and does not include archive logs.
        """
        return pulumi.get(self, "db_size_in_gbs")

    @property
    @pulumi.getter(name="isRedoLogsEnabled")
    def is_redo_logs_enabled(self) -> Optional[bool]:
        """
        The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        """
        return pulumi.get(self, "is_redo_logs_enabled")

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> Optional[float]:
        """
        The maximum number of days to retain backups for a protected database.
        """
        return pulumi.get(self, "retention_period_in_days")

    @property
    @pulumi.getter(name="unprotectedWindowInSeconds")
    def unprotected_window_in_seconds(self) -> Optional[float]:
        """
        This is the time window when there is data loss exposure. The point after which recovery is impossible unless additional redo is available.  This is the time we received the last backup or last redo-log shipped.
        """
        return pulumi.get(self, "unprotected_window_in_seconds")


@pulumi.output_type
class ProtectedDatabaseRecoveryServiceSubnet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recoveryServiceSubnetId":
            suggest = "recovery_service_subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProtectedDatabaseRecoveryServiceSubnet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProtectedDatabaseRecoveryServiceSubnet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProtectedDatabaseRecoveryServiceSubnet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recovery_service_subnet_id: str,
                 state: Optional[str] = None):
        """
        :param str recovery_service_subnet_id: (Updatable) The recovery service subnet OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param str state: The current state of the Protected Database.
        """
        ProtectedDatabaseRecoveryServiceSubnet._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            recovery_service_subnet_id=recovery_service_subnet_id,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             recovery_service_subnet_id: str,
             state: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'recoveryServiceSubnetId' in kwargs:
            recovery_service_subnet_id = kwargs['recoveryServiceSubnetId']

        _setter("recovery_service_subnet_id", recovery_service_subnet_id)
        if state is not None:
            _setter("state", state)

    @property
    @pulumi.getter(name="recoveryServiceSubnetId")
    def recovery_service_subnet_id(self) -> str:
        """
        (Updatable) The recovery service subnet OCID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "recovery_service_subnet_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Protected Database.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetProtectedDatabaseMetricResult(dict):
    def __init__(__self__, *,
                 backup_space_estimate_in_gbs: float,
                 backup_space_used_in_gbs: float,
                 current_retention_period_in_seconds: float,
                 db_size_in_gbs: float,
                 is_redo_logs_enabled: bool,
                 retention_period_in_days: float,
                 unprotected_window_in_seconds: float):
        """
        :param float backup_space_estimate_in_gbs: The estimated backup storage space, in gigabytes, required to meet the recovery window goal, including foot print and backups for the protected database.
        :param float backup_space_used_in_gbs: Backup storage space, in gigabytes, utilized by the protected database. Oracle charges for the total storage used.
        :param float current_retention_period_in_seconds: Number of seconds backups are currently retained for this database.
        :param float db_size_in_gbs: The estimated space, in gigabytes, consumed by the protected database. The database size is based on the size of the data files in the catalog, and does not include archive logs.
        :param bool is_redo_logs_enabled: The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        :param float retention_period_in_days: The maximum number of days to retain backups for a protected database.
        :param float unprotected_window_in_seconds: This is the time window when there is data loss exposure. The point after which recovery is impossible unless additional redo is available.  This is the time we received the last backup or last redo-log shipped.
        """
        GetProtectedDatabaseMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            backup_space_estimate_in_gbs=backup_space_estimate_in_gbs,
            backup_space_used_in_gbs=backup_space_used_in_gbs,
            current_retention_period_in_seconds=current_retention_period_in_seconds,
            db_size_in_gbs=db_size_in_gbs,
            is_redo_logs_enabled=is_redo_logs_enabled,
            retention_period_in_days=retention_period_in_days,
            unprotected_window_in_seconds=unprotected_window_in_seconds,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             backup_space_estimate_in_gbs: float,
             backup_space_used_in_gbs: float,
             current_retention_period_in_seconds: float,
             db_size_in_gbs: float,
             is_redo_logs_enabled: bool,
             retention_period_in_days: float,
             unprotected_window_in_seconds: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'backupSpaceEstimateInGbs' in kwargs:
            backup_space_estimate_in_gbs = kwargs['backupSpaceEstimateInGbs']
        if 'backupSpaceUsedInGbs' in kwargs:
            backup_space_used_in_gbs = kwargs['backupSpaceUsedInGbs']
        if 'currentRetentionPeriodInSeconds' in kwargs:
            current_retention_period_in_seconds = kwargs['currentRetentionPeriodInSeconds']
        if 'dbSizeInGbs' in kwargs:
            db_size_in_gbs = kwargs['dbSizeInGbs']
        if 'isRedoLogsEnabled' in kwargs:
            is_redo_logs_enabled = kwargs['isRedoLogsEnabled']
        if 'retentionPeriodInDays' in kwargs:
            retention_period_in_days = kwargs['retentionPeriodInDays']
        if 'unprotectedWindowInSeconds' in kwargs:
            unprotected_window_in_seconds = kwargs['unprotectedWindowInSeconds']

        _setter("backup_space_estimate_in_gbs", backup_space_estimate_in_gbs)
        _setter("backup_space_used_in_gbs", backup_space_used_in_gbs)
        _setter("current_retention_period_in_seconds", current_retention_period_in_seconds)
        _setter("db_size_in_gbs", db_size_in_gbs)
        _setter("is_redo_logs_enabled", is_redo_logs_enabled)
        _setter("retention_period_in_days", retention_period_in_days)
        _setter("unprotected_window_in_seconds", unprotected_window_in_seconds)

    @property
    @pulumi.getter(name="backupSpaceEstimateInGbs")
    def backup_space_estimate_in_gbs(self) -> float:
        """
        The estimated backup storage space, in gigabytes, required to meet the recovery window goal, including foot print and backups for the protected database.
        """
        return pulumi.get(self, "backup_space_estimate_in_gbs")

    @property
    @pulumi.getter(name="backupSpaceUsedInGbs")
    def backup_space_used_in_gbs(self) -> float:
        """
        Backup storage space, in gigabytes, utilized by the protected database. Oracle charges for the total storage used.
        """
        return pulumi.get(self, "backup_space_used_in_gbs")

    @property
    @pulumi.getter(name="currentRetentionPeriodInSeconds")
    def current_retention_period_in_seconds(self) -> float:
        """
        Number of seconds backups are currently retained for this database.
        """
        return pulumi.get(self, "current_retention_period_in_seconds")

    @property
    @pulumi.getter(name="dbSizeInGbs")
    def db_size_in_gbs(self) -> float:
        """
        The estimated space, in gigabytes, consumed by the protected database. The database size is based on the size of the data files in the catalog, and does not include archive logs.
        """
        return pulumi.get(self, "db_size_in_gbs")

    @property
    @pulumi.getter(name="isRedoLogsEnabled")
    def is_redo_logs_enabled(self) -> bool:
        """
        The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        """
        return pulumi.get(self, "is_redo_logs_enabled")

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> float:
        """
        The maximum number of days to retain backups for a protected database.
        """
        return pulumi.get(self, "retention_period_in_days")

    @property
    @pulumi.getter(name="unprotectedWindowInSeconds")
    def unprotected_window_in_seconds(self) -> float:
        """
        This is the time window when there is data loss exposure. The point after which recovery is impossible unless additional redo is available.  This is the time we received the last backup or last redo-log shipped.
        """
        return pulumi.get(self, "unprotected_window_in_seconds")


@pulumi.output_type
class GetProtectedDatabaseRecoveryServiceSubnetResult(dict):
    def __init__(__self__, *,
                 recovery_service_subnet_id: str,
                 state: str):
        """
        :param str recovery_service_subnet_id: Recovery Service Subnet Identifier.
        :param str state: The current state of the Protected Database.
        """
        GetProtectedDatabaseRecoveryServiceSubnetResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            recovery_service_subnet_id=recovery_service_subnet_id,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             recovery_service_subnet_id: str,
             state: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'recoveryServiceSubnetId' in kwargs:
            recovery_service_subnet_id = kwargs['recoveryServiceSubnetId']

        _setter("recovery_service_subnet_id", recovery_service_subnet_id)
        _setter("state", state)

    @property
    @pulumi.getter(name="recoveryServiceSubnetId")
    def recovery_service_subnet_id(self) -> str:
        """
        Recovery Service Subnet Identifier.
        """
        return pulumi.get(self, "recovery_service_subnet_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Protected Database.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetProtectedDatabasesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetProtectedDatabasesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProtectedDatabasesProtectedDatabaseCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionItemResult']):
        GetProtectedDatabasesProtectedDatabaseCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProtectedDatabasesProtectedDatabaseCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 database_id: str,
                 database_size: str,
                 db_unique_name: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 health: str,
                 health_details: str,
                 id: str,
                 is_read_only_resource: bool,
                 is_redo_logs_shipped: bool,
                 lifecycle_details: str,
                 metrics: Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionItemMetricResult'],
                 password: str,
                 protection_policy_id: str,
                 recovery_service_subnets: Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionItemRecoveryServiceSubnetResult'],
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str,
                 vpc_user_name: str):
        """
        :param str compartment_id: The compartment OCID.
        :param str database_id: The OCID of the protected database.
        :param str database_size: The size of the protected database. XS - Less than 5GB, S - 5GB to 50GB, M - 50GB to 500GB, L - 500GB to 1TB, XL - 1TB to 5TB, XXL - Greater than 5TB.
        :param str db_unique_name: The dbUniqueName for the protected database in Recovery Service. You cannot change the unique name.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param str display_name: A filter to return only resources that match the entire 'displayname' given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str health: Indicates the protection status of the database. Allowed values are:
               * HEALTHY
               * WARNING
               * ALERT
        :param str health_details: A message describing the current health of the protected database.
        :param str id: The protected database OCID.
        :param bool is_read_only_resource: Indicates whether the protected database is created by Recovery Service or created manually. Set to <b>TRUE</b> for a service-defined protected database. When you enable the OCI-managed automatic backups option for a database and set Recovery Service as the backup destination, then Recovery Service creates the associated protected database resource. Set to <b>FALSE</b> for a user-defined protected database.
        :param bool is_redo_logs_shipped: The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups. For this to be effective, additional configuration is needed on client side.
        :param str lifecycle_details: Detailed description about the current lifecycle state of the protected database. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param Sequence['GetProtectedDatabasesProtectedDatabaseCollectionItemMetricArgs'] metrics: Backup performance and storage utilization metrics for the protected database.
        :param str protection_policy_id: The protection policy OCID.
        :param Sequence['GetProtectedDatabasesProtectedDatabaseCollectionItemRecoveryServiceSubnetArgs'] recovery_service_subnets: List of recovery service subnet resources associated with the protected database.
        :param str state: A filter to return only the resources that match the specified lifecycle state.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param str time_created: An RFC3339 formatted datetime string that indicates the created time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        :param str time_updated: An RFC3339 formatted datetime string that indicates the last updated time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        :param str vpc_user_name: The virtual private catalog (VPC) user credentials that authenticates the protected database to access Recovery Service.
        """
        GetProtectedDatabasesProtectedDatabaseCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            database_id=database_id,
            database_size=database_size,
            db_unique_name=db_unique_name,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            health=health,
            health_details=health_details,
            id=id,
            is_read_only_resource=is_read_only_resource,
            is_redo_logs_shipped=is_redo_logs_shipped,
            lifecycle_details=lifecycle_details,
            metrics=metrics,
            password=password,
            protection_policy_id=protection_policy_id,
            recovery_service_subnets=recovery_service_subnets,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
            vpc_user_name=vpc_user_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             database_id: str,
             database_size: str,
             db_unique_name: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             health: str,
             health_details: str,
             id: str,
             is_read_only_resource: bool,
             is_redo_logs_shipped: bool,
             lifecycle_details: str,
             metrics: Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionItemMetricResult'],
             password: str,
             protection_policy_id: str,
             recovery_service_subnets: Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionItemRecoveryServiceSubnetResult'],
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             vpc_user_name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'databaseId' in kwargs:
            database_id = kwargs['databaseId']
        if 'databaseSize' in kwargs:
            database_size = kwargs['databaseSize']
        if 'dbUniqueName' in kwargs:
            db_unique_name = kwargs['dbUniqueName']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'healthDetails' in kwargs:
            health_details = kwargs['healthDetails']
        if 'isReadOnlyResource' in kwargs:
            is_read_only_resource = kwargs['isReadOnlyResource']
        if 'isRedoLogsShipped' in kwargs:
            is_redo_logs_shipped = kwargs['isRedoLogsShipped']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'protectionPolicyId' in kwargs:
            protection_policy_id = kwargs['protectionPolicyId']
        if 'recoveryServiceSubnets' in kwargs:
            recovery_service_subnets = kwargs['recoveryServiceSubnets']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'vpcUserName' in kwargs:
            vpc_user_name = kwargs['vpcUserName']

        _setter("compartment_id", compartment_id)
        _setter("database_id", database_id)
        _setter("database_size", database_size)
        _setter("db_unique_name", db_unique_name)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("health", health)
        _setter("health_details", health_details)
        _setter("id", id)
        _setter("is_read_only_resource", is_read_only_resource)
        _setter("is_redo_logs_shipped", is_redo_logs_shipped)
        _setter("lifecycle_details", lifecycle_details)
        _setter("metrics", metrics)
        _setter("password", password)
        _setter("protection_policy_id", protection_policy_id)
        _setter("recovery_service_subnets", recovery_service_subnets)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("vpc_user_name", vpc_user_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> str:
        """
        The OCID of the protected database.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseSize")
    def database_size(self) -> str:
        """
        The size of the protected database. XS - Less than 5GB, S - 5GB to 50GB, M - 50GB to 500GB, L - 500GB to 1TB, XL - 1TB to 5TB, XXL - Greater than 5TB.
        """
        return pulumi.get(self, "database_size")

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> str:
        """
        The dbUniqueName for the protected database in Recovery Service. You cannot change the unique name.
        """
        return pulumi.get(self, "db_unique_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire 'displayname' given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        Indicates the protection status of the database. Allowed values are:
        * HEALTHY
        * WARNING
        * ALERT
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthDetails")
    def health_details(self) -> str:
        """
        A message describing the current health of the protected database.
        """
        return pulumi.get(self, "health_details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The protected database OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isReadOnlyResource")
    def is_read_only_resource(self) -> bool:
        """
        Indicates whether the protected database is created by Recovery Service or created manually. Set to <b>TRUE</b> for a service-defined protected database. When you enable the OCI-managed automatic backups option for a database and set Recovery Service as the backup destination, then Recovery Service creates the associated protected database resource. Set to <b>FALSE</b> for a user-defined protected database.
        """
        return pulumi.get(self, "is_read_only_resource")

    @property
    @pulumi.getter(name="isRedoLogsShipped")
    def is_redo_logs_shipped(self) -> bool:
        """
        The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups. For this to be effective, additional configuration is needed on client side.
        """
        return pulumi.get(self, "is_redo_logs_shipped")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Detailed description about the current lifecycle state of the protected database. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionItemMetricResult']:
        """
        Backup performance and storage utilization metrics for the protected database.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="protectionPolicyId")
    def protection_policy_id(self) -> str:
        """
        The protection policy OCID.
        """
        return pulumi.get(self, "protection_policy_id")

    @property
    @pulumi.getter(name="recoveryServiceSubnets")
    def recovery_service_subnets(self) -> Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionItemRecoveryServiceSubnetResult']:
        """
        List of recovery service subnet resources associated with the protected database.
        """
        return pulumi.get(self, "recovery_service_subnets")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only the resources that match the specified lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        An RFC3339 formatted datetime string that indicates the created time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        An RFC3339 formatted datetime string that indicates the last updated time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="vpcUserName")
    def vpc_user_name(self) -> str:
        """
        The virtual private catalog (VPC) user credentials that authenticates the protected database to access Recovery Service.
        """
        return pulumi.get(self, "vpc_user_name")


@pulumi.output_type
class GetProtectedDatabasesProtectedDatabaseCollectionItemMetricResult(dict):
    def __init__(__self__, *,
                 backup_space_estimate_in_gbs: float,
                 backup_space_used_in_gbs: float,
                 current_retention_period_in_seconds: float,
                 db_size_in_gbs: float,
                 is_redo_logs_enabled: bool,
                 retention_period_in_days: float,
                 unprotected_window_in_seconds: float):
        """
        :param float backup_space_estimate_in_gbs: The estimated backup storage space, in gigabytes, required to meet the recovery window goal, including foot print and backups for the protected database.
        :param float backup_space_used_in_gbs: Backup storage space, in gigabytes, utilized by the protected database. Oracle charges for the total storage used.
        :param float current_retention_period_in_seconds: Number of seconds backups are currently retained for this database.
        :param float db_size_in_gbs: The estimated space, in gigabytes, consumed by the protected database. The database size is based on the size of the data files in the catalog, and does not include archive logs.
        :param bool is_redo_logs_enabled: The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        :param float retention_period_in_days: The maximum number of days to retain backups for a protected database.
        :param float unprotected_window_in_seconds: This is the time window when there is data loss exposure. The point after which recovery is impossible unless additional redo is available.  This is the time we received the last backup or last redo-log shipped.
        """
        GetProtectedDatabasesProtectedDatabaseCollectionItemMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            backup_space_estimate_in_gbs=backup_space_estimate_in_gbs,
            backup_space_used_in_gbs=backup_space_used_in_gbs,
            current_retention_period_in_seconds=current_retention_period_in_seconds,
            db_size_in_gbs=db_size_in_gbs,
            is_redo_logs_enabled=is_redo_logs_enabled,
            retention_period_in_days=retention_period_in_days,
            unprotected_window_in_seconds=unprotected_window_in_seconds,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             backup_space_estimate_in_gbs: float,
             backup_space_used_in_gbs: float,
             current_retention_period_in_seconds: float,
             db_size_in_gbs: float,
             is_redo_logs_enabled: bool,
             retention_period_in_days: float,
             unprotected_window_in_seconds: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'backupSpaceEstimateInGbs' in kwargs:
            backup_space_estimate_in_gbs = kwargs['backupSpaceEstimateInGbs']
        if 'backupSpaceUsedInGbs' in kwargs:
            backup_space_used_in_gbs = kwargs['backupSpaceUsedInGbs']
        if 'currentRetentionPeriodInSeconds' in kwargs:
            current_retention_period_in_seconds = kwargs['currentRetentionPeriodInSeconds']
        if 'dbSizeInGbs' in kwargs:
            db_size_in_gbs = kwargs['dbSizeInGbs']
        if 'isRedoLogsEnabled' in kwargs:
            is_redo_logs_enabled = kwargs['isRedoLogsEnabled']
        if 'retentionPeriodInDays' in kwargs:
            retention_period_in_days = kwargs['retentionPeriodInDays']
        if 'unprotectedWindowInSeconds' in kwargs:
            unprotected_window_in_seconds = kwargs['unprotectedWindowInSeconds']

        _setter("backup_space_estimate_in_gbs", backup_space_estimate_in_gbs)
        _setter("backup_space_used_in_gbs", backup_space_used_in_gbs)
        _setter("current_retention_period_in_seconds", current_retention_period_in_seconds)
        _setter("db_size_in_gbs", db_size_in_gbs)
        _setter("is_redo_logs_enabled", is_redo_logs_enabled)
        _setter("retention_period_in_days", retention_period_in_days)
        _setter("unprotected_window_in_seconds", unprotected_window_in_seconds)

    @property
    @pulumi.getter(name="backupSpaceEstimateInGbs")
    def backup_space_estimate_in_gbs(self) -> float:
        """
        The estimated backup storage space, in gigabytes, required to meet the recovery window goal, including foot print and backups for the protected database.
        """
        return pulumi.get(self, "backup_space_estimate_in_gbs")

    @property
    @pulumi.getter(name="backupSpaceUsedInGbs")
    def backup_space_used_in_gbs(self) -> float:
        """
        Backup storage space, in gigabytes, utilized by the protected database. Oracle charges for the total storage used.
        """
        return pulumi.get(self, "backup_space_used_in_gbs")

    @property
    @pulumi.getter(name="currentRetentionPeriodInSeconds")
    def current_retention_period_in_seconds(self) -> float:
        """
        Number of seconds backups are currently retained for this database.
        """
        return pulumi.get(self, "current_retention_period_in_seconds")

    @property
    @pulumi.getter(name="dbSizeInGbs")
    def db_size_in_gbs(self) -> float:
        """
        The estimated space, in gigabytes, consumed by the protected database. The database size is based on the size of the data files in the catalog, and does not include archive logs.
        """
        return pulumi.get(self, "db_size_in_gbs")

    @property
    @pulumi.getter(name="isRedoLogsEnabled")
    def is_redo_logs_enabled(self) -> bool:
        """
        The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        """
        return pulumi.get(self, "is_redo_logs_enabled")

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> float:
        """
        The maximum number of days to retain backups for a protected database.
        """
        return pulumi.get(self, "retention_period_in_days")

    @property
    @pulumi.getter(name="unprotectedWindowInSeconds")
    def unprotected_window_in_seconds(self) -> float:
        """
        This is the time window when there is data loss exposure. The point after which recovery is impossible unless additional redo is available.  This is the time we received the last backup or last redo-log shipped.
        """
        return pulumi.get(self, "unprotected_window_in_seconds")


@pulumi.output_type
class GetProtectedDatabasesProtectedDatabaseCollectionItemRecoveryServiceSubnetResult(dict):
    def __init__(__self__, *,
                 recovery_service_subnet_id: str,
                 state: str):
        """
        :param str recovery_service_subnet_id: The recovery service subnet OCID.
        :param str state: A filter to return only the resources that match the specified lifecycle state.
        """
        GetProtectedDatabasesProtectedDatabaseCollectionItemRecoveryServiceSubnetResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            recovery_service_subnet_id=recovery_service_subnet_id,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             recovery_service_subnet_id: str,
             state: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'recoveryServiceSubnetId' in kwargs:
            recovery_service_subnet_id = kwargs['recoveryServiceSubnetId']

        _setter("recovery_service_subnet_id", recovery_service_subnet_id)
        _setter("state", state)

    @property
    @pulumi.getter(name="recoveryServiceSubnetId")
    def recovery_service_subnet_id(self) -> str:
        """
        The recovery service subnet OCID.
        """
        return pulumi.get(self, "recovery_service_subnet_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only the resources that match the specified lifecycle state.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetProtectionPoliciesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetProtectionPoliciesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProtectionPoliciesProtectionPolicyCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProtectionPoliciesProtectionPolicyCollectionItemResult']):
        GetProtectionPoliciesProtectionPolicyCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetProtectionPoliciesProtectionPolicyCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProtectionPoliciesProtectionPolicyCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProtectionPoliciesProtectionPolicyCollectionItemResult(dict):
    def __init__(__self__, *,
                 backup_retention_period_in_days: int,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_predefined_policy: bool,
                 lifecycle_details: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param int backup_retention_period_in_days: The maximum number of days to retain backups for a protected database. Specify a period ranging from a minimum 14 days to a maximum 95 days. For example, specify the value 55 if you want to retain backups for 55 days.
        :param str compartment_id: The compartment OCID.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param str display_name: A filter to return only resources that match the entire 'displayname' given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The protection policy OCID.
        :param bool is_predefined_policy: Set to TRUE if the policy is Oracle-defined, and FALSE for a user-defined custom policy. You can modify only the custom policies.
        :param str lifecycle_details: Detailed description about the current lifecycle state of the protection policy. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param str time_created: An RFC3339 formatted datetime string that indicates the created time for the protection policy. For example: '2020-05-22T21:10:29.600Z'.
        :param str time_updated: An RFC3339 formatted datetime string that indicates the updated time for the protection policy. For example: '2020-05-22T21:10:29.600Z'.
        """
        GetProtectionPoliciesProtectionPolicyCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            backup_retention_period_in_days=backup_retention_period_in_days,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            is_predefined_policy=is_predefined_policy,
            lifecycle_details=lifecycle_details,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             backup_retention_period_in_days: int,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_predefined_policy: bool,
             lifecycle_details: str,
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'backupRetentionPeriodInDays' in kwargs:
            backup_retention_period_in_days = kwargs['backupRetentionPeriodInDays']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isPredefinedPolicy' in kwargs:
            is_predefined_policy = kwargs['isPredefinedPolicy']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("backup_retention_period_in_days", backup_retention_period_in_days)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_predefined_policy", is_predefined_policy)
        _setter("lifecycle_details", lifecycle_details)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="backupRetentionPeriodInDays")
    def backup_retention_period_in_days(self) -> int:
        """
        The maximum number of days to retain backups for a protected database. Specify a period ranging from a minimum 14 days to a maximum 95 days. For example, specify the value 55 if you want to retain backups for 55 days.
        """
        return pulumi.get(self, "backup_retention_period_in_days")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire 'displayname' given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The protection policy OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isPredefinedPolicy")
    def is_predefined_policy(self) -> bool:
        """
        Set to TRUE if the policy is Oracle-defined, and FALSE for a user-defined custom policy. You can modify only the custom policies.
        """
        return pulumi.get(self, "is_predefined_policy")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Detailed description about the current lifecycle state of the protection policy. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        An RFC3339 formatted datetime string that indicates the created time for the protection policy. For example: '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        An RFC3339 formatted datetime string that indicates the updated time for the protection policy. For example: '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetRecoveryServiceSubnetsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetRecoveryServiceSubnetsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionItemResult']):
        GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_details: str,
                 state: str,
                 subnet_id: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str,
                 vcn_id: str):
        """
        :param str compartment_id: The compartment OCID.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param str display_name: A filter to return only resources that match the entire 'displayname' given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The recovery service subnet OCID.
        :param str lifecycle_details: Detailed description about the current lifecycle state of the recovery service subnet. For example, it can be used to provide actionable information for a resource in a Failed state
        :param str state: A filter to return only the resources that match the specified lifecycle state. Allowed values are:
               * CREATING
               * UPDATING
               * ACTIVE
               * DELETING
               * DELETED
               * FAILED
        :param str subnet_id: The OCID of the subnet used as the recovery service subnet.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param str time_created: An RFC3339 formatted datetime string that indicates the last created time for a recovery service subnet. For example: '2020-05-22T21:10:29.600Z'.
        :param str time_updated: An RFC3339 formatted datetime string that indicates the last updated time for a recovery service subnet. For example: '2020-05-22T21:10:29.600Z'.
        :param str vcn_id: The OCID of the virtual cloud network (VCN) associated with the recovery service subnet.
        """
        GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            lifecycle_details=lifecycle_details,
            state=state,
            subnet_id=subnet_id,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
            vcn_id=vcn_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             lifecycle_details: str,
             state: str,
             subnet_id: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             vcn_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'vcnId' in kwargs:
            vcn_id = kwargs['vcnId']

        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("lifecycle_details", lifecycle_details)
        _setter("state", state)
        _setter("subnet_id", subnet_id)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire 'displayname' given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The recovery service subnet OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Detailed description about the current lifecycle state of the recovery service subnet. For example, it can be used to provide actionable information for a resource in a Failed state
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only the resources that match the specified lifecycle state. Allowed values are:
        * CREATING
        * UPDATING
        * ACTIVE
        * DELETING
        * DELETED
        * FAILED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of the subnet used as the recovery service subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        An RFC3339 formatted datetime string that indicates the last created time for a recovery service subnet. For example: '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        An RFC3339 formatted datetime string that indicates the last updated time for a recovery service subnet. For example: '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        The OCID of the virtual cloud network (VCN) associated with the recovery service subnet.
        """
        return pulumi.get(self, "vcn_id")


